/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dbd.formplugin.user;

import java.util.EventObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.field.UserEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.orm.query.QFilter;
import kd.drp.mdr.common.f7.F7Utils;
import kd.drp.mdr.common.util.CustomerUtil;
import kd.drp.mdr.common.util.UserUtil;
import kd.drp.mdr.formplugin.MdrBasePlugin;

public class CustomerSalerEditPlugin
extends MdrBasePlugin
implements BeforeF7SelectListener {
    public static final String CUSTOMER = "customer";
    public static final String USER = "user";
    public static final String ISDEFAULT = "isdefault";
    public static final String OWNER = "owner";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addF7Listener(this, new String[]{USER, OWNER, CUSTOMER});
        UserEdit userEdit = (UserEdit)this.getControl(USER);
        if (userEdit != null) {
            userEdit.addBeforeF7SelectListener(new BeforeF7SelectListener(){

                public void beforeF7Select(BeforeF7SelectEvent evt) {
                    evt.getFormShowParameter().setCustomParam("externalUserType", (Object)"all");
                }
            });
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        if (!this.isFromImport()) {
            IPageCache pageCache;
            String ownerId;
            this.getModel().setValue(OWNER, UserUtil.getDefaultOwnerID());
            IFormView parentView = this.getView().getParentView();
            if (parentView != null && (ownerId = (pageCache = (IPageCache)parentView.getService(IPageCache.class)).get(parentView.getPageId() + "ownerId")) != null && !ownerId.toString().trim().equals("")) {
                this.setOwnerF7Value(ownerId);
            }
            this.getModel().setValue(CUSTOMER, null);
            this.getModel().setValue(USER, null);
            this.getModel().setValue(ISDEFAULT, (Object)false);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        switch (key = e.getProperty().getName()) {
            case "owner": {
                if (this.getF7PKValue(OWNER) == null) {
                    this.setValue(OWNER, UserUtil.getDefaultOwnerID());
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6388\u6743\u6e20\u9053\u4e0d\u80fd\u4e3a\u7a7a\uff01", (String)"CustomerSalerEditPlugin_0", (String)"drp-dbd-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.setValue(CUSTOMER, null);
                this.setValue(USER, null);
                this.getModel().setValue(ISDEFAULT, (Object)false);
                break;
            }
        }
    }

    private QFilter getCustomerFilter() {
        Object ownerId = this.getF7PKValue(OWNER);
        if (ownerId == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7ba1\u7406\u6e20\u9053", (String)"CustomerSalerEditPlugin_1", (String)"drp-dbd-formplugin", (Object[])new Object[0]));
        }
        return CustomerUtil.getAuthSubsIdsQFilter((Object)ownerId);
    }

    private QFilter getUserFilter() {
        Object ownerId = this.getF7PKValue(OWNER);
        if (ownerId == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6388\u6743\u6e20\u9053\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u9009\u62e9\u6388\u6743\u6e20\u9053\uff01", (String)"CustomerSalerEditPlugin_2", (String)"drp-dbd-formplugin", (Object[])new Object[0]));
        }
        QFilter filter = new QFilter("id", "in", (Object)UserUtil.getSalerIds((Object)ownerId));
        return filter;
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key;
        switch (key = e.getProperty().getName()) {
            case "customer": {
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)this.getCustomerFilter());
                break;
            }
            case "user": {
                this.setNoTreeF7(e);
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)this.getUserFilter());
                break;
            }
            case "owner": {
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)UserUtil.getAuthorizedCommonUserOwnersFilter());
            }
        }
    }
}

