/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dbd.formplugin.user;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.form.events.BeforeBuildTreeNodeEvent;
import kd.bos.list.BillList;
import kd.bos.list.ITreeListView;
import kd.bos.list.events.BuildTreeListFilterEvent;
import kd.bos.list.plugin.AbstractTreeListPlugin;
import kd.bos.mvc.list.TreeListModel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.drp.mdr.common.cache.CustomerTreeCache;
import kd.drp.mdr.common.cache.model.AuthCust;
import kd.drp.mdr.common.util.CustomerUtil;
import kd.drp.mdr.common.util.QueryUtil;
import kd.drp.mdr.common.util.UserUtil;

public class CustomerUserListPlugin
extends AbstractTreeListPlugin {
    public static final String BTN_NEW = "tblnew";
    public static final String BTN_EDIT = "btnedit";
    public static final String BTN_DEL = "tbldel";
    public static final String PNL_TREEBTNLIST = "flexpanel_treebtn";

    public void initialize() {
        TreeListModel treeModel;
        super.initialize();
        ITreeListView treeListView = this.getTreeListView();
        if (treeListView != null && (treeModel = (TreeListModel)treeListView.getTreeModel()) != null) {
            List treeFilter = treeModel.getTreeFilter();
            treeFilter.add(new QFilter("enable", "=", (Object)1));
            treeModel.setTreeFilter(treeFilter);
        }
    }

    public void beforeBuildTreeNode(BeforeBuildTreeNodeEvent e) {
        e.setCurrNodeId("dbd_customer");
        super.beforeBuildTreeNode(e);
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        if (BTN_NEW.equals(evt.getItemKey())) {
            try {
                TreeView tv = (TreeView)this.getControl("treeview");
                String focusNodeId = tv.getTreeState().getFocusNodeId();
                if ("8609760E-EF83-4775-A9FF-CCDEC7C0B689".equals(focusNodeId)) {
                    evt.setCancel(true);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5546\u52a1\u4f19\u4f34", (String)"CustomerUserListPlugin_0", (String)"drp-dbd-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (BTN_DEL.equals(evt.getItemKey())) {
            try {
                TreeView tv = (TreeView)this.getControl("treeview");
                String focusNodeId = tv.getTreeState().getFocusNodeId();
                QFilter adminFilter = new QFilter("isadmin", "=", (Object)true);
                QFilter bizpartnerFilter = new QFilter("bizpartner", "=", (Object)focusNodeId);
                QFilter[] qfilters = new QFilter[]{adminFilter, bizpartnerFilter};
                DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"bos_bizpartneruser", (String)"", (QFilter[])qfilters);
                BillList billList = (BillList)this.getControl("billlistap");
                ListSelectedRowCollection selectedRows = billList.getSelectedRows();
                Object[] values = selectedRows.getPrimaryKeyValues();
                Object pkValue = dynamicObject.getPkValue();
                for (Object object : values) {
                    if (!pkValue.equals(object)) continue;
                    evt.setCancel(true);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ba1\u7406\u5458\u7528\u6237\u4e0d\u80fd\u5220\u9664", (String)"CustomerUserListPlugin_1", (String)"drp-dbd-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                    break;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void initTreeToolbar(EventObject e) {
        super.initTreeToolbar(e);
        this.getView().setVisible(Boolean.valueOf(false), new String[]{PNL_TREEBTNLIST});
    }

    public void refreshNode(RefreshNodeEvent e) {
        super.refreshNode(e);
        TreeNode root = this.getTreeModel().getRoot();
        String currNodeId = (String)e.getNodeId();
        TreeNode currNode = root.getTreeNode(currNodeId, 10);
        if (currNode.getChildren() != null && !currNode.getChildren().isEmpty()) {
            e.setChildNodes(currNode.getChildren());
        } else if (this.isRootNode(currNodeId)) {
            e.setChildNodes(this.loadTreeNodes());
        } else {
            e.setChildNodes(null);
        }
    }

    private Set<Object> getCustomerIdByUser() {
        if (UserUtil.isPartnerUser()) {
            Long userId = Long.valueOf(UserUtil.getUserID().toString());
            QFilter fs = new QFilter("user", "=", (Object)userId);
            return QueryUtil.querySingleCol((String)"dbd_customer_user", (String)"dbd_customer", (QFilter[])fs.toArray());
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u9700\u6c42\u6682\u505c\uff0c\u8fd8\u6ca1\u5b9e\u73b0", (String)"CustomerUserListPlugin_2", (String)"drp-dbd-formplugin", (Object[])new Object[0]));
    }

    private void createChildNode(TreeNode node, Map<Object, List<TreeNode>> allNodeMap, Map<Object, List<AuthCust>> ownerMap) {
        Object id = node.getData();
        List<AuthCust> childs = ownerMap.get(id);
        if (childs == null) {
            return;
        }
        for (AuthCust authCust : childs) {
            if (!authCust.isValid()) continue;
            Object customerId = authCust.getCustomerId();
            TreeNode childNode = new TreeNode();
            childNode.setData(customerId);
            childNode.setId(customerId.toString());
            childNode.setParentid(node.getId());
            node.addChild(childNode);
            List nodeList = allNodeMap.computeIfAbsent(customerId, k -> new LinkedList());
            nodeList.add(childNode);
            this.createChildNode(childNode, allNodeMap, ownerMap);
        }
    }

    private boolean isRootNode(String nodeId) {
        return this.getTreeModel().getRoot().getId().equals(nodeId);
    }

    private List<TreeNode> loadTreeNodes() {
        HashMap<Object, List<TreeNode>> allNodeMap = new HashMap<Object, List<TreeNode>>();
        Set<Object> rootCustomerIds = this.getCustomerIdByUser();
        Map ownerMap = CustomerTreeCache.getCache().getAuthownerMap();
        ArrayList<TreeNode> nodes = new ArrayList<TreeNode>(rootCustomerIds.size());
        for (Object id : rootCustomerIds) {
            TreeNode node = new TreeNode();
            node.setId(id.toString());
            node.setParentid("0");
            node.setData(id);
            nodes.add(node);
            List nodeList = allNodeMap.computeIfAbsent(id, k -> new LinkedList());
            nodeList.add(node);
            this.createChildNode(node, allNodeMap, ownerMap);
        }
        this.loadCustomerNodeInfo(allNodeMap);
        return nodes;
    }

    private void loadCustomerNodeInfo(Map<Object, List<TreeNode>> allNodeMap) {
        Set<Object> ids = allNodeMap.keySet();
        String cols = "id, number, name";
        String orderby = "number asc";
        QFilter fs = new QFilter("id", "in", ids);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"mdr_customer", (String)"mdr_customer", (String)cols, (QFilter[])fs.toArray(), (String)orderby);){
            for (Row row : ds) {
                Long id = row.getLong("id");
                List<TreeNode> nodes = allNodeMap.get(id);
                String name = row.getString("name");
                for (TreeNode node : nodes) {
                    node.setText(name);
                }
            }
        }
    }

    public void buildTreeListFilter(BuildTreeListFilterEvent e) {
        super.buildTreeListFilter(e);
        QFilter filter = this.buildAppQFilter("dbd_customer", e.getNodeId().toString());
        e.addQFilter(filter);
        e.setCancel(true);
    }

    private QFilter buildAppQFilter(String appIdFldKey, String nodeId) {
        if (this.isRootNode(nodeId)) {
            Set<Object> rootCustomerIds = this.getCustomerIdByUser();
            HashSet allSubIds = new HashSet();
            for (Object id : rootCustomerIds) {
                allSubIds.addAll(CustomerUtil.getAllAuthSubIdsById((Object)id));
            }
            return new QFilter(appIdFldKey, "in", allSubIds);
        }
        Long id = Long.valueOf(nodeId);
        Set allSubIds = CustomerUtil.getAllAuthSubIdsById((Object)id);
        allSubIds.add(id);
        return new QFilter(appIdFldKey, "in", (Object)allSubIds);
    }
}

