/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dbd.formplugin.user;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.field.UserEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.drp.dbd.formplugin.user.pagehandler.UserPageHandler;
import kd.drp.mdr.common.f7.F7Utils;
import kd.drp.mdr.formplugin.MdrFormPlugin;
import org.apache.commons.lang3.StringUtils;

public class UserAddEdit
extends MdrFormPlugin
implements BeforeF7SelectListener {
    private static final String[] cols = new String[]{"sysuser", "owner", "isdefault", "isbuyer", "iscusorderprocessor", "isdispatcher", "isdptadmin", "issaler", "remark"};

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addF7Listener(this, new String[]{"owner"});
        this.addItemClickListeners(new String[]{"ops"});
        UserEdit userEdit = (UserEdit)this.getControl("sysuser");
        if (userEdit != null) {
            userEdit.addBeforeF7SelectListener(new BeforeF7SelectListener(){

                public void beforeF7Select(BeforeF7SelectEvent evt) {
                    evt.getFormShowParameter().setCustomParam("externalUserType", (Object)"all");
                }
            });
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "save": {
                this.beforeSave(evt);
                break;
            }
            case "saveandnew": {
                this.beforeSaveAndNew(evt);
                break;
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key;
        switch (key = e.getProperty().getName()) {
            case "owner": {
                this.beforeOwnerSelect(e);
                break;
            }
        }
    }

    private void beforeSaveAndNew(ItemClickEvent e) {
        boolean success = this.toSaveRows();
        if (success) {
            this.getModel().deleteEntryData("users");
            this.getModel().createNewEntryRow("users");
        }
    }

    private boolean toSaveRows() {
        List<DynamicObject> datas = this.checkAndGetRows();
        boolean success = true;
        if (datas.size() > 0) {
            OperateOption op = OperateOption.create();
            op.setVariableValue("userAddEditbatchSave", "true");
            OperationResult result = OperationServiceHelper.executeOperate((String)"save", (String)"dbd_drp_user", (DynamicObject[])datas.toArray(new DynamicObject[datas.size()]), (OperateOption)op);
            if (!result.isSuccess()) {
                List infos = result.getAllErrorOrValidateInfo();
                StringBuilder msg = new StringBuilder();
                for (IOperateInfo info : infos) {
                    msg.append(info.getMessage());
                    msg.append("\r\n");
                }
                this.getView().showMessage(msg.toString());
                success = false;
            }
        }
        return success;
    }

    private List<DynamicObject> checkAndGetRows() {
        IDataModel model = this.getModel();
        HashSet<String> pageExsist = new HashSet<String>();
        DynamicObjectCollection rows = model.getEntryEntity("users");
        StringBuilder msg = new StringBuilder();
        DynamicObject sysUser = null;
        DynamicObject owner = null;
        String key = null;
        ArrayList<DynamicObject> datas = new ArrayList<DynamicObject>();
        for (DynamicObject row : rows) {
            sysUser = row.getDynamicObject("sysuser");
            if (sysUser == null) {
                msg.append(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\uff0c\u7f3a\u5c11\u5fc5\u5f55\u9879\uff1b", (String)"UserAddEdit_0", (String)"drp-dbd-formplugin", (Object[])new Object[0]), row.get("seq")));
                continue;
            }
            owner = row.getDynamicObject("owner");
            if (owner == null) {
                msg.append(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\uff0c\u7f3a\u5c11\u5fc5\u5f55\u9879\uff1b", (String)"UserAddEdit_0", (String)"drp-dbd-formplugin", (Object[])new Object[0]), row.get("seq")));
                continue;
            }
            key = sysUser.get("id").toString() + owner.get("id").toString();
            if (!pageExsist.add(key)) {
                msg.append(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\uff0c\u5217\u8868\u4e2d\u5df2\u5b58\u5728\uff1b", (String)"UserAddEdit_1", (String)"drp-dbd-formplugin", (Object[])new Object[0]), row.get("seq")));
                continue;
            }
            datas.add(this.createDrpUser(row));
        }
        String showMsg = msg.toString();
        if (!StringUtils.isEmpty((CharSequence)showMsg)) {
            throw new KDBizException(showMsg);
        }
        return datas;
    }

    protected DynamicObject createDrpUser(DynamicObject row) {
        DynamicObject data = BusinessDataServiceHelper.newDynamicObject((String)"dbd_drp_user");
        for (String col : cols) {
            data.set(col, row.get(col));
        }
        data.set("creator", this.getCurrent().getUserId());
        data.set("createtime", (Object)this.getCurrent().getNow());
        data.set("enable", (Object)"1");
        return data;
    }

    private void beforeSave(ItemClickEvent e) {
        boolean success = this.toSaveRows();
        if (success) {
            this.getView().close();
        }
    }

    private void beforeOwnerSelect(BeforeF7SelectEvent e) {
        F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)this.getOwnerFilter());
    }

    private QFilter getOwnerFilter() {
        return UserPageHandler.getOwnerFilter(this.getPageCache(), "id");
    }
}

