/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dbd.formplugin.user;

import java.util.Collections;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.orm.query.QFilter;
import kd.drp.mdr.common.f7.F7Utils;
import kd.drp.mdr.common.util.CustomerAdminUtil;
import kd.drp.mdr.common.util.CustomerUtil;
import kd.drp.mdr.common.util.QueryUtil;
import kd.drp.mdr.formplugin.MdrBasePlugin;

@Deprecated
public class UserInfoEditPlugin
extends MdrBasePlugin
implements BeforeF7SelectListener {
    private static final String MY_OWNER = "myowner";
    private static final String IS_DEFAULT = "isdefault";
    private static final String IS_SYS_INIT = "issysinit";
    private static final String TB_RELATION_ENTRY = "relationentry";
    private static final String BAR_BIZ_INFO = "bar_bizinfo";
    private static final String ADD_ROW = "addrow";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{BAR_BIZ_INFO});
        this.addF7Listener(this, new String[]{MY_OWNER, "owner", "sysuser"});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        int index = this.getRowIndex(e);
        switch (e.getProperty().getName()) {
            case "myowner": {
                this.myOwnerChanged();
                break;
            }
            case "isdefault": {
                this.defaultChanged(index);
                break;
            }
        }
    }

    private void defaultChanged(int index) {
        DynamicObject rowInfo = this.getRowInfo(TB_RELATION_ENTRY, index);
        if (rowInfo.getBoolean(IS_DEFAULT)) {
            IDataModel model = this.getModel();
            int count = model.getEntryRowCount(TB_RELATION_ENTRY);
            int len = count;
            for (int i = 0; i < len; ++i) {
                if (i == index) continue;
                model.setValue(IS_DEFAULT, (Object)false, i);
            }
        }
    }

    private void myOwnerChanged() {
        this.getModel().deleteEntryData(TB_RELATION_ENTRY);
    }

    public void beforeItemClick(BeforeItemClickEvent e) {
        switch (e.getOperationKey()) {
            case "addrow": {
                this.checkCanAddRow(e);
                break;
            }
        }
    }

    private void checkCanAddRow(BeforeItemClickEvent e) {
        DynamicObject myOwner = this.getF7Value(MY_OWNER);
        if (myOwner == null) {
            e.setCancel(true);
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u3010\u6211\u7684\u6240\u5c5e\u6e20\u9053\u3011", (String)"UserInfoEditPlugin_0", (String)"drp-dbd-formplugin", (Object[])new Object[0]));
        }
    }

    public void afterCreateNewData(EventObject e) {
        if (!this.isFromImport()) {
            IPageCache pageCache;
            String ownerId;
            this.initDefaultVal();
            this.getView().setVisible(Boolean.valueOf(false), new String[]{IS_SYS_INIT});
            IFormView parentView = this.getView().getParentView();
            if (parentView != null && (ownerId = (pageCache = (IPageCache)parentView.getService(IPageCache.class)).get(parentView.getPageId() + "myownerId")) != null && !ownerId.toString().trim().equals("")) {
                this.setValue(MY_OWNER, ownerId);
            }
        }
    }

    public void afterLoadData(EventObject e) {
        this.getView().setVisible(Boolean.valueOf(this.getModel().getDataEntity().getBoolean(IS_SYS_INIT)), new String[]{IS_SYS_INIT});
    }

    private void initDefaultVal() {
        this.initDefaultMyOwner();
    }

    private void initDefaultMyOwner() {
        List owners = CustomerAdminUtil.getAuthCustomersByCurrentUser();
        if (owners.size() == 0) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u60a8\u4e0d\u662f\u6e20\u9053\u7ba1\u7406\u5458", (String)"UserInfoEditPlugin_1", (String)"drp-dbd-formplugin", (Object[])new Object[0]));
            return;
        }
        if (owners.size() == 1) {
            // empty if block
        }
        this.setValue(MY_OWNER, owners.get(0));
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key;
        switch (key = e.getProperty().getName()) {
            case "myowner": {
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)this.getMyOwnerFitler());
                break;
            }
            case "owner": {
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)this.getOwnerFitler());
            }
        }
    }

    private QFilter getMyOwnerFitler() {
        return new QFilter("id", "in", (Object)CustomerAdminUtil.getAuthCustomersByCurrentUser());
    }

    private QFilter getOwnerFitler() {
        Object myOwnerId = this.getF7PKValue(MY_OWNER);
        Set subIds = CustomerUtil.getAllAuthSubsIdsAndSelf((Object)myOwnerId);
        Set<Object> rowOwners = this.getRowOwners();
        subIds.removeAll(rowOwners);
        subIds.removeAll(this.queryUserExistOwner());
        return new QFilter("id", "in", (Object)subIds);
    }

    private Set<Object> queryUserExistOwner() {
        DynamicObject sysUser = this.getF7Value("sysuser");
        if (sysUser == null) {
            return Collections.EMPTY_SET;
        }
        QFilter fs = new QFilter("sysuser", "=", sysUser.get("id"));
        return QueryUtil.querySingleCol((String)"", (String)"relationentry.owner", (QFilter[])fs.toArray());
    }

    private Set<Object> getRowOwners() {
        DynamicObjectCollection rows = this.getModel().getEntryEntity(TB_RELATION_ENTRY);
        HashSet<Object> ids = new HashSet<Object>(rows.size());
        DynamicObject owner = null;
        for (DynamicObject row : rows) {
            owner = row.getDynamicObject("owner");
            if (owner == null) continue;
            ids.add(owner.get("id"));
        }
        return ids;
    }
}

