/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dbd.common.pay.ali.builder;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.earlywarn.kit.StringUtil;
import kd.bos.orm.util.CollectionUtils;
import kd.drp.dbd.common.pay.ali.vo.TradePayExtendParam;
import kd.drp.dbd.common.pay.ali.vo.TradePayGoodsDetail;
import kd.drp.dbd.common.pay.ali.vo.TradePayPromoParam;
import kd.drp.dbd.common.pay.ali.vo.TradePayRequestParam;
import kd.drp.dbd.common.pay.util.AliPayUtil;

public class TradePayRequestBuilder {
    private JSONObject builder = new JSONObject();

    public TradePayRequestBuilder() {
    }

    public TradePayRequestBuilder(TradePayRequestParam tradePayRequestParam) {
        if (tradePayRequestParam != null) {
            this.setOutTradeNo(tradePayRequestParam.getOutTradeNo()).setScene(tradePayRequestParam.getScene()).setAuthCode(tradePayRequestParam.getAuthCode()).setSubject(tradePayRequestParam.getSubject()).setProductCode(tradePayRequestParam.getProductCode()).setBuyerId(tradePayRequestParam.getBuyerId()).setSellerId(tradePayRequestParam.getSellerId()).setTotalAmount(tradePayRequestParam.getTotalAmount()).setTransCurrency(tradePayRequestParam.getTransCurrency()).setSettleCurrency(tradePayRequestParam.getSettleCurrency()).setDiscountableAmount(tradePayRequestParam.getDiscountableAmount()).setBody(tradePayRequestParam.getBody()).setGoodsDetails(tradePayRequestParam.getGoodsDetails()).setOperatorId(tradePayRequestParam.getOperatorId()).setStoreId(tradePayRequestParam.getStoreId()).setTerminalId(tradePayRequestParam.getTerminalId()).setExtendParam(tradePayRequestParam.getExtendParam()).setTimeOutExpress(tradePayRequestParam.getTimeoutExpress()).setAuthConfirmMode(tradePayRequestParam.getAuthComfirmMode()).setTerminalParams(tradePayRequestParam.getTerminalParams()).setPromoParam(tradePayRequestParam.getPromoParam()).setAdvancePaymentType(tradePayRequestParam.getAdvancePaymentType());
        }
    }

    public final TradePayRequestBuilder setOutTradeNo(String outTradeNo) {
        if (StringUtil.isNotEmpty((CharSequence)outTradeNo)) {
            this.builder.put("out_trade_no", (Object)outTradeNo);
        }
        return this;
    }

    public final TradePayRequestBuilder setScene(String scene) {
        if (StringUtil.isNotEmpty((CharSequence)scene)) {
            this.builder.put("scene", (Object)scene);
        }
        return this;
    }

    public final TradePayRequestBuilder setAuthCode(String authCode) {
        if (StringUtil.isNotEmpty((CharSequence)authCode)) {
            this.builder.put("auth_code", (Object)authCode);
        }
        return this;
    }

    public final TradePayRequestBuilder setSubject(String subject) {
        if (StringUtil.isNotEmpty((CharSequence)subject)) {
            this.builder.put("subject", (Object)subject);
        }
        return this;
    }

    public final TradePayRequestBuilder setProductCode(String productCode) {
        if (StringUtil.isNotEmpty((CharSequence)productCode)) {
            this.builder.put("product_code", (Object)productCode);
        }
        return this;
    }

    public final TradePayRequestBuilder setBuyerId(String buyerId) {
        if (StringUtil.isNotEmpty((CharSequence)buyerId)) {
            this.builder.put("buyer_id", (Object)buyerId);
        }
        return this;
    }

    public final TradePayRequestBuilder setSellerId(String sellerId) {
        if (StringUtil.isNotEmpty((CharSequence)sellerId)) {
            this.builder.put("seller_id", (Object)sellerId);
        }
        return this;
    }

    public final TradePayRequestBuilder setTransCurrency(String transCurrency) {
        if (StringUtil.isNotEmpty((CharSequence)transCurrency)) {
            this.builder.put("trans_currency", (Object)transCurrency);
        }
        return this;
    }

    public final TradePayRequestBuilder setSettleCurrency(String settleCurrency) {
        if (StringUtil.isNotEmpty((CharSequence)settleCurrency)) {
            this.builder.put("settle_currency", (Object)settleCurrency);
        }
        return this;
    }

    public final TradePayRequestBuilder setTotalAmount(BigDecimal totalAmount) {
        if (totalAmount != null) {
            this.builder.put("total_amount", (Object)AliPayUtil.decimalConvertToAmountString(totalAmount));
        }
        return this;
    }

    public final TradePayRequestBuilder setDiscountableAmount(BigDecimal discountableAmount) {
        if (discountableAmount != null) {
            this.builder.put("discountable_amount", (Object)AliPayUtil.decimalConvertToAmountString(discountableAmount));
        }
        return this;
    }

    public final TradePayRequestBuilder setBody(String body) {
        if (StringUtil.isNotEmpty((CharSequence)body)) {
            this.builder.put("body", (Object)body);
        }
        return this;
    }

    public final TradePayRequestBuilder setGoodsDetails(List<TradePayGoodsDetail> goodsDetails) {
        if (!CollectionUtils.isEmpty(goodsDetails)) {
            ArrayList<JSONObject> goods_details = new ArrayList<JSONObject>(goodsDetails.size());
            for (TradePayGoodsDetail goodsDetail : goodsDetails) {
                JSONObject goods_detail = new JSONObject();
                if (StringUtil.isNotEmpty((CharSequence)goodsDetail.getGoodsId())) {
                    goods_detail.put("goods_id", (Object)goodsDetail.getGoodsId());
                }
                if (StringUtil.isNotEmpty((CharSequence)goodsDetail.getGoodsName())) {
                    goods_detail.put("goods_name", (Object)goodsDetail.getGoodsName());
                }
                if (goodsDetail.getQuantity() > 0) {
                    goods_detail.put("quantity", (Object)String.valueOf(goodsDetail.getQuantity()));
                }
                if (goodsDetail.getPrice() != null) {
                    goods_detail.put("price", (Object)AliPayUtil.decimalConvertToAmountString(goodsDetail.getPrice()));
                }
                if (StringUtil.isNotEmpty((CharSequence)goodsDetail.getGoodsCategory())) {
                    goods_detail.put("goods_category", (Object)goodsDetail.getGoodsCategory());
                }
                if (StringUtil.isNotEmpty((CharSequence)goodsDetail.getCategoriesTree())) {
                    goods_detail.put("categories_tree", (Object)goodsDetail.getCategoriesTree());
                }
                if (StringUtil.isNotEmpty((CharSequence)goodsDetail.getBody())) {
                    goods_detail.put("body", (Object)goodsDetail.getBody());
                }
                if (StringUtil.isNotEmpty((CharSequence)goodsDetail.getShowUrl())) {
                    goods_detail.put("show_url", (Object)goodsDetail.getShowUrl());
                }
                if (goods_detail.size() <= 0) continue;
                goods_details.add(goods_detail);
            }
            if (!CollectionUtils.isEmpty(goods_details)) {
                this.builder.put("goods_detail", (Object)SerializationUtils.toJsonString(goods_details));
            }
        }
        return this;
    }

    public final TradePayRequestBuilder setOperatorId(String operatorId) {
        if (StringUtil.isNotEmpty((CharSequence)operatorId)) {
            this.builder.put("operator_id", (Object)operatorId);
        }
        return this;
    }

    public final TradePayRequestBuilder setStoreId(String storeId) {
        if (StringUtil.isNotEmpty((CharSequence)storeId)) {
            this.builder.put("store_id", (Object)storeId);
        }
        return this;
    }

    public final TradePayRequestBuilder setTerminalId(String terminalId) {
        if (StringUtil.isNotEmpty((CharSequence)terminalId)) {
            this.builder.put("terminal_id", (Object)terminalId);
        }
        return this;
    }

    public final TradePayRequestBuilder setExtendParam(TradePayExtendParam extendParam) {
        if (extendParam != null) {
            JSONObject extend_params = new JSONObject();
            if (StringUtil.isNotEmpty((CharSequence)extendParam.getSysServiceProviderId())) {
                extend_params.put("sys_service_provider_id", (Object)extendParam.getSysServiceProviderId());
            }
            if (StringUtil.isNotEmpty((CharSequence)extendParam.getIndustryRefluxInfo())) {
                extend_params.put("industry_reflux_info", (Object)extendParam.getIndustryRefluxInfo());
            }
            if (StringUtil.isNotEmpty((CharSequence)extendParam.getCardType())) {
                extend_params.put("card_type", (Object)extendParam.getCardType());
            }
            if (extend_params.size() > 0) {
                this.builder.put("extend_params", (Object)SerializationUtils.toJsonString((Object)extendParam));
            }
        }
        return this;
    }

    public final TradePayRequestBuilder setTimeOutExpress(String timeOutExpress) {
        if (StringUtil.isNotEmpty((CharSequence)timeOutExpress)) {
            this.builder.put("timeout_express", (Object)timeOutExpress);
        }
        return this;
    }

    public final TradePayRequestBuilder setAuthConfirmMode(String authConfirmMode) {
        if (StringUtil.isNotEmpty((CharSequence)authConfirmMode)) {
            this.builder.put("auth_confirm_mode", (Object)authConfirmMode);
        }
        return this;
    }

    public final TradePayRequestBuilder setTerminalParams(String terminalParams) {
        if (StringUtil.isNotEmpty((CharSequence)terminalParams)) {
            this.builder.put("terminal_params", (Object)terminalParams);
        }
        return this;
    }

    public final TradePayRequestBuilder setPromoParam(TradePayPromoParam promoParam) {
        if (promoParam != null) {
            JSONObject promo_params = new JSONObject();
            if (StringUtil.isNotEmpty((CharSequence)promoParam.getActualOrderTime())) {
                promo_params.put("actual_order_time", (Object)promoParam.getActualOrderTime());
            }
            if (promo_params.size() > 0) {
                this.builder.put("promo_params", (Object)SerializationUtils.toJsonString((Object)promoParam));
            }
        }
        return this;
    }

    public final TradePayRequestBuilder setAdvancePaymentType(String advancePaymentType) {
        if (StringUtil.isNotEmpty((CharSequence)advancePaymentType)) {
            this.builder.put("advance_payment_type", (Object)advancePaymentType);
        }
        return this;
    }

    public String toJsonString() {
        return SerializationUtils.toJsonString((Object)this.builder);
    }
}

