/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dbd.common.pay.util;

import com.alibaba.fastjson.JSONObject;
import com.alipay.api.AlipayApiException;
import com.alipay.api.AlipayClient;
import com.alipay.api.AlipayRequest;
import com.alipay.api.DefaultAlipayClient;
import com.alipay.api.request.AlipayTradeCancelRequest;
import com.alipay.api.request.AlipayTradePayRequest;
import com.alipay.api.request.AlipayTradeQueryRequest;
import com.alipay.api.request.AlipayTradeRefundRequest;
import com.alipay.api.response.AlipayTradeCancelResponse;
import com.alipay.api.response.AlipayTradePayResponse;
import com.alipay.api.response.AlipayTradeQueryResponse;
import com.alipay.api.response.AlipayTradeRefundResponse;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.Map;
import kd.bos.config.client.util.StringUtils;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.drp.dbd.common.pay.ali.builder.TradeCancelRequestBuilder;
import kd.drp.dbd.common.pay.ali.builder.TradePayRequestBuilder;
import kd.drp.dbd.common.pay.ali.builder.TradeQueryRequestBuilder;
import kd.drp.dbd.common.pay.ali.builder.TradeRefundRequestBuilder;
import kd.drp.dbd.common.pay.ali.vo.TradeCancelRequestParam;
import kd.drp.dbd.common.pay.ali.vo.TradePayRequestParam;
import kd.drp.dbd.common.pay.ali.vo.TradeQueryRequestParam;
import kd.drp.dbd.common.pay.ali.vo.TradeRefundRequestParam;
import kd.drp.dbd.common.pay.exception.ServiceException;

public class AliPayUtil {
    private static Log logger = LogFactory.getLog(AliPayUtil.class);
    public static final String CHARSET = "utf-8";
    public static final String GATEWAYURL = "https://openapi.alipay.com/gateway.do";

    public static String doubleConvertToAmountString(Double amount) {
        DecimalFormat df = new DecimalFormat("######0.00");
        return df.format(amount);
    }

    public static String decimalConvertToAmountString(BigDecimal amount) {
        DecimalFormat df = new DecimalFormat("######0.00");
        return df.format(amount);
    }

    public static AlipayClient getAlipayClient(Map<String, String> payConfig) {
        DefaultAlipayClient alipayClient = new DefaultAlipayClient(GATEWAYURL, payConfig.get("appid"), payConfig.get("private_key_pkcs8"), "json", CHARSET, payConfig.get("alipay_public_key"), payConfig.get("sign_type"));
        return alipayClient;
    }

    public static JSONObject tradePay(TradePayRequestParam tradePayRequestParam) {
        AlipayClient alipayClient = AliPayUtil.getAlipayClient(tradePayRequestParam.getPayConfig());
        String bizContent = new TradePayRequestBuilder(tradePayRequestParam).toJsonString();
        String responseBody = "";
        try {
            AlipayTradePayRequest request = new AlipayTradePayRequest();
            request.setBizContent(bizContent);
            AlipayTradePayResponse response = (AlipayTradePayResponse)alipayClient.execute((AlipayRequest)request);
            responseBody = response.getBody();
        }
        catch (AlipayApiException e) {
            StringBuilder errorMsg = new StringBuilder(e.getMessage());
            if (StringUtils.isNotNull((String)e.getErrCode())) {
                errorMsg.append(e.getErrCode());
            }
            if (StringUtils.isNotNull((String)e.getErrMsg())) {
                errorMsg.append(e.getErrMsg());
            }
            logger.error(errorMsg.append(":\u652f\u4ed8\u5b9d\u7edf\u4e00\u6536\u5355\u4ea4\u6613\u652f\u4ed8\u63a5\u53e3\u5f02\u5e38 ").toString());
            throw new ServiceException(errorMsg.toString(), (Exception)((Object)e));
        }
        JSONObject result = (JSONObject)SerializationUtils.fromJsonString((String)responseBody, JSONObject.class);
        return result.getJSONObject("alipay_trade_pay_response");
    }

    public static JSONObject tradeQuery(TradeQueryRequestParam tradeQueryRequestParam) {
        AlipayClient alipayClient = AliPayUtil.getAlipayClient(tradeQueryRequestParam.getPayConfig());
        String bizContent = new TradeQueryRequestBuilder(tradeQueryRequestParam).toJsonString();
        String responseBody = "";
        try {
            AlipayTradeQueryRequest request = new AlipayTradeQueryRequest();
            request.setBizContent(bizContent);
            AlipayTradeQueryResponse response = (AlipayTradeQueryResponse)alipayClient.execute((AlipayRequest)request);
            responseBody = response.getBody();
        }
        catch (AlipayApiException e) {
            StringBuilder errorMsg = new StringBuilder(e.getMessage());
            if (StringUtils.isNotNull((String)e.getErrCode())) {
                errorMsg.append(e.getErrCode());
            }
            if (StringUtils.isNotNull((String)e.getErrMsg())) {
                errorMsg.append(e.getErrMsg());
            }
            logger.error(errorMsg.append(":\u652f\u4ed8\u5b9d\u7edf\u4e00\u6536\u5355\u7ebf\u4e0b\u4ea4\u6613\u67e5\u8be2\u63a5\u53e3\u5f02\u5e38").toString());
            throw new ServiceException(errorMsg.toString(), (Exception)((Object)e));
        }
        JSONObject result = (JSONObject)SerializationUtils.fromJsonString((String)responseBody, JSONObject.class);
        return result.getJSONObject("alipay_trade_query_response");
    }

    public static JSONObject tradeCancel(TradeCancelRequestParam tradeCancelRequestParam) {
        AlipayClient alipayClient = AliPayUtil.getAlipayClient(tradeCancelRequestParam.getPayConfig());
        String bizContent = new TradeCancelRequestBuilder(tradeCancelRequestParam).toJsonString();
        String responseBody = "";
        try {
            AlipayTradeCancelRequest request = new AlipayTradeCancelRequest();
            request.setBizContent(bizContent);
            AlipayTradeCancelResponse response = (AlipayTradeCancelResponse)alipayClient.execute((AlipayRequest)request);
            responseBody = response.getBody();
        }
        catch (AlipayApiException e) {
            StringBuilder errorMsg = new StringBuilder(e.getMessage());
            if (StringUtils.isNotNull((String)e.getErrCode())) {
                errorMsg.append(e.getErrCode());
            }
            if (StringUtils.isNotNull((String)e.getErrMsg())) {
                errorMsg.append(e.getErrMsg());
            }
            logger.error(errorMsg.append(":\u652f\u4ed8\u5b9d\u7edf\u4e00\u6536\u5355\u4ea4\u6613\u64a4\u9500\u63a5\u53e3\u5f02\u5e38").toString());
            throw new ServiceException(errorMsg.toString(), (Exception)((Object)e));
        }
        JSONObject result = (JSONObject)SerializationUtils.fromJsonString((String)responseBody, JSONObject.class);
        return result.getJSONObject("alipay_trade_cancel_response");
    }

    public static JSONObject tradeRefund(TradeRefundRequestParam tradeRefundRequestParam) {
        AlipayClient alipayClient = AliPayUtil.getAlipayClient(tradeRefundRequestParam.getPayConfig());
        String bizContent = new TradeRefundRequestBuilder(tradeRefundRequestParam).toJsonString();
        String responseBody = "";
        try {
            AlipayTradeRefundRequest request = new AlipayTradeRefundRequest();
            request.setBizContent(bizContent);
            AlipayTradeRefundResponse response = (AlipayTradeRefundResponse)alipayClient.execute((AlipayRequest)request);
            responseBody = response.getBody();
        }
        catch (AlipayApiException e) {
            StringBuilder errorMsg = new StringBuilder(e.getMessage());
            if (StringUtils.isNotNull((String)e.getErrCode())) {
                errorMsg.append(e.getErrCode());
            }
            if (StringUtils.isNotNull((String)e.getErrMsg())) {
                errorMsg.append(e.getErrMsg());
            }
            logger.error(errorMsg.append(":\u652f\u4ed8\u5b9d\u7edf\u4e00\u6536\u5355\u4ea4\u6613\u9000\u6b3e\u63a5\u53e3\u5f02\u5e38").toString());
            throw new ServiceException(errorMsg.toString(), (Exception)((Object)e));
        }
        JSONObject result = (JSONObject)SerializationUtils.fromJsonString((String)responseBody, JSONObject.class);
        return result.getJSONObject("alipay_trade_refund_response");
    }
}

