/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dbd.common.pay.util;

import com.alibaba.fastjson.JSONObject;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.drp.dbd.common.pay.config.WechatPayConfig;
import kd.drp.dbd.common.pay.exception.ServiceException;
import kd.drp.dbd.common.pay.wechat.vo.MicroPayRequestParam;
import kd.drp.dbd.common.pay.wechat.vo.OrderQueryRequestParam;
import kd.drp.dbd.common.pay.wechat.vo.RefundRequestParam;
import kd.drp.dbd.common.pay.wechat.vo.ReverseRequestParam;
import kd.drp.dbd.common.pay.wechatpay.sdk.WXPayConstants;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Lookup;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.DefaultHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.BasicHttpClientConnectionManager;
import org.apache.http.util.EntityUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WechatPayUtil {
    private static Log logger = LogFactory.getLog(WechatPayUtil.class);
    private static final String SYMBOLS = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private static final Random RANDOM = new SecureRandom();
    private static final String PREFIX_XML = "<xml>";
    private static final String SUFFIX_XML = "</xml>";
    private static final String PREFIX_CDATA = "<![CDATA[";
    private static final String SUFFIX_CDATA = "]]>";

    public static JSONObject microPay(MicroPayRequestParam microPayRequestParam) {
        String interfaceName = "/pay/micropay";
        String bizContent = "";
        String responseBody = "";
        try {
            boolean isNeedCert = false;
            WechatPayConfig config = WechatPayUtil.getWechatPayConfig(microPayRequestParam.getPayConfig(), isNeedCert);
            bizContent = WechatPayUtil.mapToXml(WechatPayUtil.fillRequestData(config, microPayRequestParam.buildRequestMap()));
            responseBody = WechatPayUtil.requestWithoutCert(config, interfaceName, bizContent);
            JSONObject result = new JSONObject();
            result.putAll(WechatPayUtil.processResponseXml(config, responseBody));
            return result;
        }
        catch (Exception e) {
            logger.info("\u5fae\u4fe1\u652f\u4ed8\u63d0\u4ea4\u5237\u5361\u652f\u4ed8\u63a5\u53e3\u5f02\u5e38 : (" + e.getMessage() + ")");
            throw new ServiceException("\u5fae\u4fe1\u652f\u4ed8\u63d0\u4ea4\u5237\u5361\u652f\u4ed8\u63a5\u53e3\u5f02\u5e38 : (" + e.getMessage() + ")", e);
        }
    }

    public static JSONObject orderQuery(OrderQueryRequestParam orderQueryRequestParam) {
        String interfaceName = "/pay/orderquery";
        String bizContent = "";
        String responseBody = "";
        try {
            boolean isNeedCert = false;
            WechatPayConfig config = WechatPayUtil.getWechatPayConfig(orderQueryRequestParam.getPayConfig(), isNeedCert);
            bizContent = WechatPayUtil.mapToXml(WechatPayUtil.fillRequestData(config, orderQueryRequestParam.buildRequestMap()));
            responseBody = WechatPayUtil.requestWithoutCert(config, interfaceName, bizContent);
            JSONObject result = new JSONObject();
            result.putAll(WechatPayUtil.processResponseXml(config, responseBody));
            return result;
        }
        catch (Exception e) {
            logger.info("\u5fae\u4fe1\u652f\u4ed8\u67e5\u8be2\u8ba2\u5355\u63a5\u53e3\u5f02\u5e38 : (" + e.getMessage() + ")");
            throw new ServiceException("\u5fae\u4fe1\u652f\u4ed8\u67e5\u8be2\u8ba2\u5355\u63a5\u53e3\u5f02\u5e38 : (" + e.getMessage() + ")", e);
        }
    }

    public static JSONObject reverse(ReverseRequestParam reverseRequestParam) {
        String interfaceName = "/secapi/pay/reverse";
        String bizContent = "";
        String responseBody = "";
        try {
            boolean isNeedCert = true;
            WechatPayConfig config = WechatPayUtil.getWechatPayConfig(reverseRequestParam.getPayConfig(), isNeedCert);
            bizContent = WechatPayUtil.mapToXml(WechatPayUtil.fillRequestData(config, reverseRequestParam.buildRequestMap()));
            responseBody = WechatPayUtil.requestWithCert(config, interfaceName, bizContent);
            JSONObject result = new JSONObject();
            result.putAll(WechatPayUtil.processResponseXml(config, responseBody));
            return result;
        }
        catch (Exception e) {
            logger.info("\u5fae\u4fe1\u652f\u4ed8\u64a4\u9500\u8ba2\u5355\u63a5\u53e3\u5f02\u5e38 : (" + e.getMessage() + ")");
            throw new ServiceException("\u5fae\u4fe1\u652f\u4ed8\u64a4\u9500\u8ba2\u5355\u63a5\u53e3\u5f02\u5e38 : (" + e.getMessage() + ")", e);
        }
    }

    public static JSONObject refund(RefundRequestParam refundRequestParam) {
        String interfaceName = "/secapi/pay/refund";
        String bizContent = "";
        String responseBody = "";
        try {
            boolean isNeedCert = true;
            WechatPayConfig config = WechatPayUtil.getWechatPayConfig(refundRequestParam.getPayConfig(), isNeedCert);
            bizContent = WechatPayUtil.mapToXml(WechatPayUtil.fillRequestData(config, refundRequestParam.buildRequestMap()));
            try {
                responseBody = WechatPayUtil.requestWithCert(config, interfaceName, bizContent);
            }
            catch (Exception e) {
                throw new ServiceException("\u5fae\u4fe1\u53cc\u5411\u8ba4\u8bc1\u8bf7\u6c42\u5931\u8d25 :", e);
            }
            JSONObject result = new JSONObject();
            result.putAll(WechatPayUtil.processResponseXml(config, responseBody));
            return result;
        }
        catch (Exception e) {
            logger.info("\u5fae\u4fe1\u652f\u4ed8\u7533\u8bf7\u9000\u6b3e\u63a5\u53e3\u5f02\u5e38 : (" + e.getMessage() + ")");
            throw new ServiceException("\u5fae\u4fe1\u652f\u4ed8\u7533\u8bf7\u9000\u6b3e\u63a5\u53e3\u5f02\u5e38 : (" + e.getMessage() + ")", e);
        }
    }

    protected static WechatPayConfig getWechatPayConfig(Map<String, String> payConfig, Boolean isNeedCert) {
        WechatPayConfig wechatPayConfig = new WechatPayConfig();
        wechatPayConfig.setAppId(payConfig.get("appid"));
        wechatPayConfig.setMchId(payConfig.get("mch_id"));
        wechatPayConfig.setApiKey(payConfig.get("key"));
        wechatPayConfig.setPayDomain("api.mch.weixin.qq.com");
        if (isNeedCert.booleanValue()) {
            byte[] certData = WechatPayUtil.getCertdata(payConfig.get("pay_certificate"));
            wechatPayConfig.setCertData(certData);
        }
        return wechatPayConfig;
    }

    protected static byte[] getCertdata(String fileUrl) {
        byte[] certData = new byte[]{};
        FileService fs = FileServiceFactory.getAttachmentFileService();
        try {
            int temp;
            InputStream fis = fs.getInputStream(fileUrl);
            ByteArrayOutputStream baos = new ByteArrayOutputStream(fis.available());
            byte[] bytes = new byte[fis.available()];
            while ((temp = fis.read(bytes)) != -1) {
                baos.write(bytes, 0, temp);
            }
            fis.close();
            baos.close();
            certData = baos.toByteArray();
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u8bc1\u4e66\u5185\u5bb9\u5931\u8d25 :" + e.getMessage());
        }
        return certData;
    }

    protected static Map<String, String> fillRequestData(WechatPayConfig config, Map<String, String> reqData) throws Exception {
        reqData.put("appid", config.getAppId());
        reqData.put("mch_id", config.getMchId());
        reqData.put("nonce_str", WechatPayUtil.generateNonceStr());
        reqData.put("sign_type", "HMAC-SHA256");
        reqData.put("sign", WechatPayUtil.generateSignature(reqData, config.getApiKey(), WXPayConstants.SignType.HMACSHA256));
        return reqData;
    }

    protected static Map<String, String> processResponseXml(WechatPayConfig config, String xmlStr) throws Exception {
        String RETURN_CODE = "return_code";
        Map<String, String> respData = WechatPayUtil.xmlToMap(xmlStr);
        String value = respData.get(RETURN_CODE);
        if (value == null) {
            throw new Exception(String.format("No `return_code` in XML: %s", xmlStr));
        }
        String return_code = value;
        if (return_code.equals("FAIL")) {
            return respData;
        }
        if (return_code.equals("SUCCESS")) {
            if (WechatPayUtil.isResponseSignatureValid(config, respData)) {
                return respData;
            }
            throw new Exception(String.format("Invalid sign value in XML: %s", xmlStr));
        }
        throw new Exception(String.format("return_code value %s is invalid in XML: %s", return_code, xmlStr));
    }

    protected static boolean isResponseSignatureValid(WechatPayConfig config, Map<String, String> reqData) throws Exception {
        return WechatPayUtil.isSignatureValid(reqData, config.getApiKey(), WXPayConstants.SignType.HMACSHA256);
    }

    protected static String requestWithoutCert(WechatPayConfig config, String urlSuffix, String data) throws Exception {
        return WechatPayUtil.requestOnce(config, urlSuffix, data, false);
    }

    protected static String requestWithCert(WechatPayConfig config, String urlSuffix, String data) throws Exception {
        return WechatPayUtil.requestOnce(config, urlSuffix, data, true);
    }

    protected static synchronized String requestOnce(WechatPayConfig config, String urlSuffix, String data, boolean useCert) throws Exception {
        BasicHttpClientConnectionManager connManager;
        if (useCert) {
            char[] password = config.getMchId().toCharArray();
            ByteArrayInputStream certStream = new ByteArrayInputStream(config.getCertData());
            KeyStore ks = KeyStore.getInstance("PKCS12");
            try {
                ks.load(certStream, password);
            }
            catch (Exception e) {
                throw new ServiceException("\u5fae\u4fe1\u8bc1\u4e66\u52a0\u8f7d\u5f02\u5e38 :", e);
            }
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            kmf.init(ks, password);
            SSLContext sslContext = SSLContext.getInstance("TLSv1.2");
            sslContext.init(kmf.getKeyManagers(), null, new SecureRandom());
            SSLConnectionSocketFactory sslConnectionSocketFactory = new SSLConnectionSocketFactory(sslContext, new String[]{"TLSv1"}, null, (HostnameVerifier)new DefaultHostnameVerifier());
            connManager = new BasicHttpClientConnectionManager((Lookup)RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)sslConnectionSocketFactory).build(), null, null, null);
        } else {
            connManager = new BasicHttpClientConnectionManager((Lookup)RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)SSLConnectionSocketFactory.getSocketFactory()).build(), null, null, null);
        }
        CloseableHttpClient httpClient = HttpClientBuilder.create().setConnectionManager((HttpClientConnectionManager)connManager).build();
        String url = "https://" + config.getPayDomain() + urlSuffix;
        HttpPost httpPost = new HttpPost(url);
        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(config.getReadTimeOutMs()).setConnectTimeout(config.getConnectTimeOutMs()).build();
        httpPost.setConfig(requestConfig);
        StringEntity postEntity = new StringEntity(data, "UTF-8");
        httpPost.addHeader("Content-Type", "text/xml");
        httpPost.addHeader("User-Agent", WXPayConstants.USER_AGENT + " " + config.getMchId());
        httpPost.setEntity((HttpEntity)postEntity);
        try {
            HttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpPost);
            HttpEntity httpEntity = httpResponse.getEntity();
            return EntityUtils.toString((HttpEntity)httpEntity, (String)"UTF-8");
        }
        catch (Exception e) {
            throw new ServiceException("\u5fae\u4fe1\u53d1\u8d77Http\u8bf7\u6c42\u5f02\u5e38 :", e);
        }
    }

    protected static boolean isSignatureValid(Map<String, String> data, String key, WXPayConstants.SignType signType) throws Exception {
        if (!data.containsKey("sign")) {
            return false;
        }
        String sign = data.get("sign");
        return WechatPayUtil.generateSignature(data, key, signType).toUpperCase(Locale.ENGLISH).equals(sign);
    }

    protected static String generateSignature(Map<String, String> data, String key, WXPayConstants.SignType signType) throws Exception {
        Set<String> keySet = data.keySet();
        Object[] keyArray = keySet.toArray(new String[keySet.size()]);
        Arrays.sort(keyArray);
        StringBuilder sb = new StringBuilder();
        for (Object k : keyArray) {
            if (((String)k).equals("sign") || data.get(k).trim().length() <= 0) continue;
            sb.append((String)k).append('=').append(data.get(k).trim()).append('&');
        }
        sb.append("key=").append(key);
        if (WXPayConstants.SignType.HMACSHA256 == signType) {
            return WechatPayUtil.HMACSHA256(sb.toString(), key);
        }
        throw new Exception(String.format("Invalid sign_type: %s", new Object[]{signType}));
    }

    protected static String generateNonceStr() {
        char[] nonceChars = new char[32];
        for (int index = 0; index < nonceChars.length; ++index) {
            nonceChars[index] = SYMBOLS.charAt(RANDOM.nextInt(SYMBOLS.length()));
        }
        return new String(nonceChars);
    }

    public static String HMACSHA256(String data, String key) throws Exception {
        Mac sha256_HMAC = Mac.getInstance("HmacSHA256");
        SecretKeySpec secret_key = new SecretKeySpec(key.getBytes("UTF-8"), "HmacSHA256");
        sha256_HMAC.init(secret_key);
        byte[] array = sha256_HMAC.doFinal(data.getBytes("UTF-8"));
        StringBuilder sb = new StringBuilder();
        for (byte item : array) {
            sb.append(Integer.toHexString(item & 0xFF | 0x100).substring(1, 3));
        }
        return sb.toString().toUpperCase();
    }

    public static Map<String, String> xmlToMap(String strXML) throws Exception {
        try {
            HashMap<String, String> data = new HashMap<String, String>();
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            DocumentBuilder documentBuilder = dbf.newDocumentBuilder();
            ByteArrayInputStream stream = new ByteArrayInputStream(strXML.getBytes("UTF-8"));
            Document doc = documentBuilder.parse(stream);
            doc.getDocumentElement().normalize();
            NodeList nodeList = doc.getDocumentElement().getChildNodes();
            for (int idx = 0; idx < nodeList.getLength(); ++idx) {
                Node node = nodeList.item(idx);
                if (node.getNodeType() != 1) continue;
                Element element = (Element)node;
                data.put(element.getNodeName(), element.getTextContent());
            }
            try {
                ((InputStream)stream).close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return data;
        }
        catch (Exception ex) {
            logger.error("\u65e0\u6548\u7684XML\uff0c\u8f6c\u6362Map\u5931\u8d25\u3002\u9519\u8bef\u4fe1\u606f\u662f\uff1a" + ex.getMessage() + "\u51fa\u9519XML\u662f\uff1a" + strXML);
            throw ex;
        }
    }

    public static String mapToXml(Map<String, String> data) throws Exception {
        StringBuilder strbuff = new StringBuilder(PREFIX_XML);
        if (null != data) {
            for (Map.Entry<String, String> entry : data.entrySet()) {
                strbuff.append('<').append(entry.getKey()).append('>');
                strbuff.append(PREFIX_CDATA);
                if (null != entry.getValue()) {
                    strbuff.append(entry.getValue());
                }
                strbuff.append(SUFFIX_CDATA);
                strbuff.append("</").append(entry.getKey()).append('>');
            }
        }
        return strbuff.append(SUFFIX_XML).toString();
    }
}

