/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dbd.common.util;

import java.util.List;
import java.util.Map;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;

public class FormShowUtils {
    public static FormShowParameter openNewForm(String caption, String formId, ShowType showType, OperationStatus status, Map<String, Object> customParams) {
        FormShowParameter param = new FormShowParameter();
        if (StringUtils.isNotBlank((CharSequence)caption)) {
            param.setCaption(caption);
        }
        param.setFormId(formId);
        param.getOpenStyle().setShowType(showType);
        if (status != null) {
            param.setStatus(status);
        }
        if (!CollectionUtils.isEmpty(customParams)) {
            for (Map.Entry<String, Object> entry : customParams.entrySet()) {
                param.setCustomParam(entry.getKey(), entry.getValue());
            }
        }
        return param;
    }

    public static BillShowParameter openNewBill(String caption, String formId, ShowType showType, OperationStatus status, Map<String, Object> customParams) {
        BillShowParameter param = new BillShowParameter();
        if (StringUtils.isNotBlank((CharSequence)caption)) {
            param.setCaption(caption);
        }
        param.setFormId(formId);
        param.getOpenStyle().setShowType(showType);
        if (status != null) {
            param.setStatus(status);
        }
        if (!CollectionUtils.isEmpty(customParams)) {
            for (Map.Entry<String, Object> entry : customParams.entrySet()) {
                param.setCustomParam(entry.getKey(), entry.getValue());
            }
        }
        return param;
    }

    public static ListShowParameter openChooseList(String caption, String formId, ShowType showType, List<QFilter> lstFilter, boolean isMultSelect, boolean isLookUp) {
        ListShowParameter param = ShowFormHelper.createShowListForm((String)formId, (boolean)isMultSelect, (int)3, (boolean)isLookUp);
        param.setCaption(caption);
        if (!CollectionUtils.isEmpty(lstFilter)) {
            ListFilterParameter filterParam = new ListFilterParameter(lstFilter, null);
            param.setListFilterParameter(filterParam);
        }
        param.getOpenStyle().setShowType(showType);
        return param;
    }
}

