/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dbd.common.util;

import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;

public class IDcardUtils {
    static final Map<Integer, String> zoneNum = new HashMap<Integer, String>();
    static final int[] PARITYBIT;
    static final int[] POWER_LIST;

    public static boolean isIDCard(String certNo) {
        if (certNo == null || certNo.length() != 15 && certNo.length() != 18) {
            return false;
        }
        char[] cs = certNo.toUpperCase().toCharArray();
        int power = 0;
        for (int i = 0; i < cs.length && (i != cs.length - 1 || cs[i] != 'X'); ++i) {
            if (cs[i] < '0' || cs[i] > '9') {
                return false;
            }
            if (i >= cs.length - 1) continue;
            power += (cs[i] - 48) * POWER_LIST[i];
        }
        if (!zoneNum.containsKey(Integer.valueOf(certNo.substring(0, 2)))) {
            return false;
        }
        String year = certNo.length() == 15 ? IDcardUtils.getIdcardCalendar() + certNo.substring(6, 8) : certNo.substring(6, 10);
        int iyear = Integer.parseInt(year);
        if (iyear < 1900 || iyear > Calendar.getInstance().get(1)) {
            return false;
        }
        String month = certNo.length() == 15 ? certNo.substring(8, 10) : certNo.substring(10, 12);
        int imonth = Integer.parseInt(month);
        if (imonth < 1 || imonth > 12) {
            return false;
        }
        String day = certNo.length() == 15 ? certNo.substring(10, 12) : certNo.substring(12, 14);
        int iday = Integer.parseInt(day);
        if (iday < 1 || iday > 31) {
            return false;
        }
        if (certNo.length() == 15) {
            return true;
        }
        return cs[cs.length - 1] == PARITYBIT[power % 11];
    }

    private static int getIdcardCalendar() {
        GregorianCalendar curDay = new GregorianCalendar();
        int curYear = curDay.get(1);
        int year2bit = Integer.parseInt(String.valueOf(curYear).substring(2));
        return year2bit;
    }

    static {
        zoneNum.put(11, "\u5317\u4eac");
        zoneNum.put(12, "\u5929\u6d25");
        zoneNum.put(13, "\u6cb3\u5317");
        zoneNum.put(14, "\u5c71\u897f");
        zoneNum.put(15, "\u5185\u8499\u53e4");
        zoneNum.put(21, "\u8fbd\u5b81");
        zoneNum.put(22, "\u5409\u6797");
        zoneNum.put(23, "\u9ed1\u9f99\u6c5f");
        zoneNum.put(31, "\u4e0a\u6d77");
        zoneNum.put(32, "\u6c5f\u82cf");
        zoneNum.put(33, "\u6d59\u6c5f");
        zoneNum.put(34, "\u5b89\u5fbd");
        zoneNum.put(35, "\u798f\u5efa");
        zoneNum.put(36, "\u6c5f\u897f");
        zoneNum.put(37, "\u5c71\u4e1c");
        zoneNum.put(41, "\u6cb3\u5357");
        zoneNum.put(42, "\u6e56\u5317");
        zoneNum.put(43, "\u6e56\u5357");
        zoneNum.put(44, "\u5e7f\u4e1c");
        zoneNum.put(45, "\u5e7f\u897f");
        zoneNum.put(46, "\u6d77\u5357");
        zoneNum.put(50, "\u91cd\u5e86");
        zoneNum.put(51, "\u56db\u5ddd");
        zoneNum.put(52, "\u8d35\u5dde");
        zoneNum.put(53, "\u4e91\u5357");
        zoneNum.put(54, "\u897f\u85cf");
        zoneNum.put(61, "\u9655\u897f");
        zoneNum.put(62, "\u7518\u8083");
        zoneNum.put(63, "\u9752\u6d77");
        zoneNum.put(64, "\u65b0\u7586");
        zoneNum.put(71, "\u53f0\u6e7e");
        zoneNum.put(81, "\u9999\u6e2f");
        zoneNum.put(82, "\u6fb3\u95e8");
        zoneNum.put(91, "\u5916\u56fd");
        PARITYBIT = new int[]{49, 48, 88, 57, 56, 55, 54, 53, 52, 51, 50};
        POWER_LIST = new int[]{7, 9, 10, 5, 8, 4, 2, 1, 6, 3, 7, 9, 10, 5, 8, 4, 2};
    }
}

