/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dbd.common.util;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.db.DB;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.actions.SerializationUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.drp.dbd.common.util.DynamicObjectUtils;
import kd.drp.mdr.common.ORMUtil;
import kd.drp.mdr.common.StringUtils;

public class ItemSaleContentUtils {
    private static final String ALLERRORORVALIDATEINFO = "allErrorOrValidateInfo";
    private static final String BILLCOUNT = "billCount";
    private static final String SUCCESSPKIDS = "successPkIds";
    private static final String MESSAGE = "message";
    private static final Log logger = LogFactory.getLog(ItemSaleContentUtils.class);

    public static OperationResult jsonStr2OperationResult(String jsonStr) {
        Map result = (Map)SerializationUtils.fromJsonString((String)jsonStr, Map.class);
        List allErrorOrValidateInfo = (List)result.get(ALLERRORORVALIDATEINFO);
        int billCount = Integer.parseInt(result.get(BILLCOUNT).toString());
        String msg = result.get(MESSAGE).toString();
        List successPkIds = (List)result.get(SUCCESSPKIDS);
        OperationResult operationResult = ItemSaleContentUtils.createOperationResult(billCount, successPkIds, new ArrayList<OperateErrorInfo>(), true, msg);
        if (successPkIds.size() < billCount) {
            operationResult.setSuccess(false);
        }
        for (Map operateErrorInfo : allErrorOrValidateInfo) {
            Object pkValue = operateErrorInfo.get("pkValue");
            Object entryId = operateErrorInfo.get("entryId");
            Object detailId = operateErrorInfo.get("detailId");
            String entityKey = (String)operateErrorInfo.get("entityKey");
            String errorCode = operateErrorInfo.get("errorCode").toString();
            int rowIndex = (Integer)operateErrorInfo.get("rowIndex");
            String title = (String)operateErrorInfo.get("title");
            String message = (String)operateErrorInfo.get(MESSAGE);
            OperateErrorInfo ErrorInfo = new OperateErrorInfo(errorCode, ErrorLevel.FatalError, pkValue, entryId, detailId);
            ErrorInfo.setTitle(title);
            ErrorInfo.setMessage(message);
            operationResult.addErrorInfo(ErrorInfo);
        }
        return operationResult;
    }

    public static String operationResult2JsonStr(OperationResult result) {
        List allErrorOrValidateInfo = result.getAllErrorOrValidateInfo();
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put(ALLERRORORVALIDATEINFO, allErrorOrValidateInfo);
        resultMap.put(BILLCOUNT, result.getBillCount());
        resultMap.put(SUCCESSPKIDS, result.getSuccessPkIds());
        resultMap.put(MESSAGE, result.getMessage());
        String resultStr = SerializationUtils.toJsonString(resultMap);
        return resultStr;
    }

    public static OperationResult createOperationResult(int billCount, List<Object> SuccessPkIds, List<OperateErrorInfo> OperateErrorInfos, boolean showMessage, String message) {
        OperationResult operationResult = new OperationResult();
        operationResult.setBillCount(billCount);
        operationResult.setSuccessPkIds(SuccessPkIds);
        operationResult.setShowMessage(showMessage);
        operationResult.setAllErrorInfo(OperateErrorInfos);
        operationResult.setMessage(message);
        return operationResult;
    }

    public static void updateItemContentHead(String op, DynamicObject[] datas) {
        if (datas == null || datas.length == 0) {
            return;
        }
        try {
            HashMap<String, DynamicObject> keymap = new HashMap<String, DynamicObject>(datas.length);
            StringBuilder key = new StringBuilder();
            ArrayList<DynamicObject> saveData = new ArrayList<DynamicObject>(datas.length);
            ArrayList<Object> delIds = new ArrayList<Object>(datas.length);
            DynamicObject exist = null;
            String headentityNum = "";
            String entityNum = "";
            MainEntityType dataEntityType = (MainEntityType)datas[0].getDataEntityType();
            entityNum = dataEntityType.getName();
            headentityNum = ItemSaleContentUtils.getHeadEntityNum(entityNum);
            long[] dbIds = DB.genGlobalLongIds((int)datas.length);
            int index = 0;
            block21: for (DynamicObject dynamicObject : datas) {
                Long createorgid = DynamicObjectUtils.getPkValue(dynamicObject, "createorg");
                Long currencyid = DynamicObjectUtils.getPkValue(dynamicObject, "currency");
                Long customerid = DynamicObjectUtils.getPkValue(dynamicObject, "customer");
                Long itemid = DynamicObjectUtils.getPkValue(dynamicObject, "item");
                Long spuid = DynamicObjectUtils.getPkValue(dynamicObject, "spuid");
                if (!((Object)spuid).equals(0L)) {
                    itemid = 0L;
                }
                Object headid = dynamicObject.get("headid");
                switch (op) {
                    case "save": {
                        QFilter filter;
                        key.setLength(0);
                        key.append(createorgid).append('_').append(currencyid).append('_').append(customerid).append('_').append(itemid).append('_').append(spuid);
                        if (keymap.containsKey(key.toString())) {
                            exist = (DynamicObject)keymap.get(key.toString());
                        } else {
                            filter = new QFilter("createorgid", "=", (Object)createorgid);
                            filter.and("currencyid", "=", (Object)currencyid);
                            filter.and("customerid", "=", (Object)customerid);
                            filter.and("itemid", "=", (Object)itemid);
                            filter.and("spuid", "=", (Object)spuid);
                            exist = BusinessDataServiceHelper.loadSingle((String)headentityNum, (String)ORMUtil.appendFieldsToStr((String[])new String[]{"createorgid", "currencyid", "customerid", "itemid", "spuid", "minmemberprice", "maxmemberprice", "maxretailprice", "maxretailprice", "minretailprice"}), (QFilter[])filter.toArray());
                            if (exist != null) {
                                keymap.put(key.toString(), exist);
                            } else {
                                exist = BusinessDataServiceHelper.newDynamicObject((String)headentityNum);
                                exist.set("id", (Object)dbIds[index++]);
                                exist.set(DynamicObjectUtils.append_Id("createorgid"), (Object)createorgid);
                                exist.set(DynamicObjectUtils.append_Id("currencyid"), (Object)currencyid);
                                exist.set(DynamicObjectUtils.append_Id("customerid"), (Object)customerid);
                                exist.set(DynamicObjectUtils.append_Id("itemid"), (Object)itemid);
                                exist.set(DynamicObjectUtils.append_Id("spuid"), (Object)spuid);
                            }
                            keymap.put(key.toString(), exist);
                            saveData.add(exist);
                        }
                        dynamicObject.set("headid", exist.getPkValue());
                        if (exist.getBigDecimal("minretailprice").compareTo(BigDecimal.ZERO) == 0) {
                            exist.set("minretailprice", (Object)dynamicObject.getBigDecimal("retailprice"));
                        } else if (exist.getBigDecimal("minretailprice").compareTo(dynamicObject.getBigDecimal("retailprice")) > 0) {
                            exist.set("minretailprice", (Object)dynamicObject.getBigDecimal("retailprice"));
                        }
                        if (exist.getBigDecimal("maxretailprice").compareTo(BigDecimal.ZERO) == 0) {
                            exist.set("maxretailprice", (Object)dynamicObject.getBigDecimal("retailprice"));
                        } else if (exist.getBigDecimal("maxretailprice").compareTo(dynamicObject.getBigDecimal("retailprice")) < 0) {
                            exist.set("maxretailprice", (Object)dynamicObject.getBigDecimal("retailprice"));
                        }
                        if (exist.getBigDecimal("minmemberprice").compareTo(BigDecimal.ZERO) == 0) {
                            exist.set("minmemberprice", (Object)dynamicObject.getBigDecimal("memberprice"));
                        } else if (exist.getBigDecimal("minmemberprice").compareTo(dynamicObject.getBigDecimal("memberprice")) > 0) {
                            exist.set("minmemberprice", (Object)dynamicObject.getBigDecimal("memberprice"));
                        }
                        if (exist.getBigDecimal("maxmemberprice").compareTo(BigDecimal.ZERO) == 0) {
                            exist.set("maxmemberprice", (Object)dynamicObject.getBigDecimal("memberprice"));
                            continue block21;
                        }
                        if (exist.getBigDecimal("maxmemberprice").compareTo(dynamicObject.getBigDecimal("memberprice")) >= 0) continue block21;
                        exist.set("maxmemberprice", (Object)dynamicObject.getBigDecimal("memberprice"));
                        continue block21;
                    }
                    case "change": {
                        key.setLength(0);
                        key.append(createorgid).append('_').append(currencyid).append('_').append(customerid).append('_').append(itemid).append('_').append(spuid);
                        if (keymap.containsKey(key.toString())) {
                            exist = (DynamicObject)keymap.get(key.toString());
                            continue block21;
                        }
                        QFilter filter = new QFilter("createorgid", "=", (Object)createorgid);
                        filter.and("currencyid", "=", (Object)currencyid);
                        filter.and("customerid", "=", (Object)customerid);
                        filter.and("itemid", "=", (Object)itemid);
                        filter.and("spuid", "=", (Object)spuid);
                        exist = BusinessDataServiceHelper.loadSingle((String)headentityNum, (String)ORMUtil.appendFieldsToStr((String[])new String[]{"createorgid", "currencyid", "customerid", "itemid", "spuid", "minmemberprice", "maxmemberprice", "maxretailprice", "maxretailprice", "minretailprice"}), (QFilter[])filter.toArray());
                        keymap.put(key.toString(), exist);
                        saveData.add(exist);
                        QFilter idfiter2 = new QFilter("headid", "=", headid);
                        String maxmemberprice = "max(memberprice) as maxmemberprice";
                        String minmemberprice = "min(memberprice) as minmemberprice";
                        String maxretailprice = "max(retailprice) as maxretailprice";
                        String minretailprice = "min(retailprice) as minretailprice";
                        DynamicObjectCollection dbMaxMins = QueryServiceHelper.query((String)entityNum, (String)ORMUtil.appendFieldsToStr((String[])new String[]{maxmemberprice, maxretailprice, minmemberprice, minretailprice}), (QFilter[])idfiter2.toArray());
                        if (CollectionUtils.isEmpty((Collection)dbMaxMins)) continue block21;
                        DynamicObject dbMax = (DynamicObject)dbMaxMins.get(0);
                        exist.set("maxmemberprice", (Object)dbMax.getBigDecimal("maxmemberprice"));
                        exist.set("minmemberprice", (Object)dbMax.getBigDecimal("minmemberprice"));
                        exist.set("maxretailprice", (Object)dbMax.getBigDecimal("maxretailprice"));
                        exist.set("minretailprice", (Object)dbMax.getBigDecimal("minretailprice"));
                        continue block21;
                    }
                    case "delete": {
                        if (delIds.contains(headid)) continue block21;
                        QFilter idfiter = new QFilter("headid", "=", headid);
                        Set ids = Arrays.asList(datas).stream().filter(m -> headid.equals(m.get("headid"))).map(m -> m.get("id")).collect(Collectors.toSet());
                        DynamicObjectCollection dbDys = QueryServiceHelper.query((String)entityNum, (String)ORMUtil.appendFieldsToStr((String[])new String[]{"id", "headid", "memberprice", "retailprice"}), (QFilter[])idfiter.toArray());
                        if (!(CollectionUtils.isEmpty((Collection)dbDys) || CollectionUtils.isEmpty(ids) || dbDys.size() != ids.size() || StringUtils.isEmpty((Object)headid))) {
                            delIds.add(headid);
                            continue block21;
                        }
                        List exists = saveData.stream().filter(m -> headid.equals(m.getPkValue())).collect(Collectors.toList());
                        if (!CollectionUtils.isEmpty(exists)) continue block21;
                        exist = BusinessDataServiceHelper.loadSingle((Object)headid, (String)headentityNum, (String)ORMUtil.appendFieldsToStr((String[])new String[]{"id", "minmemberprice", "minretailprice", "maxmemberprice", "maxretailprice"}));
                        List<DynamicObject> contentList = dbDys.stream().filter(m -> !ids.contains(m.get("id"))).collect(Collectors.toList());
                        ItemSaleContentUtils.updateMaxandMinprice(exist, contentList);
                        saveData.add(exist);
                        continue block21;
                    }
                }
            }
            switch (op) {
                case "save": 
                case "change": {
                    if (CollectionUtils.isEmpty(saveData)) break;
                    SaveServiceHelper.save((DynamicObject[])saveData.toArray(new DynamicObject[saveData.size()]));
                    break;
                }
                case "delete": {
                    if (!CollectionUtils.isEmpty(saveData)) {
                        SaveServiceHelper.save((DynamicObject[])saveData.toArray(new DynamicObject[saveData.size()]));
                    }
                    if (CollectionUtils.isEmpty(delIds)) break;
                    MainEntityType headEntityType = MetadataServiceHelper.getDataEntityType((String)headentityNum);
                    DeleteServiceHelper.delete((IDataEntityType)headEntityType, (Object[])delIds.toArray(new Object[delIds.size()]));
                }
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            throw e;
        }
    }

    private static void updateMaxandMinprice(DynamicObject head, List<DynamicObject> contentList) {
        DynamicObject minmemberpriceDy = Collections.min(contentList, new Comparator<DynamicObject>(){

            @Override
            public int compare(DynamicObject o1, DynamicObject o2) {
                return o1.getBigDecimal("memberprice").compareTo(o2.getBigDecimal("memberprice"));
            }
        });
        head.set("minmemberprice", (Object)minmemberpriceDy.getBigDecimal("memberprice"));
        DynamicObject minretailpriceDy = Collections.min(contentList, new Comparator<DynamicObject>(){

            @Override
            public int compare(DynamicObject o1, DynamicObject o2) {
                return o1.getBigDecimal("retailprice").compareTo(o2.getBigDecimal("retailprice"));
            }
        });
        head.set("minretailprice", (Object)minretailpriceDy.getBigDecimal("retailprice"));
        DynamicObject maxmemberpriceDy = Collections.max(contentList, new Comparator<DynamicObject>(){

            @Override
            public int compare(DynamicObject o1, DynamicObject o2) {
                return o1.getBigDecimal("memberprice").compareTo(o2.getBigDecimal("memberprice"));
            }
        });
        head.set("maxmemberprice", (Object)maxmemberpriceDy.getBigDecimal("memberprice"));
        DynamicObject maxretailpriceDy = Collections.max(contentList, new Comparator<DynamicObject>(){

            @Override
            public int compare(DynamicObject o1, DynamicObject o2) {
                return o1.getBigDecimal("retailprice").compareTo(o2.getBigDecimal("retailprice"));
            }
        });
        head.set("maxretailprice", (Object)maxretailpriceDy.getBigDecimal("retailprice"));
    }

    public static String getEntityNum(String name) {
        String entityNum = "";
        switch (name) {
            case "dbd_itemsale_publish": 
            case "dbd_item_pricechange": 
            case "dbd_itemcontent_head": {
                entityNum = "dbd_itemsale_content";
                break;
            }
            case "olmm_itemsale_publish": 
            case "olmm_item_pricechange": 
            case "olmm_itemcontent_head": {
                entityNum = "olmm_itemsale_content";
            }
        }
        return entityNum;
    }

    public static String getHeadEntityNum(String name) {
        String entityNum = "";
        switch (name) {
            case "dbd_itemsale_publish": 
            case "dbd_item_pricechange": 
            case "dbd_itemsale_content": {
                entityNum = "dbd_itemcontent_head";
                break;
            }
            case "olmm_itemsale_publish": 
            case "olmm_item_pricechange": 
            case "olmm_itemsale_content": {
                entityNum = "olmm_itemcontent_head";
            }
        }
        return entityNum;
    }

    public static String getValidateCustomerMsg(String entityNum) {
        String msg = "";
        switch (entityNum) {
            case "dbd_itemsale_content": {
                msg = "\u95e8\u5e97";
                break;
            }
            case "olmm_itemsale_content": {
                msg = "\u5546\u57ce";
                break;
            }
        }
        return msg;
    }

    public static QFilter getCustomerTypeQfiter(String entityNum) {
        QFilter qFilter = null;
        switch (entityNum) {
            case "dbd_itemsale_content": {
                qFilter = new QFilter("isstore", "=", (Object)"1");
                break;
            }
            case "olmm_itemsale_content": {
                qFilter = new QFilter("customertype.typeid", "=", (Object)"H");
                break;
            }
        }
        return qFilter;
    }
}

