/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dbd.common.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.drp.dbd.common.util.F7Utils;

public class OwnerUtils {
    public static Long getDefaultOwnerId(boolean isStore) {
        List<Long> lstOwnerIds = OwnerUtils.getOwnerIds(isStore);
        return CollectionUtils.isEmpty(lstOwnerIds) ? Long.valueOf(0L) : lstOwnerIds.get(0);
    }

    public static List<Long> getOwnerIds(boolean isstore) {
        DynamicObjectCollection datas;
        String useridStr = RequestContext.get().getUserId();
        Long userId = 0L;
        if (useridStr != null && useridStr.trim().length() > 0) {
            userId = Long.valueOf(useridStr);
        }
        QFilter filter = new QFilter("sysuser", "=", (Object)userId);
        filter.and("enable", "=", (Object)"1");
        Map userInfos = BusinessDataServiceHelper.loadFromCache((String)"dbd_drp_user", (QFilter[])filter.toArray());
        ArrayList<Long> owners = new ArrayList<Long>(userInfos.size());
        if (userInfos.isEmpty()) {
            return owners;
        }
        long defaultOwnerId = 0L;
        for (DynamicObject userInfo : userInfos.values()) {
            DynamicObject owner = userInfo.getDynamicObject("owner");
            if (owner == null) continue;
            long ownerId = owner.getLong("id");
            if (defaultOwnerId == 0L && userInfo.getBoolean("isdefault")) {
                defaultOwnerId = ownerId;
            }
            owners.add(ownerId);
        }
        filter = F7Utils.getCommonStatusFilter();
        filter.and("id", "in", owners);
        if (isstore) {
            filter.and("isstore", "=", (Object)Boolean.TRUE);
        }
        if ((datas = QueryServiceHelper.query((String)"mdr_customer", (String)"id", (QFilter[])filter.toArray())) == null || datas.isEmpty()) {
            return null;
        }
        ArrayList<Long> ownerIds = new ArrayList<Long>(datas.size());
        for (DynamicObject item : datas) {
            long itemId = item.getLong("id");
            if (defaultOwnerId == itemId) {
                ownerIds.add(0, itemId);
                continue;
            }
            ownerIds.add(itemId);
        }
        return ownerIds;
    }
}

