/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dbd.enums;

import java.util.Arrays;
import java.util.List;

public enum PaymentModeEnum {
    wechatpay(1L, "wechatpay"),
    alipay(2L, "alipay"),
    cashpay(3L, "cashpay"),
    coupon(4L, "coupon"),
    bankcard(5L, "bankcard"),
    deliverycard(6L, "deliverycard"),
    clearprice(7L, "clearprice"),
    pointspaid(8L, "pointspaid"),
    creditpay(15L, "tosettleaccounts"),
    deposit(14L, "deposit");

    private long key;
    private String paymentType;

    private PaymentModeEnum(long key, String paymentType) {
        this.key = key;
        this.paymentType = paymentType;
    }

    public static String getName(long key) {
        for (PaymentModeEnum paymentMode : PaymentModeEnum.values()) {
            if (paymentMode.getKey() != key) continue;
            return paymentMode.getPaymentType();
        }
        return "";
    }

    public static long getKey(String value) {
        for (PaymentModeEnum paymentMode : PaymentModeEnum.values()) {
            if (!paymentMode.getPaymentType().equals(value)) continue;
            return paymentMode.getKey();
        }
        return 0L;
    }

    public long getKey() {
        return this.key;
    }

    public String getPaymentType() {
        return this.paymentType;
    }

    public static List<Long> getNoElectricPayList() {
        return Arrays.asList(3L, 4L, 7L, 14L, 15L);
    }
}

