/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dbd.utils;

import java.util.Calendar;
import java.util.Date;

public class CalendarUtil {
    public static int calculateDayInterval(Date startDate, Date endDate) {
        Calendar startCal = Calendar.getInstance();
        startCal.setTime(startDate);
        Calendar endCal = Calendar.getInstance();
        endCal.setTime(endDate);
        long diff = endCal.getTimeInMillis() - startCal.getTimeInMillis();
        Long day = diff / 86400000L;
        Long hour = diff / 3600000L - 24L * day;
        Long min = diff / 60000L - 1440L * day - 60L * hour;
        Long second = diff / 1000L - day * 24L * 60L * 60L - hour * 60L * 60L - min * 60L;
        int dayDiff = hour > 0L || min > 0L || second > 0L ? 1 : 0;
        return day.intValue() + dayDiff;
    }

    public static Date getDayStartTime(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 1);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date getDayEndTime(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date calculateDayAdd(Date date, int relativeDays) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(6, relativeDays);
        return calendar.getTime();
    }
}

