/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dbd.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.drp.dbd.utils.F7Util;

public class OwnerUtil {
    private static final String KEY_OWNERS = "owners";
    private static final String KEY_OWNER = "owner";
    private static final String DRP_USER_DT = "dbd_drp_user";
    private static final String MDR_CUSTOMER_DT = "mdr_customer";
    private static final String KEY_ENABLE = "enable";
    private static final String KEY_SYSUSER = "sysuser";
    private static final String KEY_ISDEFAULT = "isdefault";
    private static final String KEY_ISSTORE = "isstore";
    private static final String KEY_BIZGROUP = "bizgroup.Id";

    public static Object getDefaultOwnerId(List<Object> ownerIds) {
        return ownerIds.isEmpty() ? Long.valueOf(0L) : ownerIds.get(0);
    }

    public static List<Object> getOwnerIds(long orgId, boolean isDefualtBranch) {
        QFilter filter = new QFilter(KEY_SYSUSER, "=", (Object)RequestContext.get().getUserId());
        filter.and(KEY_ENABLE, "=", (Object)"1");
        Map users = BusinessDataServiceHelper.loadFromCache((String)DRP_USER_DT, (QFilter[])filter.toArray());
        ArrayList<Object> owners = new ArrayList<Object>(users.size());
        if (users.isEmpty()) {
            return owners;
        }
        Object defaultOwnerId = null;
        for (DynamicObject userInfo : users.values()) {
            DynamicObject owner = userInfo.getDynamicObject(KEY_OWNER);
            if (owner == null) continue;
            Object ownerId = owner.getPkValue();
            if (defaultOwnerId == null && userInfo.getBoolean(KEY_ISDEFAULT)) {
                defaultOwnerId = ownerId;
                continue;
            }
            owners.add(ownerId);
        }
        if (defaultOwnerId != null) {
            owners.add(0, defaultOwnerId);
        }
        filter = F7Util.getCommonStatusFilter().and("Id", "in", owners).and(KEY_ISSTORE, "=", (Object)Boolean.TRUE).and(KEY_BIZGROUP, "=", (Object)orgId);
        ArrayList<Object> ownerIds = new ArrayList<Object>();
        DynamicObjectCollection docData = QueryServiceHelper.query((String)MDR_CUSTOMER_DT, (String)"Id", (QFilter[])filter.toArray());
        if (docData == null || docData.isEmpty() || docData.size() == 0) {
            return ownerIds;
        }
        for (DynamicObject data : docData) {
            if (isDefualtBranch && defaultOwnerId != null && defaultOwnerId.equals(data.get("Id"))) {
                ownerIds.add(0, data.get("Id"));
                continue;
            }
            ownerIds.add(data.get("Id"));
        }
        return ownerIds;
    }

    public static QFilter getOwnerIdsFilter(long orgId) {
        QFilter filter = new QFilter(KEY_SYSUSER, "=", (Object)RequestContext.get().getUserId());
        filter.and(KEY_ENABLE, "=", (Object)"1");
        Map users = BusinessDataServiceHelper.loadFromCache((String)DRP_USER_DT, (QFilter[])filter.toArray());
        ArrayList<Object> owners = new ArrayList<Object>(users.size());
        if (users.isEmpty()) {
            return filter;
        }
        Object defaultOwnerId = null;
        for (DynamicObject userInfo : users.values()) {
            DynamicObject owner = userInfo.getDynamicObject(KEY_OWNER);
            if (owner == null) continue;
            Object ownerId = owner.getPkValue();
            if (defaultOwnerId == null && userInfo.getBoolean(KEY_ISDEFAULT)) {
                defaultOwnerId = ownerId;
                continue;
            }
            owners.add(ownerId);
        }
        if (defaultOwnerId != null) {
            owners.add(0, defaultOwnerId);
        }
        filter = F7Util.getCommonStatusFilter().and("Id", "in", owners).and(KEY_ISSTORE, "=", (Object)Boolean.TRUE).and(KEY_BIZGROUP, "=", (Object)orgId);
        return filter;
    }
}

