/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dma.formplugin.index;

import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Control;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.orm.query.QFilter;
import kd.drp.mdr.common.f7.F7Utils;
import kd.drp.mdr.common.model.CheckResult;
import kd.drp.mdr.common.util.CustomerUtil;
import kd.drp.mdr.common.util.SysParamsUtil;
import kd.drp.mdr.common.util.UserUtil;
import kd.drp.mdr.common.util.WarehouseRuleUtil;
import kd.drp.mdr.formplugin.MdrFormMobPlugin;
import org.apache.commons.lang3.StringUtils;

public class CustomerChangeMobPlugin
extends MdrFormMobPlugin
implements BeforeF7SelectListener {
    private static final String COMMIT = "commit";
    private static final String CANCEL = "cancel";
    protected static final String CACHE_KEY_USEWAREHOUSERULE = "cache_key_usewarehouserule";

    public void afterCreateNewData(EventObject e) {
        if (this.getParameter("isInit") != null) {
            this.initCustomer();
            this.setDisVisible(new String[]{CANCEL});
        } else {
            this.getModel().setValue("customer", this.getParameter("customerid"));
            this.getModel().setValue("owner", this.getParameter("ownerid"));
            this.getModel().setValue("warehouse", this.getParameter("warehouseid"));
        }
    }

    private void initCustomer() {
        List customerIds = UserUtil.getOwnerIDs();
        if (customerIds == null || customerIds.size() == 0) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"customer", "owner", "warehouse"});
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u6ca1\u6709\u6240\u5c5e\u6e20\u9053\uff0c\u65e0\u6cd5\u4f7f\u7528\u5fae\u5546\u57ce", (String)"CustomerChangeMobPlugin_0", (String)"drp-dma-formplugin", (Object[])new Object[0]));
        } else {
            boolean isMatch = false;
            for (Object customerId : customerIds) {
                List ownerids = CustomerUtil.getAuthOwnerIDs(customerId);
                if (ownerids == null || ownerids.size() == 0) continue;
                this.getModel().setValue("customer", customerId);
                this.getModel().setValue("owner", ownerids.get(0));
                isMatch = true;
                break;
            }
            if (!isMatch) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"customer", "owner", "warehouse"});
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u662f\u4f01\u4e1a\u7528\u6237\u4e0d\u53ef\u4ee5\u8ba2\u8d27\uff0c\u5982\u9700\u4ee3\u5ba2\u4e0b\u5355\u8bf7\u4f7f\u7528\u9500\u552e\u52a9\u624b", (String)"CustomerChangeMobPlugin_1", (String)"drp-dma-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{COMMIT, CANCEL});
        this.addF7Listener(this, new String[]{"owner", "customer", "warehouse"});
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control control = (Control)evt.getSource();
        switch (key = control.getKey()) {
            case "commit": {
                Map param = this.getView().getFormShowParameter().getCustomParams();
                Object customerid = this.getCustomerF7PKValue();
                if (customerid == null) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8981\u8d27\u6e20\u9053\uff01", (String)"CustomerChangeMobPlugin_2", (String)"drp-dma-formplugin", (Object[])new Object[0]));
                    return;
                }
                Object ownerid = this.getOwnerF7PKValue();
                if (ownerid == null) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f9b\u8d27\u6e20\u9053\uff01", (String)"CustomerChangeMobPlugin_3", (String)"drp-dma-formplugin", (Object[])new Object[0]));
                    return;
                }
                Object warehouseid = this.getF7PKValue("warehouse");
                param.put("customerid", customerid);
                param.put("ownerid", ownerid);
                param.put("warehouseid", warehouseid);
                this.getView().returnDataToParent((Object)param);
                this.getView().close();
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key;
        switch (key = e.getProperty().getName()) {
            case "owner": {
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)this.getOwnerFitler());
                break;
            }
            case "customer": {
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)this.getCustomerFitler());
                break;
            }
            case "warehouse": {
                CheckResult re = this.checkCustomerBeforeSelect();
                if (re.isSuccess()) {
                    F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)this.getWareHouseFilter());
                    break;
                }
                this.getView().showErrorNotification(re.getMsg());
                e.setCancel(true);
                return;
            }
        }
    }

    private QFilter getOwnerFitler() {
        List<Object> ownerIds = this.getOwnerIDs();
        return new QFilter("id", "in", ownerIds);
    }

    private List<Object> getOwnerIDs() {
        List ownerids = CustomerUtil.getAuthOwnerIDs((Object)this.getCustomerF7PKValue());
        if (ownerids.isEmpty()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4f01\u4e1a\u7528\u6237\uff0c\u4e0d\u80fd\u8981\u8d27\uff01\u8bf7\u5207\u6362\u6e20\u9053", (String)"CustomerChangeMobPlugin_4", (String)"drp-dma-formplugin", (Object[])new Object[0]));
        }
        return ownerids;
    }

    private QFilter getCustomerFitler() {
        return new QFilter("id", "in", (Object)UserUtil.getOwnerIDs());
    }

    private QFilter getWareHouseFilter() {
        if (!this.isUseWareHouseRule()) {
            return this.getWareFilterByCustomer(this.getOwnerF7PKValue());
        }
        List ids = WarehouseRuleUtil.getWarehouseList((Object)this.getOwnerF7PKValue(), (Object)this.getCustomerF7PKValue());
        if (ids.isEmpty()) {
            return this.getWareFilterByCustomer(this.getOwnerF7PKValue());
        }
        return new QFilter("id", "in", (Object)ids);
    }

    private QFilter getWareFilterByCustomer(Object customerId) {
        List list = WarehouseRuleUtil.queryWarehouse((Object)customerId);
        if (list.isEmpty()) {
            return new QFilter("id", "=", (Object)0L);
        }
        return new QFilter("id", "in", (Object)list);
    }

    protected boolean isUseWareHouseRule() {
        IPageCache pc = this.getPageCache();
        String value = pc.get(CACHE_KEY_USEWAREHOUSERULE);
        if (StringUtils.isEmpty((CharSequence)value)) {
            Boolean useWareHouseRule = SysParamsUtil.isUseWareHouseRule();
            value = useWareHouseRule.toString();
            pc.put(CACHE_KEY_USEWAREHOUSERULE, value);
        }
        return Boolean.parseBoolean(value);
    }

    private CheckResult checkCustomerBeforeSelect() {
        if (this.getCustomerF7Value() == null) {
            return CheckResult.returnFalse((String)ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8981\u8d27\u6e20\u9053\uff01", (String)"CustomerChangeMobPlugin_2", (String)"drp-dma-formplugin", (Object[])new Object[0]));
        }
        if (this.getOwnerF7Value() == null) {
            return CheckResult.returnFalse((String)ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f9b\u8d27\u6e20\u9053\uff01", (String)"CustomerChangeMobPlugin_3", (String)"drp-dma-formplugin", (Object[])new Object[0]));
        }
        return CheckResult.returnTrue();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        if (!this.triggerChangeEvent) {
            return;
        }
        this.triggerChangeEvent = false;
        switch (key = e.getProperty().getName()) {
            case "customer": {
                this.getModel().setValue("owner", null);
                this.getModel().setValue("warehouse", null);
                this.setOwnerValue();
                break;
            }
            case "owner": {
                this.getModel().setValue("warehouse", null);
                break;
            }
            default: {
                this.triggerChangeEvent = true;
            }
        }
    }

    private void setOwnerValue() {
        List ownerIds = CustomerUtil.getAuthOwnerIDs((Object)this.getCustomerF7PKValue());
        if (ownerIds != null && !ownerIds.isEmpty()) {
            this.getModel().setValue("owner", ownerIds.get(0));
        } else {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4f01\u4e1a\u7528\u6237\uff0c\u4e0d\u80fd\u8981\u8d27\uff01\u8bf7\u5207\u6362\u6e20\u9053", (String)"CustomerChangeMobPlugin_4", (String)"drp-dma-formplugin", (Object[])new Object[0]));
        }
    }
}

