/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dma.formplugin.index;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.drp.mdr.common.util.BalanceUtil;
import kd.drp.mdr.formplugin.MdrFormMobPlugin;
import kd.drp.mdr.mobile.MobileControlUtils;
import kd.drp.mdr.mobile.model.FormModel;

public class DmaMobileMinePlugin
extends MdrFormMobPlugin {
    protected static final String USERPHOTO = "userphoto";
    protected static final String USERNAME = "username";
    protected static final String USERTEL = "usertel";
    protected static final String CUSTOMERSERVICETEL = "customservicetel";
    protected static final String MYBALANCE = "mybalance";
    protected static final String MYREBATE = "myrebate";
    protected static final String MYCREDIT = "mycredit";
    protected static final String MYSTORE = "mystore";
    protected static final String PROMOTIONINFO = "promotioninfo";
    protected static final String MYKDPAY = "mykdpay";
    protected static final String MYADDRESS = "myaddress";
    protected static final String MYRECEIPT = "myreceipt";
    protected static final String MYCOMPANY = "mycompany";
    protected static final String CONFIGURATION = "configuration";
    protected static final String ABOUT = "about";
    protected static final String LOGOUT = "logout";
    protected static final String SWITCH = "switch";
    public static final String MORE_ORDER = "all_order";
    public static final String OFT_UNPAIDORDER = "unpaidorder";
    public static final String OFT_UNRECEIVEORDER = "unreceiveorder";
    public static final String OFT_UNSHIPORDER = "unshipoder";
    public static final String OFT_SUBMITORDER = "submitorder";
    public static final String REBATE_AMOUNT = "rebateamount";
    public static final String LABEL_REBATE_AMOUNT = "rebateamountlabel";
    public static final String LABEL_REBATE_AMOUNT_FLEX = "rebateamountflex";
    public static final String UNPAID_AMOUNT = "unpaidamount";
    public static final String LABEL_UNPAID_AMOUNT = "unpaidamountlabel";
    public static final String LABEL_UNPAID_AMOUNT_FLEX = "unpaidamountflex";
    public static final String PRE_COLLECTION = "precollection";
    public static final String LABEL_PRE_COLLECTION = "precollectionlabel";
    public static final String LABEL_PRE_COLLECTION_FLEX = "precollectionlabelflex";
    public static final String LOAN_BALANCE = "loanbalance";
    public static final String LABEL_LOAN_BALANCE = "loanbalancelabel";
    public static final String LABEL_LOAN_BALANCE_FLEX = "loanbalanceflex";
    public static final String OWNERID = "ownerid";
    public static final String CUSTOMERID = "customerid";
    public static final String WAREHOUSEID = "warehouseid";
    private static final String DMAFORMPLUGIN = "drp-dma-formplugin";
    private static final String DMAMOBILEMINEPLUGIN_0 = "DmaMobileMinePlugin_0";
    public static final String AMOUNTTOBEPID = "amounttobepaid";
    public static final String CUSTOMER = "customer";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{MYBALANCE, MYREBATE, MYCREDIT, MYSTORE, PROMOTIONINFO, MYKDPAY, MYADDRESS, MYRECEIPT, MYCOMPANY, CONFIGURATION, ABOUT, LOGOUT, SWITCH, MORE_ORDER, OFT_UNPAIDORDER, OFT_UNRECEIVEORDER, OFT_UNSHIPORDER, OFT_SUBMITORDER, REBATE_AMOUNT, LABEL_REBATE_AMOUNT, LABEL_UNPAID_AMOUNT_FLEX, PRE_COLLECTION, LABEL_PRE_COLLECTION, LABEL_PRE_COLLECTION_FLEX, LOAN_BALANCE, LABEL_LOAN_BALANCE, LABEL_LOAN_BALANCE_FLEX, UNPAID_AMOUNT, LABEL_UNPAID_AMOUNT, LABEL_UNPAID_AMOUNT_FLEX});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initUserInfo();
        this.setOwnerF7Value(this.getParameter(OWNERID));
        this.setCustomerF7Value(this.getParameter(CUSTOMERID));
        this.setF7Value("warehouse", this.getParameter(WAREHOUSEID));
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initOrderInfo();
        this.initAccount();
    }

    protected void initUserInfo() {
        Long userId = UserServiceHelper.getCurrentUserId();
        this.initUserPhoto(userId);
        Map userInfo = UserServiceHelper.getUserInfoByID((long)userId);
        MobileControlUtils.LabelSetValue((Label)((Label)this.getControl(USERNAME)), (Object)userInfo.get("name").toString());
        MobileControlUtils.LabelSetValue((Label)((Label)this.getControl(USERTEL)), (Object)userInfo.get("phone").toString());
    }

    protected void initUserPhoto(Long userId) {
        QFilter filter = new QFilter("id", "=", (Object)userId);
        DynamicObject result = QueryServiceHelper.queryOne((String)"bos_user", (String)"picturefield", (QFilter[])filter.toArray());
        String userPhoto = (String)result.get("picturefield");
        Image userphoto = (Image)this.getControl(USERPHOTO);
        userphoto.setUrl(userPhoto);
    }

    protected void initOrderInfo() {
        this.setOrderCount(OFT_SUBMITORDER);
        this.setOrderCount(OFT_UNPAIDORDER);
        this.setOrderCount(OFT_UNRECEIVEORDER);
        this.setOrderCount(OFT_UNSHIPORDER);
    }

    protected void initAccount() {
        Object ownerid = this.getOwnerF7PKValue();
        Object customerid = this.getCustomerF7PKValue();
        MobileControlUtils.LabelSetValue((Label)((Label)this.getControl(UNPAID_AMOUNT)), (Object)"0");
        MobileControlUtils.LabelSetValue((Label)((Label)this.getControl(PRE_COLLECTION)), (Object)(ResManager.loadKDString((String)"\u53ef\u7528 ", (String)DMAMOBILEMINEPLUGIN_0, (String)DMAFORMPLUGIN, (Object[])new Object[0]) + 0));
        MobileControlUtils.LabelSetValue((Label)((Label)this.getControl(REBATE_AMOUNT)), (Object)(ResManager.loadKDString((String)"\u53ef\u7528 ", (String)DMAMOBILEMINEPLUGIN_0, (String)DMAFORMPLUGIN, (Object[])new Object[0]) + 0));
        MobileControlUtils.LabelSetValue((Label)((Label)this.getControl(LOAN_BALANCE)), (Object)(ResManager.loadKDString((String)"\u53ef\u7528 ", (String)DMAMOBILEMINEPLUGIN_0, (String)DMAFORMPLUGIN, (Object[])new Object[0]) + 0));
        if (ownerid == null || customerid == null) {
            return;
        }
        DecimalFormat df4 = new DecimalFormat("#,##0.00");
        MobileControlUtils.LabelSetValue((Label)((Label)this.getControl(UNPAID_AMOUNT)), (Object)("" + df4.format(this.countUpaidOrder())));
        MobileControlUtils.LabelSetValue((Label)((Label)this.getControl(PRE_COLLECTION)), (Object)(ResManager.loadKDString((String)"\u53ef\u7528 ", (String)DMAMOBILEMINEPLUGIN_0, (String)DMAFORMPLUGIN, (Object[])new Object[0]) + 0));
        DynamicObject balanceinfo = BalanceUtil.getBalanceInfo((Object)ownerid, (Object)customerid, (boolean)true);
        if (balanceinfo != null) {
            MobileControlUtils.LabelSetValue((Label)((Label)this.getControl(PRE_COLLECTION)), (Object)(ResManager.loadKDString((String)"\u53ef\u7528 ", (String)DMAMOBILEMINEPLUGIN_0, (String)DMAFORMPLUGIN, (Object[])new Object[0]) + df4.format(balanceinfo.getBigDecimal("usable"))));
        }
        MobileControlUtils.LabelSetValue((Label)((Label)this.getControl(REBATE_AMOUNT)), (Object)(ResManager.loadKDString((String)"\u53ef\u7528 ", (String)DMAMOBILEMINEPLUGIN_0, (String)DMAFORMPLUGIN, (Object[])new Object[0]) + 0));
        try {
            Object rebateAmount = null;
            rebateAmount = DispatchServiceHelper.invokeBizService((String)"drp", (String)"drm", (String)"RebateService", (String)"getAccountBalance4Customer", (Object[])new Object[]{ownerid, customerid});
            MobileControlUtils.LabelSetValue((Label)((Label)this.getControl(REBATE_AMOUNT)), (Object)(ResManager.loadKDString((String)"\u53ef\u7528 ", (String)DMAMOBILEMINEPLUGIN_0, (String)DMAFORMPLUGIN, (Object[])new Object[0]) + df4.format(rebateAmount)));
        }
        catch (Exception e) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8fd4\u5229\u670d\u52a1\u6682\u4e0d\u53ef\u7528\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5", (String)"DmaMobileMinePlugin_1", (String)DMAFORMPLUGIN, (Object[])new Object[0]));
        }
    }

    private BigDecimal countUpaidOrder() {
        BigDecimal amounttobepaid = BigDecimal.ZERO;
        QFilter filter = new QFilter("paystatus", "=", (Object)"A").and(AMOUNTTOBEPID, ">", (Object)0).and("owner", "=", this.getOwnerF7PKValue()).and(CUSTOMER, "=", this.getCustomerF7PKValue());
        ORM orm = ORM.create();
        String queryField = "customer,amounttobepaid";
        try (DataSet saleInfo = orm.queryDataSet(((Object)((Object)this)).getClass().getName(), "bbc_saleorder", queryField, filter.toArray()).groupBy(new String[]{CUSTOMER}).sum(AMOUNTTOBEPID).finish();){
            while (saleInfo.hasNext()) {
                Row row = saleInfo.next();
                amounttobepaid = (BigDecimal)row.get(AMOUNTTOBEPID);
            }
        }
        return amounttobepaid;
    }

    private int setOrderCount(String filterType) {
        QFilter filter = null;
        switch (filterType) {
            case "submitorder": {
                filter = new QFilter("orderstatus", "=", (Object)"B");
                break;
            }
            case "unpaidorder": {
                filter = new QFilter("paystatus", "=", (Object)"A");
                break;
            }
            case "unreceiveorder": {
                filter = new QFilter("orderstatus", "in", (Object)new String[]{"E", "D"});
                break;
            }
            case "unshipoder": {
                filter = new QFilter("orderstatus", "in", (Object)new String[]{"C", "D"});
                break;
            }
        }
        if (filter == null) {
            filter = new QFilter("owner", "=", this.getOwnerF7PKValue());
        } else {
            filter.and(new QFilter("owner", "=", this.getOwnerF7PKValue()));
        }
        filter.and(new QFilter(CUSTOMER, "=", this.getCustomerF7PKValue()));
        ORM orm = ORM.create();
        int count = orm.count("MDR", "bbc_saleorder", filter.toArray());
        MobileControlUtils.LabelSetValue((Label)((Label)this.getControl(filterType)), (Object)("" + count));
        return count;
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control control = (Control)evt.getSource();
        switch (key = control.getKey()) {
            case "logout": {
                String source = (String)this.getParameter("source");
                this.logout(source);
                break;
            }
            case "switch": {
                MobileFormShowParameter parameter = new MobileFormShowParameter();
                parameter.getOpenStyle().setShowType(ShowType.Floating);
                parameter.setFormId("mdr_mobileindex");
                this.getView().showForm((FormShowParameter)parameter);
                break;
            }
            case "mystore": {
                this.clickMyStore(evt);
                break;
            }
            case "promotioninfo": {
                this.clickPromotionInfo(evt);
                break;
            }
            case "myaddress": {
                this.clickMyAdress(evt);
                break;
            }
            case "myreceipt": {
                this.clickMyReceipt(evt);
                break;
            }
            case "all_order": 
            case "submitorder": 
            case "unpaidorder": 
            case "unreceiveorder": 
            case "unshipoder": {
                this.clickOrder(evt, key);
                break;
            }
            case "unpaidamount": 
            case "unpaidamountlabel": 
            case "unpaidamountflex": {
                this.clickOrder(evt, OFT_UNPAIDORDER);
                break;
            }
            case "precollection": 
            case "precollectionlabel": 
            case "precollectionlabelflex": {
                this.clickMyBalance(evt);
                break;
            }
            case "loanbalance": 
            case "loanbalancelabel": 
            case "loanbalanceflex": {
                this.clickLoanBalance(evt);
                break;
            }
            case "rebateamount": 
            case "rebateamountlabel": 
            case "rebateamountflex": {
                this.clickMyRebateAmount(evt);
                break;
            }
        }
    }

    protected void clickOrder(EventObject evt, String key) {
        IFormView parentView = this.getView().getParentView();
        if (parentView != null) {
            parentView.getModel().setValue("orderfiltertype", (Object)key);
        }
        this.getView().sendFormAction(parentView);
    }

    protected void clickMyBalance(EventObject evt) {
        HashMap<String, Object> customParams = new HashMap<String, Object>();
        customParams.put(OWNERID, this.getOwnerF7PKValue());
        customParams.put(CUSTOMERID, this.getCustomerF7PKValue());
        new FormModel("dma_mybalance", ResManager.loadKDString((String)"\u6211\u7684\u9884\u6536\u6b3e\u4f59\u989d", (String)"DmaMobileMinePlugin_2", (String)DMAFORMPLUGIN, (Object[])new Object[0]), "5", false, customParams).showPage((AbstractFormPlugin)this);
    }

    protected void clickMyRebateAmount(EventObject evt) {
        HashMap<String, Object> customParams = new HashMap<String, Object>();
        customParams.put(OWNERID, this.getOwnerF7PKValue());
        customParams.put(CUSTOMERID, this.getCustomerF7PKValue());
        new FormModel("drm_myrebateaccount", ResManager.loadKDString((String)"\u6211\u7684\u8fd4\u5229\u4f59\u989d", (String)"DmaMobileMinePlugin_3", (String)DMAFORMPLUGIN, (Object[])new Object[0]), "5", false, customParams).showPage((AbstractFormPlugin)this);
    }

    protected void clickLoanBalance(EventObject evt) {
        this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6682\u672a\u5f00\u901a\u8d37\u6b3e\u529f\u80fd", (String)"DmaMobileMinePlugin_4", (String)DMAFORMPLUGIN, (Object[])new Object[0]));
    }

    protected void clickMyReceipt(EventObject evt) {
        HashMap<String, Object> customParams = new HashMap<String, Object>();
        customParams.put(OWNERID, this.getOwnerF7PKValue());
        customParams.put(CUSTOMERID, this.getCustomerF7PKValue());
        if (this.isCustomer()) {
            customParams.put("iscustomer", "true");
        }
        new FormModel("mdr_myreceipt_mobile", ResManager.loadKDString((String)"\u6211\u7684\u5f00\u7968\u4fe1\u606f", (String)"DmaMobileMinePlugin_5", (String)DMAFORMPLUGIN, (Object[])new Object[0]), "5", false, customParams).showPage((AbstractFormPlugin)this);
    }

    protected void clickMyAdress(EventObject evt) {
        HashMap<String, Object> customParams = new HashMap<String, Object>();
        customParams.put(OWNERID, this.getOwnerF7PKValue());
        customParams.put(CUSTOMERID, this.getCustomerF7PKValue());
        if (this.isCustomer()) {
            customParams.put("iscustomer", "true");
        }
        new FormModel("mdr_myaddress_mob", ResManager.loadKDString((String)"\u6211\u7684\u6536\u8d27\u5730\u5740", (String)"DmaMobileMinePlugin_6", (String)DMAFORMPLUGIN, (Object[])new Object[0]), "5", false, customParams).showPage((AbstractFormPlugin)this);
    }

    protected void clickMyStore(EventObject evt) {
        HashMap<String, Object> customParams = new HashMap<String, Object>();
        customParams.put(OWNERID, this.getOwnerF7PKValue());
        customParams.put(CUSTOMERID, this.getCustomerF7PKValue());
        new FormModel("mdr_mystore_mob", ResManager.loadKDString((String)"\u6211\u7684\u5e93\u5b58", (String)"DmaMobileMinePlugin_7", (String)DMAFORMPLUGIN, (Object[])new Object[0]), "5", false, customParams).showPage((AbstractFormPlugin)this);
    }

    protected void clickPromotionInfo(EventObject evt) {
        HashMap<String, Object> customParams = new HashMap<String, Object>();
        customParams.put(OWNERID, this.getOwnerF7PKValue());
        customParams.put(CUSTOMERID, this.getCustomerF7PKValue());
        new FormModel("dma_promotionevent_mobile", "\u4fc3\u9500\u6d3b\u52a8", "5", false, customParams).showPage((AbstractFormPlugin)this);
    }

    protected boolean isCustomer() {
        return true;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        switch (key = e.getProperty().getName()) {
            case "customer": 
            case "owner": {
                this.initOrderInfo();
                this.initAccount();
                break;
            }
        }
    }
}

