/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dma.formplugin.index;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IPageCache;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.CarouselFigure;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.MobileSearchTextChangeEvent;
import kd.bos.form.control.events.MobileSearchTextChangeListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.events.SetFilterListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.MobileSearch;
import kd.bos.list.events.CreateListDataProviderListener;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.events.ListRowClickListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.fulltext.QMatches;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.url.UrlService;
import kd.drp.mdr.common.itemcontrol.ItemSaleControlUtil;
import kd.drp.mdr.common.model.dpm.DetailItemInfo;
import kd.drp.mdr.common.model.dpm.UsablePromotionResult;
import kd.drp.mdr.common.util.CustomerUtil;
import kd.drp.mdr.common.util.ItemAttrUtil;
import kd.drp.mdr.common.util.ItemStoreUtil;
import kd.drp.mdr.common.util.PriceUtil;
import kd.drp.mdr.common.util.SysParamsUtil;
import kd.drp.mdr.common.util.UserUtil;
import kd.drp.mdr.formplugin.MdrFormMobPlugin;
import kd.drp.mdr.mobile.ShowPageUtils;
import kd.drp.mdr.mobile.model.FormModel;
import kd.drp.mdr.servicehelper.PromotionServiceHelper;

public class MobileIndexPlugin
extends MdrFormMobPlugin
implements RowClickEventListener,
ListRowClickListener,
MobileSearchTextChangeListener,
CreateListDataProviderListener {
    private static final Log LOGGER = LogFactory.getLog(MobileIndexPlugin.class);
    public static final BigDecimal ONE = new BigDecimal(1);
    public static final String SEARCH = "search";
    public static final String SEARCH_HINT = "searchhint";
    public static final String BILLLLISTAP = "billlistap";
    public static final String ADDTOSHOPPINGCART = "addtoshoppingcart";
    public static final String TOP_SALE_FLEX = "topsale";
    public static final String ITEM_LIST_FLEX = "itemlist";
    public static final String ITEMCLASS = "itemclass";
    public static final String ITEM_LIST_TYPE = "itemlisttype";
    public static final String ALLITEM = "allitem";
    public static final String NEWITEM = "newitem";
    public static final String HOTSALE = "hotsale";
    public static final String PROMOTION = "promotion";
    public static final String BUYAGAIN = "buyagain";
    public static final String SEARCH_RESULT = "searchresult";
    public static final String NOTICE_BUTTON = "notice";
    public static final int MINITEMNUM = 10;
    public static final int MAXITEMNUM = 50;
    public static final String OWNERID = "ownerid";
    public static final String CUSTOMERID = "customerid";
    public static final String CUSTOMER = "customer";
    public static final String CUSTOMERKEY = "customerkey";
    public static final String PROMOTIONKEY = "promotionkey";
    private boolean isAfterCreateNewData;
    public static final String TOP_SALE_ITEM_LIST = "topsaleitem";
    public static final String TOP_SALE_RANK = "topsalerank";
    public static final String TOP_ITEM_PIC = "topitempic";
    public static final String TOP_ITEM_STORE_INFO = "topitemstoreinfo";
    public static final String TOP_ITEM_NUMBER = "topitemnumber";
    public static final String TOP_ITEM_PRICE = "topprice";
    public static final String TOP_ITEM_UNIT = "topunit";
    public static final String TOP_ITEM_SALES = "topitemsales";
    public static final String TOP_ADD_SHOPPINGCART = "topaddtoshoppingcart";

    public void initialize() {
        super.initialize();
        BillList itemlist = (BillList)this.getControl(BILLLLISTAP);
        itemlist.addCreateListDataProviderListener((CreateListDataProviderListener)this);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{ADDTOSHOPPINGCART, TOP_ADD_SHOPPINGCART, ITEMCLASS, NEWITEM, PROMOTION, BUYAGAIN, HOTSALE, ALLITEM, NOTICE_BUTTON});
        MobileSearch serach = (MobileSearch)this.getView().getControl(SEARCH);
        serach.addMobileSearchTextChangeListener((MobileSearchTextChangeListener)this);
        BillList billList = (BillList)this.getView().getControl(BILLLLISTAP);
        billList.addListRowClickListener((ListRowClickListener)this);
        CardEntry topSale = (CardEntry)this.getView().getControl(TOP_SALE_ITEM_LIST);
        topSale.addRowClickListener((RowClickEventListener)this);
    }

    public void click(MobileSearchTextChangeEvent e) {
        super.click((EventObject)e);
        String context = e.getText();
        this.reLoadItem(context);
    }

    private void reLoadItem(Object context) {
        String searchText = context.toString();
        if (searchText != null && !"".equals(searchText.trim())) {
            BillList itemlist = (BillList)this.getControl(BILLLLISTAP);
            ArrayList<QFilter> tbFilters = new ArrayList<QFilter>();
            tbFilters.add(QMatches.ftlike((String[])new String[]{searchText}, (String[])new String[]{"number,name,searchkey"}));
            tbFilters.add(new QFilter("isonsell", "=", (Object)"1"));
            tbFilters.add(ItemSaleControlUtil.getItemFilterUsePageCache((Object)this.getOwnerF7PKValue(), (Object)this.getCustomerF7PKValue(), (IPageCache)this.getPageCache()));
            FilterParameter filterParameter = new FilterParameter();
            filterParameter.setQFilters(tbFilters);
            itemlist.setQueryFilterParameter(filterParameter);
            itemlist.addCreateListDataProviderListener((CreateListDataProviderListener)this);
            itemlist.refresh();
            Label searchHint = (Label)this.getControl(SEARCH_HINT);
            searchHint.setText(String.format(ResManager.loadKDString((String)"\u4ee5\u4e0b\u662f \"%s\" \u7684\u641c\u7d22\u7ed3\u679c", (String)"MobileIndexPlugin_0", (String)"drp-dma-formplugin", (Object[])new Object[0]), searchText));
            this.setValue(ITEM_LIST_TYPE, SEARCH_RESULT);
            this.setVisible(new String[]{ALLITEM});
            this.setVisible(new String[]{ITEM_LIST_FLEX});
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initCustomerValue();
        this.initOwnerValue();
        this.loadData();
        this.isAfterCreateNewData = true;
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initCarouselFigure();
        this.initNotification();
        if (!this.isAfterCreateNewData) {
            this.loadData();
        }
    }

    private void initCarouselFigure() {
        ORM orm = ORM.create();
        QFilter filter = new QFilter("owner", "=", this.getOwnerF7PKValue());
        DynamicObject ad = orm.queryOne("mdr_adcolumn", new QFilter[]{filter});
        if (ad == null) {
            return;
        }
        CarouselFigure carousel = (CarouselFigure)this.getControl("carousel");
        ArrayList<String> urls = new ArrayList<String>();
        DynamicObjectCollection doc = ad.getDynamicObjectCollection("adentry");
        for (DynamicObject dynamicObject : doc) {
            if (dynamicObject.get("entrypicture") == null) continue;
            urls.add(UrlService.getImageFullUrl((String)"") + dynamicObject.getString("entrypicture"));
        }
        String[] a = new String[urls.size()];
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.invokeControlMethod(carousel.getKey(), "updatecarousel", new Object[]{urls.toArray(a)});
    }

    private void initNotification() {
        Label header = (Label)this.getControl("headerinfo");
        QFilter filters = new QFilter("status", "=", (Object)Character.valueOf('B')).and("ownerentity.ownerid", "in", UserUtil.getOwnerIDs().stream().map(id -> id.toString()).collect(Collectors.toList()));
        DynamicObjectCollection message = QueryServiceHelper.query((String)"mdr_notice_sendview", (String)"id,title", (QFilter[])filters.toArray(), (String)"createtime desc", (int)1);
        if (message != null && message.size() != 0) {
            header.setText(((DynamicObject)message.get(0)).getString("title"));
        } else {
            header.setText(ResManager.loadKDString((String)"\u6682\u65e0\u6d88\u606f", (String)"MobileIndexPlugin_1", (String)"drp-dma-formplugin", (Object[])new Object[0]));
        }
    }

    private void initCustomerValue() {
        Object customerId = this.getParameter(CUSTOMERID);
        if (customerId == null) {
            customerId = UserUtil.getDefaultOwnerID();
        }
        this.getModel().setValue(CUSTOMER, customerId);
    }

    private void initOwnerValue() {
        Object ownerid = this.getParameter(OWNERID);
        if (ownerid == null) {
            List ownerIds = CustomerUtil.getAuthOwnerIDs((Object)this.getCustomerF7PKValue());
            ownerid = ownerIds != null && !ownerIds.isEmpty() ? ownerIds.get(0) : Long.valueOf(0L);
        }
        this.getModel().setValue("owner", ownerid);
    }

    private void goToItemInfo(Object item) {
        MobileFormShowParameter parameter = new MobileFormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Floating);
        parameter.setFormId("mdr_item_details_mob");
        parameter.setCustomParam("item", item);
        this.getView().showForm((FormShowParameter)parameter);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        switch (key = e.getProperty().getName()) {
            case "customer": 
            case "owner": 
            case "itemlisttype": {
                this.loadData();
                this.initCarouselFigure();
                break;
            }
        }
    }

    private void loadData() {
        String itemListType;
        this.setDisVisible(new String[]{SEARCH_HINT});
        switch (itemListType = this.getTextFieldValue(ITEM_LIST_TYPE)) {
            case "allitem": 
            case "newitem": 
            case "promotion": {
                this.loadItem(itemListType);
                break;
            }
            case "hotsale": 
            case "buyagain": {
                this.loadTopItem(itemListType);
                break;
            }
            case "searchresult": {
                this.setVisible(new String[]{ITEM_LIST_FLEX});
                this.setVisible(new String[]{SEARCH_HINT});
                this.setDisVisible(new String[]{TOP_SALE_FLEX});
                break;
            }
        }
    }

    private void loadItem(String itemListType) {
        this.setVisible(new String[]{ITEM_LIST_FLEX});
        this.setDisVisible(new String[]{TOP_SALE_FLEX});
        Object ownerId = this.getOwnerF7PKValue();
        Object customerId = this.getCustomerF7PKValue();
        ArrayList<QFilter> tbFilters = new ArrayList<QFilter>();
        BillList itemlist = (BillList)this.getControl(BILLLLISTAP);
        itemlist.addSetFilterListener(new SetFilterListener(){

            public void setFilter(SetFilterEvent e) {
                e.setOrderBy("serialnumber desc,selltime desc");
            }
        });
        FilterParameter filterParameter = new FilterParameter();
        if (ownerId == null || customerId == null || !CustomerUtil.isAuthRelation((Object)ownerId, (Object)customerId)) {
            tbFilters.add(new QFilter("1", "!=", (Object)"1"));
        } else {
            tbFilters.add(ItemSaleControlUtil.getItemFilterUsePageCache((Object)ownerId, (Object)customerId, (IPageCache)this.getPageCache()));
            tbFilters.add(new QFilter("isonsell", "=", (Object)"1"));
            switch (itemListType) {
                case "newitem": {
                    tbFilters.add(new QFilter("newsell", "=", (Object)"1"));
                    break;
                }
                case "promotion": {
                    tbFilters.add(new QFilter("ispromotional", "=", (Object)"1"));
                    break;
                }
            }
        }
        filterParameter.setQFilters(tbFilters);
        itemlist.setQueryFilterParameter(filterParameter);
        itemlist.addCreateListDataProviderListener((CreateListDataProviderListener)this);
        itemlist.refresh();
    }

    public void createListDataProvider(BeforeCreateListDataProviderArgs e) {
        e.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int arg0, int arg1) {
                DynamicObjectCollection rows = super.getData(arg0, arg1);
                if (rows.isEmpty()) {
                    return rows;
                }
                Object ownerid = MobileIndexPlugin.this.getOwnerF7PKValue();
                Object customerid = MobileIndexPlugin.this.getCustomerF7PKValue();
                Set promotioninfos = null;
                String itemListType = MobileIndexPlugin.this.getTextFieldValue(MobileIndexPlugin.ITEM_LIST_TYPE);
                if (ownerid != null && customerid != null && itemListType.compareTo(MobileIndexPlugin.PROMOTION) == 0) {
                    String key = String.format("%s_%s", ownerid, customerid);
                    String customerkey = MobileIndexPlugin.this.getPageCache().get(MobileIndexPlugin.CUSTOMERKEY);
                    if (customerkey == null || key.compareTo(customerkey) != 0) {
                        PromotionServiceHelper.removePromotionContextFromCache((String)MobileIndexPlugin.this.getPageCache().get(MobileIndexPlugin.PROMOTIONKEY));
                        String cachekey = UUID.randomUUID().toString().replace("-", "");
                        MobileIndexPlugin.this.getPageCache().put(MobileIndexPlugin.PROMOTIONKEY, cachekey);
                        promotioninfos = PromotionServiceHelper.matchAndExecutePromotion((String)cachekey, (Object)ownerid, (Object)customerid, (boolean)true, (String[])new String[]{"C"});
                        MobileIndexPlugin.this.getPageCache().put(MobileIndexPlugin.CUSTOMERKEY, key);
                    } else {
                        promotioninfos = PromotionServiceHelper.getUsablePromotionResult((String)MobileIndexPlugin.this.getPageCache().get(MobileIndexPlugin.PROMOTIONKEY));
                    }
                }
                Object warehouseId = MobileIndexPlugin.this.getF7PKValue("warehouse");
                HashSet<Object> itemIds = new HashSet<Object>(rows.size());
                for (DynamicObject row : rows) {
                    itemIds.add(row.get("id"));
                }
                MobileIndexPlugin.this.getUnitFormHandler().batchLoad(itemIds);
                DynamicObject authBizInfo = CustomerUtil.getAuthBizInfo((Object)ownerid, (Object)customerid);
                String parentinvtype = authBizInfo.getString("parentinvtype");
                String hasStore = "";
                HashMap<String, DynamicObject> itemstores = new HashMap<String, DynamicObject>();
                if (!"0".equals(parentinvtype)) {
                    DynamicObjectCollection store = ItemStoreUtil.queryItemsStoreInfoSum((Object)ownerid, itemIds, (Object)warehouseId, (boolean)true);
                    for (DynamicObject dyObject : store) {
                        itemstores.put(String.format("%s_%s", dyObject.getString("item"), dyObject.getString("measureunit")), dyObject);
                    }
                }
                for (int i = 0; i < rows.size(); ++i) {
                    DynamicObject row = (DynamicObject)rows.get(i);
                    Object itempk = row.get("id");
                    Object unitId = row.getDynamicObject("saleunit").get("id");
                    Object attrid = ItemAttrUtil.getDefaultAttrId((Object)itempk);
                    BigDecimal itemprice = BigDecimal.ZERO;
                    if (ownerid != null && customerid != null) {
                        itemprice = PriceUtil.getItemPrice((Object)ownerid, (Object)customerid, (Object)itempk, (Object)unitId, (Object)attrid, (BigDecimal)BigDecimal.ONE);
                        if (itemprice == null) {
                            itemprice = BigDecimal.ZERO;
                        }
                        if (itemListType.compareTo(MobileIndexPlugin.PROMOTION) == 0) {
                            row.set("promotioninfo", (Object)MobileIndexPlugin.this.getPromotionDetatils(new DetailItemInfo(itempk, unitId, attrid), promotioninfos));
                        }
                    }
                    row.set("easnum", (Object)itemprice.stripTrailingZeros().toPlainString());
                    if ("0".equals(parentinvtype)) {
                        hasStore = "";
                    } else {
                        BigDecimal usableQty;
                        hasStore = "\u65e0\u8d27";
                        DynamicObject itemstore = (DynamicObject)itemstores.get(String.format("%s_%s", itempk, unitId));
                        if (itemstore != null && (usableQty = itemstore.getBigDecimal("usableqty")).compareTo(MdrFormMobPlugin.ZERO) > 0) {
                            hasStore = "1".equals(parentinvtype) ? "\u6709\u8d27" : new StringBuffer("\u6709\u8d27\uff08\u5e93\u5b58").append(usableQty.stripTrailingZeros().toPlainString()).append("\uff09").toString();
                        }
                    }
                    row.set("storeinfo", (Object)hasStore);
                }
                return rows;
            }
        });
    }

    public void beforeClosed(BeforeClosedEvent arg0) {
        super.beforeClosed(arg0);
        PromotionServiceHelper.removePromotionContextFromCache((String)this.getPageCache().get(PROMOTIONKEY));
    }

    private String getPromotionDetatils(DetailItemInfo iteminfo, Set<UsablePromotionResult> promotioninfos) {
        if (promotioninfos == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        Set itemranges = null;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy/MM/dd");
        int i = 0;
        block0: for (UsablePromotionResult usablePromotionResult : promotioninfos) {
            itemranges = usablePromotionResult.getItemRanges();
            if (itemranges == null) continue;
            for (DetailItemInfo detailItemInfo : itemranges) {
                if (detailItemInfo.getItemid().toString().compareTo(iteminfo.getItemid().toString()) != 0) continue;
                if (i > 2) {
                    stringBuilder.append("...");
                    continue block0;
                }
                stringBuilder.append(String.format("%s\uff1a", usablePromotionResult.getName()));
                stringBuilder.append(String.format("%s-%s\uff0c", simpleDateFormat.format(usablePromotionResult.getstarttime()), simpleDateFormat.format(usablePromotionResult.getendtime())));
                if (usablePromotionResult.getLeftLimitqty() != null && usablePromotionResult.getLeftLimitqty().compareTo(BigDecimal.ZERO) > 0) {
                    stringBuilder.append(String.format("\u5269\u4f59\u6570\u91cf\uff1a%s\n", usablePromotionResult.getLeftLimitqty()));
                }
                ++i;
                continue block0;
            }
        }
        return stringBuilder.toString();
    }

    protected QFilter getOrderDateFilter(QFilter filter) {
        Date date = new Date();
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(2, -3);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        Date beginDate = cal.getTime();
        cal = Calendar.getInstance();
        cal.setTime(date);
        cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        Date endDate = cal.getTime();
        cal = Calendar.getInstance();
        cal.setTime(date);
        if (beginDate != null) {
            filter.and("orderdate", ">=", (Object)beginDate);
        }
        if (endDate != null) {
            filter.and("orderdate", "<=", (Object)endDate);
        }
        return filter;
    }

    protected int itemNum() {
        if (this.getModel().getValue("itemnum") == null) {
            LOGGER.info("itemnum: " + this.getModel().getValue("itemnum"));
            return 10;
        }
        int num = ((BigDecimal)this.getModel().getValue("itemnum")).intValue();
        if (num < 10) {
            num = 10;
        } else if (num > 50) {
            num = 50;
        }
        return num;
    }

    private void loadTopItem(String itemListType) {
        this.setDisVisible(new String[]{ITEM_LIST_FLEX});
        this.setVisible(new String[]{TOP_SALE_FLEX});
        this.getModel().deleteEntryData(TOP_SALE_ITEM_LIST);
        Object ownerId = this.getOwnerF7PKValue();
        Object customerId = this.getCustomerF7PKValue();
        if (ownerId == null || customerId == null) {
            return;
        }
        QFilter filter = this.getOrderDateFilter(new QFilter("1", "=", (Object)1));
        String introduction = "";
        switch (itemListType) {
            case "hotsale": {
                filter.and(new QFilter("owner", "=", ownerId));
                introduction = ResManager.loadKDString((String)"\u70ed\u9500 ", (String)"MobileIndexPlugin_2", (String)"drp-dma-formplugin", (Object[])new Object[0]);
                break;
            }
            case "buyagain": {
                filter.and(new QFilter(CUSTOMER, "=", customerId));
                introduction = ResManager.loadKDString((String)"\u5df2\u8d2d ", (String)"MobileIndexPlugin_3", (String)"drp-dma-formplugin", (Object[])new Object[0]);
                break;
            }
        }
        ORM orm = ORM.create();
        String queryField = "itementry.item as itemid,itementry.alterbaseqty as qty,itementry.item.isonsell";
        int itemNum = this.itemNum();
        try (DataSet dataset = orm.queryDataSet(((Object)((Object)this)).getClass().getName(), "bbc_saleorder", queryField, filter.toArray()).groupBy(new String[]{"itemid", "itementry.item.isonsell"}).sum("qty").finish().orderBy(new String[]{"qty desc"}).limit(0, itemNum * 2);){
            int size = 1;
            while (dataset.hasNext()) {
                Row row = dataset.next();
                String isonsell = (String)row.get("itementry.item.isonsell");
                if (isonsell == null || !"1".equals(isonsell)) continue;
                Object item = row.get("itemid");
                BigDecimal sales = (BigDecimal)row.get("qty");
                this.addTopItem(item, introduction + sales.stripTrailingZeros().toPlainString() + " ");
                if (++size <= itemNum) continue;
                return;
            }
        }
    }

    public void listRowClick(ListRowClickEvent evt) {
        ListSelectedRow listSelectedRow = evt.getCurrentListSelectedRow();
        Object itempk = listSelectedRow.getPrimaryKeyValue();
        this.addToShoppingCart(itempk);
    }

    public void entryRowClick(RowClickEvent evt) {
        int row = evt.getRow();
        Object topItemPk = this.getModel().getValue(TOP_ITEM_NUMBER, row);
        if (topItemPk != null) {
            this.addToShoppingCart(((DynamicObject)topItemPk).getPkValue());
        }
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control control = (Control)evt.getSource();
        switch (key = control.getKey()) {
            case "addtoshoppingcart": {
                if (this.getModel().getValue("owner") == null) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4f9b\u8d27\u6e20\u9053\u4e0d\u80fd\u4e3a\u7a7a", (String)"MobileIndexPlugin_4", (String)"drp-dma-formplugin", (Object[])new Object[0]));
                    return;
                }
                BillList itemList = (BillList)this.getControl(BILLLLISTAP);
                ListSelectedRow iteminfo = itemList.getCurrentSelectedRowInfo();
                Object itempk = iteminfo.getPrimaryKeyValue();
                this.addToShoppingCart(itempk);
                break;
            }
            case "topaddtoshoppingcart": {
                if (this.getModel().getValue("owner") == null) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4f9b\u8d27\u6e20\u9053\u4e0d\u80fd\u4e3a\u7a7a", (String)"MobileIndexPlugin_4", (String)"drp-dma-formplugin", (Object[])new Object[0]));
                    return;
                }
                int index = this.getModel().getEntryCurrentRowIndex(TOP_SALE_ITEM_LIST);
                Object topItemPk = this.getModel().getValue(TOP_ITEM_NUMBER, index);
                if (topItemPk == null) break;
                this.addToShoppingCart(((DynamicObject)topItemPk).getPkValue());
                break;
            }
            case "newitem": 
            case "hotsale": 
            case "promotion": 
            case "buyagain": {
                this.setVisible(new String[]{ALLITEM});
                this.setValue(ITEM_LIST_TYPE, key);
                break;
            }
            case "allitem": {
                this.setDisVisible(new String[]{ALLITEM});
                this.setValue(ITEM_LIST_TYPE, key);
                break;
            }
            case "notice": {
                this.goToNotice();
                break;
            }
        }
    }

    protected void goToNotice() {
        FormModel formModel = new FormModel("mdr_notice_sendview", ResManager.loadKDString((String)"\u901a\u77e5\u5217\u8868", (String)"MobileIndexPlugin_5", (String)"drp-dma-formplugin", (Object[])new Object[0]), "10");
        formModel.setTemplateId("dma_notice");
        ShowPageUtils.showPage((FormModel)formModel, (AbstractFormPlugin)this);
    }

    private void addToShoppingCart(Object itempk) {
        Object ownerId = this.getOwnerF7PKValue();
        Object customerId = this.getCustomerF7PKValue();
        if (ownerId == null || customerId == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8981\u8d27\u6e20\u9053\u53ca\u4f9b\u8d27\u6e20\u9053", (String)"MobileIndexPlugin_6", (String)"drp-dma-formplugin", (Object[])new Object[0]));
            return;
        }
        MobileFormShowParameter parameter = new MobileFormShowParameter();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(OWNERID, ownerId);
        params.put(CUSTOMERID, customerId);
        params.put("itemid", itempk);
        parameter.setCustomParams(params);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("mdr_mobchooseitemattr");
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, ADDTOSHOPPINGCART));
        this.getView().showForm((FormShowParameter)parameter);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String key;
        super.closedCallBack(e);
        switch (key = e.getActionId()) {
            case "addtoshoppingcart": {
                Map param = (Map)e.getReturnData();
                if (param == null) {
                    return;
                }
                this.addToShoppingCartCallBack(param);
                break;
            }
        }
    }

    private void addToShoppingCartCallBack(Map<String, Object> param) {
        boolean isMergeCartSameItem = SysParamsUtil.isMergeCartSameItem();
        boolean isAddToShoppingCart = false;
        if (isMergeCartSameItem) {
            QFilter filter = new QFilter("item", "=", param.get("itemid"));
            filter.and("owner", "=", param.get(CUSTOMERID));
            filter.and(CUSTOMER, "=", param.get(OWNERID));
            filter.and("user", "=", UserUtil.getUserID());
            filter.and("unit", "=", param.get("unitid"));
            filter.and("assistattr", "=", param.get("assistattrid") == null ? Integer.valueOf(0) : param.get("assistattrid"));
            filter.and("assistunit", "=", param.get("assistunitid") == null ? Integer.valueOf(0) : param.get("assistunitid"));
            filter.and("ispurchasing", "=", (Object)Character.valueOf('0'));
            DynamicObject[] cartItems = BusinessDataServiceHelper.load((String)"mdr_shopping_cart", (String)"id,item,owner,customer,unit,assistattr,assistunit,price,assistqty,qty,createdate", (QFilter[])filter.toArray());
            if (cartItems != null && cartItems.length > 0) {
                for (DynamicObject cartItem : cartItems) {
                    if (cartItem.getBigDecimal("price").compareTo((BigDecimal)param.get("price")) != 0) continue;
                    isAddToShoppingCart = true;
                    BigDecimal qty = cartItem.getBigDecimal("qty");
                    BigDecimal assistqty = cartItem.getBigDecimal("assistqty");
                    if (param.get("assistqty") != null) {
                        cartItem.set("assistqty", (Object)assistqty.add((BigDecimal)param.get("assistqty")));
                    }
                    cartItem.set("qty", (Object)qty.add((BigDecimal)param.get("qty")));
                    cartItem.set("createdate", (Object)new Date());
                    SaveServiceHelper.save((IDataEntityType)cartItem.getDataEntityType(), (Object[])new Object[]{cartItem});
                    break;
                }
            }
        }
        if (!isAddToShoppingCart) {
            DynamicObject cartItem = BusinessDataServiceHelper.newDynamicObject((String)"mdr_shopping_cart");
            cartItem.set("owner", param.get(CUSTOMERID));
            cartItem.set("item", param.get("itemid"));
            cartItem.set("unit", param.get("unitid"));
            cartItem.set("price", param.get("price"));
            cartItem.set("qty", param.get("qty"));
            cartItem.set("assistattr", param.get("assistattrid"));
            cartItem.set("assistunit", param.get("assistunitid"));
            cartItem.set("assistqty", param.get("assistqty"));
            cartItem.set("createdate", (Object)new Date());
            cartItem.set(CUSTOMER, param.get(OWNERID));
            cartItem.set("user", UserUtil.getUserID());
            cartItem.set("ispurchasing", (Object)0);
            SaveServiceHelper.save((IDataEntityType)cartItem.getDataEntityType(), (Object[])new Object[]{cartItem});
        }
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6dfb\u52a0\u8d2d\u7269\u8f66\u6210\u529f", (String)"MobileIndexPlugin_7", (String)"drp-dma-formplugin", (Object[])new Object[0]));
    }

    public void addTopItem(Object itemPk, String sales) {
        Object unitId = this.getUnitFormHandler().getBaseUnitId(itemPk);
        Object attrid = ItemAttrUtil.getDefaultAttrId((Object)itemPk);
        BigDecimal itemprice = PriceUtil.getItemPrice((Object)this.getOwnerF7PKValue(), (Object)this.getCustomerF7PKValue(), (Object)itemPk, (Object)unitId, (Object)attrid, (BigDecimal)BigDecimal.ONE);
        IDataModel model = this.getModel();
        int index = model.createNewEntryRow(TOP_SALE_ITEM_LIST);
        model.setValue(TOP_ITEM_NUMBER, itemPk, index);
        DynamicObject iteminfo = (DynamicObject)this.getValue(TOP_ITEM_NUMBER, index);
        Integer rank = index + 1;
        model.setValue(TOP_SALE_RANK, (Object)rank, index);
        if (iteminfo != null) {
            model.setValue(TOP_ITEM_PIC, iteminfo.get("thumbnail"), index);
        }
        model.setValue(TOP_ITEM_PRICE, (Object)itemprice, index);
        model.setValue(TOP_ITEM_UNIT, unitId, index);
        DynamicObject unit = (DynamicObject)model.getValue(TOP_ITEM_UNIT, index);
        model.setValue(TOP_ITEM_SALES, (Object)(sales + unit.get("name")), index);
    }
}

