/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dma.formplugin.index;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.MobileListShowParameter;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.drp.mdr.common.f7.F7Utils;
import kd.drp.mdr.common.status.SaleOrderStatus;
import kd.drp.mdr.common.util.CustomerUtil;
import kd.drp.mdr.common.util.UserUtil;
import kd.drp.mdr.formplugin.MdrFormMobPlugin;

public class MobileSimpleIndexPlugin
extends MdrFormMobPlugin
implements BeforeF7SelectListener {
    private static final String SUBMITED = "submited";
    private static final String DISPATCHED = "dispatched";
    private static final String TOBEDELIVERY = "tobedelivery";
    private static final String TOBERECEIVE = "tobereceive";
    private static final String GOTOSHOPPINGCART = "gotoshoppingcart";
    public static final String ORDER_FILTER_TYPE = "orderfiltertype";
    public static final String OFT_ALLORDER = "all_order";
    public static final String OFT_UNPAIDORDER = "unpaidorder";
    public static final String OFT_UNRECEIVEORDER = "unreceiveorder";
    public static final String OFT_UNSHIPORDER = "unshipoder";
    public static final String OFT_SUBMITORDER = "submitorder";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initCustomer();
        this.loadOrderInfo();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.loadOrderInfo();
    }

    private void loadOrderInfo() {
        Object customer = this.getCustomerF7PKValue();
        Object owner = this.getOwnerF7PKValue();
        ORM orm = ORM.create();
        QFilter filter = new QFilter("customer", "=", customer).and("owner", "=", owner);
        try (DataSet orderSet = orm.queryDataSet(((Object)((Object)this)).getClass().getName(), "dpa_purorder", "orderstatus", new QFilter[]{filter}).groupBy(new String[]{"orderstatus"}).count().finish();){
            Iterator iterator = orderSet.iterator();
            BigDecimal submited = BigDecimal.ZERO;
            BigDecimal dispatched = BigDecimal.ZERO;
            BigDecimal tobedelivery = BigDecimal.ZERO;
            BigDecimal tobereceive = BigDecimal.ZERO;
            BigDecimal partTobedelivery = BigDecimal.ZERO;
            while (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                String orderstatus = (String)row.get("orderstatus");
                BigDecimal ordercount = row.getBigDecimal("count");
                switch (orderstatus) {
                    case "B": {
                        submited = ordercount;
                        break;
                    }
                    case "L": {
                        dispatched = ordercount;
                        break;
                    }
                    case "C": {
                        tobedelivery = ordercount;
                        break;
                    }
                    case "D": {
                        partTobedelivery = ordercount;
                        break;
                    }
                    case "E": {
                        tobereceive = ordercount;
                    }
                }
            }
            ((Label)this.getControl(SUBMITED)).setText(submited.toString());
            ((Label)this.getControl(DISPATCHED)).setText(dispatched.toString());
            ((Label)this.getControl(TOBEDELIVERY)).setText(tobedelivery.add(partTobedelivery).toString());
            ((Label)this.getControl(TOBERECEIVE)).setText(tobereceive.add(partTobedelivery).toString());
        }
    }

    private void initCustomer() {
        List customerIds = UserUtil.getOwnerIDs();
        if (customerIds == null || customerIds.size() == 0) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"customer", "owner", "warehouse"});
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u6ca1\u6709\u6240\u5c5e\u6e20\u9053\uff0c\u65e0\u6cd5\u4f7f\u7528\u5fae\u5546\u57ce", (String)"MobileSimpleIndexPlugin_0", (String)"drp-dma-formplugin", (Object[])new Object[0]));
        } else {
            boolean isMatch = false;
            for (Object customerId : customerIds) {
                List ownerids = CustomerUtil.getAuthOwnerIDs(customerId);
                if (ownerids == null || ownerids.size() == 0) continue;
                this.getModel().setValue("customer", customerId);
                this.getModel().setValue("owner", ownerids.get(0));
                isMatch = true;
                break;
            }
            if (!isMatch) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"customer", "owner", "warehouse"});
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u662f\u4f01\u4e1a\u7528\u6237\u4e0d\u53ef\u4ee5\u8ba2\u8d27\uff0c\u5982\u9700\u4ee3\u5ba2\u4e0b\u5355\u8bf7\u4f7f\u7528\u9500\u552e\u52a9\u624b", (String)"MobileSimpleIndexPlugin_1", (String)"drp-dma-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private void initOwnerValue() {
        List<Object> ownerIds = this.getOwnerIDs();
        if (ownerIds.isEmpty()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4f01\u4e1a\u7528\u6237\uff0c\u4e0d\u80fd\u8981\u8d27\uff01\u8bf7\u5207\u6362\u6e20\u9053", (String)"MobileSimpleIndexPlugin_2", (String)"drp-dma-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getModel().setValue("owner", ownerIds.get(0));
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{SUBMITED, DISPATCHED, TOBEDELIVERY, TOBERECEIVE, GOTOSHOPPINGCART});
        this.addF7Listener(this, new String[]{"owner", "customer"});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        if (!this.triggerChangeEvent) {
            return;
        }
        this.triggerChangeEvent = false;
        switch (key = e.getProperty().getName()) {
            case "customer": {
                this.getModel().setValue("owner", null);
                this.initOwnerValue();
                this.loadOrderInfo();
                break;
            }
            case "owner": {
                this.loadOrderInfo();
                break;
            }
            case "orderfiltertype": {
                this.orderFilterTypeChange(e);
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key;
        switch (key = e.getProperty().getName()) {
            case "owner": {
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)this.getOwnerFilter());
                break;
            }
            case "customer": {
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)this.getCustomerFilter());
            }
        }
    }

    private QFilter getOwnerFilter() {
        List<Object> ownerIds = this.getOwnerIDs();
        return new QFilter("id", "in", ownerIds);
    }

    private List<Object> getOwnerIDs() {
        List ownerids = CustomerUtil.getAuthOwnerIDs((Object)this.getCustomerF7PKValue());
        if (ownerids.isEmpty()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4f01\u4e1a\u7528\u6237\uff0c\u4e0d\u80fd\u8981\u8d27\uff01\u8bf7\u5207\u6362\u6e20\u9053", (String)"MobileSimpleIndexPlugin_2", (String)"drp-dma-formplugin", (Object[])new Object[0]));
        }
        return ownerids;
    }

    private QFilter getCustomerFilter() {
        return new QFilter("id", "in", (Object)UserUtil.getOwnerIDs());
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control control = (Control)evt.getSource();
        switch (key = control.getKey()) {
            case "submited": 
            case "dispatched": 
            case "tobedelivery": 
            case "tobereceive": {
                this.showSaleOrderList(key);
                break;
            }
            case "gotoshoppingcart": {
                this.goToShoppingCart();
                break;
            }
        }
    }

    private void showSaleOrderList(String key) {
        MobileListShowParameter parameter = new MobileListShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Floating);
        parameter.setFormId("bos_moblist");
        parameter.setBillFormId("dpa_purorder");
        ArrayList<String> orderstatus = new ArrayList<String>();
        switch (key) {
            case "submited": {
                orderstatus.add(SaleOrderStatus.SUBMITTED.getFlagStr());
                break;
            }
            case "dispatched": {
                orderstatus.add(SaleOrderStatus.DISPATCHED.getFlagStr());
                break;
            }
            case "tobedelivery": {
                orderstatus.add(SaleOrderStatus.PENDING_DELIVERY.getFlagStr());
                orderstatus.add(SaleOrderStatus.PART_DELIVERY.getFlagStr());
                break;
            }
            case "tobereceive": {
                orderstatus.add(SaleOrderStatus.WAITING_RECEIVER.getFlagStr());
                orderstatus.add(SaleOrderStatus.PART_DELIVERY.getFlagStr());
                break;
            }
        }
        QFilter f = new QFilter("owner", "=", this.getOwnerF7PKValue());
        f.and("customer", "=", this.getCustomerF7PKValue());
        if (orderstatus != null && orderstatus.size() != 0) {
            f.and("orderstatus", "in", orderstatus);
        }
        ListFilterParameter listFilterParameter = new ListFilterParameter();
        listFilterParameter.setFilter(f);
        parameter.setListFilterParameter(listFilterParameter);
        this.getView().showForm((FormShowParameter)parameter);
    }

    private void showSaleOrderList(QFilter filter) {
        MobileListShowParameter parameter = new MobileListShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Floating);
        parameter.setFormId("bos_moblist");
        parameter.setBillFormId("dpa_purorder");
        QFilter f = new QFilter("owner", "=", this.getOwnerF7PKValue());
        f.and("customer", "=", this.getCustomerF7PKValue());
        if (filter != null) {
            f.and(filter);
        }
        ListFilterParameter listFilterParameter = new ListFilterParameter();
        listFilterParameter.setFilter(f);
        parameter.setListFilterParameter(listFilterParameter);
        this.getView().showForm((FormShowParameter)parameter);
    }

    protected void goToShoppingCart() {
        MobileFormShowParameter parameter = new MobileFormShowParameter();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("customerid", this.getCustomerF7PKValue());
        map.put("ownerid", this.getOwnerF7PKValue());
        parameter.setCustomParams(map);
        parameter.getOpenStyle().setShowType(ShowType.Floating);
        parameter.setFormId("dma_shoppingcart_moblist");
        this.getView().showForm((FormShowParameter)parameter);
    }

    protected void orderFilterTypeChange(PropertyChangedArgs e) {
        String filterType;
        switch (filterType = this.getValue(ORDER_FILTER_TYPE).toString()) {
            case "all_order": {
                this.showSaleOrderList("");
                break;
            }
            case "submitorder": {
                this.showSaleOrderList(SUBMITED);
                break;
            }
            case "unpaidorder": {
                this.showSaleOrderList(new QFilter("paystatus", "=", (Object)"A"));
                break;
            }
            case "unreceiveorder": {
                this.showSaleOrderList(new QFilter("orderstatus", "in", (Object)new String[]{"E", "D"}));
                break;
            }
            case "unshipoder": {
                this.showSaleOrderList(new QFilter("orderstatus", "in", (Object)new String[]{"C", "D"}));
                break;
            }
        }
        this.triggerChangeEvent = false;
        this.setValue(ORDER_FILTER_TYPE, "");
    }
}

