/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dma.formplugin.mine;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.List;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.list.BillList;
import kd.bos.list.events.CreateListDataProviderListener;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.drp.mdr.formplugin.MdrFormMobPlugin;

public class MonthBalanceMobPlugin
extends MdrFormMobPlugin {
    private static final String ALLLIST = "alllist";
    private static final String INLIST = "inlist";
    private static final String OUTLIST = "outlist";

    public void createNewData(BizDataEventArgs e) {
        super.createNewData(e);
        BillList alllist = (BillList)this.getView().getControl(ALLLIST);
        alllist.addCreateListDataProviderListener(new CreateListDataProviderListener(){

            public void createListDataProvider(BeforeCreateListDataProviderArgs e) {
                e.setListDataProvider((IListDataProvider)new ListDataProvider(){

                    public List<QFilter> getQFilters() {
                        List filters = super.getQFilters();
                        filters.add(MonthBalanceMobPlugin.this.getCommonFilter());
                        return filters;
                    }
                });
            }
        });
        BillList inlist = (BillList)this.getView().getControl(INLIST);
        inlist.addCreateListDataProviderListener(new CreateListDataProviderListener(){

            public void createListDataProvider(BeforeCreateListDataProviderArgs e) {
                e.setListDataProvider((IListDataProvider)new ListDataProvider(){

                    public List<QFilter> getQFilters() {
                        List filters = super.getQFilters();
                        filters.add(MonthBalanceMobPlugin.this.getCommonFilter());
                        filters.add(new QFilter("amount", ">=", (Object)BigDecimal.ZERO));
                        return filters;
                    }
                });
            }
        });
        BillList outlist = (BillList)this.getView().getControl(OUTLIST);
        outlist.addCreateListDataProviderListener(new CreateListDataProviderListener(){

            public void createListDataProvider(BeforeCreateListDataProviderArgs e) {
                e.setListDataProvider((IListDataProvider)new ListDataProvider(){

                    public List<QFilter> getQFilters() {
                        List filters = super.getQFilters();
                        filters.add(MonthBalanceMobPlugin.this.getCommonFilter());
                        filters.add(new QFilter("amount", "<", (Object)BigDecimal.ZERO));
                        return filters;
                    }
                });
            }
        });
    }

    private QFilter getCommonFilter() {
        QFilter filter = new QFilter("receivingtype", "in", (Object)new String[]{"0", "1", "4", "5", "6"});
        filter.and("owner", "=", this.getOwnerID());
        filter.and("contactscustomer", "=", this.getCustomerID());
        filter.and("status", "=", (Object)Character.valueOf('C'));
        filter.and(this.getDateFilter());
        return filter;
    }

    private Object getCustomerID() {
        return this.getView().getFormShowParameter().getCustomParam("customerid");
    }

    private Object getOwnerID() {
        return this.getView().getFormShowParameter().getCustomParam("ownerid");
    }

    private QFilter getDateFilter() {
        int year = Integer.parseInt(this.getView().getFormShowParameter().getCustomParam("year").toString());
        int month = Integer.parseInt(this.getView().getFormShowParameter().getCustomParam("month").toString());
        Calendar c = Calendar.getInstance();
        c.set(1, year);
        c.set(2, month - 1);
        c.set(5, 1);
        c.set(10, 0);
        c.set(12, 0);
        c.set(13, 0);
        QFilter datefilter = new QFilter("approvetime", ">=", (Object)c.getTime());
        c.add(2, 1);
        datefilter.and(new QFilter("approvetime", "<", (Object)c.getTime()));
        return datefilter;
    }
}

