/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dma.formplugin.mine;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.EventObject;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.drp.mdr.common.util.BalanceUtil;
import kd.drp.mdr.common.util.DateUtil;
import kd.drp.mdr.formplugin.MdrFormMobPlugin;

public class MyBalanceMobPlugin
extends MdrFormMobPlugin {
    private static final String YEAR = "year";
    private static final String BACK = "back";
    private static final String USABLEAMOUNT = "usableamount";
    private static final String BALANCEAMOUNT = "balanceamount";
    private static final String PREPAIDAMOUNT = "prepaidamount";
    private static final String ENTRYENTITY = "entryentity";
    private static final String ENTRYMONTH = "entrymonth";
    private static final String ENTRYYEAR = "entryyear";
    private static final String ENTRYBALANCE = "entrybalance";
    private static final String INAMOUNT = "inamount";
    private static final String OUTAMOUNT = "outamount";
    private static final String VECTOR = "vector";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initHeadInfo();
        this.initYear();
        this.refreshMonthEntry();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{VECTOR, BACK});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control c = (Control)evt.getSource();
        if (VECTOR.equals(c.getKey())) {
            this.showMonthDetail();
        }
        if (BACK.equals(c.getKey())) {
            this.getView().close();
        }
    }

    private void showMonthDetail() {
        int index = this.getCurrentRowIndex(ENTRYENTITY);
        String monthstr = (String)this.getValue(ENTRYMONTH, index);
        monthstr = monthstr.substring(0, monthstr.length() - 1);
        FormShowParameter param = new FormShowParameter();
        param.setFormId("dma_monthbalance");
        param.setCustomParam("ownerid", this.getOwnerID());
        param.setCustomParam("customerid", this.getCustomerID());
        param.setCustomParam(YEAR, (Object)((String)this.getValue(YEAR)));
        param.setCustomParam("month", (Object)monthstr);
        param.getOpenStyle().setShowType(ShowType.Floating);
        this.getView().showForm(param);
    }

    private void initHeadInfo() {
        DynamicObject balanceinfo = BalanceUtil.getBalanceInfo((Object)this.getOwnerID(), (Object)this.getCustomerID(), (boolean)true);
        this.setValue(USABLEAMOUNT, balanceinfo.getBigDecimal("usable"));
        this.setValue(BALANCEAMOUNT, balanceinfo.getBigDecimal("balance"));
        this.setValue(PREPAIDAMOUNT, balanceinfo.getBigDecimal("occupied"));
    }

    private void initYear() {
        Calendar c = Calendar.getInstance();
        int toyear = c.get(1);
        this.setValue(YEAR, toyear);
        ComboEdit ce = (ComboEdit)this.getControl(YEAR);
        ArrayList<ComboItem> list = new ArrayList<ComboItem>();
        ComboItem co1 = new ComboItem(new LocaleString(String.valueOf(toyear)), String.valueOf(toyear));
        ComboItem co2 = new ComboItem(new LocaleString(String.valueOf(toyear - 1)), String.valueOf(toyear - 1));
        ComboItem co3 = new ComboItem(new LocaleString(String.valueOf(toyear - 2)), String.valueOf(toyear - 2));
        list.add(co1);
        list.add(co2);
        list.add(co3);
        ce.setComboItems(list);
    }

    private void refreshMonthEntry() {
        this.getModel().deleteEntryData(ENTRYENTITY);
        String year = (String)this.getValue(YEAR);
        int entryno = 12;
        if (this.isToYear(year)) {
            entryno = this.getToMonth();
        }
        int[] indexes = this.getModel().batchCreateNewEntryRow(ENTRYENTITY, entryno);
        ORM orm = ORM.create();
        try (DataSet dataset = orm.queryDataSet(((Object)((Object)this)).getClass().getName(), "mdr_money_receivingbill", "amount,approvetime", this.builderQFilter(year).toArray());
             DataSet posdataset = dataset.filter("amount >= 0").select("MONTH(approvetime) as month,amount");
             DataSet negdataset = dataset.filter("amount < 0").select("MONTH(approvetime) as month,amount");
             DataSet posgroupset = posdataset.groupBy(new String[]{"month"}).sum("amount", "amount").finish();
             DataSet neggroupset = negdataset.groupBy(new String[]{"month"}).sum("amount", "amount").finish();){
            Row row;
            while (neggroupset.hasNext()) {
                row = neggroupset.next();
                this.setValue(OUTAMOUNT, row.getBigDecimal("amount"), entryno - row.getInteger("month"));
            }
            while (posgroupset.hasNext()) {
                row = posgroupset.next();
                this.setValue(INAMOUNT, row.getBigDecimal("amount"), entryno - row.getInteger("month"));
            }
        }
        for (int i : indexes) {
            this.setValue(ENTRYMONTH, entryno - i + ResManager.loadKDString((String)"\u6708", (String)"MyBalanceMobPlugin_0", (String)"drp-dma-formplugin", (Object[])new Object[0]), i);
            this.setValue(ENTRYYEAR, year, i);
            this.setValue(ENTRYBALANCE, this.geMonthBalance(i), i);
        }
    }

    private BigDecimal geMonthBalance(int i) {
        BigDecimal amount = (BigDecimal)this.getValue(BALANCEAMOUNT);
        if (i != 0) {
            BigDecimal beforeMonthAmount = (BigDecimal)this.getValue(ENTRYBALANCE, i - 1);
            BigDecimal beforeMonthInAmount = (BigDecimal)this.getValue(INAMOUNT, i - 1);
            BigDecimal beforeMonthOutAmount = (BigDecimal)this.getValue(OUTAMOUNT, i - 1);
            amount = beforeMonthAmount.subtract(beforeMonthInAmount).subtract(beforeMonthOutAmount);
        }
        return amount;
    }

    private QFilter builderQFilter(String year) {
        QFilter filter = new QFilter("receivingtype", "in", (Object)new String[]{"0", "1", "4", "5", "6"});
        filter.and("owner", "=", this.getOwnerID());
        filter.and("contactscustomer", "=", this.getCustomerID());
        filter.and("status", "=", (Object)Character.valueOf('C'));
        filter.and(new QFilter("approvetime", ">=", (Object)DateUtil.formatDate((String)(year + "-01-01 00:00:00"), (String)"yyyy-MM-dd HH:mm:ss")));
        if (this.isToYear(year)) {
            filter.and(new QFilter("approvetime", "<=", (Object)DateUtil.formatDate((String)(year + "-12-31 23:59:59"), (String)"yyyy-MM-dd HH:mm:ss")));
        }
        return filter;
    }

    private boolean isToYear(String year) {
        Calendar c = Calendar.getInstance();
        Integer toyear = c.get(1);
        return toyear.equals(Integer.valueOf(year));
    }

    private int getToMonth() {
        Calendar c = Calendar.getInstance();
        return c.get(2) + 1;
    }

    private Object getCustomerID() {
        return this.getView().getFormShowParameter().getCustomParam("customerid");
    }

    private Object getOwnerID() {
        return this.getView().getFormShowParameter().getCustomParam("ownerid");
    }
}

