/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dma.formplugin.mine;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.function.Consumer;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.ColumnDesc;
import kd.bos.form.control.events.MobileSearchTextChangeEvent;
import kd.bos.form.control.events.MobileSearchTextChangeListener;
import kd.bos.list.MobileSearch;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.fulltext.QMatches;
import kd.drp.mdr.formplugin.MdrFormMobPlugin;

public class MyItemStoreMobPlugin
extends MdrFormMobPlugin
implements MobileSearchTextChangeListener,
Consumer<PackageDataEvent> {
    private static final String SEARCH = "search";
    private static final String ENTRYENTITY = "entryentity";
    private static final String PICTURE = "picture";
    private static final String ITEM = "item";
    private static final String HASSTORE = "hasstore";
    private static final String STORE = "store";
    private static final String UNIT = "unit";
    private String searchText = "";

    public void afterCreateNewData(EventObject e) {
        this.loadList("");
    }

    public void registerListener(EventObject e) {
        MobileSearch serach = (MobileSearch)this.getView().getControl(SEARCH);
        if (serach != null) {
            serach.addMobileSearchTextChangeListener((MobileSearchTextChangeListener)this);
        }
    }

    @Override
    public void accept(PackageDataEvent t) {
        ColumnDesc column = (ColumnDesc)t.getSource();
        DynamicObject row = t.getRowData();
        BigDecimal usableqty = row.getBigDecimal("qty").subtract(row.getBigDecimal("orderqty")).stripTrailingZeros();
        String key = column.getFieldKey();
        if (usableqty.compareTo(ZERO) <= 0) {
            switch (key) {
                case "customer.name": {
                    t.setFormatValue((Object)ResManager.loadKDString((String)"\u65e0\u8d27", (String)"MyItemStoreMobPlugin_0", (String)"drp-dma-formplugin", (Object[])new Object[0]));
                    break;
                }
                case "measureunit.name": {
                    t.setFormatValue((Object)"");
                    break;
                }
                case "usableqty": {
                    t.setFormatValue((Object)"");
                }
            }
        } else {
            switch (key) {
                case "customer.name": {
                    t.setFormatValue((Object)ResManager.loadKDString((String)"\u6709\u8d27\uff1a", (String)"MyItemStoreMobPlugin_1", (String)"drp-dma-formplugin", (Object[])new Object[0]));
                    break;
                }
                case "usableqty": {
                    t.setFormatValue((Object)usableqty.toPlainString());
                }
            }
        }
    }

    public void click(MobileSearchTextChangeEvent e) {
        String context = e.getText();
        this.loadList(context);
    }

    private void loadList(String context) {
        DynamicObjectCollection dataCollection = null;
        QFilter filter = new QFilter("customer", "in", this.getParameter("customerid"));
        if (context != null && !context.isEmpty()) {
            this.searchText = context;
            filter.and(QMatches.ftlike((String[])new String[]{this.searchText}, (String[])new String[]{"item.number,item.name,item.searchkey"}));
        }
        ORM orm = ORM.create();
        try (DataSet dataSet = orm.queryDataSet(this.getClass().getName(), "mdr_item_store", "customer,item.thumbnail,item.id,usableqty,qty,orderqty,measureunit.name", filter.toArray()).groupBy(new String[]{"item.thumbnail", "item.id", "measureunit.name"}).sum("qty", "sum_qty").sum("orderqty", "sum_orderqty").finish();){
            dataCollection = orm.toPlainDynamicObjectCollection(dataSet);
        }
        IDataModel model = this.getModel();
        model.deleteEntryData(ENTRYENTITY);
        int i = 0;
        for (DynamicObject data : dataCollection) {
            BigDecimal usableqty = data.getBigDecimal("sum_qty").subtract(data.getBigDecimal("sum_orderqty")).stripTrailingZeros();
            model.createNewEntryRow(ENTRYENTITY);
            model.setValue(PICTURE, data.get("item.thumbnail"), i);
            model.setValue(ITEM, data.get("item.id"), i);
            if (usableqty.compareTo(ZERO) <= 0) {
                model.setValue(HASSTORE, (Object)ResManager.loadKDString((String)"\u65e0\u8d27", (String)"MyItemStoreMobPlugin_0", (String)"drp-dma-formplugin", (Object[])new Object[0]), i);
            } else {
                model.setValue(HASSTORE, (Object)ResManager.loadKDString((String)"\u6709\u8d27\uff1a", (String)"MyItemStoreMobPlugin_1", (String)"drp-dma-formplugin", (Object[])new Object[0]), i);
                model.setValue(UNIT, data.get("measureunit.name"), i);
                model.setValue(STORE, (Object)usableqty.stripTrailingZeros().toPlainString(), i);
            }
            ++i;
        }
    }
}

