/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dpa.common.algorithm;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.entity.EntryType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.drp.dpm.common.PromotionUtil;
import kd.drp.dpm.common.model.execution.impl.AddPresentExecution;
import kd.drp.mdr.common.constants.BigDecimalConstants;
import kd.drp.mdr.common.constants.SaleOrderEntryType;
import kd.drp.mdr.common.model.dpm.DetailItemInfo;
import kd.drp.mdr.common.model.dpm.PromotionApiResult;
import kd.drp.mdr.common.model.dpm.PromotionOrder;
import kd.drp.mdr.common.model.dpm.PromotionOrderEntry;
import kd.drp.mdr.common.status.EnumUtil;
import kd.drp.mdr.common.status.SaleOrderStatus;
import kd.drp.mdr.common.util.BigDecimalUtil;
import kd.drp.mdr.common.util.CustomerUtil;
import kd.drp.mdr.common.util.DynamicObjectUtils;
import kd.drp.mdr.common.util.SaleOrderUtil;
import kd.drp.mdr.common.util.SysParamsUtil;
import kd.drp.mdr.common.util.WebUtil;
import kd.drp.mdr.formplugin.MdrFormPlugin;
import kd.drp.mdr.iAlgorithm.OrderAlgorithm;
import kd.drp.mdr.servicehelper.PromotionServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class SaleOrderAlgorithm
extends OrderAlgorithm {
    protected static Log log = LogFactory.getLog(SaleOrderAlgorithm.class);
    protected IFormView view;

    public SaleOrderAlgorithm(DynamicObject order, IFormView view, IPageCache pageCache) {
        super(order, pageCache);
        this.view = view;
    }

    public void calByCombEntryInit(int i) {
        this.calPrimAmount(i);
        this.calTaxPriceAndPrice(i);
        this.calDiscountAmount(i);
        this.calItemAmount(i);
        this.calSonEntryByComb(i);
        this.calPromotionAmount();
        this.calRebateAmount();
        this.calDealPriceAmount();
        this.calTotalFields();
        this.calBotpDiscount();
    }

    public void calByCombEntryQty(int i, String key, boolean needCalTotal) {
        this.calCombQtybyqtys(i, key);
        this.calPrimAmount(i);
        this.calTaxPriceAndPrice(i);
        this.calDiscountAmount(i);
        this.calItemAmount(i);
        this.calSonEntryByComb(i);
        this.calPromotionAmount();
        this.calRebateAmount();
        this.calDealPriceAmount();
        this.calTotalFields();
        this.calBotpDiscount();
    }

    protected void calCombQtybyqtys(int i, String key) {
        switch (key) {
            case "qty": {
                Object qty = this.getValue("qty", i);
                this.setValue("alterqty", qty, i);
                this.setValue("alterbaseqty", qty, i);
                this.setValue("baseqty", qty, i);
                break;
            }
            case "alterqty": {
                Object qty = this.getValue("alterqty", i);
                this.setValue("qty", qty, i);
                this.setValue("baseqty", qty, i);
                this.setValue("alterbaseqty", qty, i);
                break;
            }
            default: {
                throw new KDBizException(ResManager.loadKDString((String)"\u7ec4\u5408\u5546\u54c1\u4e0d\u5141\u8bb8\u4fee\u6539\u4e0b\u5355\u6570\u91cf\u548c\u786e\u8ba4\u6570\u91cf\u4ee5\u5916\u7684\u6570\u91cf\uff01", (String)"SaleOrderAlgorithm_0", (String)"drp-dpa-common", (Object[])new Object[0]));
            }
        }
    }

    public void calByCombPrice(int i, boolean needCalTotal) {
        this.calTaxPrice(i);
        this.calDiscountAmount(i);
        this.calItemAmount(i);
        this.calSonEntryByCombItemAmount(i);
        this.calPromotionAmount();
        this.calRebateAmount();
        this.calDealPriceAmount();
        if (needCalTotal) {
            this.calTotalFields();
        }
        if (needCalTotal) {
            this.calBotpDiscount();
        } else {
            this.calBotpDiscount(i);
        }
    }

    public void calByCombTaxPrice(int i, boolean needCalTotal) {
        this.calPrice(i);
        this.calDiscountAmount(i);
        this.calItemAmount(i);
        this.calSonEntryByCombItemAmount(i);
        this.calPromotionAmount();
        this.calRebateAmount();
        this.calDealPriceAmount();
        if (needCalTotal) {
            this.calTotalFields();
        }
        if (needCalTotal) {
            this.calBotpDiscount();
        } else {
            this.calBotpDiscount(i);
        }
    }

    public void calByCombTaxRate(int i, boolean needCalTotal) {
        Set<Integer> rows = this.getCombSonRows(i);
        BigDecimal taxrate = BigDecimalUtil.getNullToZero((DynamicObject)this.getEntry(i), (String)"taxrate");
        DynamicObject rateid = this.getEntry(i).getDynamicObject("taxrateid");
        for (int row : rows) {
            this.setValue("taxrate", taxrate, row);
            this.setValue("taxrateid", rateid, row);
        }
        if (this.hasTax()) {
            this.calByTaxRate(i, false);
            for (int row : rows) {
                this.calByTaxRate(row, false);
            }
            if (needCalTotal) {
                this.calTotalFields();
            }
        } else {
            this.calByCombPrice(i, needCalTotal);
        }
    }

    public void calByCombItemAmount(int i, boolean needCalTotal) {
        this.calPirceByItemAmount(i);
        this.calDiscountAmount(i);
        this.calSonEntryByCombItemAmount(i);
        this.calPromotionAmount();
        this.calRebateAmount();
        this.calDealPriceAmount();
        if (needCalTotal) {
            this.calTotalFields();
        }
        if (needCalTotal) {
            this.calBotpDiscount();
        } else {
            this.calBotpDiscount(i);
        }
    }

    protected void calSonEntryByCombItemAmount(int i) {
        Set<Integer> rows = this.getCombSonRows(i);
        DynamicObject parentEntry = this.getEntry(i);
        Object combitemId = DynamicObjectUtils.getDynamicObjectID((DynamicObject)parentEntry, (String)"combitem");
        DynamicObjectCollection combinations = QueryServiceHelper.query((String)"dpm_item_combination", (String)"pricemode,itemdetail.id,itemdetail.proportion", (QFilter[])WebUtil.getIdQFilter((Object)combitemId).toArray());
        BigDecimal parentItemAmount = BigDecimalUtil.getNullToZero((DynamicObject)parentEntry, (String)"itemamount");
        block0: for (int row : rows) {
            DynamicObject entry = this.getEntry(row);
            String combitementeryid = entry.getString("combitementeryid");
            for (DynamicObject combination : combinations) {
                if (!combitementeryid.equals(combination.get("itemdetail.id").toString())) continue;
                BigDecimal proportion = BigDecimalUtil.getNullToZero((DynamicObject)combination, (String)"itemdetail.proportion");
                if (proportion.compareTo(BigDecimal.ZERO) == 0) continue block0;
                proportion = proportion.divide(BigDecimalConstants.ONEHUNDRED);
                BigDecimal itemAmount = parentItemAmount.multiply(proportion).setScale(this.pricePrecision, RoundingMode.HALF_UP);
                this.setValue("itemamount", itemAmount, row);
                this.calPirceByItemAmount(row);
                continue block0;
            }
        }
    }

    protected void calSonEntryByComb(int i) {
        DynamicObject entry;
        Object itemdetails;
        Set<Integer> rows = this.getCombSonRows(i);
        DynamicObject parentEntry = this.getEntry(i);
        DynamicObject combitem = parentEntry.getDynamicObject("combitem");
        boolean issubgroup = combitem.getBoolean("issubgroup");
        BigDecimal combItemamount = BigDecimalUtil.getNullToZero((DynamicObject)parentEntry, (String)"itemamount");
        int bigestIndex = -1;
        BigDecimal bigestItemamount = BigDecimal.ZERO;
        BigDecimal totalItemamount = BigDecimal.ZERO;
        BigDecimal parentAlterQty = BigDecimalUtil.getNullToZero((DynamicObject)parentEntry, (String)"alterqty");
        BigDecimal parentQty = BigDecimalUtil.getNullToZero((DynamicObject)parentEntry, (String)"qty");
        HashMap<Integer, DynamicObject> iteminfos = new HashMap<Integer, DynamicObject>();
        boolean isUpdatePrice = false;
        if (SaleOrderUtil.isThisStatus((DynamicObject)this.order, (SaleOrderStatus)SaleOrderStatus.CHANGING) && SysParamsUtil.isAlterPriceResetPrice() || SaleOrderUtil.isThisStatus((DynamicObject)this.order, (SaleOrderStatus)SaleOrderStatus.TEMP_SAVE)) {
            isUpdatePrice = true;
        }
        DynamicObject itemCombination = null;
        if (issubgroup && isUpdatePrice) {
            itemCombination = BusinessDataServiceHelper.loadSingle((Object)combitem.getPkValue(), (String)"dpm_item_combination", (String)"issubgroup,totalamount,pricemode,itemdetail,itemdetail.item,itemdetail.unit,itemdetail.attr,itemdetail.qty,itemdetail.price,itemdetail.amount,itemdetail.proportion,itemdetail.isdefault,itemdetail.subgroup");
            itemdetails = itemCombination.getDynamicObjectCollection("itemdetail");
            Iterator iterator = itemdetails.iterator();
            while (iterator.hasNext()) {
                DynamicObject itemdetail = (DynamicObject)iterator.next();
                if (!itemdetail.getBoolean("isdefault")) continue;
                iteminfos.put(itemdetail.getInt("subgroup"), itemdetail);
            }
        }
        itemdetails = rows.iterator();
        while (itemdetails.hasNext()) {
            int row = itemdetails.next();
            entry = this.getEntry(row);
            BigDecimal combbaseqty = BigDecimalUtil.getNullToZero((DynamicObject)entry, (String)"combbaseqty");
            DynamicObject unit = entry.getDynamicObject("unit");
            BigDecimal alterQty = combbaseqty.multiply(parentAlterQty).setScale(unit.getInt("precision"), 4);
            BigDecimal qty = combbaseqty.multiply(parentQty).setScale(unit.getInt("precision"), 4);
            this.setValue("alterqty", alterQty, row);
            this.setValue("qty", qty, row);
            this.calQtysByQtyAndAlterQty(row);
            if (isUpdatePrice) {
                if (issubgroup) {
                    int subgroup = this.getSubgGoup(entry, itemCombination);
                    DynamicObject itemdetail = (DynamicObject)iteminfos.get(subgroup);
                    if (itemdetail != null) {
                        qty = BigDecimalUtil.getNullToZero((DynamicObject)itemdetail, (String)"qty").multiply(parentQty).setScale(unit.getInt("precision"), 4);
                        this.setValue("primprice", this.getSysPrice(entry, new DetailItemInfo(DynamicObjectUtils.getDynamicObjectID((DynamicObject)itemdetail, (String)"item"), DynamicObjectUtils.getDynamicObjectID((DynamicObject)itemdetail, (String)"unit"), DynamicObjectUtils.getDynamicObjectID((DynamicObject)itemdetail, (String)"attr")), qty), row);
                    }
                } else {
                    this.setValue("primprice", this.getSysPrice(row), row);
                }
            }
            this.calPrimAmount(row);
            this.calTaxPriceAndPrice(row);
        }
        this.calCombDiscount(i);
        for (Integer integer : rows) {
            entry = this.getEntry(integer);
            BigDecimal itemAmount = BigDecimalUtil.getNullToZero((DynamicObject)entry, (String)"itemamount");
            totalItemamount = totalItemamount.add(itemAmount);
            if (bigestItemamount.compareTo(itemAmount) >= 0) continue;
            bigestItemamount = itemAmount;
            bigestIndex = integer;
        }
        if (combItemamount.compareTo(totalItemamount) != 0 && bigestIndex >= 0) {
            BigDecimal diff = combItemamount.subtract(totalItemamount);
            bigestItemamount = bigestItemamount.add(diff);
            this.setValue("itemamount", bigestItemamount, bigestIndex);
        }
    }

    private int getSubgGoup(DynamicObject entry, DynamicObject itemCombination) {
        int subgoup = 0;
        if (entry == null || itemCombination == null) {
            return subgoup;
        }
        String key = String.format("%s_%s_%s", DynamicObjectUtils.getDynamicObjectID((DynamicObject)entry, (String)"item"), DynamicObjectUtils.getDynamicObjectID((DynamicObject)entry, (String)"unit"), DynamicObjectUtils.getDynamicObjectID((DynamicObject)entry, (String)"assistattr"));
        DynamicObjectCollection itemdetails = itemCombination.getDynamicObjectCollection("itemdetail");
        String itemkey = "";
        for (DynamicObject itemdetail : itemdetails) {
            itemkey = String.format("%s_%s_%s", DynamicObjectUtils.getDynamicObjectID((DynamicObject)itemdetail, (String)"item"), DynamicObjectUtils.getDynamicObjectID((DynamicObject)itemdetail, (String)"unit"), DynamicObjectUtils.getDynamicObjectID((DynamicObject)itemdetail, (String)"attr"));
            if (key.compareTo(itemkey) != 0) continue;
            subgoup = itemdetail.getInt("subgroup");
            break;
        }
        return subgoup;
    }

    public void calByMatchAndExecutePromotion() {
        if (!SysParamsUtil.isUsePromotion()) {
            return;
        }
        String promotionCacheKey = this.getPromotionCacheKey();
        if (!this.isOrderAvailable4Promotion()) {
            this.deletePresentEntries(new String[0]);
            if (promotionCacheKey != null && !promotionCacheKey.isEmpty()) {
                PromotionServiceHelper.removePromotionCache((String)promotionCacheKey);
            }
            return;
        }
        PromotionOrder order = this.buildPromotionOrder();
        PromotionApiResult result = PromotionServiceHelper.matchAndExecute((String)promotionCacheKey, (PromotionOrder)order);
        this.initPresentBagButton(result.getExecutions());
        this.refreshModelByPromotionOrder(result.getOrder(), "1");
        this.calAfterExecutePromotion();
    }

    private void initPresentBagButton(List<DynamicObject> executions) {
        if (executions == null || executions.size() == 0) {
            this.view.setVisible(Boolean.FALSE, new String[]{"tbispresent"});
            return;
        }
        boolean isVisible = false;
        for (DynamicObject execution : executions) {
            for (DynamicObject entry : execution.getDynamicObjectCollection("entryentity")) {
                if (entry.getString("type").compareTo("addpresentbag") != 0) continue;
                isVisible = true;
                break;
            }
            if (!isVisible) continue;
            break;
        }
        SaleOrderStatus status = SaleOrderUtil.getOrderStatus((DynamicObject)this.order);
        OperationStatus operationStatus = this.view.getFormShowParameter().getStatus();
        if (isVisible && SaleOrderStatus.TEMP_SAVE.equals((Object)status) && (OperationStatus.EDIT.equals((Object)operationStatus) || OperationStatus.ADDNEW.equals((Object)operationStatus))) {
            this.view.setVisible(Boolean.TRUE, new String[]{"tbispresent"});
        } else {
            this.view.setVisible(Boolean.FALSE, new String[]{"tbispresent"});
        }
    }

    public void addItemByPresentExecution(Object data) {
        if (data == null) {
            return;
        }
        if (data instanceof HashSet) {
            HashSet executions = (HashSet)data;
            PromotionOrder order = this.buildPromotionOrder();
            for (AddPresentExecution addPresentExecution : executions) {
                addPresentExecution.putOnOrder(order);
            }
            this.refreshModelByPromotionOrder(order, "2");
            PromotionUtil.putContextIntoCache((String)this.getPromotionCacheKey(), (Set)executions);
            this.calAfterExecutePromotion();
        }
    }

    public void calByExecutePromotion() {
        if (!SysParamsUtil.isUsePromotion()) {
            return;
        }
        String cachekey = this.getPromotionCacheKey();
        if (!this.isOrderAvailable4Promotion()) {
            this.deletePresentEntries(new String[0]);
            if (cachekey != null && !cachekey.isEmpty()) {
                PromotionServiceHelper.removePromotionCache((String)cachekey);
            }
            return;
        }
        PromotionOrder order = this.buildPromotionOrder();
        PromotionApiResult result = PromotionServiceHelper.execute((String)cachekey, (PromotionOrder)order);
        this.initPresentBagButton(result.getExecutions());
        this.refreshModelByPromotionOrder(result.getOrder(), "1");
        this.calAfterExecutePromotion();
    }

    public void calBySwitchPromotionExecutions(Object promotionid, char groupnumber) {
        if (!SysParamsUtil.isUsePromotion()) {
            return;
        }
        String cachekey = this.getPromotionCacheKey();
        if (!this.isOrderAvailable4Promotion()) {
            this.deletePresentEntries(new String[0]);
            if (cachekey != null && !cachekey.isEmpty()) {
                PromotionServiceHelper.removePromotionCache((String)cachekey);
            }
            return;
        }
        PromotionOrder order = this.buildPromotionOrder();
        PromotionApiResult result = PromotionServiceHelper.switchExecutions((String)cachekey, (PromotionOrder)order, (Object)promotionid, (char)groupnumber);
        this.initPresentBagButton(result.getExecutions());
        this.refreshModelByPromotionOrder(result.getOrder(), "1");
        this.calAfterExecutePromotion();
    }

    public void calAfterExecutePromotion() {
        this.calPresentEntry();
        this.calRebateAmount();
        this.calDealPriceAmount();
        this.calTotalFields();
        this.calBotpDiscount();
    }

    protected void calPresentEntry() {
        int entrySize = this.getEntrySize();
        for (int i = 0; i < entrySize; ++i) {
            boolean isPresent = this.isPresent(i);
            if (!isPresent) continue;
            SaleOrderEntryType type = this.getEntryType(i);
            if (type != SaleOrderEntryType.COMBINATION) {
                this.calQtysByAlterQty(i);
                this.resetPrimPrice(i);
            }
            this.calPrimAmount(i);
            this.calPriceByTaxPrice(i);
            this.calDiscountAmount(i);
            this.setDefaultPromotionAmount(i);
        }
    }

    protected void setDefaultPromotionAmount(int i) {
        DynamicObject entry = this.getEntry(i);
        BigDecimal itemAmount = BigDecimalUtil.getNullToZero((DynamicObject)entry, (String)"itemamount");
        this.setValue("promotionamount", itemAmount, i);
    }

    protected boolean isPresent(int i) {
        DynamicObject entry = this.getEntry(i);
        return this.isPresent(entry);
    }

    protected boolean isPresent(DynamicObject entry) {
        Object ispresent = entry.get("ispresent");
        if (ispresent == null) {
            return false;
        }
        return (Boolean)ispresent;
    }

    public void calPromotionAmount() {
        super.calPromotionAmount();
        if (!SysParamsUtil.isUsePromotion()) {
            return;
        }
        String cachekey = this.getPromotionCacheKey();
        if (!this.isOrderAvailable4Promotion()) {
            this.deletePresentEntries(new String[0]);
            if (cachekey != null && !cachekey.isEmpty()) {
                PromotionServiceHelper.removePromotionCache((String)cachekey);
            }
            return;
        }
        PromotionOrder order = this.buildPromotionOrder();
        log.info("PromotionOrder:" + order + "\n size:" + order.getEntries().size());
        PromotionApiResult result = PromotionServiceHelper.execute((String)cachekey, (PromotionOrder)order);
        this.initPresentBagButton(result.getExecutions());
        if (result != null) {
            log.info("result execution:" + result.getExecutions());
            log.info("result promotion:" + result.getPromotions());
            this.refreshModelByPromotionOrder(result.getOrder(), "1");
        }
        this.calPresentEntry();
    }

    protected boolean isOrderAvailable4Promotion() {
        DynamicObject item;
        if (SaleOrderUtil.getOrderStatus((DynamicObject)this.order) == SaleOrderStatus.CHANGING) {
            return false;
        }
        DynamicObjectCollection entrys = this.getEntry();
        if (entrys == null || entrys.size() == 0) {
            return false;
        }
        if (entrys.size() == 1 && (item = ((DynamicObject)entrys.get(0)).getDynamicObject("item")) == null) {
            return false;
        }
        for (DynamicObject entry : entrys) {
            DynamicObject item2;
            if (this.isPresent(entry) || SaleOrderEntryType.COMBINATION.getFlagStr().equals(entry.getString("entrytype")) && entry.getDynamicObject("combitem") != null || (item2 = entry.getDynamicObject("item")) == null) continue;
            DynamicObject unit = entry.getDynamicObject("unit");
            if (unit == null) {
                return false;
            }
            if (this.hasAssistAttr(item2) && entry.getDynamicObject("assistattr") == null) {
                return false;
            }
            if (entry.getBigDecimal("qty").compareTo(BigDecimal.ZERO) != 0) continue;
            return false;
        }
        return true;
    }

    public PromotionOrder buildPromotionOrder() {
        PromotionOrder promotionOrder = new PromotionOrder();
        promotionOrder.setOwnerid(DynamicObjectUtils.getDynamicObjectID((DynamicObject)this.order, (String)"owner"));
        promotionOrder.setCustomerid(DynamicObjectUtils.getDynamicObjectID((DynamicObject)this.order, (String)"customer"));
        promotionOrder.setCreatetime((Date)this.getValue(SysParamsUtil.getPromotionTime()));
        promotionOrder.setSourceFromKey(this.getSourceFromKey(this.getModelName()));
        DynamicObjectCollection entrycol = this.getEntry();
        for (int i = 0; i < entrycol.size(); ++i) {
            BigDecimal itemTaxprice;
            BigDecimal itemAmount;
            BigDecimal qty;
            DynamicObject entry = (DynamicObject)entrycol.get(i);
            if (entry.getBoolean("ispresent") || (qty = BigDecimalUtil.getNullToZero((DynamicObject)entry, (String)"qty")).compareTo(BigDecimal.ZERO) == 0) continue;
            PromotionOrderEntry pentry = new PromotionOrderEntry();
            pentry.setEntryid(this.getEntryId(i));
            pentry.setType(SaleOrderEntryType.getByFlag((String)entry.getString("entrytype")));
            Long sourcebillid = kd.drp.mdr.common.StringUtils.isEmpty((String)entry.getString("parententryid")) ? 0L : Long.parseLong(entry.getString("parententryid"));
            pentry.setSourceentryid((Object)sourcebillid);
            pentry.setIspresent(false);
            if (SaleOrderEntryType.COMBINATION.getFlagStr().equals(entry.getString("entrytype"))) {
                pentry.setItemid(entry.getDynamicObject("combitem").getPkValue());
                pentry.setUnitid((Object)0L);
                pentry.setAttrid((Object)0L);
                pentry.setQty(qty);
                itemAmount = BigDecimalUtil.getNullToZero((DynamicObject)entry, (String)"itemamount");
                itemTaxprice = BigDecimal.ZERO;
                if (itemAmount.compareTo(BigDecimal.ZERO) != 0) {
                    itemTaxprice = itemAmount.divide(qty, this.pricePrecision, RoundingMode.HALF_UP);
                }
                pentry.setAmount(itemAmount);
                pentry.setPrice(itemTaxprice);
                pentry.setIscombination(true);
                pentry.setSourceentryid((Object)0L);
            } else {
                pentry.setItemid(entry.getDynamicObject("item").getPkValue());
                pentry.setUnitid(entry.getDynamicObject("unit").getPkValue());
                pentry.setAttrid(entry.getDynamicObject("assistattr") == null ? Long.valueOf(0L) : entry.getDynamicObject("assistattr").getPkValue());
                itemAmount = BigDecimalUtil.getNullToZero((DynamicObject)entry, (String)"itemamount");
                itemTaxprice = BigDecimal.ZERO;
                if (itemAmount.compareTo(BigDecimal.ZERO) != 0) {
                    itemTaxprice = itemAmount.divide(qty, this.pricePrecision, RoundingMode.HALF_UP);
                }
                pentry.setQty(qty);
                pentry.setPrice(itemTaxprice);
                pentry.setAmount(itemAmount);
                pentry.setIscombination(false);
            }
            promotionOrder.addEntry(pentry);
        }
        return promotionOrder;
    }

    public PromotionOrder buildPromotionOrderWithPresent() {
        PromotionOrder promotionOrder = new PromotionOrder();
        promotionOrder.setOwnerid(DynamicObjectUtils.getDynamicObjectID((DynamicObject)this.order, (String)"owner"));
        promotionOrder.setCustomerid(DynamicObjectUtils.getDynamicObjectID((DynamicObject)this.order, (String)"customer"));
        promotionOrder.setCreatetime(new Date());
        PromotionApiResult ctx = null;
        String cachekey = this.order.getString("promotioncachekey");
        if (cachekey.isEmpty()) {
            long orderid = (Long)this.order.getPkValue();
            ctx = PromotionServiceHelper.getPromotionResult((Long)orderid);
            cachekey = ctx.getCachekey();
        } else {
            ctx = PromotionServiceHelper.getPromotionResult((String)cachekey);
        }
        promotionOrder.setPromotioncachekey(cachekey);
        List executions = ctx.getExecutions();
        ArrayList<Object> orderEntryids = new ArrayList<Object>();
        boolean isall = false;
        if (executions != null && !executions.isEmpty()) {
            DynamicObjectCollection entryentity = null;
            String sourceentryids = "";
            String type = "";
            Object entryid = null;
            block0: for (DynamicObject execution : executions) {
                entryentity = execution.getDynamicObjectCollection("entryentity");
                if (entryentity == null || entryentity.isEmpty()) continue;
                if (isall) break;
                for (DynamicObject entry : entryentity) {
                    type = entry.getString("type");
                    if (type.compareTo("addpresent") == 0 || type.compareTo("addpresentbag") == 0) {
                        String[] entryids;
                        sourceentryids = entry.getString("sourceentryids");
                        if (sourceentryids == null || sourceentryids.isEmpty()) continue;
                        for (String itementryid : entryids = sourceentryids.split(",")) {
                            entryid = Long.parseLong(itementryid);
                            if (orderEntryids.contains(entryid)) continue;
                            orderEntryids.add(entryid);
                        }
                        continue;
                    }
                    if (type.compareTo("orderdiff") == 0) {
                        isall = true;
                        continue block0;
                    }
                    entryid = entry.get("entryid");
                    if (entryid == null || orderEntryids.contains(entryid)) continue;
                    orderEntryids.add(entryid);
                }
            }
        }
        DynamicObjectCollection entrycol = this.getEntry();
        Object limitid = 0L;
        String limitentryid = "";
        String entrytype = "";
        for (int i = 0; i < entrycol.size(); ++i) {
            BigDecimal itemTaxprice;
            BigDecimal itemAmount;
            BigDecimal qty;
            DynamicObject entry = (DynamicObject)entrycol.get(i);
            if (entry.getDynamicObject("item") == null && entry.getDynamicObject("combitem") == null || (qty = BigDecimalUtil.getNullToZero((DynamicObject)entry, (String)"qty")).compareTo(BigDecimal.ZERO) == 0) continue;
            entrytype = entry.getString("entrytype");
            if (SaleOrderEntryType.COMBINATION_SON.getFlagStr().equals(entrytype)) continue;
            PromotionOrderEntry pentry = new PromotionOrderEntry();
            if (entry.getBoolean("ispresent")) {
                pentry.setIspresent(true);
            }
            pentry.setEntryid(this.getEntryId(i));
            pentry.setType(SaleOrderEntryType.getByFlag((String)entrytype));
            Long sourcebillid = kd.drp.mdr.common.StringUtils.isEmpty((String)entry.getString("parententryid")) ? 0L : Long.parseLong(entry.getString("parententryid"));
            pentry.setSourceentryid((Object)sourcebillid);
            if (SaleOrderEntryType.COMBINATION.getFlagStr().equals(entrytype)) {
                pentry.setItemid(entry.getDynamicObject("combitem").getPkValue());
                pentry.setUnitid((Object)0L);
                pentry.setAttrid((Object)0L);
                pentry.setQty(qty);
                itemAmount = BigDecimalUtil.getNullToZero((DynamicObject)entry, (String)"itemamount");
                itemTaxprice = BigDecimal.ZERO;
                if (itemAmount.compareTo(BigDecimal.ZERO) != 0) {
                    itemTaxprice = itemAmount.divide(qty, this.pricePrecision, RoundingMode.HALF_UP);
                }
                pentry.setAmount(itemAmount);
                pentry.setPrice(itemTaxprice);
                pentry.setIscombination(true);
                pentry.setSourceentryid((Object)0L);
            } else {
                pentry.setItemid(entry.getDynamicObject("item").getPkValue());
                pentry.setUnitid(entry.getDynamicObject("unit").getPkValue());
                pentry.setAttrid(entry.getDynamicObject("assistattr") == null ? Long.valueOf(0L) : entry.getDynamicObject("assistattr").getPkValue());
                itemAmount = BigDecimalUtil.getNullToZero((DynamicObject)entry, (String)"itemamount");
                itemTaxprice = BigDecimal.ZERO;
                if (itemAmount.compareTo(BigDecimal.ZERO) != 0) {
                    itemTaxprice = itemAmount.divide(qty, this.pricePrecision, RoundingMode.HALF_UP);
                }
                pentry.setQty(qty);
                pentry.setPrice(itemTaxprice);
                pentry.setAmount(itemAmount);
                pentry.setIscombination(false);
            }
            promotionOrder.addEntry(pentry);
            if (isall || orderEntryids.contains(pentry.getEntryid())) {
                promotionOrder.addPolicyEntry(pentry);
                continue;
            }
            limitid = DynamicObjectUtils.getDynamicObjectID((DynamicObject)entry, (String)"limit");
            limitentryid = entry.getString("limitentryid");
            if (limitid != null && !limitid.equals(0L) || limitentryid.compareTo("1") != 0) continue;
            promotionOrder.addPolicyEntry(pentry);
        }
        return promotionOrder;
    }

    protected void refreshModelByPromotionOrder(PromotionOrder order, String ... presentTypes) {
        String presentType = "1";
        if (presentTypes != null && presentTypes.length == 1) {
            presentType = presentTypes[0];
        }
        if (presentType.compareTo("2") == 0) {
            this.deletePresentEntries(presentType);
        } else {
            this.deletePresentEntries(new String[0]);
        }
        boolean haPresentEntry = false;
        ArrayList<PromotionOrderEntry> presentpentrys = new ArrayList<PromotionOrderEntry>();
        DynamicObjectCollection entrycol = this.getEntry();
        block0: for (PromotionOrderEntry pentry : order.getEntries()) {
            int i;
            if (pentry.isIspresent()) {
                if (pentry.getPsourceentryid() != null) {
                    for (i = 0; i < entrycol.size(); ++i) {
                        if (!((DynamicObject)entrycol.get(i)).getPkValue().equals(pentry.getPsourceentryid())) continue;
                        if (this.getEntryType(i).equals((Object)SaleOrderEntryType.COMBINATION)) {
                            Set<Integer> rows = this.getCombSonRows(i);
                            for (int row : rows) {
                                if (i >= row) continue;
                                i = row;
                            }
                        }
                        this.insertEntry(i + 1);
                        DynamicObject itementry = this.getEntry(i + 1);
                        itementry.set("id", pentry.getEntryid());
                        this.setPresentEntryValues(i + 1, pentry, presentType);
                        break;
                    }
                } else {
                    presentpentrys.add(pentry);
                }
                haPresentEntry = true;
                continue;
            }
            if (presentType.compareTo("2") == 0) continue;
            for (i = 0; i < entrycol.size(); ++i) {
                DynamicObject entry = (DynamicObject)entrycol.get(i);
                if (!pentry.getEntryid().equals(entry.getPkValue())) continue;
                this.setValue("promotionamount", pentry.getAmount(), i);
                continue block0;
            }
        }
        for (int i = 0; i < entrycol.size(); ++i) {
            DynamicObject entry = (DynamicObject)entrycol.get(i);
            if (entry.getString("limitentryid").compareTo("1") != 0) continue;
            this.setValue("limitentryid", 0L, i);
        }
        if (!presentpentrys.isEmpty()) {
            this.batchCreatePresentEntrys(presentpentrys, presentTypes);
        }
        if (haPresentEntry) {
            this.deleteEmptyEntries();
        }
    }

    private int[] getEmptyEntry(DynamicObjectCollection entrys) {
        ArrayList<Integer> emptyEntrys = new ArrayList<Integer>();
        for (int i = 0; i < entrys.size(); ++i) {
            DynamicObject entry = (DynamicObject)entrys.get(i);
            Object item = entry.get("item");
            Object combitem = entry.get("combitem");
            if (item != null || combitem != null) continue;
            emptyEntrys.add(i);
        }
        int[] emptyEntryArray = new int[emptyEntrys.size()];
        for (int i = 0; i < emptyEntrys.size(); ++i) {
            emptyEntryArray[i] = (Integer)emptyEntrys.get(i);
        }
        return emptyEntryArray;
    }

    private void deleteEmptyEntries() {
        int[] emptyEntry = this.getEmptyEntry(this.getEntry());
        if (emptyEntry != null) {
            this.getModel().deleteEntryRows(this.getEntryKey(), emptyEntry);
        }
    }

    protected int[] batchCreatePresentEntrys(List<PromotionOrderEntry> entrys, String ... presentType) {
        int[] indexes = this.batchAddEntry(entrys.size());
        int entryindex = 0;
        for (int index : indexes) {
            PromotionOrderEntry pentry = entrys.get(entryindex);
            this.setPresentEntryValues(index, pentry, presentType);
            ++entryindex;
        }
        return indexes;
    }

    @Deprecated
    public BigDecimal getDefaultTaxRate() {
        BigDecimal taxRate = BigDecimal.ZERO;
        DynamicObject customer = (DynamicObject)this.getValue("customer");
        DynamicObject owner = (DynamicObject)this.getValue("owner");
        if (customer == null || owner == null) {
            return taxRate;
        }
        StringBuilder cacheKeyStr = new StringBuilder();
        cacheKeyStr.append("TaxRate_").append(owner.get("id")).append('_').append(customer.get("id"));
        String cacheKey = cacheKeyStr.toString();
        String cache = this.pageCache.get(cacheKey);
        if (kd.drp.mdr.common.StringUtils.isEmpty((String)cache)) {
            DynamicObject authInfo = CustomerUtil.getAuthBizInfo((Object)owner.get("id"), (Object)customer.get("id"));
            taxRate = authInfo.getBigDecimal("taxrate");
            DynamicObject taxrateinfo = authInfo.getDynamicObject("taxrateid");
            String taxrateid = "";
            taxrateid = taxrateinfo != null ? taxrateinfo.get("id").toString() : "0";
            this.pageCache.put(cacheKey, taxRate.toString() + "$" + taxrateid);
        } else {
            String[] values = cache.split("\\$");
            taxRate = new BigDecimal(values[0]);
        }
        return taxRate;
    }

    public HashMap<String, String> getDefaultTaxRateInfo() {
        HashMap<String, String> retMap = new HashMap<String, String>();
        BigDecimal taxRate = BigDecimal.ZERO;
        DynamicObject customer = (DynamicObject)this.getValue("customer");
        DynamicObject owner = (DynamicObject)this.getValue("owner");
        if (customer == null || owner == null) {
            return retMap;
        }
        StringBuilder cacheKeyStr = new StringBuilder();
        cacheKeyStr.append("TaxRate_").append(owner.get("id")).append('_').append(customer.get("id"));
        String cacheKey = cacheKeyStr.toString();
        String cache = this.pageCache.get(cacheKey);
        if (kd.drp.mdr.common.StringUtils.isEmpty((String)cache)) {
            DynamicObject authInfo = CustomerUtil.getAuthBizInfo((Object)owner.get("id"), (Object)customer.get("id"));
            taxRate = authInfo.getBigDecimal("taxrate");
            DynamicObject taxrateinfo = authInfo.getDynamicObject("taxrateid");
            String taxrateid = "";
            taxrateid = taxrateinfo != null ? taxrateinfo.get("id").toString() : "0";
            this.pageCache.put(cacheKey, taxRate.toString() + "$" + taxrateid);
            retMap.put("taxrate", taxRate.toString());
            retMap.put("taxrateid", taxrateid);
        } else {
            String[] values = cache.split("\\$");
            retMap.put("taxrate", values[0]);
            retMap.put("taxrateid", values[1]);
        }
        return retMap;
    }

    protected void setPresentEntryValues(int index, PromotionOrderEntry entry, String ... presentTypes) {
        String presentType = "1";
        if (presentTypes != null && presentTypes.length == 1) {
            presentType = presentTypes[0];
        }
        this.setValue("ispresent", Boolean.TRUE, index);
        this.setValue("entrytype", entry.getType().getFlagStr(), index);
        this.setValue("ispromotional", presentType, index);
        if (entry.isIscombination()) {
            this.setValue("combitem", entry.getItemid(), index);
            this.setValue("qty", entry.getQty(), index);
            this.setValue("alterqty", entry.getQty(), index);
            this.setValue("taxprice", entry.getPrice(), index);
            this.setValue("custchangeprice", Boolean.TRUE, index);
            this.setValue("primamount", entry.getAmount(), index);
            this.setValue("promotionamount", entry.getAmount(), index);
            this.setValue("discounttype", null, index);
            this.setValue("discount", 0, index);
            this.setValue("discountamount", 0, index);
            this.setPresentSonEntryValues(index, entry, presentType);
        } else {
            this.setValue("ismatchpromotion", Boolean.TRUE);
            this.setValue("item", entry.getItemid(), index, false);
            this.setValue("unit", entry.getUnitid(), index);
            this.setValue("assistattr", entry.getAttrid(), index);
            this.setValue("alterqty", entry.getQty(), index);
            this.setValue("qty", entry.getQty(), index);
            this.setValue("assistunit", this.getUnitFormHandler().getAssistUnitId(entry.getItemid()), index);
            this.setValue("taxprice", entry.getPrice(), index);
            this.setValue("custchangeprice", Boolean.TRUE, index);
            this.setValue("primamount", entry.getAmount(), index);
            this.setValue("promotionamount", entry.getAmount(), index);
            this.setValue("discounttype", null, index);
            this.setValue("discount", 0, index);
            this.setValue("discountamount", 0, index);
            this.setValue("ismatchpromotion", Boolean.FALSE);
        }
        DynamicObject item = this.getEntryF7Value("itementry", "item", index);
        if (item == null) {
            return;
        }
        DynamicObject material = item.getDynamicObject("material");
        this.setValue("material", material, index);
    }

    protected void setPresentSonEntryValues(int parentIndex, PromotionOrderEntry entry, String presentType) {
        Object combId = this.getEntryF7PKValue("itementry", "combitem", parentIndex);
        if (combId == null) {
            return;
        }
        DynamicObject itemCombination = BusinessDataServiceHelper.loadSingle((Object)combId, (String)"dpm_item_combination", (String)"issubgroup,totalamount,pricemode,itemdetail,itemdetail.item,itemdetail.unit,itemdetail.attr,itemdetail.qty,itemdetail.price,itemdetail.amount,itemdetail.proportion,itemdetail.isdefault,itemdetail.subgroup");
        String parentId = this.getEntryId(parentIndex).toString();
        DynamicObjectCollection itemdetails = itemCombination.getDynamicObjectCollection("itemdetail");
        boolean issubgroup = itemCombination.getBoolean("issubgroup");
        int index = parentIndex;
        BigDecimal parentQty = entry.getQty();
        for (int j = 0; j < itemdetails.size(); ++j) {
            DynamicObject itemdetail = (DynamicObject)itemdetails.get(j);
            if (issubgroup && !itemdetail.getBoolean("isdefault")) continue;
            this.insertEntry(++index);
            BigDecimal qty = parentQty.multiply(itemdetail.getBigDecimal("qty")).setScale(this.pricePrecision, RoundingMode.HALF_UP);
            this.setValue("ispresent", Boolean.TRUE, index);
            this.setValue("entrytype", SaleOrderEntryType.COMBINATION_SON.getFlagStr(), index);
            this.setValue("ispromotional", presentType, index);
            this.setValue("combitem", combId, index);
            DynamicObject item = itemdetail.getDynamicObject("item");
            Object itemId = item.getPkValue();
            Object baseunitId = item.get("baseunit.id");
            DynamicObject material = item.getDynamicObject("material");
            this.setValue("material", material, index);
            this.setValue("item", itemId, index, false);
            this.setValue("baseunit", baseunitId, index, false);
            this.setValue("unit", itemdetail.getDynamicObject("unit").getPkValue(), index);
            this.setValue("assistattr", itemdetail.getDynamicObject("attr") == null ? Long.valueOf(0L) : itemdetail.getDynamicObject("attr").getPkValue(), index);
            this.setValue("parententryid", parentId, index);
            this.setValue("alterqty", qty, index);
            this.setValue("qty", qty, index);
            this.setValue("assistunit", this.getUnitFormHandler().getAssistUnitId(itemId), index);
            this.setValue("taxprice", BigDecimal.ZERO, index);
            this.setValue("custchangeprice", Boolean.TRUE, index);
            this.setValue("primamount", BigDecimal.ZERO, index);
            this.setValue("promotionamount", BigDecimal.ZERO, index);
            this.setValue("discounttype", null, index);
            this.setValue("discount", 0, index);
            this.setValue("discountamount", 0, index);
        }
    }

    protected void deletePresentEntries(String ... presentType) {
        DynamicObjectCollection entrys = this.getEntry();
        ArrayList<Integer> emptyEntrys = new ArrayList<Integer>();
        for (int i = 0; i < entrys.size(); ++i) {
            String promotional;
            DynamicObject entry = (DynamicObject)entrys.get(i);
            Object ispromotional = entry.get("ispromotional");
            String string = promotional = ispromotional == null ? "" : ispromotional.toString();
            if (promotional.isEmpty() || (presentType.length != 0 || promotional.compareTo("0") == 0) && (presentType.length != 1 || promotional.compareTo("2") != 0)) continue;
            emptyEntrys.add(i);
        }
        if (emptyEntrys.size() > 0) {
            int[] emptyEntryArray = new int[emptyEntrys.size()];
            for (int i = 0; i < emptyEntrys.size(); ++i) {
                emptyEntryArray[i] = (Integer)emptyEntrys.get(i);
            }
            this.getModel().deleteEntryRows(this.getEntryKey(), emptyEntryArray);
        }
    }

    public String getPromotionCacheKey() {
        String key = (String)this.getValue("promotioncachekey");
        if (kd.drp.mdr.common.StringUtils.isEmpty((String)key)) {
            key = UUID.randomUUID().toString();
            this.setValue("promotioncachekey", key);
        }
        return key;
    }

    public Set<Integer> getCombSonRows(int i) {
        HashSet<Integer> rows = new HashSet<Integer>();
        SaleOrderEntryType entryType = this.getEntryType(i);
        Object entryId = this.getEntryId(i);
        if (entryType != SaleOrderEntryType.COMBINATION) {
            return rows;
        }
        for (int j = 0; j < this.getEntrySize(); ++j) {
            if (i == j || SaleOrderEntryType.COMBINATION_SON != (entryType = this.getEntryType(j))) continue;
            String parententryid = (String)this.getValue("parententryid", j);
            if (!entryId.toString().equals(parententryid)) continue;
            rows.add(j);
        }
        return rows;
    }

    protected SaleOrderEntryType getEntryType(int i) {
        String entrytype = (String)this.getValue("entrytype", i);
        if (kd.drp.mdr.common.StringUtils.isEmpty((String)entrytype)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7b2c", (String)"SaleOrderAlgorithm_2", (String)"drp-dpa-common", (Object[])new Object[0]) + (i + 1) + ResManager.loadKDString((String)"\u884c\u5206\u5f55\uff0c\u5206\u5f55\u7c7b\u578b\u4e3a\u7a7a", (String)"SaleOrderAlgorithm_3", (String)"drp-dpa-common", (Object[])new Object[0]));
        }
        return EnumUtil.toSaleOrderEntryType((String)entrytype);
    }

    public void calByUsedRebateChanged() {
        this.calRebateAmount();
        this.calDealPriceAmount();
        this.calBotpDiscount();
        this.calTotalFields();
    }

    public void calRebateAmount() {
        if (SaleOrderUtil.isThisStatus((DynamicObject)this.order, (SaleOrderStatus)SaleOrderStatus.CHANGING)) {
            return;
        }
        BigDecimal totalOrderAmount = this.sumEntryFiled("promotionamount");
        BigDecimal usedRebate = this.calUsedRebate(totalOrderAmount);
        this.setValue("usedrebate", usedRebate);
        DynamicObjectCollection entrys = this.order.getDynamicObjectCollection("itementry");
        if (entrys.size() == 0) {
            return;
        }
        DynamicObject entry = null;
        if (totalOrderAmount.compareTo(BigDecimal.ZERO) == 0 || BigDecimal.ZERO.compareTo(usedRebate) == 0) {
            int len = entrys.size();
            for (int i = 0; i < len; ++i) {
                entry = (DynamicObject)entrys.get(i);
                this.setValue("entryusedrebate", BigDecimal.ZERO, i);
                this.setValue("rebateamount", entry.getBigDecimal("promotionamount"), i);
            }
        } else {
            int i;
            BigDecimal entryUsedRebate = null;
            DynamicObject currency = this.order.getDynamicObject("currency");
            int amtprecision = currency.getInt("amtprecision");
            BigDecimal tempTotalAmount = BigDecimal.ZERO;
            BigDecimal promotionamount = BigDecimal.ZERO;
            ArrayList<Integer> indexs = new ArrayList<Integer>();
            int len = entrys.size();
            for (int i2 = 0; i2 < len; ++i2) {
                entry = (DynamicObject)entrys.get(i2);
                if (this.getEntryType(entry).equals((Object)SaleOrderEntryType.COMBINATION)) continue;
                if (entry.getBigDecimal("promotionamount").compareTo(BigDecimal.ZERO) == 0) {
                    this.setValue("entryusedrebate", BigDecimal.ZERO, i2);
                    this.setValue("rebateamount", entry.getBigDecimal("promotionamount"), i2);
                    continue;
                }
                indexs.add(i2);
            }
            int size = indexs.size();
            if (size == 0) {
                return;
            }
            Integer integer = 0;
            for (i = 0; i < size; ++i) {
                integer = (Integer)indexs.get(i);
                entry = (DynamicObject)entrys.get(integer.intValue());
                if (this.getEntryType(entry).equals((Object)SaleOrderEntryType.COMBINATION)) continue;
                promotionamount = entry.getBigDecimal("promotionamount");
                if (i < size - 1) {
                    entryUsedRebate = usedRebate.multiply(promotionamount).divide(totalOrderAmount, amtprecision, 4);
                    this.setValue("entryusedrebate", entryUsedRebate, integer);
                    tempTotalAmount = tempTotalAmount.add(entryUsedRebate);
                } else {
                    this.setValue("entryusedrebate", usedRebate.subtract(tempTotalAmount), integer);
                }
                this.setValue("rebateamount", promotionamount.subtract(entry.getBigDecimal("entryusedrebate")), integer);
            }
            int len2 = entrys.size();
            for (i = 0; i < len2; ++i) {
                entry = (DynamicObject)entrys.get(i);
                if (!this.getEntryType(entry).equals((Object)SaleOrderEntryType.COMBINATION)) continue;
                BigDecimal combUsedrebate = BigDecimal.ZERO;
                Set<Integer> combSonRows = this.getCombSonRows(i);
                for (Integer combSonRow : combSonRows) {
                    DynamicObject sonEntry = this.getEntry(combSonRow);
                    combUsedrebate = combUsedrebate.add(BigDecimalUtil.getNullToZero((DynamicObject)sonEntry, (String)"entryusedrebate"));
                }
                this.setValue("rebateamount", entry.getBigDecimal("promotionamount").subtract(combUsedrebate), i);
            }
        }
    }

    private BigDecimal calUsedRebate(BigDecimal totalOrderAmount) {
        BigDecimal usedRebate = BigDecimal.ZERO;
        if (this.order.getBoolean("canuserebate")) {
            if (!this.order.getBoolean("isusersetrebate")) {
                DynamicObject owner = this.order.getDynamicObject("owner");
                DynamicObject customer = this.order.getDynamicObject("customer");
                DynamicObject accountType = this.order.getDynamicObject("rebateaccounttype");
                DynamicObject currency = this.order.getDynamicObject("currency");
                if (owner != null && customer != null && accountType != null && currency != null) {
                    BigDecimal rebateBalance = this.order.getBigDecimal("rebatebalance");
                    if (totalOrderAmount.compareTo(BigDecimal.ZERO) > 0 && rebateBalance.compareTo(BigDecimal.ZERO) > 0) {
                        String jsonRule = this.queryRebateRuleUseCache(owner.get("id"), customer.get("id"), accountType.get("id"), currency.get("id"));
                        BigDecimal ratio = null;
                        if (!StringUtils.isEmpty((CharSequence)jsonRule)) {
                            JSONObject info = JSON.parseObject((String)jsonRule);
                            ratio = info.getBigDecimal("byratio");
                        }
                        if (ratio == null) {
                            ratio = new BigDecimal(100);
                        }
                        if (rebateBalance.compareTo(usedRebate = totalOrderAmount.multiply(ratio).divide(new BigDecimal(100), this.getAmountPrecision(), 4)) < 0) {
                            usedRebate = rebateBalance;
                        }
                    }
                }
            } else {
                if (totalOrderAmount.compareTo(this.order.getBigDecimal("usedrebate")) < 0) {
                    return totalOrderAmount;
                }
                return this.order.getBigDecimal("usedrebate");
            }
        }
        return usedRebate;
    }

    protected int getAmountPrecision() {
        DynamicObject currency = this.order.getDynamicObject("currency");
        int amtprecision = currency.getInt("amtprecision");
        return amtprecision;
    }

    private String queryRebateRuleUseCache(Object ownerId, Object customerId, Object accountTypeId, Object currencyId) {
        String key = new StringBuffer("RebateRule4Order").append(ownerId).append(customerId).append(accountTypeId).append(currencyId).toString();
        String jsonRule = null;
        if (this.pageCache != null) {
            jsonRule = this.pageCache.get(key);
            if (jsonRule == null) {
                jsonRule = (String)DispatchServiceHelper.invokeBizService((String)"drp", (String)"drm", (String)"RebateService", (String)"getRuleJsonInfo", (Object[])new Object[]{ownerId, customerId, accountTypeId, currencyId});
                this.pageCache.put(key, jsonRule);
            }
        } else {
            jsonRule = (String)DispatchServiceHelper.invokeBizService((String)"drp", (String)"drm", (String)"RebateService", (String)"getRuleJsonInfo", (Object[])new Object[]{ownerId, customerId, accountTypeId, currencyId});
        }
        return jsonRule;
    }

    public void setValue(String key, Object value) {
        MdrFormPlugin.triggerChangeEventLocal.set(Boolean.FALSE);
        this.view.getModel().setValue(key, value);
        MdrFormPlugin.triggerChangeEventLocal.remove();
    }

    public void setValue(String key, Object value, int i) {
        MdrFormPlugin.triggerChangeEventLocal.set(Boolean.FALSE);
        this.view.getModel().setValue(key, value, i);
        MdrFormPlugin.triggerChangeEventLocal.remove();
    }

    public IDataModel getModel() {
        return this.view.getModel();
    }

    public void insertEntry(int i) {
        this.view.getModel().insertEntryRow("itementry", i);
        DynamicObject entry = this.getEntry(i);
        this.setId4RowIfNoId(entry);
    }

    public void insertEntry(int i, DynamicObject entry) {
        this.setId4RowIfNoId(entry);
        this.getModel().createNewEntryRow("itementry", i, entry);
    }

    public int addEntry() {
        DynamicObject newEntry = this.getNewEntry();
        this.setId4RowIfNoId(newEntry);
        int index = this.getModel().createNewEntryRow("itementry", newEntry);
        return index;
    }

    public int[] batchAddEntry(int i) {
        int[] indexs = new int[i];
        for (int j = 0; j < i; ++j) {
            int index;
            indexs[j] = index = this.addEntry();
        }
        return indexs;
    }

    public DynamicObject getNewEntry() {
        DynamicObject newEntry = super.getNewEntry();
        this.setId4RowIfNoId(newEntry);
        return newEntry;
    }

    protected void setId4RowIfNoId(DynamicObject entry) {
        Object entryId = entry.get("id");
        if (entryId == null || (Long)entryId == 0L) {
            long genLongId = DB.genLongId((String)((EntryType)entry.getDataEntityType()).getAlias());
            entry.set("id", (Object)genLongId);
        }
    }

    public String getSourceFromKey(String fromname) {
        String sourcefromkey = "";
        switch (fromname) {
            case "bbc_saleorder": 
            case "dpa_purorder": {
                sourcefromkey = "A";
                break;
            }
        }
        return sourcefromkey;
    }
}

