/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dpa.common.algorithm;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.drp.dpa.common.algorithm.SaleOrderAlgorithm;
import kd.drp.mdr.common.model.dpm.PromotionOrder;
import kd.drp.mdr.common.model.dpm.PromotionOrderEntry;

public class SaleOrderMobAlgorithm
extends SaleOrderAlgorithm {
    public SaleOrderMobAlgorithm(DynamicObject order, IFormView view, IPageCache pageCache) {
        super(order, view, pageCache);
    }

    @Override
    protected void refreshModelByPromotionOrder(PromotionOrder order, String ... presentTypes) {
        super.refreshModelByPromotionOrder(order, presentTypes);
        HashSet<Object> presentIds = new HashSet<Object>();
        for (PromotionOrderEntry poe : order.getEntries()) {
            if (!poe.isIspresent()) continue;
            presentIds.add(poe.getItemid());
        }
        this.fillPresentItemValue(presentIds);
    }

    protected void fillPresentItemValue(Set<Object> itemIds) {
        DynamicObject[] items = BusinessDataServiceHelper.load((String)"mdr_item_info", (String)"id,thumbnail", (QFilter[])new QFilter("id", "in", itemIds).toArray());
        HashMap<Object, Object> itemThumbnailMap = new HashMap<Object, Object>(items.length);
        for (DynamicObject item : items) {
            itemThumbnailMap.put(item.get("id"), item.get("thumbnail"));
        }
        DynamicObjectCollection itemEnties = this.order.getDynamicObjectCollection("itementry");
        for (DynamicObject itemEntry : itemEnties) {
            if (!itemEntry.getBoolean("ispresent")) continue;
            Object itemId = itemEntry.getDynamicObject("item").get("id");
            itemEntry.set("itemimg", itemThumbnailMap.get(itemId));
        }
    }

    @Override
    public String getSourceFromKey(String fromname) {
        String sourcefromkey = "";
        switch (fromname) {
            case "bbc_saleorder": {
                sourcefromkey = "D";
                break;
            }
            case "dpa_purorder": {
                sourcefromkey = "C";
                break;
            }
        }
        return sourcefromkey;
    }
}

