/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dpa.opplugin.newsaleorder;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.ValidationErrorInfo;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.drp.mdr.common.status.SaleOrderStatus;
import kd.drp.mdr.common.util.SaleOrderUtil;
import kd.drp.mdr.opplugin.MdrBaseOperationServicePlugIn;

public class SaleOrderClosePlugin
extends MdrBaseOperationServicePlugIn {
    protected static final String CLOSEORDER = "closeorder";
    protected static final String UNCLOSEORDER = "uncloseorder";
    protected static final String ENTRYCLOSE = "entryclose";
    protected static final String ENTRYUNCLOSE = "entryunclose";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("closestatus");
        fieldKeys.add("billno");
        fieldKeys.add("usedbalance");
        fieldKeys.add("usedrebate");
        fieldKeys.add("orderstatus");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        String key = e.getOperationKey();
        DynamicObject[] datas = e.getDataEntities();
        switch (key) {
            case "closeorder": {
                this.handleBeginSaveClose(e, datas, "\u5173\u95ed", "0");
                datas = e.getDataEntities();
                if (datas.length <= 0) break;
                SaveServiceHelper.update((DynamicObject[])datas);
                break;
            }
            case "uncloseorder": {
                this.handleBeginSaveClose(e, datas, "\u53cd\u5173\u95ed", "1");
                datas = e.getDataEntities();
                if (datas.length <= 0) break;
                SaveServiceHelper.update((DynamicObject[])datas);
                break;
            }
            case "entryclose": {
                if (datas.length <= 0) break;
                SaveServiceHelper.update((DynamicObject[])datas);
                break;
            }
            case "entryunclose": {
                if (datas.length <= 0) break;
                SaveServiceHelper.update((DynamicObject[])datas);
                break;
            }
        }
    }

    private void handleBeginSaveClose(BeginOperationTransactionArgs e, DynamicObject[] datas, String operateKey, String closestatus) {
        if (this.isFromListPage()) {
            if (datas.length == 0) {
                throw new KDBizException("\u8bf7\u5148\u9009\u62e9\u8981\u64cd\u4f5c\u7684\u6570\u636e\u3002");
            }
            ArrayList<DynamicObject> successObjs = new ArrayList<DynamicObject>();
            DynamicObject data = null;
            String errorStr = "%s\uff1a\u8ba2\u5355\u72b6\u6001=\u6682\u5b58\u3001\u5df2\u63d0\u4ea4\u3001\u53d8\u66f4\u4e2d\u3001\u5df2\u4f5c\u5e9f\u3001\u5df2\u5b8c\u6210\u6216\u4f7f\u7528\u8fd4\u5229\u3001\u9884\u4ed8\u6b3e\u6216\u8005\u5df2\u7ecf\u662f\u5173\u95ed\u72b6\u6001\uff0c\u65e0\u9700\u518d\u5173\u95ed\u3002";
            if (closestatus.compareTo("1") == 0) {
                errorStr = "%s\uff1a\u5173\u95ed\u72b6\u6001\u662f\u6b63\u5e38\u72b6\u6001\uff0c\u65e0\u9700\u518d\u53cd\u5173\u95ed\u3002";
            }
            int len = datas.length;
            for (int i = 0; i < len; ++i) {
                data = datas[i];
                SaleOrderStatus status = SaleOrderUtil.getOrderStatus((DynamicObject)data);
                if (data.getString("closestatus").compareTo(closestatus) == 0 || SaleOrderStatus.TEMP_SAVE.equals((Object)status) || SaleOrderStatus.SUBMITTED.equals((Object)status) || SaleOrderStatus.CHANGING.equals((Object)status) || SaleOrderStatus.COMPLETED.equals((Object)status) || SaleOrderStatus.INVALID.equals((Object)status) || data.getBigDecimal("usedbalance").compareTo(BigDecimal.ZERO) != 0 || data.getBigDecimal("usedrebate").compareTo(BigDecimal.ZERO) != 0) {
                    ValidationErrorInfo errorInfo = new ValidationErrorInfo("", data.getPkValue(), i, i + 1, "1001", operateKey, String.format(errorStr, data.getString("billno")), ErrorLevel.Error);
                    this.operationResult.addErrorInfo((OperateErrorInfo)errorInfo);
                    continue;
                }
                successObjs.add(data);
                data.set("closestatus", (Object)closestatus);
            }
            e.setDataEntities(successObjs.toArray(new DynamicObject[successObjs.size()]));
        }
    }
}

