/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dpa.opplugin.newsaleorder;

import java.util.ArrayList;
import java.util.HashMap;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.drp.mdr.common.handler.DispatchOrderHandler;
import kd.drp.mdr.common.handler.SaleOrderHandler;
import kd.drp.mdr.common.message.send.MessageSendService;
import kd.drp.mdr.common.message.send.model.MessageResponse;
import kd.drp.mdr.common.message.send.model.MsgTypeEnum;
import kd.drp.mdr.common.status.DispatchOrderStatus;
import kd.drp.mdr.common.util.SysParamsUtil;
import kd.drp.mdr.opplugin.MdrBaseOperationServicePlugIn;

public class SaleOrderConfirmChangePlugin
extends MdrBaseOperationServicePlugIn {
    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        for (DynamicObject order : e.getDataEntities()) {
            if (this.isFromListPage()) {
                order = BusinessDataServiceHelper.loadSingle((Object)order.get("id"), (String)order.getDynamicObjectType().getName());
            }
            order.set("billstatus", (Object)"C");
            SaleOrderHandler.handleStatusAfterConfirmChanged((DynamicObject)order);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{order});
            if (!SysParamsUtil.isOpenEasSync()) continue;
            this.syncEAS(order);
        }
    }

    private void syncEAS(DynamicObject order) {
        if ("dispatchorder".equals(SysParamsUtil.getTosyncbill())) {
            QFilter qfilter = new QFilter("itementry.sourcebillid", "=", order.get("id")).and("orderstatus", "=", (Object)DispatchOrderStatus.CHANGING.getFlagStr());
            DynamicObject[] dispatchInfos = BusinessDataServiceHelper.load((String)"mdr_dispatch_order", (String)"id", (QFilter[])qfilter.toArray());
            if (dispatchInfos == null || dispatchInfos.length == 0) {
                return;
            }
            ArrayList<String> orderids = new ArrayList<String>(dispatchInfos.length);
            for (DynamicObject dispatchOrder : dispatchInfos) {
                dispatchOrder = BusinessDataServiceHelper.loadSingle((Object)dispatchOrder.get("id"), (String)"mdr_dispatch_order");
                DispatchOrderHandler.reHandleOrderPayStatus((DynamicObject)dispatchOrder);
                DispatchOrderHandler.handleStatusAfterSignOrDelivery((DynamicObject)dispatchOrder);
                DispatchOrderHandler.handleOrderIsOverByQty((DynamicObject)dispatchOrder);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dispatchOrder});
                orderids.add(dispatchOrder.getString("id"));
            }
            HashMap<String, ArrayList<String>> data = new HashMap<String, ArrayList<String>>();
            data.put("orderids", orderids);
            MessageResponse result = MessageSendService.sendMessageAndWaitComplete((MsgTypeEnum)MsgTypeEnum.WDH_SALEORDER_CONFIRMALTER, data, null, (RequestContext)RequestContext.get());
            if (!result.isSuccess()) {
                throw new KDBizException(result.getErrorMessage());
            }
        } else {
            HashMap data = new HashMap();
            ArrayList<String> orderids = new ArrayList<String>();
            orderids.add(order.getString("id"));
            data.put("orderids", orderids);
            MessageResponse result = MessageSendService.sendMessageAndWaitComplete((MsgTypeEnum)MsgTypeEnum.WDH_SALEORDER_CONFIRMALTER, data, null, (RequestContext)RequestContext.get());
            if (!result.isSuccess()) {
                throw new KDBizException(result.getErrorMessage());
            }
        }
    }
}

