/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dpa.opplugin.newsaleorder;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.ValidationErrorInfo;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.drp.dpa.common.algorithm.SaleOrderAlgorithm;
import kd.drp.dpa.opplugin.newsaleorder.validator.SaleOrderSaveValidator;
import kd.drp.mdr.common.CommonUtils;
import kd.drp.mdr.common.StringUtils;
import kd.drp.mdr.common.check.operation.SaleOrderOperationCheck;
import kd.drp.mdr.common.constants.OP;
import kd.drp.mdr.common.constants.SaleOrderEntryType;
import kd.drp.mdr.common.handler.OrderOperateLogHandler;
import kd.drp.mdr.common.handler.ReceivingBillHandler;
import kd.drp.mdr.common.handler.SaleOrderHandler;
import kd.drp.mdr.common.model.CheckResult;
import kd.drp.mdr.common.model.CurrentInfo;
import kd.drp.mdr.common.model.SynResult;
import kd.drp.mdr.common.model.dpm.LimitResult;
import kd.drp.mdr.common.model.dpm.LimitResultEntry;
import kd.drp.mdr.common.model.dpm.PromotionOrder;
import kd.drp.mdr.common.status.SaleOrderPayStatus;
import kd.drp.mdr.common.status.SaleOrderStatus;
import kd.drp.mdr.common.status.SaleOrderSyncStatus;
import kd.drp.mdr.common.strategy.OrderVersionStrategyFactory;
import kd.drp.mdr.common.util.BalanceUtil;
import kd.drp.mdr.common.util.CustomerUtil;
import kd.drp.mdr.common.util.DynamicObjectUtils;
import kd.drp.mdr.common.util.ReceivingbillUtil;
import kd.drp.mdr.common.util.SaleOrderUtil;
import kd.drp.mdr.common.util.SynSaleOrderUtil;
import kd.drp.mdr.common.util.SysParamsUtil;
import kd.drp.mdr.opplugin.MdrBaseOperationServicePlugIn;
import kd.drp.mdr.servicehelper.PromotionServiceHelper;

public class SaleOrderSavePlugin
extends MdrBaseOperationServicePlugIn {
    private volatile boolean isAuditThenSync = false;
    private volatile boolean isOpenEasSync = false;

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("isusebalance");
        fieldKeys.add("usedbalance");
        fieldKeys.add("amounttobepaid");
        fieldKeys.add("receivedamount");
        fieldKeys.add("totalorderamount");
        fieldKeys.add("orderstatus");
        fieldKeys.add("paystatus");
        fieldKeys.add("usedbalance");
        fieldKeys.add("usedrebate");
        fieldKeys.add("rebateaccounttype");
        fieldKeys.add("currency");
        fieldKeys.add("amounttobepaid");
        fieldKeys.add("receivedamount");
        fieldKeys.add("totalorderamount");
        fieldKeys.add("orderdate");
        fieldKeys.add("biztype");
        fieldKeys.add("sync");
        fieldKeys.add("customer");
        fieldKeys.add("owner");
        fieldKeys.add("promotioncachekey");
        fieldKeys.add("localcurrency");
        fieldKeys.add("creator");
        fieldKeys.add("item");
        fieldKeys.add("unit");
        fieldKeys.add("qty");
        fieldKeys.add("baseqty");
        fieldKeys.add("assistqty");
        fieldKeys.add("assistattr");
        fieldKeys.add("allotedqty");
        fieldKeys.add("allotenqty");
        fieldKeys.add("price");
        fieldKeys.add("taxprice");
        fieldKeys.add("ispresent");
        fieldKeys.add("entrywarehouse");
        fieldKeys.add("alterqty");
        fieldKeys.add("entrytype");
        fieldKeys.add("combitem");
        fieldKeys.add("primprice");
        fieldKeys.add("itemamount");
        fieldKeys.add("alterbaseqty");
        fieldKeys.add("parententryid");
        fieldKeys.add("ispromotional");
        fieldKeys.add("itementry.seq");
        fieldKeys.add("limit");
        fieldKeys.add("limitentryid");
        fieldKeys.add("usablebalance");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new SaleOrderSaveValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        String key = e.getOperationKey();
        DynamicObject[] datas = e.getDataEntities();
        this.handleVersionAndOpLog(key, datas);
        switch (key) {
            case "save": {
                this.handleBeginSave(datas);
                break;
            }
            case "submit": {
                this.recalBalanceBeforeSubmit(datas, e);
                this.handleBeginSubmit(datas, e);
                break;
            }
            case "saveworkflow": {
                this.handleBeginSubmit(datas, e);
                SaveServiceHelper.save((DynamicObject[])datas);
                break;
            }
            case "audit": {
                this.handleBeginAudit(datas, e);
            }
        }
    }

    private boolean needRecal(BeginOperationTransactionArgs e) {
        String cashControl;
        String currOperation = e.getOperationKey();
        return currOperation.equals(cashControl = SysParamsUtil.getCashControl()) || StringUtils.isEmpty((String)cashControl);
    }

    private void recalBalanceBeforeSubmit(DynamicObject[] datas, BeginOperationTransactionArgs e) {
        if (!this.needRecal(e)) {
            return;
        }
        this.recalUseAbleBalance(datas);
        this.recalOtherBalance(datas);
    }

    private void recalOtherBalance(DynamicObject[] datas) {
        for (DynamicObject saleOrderObj : datas) {
            String orderStatus;
            BigDecimal totalorderamount = saleOrderObj.getBigDecimal("totalorderamount");
            BigDecimal amounttobepaid = saleOrderObj.getBigDecimal("amounttobepaid");
            BigDecimal receivedamount = saleOrderObj.getBigDecimal("receivedamount");
            BigDecimal usablebalance = saleOrderObj.getBigDecimal("usablebalance");
            BigDecimal paidAmount = ReceivingbillUtil.getBillSalePayAmount((Object)saleOrderObj.getPkValue(), (String)"saleorder");
            amounttobepaid = totalorderamount.subtract(paidAmount);
            BigDecimal usedbalance = BigDecimal.ZERO;
            boolean isUseBalance = saleOrderObj.getBoolean("isusebalance");
            if (isUseBalance) {
                if (amounttobepaid.compareTo(usablebalance) >= 0) {
                    amounttobepaid = amounttobepaid.subtract(usablebalance);
                    usedbalance = usablebalance;
                } else {
                    usedbalance = amounttobepaid;
                    amounttobepaid = BigDecimal.ZERO;
                }
            }
            if (!(orderStatus = saleOrderObj.getString("orderstatus")).equals(SaleOrderStatus.CHANGING.getFlagStr()) || receivedamount.compareTo(totalorderamount) < 0) {
                saleOrderObj.set("receivedamount", (Object)paidAmount.add(usedbalance));
            }
            saleOrderObj.set("amounttobepaid", (Object)amounttobepaid);
            saleOrderObj.set("usedbalance", (Object)usedbalance);
        }
    }

    private void recalUseAbleBalance(DynamicObject[] datas) {
        for (DynamicObject saleOrderObj : datas) {
            DynamicObject balanceInfoObj = BalanceUtil.getBalanceInfo((Object)DynamicObjectUtils.getPkId((DynamicObject)saleOrderObj, (String)"owner"), (Object)DynamicObjectUtils.getPkId((DynamicObject)saleOrderObj, (String)"customer"), (boolean)false);
            if (balanceInfoObj == null) continue;
            BigDecimal usableBalance = balanceInfoObj.getBigDecimal("usable");
            BigDecimal usedBalance = BigDecimal.ZERO;
            boolean isTemp = SaleOrderUtil.isThisStatus((DynamicObject)saleOrderObj, (SaleOrderStatus)SaleOrderStatus.TEMP_SAVE);
            if (usedBalance != null && !isTemp) {
                usedBalance = saleOrderObj.getBigDecimal("usedbalance");
            }
            usableBalance = usableBalance.add(usedBalance);
            saleOrderObj.set("usablebalance", (Object)usableBalance);
        }
    }

    protected void handleBeginSave(DynamicObject[] datas) {
        if (this.isFromListPage()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7f16\u8f91\u9875\u9762\u4e0d\u80fd\u505a\u4fdd\u5b58\u53d8\u66f4\u64cd\u4f5c\uff01", (String)"SaleOrderSavePlugin_0", (String)"drp-dpa-opplugin", (Object[])new Object[0]));
        }
        CheckResult result = null;
        boolean isChangeStatus = false;
        CurrentInfo current = new CurrentInfo();
        int len = datas.length;
        for (int i = 0; i < len; ++i) {
            isChangeStatus = SaleOrderUtil.isThisStatus((DynamicObject)datas[i], (SaleOrderStatus)SaleOrderStatus.CHANGING);
            if (isChangeStatus) {
                result = SaleOrderOperationCheck.checkCanSaveChange((DynamicObject)datas[i]);
                if (!result.isSuccess()) {
                    throw new KDBizException(result.getMsg());
                }
                datas[i].set("changer", current.getUserId());
                datas[i].set("changetime", (Object)current.getNow());
                SaleOrderUtil.handleStoreForward((DynamicObject)datas[i]);
                SaleOrderHandler.handleReceivingBill4Change((DynamicObject)datas[i]);
                boolean isCustomerConfirmChange = SysParamsUtil.isCustomerConfirmChange();
                if (!isCustomerConfirmChange) {
                    SaleOrderHandler.handleStatusAfterConfirmChanged((DynamicObject)datas[i]);
                } else {
                    SaleOrderHandler.handleStatusAfterChangeSave((DynamicObject)datas[i]);
                }
                datas[i].set("billstatus", (Object)"C");
            }
            SaleOrderHandler.reHandleOrderPayStatus((DynamicObject)datas[i]);
        }
    }

    protected void handleBeginSubmit(DynamicObject[] datas, BeginOperationTransactionArgs e) {
        this.isOpenEasSync = SysParamsUtil.isOpenEasSync();
        boolean isChangePayStatus = true;
        DynamicObject data = null;
        StringBuilder errorStr = null;
        String operateKey = "submit";
        ArrayList<DynamicObject> successObjs = new ArrayList<DynamicObject>();
        int len = datas.length;
        for (int i = 0; i < len; ++i) {
            data = datas[i];
            try {
                SaleOrderUtil.handleBalance((DynamicObject)data);
            }
            catch (Exception ex) {
                isChangePayStatus = false;
                errorStr = new StringBuilder();
                errorStr.append(OP.getName((String)operateKey)).append(ResManager.loadKDString((String)"\u5931\u8d25,", (String)"SaleOrderSavePlugin_1", (String)"drp-dpa-opplugin", (Object[])new Object[0])).append(data.getString("billno")).append(",\u9884\u6536\u6b3e\u4f59\u989d\u4e0d\u8db3\uff0c\u8bf7\u53ca\u65f6\u8865\u5145\u9884\u6536\u6b3e\u3002");
                ValidationErrorInfo errorInfo = new ValidationErrorInfo("", data.getPkValue(), i, i + 1, operateKey, OP.getName((String)operateKey), errorStr.toString(), ErrorLevel.Error);
                this.operationResult.addErrorInfo((OperateErrorInfo)errorInfo);
            }
            if (isChangePayStatus) {
                SaleOrderHandler.reHandleOrderPayStatus((DynamicObject)data);
                this.checkCanDoOperationByCashControl(operateKey, new DynamicObject[]{data}, e);
                if (e.getDataEntities().length > 0) {
                    successObjs.add(data);
                } else {
                    SaleOrderUtil.handleBalance4UnSubmit((DynamicObject)data);
                }
            } else {
                isChangePayStatus = true;
            }
            if (this.isOpenEasSync && "saleorder".equals(SysParamsUtil.getTosyncbill())) {
                data.set("sync", (Object)SaleOrderSyncStatus.NOT_SYNC.getFlagStr());
            }
            data.set("orderstatus", (Object)SaleOrderStatus.SUBMITTED.getFlagStr());
        }
        e.setDataEntities(successObjs.toArray(new DynamicObject[successObjs.size()]));
        this.checkLimitResult("submit", e.getDataEntities(), e);
        DynamicObject[] dynObjects = e.getDataEntities();
        this.setLimitValue(dynObjects);
        ArrayList<Object> ids = new ArrayList<Object>();
        if (dynObjects != null && dynObjects.length > 0) {
            for (DynamicObject dynamicObject : dynObjects) {
                SaleOrderUtil.handleStoreForward((DynamicObject)dynamicObject);
                ids.add(dynamicObject.getPkValue());
            }
        }
        if (ids.size() < datas.length) {
            for (DynamicObject dynamicObject : successObjs) {
                if (ids.contains(dynamicObject.getPkValue())) continue;
                SaleOrderUtil.handleBalance4UnSubmit((DynamicObject)dynamicObject);
            }
        }
    }

    protected void handleBeginAudit(DynamicObject[] datas, BeginOperationTransactionArgs e) {
        this.isAuditThenSync = SysParamsUtil.isAuditThenSync();
        this.isOpenEasSync = SysParamsUtil.isOpenEasSync();
        boolean isDispatch = SysParamsUtil.isDispatch();
        this.checkCanDoOperationByCashControl("audit", datas, e);
        DynamicObject[] dynObjects = e.getDataEntities();
        DynamicObject dynObject = null;
        for (int i = 0; i < dynObjects.length; ++i) {
            dynObject = dynObjects[i];
            if (dynObject.getBoolean("isusebalance")) {
                ReceivingBillHandler.handleOffsetBill((DynamicObject)dynObject, (boolean)true, (String)"audit");
                SaleOrderHandler.reHandleOrderPayStatus((DynamicObject)dynObject);
            }
            if (isDispatch) {
                dynObject.set("orderstatus", (Object)SaleOrderStatus.PENDING_DISPATCH.getFlagStr());
                continue;
            }
            dynObject.set("orderstatus", (Object)SaleOrderStatus.PENDING_DELIVERY.getFlagStr());
        }
    }

    private void checkLimitResult(String operateKey, DynamicObject[] datas, BeginOperationTransactionArgs e) {
        if (!this.isFromListPage() || datas.length == 0) {
            return;
        }
        ArrayList<DynamicObject> successObjs = new ArrayList<DynamicObject>();
        for (int i = 0; i < datas.length; ++i) {
            DynamicObject saleorder = datas[i];
            PromotionOrder order = new SaleOrderAlgorithm(saleorder, null, null).buildPromotionOrderWithPresent();
            LimitResult limitResult = PromotionServiceHelper.validateLimitRule((PromotionOrder)order, (boolean)false);
            if (!limitResult.isSuccessExecuteLimit()) {
                Map limitResultEntries = limitResult.getLimitResultEntries();
                StringBuilder stringBuilder = new StringBuilder();
                for (LimitResultEntry limitResultEntry : limitResultEntries.values()) {
                    if (limitResultEntry.getExecuteResult()) continue;
                    stringBuilder.append(String.format(ResManager.loadKDString((String)"%s\uff0c\u6570\u91cf\u5df2\u8d85\u8fc7\u9650\u5b9a\u6570\u91cf\uff0c\u8bf7\u8c03\u6574\u3002\u53ef\u7528\u4f59\u91cf\u4e3a%s\u3002", (String)"SaleOrderSaveValidator_30", (String)"drp-dpa-opplugin", (Object[])new Object[0]), limitResultEntry.getItemName(), limitResultEntry.getLeftLimitQty()));
                }
                if (stringBuilder.length() <= 0) continue;
                ValidationErrorInfo errorInfo = new ValidationErrorInfo("", saleorder.getPkValue(), i, i + 1, operateKey, OP.getName((String)operateKey), stringBuilder.toString(), ErrorLevel.Error);
                this.operationResult.addErrorInfo((OperateErrorInfo)errorInfo);
                continue;
            }
            successObjs.add(saleorder);
        }
        e.setDataEntities(successObjs.toArray(new DynamicObject[successObjs.size()]));
    }

    private void setLimitValue(DynamicObject[] datas) {
        if (datas.length == 1 && !this.isFromListPage()) {
            DynamicObject saleorder = datas[0];
            String selectfileds = "itementry.id,itementry.limitentryid";
            QFilter filter = new QFilter("id", "=", saleorder.getPkValue());
            filter.and("itementry.limitentryid", ">", (Object)1);
            DynamicObject[] bbcsaleorders = BusinessDataServiceHelper.load((String)"bbc_saleorder", (String)selectfileds, (QFilter[])filter.toArray());
            if (bbcsaleorders != null) {
                DynamicObject bbcsaleorder;
                DynamicObjectCollection itementrys = null;
                HashMap<Object, Object> limitqtyidinfo = new HashMap<Object, Object>();
                DynamicObject[] dynamicObjectArray = bbcsaleorders;
                int n = dynamicObjectArray.length;
                for (int i = 0; i < n && (itementrys = (bbcsaleorder = dynamicObjectArray[i]).getDynamicObjectCollection("itementry")) != null && !itementrys.isEmpty(); ++i) {
                    for (DynamicObject itementry : itementrys) {
                        limitqtyidinfo.put(itementry.getPkValue(), itementry.get("limitentryid"));
                    }
                }
                itementrys = saleorder.getDynamicObjectCollection("itementry");
                Object limitentryid = null;
                for (DynamicObject itementry : itementrys) {
                    limitentryid = limitqtyidinfo.get(itementry.getPkValue());
                    if (limitentryid == null || itementry.getBigDecimal("limitentryid").compareTo(BigDecimal.ZERO) != 0) continue;
                    itementry.set("limitentryid", limitentryid);
                }
            }
        }
    }

    private void checkCanDoOperationByCashControl(String operateKey, DynamicObject[] datas, BeginOperationTransactionArgs e) {
        String cashControl = SysParamsUtil.getCashControl();
        if (operateKey.equals(cashControl)) {
            ArrayList<DynamicObject> successObjs = new ArrayList<DynamicObject>();
            for (int i = 0; i < datas.length; ++i) {
                DynamicObject saleorder = datas[i];
                DynamicObject info = CustomerUtil.getAuthBizInfo((Object)saleorder.getDynamicObject("owner").getPkValue(), (Object)saleorder.getDynamicObject("customer").getPkValue());
                if (!info.getBoolean("onlycash")) {
                    successObjs.add(saleorder);
                    continue;
                }
                String payStatus = saleorder.getString("paystatus");
                if (!payStatus.equals(SaleOrderPayStatus.ALREADY_PAID.getFlagStr())) {
                    String billNo = saleorder.getString("billno");
                    StringBuilder errorStr = new StringBuilder();
                    errorStr.append(OP.getName((String)operateKey)).append(ResManager.loadKDString((String)"\u5931\u8d25,", (String)"SaleOrderSavePlugin_1", (String)"drp-dpa-opplugin", (Object[])new Object[0])).append(billNo).append(ResManager.loadKDString((String)",\u9884\u6536\u6b3e\u4f59\u989d\u4e0d\u8db3\uff0c\u8bf7\u53ca\u65f6\u8865\u5145\u9884\u6536\u6b3e!", (String)"SaleOrderSavePlugin_2", (String)"drp-dpa-opplugin", (Object[])new Object[0]));
                    ValidationErrorInfo errorInfo = new ValidationErrorInfo("", saleorder.getPkValue(), i, i + 1, operateKey, OP.getName((String)operateKey), errorStr.toString(), ErrorLevel.Error);
                    this.operationResult.addErrorInfo((OperateErrorInfo)errorInfo);
                    if (this.isFromListPage()) continue;
                    PromotionServiceHelper.rollbackLimit((Object)saleorder.getPkValue(), (boolean)true);
                    continue;
                }
                successObjs.add(saleorder);
            }
            e.setDataEntities(successObjs.toArray(new DynamicObject[successObjs.size()]));
        }
    }

    protected void handleVersionAndOpLog(String key, DynamicObject[] datas) {
        if (!this.isFromListPage()) {
            for (DynamicObject data : datas) {
                OrderVersionStrategyFactory.saveVersion((DynamicObject)data, (String)key);
            }
        } else {
            for (DynamicObject data : datas) {
                OrderOperateLogHandler.save((DynamicObject)data, (String)key);
            }
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        String key = e.getOperationKey();
        DynamicObject[] datas = e.getDataEntities();
        switch (key) {
            case "save": {
                this.handleEndSave(datas);
                break;
            }
            case "submit": {
                this.handleEndSubmit(datas, e);
                break;
            }
            case "audit": {
                this.handleEndAudit(datas);
            }
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        String key = e.getOperationKey();
        DynamicObject[] datas = e.getDataEntities();
        switch (key) {
            case "submit": {
                if (!SysParamsUtil.isSubmitThenAudit() || datas.length <= 0) break;
                this.handleCommitOrderThenAudit(datas, this.operationResult, this.operateOption, this.isFromListPage());
                break;
            }
            case "audit": {
                int size;
                if (!SysParamsUtil.isAuditThenSync() || this.operationResult.getBillCount() != 1 || (size = this.operationResult.getSuccessPkIds().size() + this.operationResult.getAllErrorOrValidateInfo().size()) <= 1) break;
                this.operationResult.setSuccessPkIds(new ArrayList());
                break;
            }
        }
    }

    public void handleCommitOrderThenAudit(DynamicObject[] datas, OperationResult operationResult, OperateOption operateOption, boolean isfromList) {
        boolean isSubmitThensAudit = SysParamsUtil.isSubmitThenAudit();
        if (isSubmitThensAudit) {
            List successPkIds = Arrays.asList(datas).stream().map(v -> v.get("id")).collect(Collectors.toList());
            operateOption.setVariableValue("isStrict", "false");
            OperationResult result = null;
            result = isfromList ? OperationServiceHelper.executeOperate((String)"audit", (String)datas[0].getDataEntityType().getName(), (Object[])successPkIds.toArray(), (OperateOption)operateOption) : OperationServiceHelper.executeOperate((String)"audit", (String)datas[0].getDataEntityType().getName(), (DynamicObject[])datas, (OperateOption)operateOption);
            if (result != null && !CollectionUtils.isEmpty((Collection)result.getAllErrorOrValidateInfo())) {
                for (IOperateInfo iOperateInfo : result.getAllErrorOrValidateInfo()) {
                    operationResult.addErrorInfo((OperateErrorInfo)iOperateInfo);
                }
            }
            if (operationResult.getBillCount() > 1) {
                operationResult.setSuccessPkIds(successPkIds);
            }
        }
    }

    protected void handleEndSave(DynamicObject[] datas) {
        if (!this.isFromListPage() && datas.length > 0) {
            this.savePromotionContext(datas[0]);
        }
    }

    protected void handleEndSubmit(DynamicObject[] datas, EndOperationTransactionArgs e) {
        if (!this.isFromListPage() && datas.length > 0) {
            this.savePromotionContext(datas[0]);
        }
        HashSet<Object> sucessorderids = new HashSet<Object>();
        for (DynamicObject order : datas) {
            this.executeLimit(order, sucessorderids);
        }
        SaleOrderUtil.handleRebate4EndSubmit((DynamicObject[])datas);
    }

    private void savePromotionContext(DynamicObject saleOrder) {
        if (!SysParamsUtil.isUsePromotion()) {
            return;
        }
        String key = null;
        boolean isProExist = CommonUtils.checkPropertyIsExist((DynamicObject)saleOrder, (String)"promotioncachekey");
        if (isProExist) {
            key = saleOrder.getString("promotioncachekey");
        }
        if (StringUtils.isEmpty(key)) {
            return;
        }
        PromotionServiceHelper.savePromotionExecution((String)key, (Object)saleOrder.getPkValue());
    }

    private void executeLimit(DynamicObject saleOrder, Set<Object> sucessorderids) {
        PromotionOrder order = new SaleOrderAlgorithm(saleOrder, null, null).buildPromotionOrderWithPresent();
        LimitResult result = PromotionServiceHelper.executeLimitRule((Object)saleOrder.getPkValue(), (PromotionOrder)order, (boolean)false);
        if (!result.isSuccessExecuteLimit()) {
            Map limitResultEntries = result.getLimitResultEntries();
            StringBuilder stringBuilder = new StringBuilder();
            for (LimitResultEntry limitResultEntry : limitResultEntries.values()) {
                if (limitResultEntry.getExecuteResult()) continue;
                stringBuilder.append(String.format(ResManager.loadKDString((String)"%s\uff0c\u6570\u91cf\u5df2\u8d85\u8fc7\u9650\u5b9a\u6570\u91cf\uff0c\u8bf7\u8c03\u6574\u3002\u53ef\u7528\u4f59\u91cf\u4e3a%s\u3002", (String)"SaleOrderSavePlugin_11", (String)"drp-dpa-opplugin", (Object[])new Object[0]), limitResultEntry.getItemName(), limitResultEntry.getLeftLimitQty()));
            }
            if (stringBuilder.length() > 0) {
                if (sucessorderids.size() > 0) {
                    for (Object orderid : sucessorderids) {
                        PromotionServiceHelper.rollbackLimit((Object)orderid, (boolean)false);
                    }
                }
                throw new KDBizException(stringBuilder.toString());
            }
        } else {
            sucessorderids.add(saleOrder.getPkValue());
        }
    }

    protected void handleEndAudit(DynamicObject[] datas) {
        Boolean doSync = Boolean.TRUE;
        if (!(this.isOpenEasSync && this.isAuditThenSync && "saleorder".equals(SysParamsUtil.getTosyncbill()))) {
            doSync = Boolean.FALSE;
        }
        for (int i = 0; i < datas.length; ++i) {
            DynamicObject order = datas[i];
            if (doSync.booleanValue()) {
                try {
                    this.syncOrder(i, order);
                }
                catch (Exception e) {
                    ValidationErrorInfo errorInfo = new ValidationErrorInfo("", order.getPkValue(), i, i + 1, "500", ResManager.loadKDString((String)"\u540c\u6b65 ", (String)"SaleOrderSavePlugin_7", (String)"drp-dpa-opplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5ba1\u6838\u6210\u529f,\u540c\u6b65\u5931\u8d25: ", (String)"SaleOrderSavePlugin_8", (String)"drp-dpa-opplugin", (Object[])new Object[0]) + order.getString("billno") + ":" + e.getMessage(), ErrorLevel.Error);
                    this.operationResult.addErrorInfo((OperateErrorInfo)errorInfo);
                }
            }
            this.recordItemInfo(order);
        }
        SaleOrderUtil.handleRebate4EndAudit((DynamicObject[])datas);
    }

    private void syncOrder(int i, DynamicObject order) {
        SynResult easresult;
        DynamicObject saleorderdata = BusinessDataServiceHelper.loadSingle((Object)order.get("id"), (String)"bbc_saleorder");
        SynResult jdresult = SynSaleOrderUtil.SynSaleOrderToJD((DynamicObject)saleorderdata);
        if (jdresult != null && !jdresult.isSuccess()) {
            this.operationResult.addErrorInfo((OperateErrorInfo)new ValidationErrorInfo("", order.getPkValue(), i, 0, "500", ResManager.loadKDString((String)" \u540c\u6b65\u4eac\u4e1c ", (String)"SaleOrderSavePlugin_9", (String)"drp-dpa-opplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5ba1\u6838\u6210\u529f,\u540c\u6b65\u4eac\u4e1c\u5931\u8d25:", (String)"SaleOrderSavePlugin_10", (String)"drp-dpa-opplugin", (Object[])new Object[0]) + order.getString("billno") + ":" + jdresult.getMsg(), ErrorLevel.Error));
        }
        if ((easresult = SynSaleOrderUtil.SynSaleOrder((DynamicObject)saleorderdata)) != null && !easresult.isSuccess()) {
            this.operationResult.addErrorInfo((OperateErrorInfo)new ValidationErrorInfo("", order.getPkValue(), i, 0, "500", ResManager.loadKDString((String)"\u540c\u6b65eas", (String)"SaleOrderSavePlugin_5", (String)"drp-dpa-opplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5ba1\u6838\u6210\u529f,\u540c\u6b65eas\u5931\u8d25:", (String)"SaleOrderSavePlugin_6", (String)"drp-dpa-opplugin", (Object[])new Object[0]) + order.getString("billno") + ":" + easresult.getMsg(), ErrorLevel.Error));
        }
    }

    private void recordItemInfo(DynamicObject order) {
        DynamicObjectCollection itementry = order.getDynamicObjectCollection("itementry");
        HashMap<Object, BigDecimal> baseQtyMap = new HashMap<Object, BigDecimal>();
        HashMap<Object, BigDecimal> assistQtyMap = new HashMap<Object, BigDecimal>();
        for (DynamicObject entry : itementry) {
            Object entrytype = entry.get("entrytype");
            if (SaleOrderEntryType.COMBINATION.getFlagStr().equals(entrytype)) continue;
            baseQtyMap.put(entry.getDynamicObject("item").get("id"), entry.getBigDecimal("baseqty"));
            if (entry.getBigDecimal("assistqty") == null) continue;
            assistQtyMap.put(entry.getDynamicObject("item").get("id"), entry.getBigDecimal("assistqty"));
        }
        DynamicObject[] itemInfo = BusinessDataServiceHelper.load((String)"mdr_item_info", (String)"id,saleqty,updatetime,isassistorder,assistsaleqty", (QFilter[])new QFilter("id", "in", baseQtyMap.keySet()).toArray());
        if (itemInfo != null) {
            for (DynamicObject item : itemInfo) {
                BigDecimal baseQty;
                Object itemId = item.get("id");
                BigDecimal assistQty = (BigDecimal)assistQtyMap.get(itemId);
                if (assistQty != null) {
                    BigDecimal assistsaleqty = item.getBigDecimal("assistsaleqty");
                    if (assistsaleqty == null) {
                        assistsaleqty = BigDecimal.ZERO;
                    }
                    item.set("assistsaleqty", (Object)assistsaleqty.add(assistQty));
                }
                if ((baseQty = (BigDecimal)baseQtyMap.get(itemId)) != null) {
                    BigDecimal saleqty = item.getBigDecimal("saleqty");
                    if (saleqty == null) {
                        saleqty = BigDecimal.ZERO;
                    }
                    item.set("saleqty", (Object)saleqty.add((BigDecimal)baseQtyMap.get(itemId)));
                }
                item.set("updatetime", (Object)new Date());
            }
            SaveServiceHelper.save((DynamicObject[])itemInfo);
        }
    }
}

