/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dpa.opplugin.newsaleorder;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.ValidationErrorInfo;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.drp.mdr.common.model.SynResult;
import kd.drp.mdr.common.util.SynSaleOrderUtil;
import kd.drp.mdr.common.util.SysParamsUtil;
import kd.drp.mdr.opplugin.MdrBaseOperationServicePlugIn;

public class SaleOrderSyncPlugin
extends MdrBaseOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("itementry");
        fieldKeys.add("closestatus");
        fieldKeys.add("entryclosestatus");
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        if (!"saleorder".equals(SysParamsUtil.getTosyncbill())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u540c\u6b65\u5355\u636e\u4e0d\u4e3a\u9500\u552e\u8ba2\u5355\uff0c\u4e0d\u5141\u8bb8\u4ece\u9500\u552e\u8ba2\u5355\u540c\u6b65\u6570\u636e\uff01", (String)"SaleOrderSyncPlugin_0", (String)"drp-dpa-opplugin", (Object[])new Object[0]));
        }
        this.handleBeginSync(e);
        DynamicObject[] datas = e.getDataEntities();
        ArrayList<DynamicObject> successObjs = new ArrayList<DynamicObject>();
        for (int i = 0; i < datas.length; ++i) {
            DynamicObject saleorderdata = BusinessDataServiceHelper.loadSingle((Object)datas[i].get("id"), (String)"bbc_saleorder");
            SynResult jdresult = SynSaleOrderUtil.SynSaleOrderToJD((DynamicObject)saleorderdata);
            if (jdresult != null && !jdresult.isSuccess()) {
                this.operationResult.addErrorInfo((OperateErrorInfo)new ValidationErrorInfo("", datas[i].getPkValue(), i, 0, "500", ResManager.loadKDString((String)" \u540c\u6b65\u4eac\u4e1c ", (String)"SaleOrderSyncPlugin_1", (String)"drp-dpa-opplugin", (Object[])new Object[0]), datas[i].getString("billno") + ":" + jdresult.getMsg(), ErrorLevel.Error));
                continue;
            }
            if (!SysParamsUtil.isOpenEasSync()) {
                this.operationResult.addErrorInfo((OperateErrorInfo)new ValidationErrorInfo("", datas[i].getPkValue(), i, 0, "500", ResManager.loadKDString((String)" \u540c\u6b65EAS ", (String)"SaleOrderSyncPlugin_2", (String)"drp-dpa-opplugin", (Object[])new Object[0]), datas[i].getString("billno") + ":" + ResManager.loadKDString((String)"\"EAS\"\u540c\u6b65\u53c2\u6570\u672a\u5f00\u542f\uff0c\u8bf7\u5f00\u542f\u540e\u91cd\u8bd5", (String)"SaleOrderSyncPlugin_4", (String)"drp-dpa-opplugin", (Object[])new Object[0]), ErrorLevel.Error));
                continue;
            }
            try {
                SynResult result = SynSaleOrderUtil.SynSaleOrder((DynamicObject)saleorderdata);
                if (!result.isSuccess()) {
                    this.operationResult.addErrorInfo((OperateErrorInfo)new ValidationErrorInfo("", datas[i].getPkValue(), i, 0, "500", ResManager.loadKDString((String)" \u540c\u6b65EAS ", (String)"SaleOrderSyncPlugin_2", (String)"drp-dpa-opplugin", (Object[])new Object[0]), datas[i].getString("billno") + ":" + result.getMsg(), ErrorLevel.Error));
                    continue;
                }
                successObjs.add(datas[i]);
                continue;
            }
            catch (Exception ex) {
                this.operationResult.addErrorInfo((OperateErrorInfo)new ValidationErrorInfo("", datas[i].getPkValue(), i, 0, "500", ResManager.loadKDString((String)" \u540c\u6b65EAS ", (String)"SaleOrderSyncPlugin_2", (String)"drp-dpa-opplugin", (Object[])new Object[0]), datas[i].getString("billno") + ":" + ex.getMessage(), ErrorLevel.Error));
            }
        }
        e.setDataEntities(successObjs.toArray(new DynamicObject[successObjs.size()]));
    }

    private void handleBeginSync(BeginOperationTransactionArgs e) {
        DynamicObject[] datas = e.getDataEntities();
        ArrayList<DynamicObject> successObjs = new ArrayList<DynamicObject>();
        DynamicObject data = null;
        String errorStr = "%s:\u5355\u636e\u5173\u95ed\uff0c\u4e0d\u53ef\u7ee7\u7eed\u540c\u6b65\u3002";
        String entryErrorStr = "%s:\u6240\u6709\u5546\u54c1\u5206\u5f55\u5df2\u5173\u95ed\uff0c\u4e0d\u53ef\u7ee7\u7eed\u540c\u6b65\u3002";
        String operateKey = "\u540c\u6b65";
        int len = datas.length;
        for (int i = 0; i < len; ++i) {
            data = datas[i];
            if (data.getString("closestatus").compareTo("0") == 0) {
                ValidationErrorInfo errorInfo = new ValidationErrorInfo("", data.getPkValue(), i, i + 1, "1001", operateKey, String.format(errorStr, data.getString("billno")), ErrorLevel.Error);
                this.operationResult.addErrorInfo((OperateErrorInfo)errorInfo);
                continue;
            }
            DynamicObjectCollection entrys = data.getDynamicObjectCollection("itementry");
            boolean isTrue = false;
            for (DynamicObject entry : entrys) {
                if (entry.getString("entryclosestatus").compareTo("1") != 0) continue;
                isTrue = true;
                break;
            }
            if (!isTrue) {
                ValidationErrorInfo errorInfo = new ValidationErrorInfo("", data.getPkValue(), i, i + 1, "1001", operateKey, String.format(entryErrorStr, data.getString("billno")), ErrorLevel.Error);
                this.operationResult.addErrorInfo((OperateErrorInfo)errorInfo);
                continue;
            }
            successObjs.add(data);
        }
        e.setDataEntities(successObjs.toArray(new DynamicObject[successObjs.size()]));
    }
}

