/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dpa.opplugin.newsaleorder;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.drp.dpa.opplugin.newsaleorder.validator.SaleOrderUnAuditValidator;
import kd.drp.mdr.common.constants.SaleOrderEntryType;
import kd.drp.mdr.common.handler.ReceivingBillHandler;
import kd.drp.mdr.common.handler.SaleOrderHandler;
import kd.drp.mdr.common.status.SaleOrderStatus;
import kd.drp.mdr.common.util.SaleOrderUtil;
import kd.drp.mdr.opplugin.MdrBaseOperationServicePlugIn;
import kd.drp.mdr.servicehelper.PromotionServiceHelper;

public class SaleOrderUnAuditPlugin
extends MdrBaseOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("orderstatus");
        fieldKeys.add("biztype");
        fieldKeys.add("sync");
        fieldKeys.add("customer");
        fieldKeys.add("owner");
        fieldKeys.add("paystatus");
        fieldKeys.add("usedbalance");
        fieldKeys.add("isusebalance");
        fieldKeys.add("amounttobepaid");
        fieldKeys.add("receivedamount");
        fieldKeys.add("totalorderamount");
        fieldKeys.add("itementry.item");
        fieldKeys.add("itementry.unit");
        fieldKeys.add("itementry.qty");
        fieldKeys.add("itementry.baseqty");
        fieldKeys.add("itementry.assistqty");
        fieldKeys.add("itementry.entrywarehouse");
        fieldKeys.add("itementry.baseqty");
        fieldKeys.add("itementry.assistqty");
        fieldKeys.add("itementry.entrywarehouse");
        fieldKeys.add("itementry.entrytype");
        fieldKeys.add("itementry.combitem");
        fieldKeys.add("itementry.combqty");
        fieldKeys.add("itementry.alterbaseqty");
        fieldKeys.add("usedrebate");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new SaleOrderUnAuditValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        List validExtDataEntities = e.getValidExtDataEntities();
        for (int i = 0; i < validExtDataEntities.size(); ++i) {
            DynamicObject order = ((ExtendedDataEntity)validExtDataEntities.get(i)).getDataEntity();
            order.set("orderstatus", (Object)SaleOrderStatus.TEMP_SAVE.getFlagStr());
            order.set("billstatus", (Object)"A");
        }
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] datas = e.getDataEntities();
        for (int i = 0; i < datas.length; ++i) {
            SaleOrderUtil.handleStoreReverse((DynamicObject)datas[i]);
            if (datas[i].getBoolean("isusebalance")) {
                ReceivingBillHandler.handleRefundsBill((DynamicObject)datas[i], null, (boolean)false);
                ReceivingBillHandler.handleOffsetBill((DynamicObject)datas[i], (boolean)false, null);
            }
            SaleOrderHandler.reHandleOrderPayStatus((DynamicObject)datas[i]);
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        DynamicObject[] datas = e.getDataEntities();
        this.handleAfterUnAudit(datas);
        SaleOrderUtil.handleRebate4EndUnAudit((DynamicObject[])datas);
    }

    private void handleAfterUnAudit(DynamicObject[] datas) {
        for (int i = 0; i < datas.length; ++i) {
            this.recordItemInfo(datas[i]);
            PromotionServiceHelper.rollbackLimit((Object)datas[i].getPkValue(), (boolean)false);
        }
    }

    private void recordItemInfo(DynamicObject order) {
        DynamicObjectCollection itementry = order.getDynamicObjectCollection("itementry");
        for (DynamicObject entry : itementry) {
            Object entrytype = entry.get("entrytype");
            if (SaleOrderEntryType.COMBINATION.getFlagStr().equals(entrytype)) continue;
            BigDecimal baseqty = (BigDecimal)entry.get("baseqty");
            BigDecimal assistqty = (BigDecimal)entry.get("assistqty");
            if (baseqty == null) {
                baseqty = BigDecimal.ZERO;
            }
            if (assistqty == null) {
                assistqty = BigDecimal.ZERO;
            }
            DynamicObject item = (DynamicObject)entry.get("item");
            Object itemId = item.get("id");
            DynamicObject itemInfo = BusinessDataServiceHelper.loadSingle((Object)itemId, (String)"mdr_item_info", (String)"id,isassistorder,assistsaleqty,saleqty,updatetime");
            BigDecimal saleqty = BigDecimal.ZERO;
            if (itemInfo.get("saleqty") != null) {
                saleqty = (BigDecimal)itemInfo.get("saleqty");
            }
            itemInfo.set("saleqty", (Object)saleqty.subtract(baseqty));
            BigDecimal assistsaleqty = BigDecimal.ZERO;
            if (itemInfo.get("assistsaleqty") != null) {
                assistsaleqty = itemInfo.getBigDecimal("assistsaleqty");
            }
            itemInfo.set("assistsaleqty", (Object)assistsaleqty.subtract(assistqty));
            itemInfo.set("updatetime", (Object)new Date());
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{itemInfo});
        }
    }
}

