/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dpa.opplugin.newsaleorder;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.ValidationErrorInfo;
import kd.drp.mdr.common.constants.OP;
import kd.drp.mdr.common.status.SaleOrderStatus;
import kd.drp.mdr.common.util.SaleOrderUtil;
import kd.drp.mdr.opplugin.MdrBaseOperationServicePlugIn;
import kd.drp.mdr.servicehelper.PromotionServiceHelper;

public class SaleOrderUnSubmitPlugin
extends MdrBaseOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("orderstatus");
        fieldKeys.add("biztype");
        fieldKeys.add("sync");
        fieldKeys.add("customer");
        fieldKeys.add("owner");
        fieldKeys.add("paystatus");
        fieldKeys.add("isusebalance");
        fieldKeys.add("usedbalance");
        fieldKeys.add("amounttobepaid");
        fieldKeys.add("receivedamount");
        fieldKeys.add("totalorderamount");
        fieldKeys.add("itementry.item");
        fieldKeys.add("itementry.unit");
        fieldKeys.add("itementry.qty");
        fieldKeys.add("itementry.entrytype");
        fieldKeys.add("itementry.entrywarehouse");
        fieldKeys.add("usedrebate");
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        List validExtDataEntities = e.getValidExtDataEntities();
        for (int i = 0; i < validExtDataEntities.size(); ++i) {
            DynamicObject order = ((ExtendedDataEntity)validExtDataEntities.get(i)).getDataEntity();
            order.set("orderstatus", (Object)SaleOrderStatus.TEMP_SAVE.getFlagStr());
            if (!SaleOrderUtil.isDataChangeWhenDoOperation((DynamicObject)order)) continue;
            e.cancel = true;
            e.setCancelMessage(ResManager.loadKDString((String)"\u8ba2\u5355\u76f8\u5173\u5b57\u6bb5\u5df2\u7ecf\u6539\u53d8\uff0c\u8bf7\u5148\u63d0\u4ea4\u540e\u64a4\u9500\uff01", (String)"SaleOrderUnSubmitPlugin_0", (String)"drp-dpa-opplugin", (Object[])new Object[0]));
            return;
        }
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] datas = e.getDataEntities();
        DynamicObject data = null;
        StringBuilder errorStr = null;
        String operateKey = "unsubmit";
        ArrayList<DynamicObject> successObjs = new ArrayList<DynamicObject>();
        for (int i = 0; i < datas.length; ++i) {
            data = datas[i];
            SaleOrderUtil.handleStoreReverse((DynamicObject)datas[i]);
            try {
                SaleOrderUtil.handleBalance4UnSubmit((DynamicObject)data);
                successObjs.add(data);
                continue;
            }
            catch (Exception ex) {
                errorStr = new StringBuilder();
                errorStr.append(OP.getName((String)operateKey)).append("\u5931\u8d25").append(data.getString("billno")).append(",\u66f4\u65b0\u9884\u6536\u6b3e\u4e09\u6b21\u91cd\u8bd5\u5168\u90e8\u5931\u8d25\u3002\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002");
                ValidationErrorInfo errorInfo = new ValidationErrorInfo("", data.getPkValue(), i, i + 1, operateKey, OP.getName((String)operateKey), errorStr.toString(), ErrorLevel.Error);
                this.operationResult.addErrorInfo((OperateErrorInfo)errorInfo);
            }
        }
        e.setDataEntities(successObjs.toArray(new DynamicObject[successObjs.size()]));
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        DynamicObject[] orders = e.getDataEntities();
        SaleOrderUtil.handleRebate4EndUnSubmit((DynamicObject[])orders);
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        DynamicObject[] datas = e.getDataEntities();
        for (int i = 0; i < datas.length; ++i) {
            PromotionServiceHelper.rollbackLimit((Object)datas[i].getPkValue(), (boolean)false);
        }
    }
}

