/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dpa.opplugin.newsaleorder.validator;

import java.math.BigDecimal;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.drp.mdr.common.CommonUtils;
import kd.drp.mdr.common.constants.OP;
import kd.drp.mdr.common.constants.SaleOrderEntryType;
import kd.drp.mdr.common.model.CheckResult;
import kd.drp.mdr.common.status.SaleOrderStatus;
import kd.drp.mdr.common.util.CustomerParamsUtil;
import kd.drp.mdr.common.util.CustomerUtil;
import kd.drp.mdr.common.util.SaleOrderUtil;
import kd.drp.mdr.common.util.SysParamsUtil;
import kd.drp.mdr.servicehelper.PromotionServiceHelper;
import kd.drp.mdr.validator.BatchFastValidator;

public class SaleOrderSaveValidator
extends BatchFastValidator {
    public void save(ExtendedDataEntity[] datas) {
        CheckResult result = null;
        for (ExtendedDataEntity data : datas) {
            result = this.save(data.getDataEntity());
            if (result.isSuccess()) continue;
            this.addFatalErrorMessage(data, result.getMsg());
        }
    }

    public void submit(ExtendedDataEntity[] datas) {
        CheckResult result = null;
        DynamicObject dynamicObject = null;
        Set<Object> orderids = new HashSet(datas.length);
        for (ExtendedDataEntity data : datas) {
            dynamicObject = data.getDataEntity();
            result = this.submit(dynamicObject);
            if (!result.isSuccess()) {
                this.addFatalErrorMessage(data, result.getMsg());
                continue;
            }
            DynamicObjectCollection entrys = dynamicObject.getDynamicObjectCollection("itementry");
            boolean ispresentbag = false;
            for (DynamicObject entry : entrys) {
                Object ispromotional = entry.get("ispromotional");
                String promotional = ispromotional == null ? "" : ispromotional.toString();
                if (promotional.compareTo("2") != 0) continue;
                ispresentbag = true;
                break;
            }
            if (ispresentbag) continue;
            orderids.add(dynamicObject.getPkValue());
        }
        if (orderids.size() > 0) {
            if ((orderids = PromotionServiceHelper.getAddPresentBagOrders(orderids)).size() == 0) {
                return;
            }
            for (ExtendedDataEntity data : datas) {
                if (!orderids.contains(data.getBillPkId())) continue;
                this.addFatalErrorMessage(data, "\u8bf7\u6dfb\u52a0\u201c\u8d60\u54c1\u5305\u201d\u4e2d\u7684\u8d60\u54c1\u3002");
            }
        }
    }

    public void audit(ExtendedDataEntity[] datas) {
        CheckResult result = null;
        for (ExtendedDataEntity data : datas) {
            result = this.audit(data.getDataEntity());
            if (result.isSuccess()) continue;
            this.addFatalErrorMessage(data, result.getMsg());
        }
    }

    private CheckResult save(DynamicObject data) {
        CheckResult checkResult = this.commonCheck(data);
        if (!checkResult.isSuccess()) {
            return checkResult;
        }
        checkResult = this.orderOpTimeCheck("save", data);
        if (!checkResult.isSuccess()) {
            return checkResult;
        }
        return checkResult;
    }

    private CheckResult submit(DynamicObject data) {
        Object oId = data.get("Id");
        long id = Long.parseLong(oId == null ? "0" : oId.toString());
        CheckResult checkResult = null;
        if (id == 0L) {
            return CheckResult.returnFalse((String)ResManager.loadKDString((String)"\u53ea\u6709\u5df2\u4fdd\u5b58\u5355\u636e\u624d\u80fd\u63d0\u4ea4\uff01", (String)"SaleOrderSaveValidator_0", (String)"drp-dpa-opplugin", (Object[])new Object[0]));
        }
        checkResult = this.commonCheck(data);
        if (!checkResult.isSuccess()) {
            return checkResult;
        }
        checkResult = this.orderOpTimeCheck("submit", data);
        if (!checkResult.isSuccess()) {
            return checkResult;
        }
        checkResult = this.promotionCheck(data);
        if (!checkResult.isSuccess()) {
            return checkResult;
        }
        return checkResult;
    }

    private CheckResult promotionCheck(DynamicObject data) {
        if (!SysParamsUtil.getIsCheckPromotion()) {
            return CheckResult.returnTrue();
        }
        Object saleOrderId = data.getPkValue();
        DynamicObjectCollection proExeDyns = QueryServiceHelper.query((String)"dpm_execution", (String)"policy", (QFilter[])new QFilter[]{new QFilter("order", "=", saleOrderId)});
        if (CommonUtils.isNull((Object)proExeDyns)) {
            return CheckResult.returnTrue();
        }
        List policyIds = proExeDyns.stream().map(dynamicObject -> dynamicObject.getLong("policy")).collect(Collectors.toList());
        DynamicObjectCollection promotionDyns = QueryServiceHelper.query((String)"dpm_policy", (String)"number,starttime,endtime,policystatus", (QFilter[])new QFilter[]{new QFilter("id", "in", policyIds)});
        if (!CommonUtils.isNull((Object)proExeDyns)) {
            StringBuilder numbers = new StringBuilder();
            for (DynamicObject promotion : promotionDyns) {
                Date startTime = promotion.getDate("starttime");
                Date endTime = promotion.getDate("endtime");
                String policyStatus = promotion.getString("policystatus");
                Date now = new Date();
                if (startTime.compareTo(now) <= 0 && now.compareTo(endTime) <= 0 && "D".equals(policyStatus)) continue;
                numbers.append(promotion.getString("number")).append("\uff0c");
            }
            if (numbers.length() > 0) {
                return CheckResult.returnFalse((String)"\u7f16\u7801\u4e3a%s\u7684\u4fc3\u9500\u653f\u7b56\u5df2\u5931\u6548", (Object[])new Object[]{numbers.deleteCharAt(numbers.length() - 1)});
            }
        }
        return CheckResult.returnTrue();
    }

    private CheckResult audit(DynamicObject data) {
        CheckResult checkResult = this.commonCheck(data);
        if (!checkResult.isSuccess()) {
            return checkResult;
        }
        checkResult = this.orderOpTimeCheck("audit", data);
        if (!checkResult.isSuccess()) {
            return checkResult;
        }
        return checkResult;
    }

    protected CheckResult commonCheck(DynamicObject data) {
        CheckResult result;
        Object customerId;
        Object ownerId = data.get("owner.id");
        if (!CustomerUtil.isAuthRelation((Object)ownerId, (Object)(customerId = data.get("customer.id")))) {
            return CheckResult.returnFalse((String)ResManager.loadKDString((String)"\u4f9b\u8d27\u6e20\u9053\u548c\u6211\u7684\u6e20\u9053\u6ca1\u6709\u6388\u6743\u5173\u7cfb\uff01", (String)"SaleOrderSaveValidator_1", (String)"drp-dpa-opplugin", (Object[])new Object[0]));
        }
        if (!this.isFromListPage() && !(result = this.checkOrderEntryData(data)).isSuccess()) {
            return result;
        }
        return CheckResult.returnTrue();
    }

    private CheckResult checkOrderEntryData(DynamicObject data) {
        CheckResult result = CheckResult.returnTrue();
        DynamicObjectCollection entrys = data.getDynamicObjectCollection("itementry");
        List<DynamicObject> emptyEntry = this.getEmptyEntry(entrys);
        if (entrys.size() == 0 || emptyEntry.size() == entrys.size()) {
            return CheckResult.returnFalse((String)ResManager.loadKDString((String)"\u81f3\u5c11\u8981\u6709\u4e00\u6761\u5206\u5f55\uff01", (String)"SaleOrderSaveValidator_2", (String)"drp-dpa-opplugin", (Object[])new Object[0]));
        }
        if (emptyEntry.size() > 0) {
            entrys.removeAll(emptyEntry);
        }
        boolean isChange = SaleOrderUtil.isThisStatus((DynamicObject)data, (SaleOrderStatus)SaleOrderStatus.CHANGING);
        int index = 1;
        for (DynamicObject tow : entrys) {
            String entryType = tow.getString("entrytype");
            result = SaleOrderEntryType.COMBINATION.getFlagStr().equals(entryType) ? this.checkCombEntry(isChange, index, tow) : this.checkCommonEntry(isChange, index, tow);
            if (!result.isSuccess()) {
                return result;
            }
            ++index;
        }
        return result;
    }

    private List<DynamicObject> getEmptyEntry(DynamicObjectCollection entrys) {
        ArrayList<DynamicObject> emptyEntrys = new ArrayList<DynamicObject>();
        for (int i = 0; i < entrys.size(); ++i) {
            DynamicObject entry = (DynamicObject)entrys.get(i);
            Object item = entry.get("item");
            Object combitem = null;
            boolean isProExist = CommonUtils.checkPropertyIsExist((DynamicObject)entry, (String)"combitem");
            if (isProExist) {
                combitem = entry.get("combitem");
            }
            if (item != null || combitem != null) continue;
            emptyEntrys.add(entry);
        }
        return emptyEntrys;
    }

    private CheckResult checkCombEntry(boolean isChange, int index, DynamicObject tow) {
        BigDecimal qty = null;
        Object combItem = tow.get("combitem");
        if (combItem == null) {
            return CheckResult.returnFalse((String)ResManager.loadKDString((String)"\u7ec4\u5408\u5546\u54c1\u5206\u5f55\uff0c\u7ec4\u5408\u5546\u54c1\u4e0d\u80fd\u4e3a\u7a7a", (String)"SaleOrderSaveValidator_3", (String)"drp-dpa-opplugin", (Object[])new Object[0]));
        }
        qty = tow.getBigDecimal("qty");
        if (isChange) {
            if (qty.compareTo(BigDecimal.ZERO) < 0) {
                return CheckResult.returnFalse((String)(ResManager.loadKDString((String)"\u53d8\u66f4\u72b6\u6001\u4e0b\uff1a\u7ec4\u5408\u5546\u54c1\u5206\u5f55", (String)"SaleOrderSaveValidator_4", (String)"drp-dpa-opplugin", (Object[])new Object[0]) + index + ResManager.loadKDString((String)"\uff1a\u6570\u91cf\u4e0d\u80fd\u5c0f\u4e8e0", (String)"SaleOrderSaveValidator_5", (String)"drp-dpa-opplugin", (Object[])new Object[0])));
            }
        } else if (qty.compareTo(BigDecimal.ZERO) <= 0) {
            return CheckResult.returnFalse((String)(ResManager.loadKDString((String)"\u7ec4\u5408\u5546\u54c1\u5206\u5f55", (String)"SaleOrderSaveValidator_6", (String)"drp-dpa-opplugin", (Object[])new Object[0]) + index + ResManager.loadKDString((String)"\uff1a\u6570\u91cf\u5fc5\u987b\u5927\u4e8e0", (String)"SaleOrderSaveValidator_7", (String)"drp-dpa-opplugin", (Object[])new Object[0])));
        }
        return CheckResult.returnTrue();
    }

    private CheckResult checkCommonEntry(boolean isChange, int index, DynamicObject tow) {
        BigDecimal qty = null;
        BigDecimal price = null;
        BigDecimal assistQty = null;
        DynamicObject item = tow.getDynamicObject("item");
        if (item == null) {
            return CheckResult.returnFalse((String)(ResManager.loadKDString((String)"\u5546\u54c1\u5206\u5f55", (String)"SaleOrderSaveValidator_8", (String)"drp-dpa-opplugin", (Object[])new Object[0]) + index + ResManager.loadKDString((String)"\uff1a\u5546\u54c1\u4e0d\u80fd\u4e3a\u7a7a", (String)"SaleOrderSaveValidator_9", (String)"drp-dpa-opplugin", (Object[])new Object[0])));
        }
        DynamicObject unit = tow.getDynamicObject("unit");
        if (unit == null) {
            return CheckResult.returnFalse((String)(ResManager.loadKDString((String)"\u53d8\u66f4\u72b6\u6001\u4e0b\uff1a\u5546\u54c1\u5206\u5f55", (String)"SaleOrderSaveValidator_10", (String)"drp-dpa-opplugin", (Object[])new Object[0]) + index + ResManager.loadKDString((String)"\uff1a\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a", (String)"SaleOrderSaveValidator_11", (String)"drp-dpa-opplugin", (Object[])new Object[0])));
        }
        qty = tow.getBigDecimal("qty");
        if (isChange) {
            if (qty.compareTo(BigDecimal.ZERO) < 0) {
                return CheckResult.returnFalse((String)(ResManager.loadKDString((String)"\u53d8\u66f4\u72b6\u6001\u4e0b\uff1a\u5546\u54c1\u5206\u5f55", (String)"SaleOrderSaveValidator_10", (String)"drp-dpa-opplugin", (Object[])new Object[0]) + index + ResManager.loadKDString((String)"\uff1a\u6570\u91cf\u4e0d\u80fd\u5c0f\u4e8e0", (String)"SaleOrderSaveValidator_5", (String)"drp-dpa-opplugin", (Object[])new Object[0])));
            }
        } else {
            if (qty.compareTo(BigDecimal.ZERO) <= 0) {
                return CheckResult.returnFalse((String)(ResManager.loadKDString((String)"\u5546\u54c1\u5206\u5f55", (String)"SaleOrderSaveValidator_8", (String)"drp-dpa-opplugin", (Object[])new Object[0]) + index + ResManager.loadKDString((String)"\uff1a\u6570\u91cf\u5fc5\u987b\u5927\u4e8e0", (String)"SaleOrderSaveValidator_7", (String)"drp-dpa-opplugin", (Object[])new Object[0])));
            }
            price = tow.getBigDecimal("taxprice");
            if (price.compareTo(BigDecimal.ZERO) < 0) {
                return CheckResult.returnFalse((String)(ResManager.loadKDString((String)"\u5546\u54c1\u5206\u5f55", (String)"SaleOrderSaveValidator_8", (String)"drp-dpa-opplugin", (Object[])new Object[0]) + index + ResManager.loadKDString((String)"\uff1a\u5355\u4ef7\u4e0d\u80fd\u5c0f\u4e8e0", (String)"SaleOrderSaveValidator_12", (String)"drp-dpa-opplugin", (Object[])new Object[0])));
            }
            assistQty = tow.getBigDecimal("assistqty");
            if (assistQty.compareTo(BigDecimal.ZERO) < 0) {
                return CheckResult.returnFalse((String)(ResManager.loadKDString((String)"\u5546\u54c1\u5206\u5f55", (String)"SaleOrderSaveValidator_8", (String)"drp-dpa-opplugin", (Object[])new Object[0]) + index + ResManager.loadKDString((String)"\uff1a\u8f85\u52a9\u6570\u91cf\u4e0d\u80fd\u5c0f\u4e8e0", (String)"SaleOrderSaveValidator_13", (String)"drp-dpa-opplugin", (Object[])new Object[0])));
            }
        }
        DynamicObject assistattr = tow.getDynamicObject("assistattr");
        boolean hasattr = item.getBoolean("hasattr");
        if (hasattr && assistattr == null) {
            return CheckResult.returnFalse((String)(ResManager.loadKDString((String)"\u5546\u54c1\u5206\u5f55", (String)"SaleOrderSaveValidator_8", (String)"drp-dpa-opplugin", (Object[])new Object[0]) + index + ResManager.loadKDString((String)"\uff1a\u5546\u54c1\u5f00\u542f\u8f85\u52a9\u5c5e\u6027\uff0c\u8f85\u52a9\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a", (String)"SaleOrderSaveValidator_14", (String)"drp-dpa-opplugin", (Object[])new Object[0])));
        }
        return CheckResult.returnTrue();
    }

    private CheckResult orderOpTimeCheck(String operatKey, DynamicObject saleOrder) {
        if (this.isFromListPage()) {
            Object pkId = saleOrder.getPkValue();
            saleOrder = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)"bbc_saleorder", (String)"owner");
        }
        DynamicObject currentOwner = saleOrder.getDynamicObject("owner");
        Object ownerId = currentOwner.get("id");
        String fields = "id,timeentity.id,timeentity.operation,timeentity.isuse,timeentity.starttime,timeentity.endtime";
        DynamicObjectCollection timeentityCollection = CustomerParamsUtil.getTimeEntity((Object)ownerId, (String)fields);
        for (DynamicObject timeentity : timeentityCollection) {
            LocalTime endTime;
            boolean isuse = timeentity.getBoolean("timeentity.isuse");
            String operation = timeentity.getString("timeentity.operation");
            if (operation == null || !operation.contains(operatKey) || !isuse) continue;
            Date startDate = timeentity.getDate("timeentity.starttime");
            Date endDate = timeentity.getDate("timeentity.endtime");
            Instant startInstant = startDate.toInstant();
            Instant endInstant = endDate.toInstant();
            ZoneId zone = ZoneId.systemDefault();
            LocalDateTime startDateTime = LocalDateTime.ofInstant(startInstant, zone);
            LocalDateTime endDateTime = LocalDateTime.ofInstant(endInstant, zone);
            LocalTime startTime = startDateTime.toLocalTime();
            boolean isCan = this.isCanOrder(startTime, endTime = endDateTime.toLocalTime());
            if (isCan) continue;
            return CheckResult.returnFalse((String)(ResManager.loadKDString((String)"\u8be5\u65f6\u95f4\u6bb5\u4e0d\u5141\u8bb8\u8fdb\u884c", (String)"SaleOrderSaveValidator_15", (String)"drp-dpa-opplugin", (Object[])new Object[0]) + OP.getName((String)operatKey) + ResManager.loadKDString((String)"\u64cd\u4f5c\uff0c\u8bf7\u5728", (String)"SaleOrderSaveValidator_16", (String)"drp-dpa-opplugin", (Object[])new Object[0]) + startTime + ResManager.loadKDString((String)"\u81f3", (String)"SaleOrderSaveValidator_17", (String)"drp-dpa-opplugin", (Object[])new Object[0]) + endTime + ResManager.loadKDString((String)"\u65f6\u95f4\u6bb5\u5185\u8fdb\u884c", (String)"SaleOrderSaveValidator_18", (String)"drp-dpa-opplugin", (Object[])new Object[0])));
        }
        return CheckResult.returnTrue();
    }

    public boolean isCanOrder(LocalTime startdatetime, LocalTime enddatetime) {
        LocalTime currentTime = LocalTime.now();
        if (startdatetime != null && currentTime.isBefore(startdatetime)) {
            return false;
        }
        return enddatetime == null || !currentTime.isAfter(enddatetime);
    }
}

