/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dpa.opplugin.newsaleorder.validator;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.drp.mdr.common.model.CheckResult;
import kd.drp.mdr.common.status.SaleOrderStatus;
import kd.drp.mdr.common.status.SaleOrderSyncStatus;
import kd.drp.mdr.common.util.ReceivingbillUtil;
import kd.drp.mdr.common.util.SaleOrderUtil;
import kd.drp.mdr.common.util.SysParamsUtil;
import kd.drp.mdr.validator.BatchFastValidator;

public class SaleOrderUnAuditValidator
extends BatchFastValidator {
    public void unaudit(ExtendedDataEntity[] datas) {
        for (ExtendedDataEntity data : datas) {
            CheckResult checkResult = this.checkCanUnAudit(data.getDataEntity());
            if (checkResult.isSuccess()) continue;
            this.addFatalErrorMessage(data, checkResult.getMsg());
        }
    }

    private CheckResult checkCanUnAudit(DynamicObject order) {
        BigDecimal salePayAmount;
        boolean isDispatch = SysParamsUtil.isDispatch();
        if (isDispatch) {
            if (!SaleOrderUtil.isThisStatus((DynamicObject)order, (SaleOrderStatus)SaleOrderStatus.PENDING_DISPATCH) || !SaleOrderUtil.isThisStatus((DynamicObject)order, (SaleOrderSyncStatus)SaleOrderSyncStatus.NO_SYNC) && !SaleOrderUtil.isThisStatus((DynamicObject)order, (SaleOrderSyncStatus)SaleOrderSyncStatus.NOT_SYNC)) {
                return CheckResult.returnFalse((String)ResManager.loadKDString((String)"\u53ea\u6709\u5f85\u5206\u8d27\u4e14\u5f85\u540c\u6b65\u6216\u540c\u6b65\u72b6\u6001\u4e3a\u7a7a\u7684\u5355\u636e\u624d\u80fd\u53cd\u5ba1\u6838", (String)"SaleOrderUnAuditValidator_0", (String)"drp-dpa-opplugin", (Object[])new Object[0]));
            }
        } else if (!SaleOrderUtil.isThisStatus((DynamicObject)order, (SaleOrderStatus)SaleOrderStatus.PENDING_DELIVERY) || !SaleOrderUtil.isThisStatus((DynamicObject)order, (SaleOrderSyncStatus)SaleOrderSyncStatus.NO_SYNC) && !SaleOrderUtil.isThisStatus((DynamicObject)order, (SaleOrderSyncStatus)SaleOrderSyncStatus.NOT_SYNC)) {
            return CheckResult.returnFalse((String)ResManager.loadKDString((String)"\u53ea\u6709\u5f85\u53d1\u8d27\u4e14\u5f85\u540c\u6b65\u6216\u540c\u6b65\u72b6\u6001\u4e3a\u7a7a\u7684\u5355\u636e\u624d\u80fd\u53cd\u5ba1\u6838", (String)"SaleOrderUnAuditValidator_1", (String)"drp-dpa-opplugin", (Object[])new Object[0]));
        }
        if ((salePayAmount = ReceivingbillUtil.getBillSalePayAmount((Object)order.get("id"), (String)"saleorder")).compareTo(BigDecimal.ZERO) > 0) {
            return CheckResult.returnFalse((String)ResManager.loadKDString((String)"\u8ba2\u5355\u5df2\u6709\u9500\u552e\u56de\u6b3e\uff0c\u8bf7\u5148\u5904\u7406\u9500\u552e\u56de\u6b3e\u540e\u518d\u53cd\u5ba1\u6838", (String)"SaleOrderUnAuditValidator_2", (String)"drp-dpa-opplugin", (Object[])new Object[0]));
        }
        if (BFTrackerServiceHelper.isPush((String)"bbc_saleorder", (Long)order.getLong("id"))) {
            return CheckResult.returnFalse((String)ResManager.loadKDString((String)"\u8ba2\u5355\u5df2\u5b58\u5728\u4e0b\u6e38\u5355\u636e\uff0c\u8bf7\u5148\u5220\u9664\u4e0b\u6e38\u5355\u636e\u518d\u53cd\u5ba1\u6838", (String)"SaleOrderUnAuditValidator_3", (String)"drp-dpa-opplugin", (Object[])new Object[0]));
        }
        return CheckResult.returnTrue();
    }
}

