/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dpa.opplugin.returnorder;

import com.alibaba.fastjson.JSONArray;
import java.math.BigDecimal;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.drp.mdr.common.handler.ReceivingBillHandler;
import kd.drp.mdr.common.util.SysParamsUtil;
import kd.drp.mdr.opplugin.MdrBaseOperationServicePlugIn;

public class ReturnOrderAuditOp
extends MdrBaseOperationServicePlugIn {
    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("itementry");
        fieldKeys.add("itementry.srcbillid");
        fieldKeys.add("itementry.srcbillnumber");
        fieldKeys.add("totalamountandtax");
        fieldKeys.add("billno");
        fieldKeys.add("billstatus");
        fieldKeys.add("owner");
        fieldKeys.add("customer");
        fieldKeys.add("srcbillentity");
        fieldKeys.add("currentbackrebamount");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject[] returnOrderObjs = e.getDataEntities();
        String operationKey = e.getOperationKey();
        for (int i = 0; i < returnOrderObjs.length; ++i) {
            if (SysParamsUtil.getIsAutoReturnBalance()) {
                if (ReturnOrderAuditOp.isFromSaleOrder(returnOrderObjs[i]) && "audit".equals(operationKey)) {
                    ReceivingBillHandler.newReceivingBillThenAudit((DynamicObject)returnOrderObjs[i]);
                } else if (ReturnOrderAuditOp.isFromSaleOrder(returnOrderObjs[i]) && "unaudit".equals(operationKey)) {
                    ReceivingBillHandler.deleteReceivingBill((DynamicObject)returnOrderObjs[i]);
                }
            }
            if (!SysParamsUtil.isAutoReturnRebate()) continue;
            BigDecimal currentbackrebamount = returnOrderObjs[i].getBigDecimal("currentbackrebamount");
            if (!ReturnOrderAuditOp.isFromSaleOrder(returnOrderObjs[i]) || currentbackrebamount.compareTo(BigDecimal.ZERO) <= 0) continue;
            JSONArray ids = new JSONArray();
            ids.add((Object)returnOrderObjs[i].get("id").toString());
            if ("audit".equals(operationKey)) {
                DispatchServiceHelper.invokeBizService((String)"drp", (String)"drm", (String)"RebateService", (String)"handleAccount4ReturnOrderAudit", (Object[])new Object[]{ids.toString()});
                continue;
            }
            if (!"unaudit".equals(operationKey)) continue;
            DispatchServiceHelper.invokeBizService((String)"drp", (String)"drm", (String)"RebateService", (String)"handleAccount4ReturnOrderUnAudit", (Object[])new Object[]{ids.toString()});
        }
    }

    private static boolean isFromSaleOrder(DynamicObject returnOrderObj) {
        DynamicObjectCollection itemEntry = returnOrderObj.getDynamicObjectCollection("itementry");
        return itemEntry.size() > 0 && "bbc_saleorder".equalsIgnoreCase(((DynamicObject)itemEntry.get(0)).getString("srcbillentity"));
    }
}

