/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dpa.report;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.orm.ORM;
import kd.drp.mdr.common.util.UserUtil;
import org.apache.log4j.Logger;

public class OrderSimpleQueryRpt
extends AbstractReportListDataPlugin {
    protected List<Object> ownerid = UserUtil.getOwnerIDs();
    private static Logger LOG = Logger.getLogger(OrderSimpleQueryRpt.class);

    public DataSet query(ReportQueryParam arg0, Object arg1) throws Throwable {
        if (this.ownerid == null) {
            this.ownerid = new ArrayList<Object>();
        }
        LocalDate now = LocalDate.now();
        String start = now.format(DateTimeFormatter.ofPattern("yyyy-MM-dd 00:00:00"));
        String end = now.format(DateTimeFormatter.ofPattern("yyyy-MM-dd 23:59:59"));
        DataSet dayset = this.queryregiondataset(start, end, ResManager.loadKDString((String)"\u4eca\u65e5", (String)"OrderSimpleQueryRpt_0", (String)"drp-dpa-report", (Object[])new Object[0]));
        start = now.format(DateTimeFormatter.ofPattern("yyyy-MM-01 00:00:00"));
        end = now.with(TemporalAdjusters.lastDayOfMonth()).format(DateTimeFormatter.ofPattern("yyyy-MM-dd 23:59:59"));
        DataSet monthset = this.queryregiondataset(start, end, ResManager.loadKDString((String)"\u4eca\u6708", (String)"OrderSimpleQueryRpt_1", (String)"drp-dpa-report", (Object[])new Object[0]));
        start = now.format(DateTimeFormatter.ofPattern("yyyy-01-01 00:00:00"));
        end = now.format(DateTimeFormatter.ofPattern("yyyy-12-31 23:59:59"));
        DataSet yearset = this.queryregiondataset(start, end, ResManager.loadKDString((String)"\u4eca\u5e74", (String)"OrderSimpleQueryRpt_2", (String)"drp-dpa-report", (Object[])new Object[0]));
        return dayset.union(monthset).union(yearset);
    }

    private String getdatestr(SimpleDateFormat sdf) {
        return sdf.format(new Date());
    }

    private DataSet queryregiondataset(String begindate, String enddate, String dateregion) {
        ORM orm = ORM.create();
        String str = this.getString();
        Object[] ob = this.getObjectValue(begindate, enddate);
        String returnsql = "select count(id) as returnqty,sum(totalamount) as returnamont from mdr_returnorder where customer.id in " + str + " and createtime > ? and createtime < ?";
        DataSet returnDataSet = orm.queryDataSet(((Object)((Object)this)).getClass().getName(), returnsql, ob);
        String reuturninfo = this.getReturnInfo(returnDataSet);
        String ordersql = "select '" + dateregion + "' as dateregion, count(id) as orderqty,sum(totalorderamount) as orderamount " + reuturninfo + " from dpa_purorder where customer.id in " + str + " and orderdate > ? and orderdate < ?";
        return orm.queryDataSet(((Object)((Object)this)).getClass().getName(), ordersql, ob);
    }

    private String getReturnInfo(DataSet returnDataSet) {
        StringBuilder str = new StringBuilder();
        for (Row row : returnDataSet) {
            str.append(',').append(row.getBigDecimal("returnqty")).append(" as returnqty");
            if (row.getBigDecimal("returnamont") == null || row.getBigDecimal("returnamont").compareTo(BigDecimal.ZERO) == 0) {
                str.append(',').append(" 0 as returnamont");
                continue;
            }
            str.append(',').append(row.getBigDecimal("returnamont")).append(" as returnamont");
        }
        return str.toString();
    }

    private String getString() {
        if (this.ownerid.isEmpty()) {
            return "(0)";
        }
        StringBuilder str = new StringBuilder("(");
        for (int i = 0; i < this.ownerid.size(); ++i) {
            str.append("?,");
        }
        return str.substring(0, str.length() - 1) + ")";
    }

    private Object[] getObjectValue(String begindate, String enddate) {
        if (this.ownerid != null) {
            ArrayList<Object> newList = new ArrayList<Object>(this.ownerid);
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Date startTime = null;
            Date endTime = null;
            try {
                startTime = simpleDateFormat.parse(begindate);
                endTime = simpleDateFormat.parse(enddate);
            }
            catch (Exception e) {
                LOG.error((Object)e.getMessage());
                throw new KDBizException(ResManager.loadKDString((String)"\u65e5\u671f\u8f6c\u6362\u5f02\u5e38", (String)"OrderSimpleQueryRpt_3", (String)"drp-dpa-report", (Object[])new Object[0]));
            }
            newList.add(startTime);
            newList.add(endTime);
            return newList.toArray();
        }
        return new Object[0];
    }
}

