/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dpa.formplugin.bill.saleorder;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.drp.mdr.common.util.DeliveryUtil;
import kd.drp.mdr.formplugin.MdrFormPlugin;

public class DeliverySignPlugin
extends MdrFormPlugin
implements CellClickListener {
    public static final String TOOL_BARAP = "toolbarap";
    public static final String EDIT_LOGISTICS = "editlogistics";
    public static final String SIGN = "sign";
    public static final String REFRESH = "refresh";
    public static final String DELIVERY_RECORD_LIST = "deliveryrecordlist";
    public static final String TB_DELIVERYRECORDID = "deliveryrecordid";
    public static final String TB_DELIVERYRECORDNO = "deliveryrecordno";
    public static final String TB_DELIVERYDATE = "deliverydate";
    public static final String TB_LOGISTICS = "logistics";
    public static final String TB_LOGISTICSBILL = "logisticsbill";
    public static final String TB_ITEM = "item";
    public static final String TB_UNIT = "unit";
    public static final String TB_ASSISTATTR = "assistattr";
    public static final String TB_DELIVERQTY = "deliverqty";
    public static final String TB_DELIVERYDETAIL = "deliverydetail";
    public static final String TB_SIGN_QTY = "signqty";
    public static final String TB_FEEDBACK = "feedback";

    public void initialize() {
        super.initialize();
        this.addItemClickListeners(new String[]{TOOL_BARAP});
        EntryGrid deliveryRecordList = (EntryGrid)this.getControl(DELIVERY_RECORD_LIST);
        deliveryRecordList.addCellClickListener((CellClickListener)this);
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        if (EDIT_LOGISTICS.equals(evt.getItemKey())) {
            this.editLogistics();
        } else if (SIGN.equals(evt.getItemKey())) {
            this.sign();
        } else if (REFRESH.equals(evt.getItemKey())) {
            this.initTable();
        }
    }

    private void sign() {
        EntryGrid deliveryRecordList = (EntryGrid)this.getControl(DELIVERY_RECORD_LIST);
        int[] rows = deliveryRecordList.getSelectRows();
        if (rows.length > 0) {
            HashSet<Long> deliveryRecords = new HashSet<Long>(rows.length);
            HashSet<Integer> rowIndexSet = new HashSet<Integer>();
            for (int n : rows) {
                String deliveryRecordId = (String)this.getModel().getValue(TB_DELIVERYRECORDID, n);
                deliveryRecords.add(Long.valueOf(deliveryRecordId));
            }
            for (int i = 0; i < this.getModel().getEntryRowCount(DELIVERY_RECORD_LIST); ++i) {
                String deliveryRecordId = (String)this.getModel().getValue(TB_DELIVERYRECORDID, i);
                if (!deliveryRecords.contains(Long.valueOf(deliveryRecordId))) continue;
                rowIndexSet.add(i);
            }
            try (TXHandle h = TX.required();){
                try {
                    for (Object e : deliveryRecords) {
                        DynamicObject deliveryRecord = BusinessDataServiceHelper.loadSingle(e, (String)"bbc_delivery_record");
                        if (deliveryRecord == null) {
                            throw new KDBizException(ResManager.loadKDString((String)"\u7b7e\u6536\u5931\u8d25\uff0c\u83b7\u53d6\u53d1\u8d27\u4fe1\u606f\u5931\u8d25\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\uff01", (String)"DeliverySignPlugin_0", (String)"drp-dpa-formplugin", (Object[])new Object[0]));
                        }
                        DynamicObjectCollection deliveryDetails = deliveryRecord.getDynamicObjectCollection(TB_DELIVERYDETAIL);
                        for (DynamicObject deliveryDetail : deliveryDetails) {
                            Iterator iterator = rowIndexSet.iterator();
                            while (iterator.hasNext()) {
                                int row = (Integer)iterator.next();
                                Object rowDeliveryDetailId = this.getModel().getValue(TB_DELIVERYDETAIL, row);
                                if (rowDeliveryDetailId == null || !rowDeliveryDetailId.toString().equals(deliveryDetail.get("id").toString())) continue;
                                BigDecimal signQty = (BigDecimal)this.getModel().getValue(TB_SIGN_QTY, row);
                                Object feedback = this.getModel().getValue(TB_FEEDBACK, row);
                                deliveryDetail.set(TB_SIGN_QTY, (Object)signQty);
                                deliveryDetail.set(TB_FEEDBACK, feedback);
                            }
                        }
                        DeliveryUtil.sign((DynamicObject)deliveryRecord, (boolean)true);
                    }
                }
                catch (Throwable e) {
                    h.markRollback();
                    throw e;
                }
            }
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u7b7e\u6536\u6210\u529f", (String)"DeliverySignPlugin_1", (String)"drp-dpa-formplugin", (Object[])new Object[0]));
            this.initTable();
            this.getView().close();
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u4e2d\u8981\u7b7e\u6536\u7684\u53d1\u8d27\u8bb0\u5f55", (String)"DeliverySignPlugin_2", (String)"drp-dpa-formplugin", (Object[])new Object[0]));
        }
    }

    private void editLogistics() {
        EntryGrid deliveryRecordList = (EntryGrid)this.getControl(DELIVERY_RECORD_LIST);
        int[] rows = deliveryRecordList.getSelectRows();
        if (rows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u4e2d\u8981\u4fee\u6539\u7269\u6d41\u4fe1\u606f\u7684\u53d1\u8d27\u8bb0\u5f55\uff01", (String)"DeliverySignPlugin_3", (String)"drp-dpa-formplugin", (Object[])new Object[0]));
        } else if (rows.length > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7269\u6d41\u4fe1\u606f\u6682\u4e0d\u652f\u6301\u6279\u91cf\u4fee\u6539\uff0c\u8bf7\u53ea\u9009\u4e2d\u8981\u4fee\u6539\u7269\u6d41\u4fe1\u606f\u7684\u53d1\u8d27\u8bb0\u5f55\uff01", (String)"DeliverySignPlugin_4", (String)"drp-dpa-formplugin", (Object[])new Object[0]));
        } else {
            String deliveryRecordId = (String)this.getModel().getValue(TB_DELIVERYRECORDID, rows[0]);
            FormShowParameter parameter = new FormShowParameter();
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setFormId("mdr_logistics_change");
            parameter.setStatus(OperationStatus.ADDNEW);
            parameter.setCustomParam("deliveryRecord", (Object)Long.valueOf(deliveryRecordId));
            this.getView().showForm(parameter);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initTable();
    }

    private void initTable() {
        this.getModel().deleteEntryData(DELIVERY_RECORD_LIST);
        List orderList = (List)this.getView().getFormShowParameter().getCustomParam("orderList");
        if (orderList == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4f20\u8f93\u8ba2\u5355\u6570\u636e\u6709\u8bef\uff0c\u8bf7\u91cd\u65b0\u64cd\u4f5c\uff01", (String)"DeliverySignPlugin_5", (String)"drp-dpa-formplugin", (Object[])new Object[0]));
        }
        QFilter filer = new QFilter("deliverydetail.srcbillid", "in", (Object)orderList);
        filer.or("deliverydetail.mainbillid", "in", (Object)orderList);
        filer.and("signstatus", "=", (Object)"0");
        DynamicObject[] orderEntryInfo = BusinessDataServiceHelper.load((String)"bbc_delivery_record", (String)"id,billno,deliverdate,logistics,logisticsbill,deliverydetail.id,deliverydetail.item,deliverydetail.unit,deliverydetail.assistattr,deliverydetail.deliverqty", (QFilter[])filer.toArray());
        DynamicObjectCollection entrys = null;
        IDataModel model = this.getModel();
        Object id = null;
        for (DynamicObject orderEntry : orderEntryInfo) {
            id = orderEntry.get("id");
            entrys = orderEntry.getDynamicObjectCollection(TB_DELIVERYDETAIL);
            for (DynamicObject detail : entrys) {
                int i = model.createNewEntryRow(DELIVERY_RECORD_LIST);
                model.setValue(TB_DELIVERYRECORDID, id, i);
                model.setValue(TB_DELIVERYRECORDNO, orderEntry.get("billno"), i);
                model.setValue(TB_DELIVERYDATE, orderEntry.get("deliverdate"), i);
                model.setValue(TB_LOGISTICS, orderEntry.get(TB_LOGISTICS), i);
                model.setValue(TB_LOGISTICSBILL, orderEntry.get(TB_LOGISTICSBILL), i);
                model.setValue(TB_DELIVERYDETAIL, detail.get("id"), i);
                model.setValue(TB_ITEM, detail.get(TB_ITEM), i);
                model.setValue(TB_UNIT, detail.get(TB_UNIT), i);
                model.setValue(TB_ASSISTATTR, detail.get(TB_ASSISTATTR), i);
                model.setValue(TB_DELIVERQTY, detail.get(TB_DELIVERQTY), i);
                model.setValue(TB_SIGN_QTY, detail.get(TB_DELIVERQTY), i);
            }
        }
    }

    public void cellClick(CellClickEvent arg0) {
        EntryGrid deliveryRecordList = (EntryGrid)this.getControl(DELIVERY_RECORD_LIST);
        deliveryRecordList.getEntryState().getFocusField();
        int onfocusRow = arg0.getRow();
        if (TB_SIGN_QTY.equals(arg0.getFieldKey()) || TB_FEEDBACK.equals(arg0.getFieldKey()) || "0".equals(arg0.getFieldKey()) && onfocusRow == -1) {
            return;
        }
        int[] rows = deliveryRecordList.getSelectRows();
        HashSet<Integer> rowIndexSet = new HashSet<Integer>();
        boolean hasSelect = false;
        if (rows.length > 0) {
            for (int row : rows) {
                rowIndexSet.add(row);
                if (onfocusRow != row) continue;
                hasSelect = true;
            }
        }
        String deliveryRecordId = (String)this.getModel().getValue(TB_DELIVERYRECORDID, onfocusRow);
        for (int i = 0; i < this.getModel().getEntryRowCount(DELIVERY_RECORD_LIST); ++i) {
            String deliveryRecordId2 = (String)this.getModel().getValue(TB_DELIVERYRECORDID, i);
            if (!deliveryRecordId.equals(deliveryRecordId2)) continue;
            if (hasSelect) {
                rowIndexSet.add(i);
                continue;
            }
            rowIndexSet.remove(i);
        }
        ArrayList rowIndexList = new ArrayList(rowIndexSet);
        int[] d = new int[rowIndexList.size()];
        for (int i = 0; i < rowIndexList.size(); ++i) {
            d[i] = (Integer)rowIndexList.get(i);
        }
        deliveryRecordList.selectRows(d, onfocusRow);
    }

    public void cellDoubleClick(CellClickEvent arg0) {
    }
}

