/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dpa.formplugin.bill.saleorder;

import java.math.BigDecimal;
import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.drp.mdr.common.constants.OP;
import kd.drp.mdr.common.util.OperationUtil;
import kd.drp.mdr.formplugin.MdrBillPlugin;
import org.apache.commons.lang.StringUtils;

public class OEMSaleOrderEditPlugin
extends MdrBillPlugin
implements BeforeF7SelectListener,
TabSelectListener {
    private static final String ALTERQTY = "alterqty";
    private static final String PLADNPRODUCTQTY = "planproductqty";
    private static final String EXISTSTOREQTY = "existstoreqty";
    private static final String DELIVERABLEQTY = "deliverableqty";
    private static final String COMPLETEQTY = "completeqty";
    private static final String TOTALALTERQTY = "totalalterqty";
    private static final String PAGE_COMPLETEREPORTPAGE = "completereportpage";
    protected static final String PAGE_DELIVERYRECORDTB = "deliveryrecordtb";

    public void beforeF7Select(BeforeF7SelectEvent arg0) {
    }

    public void afterBindData(EventObject e) {
    }

    public void propertyChanged(PropertyChangedArgs e, String key) {
        switch (key) {
            case "existstoreqty": {
                this.handleExiststoreqtyPropertyChanged(e);
                break;
            }
            case "alterqty": {
                this.alterQtyChanged(e);
                break;
            }
        }
    }

    protected void alterQtyChanged(PropertyChangedArgs e) {
        ChangeData[] changeData = e.getChangeSet();
        BigDecimal newValue = (BigDecimal)changeData[0].getNewValue();
        BigDecimal oldValue = (BigDecimal)changeData[0].getOldValue();
        BigDecimal totalalterqty = (BigDecimal)this.getValue(TOTALALTERQTY);
        this.setValue(TOTALALTERQTY, totalalterqty.add(newValue).subtract(oldValue));
    }

    private void handleExiststoreqtyPropertyChanged(PropertyChangedArgs e) {
        ChangeData[] changeData = e.getChangeSet();
        BigDecimal newValue = (BigDecimal)changeData[0].getNewValue();
        BigDecimal oldValue = (BigDecimal)changeData[0].getOldValue();
        int rowIndex = this.getRowIndex(e);
        if (((BigDecimal)this.getValue(ALTERQTY)).subtract(newValue).compareTo(BigDecimal.ZERO) < 0) {
            this.getModel().setValue(EXISTSTOREQTY, (Object)oldValue, rowIndex);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u73b0\u6709\u5e93\u5b58\u91cf\u4e0d\u80fd\u5927\u4e8e\u4e0b\u8fbe\u6570\u91cf", (String)"OEMSaleOrderEditPlugin_0", (String)"drp-dpa-formplugin", (Object[])new Object[0]));
            return;
        }
        if (((BigDecimal)this.getValue(ALTERQTY)).subtract(newValue).subtract((BigDecimal)this.getValue(COMPLETEQTY)).compareTo(BigDecimal.ZERO) < 0) {
            this.getModel().setValue(EXISTSTOREQTY, (Object)oldValue, rowIndex);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u73b0\u6709\u5e93\u5b58\u91cf\u4e0d\u80fd\u5927\u4e8e\u4e0b\u8fbe\u6570\u91cf\u548c\u7d2f\u8ba1\u5df2\u5b8c\u5de5\u6570\u91cf\u7684\u5dee\u91cf", (String)"OEMSaleOrderEditPlugin_1", (String)"drp-dpa-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getModel().setValue(PLADNPRODUCTQTY, (Object)((BigDecimal)this.getValue(ALTERQTY)).subtract(newValue), rowIndex);
        BigDecimal deliverableqty = ((BigDecimal)this.getValue(EXISTSTOREQTY)).add((BigDecimal)this.getValue(COMPLETEQTY));
        this.getModel().setValue(DELIVERABLEQTY, (Object)deliverableqty, rowIndex);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String key;
        super.beforeDoOperation(args);
        switch (key = ((AbstractOperate)args.getSource()).getOperateKey()) {
            case "audit": 
            case "unaudit": 
            case "submit": 
            case "unsubmit": {
                args.setCancel(true);
                Object id = this.getModel().getDataEntity().get("id");
                DynamicObject saveObject = BusinessDataServiceHelper.loadSingle((Object)id, (String)"bbc_oemsaleorder");
                DynamicObject drpOemObject = this.getModel().getDataEntity();
                String result = OperationUtil.invokeOperationToStr((DynamicObject)saveObject, (String)key);
                if (StringUtils.isEmpty((String)result)) {
                    this.getView().showSuccessNotification(OP.getName((String)key) + ResManager.loadKDString((String)"\u6210\u529f", (String)"OEMSaleOrderEditPlugin_2", (String)"drp-dpa-formplugin", (Object[])new Object[0]));
                    this.reLoadPage();
                    break;
                }
                this.getView().showErrorNotification(result);
                break;
            }
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addTabSelectListener(this, new String[]{"tabap"});
    }

    public void tabSelected(TabSelectEvent e) {
        String key;
        switch (key = e.getTabKey()) {
            case "deliveryrecordtb": {
                this.loadDeliveryRecordTb();
                break;
            }
            case "completereportpage": {
                this.laodCompletereportpage();
            }
        }
    }

    private boolean isLoaded(String key) {
        return this.getPageCache().get("tab_" + key) != null;
    }

    private void loadDeliveryRecordTb() {
        QFilter filter = new QFilter("sourcebilltype", "=", (Object)"oemorder");
        filter.and("sourcebillid", "=", (Object)this.getId().toString());
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("bbc_order_delivery_list");
        parameter.getOpenStyle().setShowType(ShowType.InContainer);
        parameter.getOpenStyle().setTargetKey(PAGE_DELIVERYRECORDTB);
        parameter.setCustomParam("filterStr", (Object)filter.toSerializedString());
        this.getView().showForm(parameter);
    }

    private void laodCompletereportpage() {
        QFilter filter = new QFilter("sourcebillid", "=", (Object)this.getId().toString());
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("dpa_oemreport_list");
        parameter.getOpenStyle().setShowType(ShowType.InContainer);
        parameter.getOpenStyle().setTargetKey(PAGE_COMPLETEREPORTPAGE);
        parameter.setCustomParam("filterStr", (Object)filter.toSerializedString());
        this.getView().showForm(parameter);
    }
}

