/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dpa.formplugin.bill.saleorder;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.OperationColumn;
import kd.bos.form.control.Vector;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.operatecol.OperationColItem;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.entity.commonfield.CheckBoxField;
import kd.bos.metadata.entity.commonfield.ComboField;
import kd.bos.metadata.entity.commonfield.ComboItem;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.metadata.form.control.LabelAp;
import kd.bos.metadata.form.control.VectorAp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.CodeRuleServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.drp.mdr.common.StringUtils;
import kd.drp.mdr.common.util.EvaluateUtil;
import kd.drp.mdr.common.util.OperationUtil;
import kd.drp.mdr.common.util.UserUtil;
import kd.drp.mdr.formplugin.MdrFormPlugin;
import net.sf.json.JSONArray;

public class OrderEvaluatePlugin
extends MdrFormPlugin {
    private static final String TAG = "tag";
    private static final String LABEL = "label";
    private static final String STAR = "star";
    private static final String EVALTAGFLEX = "evaltagflex";
    private static final String EVALLABELFLEX = "evallabelflex";
    private static final String shixin = "kdfont kdfont-xingxing_shixin";
    private static final String kongxin = "kdfont kdfont-xingxing_xianxing";
    private static final String ENTRYENTITY = "entryentity";
    private static final String PICTUREFILD = "picturefield";
    private static final String PICTUREFILD1 = "picturefield1";
    private static final String PICTUREFILD2 = "picturefield2";
    private static final String PICTUREFILD3 = "picturefield3";
    private static final String PICTUREFILD4 = "picturefield4";
    private DynamicObject order = null;

    private DynamicObject getOrder(FormShowParameter param) {
        if (this.order == null) {
            Object orderId = param.getCustomParam("orderid");
            if (orderId == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5f85\u8bc4\u8bba\u8ba2\u5355ID\u4e3a\u7a7a\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\uff01", (String)"OrderEvaluatePlugin_0", (String)"drp-dpa-formplugin", (Object[])new Object[0]));
            }
            this.order = BusinessDataServiceHelper.loadSingle((Object)orderId, (String)"bbc_saleorder", (String)"owner,billno,totalqty,totalorderamount,itementry.id,itementry.isevaluate,itementry.combitem,itementry.item,itementry.ispresent,itementry.assistattr,itementry.qty,itementry.unit,itementry.assistqty,itementry.assistunit,itementry.actualtaxprice,itementry.taxamount,itementry.entrywarehouse,itementry.entryremark");
            if (this.order == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8ba2\u5355\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\uff01", (String)"OrderEvaluatePlugin_1", (String)"drp-dpa-formplugin", (Object[])new Object[0]));
            }
        }
        return this.order;
    }

    public void createNewData(BizDataEventArgs e) {
        super.createNewData(e);
        DynamicObject order = this.getOrder(this.getView().getFormShowParameter());
        Object ownerId = order.getDynamicObject("owner").get("id");
        DynamicObject owner = order.getDynamicObject("owner");
        Label ownertag = (Label)this.getControl("owner");
        ownertag.setText(owner.getString("name"));
        Label billnotag = (Label)this.getControl("billno");
        billnotag.setText(order.getString("billno"));
        this.addEntryPackageDataListener();
        List tags = EvaluateUtil.getEvaluateTagsByOwnerId((Object)ownerId);
        if (tags == null || tags.isEmpty()) {
            return;
        }
        JSONArray tagids = new JSONArray();
        for (int i = 0; i < tags.size(); ++i) {
            Map tag = (Map)tags.get(i);
            tagids.add((Object)(TAG + tag.get("id")));
        }
        String pageid = this.getView().getPageId();
        this.getPageCache().put(pageid + TAG, tagids.toString());
        List labels = EvaluateUtil.getEvaluateLabelsByOwnerId((Object)ownerId);
        if (labels == null || labels.isEmpty()) {
            return;
        }
        JSONArray labelids = new JSONArray();
        for (int i = 0; i < labels.size(); ++i) {
            Map label = (Map)labels.get(i);
            labelids.add((Object)(LABEL + label.get("id")));
        }
        this.getPageCache().put(pageid + LABEL, labelids.toString());
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        if ("toitemevaluate".equals(e.getActionId())) {
            this.addEntryPackageDataListener();
            DynamicObject order = this.getOrder(this.getView().getFormShowParameter());
            this.initEntryList(order);
            this.getView().updateView(ENTRYENTITY);
        }
    }

    private void addEntryPackageDataListener() {
        EntryGrid entryentity = (EntryGrid)this.getView().getControl(ENTRYENTITY);
        entryentity.addPackageDataListener(evt -> {
            Object formatValue = evt.getFormatValue();
            Object source = evt.getSource();
            DynamicObject rowData = evt.getRowData();
            if (source instanceof OperationColumn) {
                List items = (List)formatValue;
                for (OperationColItem item : items) {
                    String isevaluate = rowData.getString("isevaluate");
                    if (item.getOperationKey().equals("toitemevaluate")) {
                        item.setVisible("0".equals(isevaluate));
                    }
                    if (!item.getOperationKey().equals("viewitemevaluate")) continue;
                    item.setVisible("1".equals(isevaluate));
                }
            }
        });
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        DynamicObject order = this.getOrder(this.getView().getFormShowParameter());
        this.initEntryList(order);
        QFilter qFilter = new QFilter("billnumber", "=", order.get("id"));
        boolean exists = QueryServiceHelper.exists((String)"mdr_bill_evaluate_manage", (QFilter[])qFilter.toArray());
        if (exists) {
            this.getPageCache().put("hasevaluat", "true");
            DynamicObject orderEvaluate = BusinessDataServiceHelper.loadSingle((String)"mdr_bill_evaluate_manage", (String)"id,evaluatecontent,picture1,picture2,picture3,picture4,picture5,evaluatelabels.fbasedataid,evaluatelabels.fbasedataid_id,entryentity.evaluatenumber,entryentity.evaluategrade", (QFilter[])qFilter.toArray());
            this.setValue("evaluatecontent", orderEvaluate.get("evaluatecontent"));
            this.setValue(PICTUREFILD, orderEvaluate.get("picture1"));
            this.setValue(PICTUREFILD1, orderEvaluate.get("picture2"));
            this.setValue(PICTUREFILD2, orderEvaluate.get("picture3"));
            this.setValue(PICTUREFILD3, orderEvaluate.get("picture4"));
            this.setValue(PICTUREFILD4, orderEvaluate.get("picture5"));
            DynamicObjectCollection evaluatelabels = orderEvaluate.getDynamicObjectCollection("evaluatelabels");
            for (Object evaluatelabel : evaluatelabels) {
                Object labelId = evaluatelabel.get("fbasedataid_id");
                Control label = this.getControl(LABEL + labelId);
                if (label == null) continue;
                this.setValue(label.getKey(), Boolean.TRUE);
            }
            DynamicObjectCollection tagsentrys = orderEvaluate.getDynamicObjectCollection(ENTRYENTITY);
            for (DynamicObject tagsentry : tagsentrys) {
                DynamicObject evaluateTag = tagsentry.getDynamicObject("evaluatenumber");
                String tagId = evaluateTag.get("id").toString();
                BigDecimal evaluategrade = tagsentry.getBigDecimal("evaluategrade");
                Control Tag = this.getControl(TAG + tagId);
                if (Tag == null) continue;
                this.setValue(Tag.getKey(), evaluategrade.toString());
                for (int i = 1; i <= 5; ++i) {
                    String starKey = STAR + tagId + "_" + i;
                    Vector v = (Vector)this.getControl(starKey);
                    if (i <= evaluategrade.intValue()) {
                        v.setFontClass(shixin);
                        continue;
                    }
                    v.setFontClass(kongxin);
                }
            }
            this.setDisVisible(new String[]{"bar_submit"});
            this.setUnEnable(new String[]{"evaluatecontent"});
            this.setUnEnable(new String[]{EVALLABELFLEX});
            this.setUnEnable(new String[]{"evalpicflex"});
        } else {
            JSONArray evalTags = this.getEvalTags();
            for (Object tags : evalTags) {
                String id = tags.toString();
                this.setValue(id, "5");
            }
        }
    }

    private void initEntryList(DynamicObject order) {
        this.getModel().deleteEntryData(ENTRYENTITY);
        DynamicObjectCollection itementry = order.getDynamicObjectCollection("itementry");
        this.getModel().batchCreateNewEntryRow(ENTRYENTITY, itementry.size());
        for (int i = 0; i < itementry.size(); ++i) {
            DynamicObject entry = (DynamicObject)itementry.get(i);
            this.setValue("entryid", entry.get("id"), i);
            this.setValue("isevaluate", entry.get("isevaluate"), i);
            this.setValue("combitem", entry.get("combitem"), i);
            this.setValue("item", entry.get("item"), i);
            this.setValue("ispresent", entry.get("ispresent"), i);
            this.setValue("assistattr", entry.get("assistattr"), i);
            this.setValue("qty", entry.get("qty"), i);
            this.setValue("unit", entry.get("unit"), i);
            this.setValue("assistqty", entry.get("assistqty"), i);
            this.setValue("assistunit", entry.get("assistunit"), i);
            this.setValue("actualtaxprice", entry.get("actualtaxprice"), i);
            this.setValue("taxamount", entry.get("taxamount"), i);
            this.setValue("entrywarehouse", entry.get("entrywarehouse"), i);
            this.setValue("entryremark", entry.get("entryremark"), i);
        }
    }

    public void loadCustomControlMetas(LoadCustomControlMetasArgs e) {
        FlexPanelAp labelap;
        super.loadCustomControlMetas(e);
        FormShowParameter showParameter = (FormShowParameter)e.getSource();
        DynamicObject order = this.getOrder(showParameter);
        Object ownerId = order.getDynamicObject("owner").get("id");
        FlexPanelAp tagap = this.createEvalTagsAp(ownerId);
        if (tagap != null) {
            HashMap<String, String> mapHead = new HashMap<String, String>();
            mapHead.put("id", EVALTAGFLEX);
            mapHead.put("items", (String)tagap.createControl().get("items"));
            e.getItems().add(mapHead);
        }
        if ((labelap = this.createEvalLabelsAp(ownerId)) != null) {
            HashMap<String, String> mapHead = new HashMap<String, String>();
            mapHead.put("id", EVALLABELFLEX);
            mapHead.put("items", (String)labelap.createControl().get("items"));
            e.getItems().add(mapHead);
        }
    }

    public void onGetControl(OnGetControlArgs e) {
        FieldEdit fe;
        super.onGetControl(e);
        String key = e.getKey();
        if (key.startsWith(TAG)) {
            ComboEdit co = new ComboEdit();
            co.setKey(key);
            co.setView(this.getView());
            e.setControl((Control)co);
        }
        if (key.startsWith(LABEL)) {
            fe = new FieldEdit();
            fe.setKey(key);
            fe.setView(this.getView());
            e.setControl((Control)fe);
        }
        if (key.startsWith(STAR)) {
            fe = new Vector();
            fe.setKey(key);
            fe.setView(this.getView());
            e.setControl((Control)fe);
            String hasevaluat = this.getPageCache().get("hasevaluat");
            if (StringUtils.isEmpty((String)hasevaluat) || !"true".equals(hasevaluat)) {
                fe.addClickListener((ClickListener)this);
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (key.startsWith(STAR)) {
            String[] split = key.split("_");
            String id = split[0].substring(4, split[0].length());
            Integer index = Integer.valueOf(split[1]);
            this.setValue(TAG + id, index);
            for (int i = 1; i <= 5; ++i) {
                String starKey = STAR + id + "_" + i;
                Vector v = (Vector)this.getControl(starKey);
                if (i <= index) {
                    v.setFontClass(shixin);
                    continue;
                }
                v.setFontClass(kongxin);
            }
        }
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        super.getEntityType(e);
        MainEntityType oldMainType = e.getOriginalEntityType();
        MainEntityType newMainType = null;
        try {
            newMainType = (MainEntityType)oldMainType.clone();
        }
        catch (CloneNotSupportedException exp) {
            throw new KDException((Throwable)exp, new ErrorCode("LoadCustomControlMetasSample", exp.getMessage()), new Object[0]);
        }
        Map fieldmap = newMainType.getAllFields();
        JSONArray tagids = this.getEvalTags();
        for (int i = 0; i < tagids.size(); ++i) {
            String id = tagids.get(i).toString();
            if (fieldmap.get(id) != null) continue;
            ComboProp prop = new ComboProp();
            prop.setName(id);
            prop.setDbIgnore(true);
            prop.setDefaultValue((Object)"5");
            fieldmap.put(id, prop);
            newMainType.registerSimpleProperty((DynamicSimpleProperty)prop);
        }
        JSONArray labelids = this.getEvalLabels();
        for (int i = 0; i < labelids.size(); ++i) {
            String id = (String)labelids.get(i);
            if (fieldmap.get(id) != null) continue;
            BooleanProp prop = new BooleanProp();
            prop.setName(id);
            prop.setDbIgnore(true);
            prop.setDefaultValue((Object)Boolean.TRUE);
            fieldmap.put(id, prop);
            newMainType.registerSimpleProperty((DynamicSimpleProperty)prop);
        }
        e.setNewEntityType(newMainType);
    }

    private JSONArray getEvalTags() {
        String pageid = this.getView().getPageId();
        String labels = this.getPageCache().get(pageid + TAG);
        JSONArray array = new JSONArray();
        if (labels != null) {
            array = JSONArray.fromObject((Object)labels);
        }
        return array;
    }

    private JSONArray getEvalLabels() {
        String pageid = this.getView().getPageId();
        String labels = this.getPageCache().get(pageid + LABEL);
        JSONArray array = new JSONArray();
        if (labels != null) {
            array = JSONArray.fromObject((Object)labels);
        }
        return array;
    }

    private void saveEvalTag(DynamicObject eval) {
        BigDecimal evalutategrade = BigDecimal.ZERO;
        JSONArray tagids = this.getEvalTags();
        if (tagids.isEmpty()) {
            eval.set("evalutategrade", (Object)5);
            return;
        }
        for (int i = 0; i < tagids.size(); ++i) {
            DynamicObject entry = eval.getDynamicObjectCollection(ENTRYENTITY).addNew();
            String number = tagids.get(i).toString();
            entry.set("evaluatenumber", (Object)this.getEvaluateContentById(number.substring(3, number.length())));
            BigDecimal grade = new BigDecimal((String)this.getValue(number));
            evalutategrade = evalutategrade.add(grade);
            entry.set("evaluategrade", (Object)grade);
        }
        if (evalutategrade.compareTo(BigDecimal.ZERO) != 0) {
            evalutategrade = evalutategrade.divide(new BigDecimal(tagids.size()), 0, RoundingMode.HALF_UP);
        }
        eval.set("evalutategrade", (Object)evalutategrade);
    }

    private void saveEvalLabel(DynamicObject eval) {
        JSONArray labelids = this.getEvalLabels();
        if (labelids.isEmpty()) {
            return;
        }
        for (int i = 0; i < labelids.size(); ++i) {
            String number = labelids.getString(i);
            if (!((Boolean)this.getModel().getValue(number)).booleanValue()) continue;
            DynamicObject entry = eval.getDynamicObjectCollection("evaluatelabels").addNew();
            DynamicObject label = this.getEvaluateContentById(number.substring(5, number.length()));
            entry.set("fbasedataid", (Object)label);
            entry.set("fbasedataid_id", label.get("id"));
        }
    }

    private FlexPanelAp createEvalLabelsAp(Object ownerId) {
        List labels = EvaluateUtil.getEvaluateLabelsByOwnerId((Object)ownerId);
        if (labels == null || labels.isEmpty()) {
            return null;
        }
        FlexPanelAp evallabelflex = new FlexPanelAp();
        evallabelflex.setKey("headevallabelflex");
        JSONArray labelids = new JSONArray();
        for (int i = 0; i < labels.size(); ++i) {
            Map label = (Map)labels.get(i);
            FieldAp field = this.createLabelField(label.get("id").toString(), (String)label.get("name"));
            evallabelflex.getItems().add(field);
            labelids.add((Object)(LABEL + label.get("id")));
        }
        return evallabelflex;
    }

    private FieldAp createLabelField(String id, String name) {
        FieldAp field = new FieldAp();
        CheckBoxField co = new CheckBoxField();
        co.setKey(LABEL + id);
        co.setMustInput(true);
        co.setName(new LocaleString(name));
        co.setDefValue(true);
        co.setShowStyle(1);
        field.setId(LABEL + id);
        field.setKey(LABEL + id);
        field.setField((Field)co);
        field.setName(new LocaleString(name));
        field.setLabelDirection("h");
        field.setWidth(new LocaleString("120px"));
        field.setLabelWidth(new LocaleString("120px"));
        field.setComboShowStyle(0);
        field.setComboShowType(0);
        field.setFireUpdEvt(true);
        Style style = new Style();
        Margin margin = new Margin();
        margin.setBottom("0px");
        margin.setLeft("20px");
        style.setMargin(margin);
        field.setStyle(style);
        return field;
    }

    private FlexPanelAp createEvalTagsAp(Object ownerId) {
        List tags = EvaluateUtil.getEvaluateTagsByOwnerId((Object)ownerId);
        if (tags == null || tags.isEmpty()) {
            return null;
        }
        FlexPanelAp evaltagflex = new FlexPanelAp();
        evaltagflex.setKey("headevaltagflex");
        JSONArray tagids = new JSONArray();
        for (int i = 0; i < tags.size(); ++i) {
            Map tag = (Map)tags.get(i);
            FieldAp field = this.createTagField(tag.get("id").toString(), (String)tag.get("name"));
            evaltagflex.getItems().add(field);
            tagids.add((Object)(TAG + tag.get("id")));
            LabelAp label = this.createTagLabel(tag.get("id").toString(), (String)tag.get("name"));
            evaltagflex.getItems().add(label);
            for (int j = 1; j <= 5; ++j) {
                VectorAp v = this.createTagStar(tag.get("id").toString(), (String)tag.get("name"), j);
                evaltagflex.getItems().add(v);
            }
        }
        return evaltagflex;
    }

    private VectorAp createTagStar(String id, String name, int j) {
        VectorAp v = new VectorAp();
        v.setfontClass(shixin);
        v.setId(STAR + id + "_" + j);
        v.setKey(STAR + id + "_" + j);
        v.setClickable(true);
        v.setForeColor("#ffaa56");
        Style style = new Style();
        Margin margin = new Margin();
        margin.setBottom("0px");
        margin.setLeft("3px");
        style.setMargin(margin);
        v.setStyle(style);
        return v;
    }

    private LabelAp createTagLabel(String id, String name) {
        LabelAp Label2 = new LabelAp();
        Label2.setName(new LocaleString(name));
        Label2.setId(LABEL + id);
        Label2.setKey(LABEL + id);
        Style style = new Style();
        Margin margin = new Margin();
        margin.setBottom("0px");
        margin.setLeft("30px");
        margin.setRight("5px");
        style.setMargin(margin);
        Label2.setStyle(style);
        return Label2;
    }

    private FieldAp createTagField(String id, String name) {
        FieldAp field = new FieldAp();
        ComboField co = new ComboField();
        co.setItems(this.buildComboItems());
        co.setKey(TAG + id);
        co.setDefValue("5");
        co.setMustInput(true);
        field.setId(TAG + id);
        field.setKey(TAG + id);
        field.setField((Field)co);
        field.setName(new LocaleString(name));
        field.setLabelDirection("h");
        field.setWidth(new LocaleString("150px"));
        field.setLabelWidth(new LocaleString("160px"));
        field.setComboShowStyle(0);
        field.setComboShowType(0);
        field.setFireUpdEvt(true);
        Style style = new Style();
        Margin margin = new Margin();
        margin.setBottom("0px");
        margin.setLeft("20px");
        style.setMargin(margin);
        field.setStyle(style);
        field.setVisible("");
        return field;
    }

    private List<ComboItem> buildComboItems() {
        ArrayList<ComboItem> list = new ArrayList<ComboItem>(16);
        for (int i = 1; i <= 5; ++i) {
            ComboItem item = new ComboItem();
            String value = String.valueOf(i);
            item.setCaption(new LocaleString(value));
            item.setValue(value);
            list.add(item);
        }
        return list;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        String opKey;
        super.beforeDoOperation(e);
        switch (opKey = this.getOpKey(e)) {
            case "toitemevaluate": {
                this.toItemEvaluate();
                break;
            }
            case "evaluate": {
                this.orderEvaluateSubmit();
                break;
            }
            case "viewitemevaluate": {
                this.toViewEvaluate();
                break;
            }
        }
    }

    private void orderEvaluateSubmit() {
        Object evaluatecontent = this.getValue("evaluatecontent");
        Object picture1 = this.getValue(PICTUREFILD);
        Object picture2 = this.getValue(PICTUREFILD1);
        Object picture3 = this.getValue(PICTUREFILD2);
        Object picture4 = this.getValue(PICTUREFILD3);
        Object picture5 = this.getValue(PICTUREFILD4);
        DynamicObject orderEvaluate = BusinessDataServiceHelper.newDynamicObject((String)"mdr_bill_evaluate_manage");
        DynamicObject saleorder = this.order;
        if (saleorder == null) {
            Object orderId = this.getView().getFormShowParameter().getCustomParam("orderid");
            saleorder = BusinessDataServiceHelper.loadSingle((Object)orderId, (String)"mdr_order_f7", (String)"id,number,totalqty,totalorderamount");
        }
        orderEvaluate.set("billnumber", (Object)saleorder);
        orderEvaluate.set("goodqty", saleorder.get("totalqty"));
        orderEvaluate.set("amount", saleorder.get("totalorderamount"));
        orderEvaluate.set("billstatus", (Object)"A");
        orderEvaluate.set("creator", UserUtil.getUserID());
        orderEvaluate.set("createtime", (Object)new Date());
        orderEvaluate.set("evaluateshoworhide", (Object)"1");
        orderEvaluate.set("evaluatecontent", evaluatecontent);
        this.saveEvalLabel(orderEvaluate);
        this.saveEvalTag(orderEvaluate);
        orderEvaluate.set("evaluatetype", (Object)"0");
        orderEvaluate.set("picture1", picture1);
        orderEvaluate.set("picture2", picture2);
        orderEvaluate.set("picture3", picture3);
        orderEvaluate.set("picture4", picture4);
        orderEvaluate.set("picture5", picture5);
        orderEvaluate.set("replystatus", (Object)"0");
        String number = CodeRuleServiceHelper.getNumber((String)"mdr_bill_evaluate_manage", (DynamicObject)orderEvaluate, null);
        orderEvaluate.set("billno", (Object)number);
        OperationResult invokeOperation = OperationUtil.invokeOperation((DynamicObject)orderEvaluate, (String)"submit");
        if (invokeOperation.isSuccess()) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u63d0\u4ea4\u6210\u529f", (String)"OrderEvaluatePlugin_2", (String)"drp-dpa-formplugin", (Object[])new Object[0]));
            this.getView().close();
        }
    }

    protected DynamicObject getEvaluateContentById(Object id) {
        return BusinessDataServiceHelper.loadSingle((Object)id, (String)"mdr_evaluate_content");
    }

    protected void toItemEvaluate() {
        EntryGrid entry = (EntryGrid)this.getControl(ENTRYENTITY);
        int i = entry.getEntryState().getFocusRow();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("orderid", this.getView().getFormShowParameter().getCustomParam("orderid"));
        map.put("entryid", this.getValue("entryid", i));
        DynamicObject combitem = (DynamicObject)this.getValue("combitem", i);
        map.put("combitem", combitem);
        DynamicObject item = (DynamicObject)this.getValue("item", i);
        if (item == null) {
            return;
        }
        map.put("itemid", item.getPkValue());
        DynamicObject unit = (DynamicObject)this.getValue("unit", i);
        map.put("unitid", unit == null ? Integer.valueOf(0) : unit.getPkValue());
        map.put("qty", this.getValue("qty", i));
        DynamicObject assistattr = (DynamicObject)this.getValue("assistattr", i);
        map.put("attrid", assistattr == null ? Integer.valueOf(0) : assistattr.getPkValue());
        map.put("price", this.getValue("actualtaxprice", i));
        map.put("amount", this.getValue("taxamount", i));
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("bbc_item_evaluate_edit");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "toitemevaluate"));
        parameter.setCustomParams(map);
        this.getView().showForm(parameter);
    }

    protected void toViewEvaluate() {
        EntryGrid entry = (EntryGrid)this.getControl(ENTRYENTITY);
        int i = entry.getEntryState().getFocusRow();
        HashMap<String, Object> map = new HashMap<String, Object>();
        Object evalid = EvaluateUtil.getItemEvaluateIDByEntryId((Object)this.getValue("entryid", i));
        map.put("evalid", evalid);
        map.put("itemid", ((DynamicObject)this.getValue("item", i)).getPkValue());
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("bbc_item_evaluate_edit");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCustomParams(map);
        this.getView().showForm(parameter);
    }
}

