/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dpa.formplugin.bill.saleorder;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.coderule.api.CodeRuleInfo;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.entity.EntryType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.property.EntryProp;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FloatingDirection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Image;
import kd.bos.form.control.events.EntryGridBindDataEvent;
import kd.bos.form.control.events.EntryGridBindDataListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.field.events.BasedataFuzzySearchEvent;
import kd.bos.form.field.events.BasedataFuzzySearchListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.CreateListDataProviderListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.drp.dpa.common.algorithm.SaleOrderAlgorithm;
import kd.drp.mdr.common.ShortMessageUtil;
import kd.drp.mdr.common.StringUtils;
import kd.drp.mdr.common.constants.BigDecimalConstants;
import kd.drp.mdr.common.constants.DiscountModeEnum;
import kd.drp.mdr.common.constants.PayType;
import kd.drp.mdr.common.constants.SaleOrderEntryType;
import kd.drp.mdr.common.f7.F7Utils;
import kd.drp.mdr.common.handler.OrderOperateLogHandler;
import kd.drp.mdr.common.handler.SaleOrderHandler;
import kd.drp.mdr.common.itemcontrol.ItemSaleControlUtil;
import kd.drp.mdr.common.model.CheckResult;
import kd.drp.mdr.common.model.dpm.DetailItemInfo;
import kd.drp.mdr.common.model.dpm.LimitResult;
import kd.drp.mdr.common.model.dpm.LimitResultEntry;
import kd.drp.mdr.common.model.dpm.PromotionApiResult;
import kd.drp.mdr.common.model.dpm.PromotionOrder;
import kd.drp.mdr.common.model.dpm.UsablePromotionResult;
import kd.drp.mdr.common.status.DispatchOrderConfirmStatus;
import kd.drp.mdr.common.status.EnumUtil;
import kd.drp.mdr.common.status.PhoneType;
import kd.drp.mdr.common.status.SaleOrderConfirmStatus;
import kd.drp.mdr.common.status.SaleOrderPayStatus;
import kd.drp.mdr.common.status.SaleOrderStatus;
import kd.drp.mdr.common.status.SaleOrderSyncStatus;
import kd.drp.mdr.common.util.BalanceUtil;
import kd.drp.mdr.common.util.BigDecimalUtil;
import kd.drp.mdr.common.util.BillTypeParameterHelper;
import kd.drp.mdr.common.util.ConsigneeAddressUtil;
import kd.drp.mdr.common.util.CustomerParamsUtil;
import kd.drp.mdr.common.util.CustomerSalerUtil;
import kd.drp.mdr.common.util.CustomerUtil;
import kd.drp.mdr.common.util.DateUtil;
import kd.drp.mdr.common.util.DriverUtil;
import kd.drp.mdr.common.util.DynamicObjectUtils;
import kd.drp.mdr.common.util.ItemAttrUtil;
import kd.drp.mdr.common.util.ItemStoreUtil;
import kd.drp.mdr.common.util.OperationUtil;
import kd.drp.mdr.common.util.OrderQuantityUtil;
import kd.drp.mdr.common.util.PriceUtil;
import kd.drp.mdr.common.util.QueryUtil;
import kd.drp.mdr.common.util.ReceiptUtil;
import kd.drp.mdr.common.util.ReceivingbillUtil;
import kd.drp.mdr.common.util.SaleOrderUtil;
import kd.drp.mdr.common.util.SysParamsUtil;
import kd.drp.mdr.common.util.UserUtil;
import kd.drp.mdr.common.util.ValidateUtils;
import kd.drp.mdr.common.util.WarehouseRuleUtil;
import kd.drp.mdr.common.util.WebUtil;
import kd.drp.mdr.formplugin.MdrBillPlugin;
import kd.drp.mdr.formplugin.MdrFormPlugin;
import kd.drp.mdr.formplugin.template.BeForeF7Template;
import kd.drp.mdr.formplugin.template.FormTemplate;
import kd.drp.mdr.servicehelper.PromotionServiceHelper;

public class PurOrderEditPlugin
extends MdrBillPlugin
implements AfterF7SelectListener,
BeforeF7SelectListener,
TabSelectListener,
BasedataFuzzySearchListener,
EntryGridBindDataListener {
    private static Log logger = LogFactory.getLog(OrgUnitServiceHelper.class);
    private static final String ORDER_NEED_NUM = "orderneednum";
    protected static final String F_easbusinesstype = "biztype";
    protected static final String F_signstatus = "signstatus";
    protected static final String F_saleorderbilltypeid = "saleorderbilltypeid";
    protected static final String F_stockorgid = "stockorgid";
    protected static final String F_stockid = "stockid";
    protected static final String F_localcurrency = "localcurrency";
    protected static final String PAGE_PAYTB = "paytb";
    protected static final String PAGE_PROMOTIONTB = "promotiontb";
    protected static final String PAGE_AVAILABLEPROMOTION = "availablepromotion";
    protected static final String PAGE_DELIVERYRECORDTB = "deliveryrecordtb";
    protected static final String PAGE_VERSIONTB = "versiontb";
    protected static final String PAGE_EVALUATETB = "evaluatetb";
    protected static final String PAGE_OPLOGTB = "oplogtb";
    protected static final String TB_RECEIVE_BILL = "receivebilltb";
    protected static final String TB_DELIVERY_BILL = "deliverybilltb";
    protected static final String TB_EVALUATE = "evaluatetb";
    protected static final String TB_ORDER_VERSION = "orderversiontb";
    protected static final String TB_MAIN = "tbmain";
    protected static final String BAR_MODIFY = "bar_modify";
    protected static final String BAR_UNSUBMIT = "bar_unsubmit";
    protected static final String BAR_SUBMIT = "bar_submit";
    protected static final String BAR_SUBMITANDNEW = "bar_submitandnew";
    protected static final String BAR_AUDIT = "bar_audit";
    protected static final String BAR_DEL = "bar_del";
    protected static final String BAR_PRINT = "bar_print";
    protected static final String BAR_NEW = "bar_new";
    protected static final String BAR_UNAUDIT = "bar_unaudit";
    protected static final String BAR_ENTRY = "bar_entry";
    protected static final String BAR_CLOSEORDER = "bar_closeorder";
    protected static final String BAR_UNCLOSEORDER = "bar_uncloseorder";
    protected static final String CLOSEORDER = "closeorder";
    protected static final String UNCLOSEORDER = "uncloseorder";
    protected static final String BAR_LINE = "bar_line";
    protected static final String ENTRYCLOSE = "entryclose";
    protected static final String ENTRYUNCLOSE = "entryunclose";
    protected static final String PRESENTBAG = "presentbag";
    protected static final String SELECTSUBITEM = "selectsubitem";
    protected static final String TO_DELIVERY = "todelivery";
    protected static final String TO_SIGN = "tosign";
    protected static final String TO_EVALUATE = "toevaluate";
    protected static final String TO_GENERATION = "generation";
    protected static final String TO_CHANGE = "change";
    protected static final String TO_PAY = "topay";
    protected static final String TO_DISPATCHCONFIRM = "dispatchconfirm";
    protected static final String PUSH_DISPATCH_ORDER = "pushdispatchorder";
    protected static final String PUSH_LOGISTIC_SEND = "pushlogisticssend";
    protected static final String SEND_ALLOT_MSG = "sendallotmsg";
    protected static final String SEND_AMOUNT_MSG = "sendamountmsg";
    protected static final String MENU_FLOAT = "floatmenuap";
    protected static final String MENU_OPLOG = "oplogmenu";
    protected static final String MENU_MESSAGE = "messagemenu";
    protected static final String TO_ALLOT = "toallot";
    protected static final String TO_SYNC = "tosync";
    protected static final String CANCEL_SYNC = "cancelsync";
    protected static final String TO_INVALID = "invalid";
    protected static final String TO_VALID = "valid";
    protected static final String RE_FRESH = "refresh";
    protected static final String UNSUBMIT = "unsubmit";
    protected static final String UNAUDIT = "unaudit";
    protected static final String DELETE = "delete";
    protected static final String WITHDRAW = "withdraw";
    protected static final String SAVE = "save";
    private static final String OP_CHECKSAVE = "checksave";
    protected static final String MODIFY = "modify";
    protected static final String SUBMIT = "submit";
    private static final String OP_CHECKSUBMIT = "checksubmit";
    protected static final String AUDIT = "audit";
    protected static final String REFRESH = "refresh";
    protected static final String OP_ADDENTRY = "addentry";
    protected static final String OP_DELENTRY = "delentry";
    protected static final String OP_NEWENTRY = "newentry";
    protected static final String OP_DELETEENTRY = "deleteentry";
    protected static final String CALLBACK_SHOWITEM = "showitem";
    protected static final String CALLBACK_CHOOSEATTR = "chooseattr";
    protected static final String LABEL_BILLNO = "billnolabel";
    protected static final String LABEL_ORDERDATE = "orderdatelable";
    protected static final String LABEL_ARRIVALDATE = "arrivaldatelable";
    protected static final String LABEL_CONFIRMARRIVALDATE = "confirmarrivaldatelable";
    protected static final String LABEL_ORDERREMARK = "orderremarklable";
    protected static final String AP_ENTRYCONSIGNEEHEAD = "entryconsigneehead";
    protected static final String AP_HEADCONSIGNEE = "headconsigneeap";
    protected static final String AP_PAYSTATUSVECTOR = "paystatusvectorap";
    protected static final String BTN_SALER_ALTER = "saler_alter";
    protected static final String BTN_REGION_ALTER = "region_alter";
    protected static final String BTN_OWNER_ALTER = "owner_alter";
    protected static final String BTN_CUSTOMER_ALTER = "customer_alter";
    protected static final String BTN_CONSIGNEEADDRESS_ALTER = "consigneeaddress_alter";
    protected static final String BTN_ASSISTATTR_ALTER = "assistattr_alter";
    protected static final String BTN_RECEIPT_ALTER = "receipt_alter";
    protected static final String BTN_SENDCUSTOMER_ALTER = "sendcustomer_alter";
    protected static final String BTN_RECEIVERCUSTOMER_ALTER = "receivercustomer_alter";
    protected static final String BTN_CONSIGNEECUTOMER_ALTER = "consigneecutomer_alter";
    protected static final String BTN_PAYCUSTOMER_ALTER = "paycustomer_alter";
    protected static final String BTN_REBATEACCOUNTTYPE_ALTER = "rebateaccounttype_alter";
    protected static final String SWITCH_EXECUTION_BTN = "switch_execution_btn";
    protected static final String EXECUTIONS_LIST = "executions_list";
    protected volatile boolean isSpliting = false;
    protected volatile boolean isReSettedPrice = false;
    protected static final String SPLITKEY = "&";
    protected static final String CACHE_KEY_USEWAREHOUSERULE = "cache_key_usewarehouserule";
    protected static final String CACHE_KEY_MAXATTR = "maxAttr";
    protected static final String logoUrl = "images/pc/emotion/No_picture.png";
    protected static final String ITEM_SELECT = "item_select";
    protected static final Long easBusinessType = 322951122669016064L;
    private static final String[] changerQtys = new String[]{"invalidreason", "changer", "changetime", "synctime", "syncuser", "allotdate"};
    private static final String[] alreadyQtys = new String[]{"alreadyreceqty", "alreadyreceamount", "allotenqty", "allotedqty", "deliveredqty", "signedqty"};
    private static final String[] sourceBillTypes = new String[]{"saleorder", "oemorder", "saloutbill"};
    protected volatile boolean isChangeEvent = true;
    private SaleOrderAlgorithm algo = null;
    private static final String[] qtyCols = new String[]{"qty", "alterqty", "assistqty", "alterassistqty", "baseqty", "alterbaseqty"};
    private static final String[] amonutCols = new String[]{"primamount", "discountamount", "itemamount", "promotionamount", "rebateamount", "taxamount", "tax", "amount"};
    private static final String[] localAmonutCols = new String[]{"localtaxamount", "localtax", "localamount"};

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        List ownerIDs = super.getOwnerIDs();
        if (ownerIDs.isEmpty()) {
            e.setCancel(true);
            e.setCancelMessage(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u6682\u65e0\u6240\u5c5e\u6e20\u9053\uff0c\u8bf7\u5148\u521b\u5efa\u6216\u542f\u7528\u6e20\u9053\u7528\u6237", (String)"PurOrderEditPlugin_0", (String)"drp-dpa-formplugin", (Object[])new Object[0]));
        }
    }

    protected boolean isUseWareHouseRule() {
        IPageCache pc = this.getPageCache();
        String value = pc.get(CACHE_KEY_USEWAREHOUSERULE);
        if (StringUtils.isEmpty((String)value)) {
            Boolean useWareHouseRule = SysParamsUtil.isUseWareHouseRule();
            value = useWareHouseRule.toString();
            pc.put(CACHE_KEY_USEWAREHOUSERULE, value);
        }
        return Boolean.parseBoolean(value);
    }

    public void afterCopyData(EventObject e) {
        this.initHeadFromCopy();
        this.initEntryFromCopy();
        this.initPromotionCacheKey();
        this.resetEntryByCusOwner();
        if (this.isReacquirePromotion()) {
            this.initAvailablePromotion();
        }
        this.getAlgorithm().reCalFields();
        this.afterInitNewPresentRowData();
        this.initBalanceInfo();
        this.initUseableAccountInfo();
        this.getAlgorithm().calByUsedRebateChanged();
        this.initNumber();
    }

    protected void initHeadFromCopy() {
        this.initCreatorAndTime();
        this.setValue("orderdate", new Date());
        this.initDefaultArrivalDate();
        this.setValue("confirmstatus", "A");
        this.setValue("isdelete", Boolean.FALSE);
        this.setValue("amountstatus", "A");
        this.setValue("paystatus", "A");
        this.setValue("evaluatestatus", "A");
        this.setValue("sync", "D");
        this.resetHeadValueFromCopy();
        this.setSettleOrg((DynamicObject)this.getModel().getValue("saleorgid"));
        this.setValue("returnbalance", BigDecimal.ZERO);
    }

    private void resetHeadValueFromCopy() {
        for (int j = 0; j < changerQtys.length; ++j) {
            this.setValue(changerQtys[j], null);
        }
    }

    protected void initEntryFromCopy() {
        DynamicObjectCollection itemEntry = this.getModel().getEntryEntity("itementry");
        if (itemEntry == null || itemEntry.size() == 0) {
            return;
        }
        HashSet<Integer> rows = new HashSet<Integer>();
        for (int i = 0; i < itemEntry.size(); ++i) {
            SaleOrderEntryType entryType = this.getEntryType(i);
            if (this.isIspromotional(i)) {
                rows.add(i);
            }
            this.setValue("qty", this.getValue("alterqty", i), i);
            this.setId4RowIfNoId(i);
            this.initNewRowCommonData(i);
            this.newTaxrateSet(i);
            if (entryType == SaleOrderEntryType.COMBINATION) {
                DynamicObject combitem = this.getEntryF7Value("itementry", "combitem", i);
                DynamicObjectCollection itemdetails = combitem.getDynamicObjectCollection("itemdetail");
                String pricemode = combitem.getString("pricemode");
                Object entryId = this.getEntryId(i);
                Object oldCombEntryId = this.getValue("parententryid", i);
                block1: for (int j = 0; j < itemEntry.size(); ++j) {
                    SaleOrderEntryType sonEntryType = this.getEntryType(j);
                    if (sonEntryType != SaleOrderEntryType.COMBINATION_SON) continue;
                    Object sonOldCombEntryId = this.getValue("parententryid", j);
                    if (oldCombEntryId == null || !oldCombEntryId.equals(sonOldCombEntryId)) continue;
                    this.setValue("parententryid", entryId, j);
                    this.setId4RowIfNoId(j);
                    this.initNewRowCommonData(i);
                    this.newTaxrateSet(i);
                    Object combItemEntryId = this.getValue("combitementeryid", j);
                    for (DynamicObject itemdetail : itemdetails) {
                        if (!combItemEntryId.equals(itemdetail.get("id").toString())) continue;
                        BigDecimal entryprice = BigDecimal.ZERO;
                        if ("0".equals(pricemode)) {
                            BigDecimal primprice;
                            entryprice = primprice = this.getAlgorithm().getSysPrice(j);
                            this.setValue("custchangeprice", Boolean.FALSE, j);
                        } else {
                            entryprice = itemdetail.getBigDecimal("price");
                            this.setValue("custchangeprice", Boolean.TRUE, j);
                        }
                        this.setValue("primprice", entryprice, j);
                        continue block1;
                    }
                }
                this.setValue("parententryid", entryId, i);
                this.setCombPrice(i, combitem);
                continue;
            }
            if (entryType == SaleOrderEntryType.COMMON) {
                this.getAlgorithm().resetPrimPrice(i);
                this.setValue("custchangeprice", Boolean.FALSE, i);
            }
            this.itemStoreReSet(i);
            this.resetExecteQty(i);
            this.setValue("isevaluate", "0", i);
            this.getAlgorithm().calPrimAmount(i);
        }
        if (rows.size() > 0) {
            this.deleteEntry(rows);
        }
    }

    private void resetExecteQty(int i) {
        for (int j = 0; j < alreadyQtys.length; ++j) {
            this.setValue(alreadyQtys[j], BigDecimal.ZERO, i);
        }
    }

    protected void initCreatorAndTime() {
        this.setValue("creator", UserUtil.getUserID());
        this.setValue("createtime", new Date());
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{BAR_ENTRY, TB_MAIN, MENU_FLOAT});
        this.addTabSelectListener(this, new String[]{"tabap"});
        this.addFuzzySearchListener(this, new String[]{"entrywarehouse"});
        this.addF7Listener(this, new String[]{"owner", "driver", "customer", "directcustomer", "dispatcher", "saler", "unit", "warehouse", "entryreceivewarehouse", "entrywarehouse", "receipt", "consigneeaddress", "entryconsigneeaddress", "receivablecompany", "item", "assistattr", "sendcustomer", "receivercustomer", "consigneecutomer", "paycustomer", "department", "combitem", "rebateaccounttype", "saleorgid", "settleorgid", F_stockorgid, F_stockid});
        BasedataEdit itemControl = (BasedataEdit)this.getControl("item");
        itemControl.addAfterF7SelectListener((AfterF7SelectListener)this);
        this.addClickListeners(new String[]{BTN_SALER_ALTER, BTN_REGION_ALTER, BTN_OWNER_ALTER, BTN_CUSTOMER_ALTER, BTN_CONSIGNEEADDRESS_ALTER, BTN_ASSISTATTR_ALTER, BTN_RECEIPT_ALTER, SWITCH_EXECUTION_BTN, BTN_SENDCUSTOMER_ALTER, BTN_RECEIVERCUSTOMER_ALTER, BTN_CONSIGNEECUTOMER_ALTER, BTN_PAYCUSTOMER_ALTER, BTN_REBATEACCOUNTTYPE_ALTER});
        this.addExecutionListDataProvider();
    }

    public void initialize() {
        super.initialize();
        EntryGrid entryGrid = (EntryGrid)this.getControl("itementry");
        entryGrid.addDataBindListener((EntryGridBindDataListener)this);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        String key;
        super.beforeDoOperation(e);
        switch (key = ((AbstractOperate)e.getSource()).getOperateKey()) {
            case "addentry": {
                if (this.getOwnerF7PKValue() == null) {
                    e.setCancel(true);
                    this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9500\u552e\u6e20\u9053\uff01", (String)"PurOrderEditPlugin_1", (String)"drp-dpa-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (this.getCustomerF7PKValue() != null) break;
                e.setCancel(true);
                this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8ba2\u8d27\u6e20\u9053\uff01", (String)"PurOrderEditPlugin_2", (String)"drp-dpa-formplugin", (Object[])new Object[0]));
                return;
            }
            case "pushdispatchorder": {
                boolean isDispatch = SysParamsUtil.isDispatch();
                if (isDispatch) break;
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5f00\u542f\u53c2\u6570--\u662f\u5426\u542f\u7528\u5206\u8d27\u6d41\u7a0b", (String)"PurOrderEditPlugin_3", (String)"drp-dpa-formplugin", (Object[])new Object[0]));
            }
            case "invalid": {
                DynamicObject order = this.getModel().getDataEntity(true);
                SaleOrderStatus status = SaleOrderUtil.getOrderStatus((DynamicObject)order);
                if (!SaleOrderStatus.TEMP_SAVE.equals((Object)status)) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u6682\u5b58\u72b6\u6001\u7684\u5355\u636e\u624d\u80fd\u4f5c\u5e9f\uff01", (String)"PurOrderEditPlugin_4", (String)"drp-dpa-formplugin", (Object[])new Object[0]));
                }
                this.showForm("mdr_saleorder_invalid", new HashMap(), new CloseCallBack((IFormPlugin)this, TO_INVALID), ShowType.Modal);
                e.setCancel(true);
                break;
            }
            case "withdraw": {
                FormOperate operate = (FormOperate)e.getSource();
                RefObject afterConfirm = new RefObject();
                if (operate.getOption().tryGetVariableValue("afterconfirm", afterConfirm)) break;
                String opMessage = OrderOperateLogHandler.getOpMessage((String)key);
                HashMap<String, String> param = new HashMap<String, String>();
                if (key.equals(WITHDRAW) && "C".equals(this.getModel().getDataEntity().getString("confirmstatus"))) {
                    opMessage = ResManager.loadKDString((String)"\u8ba2\u5355\u5206\u8d27\u6d88\u606f\u5df2\u786e\u8ba4\uff0c\u786e\u8ba4\u64a4\u9500\u8ba2\u5355\uff1f", (String)"PurOrderEditPlugin_5", (String)"drp-dpa-formplugin", (Object[])new Object[0]);
                }
                param.put("message", opMessage);
                this.showForm("mdr_operate_confirm", param, new CloseCallBack((IFormPlugin)this, key), ShowType.Modal);
                e.setCancel(true);
                break;
            }
            case "checksave": {
                this.orderInventoryCheck(key);
                break;
            }
            case "checksubmit": {
                e.setCancel(true);
                this.orderInventoryCheck(key);
                break;
            }
            case "audit": {
                if (this.checkStatus(key)) break;
                e.setCancel(true);
                break;
            }
            case "save": 
            case "submit": {
                CheckResult result = this.checkNeedNum();
                if (!result.isSuccess()) {
                    this.getView().showMessage(result.getMsg());
                    e.setCancel(true);
                    break;
                }
                if (!this.checkTel()) {
                    e.setCancel(true);
                    break;
                }
                this.checkOrderQuantity(e);
                break;
            }
            case "deleteentry": {
                this.deleteEntry(e);
                break;
            }
            case "entryclose": 
            case "entryunclose": {
                EntryGrid entryGrid = (EntryGrid)this.getView().getControl("itementry");
                int[] selectRows = entryGrid.getSelectRows();
                if (selectRows == null || selectRows.length == 0) {
                    e.setCancel(true);
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u4e2d\u9700\u8981\u64cd\u4f5c\u7684\u5546\u54c1\u5206\u5f55\u3002", (String)"PurOrderEditPlugin_72", (String)"drp-dpa-formplugin", (Object[])new Object[0]));
                    break;
                }
                String entryclosestatus = "1";
                boolean isclose = false;
                if (key.compareTo(ENTRYCLOSE) == 0) {
                    isclose = true;
                    entryclosestatus = "0";
                }
                boolean isCancel = true;
                for (int i : selectRows) {
                    if (entryclosestatus.compareTo(this.getValue("entryclosestatus", i).toString()) == 0) continue;
                    this.setValue("entryclosestatus", entryclosestatus, i);
                    isCancel = false;
                }
                if (isCancel) {
                    e.setCancel(true);
                    String operatename = ResManager.loadKDString((String)"\u5173\u95ed", (String)"PurOrderEditPlugin_73", (String)"drp-dpa-formplugin", (Object[])new Object[0]);
                    if (key.compareTo(ENTRYUNCLOSE) == 0) {
                        operatename = ResManager.loadKDString((String)"\u6b63\u5e38", (String)"PurOrderEditPlugin_74", (String)"drp-dpa-formplugin", (Object[])new Object[0]);
                    }
                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u9009\u4e2d\u5546\u54c1\u5206\u5f55\u72b6\u6001\u5df2\u7ecf\u662f%s\u72b6\u6001\u4e86\uff0c\u65e0\u9700\u518d\u64cd\u4f5c\u3002", (String)"PurOrderEditPlugin_75", (String)"drp-dpa-formplugin", (Object[])new Object[0]), operatename));
                    return;
                }
                boolean isModifyHeader = true;
                if (isclose) {
                    DynamicObject data = this.getModel().getDataEntity(true);
                    DynamicObjectCollection itemEntryCollection = data.getDynamicObjectCollection("itementry");
                    for (DynamicObject itemEntry : itemEntryCollection) {
                        if (entryclosestatus.compareTo(itemEntry.getString("entryclosestatus")) == 0) continue;
                        isModifyHeader = false;
                        break;
                    }
                }
                if (!isModifyHeader) break;
                this.setValue("closestatus", entryclosestatus);
                break;
            }
            case "closeorder": {
                if (this.getStringValue("closestatus").compareTo("0") == 0) {
                    e.setCancel(true);
                    return;
                }
                this.setValue("closestatus", "0");
                break;
            }
            case "uncloseorder": {
                if (this.getStringValue("closestatus").compareTo("1") == 0) {
                    e.setCancel(true);
                    return;
                }
                this.setValue("closestatus", "1");
                break;
            }
            case "presentbag": {
                this.showSeletPresent();
                break;
            }
            case "selectsubitem": {
                this.showSelectSubitem(e);
                break;
            }
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        super.afterDeleteRow(e);
        EntryProp prop = e.getEntryProp();
        if ("itementry".equals(prop.getName())) {
            this.initEntryView();
        }
    }

    public void entryGridBindData(EntryGridBindDataEvent e) {
        super.entryGridBindData(e);
        this.initEntryView();
    }

    private void orderLimitCheck() {
        DynamicObject data = this.getModel().getDataEntity(true);
        PromotionOrder promotionorder = new SaleOrderAlgorithm(data, null, null).buildPromotionOrderWithPresent();
        LimitResult limitResult = PromotionServiceHelper.validateLimitRule((PromotionOrder)promotionorder, (boolean)false);
        StringBuilder stringBuilder = new StringBuilder();
        boolean iserror = false;
        HashSet<Object> ruleids = new HashSet<Object>();
        Object ruleid = null;
        if (!limitResult.isSuccessExecuteLimit()) {
            Map limitResultEntries = limitResult.getLimitResultEntries();
            for (LimitResultEntry limitResultEntry : limitResultEntries.values()) {
                if (limitResultEntry.getExecuteResult()) continue;
                if (!iserror && !limitResultEntry.isactonpolicy()) {
                    iserror = true;
                }
                ruleid = limitResultEntry.getRuleId();
                ruleids.add(ruleid);
                stringBuilder.append(String.format(ResManager.loadKDString((String)"%s\uff0c\u53ef\u7528\u4f59\u91cf\u4e3a%s\u3002", (String)"PurOrderEditPlugin_67", (String)"drp-dpa-formplugin", (Object[])new Object[0]), limitResultEntry.getItemName(), limitResultEntry.getLeftLimitQty().stripTrailingZeros().toPlainString()));
            }
        }
        if (ruleids.size() > 0) {
            StringBuilder strruleids = new StringBuilder();
            for (Object object : ruleids) {
                strruleids.append(object);
                strruleids.append(',');
            }
            this.setValue("operateremark", strruleids.substring(0, strruleids.length() - 1));
        }
        if (stringBuilder.length() > 0) {
            if (iserror) {
                this.getView().showErrorNotification(stringBuilder.toString());
            } else {
                ConfirmCallBackListener callBack = new ConfirmCallBackListener("limitCallBack", (IFormPlugin)this);
                this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u4ee5\u4e0b\u5546\u54c1\u6570\u91cf\u5df2\u8d85\u8fc7\u9650\u5b9a\u6570\u91cf\uff0c\u65e0\u6cd5\u4eab\u53d7\u4fc3\u9500\u653f\u7b56\uff0c\u8bf7\u95ee\u786e\u8ba4\u63d0\u4ea4\uff1f%s", (String)"PurOrderEditPlugin_68", (String)"drp-dpa-formplugin", (Object[])new Object[0]), stringBuilder), MessageBoxOptions.OKCancel, callBack);
            }
        } else {
            this.getView().invokeOperation(SUBMIT);
        }
    }

    private void orderLimitAgainCheck() {
        DynamicObject data = this.getModel().getDataEntity(true);
        PromotionOrder promotionorder = new SaleOrderAlgorithm(data, null, null).buildPromotionOrderWithPresent();
        LimitResult limitResult = PromotionServiceHelper.validateLimitRule((PromotionOrder)promotionorder, (boolean)false);
        StringBuilder stringBuilder = new StringBuilder();
        if (!limitResult.isSuccessExecuteLimit()) {
            Map limitResultEntries = limitResult.getLimitResultEntries();
            for (LimitResultEntry limitResultEntry : limitResultEntries.values()) {
                if (limitResultEntry.getExecuteResult()) continue;
                stringBuilder.append(String.format(ResManager.loadKDString((String)"%s\uff0c\u53ef\u7528\u4f59\u91cf\u4e3a%s\u3002", (String)"PurOrderEditPlugin_67", (String)"drp-dpa-formplugin", (Object[])new Object[0]), limitResultEntry.getItemName(), limitResultEntry.getLeftLimitQty().stripTrailingZeros().toPlainString()));
            }
            if (stringBuilder.length() > 0) {
                this.getView().showErrorNotification(stringBuilder.toString());
            }
        } else {
            this.getView().invokeOperation(SUBMIT);
        }
    }

    private boolean checkStatus(String operatekey) {
        Object saleorderid = this.getId();
        if (saleorderid.equals(0L) || !QueryServiceHelper.exists((String)this.getModelName(), (Object)saleorderid)) {
            return true;
        }
        DynamicObject saleorder = BusinessDataServiceHelper.loadSingle((Object)saleorderid, (String)this.getModelName(), (String)"id,orderstatus");
        String orderstatus = saleorder.getString("orderstatus");
        switch (operatekey) {
            case "checksave": {
                if ("A".equals(orderstatus) || "F".equals(orderstatus)) break;
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53ea\u6709\u6682\u5b58\u3001\u53d8\u66f4\u4e2d\u72b6\u6001\u5355\u636e\u53ef\u4ee5\u4fdd\u5b58\u3002", (String)"PurOrderEditPlugin_76", (String)"drp-dpa-formplugin", (Object[])new Object[0]));
                return false;
            }
            case "checksubmit": {
                if ("A".equals(orderstatus)) break;
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53ea\u6709\u6682\u5b58\u7684\u5355\u636e\u624d\u5141\u8bb8\u63d0\u4ea4\u3002", (String)"PurOrderEditPlugin_77", (String)"drp-dpa-formplugin", (Object[])new Object[0]));
                return false;
            }
            case "audit": {
                if ("B".equals(orderstatus)) break;
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5355\u636e\u72b6\u6001\u5fc5\u987b\u4e3a\u5df2\u63d0\u4ea4\u624d\u80fd\u5ba1\u6838\u3002", (String)"PurOrderEditPlugin_78", (String)"drp-dpa-formplugin", (Object[])new Object[0]));
                return false;
            }
        }
        return true;
    }

    private void orderInventoryCheck(String operatekey) {
        HashMap keyMap = new HashMap();
        DynamicObject data = this.getModel().getDataEntity(true);
        StringBuilder errorInfos = new StringBuilder();
        DynamicObject currentOwner = data.getDynamicObject("owner");
        Object ownerId = currentOwner.get("id");
        String isallow = CustomerParamsUtil.isAllowOver((Object)ownerId);
        if (!isallow.equals("0")) {
            DynamicObjectCollection itemEntryCollection = data.getDynamicObjectCollection("itementry");
            StringBuilder sb = new StringBuilder();
            for (DynamicObject itemEntry : itemEntryCollection) {
                DynamicObject wareHouseVal;
                DynamicObject assistattrVal;
                String entrytype = itemEntry.getString("entrytype");
                if (SaleOrderEntryType.COMBINATION.getFlagStr().equals(entrytype)) continue;
                sb = new StringBuilder();
                Object itemId = null;
                Object unitId = null;
                Object assistattrId = null;
                Object wareHouseId = null;
                String seq = itemEntry.getString("seq");
                DynamicObject itemVal = itemEntry.getDynamicObject("item");
                if (itemVal == null) break;
                itemId = itemVal.get("id");
                sb.append(itemId);
                DynamicObject unitVal = itemEntry.getDynamicObject("unit");
                if (unitVal != null) {
                    unitId = unitVal.get("id");
                    sb.append(unitId);
                }
                if ((assistattrVal = itemEntry.getDynamicObject("assistattr")) != null) {
                    assistattrId = assistattrVal.get("id");
                    sb.append(assistattrId);
                }
                if ((wareHouseVal = itemEntry.getDynamicObject("entrywarehouse")) != null) {
                    wareHouseId = wareHouseVal.get("id");
                    sb.append(wareHouseId);
                }
                int alterqty = itemEntry.getInt("alterqty");
                DynamicObject storeObject = ItemStoreUtil.queryItemStore((Object)ownerId, (Object)itemId, (Object)unitId, (Object)assistattrId, (Object)wareHouseId);
                if (!keyMap.containsKey(sb.toString())) {
                    int qty = storeObject.getInt("qty") - storeObject.getInt("orderqty");
                    LinkedHashMap<String, Integer> map = new LinkedHashMap<String, Integer>();
                    map.put(seq, qty - alterqty);
                    keyMap.put(sb.toString(), map);
                    if (qty >= alterqty) continue;
                    errorInfos.append(seq).append('\u3001');
                    continue;
                }
                LinkedHashMap map = (LinkedHashMap)keyMap.get(sb.toString());
                Map.Entry entry = this.getTail(map);
                int qty = (Integer)entry.getValue();
                map.put(seq, qty - alterqty);
                if (qty >= alterqty) continue;
                if (qty >= 0) {
                    for (String seqKey : map.keySet()) {
                        errorInfos.append(seqKey).append('\u3001');
                    }
                    continue;
                }
                errorInfos.append(seq).append('\u3001');
            }
        }
        if (errorInfos.length() > 0) {
            if (isallow.equals("2")) {
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("submitCallBack", (IFormPlugin)this);
                if (operatekey.equals(OP_CHECKSAVE)) {
                    confirmCallBacks = new ConfirmCallBackListener("saveCallBack", (IFormPlugin)this);
                }
                this.getView().showConfirm(ResManager.loadKDString((String)"\u884c", (String)"PurOrderEditPlugin_6", (String)"drp-dpa-formplugin", (Object[])new Object[0]) + errorInfos.toString().substring(0, errorInfos.toString().length() - 1) + ResManager.loadKDString((String)"\uff1a\u4e0b\u5355\u6570\u91cf\u8d85\u51fa\u5e93\u5b58\u53ef\u7528\u6570\u91cf\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"PurOrderEditPlugin_7", (String)"drp-dpa-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, ConfirmTypes.Save, confirmCallBacks);
            } else {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u884c", (String)"PurOrderEditPlugin_6", (String)"drp-dpa-formplugin", (Object[])new Object[0]) + errorInfos.toString().substring(0, errorInfos.toString().length() - 1) + ResManager.loadKDString((String)"\uff1a\u4e0b\u5355\u6570\u91cf\u8d85\u51fa\u5e93\u5b58\u53ef\u7528\u6570\u91cf\uff01", (String)"PurOrderEditPlugin_8", (String)"drp-dpa-formplugin", (Object[])new Object[0]));
            }
        } else {
            if (!this.checkStatus(operatekey)) {
                return;
            }
            if (operatekey.equals(OP_CHECKSAVE)) {
                this.getView().invokeOperation(SAVE);
            } else {
                this.orderLimitCheck();
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        switch (messageBoxClosedEvent.getCallBackId()) {
            case "saveCallBack": {
                if (messageBoxClosedEvent.getResult().equals((Object)MessageBoxResult.Yes)) {
                    this.getView().invokeOperation(SAVE);
                    break;
                }
                return;
            }
            case "submitCallBack": {
                if (messageBoxClosedEvent.getResult().equals((Object)MessageBoxResult.Yes)) {
                    this.orderLimitCheck();
                    break;
                }
                return;
            }
            case "limitCallBack": {
                if (messageBoxClosedEvent.getResult().equals((Object)MessageBoxResult.Yes)) {
                    this.refreshModelByPromotionOrder();
                    this.orderLimitAgainCheck();
                    break;
                }
                return;
            }
        }
    }

    protected void refreshModelByPromotionOrder() {
        DynamicObject data = this.getModel().getDataEntity(true);
        String strruleids = data.getString("operateremark");
        HashSet<Object> promotionpolicyids = new HashSet<Object>();
        Object policyid = null;
        HashSet<Object> policyids = new HashSet<Object>();
        DynamicObjectCollection results = QueryServiceHelper.query((String)"dpm_limit", (String)"id,policy.promotionpolicy", (QFilter[])new QFilter("id", "in", (Object)strruleids.split(",")).toArray());
        for (DynamicObject limit : results) {
            promotionpolicyids.add(limit.get("policy.promotionpolicy"));
        }
        PromotionApiResult ctx = null;
        String cachekey = data.getString("promotioncachekey");
        if (cachekey.isEmpty()) {
            long orderid = (Long)data.getPkValue();
            ctx = PromotionServiceHelper.getPromotionResult((Long)orderid);
        } else {
            ctx = PromotionServiceHelper.getPromotionResult((String)cachekey);
        }
        List executions = ctx.getExecutions();
        HashSet<Integer> rows = new HashSet<Integer>();
        HashSet<Object> strEntryids = new HashSet<Object>();
        StringBuilder stringBuilder = new StringBuilder();
        if (executions != null && !executions.isEmpty()) {
            DynamicObjectCollection entryentity = null;
            String type = "";
            Object entryid = null;
            DynamicObjectCollection entrycol = this.getAlgorithm().getEntry();
            BigDecimal sumamountdiff = BigDecimal.ZERO;
            BigDecimal amountdiff = BigDecimal.ZERO;
            BigDecimal pricediff = BigDecimal.ZERO;
            for (DynamicObject execution : executions) {
                policyid = execution.getDynamicObject("policy").getPkValue();
                if (policyid == null || !promotionpolicyids.contains(policyid)) continue;
                policyids.add(policyid);
                entryentity = execution.getDynamicObjectCollection("entryentity");
                if (entryentity == null || entryentity.isEmpty()) continue;
                block2: for (DynamicObject entry : entryentity) {
                    type = entry.getString("type");
                    if (type.compareTo("orderdiff") == 0) {
                        sumamountdiff = sumamountdiff.add(entry.getBigDecimal("amountdiff"));
                        continue;
                    }
                    entryid = entry.get("entryid");
                    if (entryid == null) continue;
                    for (int i = 0; i < entrycol.size(); ++i) {
                        DynamicObject entryc = (DynamicObject)entrycol.get(i);
                        if (!entryc.getPkValue().equals(entryid)) continue;
                        if (type.compareTo("addpresent") == 0) {
                            rows.add(i);
                            stringBuilder.append(entry.get("sourceentryids"));
                            stringBuilder.append(',');
                            continue block2;
                        }
                        amountdiff = entry.getBigDecimal("amountdiff");
                        pricediff = entry.getBigDecimal("pricediff");
                        if (pricediff.compareTo(BigDecimal.ZERO) < 0) {
                            amountdiff = amountdiff.add(pricediff.multiply(entryc.getBigDecimal("qty")));
                        }
                        if (amountdiff.compareTo(BigDecimal.ZERO) < 0) {
                            BigDecimal promotionamount = entryc.getBigDecimal("promotionamount");
                            this.setValue("promotionamount", promotionamount.subtract(amountdiff), i);
                        }
                        strEntryids.add(entryid);
                        continue block2;
                    }
                }
            }
            if (rows != null && rows.size() > 0) {
                this.deleteEntry(rows);
            }
            if (sumamountdiff.compareTo(BigDecimal.ZERO) < 0) {
                BigDecimal totalitemamount = data.getBigDecimal("totalitemamount");
                BigDecimal itemamount = BigDecimal.ZERO;
                BigDecimal promotionamount = BigDecimal.ZERO;
                BigDecimal amount = BigDecimal.ZERO;
                BigDecimal sumamount = BigDecimal.ZERO;
                ArrayList<Integer> indexs = new ArrayList<Integer>();
                DynamicObject entryc = null;
                for (int i = 0; i < entrycol.size(); ++i) {
                    entryc = (DynamicObject)entrycol.get(i);
                    if (entryc.getBoolean("ispresent")) continue;
                    indexs.add(i);
                }
                Integer integer = 0;
                for (int j = 0; j < indexs.size(); ++j) {
                    integer = (Integer)indexs.get(j);
                    entryc = (DynamicObject)entrycol.get(integer.intValue());
                    if (j == indexs.size() - 1) {
                        promotionamount = entryc.getBigDecimal("promotionamount");
                        amount = promotionamount.subtract(sumamountdiff.add(sumamount));
                    } else if (totalitemamount.compareTo(BigDecimal.ZERO) > 0) {
                        itemamount = entryc.getBigDecimal("itemamount");
                        amountdiff = sumamountdiff.multiply(itemamount).divide(totalitemamount, 2, RoundingMode.HALF_UP);
                        promotionamount = entryc.getBigDecimal("promotionamount");
                        amount = promotionamount.subtract(amountdiff);
                        if (amount.compareTo(itemamount) > 0) {
                            amount = itemamount;
                        }
                        sumamount = sumamount.add(amount.subtract(promotionamount));
                    }
                    this.setValue("promotionamount", amount, integer);
                    if (strEntryids.contains(entryid)) continue;
                    strEntryids.add(entryc.getPkValue());
                }
            }
            if (strEntryids.size() > 0 || stringBuilder.length() > 0) {
                String entryids = stringBuilder.toString();
                for (int i = 0; i < entrycol.size(); ++i) {
                    Object pkid = ((DynamicObject)entrycol.get(i)).getPkValue();
                    if (!strEntryids.contains(pkid) && !entryids.contains(pkid.toString())) continue;
                    this.setValue("limitentryid", 1L, i);
                }
            }
            this.getAlgorithm().calAfterExecutePromotion();
        }
        if (!cachekey.isEmpty() && policyids.size() > 0) {
            PromotionServiceHelper.removeContextFromPolicy((String)cachekey, policyids);
        }
    }

    public <K, V> Map.Entry<K, V> getTail(LinkedHashMap<K, V> map) {
        Iterator<Map.Entry<K, V>> iterator = map.entrySet().iterator();
        Map.Entry<K, V> tail = null;
        while (iterator.hasNext()) {
            tail = iterator.next();
        }
        return tail;
    }

    private CheckResult checkNeedNum() {
        int count = this.getModel().getEntryRowCount("itementry");
        DynamicObject rowInfo = null;
        for (int i = 0; i < count; ++i) {
            rowInfo = this.getRowInfo("itementry", i);
            if (rowInfo.getBigDecimal("qty").compareTo(rowInfo.getBigDecimal(ORDER_NEED_NUM)) >= 0) continue;
            return CheckResult.returnFalse((String)(ResManager.loadKDString((String)"\u7b2c", (String)"PurOrderEditPlugin_9", (String)"drp-dpa-formplugin", (Object[])new Object[0]) + (i + 1) + ResManager.loadKDString((String)"\u884c\u5206\u5f55\uff1a\u9700\u751f\u4ea7\u6570\u91cf\u4e0d\u80fd\u5927\u4e8e\u786e\u8ba4\u6570\u91cf", (String)"PurOrderEditPlugin_10", (String)"drp-dpa-formplugin", (Object[])new Object[0])));
        }
        return CheckResult.returnTrue();
    }

    protected void doWhenOrderQuantityFailed(BeforeDoOperationEventArgs e, String errorMsg) {
        if (this.isOrderQuantityStrongControl()) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25:", (String)"PurOrderEditPlugin_11", (String)"drp-dpa-formplugin", (Object[])new Object[0]) + errorMsg);
            e.setCancel(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String key = e.getOperateKey();
        if (this.getOperationResult(e)) {
            switch (key) {
                case "topay": {
                    this.toPayPage();
                    break;
                }
                case "toallot": {
                    this.toAllotPage();
                    break;
                }
                case "todelivery": {
                    this.toDeliveryPage();
                    break;
                }
                case "tosign": {
                    this.toSignPage();
                    break;
                }
                case "toevaluate": {
                    this.toEvaluate();
                    break;
                }
                case "generation": {
                    this.toGeneration();
                    break;
                }
                case "pushdispatchorder": {
                    Object saleorderid = this.getId();
                    ArrayList<QFilter> tbFilters = new ArrayList<QFilter>();
                    tbFilters.add(new QFilter("itementry.sourcebillid", "=", (Object)saleorderid.toString()));
                    ListFilterParameter filter = new ListFilterParameter();
                    filter.setQFilters(tbFilters);
                    this.toDispatchOrder(filter);
                    break;
                }
                case "pushlogisticssend": {
                    this.toLogisticsSend();
                    break;
                }
                case "sendallotmsg": {
                    this.sendAllotMsg();
                    break;
                }
                case "sendamountmsg": {
                    this.sendAmountMsg();
                    break;
                }
                case "change": {
                    this.refreshPage();
                    break;
                }
                case "refresh": {
                    this.refreshPage();
                    this.getPageCache().put("refresh", "1");
                    this.loadDeliveryRecordTb();
                    break;
                }
                case "dispatchconfirm": {
                    Object id = this.getId();
                    String confirmstatus = this.getModel().getDataEntity().getString("confirmstatus");
                    if (!SaleOrderConfirmStatus.ALLOTSENDED.getFlagStr().equals(confirmstatus)) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u9500\u552e\u8ba2\u5355\u786e\u8ba4\u72b6\u6001\u4e0d\u4e3a\u5206\u8d27\u5f85\u786e\u8ba4\uff0c\u4e0d\u9700\u8981\u786e\u8ba4\uff01", (String)"PurOrderEditPlugin_12", (String)"drp-dpa-formplugin", (Object[])new Object[0]));
                    }
                    DynamicObject dispatchOrder = BusinessDataServiceHelper.newDynamicObject((String)"mdr_dispatch_confirm");
                    dispatchOrder.set("billid", id);
                    dispatchOrder.set("remark", (Object)ResManager.loadKDString((String)"\u624b\u52a8\u786e\u8ba4\uff01", (String)"PurOrderEditPlugin_13", (String)"drp-dpa-formplugin", (Object[])new Object[0]));
                    dispatchOrder.set("ordertype", (Object)"dispatchorder");
                    OperationUtil.invokeOperation((DynamicObject)dispatchOrder, (String)SAVE);
                    break;
                }
                case "addentry": {
                    DynamicObjectCollection itemEntry = this.getModel().getEntryEntity("itementry");
                    if (itemEntry == null || itemEntry.size() == 0) {
                        return;
                    }
                    for (int i = 0; i < itemEntry.size(); ++i) {
                        this.setEnableByIsAllowAddPresent(i);
                    }
                    break;
                }
            }
            switch (key) {
                case "save": {
                    String cachekey = this.getStringValue("usablepromotioncachekey");
                    this.refreshPage();
                    if (!this.isReacquirePromotion()) break;
                    if (!StringUtils.isEmpty((String)cachekey)) {
                        this.setValue("usablepromotioncachekey", cachekey);
                        this.getModel().setDataChanged(false);
                    }
                    this.initAvailablePromotion();
                    break;
                }
                case "submit": {
                    break;
                }
                case "unsubmit": 
                case "audit": 
                case "unaudit": {
                    this.refreshPage();
                    break;
                }
                case "closeorder": 
                case "uncloseorder": 
                case "entryclose": 
                case "entryunclose": {
                    this.refreshPage();
                    break;
                }
            }
        } else {
            switch (key) {
                case "submit": {
                    if (!this.isNewCreate()) {
                        DynamicObject order = BusinessDataServiceHelper.loadSingle((Object)this.getId(), (String)this.getModelName(), (String)"orderstatus");
                        String orderstatus = order.getString("orderstatus");
                        if (orderstatus.compareTo(SaleOrderStatus.TEMP_SAVE.getFlagStr()) == 0) {
                            PromotionServiceHelper.rollbackLimit((Object)this.getId(), (boolean)true);
                        }
                        this.setValue("orderstatus", orderstatus);
                        break;
                    }
                    this.setValue("orderstatus", SaleOrderStatus.TEMP_SAVE.getFlagStr());
                    break;
                }
                case "save": 
                case "audit": {
                    if (!this.isNewCreate()) {
                        DynamicObject order = BusinessDataServiceHelper.loadSingle((Object)this.getId(), (String)this.getModelName(), (String)"orderstatus");
                        this.setValue("orderstatus", order.get("orderstatus"));
                        break;
                    }
                    this.setValue("orderstatus", SaleOrderStatus.TEMP_SAVE.getFlagStr());
                    break;
                }
            }
        }
        if (SUBMIT.equals(key) || AUDIT.equals(key) && SysParamsUtil.isAuditThenSync() || TO_SYNC.equals(key) || CANCEL_SYNC.equals(key)) {
            this.refreshPage();
        }
    }

    protected void sendAllotMsg() {
        if (!SysParamsUtil.isDispatch() || !SysParamsUtil.isNeedConfirmAfterAllot()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8ba2\u5355\u5206\u8d27\u6d41\u7a0b\u6216\u5ba2\u6237\u786e\u8ba4 \u53c2\u6570\u672a\u5f00\u542f", (String)"PurOrderEditPlugin_14", (String)"drp-dpa-formplugin", (Object[])new Object[0]));
        }
        Object saleorderid = this.getId();
        DynamicObject saleorder = BusinessDataServiceHelper.loadSingle((Object)saleorderid, (String)this.getModelName());
        saleorder.set("confirmstatus", (Object)SaleOrderConfirmStatus.ALLOTSENDED.getFlagStr());
        SaleOrderUtil.unWriteDispatchOrderConfirmStatus((Object)saleorderid, (String)DispatchOrderConfirmStatus.ALLOTSENDED.getFlagStr());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{saleorder});
        ShortMessageUtil.sendDispatchOrderMsg((Object)saleorderid);
    }

    protected void sendAmountMsg() {
        if (!SysParamsUtil.isNeedConfirmOrderAmount()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8ba2\u5355\u5e94\u6536\u662f\u5426\u9700\u8981\u5ba2\u6237\u786e\u8ba4 \u53c2\u6570\u672a\u5f00\u542f", (String)"PurOrderEditPlugin_15", (String)"drp-dpa-formplugin", (Object[])new Object[0]));
        }
        Object saleorderid = this.getId();
        DynamicObject saleorder = BusinessDataServiceHelper.loadSingle((Object)saleorderid, (String)this.getModelName(), (String)"id,confirmstatus");
        saleorder.set("confirmstatus", (Object)SaleOrderConfirmStatus.AMOUNTSENDED.getFlagStr());
        SaleOrderUtil.unWriteDispatchOrderConfirmStatus((Object)saleorderid, (String)DispatchOrderConfirmStatus.AMOUNTSENDED.getFlagStr());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{saleorder});
        ShortMessageUtil.sendAmountOrderMsg((Object)saleorderid);
    }

    private void toAllotPage() {
        Object id = this.getId();
        String operation = "allot";
        String pageId = this.getExsistPage(id, operation);
        IFormView View = this.getView().getParentView();
        IFormView childView = View.getView(pageId);
        if (childView != null) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8be5\u9500\u552e\u8ba2\u5355\u5206\u914d\u9875\u9762\u5df2\u6253\u5f00\uff01", (String)"PurOrderEditPlugin_16", (String)"drp-dpa-formplugin", (Object[])new Object[0]));
            return;
        }
        BillShowParameter parameter = new BillShowParameter();
        parameter.setFormId("mdr_allot_order");
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.getOpenStyle().setTargetKey(TO_ALLOT);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "refresh"));
        parameter.setCustomParam("orderid", id);
        this.getView().showForm((FormShowParameter)parameter);
        pageId = parameter.getPageId();
        this.cachePageId(id, pageId, operation);
    }

    private String getExsistPage(Object pk, String operation) {
        String key = "exsistPage" + operation + pk;
        return this.getPageCache().get(key);
    }

    private void cachePageId(Object pk, String pageId, String operation) {
        String key = "exsistPage" + operation + pk;
        this.getPageCache().put(key, pageId);
    }

    private void toDispatchOrder(ListFilterParameter filter) {
        ListShowParameter parameter = new ListShowParameter();
        parameter.setFormId("bos_list");
        parameter.setBillFormId("mdr_dispatch_order");
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.setListFilterParameter(filter);
        this.getView().showForm((FormShowParameter)parameter);
    }

    private void toLogisticsSend() {
        Object saleorderid = this.getId();
        SaleOrderStatus status = SaleOrderUtil.getOrderStatus((DynamicObject)this.getModel().getDataEntity());
        List afterDispatchStatus = SaleOrderHandler.getAfterDispatchStatus();
        if (!afterDispatchStatus.contains(status.getFlagStr())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u975e\u5df2\u5206\u8d27\u53ca\u4ee5\u540e\u7684\u72b6\u6001\u8ba2\u5355\u4e0d\u80fd\u751f\u6210\u6d3e\u8f66\u5355\u3002", (String)"PurOrderEditPlugin_17", (String)"drp-dpa-formplugin", (Object[])new Object[0]));
        }
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("mdr_logistics_send");
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.setCustomParam("orderid", saleorderid);
        this.getView().showForm(parameter);
    }

    private void toGeneration() {
        Object orderId = this.getId();
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("mdr_money_debt");
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.setCustomParam("orderid", orderId);
        this.getView().showForm(parameter);
    }

    private void toEvaluate() {
        Object orderId = this.getId();
        if (orderId == null) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u8ba2\u5355\uff01", (String)"PurOrderEditPlugin_18", (String)"drp-dpa-formplugin", (Object[])new Object[0]));
            return;
        }
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("mdr_order_evaluate_op");
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.getOpenStyle().setTargetKey(TO_EVALUATE);
        parameter.setCustomParam("orderid", orderId);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "evaluatetb"));
        this.getView().showForm(parameter);
    }

    private void toSignPage() {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("mdr_delivery_sign");
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.getOpenStyle().setTargetKey(TO_SIGN);
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(this.getId());
        parameter.setCustomParam("orderList", list);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, PAGE_DELIVERYRECORDTB));
        this.getView().showForm(parameter);
    }

    protected void toDeliveryPage() {
        throw new KDBizException(ResManager.loadKDString((String)"\u8981\u8d27\u65b9\u6682\u4e0d\u5141\u8bb8\u53d1\u8d27", (String)"PurOrderEditPlugin_19", (String)"drp-dpa-formplugin", (Object[])new Object[0]));
    }

    protected void toPayPage() {
        throw new KDBizException(ResManager.loadKDString((String)"\u8981\u8d27\u65b9\u6682\u4e0d\u80fd\u652f\u6301\u4ed8\u6b3e", (String)"PurOrderEditPlugin_20", (String)"drp-dpa-formplugin", (Object[])new Object[0]));
    }

    private void copyHeadInfo(int index) {
        this.copyHeadDateInfo(index);
        Object address = this.getF7PKValue("consigneeaddress");
        this.setRowValue("entryconsigneeaddress", address, index);
        this.setEntryConsigneeInfo(index);
    }

    private void copyHeadDateInfo(int index) {
        Date arrivalDate = this.getDateFieldValue("arrivaldate");
        Date confirmarrivaldate = this.getDateFieldValue("confirmarrivaldate");
        this.setRowValue("entryarrivaldate", arrivalDate, index);
        this.setRowValue("entryconfirmarrivaldate", confirmarrivaldate, index);
    }

    private void setEntryWareHouse(int index) {
        Object wareHouse = WarehouseRuleUtil.getWarehouse((Object)this.getOwnerF7PKValue(), (Object)this.getCustomerF7PKValue(), (Object)this.getEntryF7PKValue("itementry", "item", index));
        this.setRowValue("entrywarehouse", wareHouse, index);
    }

    public void afterBindData(EventObject e) {
        boolean isTempSave;
        super.afterBindData(e);
        DynamicObject order = this.getModel().getDataEntity(true);
        if (!this.isReSettedPrice && this.isEdit()) {
            if (SysParamsUtil.isTempOrderResetPrice() && SaleOrderUtil.isThisStatus((DynamicObject)order, (SaleOrderStatus)SaleOrderStatus.TEMP_SAVE)) {
                IDataModel model = this.getModel();
                int count = model.getEntryRowCount("itementry");
                for (int i = 0; i < count; ++i) {
                    this.getAlgorithm().calByResetPrimPrice(i, false);
                }
                this.afterInitNewPresentRowData();
                this.getAlgorithm().calTotalFields();
            }
            this.isReSettedPrice = true;
        }
        if (SaleOrderUtil.isThisStatus((DynamicObject)order, (SaleOrderStatus)SaleOrderStatus.CHANGING)) {
            int count = this.getModel().getEntryRowCount("itementry");
            for (int i = 0; i < count; ++i) {
                this.setUnEnable(i, new String[]{"item"});
            }
            this.setUnEnable(new String[]{"rebatenfo"});
        }
        if (!(isTempSave = SaleOrderUtil.isThisStatus((DynamicObject)order, (SaleOrderStatus)SaleOrderStatus.TEMP_SAVE))) {
            this.setUnEnable(new String[]{"owner", "customer", "isusebalance"});
        }
        if (SysParamsUtil.isUsePromotion()) {
            this.initPromotionCacheKey();
        }
        this.initShowAp();
        this.initBalanceInfo();
        if (isTempSave) {
            this.initUseableAccountInfo();
        }
        this.getView().setVisible(Boolean.valueOf(isTempSave), new String[]{"rebatebalance"});
        this.getView().setEnable(Boolean.valueOf(isTempSave), new String[]{"isusebalance"});
    }

    private void setRebateStatus(boolean isCreateNew) {
        boolean idUseRebate = SysParamsUtil.isUseRebate();
        if (isCreateNew) {
            this.setValue("canuserebate", idUseRebate);
        }
        if (idUseRebate) {
            this.setVisible(new String[]{"rebateflexpanelap"});
            this.getPageCache().put("userebate", "true");
        } else {
            this.setDisVisible(new String[]{"rebateflexpanelap"});
            this.getPageCache().put("userebate", "false");
        }
        this.setMoneyPanelAp();
    }

    private void setMoneyPanelAp() {
        String userebate = this.getPageCache().get("userebate");
        String usebalance = this.getPageCache().get("usebalance");
        if ("true".equals(usebalance) || "true".equals(userebate)) {
            this.setVisible(new String[]{"moneypanelap"});
            if ("true".equals(usebalance) && !"true".equals(userebate)) {
                this.setDisVisible(new String[]{"moneylit1"});
            }
        } else {
            this.setDisVisible(new String[]{"moneypanelap"});
        }
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        this.loadPromotionCache();
        this.initBalanceInfo();
        this.setRebateStatus(false);
        this.setMustInput("billtypeid", false);
    }

    private void loadPromotionCache() {
        Object orderPk;
        if (SysParamsUtil.isUsePromotion() && (orderPk = this.getId()) != null && !orderPk.equals(0L)) {
            PromotionApiResult result = PromotionServiceHelper.getPromotionResult((Long)((Long)orderPk));
            this.initPresentBagButton(result.getExecutions());
            this.setValue("promotioncachekey", result.getCachekey());
        }
    }

    protected void initOrderStatus() {
        this.setValue("orderstatus", SaleOrderStatus.TEMP_SAVE.getFlagStr());
    }

    protected void initBizType() {
        QFilter q = new QFilter("enable", "=", (Object)"1");
        q.and("status", "=", (Object)"C");
        DynamicObjectCollection bizTypes = QueryServiceHelper.query((String)"mdr_biztype", (String)"id", (QFilter[])q.toArray(), (String)"isdefault desc");
        if (bizTypes != null && bizTypes.size() > 0) {
            this.setValue(F_easbusinesstype, ((DynamicObject)bizTypes.get(0)).get("id"));
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initNumber();
        if (!this.isFromImport()) {
            this.initDefaultValues();
            this.setBillParameters();
        }
        this.setCurrencyByCustomer();
    }

    protected final void setCurrencyByCustomer() {
        DynamicObject customer = this.getModel().getDataEntity().getDynamicObject("customer");
        if (null != customer) {
            this.getModel().setItemValueByID("currency", (Object)customer.getLong("currency.id"));
        } else {
            this.setValue("currency", null);
        }
    }

    protected final void setCurrencyByCustomer(Object newCustomer) {
        if (newCustomer instanceof DynamicObject) {
            this.getModel().setItemValueByID("currency", (Object)((DynamicObject)newCustomer).getLong("currency.id"));
        } else {
            this.setCurrencyByCustomer();
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        EntryProp prop = e.getEntryProp();
        if ("itementry".equals(prop.getName())) {
            this.initEntryView();
            for (RowDataEntity rowDataEntity : e.getRowDataEntities()) {
                int rowIndex = rowDataEntity.getRowIndex();
                Object item = this.getValue("item", rowIndex);
                if (null != item) continue;
                this.afterInitNewRowData(rowIndex);
                this.setEnableByIsAllowAddPresent(rowIndex);
            }
        }
    }

    private void setEntryStockInfo() {
        Object saleOrg = this.getModel().getValue("saleorgid");
        DynamicObjectCollection entities = this.getModel().getEntryEntity("itementry");
        for (DynamicObject entity : entities) {
            Object delegation = entity.get(F_stockorgid);
            if (null != delegation) continue;
            entity.set(F_stockorgid, saleOrg);
        }
    }

    protected void initNumber() {
        DynamicObject obj = this.getModel().getDataEntity();
        obj.set("createtime", (Object)new Date());
        obj.set("orderdate", (Object)new Date());
        CodeRuleInfo codeRuleInfo = CodeRuleServiceHelper.getCodeRule((String)obj.getDataEntityType().getName(), (DynamicObject)obj, null);
        String number = "";
        this.getModel().setValue("billno", (Object)number);
        this.setEnable(new String[]{"billno"});
        if (codeRuleInfo != null) {
            try {
                number = CodeRuleServiceHelper.getNumber((CodeRuleInfo)codeRuleInfo, (DynamicObject)obj);
            }
            catch (KDException e) {
                this.getView().showErrorNotification(e.getLocalizedMessage());
            }
            if (!StringUtils.isEmpty((String)number)) {
                this.getModel().setValue("billno", (Object)number);
                this.setEnable(new String[]{"billno"});
            }
        } else {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u8981\u8d27\u7533\u8bf7\u7684\u201c\u7f16\u7801\u89c4\u5219\u201d", (String)"PurOrderEditPlugin_85", (String)"drp-dpa-formplugin", (Object[])new Object[0]));
        }
    }

    private void initDefaultValues() {
        this.initBizType();
        FormShowParameter fsp = this.getView().getFormShowParameter();
        Object ownerId = fsp.getCustomParam("ownerId");
        Object customerId = fsp.getCustomParam("customerId");
        List cartList = (List)fsp.getCustomParam("cartList");
        if (ownerId != null && customerId != null && cartList != null) {
            this.fromShoppingCart(ownerId, customerId, cartList);
        } else {
            this.directOrder();
        }
        this.recalBalance();
        this.initRebateInfo();
        this.getAlgorithm().calByUsedRebateChanged();
        this.setSaleOrg();
    }

    protected void initRebateInfo() {
        this.setRebateStatus(true);
        if (this.getBooleanValue("canuserebate")) {
            FormTemplate.initAccountType((MdrFormPlugin)this, (String)"rebateaccounttype");
        }
        this.initUseableAccountInfo();
    }

    protected void initBalanceInfo() {
        boolean isUseBalance = (Boolean)this.getModel().getValue("isusebalance");
        this.initUseAbleBalance();
        if (this.isView()) {
            if (!isUseBalance) {
                this.setDisVisible(new String[]{"usablebalance", "usedbalance", "usablebalancelabel", "usedbalancelabel"});
                this.getPageCache().put("usebalance", "fasle");
            }
        } else {
            if (this.isNewCreate()) {
                Object ownerPK = this.getOwnerF7PKValue();
                Object customerPK = this.getCustomerF7PKValue();
                if (ownerPK == null || customerPK == null) {
                    this.setValue("isusebalance", Boolean.FALSE);
                    this.setDisVisible(new String[]{"balanceinfopanelap"});
                    this.getPageCache().put("usebalance", "fasle");
                } else {
                    DynamicObject balanceInfo = BalanceUtil.getBalanceInfo((Object)ownerPK, (Object)customerPK, (boolean)false);
                    BigDecimal usable = ZERO;
                    if (balanceInfo != null) {
                        usable = balanceInfo.getBigDecimal("usable");
                    }
                    this.setValue("isusebalance", Boolean.TRUE);
                    this.setVisible(new String[]{"balanceinfopanelap", "isusebalance", "usedbalance", "usedbalance"});
                    this.getPageCache().put("usebalance", "true");
                }
            }
            this.recalBalance();
        }
        this.setMoneyPanelAp();
    }

    protected void initUseAbleBalance() {
        DynamicObject balanceInfo;
        BigDecimal usedBalance;
        Object ownerPK = this.getOwnerF7PKValue();
        Object customerPK = this.getCustomerF7PKValue();
        if (ownerPK == null || customerPK == null) {
            return;
        }
        if (!this.isNewCreate()) {
            Object orderPk = this.getId();
            DynamicObject saleorder = BusinessDataServiceHelper.loadSingle((Object)orderPk, (String)this.getModelName(), (String)"isusebalance,usedbalance");
            usedBalance = saleorder.getBigDecimal("usedbalance");
            this.getPageCache().put("usedbalance", usedBalance.toString());
        }
        if ((balanceInfo = BalanceUtil.getBalanceInfo((Object)ownerPK, (Object)customerPK, (boolean)false)) != null) {
            BigDecimal usableBalance = balanceInfo.getBigDecimal("usable");
            usedBalance = BigDecimal.ZERO;
            boolean isTemp = SaleOrderUtil.isThisStatus((DynamicObject)this.getModel().getDataEntity(true), (SaleOrderStatus)SaleOrderStatus.TEMP_SAVE);
            if (this.getPageCache().get("usedbalance") != null && !isTemp) {
                usedBalance = new BigDecimal(this.getPageCache().get("usedbalance"));
            }
            usableBalance = usableBalance.add(usedBalance);
            this.setValue("usablebalance", usableBalance);
        } else {
            this.setValue("usablebalance", BigDecimal.ZERO);
        }
    }

    protected void recalBalance() {
        if (this.isEdit() || this.isAddNew()) {
            this.recalUsedBalance();
        }
    }

    protected void recalUsedBalance() {
        String orderStatus;
        BigDecimal totalorderamount = (BigDecimal)this.getModel().getValue("totalorderamount");
        BigDecimal amounttobepaid = (BigDecimal)this.getModel().getValue("amounttobepaid");
        BigDecimal receivedamount = (BigDecimal)this.getModel().getValue("receivedamount");
        BigDecimal usablebalance = (BigDecimal)this.getModel().getValue("usablebalance");
        BigDecimal paidAmount = ReceivingbillUtil.getBillSalePayAmount((Object)this.getId(), (String)"saleorder");
        amounttobepaid = totalorderamount.subtract(paidAmount);
        BigDecimal usedbalance = BigDecimal.ZERO;
        boolean isUseBalance = (Boolean)this.getModel().getValue("isusebalance");
        if (isUseBalance) {
            if (amounttobepaid.compareTo(usablebalance) >= 0) {
                amounttobepaid = amounttobepaid.subtract(usablebalance);
                usedbalance = usablebalance;
            } else {
                usedbalance = amounttobepaid;
                amounttobepaid = BigDecimal.ZERO;
            }
        }
        if (!(orderStatus = (String)this.getModel().getValue("orderstatus")).equals(SaleOrderStatus.CHANGING.getFlagStr()) || receivedamount.compareTo(totalorderamount) < 0) {
            this.setValue("receivedamount", paidAmount.add(usedbalance));
        }
        this.setValue("amounttobepaid", amounttobepaid);
        this.setValue("usedbalance", usedbalance);
    }

    private void fromShoppingCart(Object ownerId, Object customerId, List<Object> cartList) {
        this.setCustomer(customerId);
        this.setOwner(ownerId);
        this.setUnEnable(new String[]{"owner", "customer"});
        this.initCusOwnerFields();
        this.createItemRow(cartList);
        this.getAlgorithm().reCalFields();
        this.afterInitNewPresentRowData();
    }

    private void createItemRow(List<Object> cartList) {
        IDataModel model = this.getModel();
        this.clearItemEntry();
        QFilter f = new QFilter("id", "in", cartList);
        DynamicObjectCollection cartInfos = QueryServiceHelper.query((String)"mdr_shopping_cart", (String)"id,item.id,item.material,item.thumbnail,item.name,item.baseunit,unit.id,assistattr.id,assistunit.id,qty,assistqty", (QFilter[])f.toArray());
        DynamicObject cartInfo = new DynamicObject();
        int rowIndex = 0;
        Object itemId = null;
        BigDecimal unitQty = null;
        int len = cartInfos.size();
        for (int i = 0; i < len; ++i) {
            rowIndex = this.createNewEntryRow("itementry");
            cartInfo = (DynamicObject)cartInfos.get(i);
            itemId = cartInfo.get("item.id");
            unitQty = cartInfo.getBigDecimal("qty");
            model.setValue("item", itemId, rowIndex);
            model.setValue("unit", cartInfo.get("unit.id"), rowIndex);
            model.setValue("assistattr", cartInfo.get("assistattr.id"), rowIndex);
            model.setValue("alterqty", (Object)unitQty, rowIndex);
            model.setValue("qty", (Object)unitQty, rowIndex);
            model.setValue("assistunit", cartInfo.get("assistunit.id"), rowIndex);
            model.setValue("assistqty", (Object)cartInfo.getBigDecimal("assistqty"), rowIndex);
            model.setValue("alterassistqty", (Object)cartInfo.getBigDecimal("assistqty"), rowIndex);
            model.setValue("baseunit", cartInfo.get("item.baseunit"), rowIndex);
            model.setValue("material", cartInfo.get("item.material"), rowIndex);
            String itemTitle = null;
            String thumbnail = logoUrl;
            itemTitle = cartInfo.getString("item.name");
            if (StringUtils.isNotEmpty((String)cartInfo.getString("item.thumbnail"))) {
                thumbnail = cartInfo.getString("item.thumbnail");
            }
            this.setValue("itemimg", thumbnail, rowIndex);
            this.setValue("itemtitle", itemTitle, rowIndex);
            this.setEnable(rowIndex, new String[]{"unit", "actualtaxprice", "qty", "alterqty", ORDER_NEED_NUM});
            this.initNewRowCommonData(rowIndex);
            this.itemStoreReSet(rowIndex);
            this.getAlgorithm().resetPrimPrice(rowIndex);
            this.newTaxrateSet(rowIndex);
            this.getAlgorithm().calPrimAmount(rowIndex);
        }
    }

    private void directOrder() {
        this.SetOwnerFromCache("customer");
        this.setCustomer(this.getCustomerF7Value());
        this.initDefaultOwner();
        this.initCusOwnerFields();
    }

    private void initDefaultReceipt() {
        List ids = ReceiptUtil.queryReceiptPK((Object)this.getCustomerF7PKValue());
        if (!ids.isEmpty()) {
            this.setReceiptF7Value(ids.get(0));
        } else {
            this.setReceiptF7Value(null);
        }
    }

    private void initDefaultWareHouse() {
        if (!this.isUseWareHouseRule()) {
            return;
        }
        List ids = WarehouseRuleUtil.getWarehouseList((Object)this.getOwnerF7PKValue(), (Object)this.getCustomerF7PKValue());
        if (ids != null && !ids.isEmpty()) {
            this.setWareHouseF7Value(ids.get(0));
            this.getView().setVisible(Boolean.TRUE, new String[]{"warehouse"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"warehouse"});
            this.getModel().setValue("warehouse", null);
        }
    }

    protected void initDefaultSaler() {
        this.setSalerF7Value(this.getDefaultSalerByRelation());
    }

    protected Object getDefaultSalerByRelation() {
        List salers = CustomerSalerUtil.queryCustomerSalerPK((Object)this.getCustomerF7PKValue(), (Object)this.getOwnerF7PKValue());
        return salers.isEmpty() ? null : salers.get(0);
    }

    protected QFilter getSalerFilter() {
        List salers = CustomerSalerUtil.queryCustomerSalerPK((Object)this.getCustomerF7PKValue(), (Object)this.getOwnerF7PKValue());
        if (!salers.isEmpty()) {
            return new QFilter("id", "in", (Object)salers);
        }
        return new QFilter("id", "=", (Object)0L);
    }

    protected void initDefaultOwner() {
        List<Object> ids = this.getOwnerIDs();
        Object id = null;
        if (ids.size() > 0) {
            id = ids.get(0);
        }
        if (ids.size() <= 1) {
            this.setUnEnable(new String[]{"owner"});
        } else {
            this.setEnable(new String[]{"owner"});
        }
        this.setOwner(id);
    }

    protected void setOwner(Object owner) {
        this.setOwnerF7Value(owner);
        this.setOwnerLogo();
        this.setSaleOrg();
    }

    protected final void setSaleOrg() {
        DynamicObject bizgroup;
        DynamicObject ownerF7Value = this.getOwnerF7Value();
        if (null != ownerF7Value && null != (bizgroup = ownerF7Value.getDynamicObject("bizgroup"))) {
            this.setValue("saleorgid", bizgroup);
            this.setSettleOrg((DynamicObject)this.getModel().getValue("saleorgid"));
            this.setEntryStockInfo();
        }
    }

    protected final void setSettleOrg(DynamicObject saleOrg) {
        if (null == saleOrg) {
            this.setValue("settleorgid", null);
        } else {
            Map map = OrgUnitServiceHelper.getCompanyByOrg((Long)saleOrg.getLong("id"), (Boolean)false, (Boolean)true);
            if (!CollectionUtils.isEmpty((Map)map)) {
                this.setValue("settleorgid", map.get("id"));
            } else {
                this.setValue("settleorgid", null);
            }
        }
        this.setExRateTable();
    }

    private void setExRateTable() {
        DynamicObject[] accountingsys;
        Object settleOrg = this.getValue("settleorgid");
        if (null == settleOrg) {
            this.setValue("exratetableid", null);
            this.setValue("exchangerate", 1, false);
            this.setValue(F_localcurrency, null, false);
        } else if (settleOrg instanceof DynamicObject && (accountingsys = BusinessDataServiceHelper.load((String)"bd_accountingsys_base", (String)"id,exratetable,basecurrrency", (QFilter[])new QFilter[]{new QFilter("baseacctorg", "=", ((DynamicObject)settleOrg).getPkValue())})).length > 0) {
            Object exratetable = accountingsys[0].get("exratetable");
            if (null == exratetable) {
                return;
            }
            this.setValue("exratetableid", exratetable);
            Object currency = this.getValue("currency");
            if (null == currency) {
                return;
            }
            Long srcCurId = (Long)((DynamicObject)currency).getPkValue();
            Object orderDate = this.getValue("orderdate");
            if (null == orderDate) {
                return;
            }
            Object basecurrrency = accountingsys[0].get("basecurrrency");
            if (null == basecurrrency) {
                return;
            }
            this.setValue(F_localcurrency, basecurrrency, false);
            this.setExchangeRate(srcCurId, (Long)((DynamicObject)basecurrrency).getPkValue(), (Long)((DynamicObject)exratetable).getPkValue(), (Date)orderDate);
        }
    }

    private void setExchangeRate(Long srcCurId, Long targetCurId, Long exRateTableId, Date date) {
        BigDecimal exchangeRate = this.calcExChangeRate(srcCurId, targetCurId, exRateTableId, date);
        this.setValue("exchangerate", exchangeRate);
    }

    private BigDecimal calcExChangeRate(Long srcCurId, Long targetCurId, Long exRateTableId, Date date) {
        BigDecimal exchangeRate = BigDecimal.ZERO;
        if (srcCurId.equals(targetCurId)) {
            exchangeRate = BigDecimal.valueOf(1L);
        } else {
            exchangeRate = BaseDataServiceHelper.getExchangeRate((Long)exRateTableId, (Long)srcCurId, (Long)targetCurId, (Date)date);
            if (null == exchangeRate || BigDecimal.ZERO.compareTo(exchangeRate) >= 0) {
                exchangeRate = BigDecimal.ONE;
            }
        }
        return exchangeRate;
    }

    protected void setCustomer(Object customerId) {
        this.setValue("customer", customerId);
        this.initDefaultDirectCustomer();
        this.initDefaultReceipt();
        this.initDefaultConsignee();
        this.initDefaultDriver();
        this.initCustomerPhone();
        this.setCustomerLogo();
    }

    public List<Object> getOwnerIDs() {
        return new ArrayList<Object>(CustomerUtil.getAuthOwnerIDs((Object)this.getCustomerF7PKValue()));
    }

    private void clearCache() {
        IPageCache pc = this.getPageCache();
        pc.remove(CACHE_KEY_USEWAREHOUSERULE);
    }

    protected void initCusOwnerFields() {
        CheckResult result = this.checkCustomerBeforeSelect();
        if (!result.isSuccess()) {
            return;
        }
        this.clearCache();
        this.initDefaultWareHouse();
        this.initRegion();
        this.initPayType();
        this.initDefaultArrivalDate();
        this.initDefaultSaler();
        this.initDefaultDepartment();
        this.initDefaultDispatcher();
        this.resetEntryByCusOwner();
        this.initNewEntryRow();
        this.matchPromotion();
        this.getAlgorithm().reCalFields();
        this.afterInitNewPresentRowData();
        this.initTotalEntry();
        this.initBalanceInfo();
    }

    protected void resetEntryByCusOwner() {
        BigDecimal taxrate = this.getDefaultTaxRate();
        Long taxrateid = this.getDefaultTaxRateID();
        Set items = QueryUtil.querySingleCol((String)"mdr_item_info", (String)"id", (QFilter[])this.getItemFilter().toArray(new QFilter("1", "=", (Object)"1").toArray()));
        Set combItems = QueryUtil.querySingleCol((String)"dpm_item_combination", (String)"id", (QFilter[])this.getCombItemFilter().toArray());
        int entryRowCount = this.getModel().getEntryRowCount("itementry");
        HashSet<Integer> deleteRows = new HashSet<Integer>();
        for (int i = 0; i < entryRowCount; ++i) {
            if (this.isIspromotional(i)) {
                deleteRows.add(i);
                continue;
            }
            SaleOrderEntryType entryType = this.getEntryType(i);
            if (entryType == SaleOrderEntryType.COMMON) {
                Object itemId = this.getEntryF7PKValue("itementry", "item", i);
                if (!items.contains(itemId)) {
                    deleteRows.add(i);
                    continue;
                }
                this.taxrateProcesswhenCusOwnchange(i, taxrate, taxrateid);
                this.getAlgorithm().resetPrimPrice(i);
                this.getAlgorithm().calPrimAmount(i);
                continue;
            }
            if (entryType != SaleOrderEntryType.COMBINATION) continue;
            Object combItemId = this.getEntryF7PKValue("itementry", "combitem", i);
            if (!combItems.contains(combItemId)) {
                deleteRows.add(i);
                Set<Integer> combItemSonEntrys = this.getCombItemSonEntrys(i);
                deleteRows.addAll(combItemSonEntrys);
                continue;
            }
            this.taxrateProcesswhenCusOwnchange(i, taxrate, taxrateid);
        }
        if (deleteRows.size() != 0) {
            int[] deleteRowIndexs = new int[deleteRows.size()];
            int i = 0;
            Iterator iterator = deleteRows.iterator();
            while (iterator.hasNext()) {
                int row = (Integer)iterator.next();
                deleteRowIndexs[i++] = row;
            }
            this.getModel().deleteEntryRows("itementry", deleteRowIndexs);
        }
        int newRows = this.getModel().getEntryRowCount("itementry");
        for (int i = 0; i < newRows; ++i) {
            this.newTaxrateSet(i);
            this.initNewRowCommonData(i);
        }
    }

    private void taxrateProcesswhenCusOwnchange(int index, BigDecimal newTaxRate, Long newTaxRateID) {
        BigDecimal oldTaxRate = BigDecimal.ZERO;
        Object tempRate = this.getValue("taxrate", index);
        if (tempRate != null) {
            oldTaxRate = (BigDecimal)tempRate;
        }
        this.setValue("taxrateid", newTaxRateID == 0L ? null : newTaxRateID, index);
        this.setUnEnable(index, new String[]{"taxrate"});
        if (newTaxRate.compareTo(oldTaxRate) != 0) {
            this.setValue("taxrate", newTaxRate, index);
            this.taxRateChangeProcess(index);
        }
    }

    protected void ownerChanged(PropertyChangedArgs e) {
        Object ownerid = this.getOwnerF7PKValue();
        if (ownerid == null) {
            Object oldValue = e.getChangeSet()[0].getOldValue();
            if (oldValue != null) {
                this.setOwnerF7Value(oldValue);
            }
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9500\u552e\u6e20\u9053\u4e0d\u80fd\u4e3a\u7a7a", (String)"PurOrderEditPlugin_21", (String)"drp-dpa-formplugin", (Object[])new Object[0]));
            return;
        }
        this.setOwner(ownerid);
        this.initCusOwnerFields();
        this.initUseableAccountInfo();
    }

    protected void customerChanged() {
        DynamicObject customerid = this.getCustomerF7Value();
        this.initDefaultOwner();
        this.setCustomer(customerid);
        this.initCusOwnerFields();
        this.initUseableAccountInfo();
    }

    protected boolean isReacquirePromotion() {
        boolean isreacquire = false;
        DynamicObject customerid = this.getCustomerF7Value();
        Object ownerid = this.getOwnerF7PKValue();
        if (customerid != null && ownerid != null) {
            if (SysParamsUtil.isUsePromotion() && SaleOrderStatus.TEMP_SAVE.equals((Object)this.getOrderStatus()) && !this.isView()) {
                isreacquire = true;
            }
        } else {
            IDataModel model = this.getModel();
            DynamicObjectCollection promotionInfo = model.getEntryEntity("promotionpreview");
            if (promotionInfo != null && promotionInfo.size() > 0) {
                model.deleteEntryData("promotionpreview");
            }
        }
        return isreacquire;
    }

    protected void initAvailablePromotion() {
        Set promotionInfos;
        DynamicObject customer = this.getCustomerF7Value();
        Object ownerid = this.getOwnerF7PKValue();
        if (customer == null || ownerid == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9500\u552e\u6e20\u9053\u6216\u8ba2\u8d27\u6e20\u9053\u3002", (String)"PurOrderEditPlugin_79", (String)"drp-dpa-formplugin", (Object[])new Object[0]));
            return;
        }
        Object customerid = customer.getPkValue();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String key = String.format("ap%s,%s,%s", customerid, ownerid, sdf.format(this.getValue("orderdate")));
        String cachekey = this.getStringValue("usablepromotioncachekey");
        if (!StringUtils.isEmpty((String)key) && cachekey.compareTo(key) == 0) {
            return;
        }
        this.setValue("usablepromotioncachekey", key);
        IDataModel model = this.getModel();
        DynamicObjectCollection promotionInfo = model.getEntryEntity("promotionpreview");
        if (promotionInfo != null && promotionInfo.size() > 0) {
            model.deleteEntryData("promotionpreview");
        }
        if ((promotionInfos = PromotionServiceHelper.matchByOrder((PromotionOrder)this.getAlgorithm().buildPromotionOrder())) != null && promotionInfos.size() > 0) {
            this.setVisible(new String[]{PAGE_AVAILABLEPROMOTION});
            int a = 0;
            int[] indexes = model.batchCreateNewEntryRow("promotionpreview", promotionInfos.size());
            for (UsablePromotionResult promotion : promotionInfos) {
                int i = indexes[a];
                model.setValue("policy", promotion.getId(), i);
                model.setValue("islimit", (Object)promotion.getIslimit(), i);
                model.setValue("starttime", (Object)promotion.getstarttime(), i);
                model.setValue("endtime", (Object)promotion.getendtime(), i);
                model.setValue("sumleftlimitqty", (Object)promotion.getLeftLimitqty(), i);
                ++a;
            }
        } else {
            this.setDisVisible(new String[]{PAGE_AVAILABLEPROMOTION});
        }
    }

    protected void initDefaultDirectCustomer() {
        this.setValue("directcustomer", this.getCustomerF7PKValue());
    }

    protected void initDefaultDepartment() {
        Object salerid = this.getF7PKValue("saler");
        if (salerid != null) {
            this.setValue("department", UserUtil.getDefaultAdminOrgID((Object)salerid));
        } else {
            this.setValue("department", null);
        }
    }

    protected void initDefaultDispatcher() {
        Object departmentid = this.getF7PKValue("department");
        if (departmentid != null) {
            this.setValue("dispatcher", UserUtil.getDefaultDispatcherId((Object)departmentid));
        } else {
            this.setValue("dispatcher", null);
        }
    }

    protected void initNewEntryRow() {
        if (this.getOwnerF7PKValue() != null && this.getCustomerF7PKValue() != null && this.getModel().getEntryRowCount("itementry") == 0) {
            this.createNewEntryRow("itementry");
        }
    }

    protected void initPayType() {
        Object customerF7PKValue = this.getCustomerF7PKValue();
        Object ownerF7PKValue = this.getOwnerF7PKValue();
        if (customerF7PKValue == null || ownerF7PKValue == null) {
            return;
        }
        DynamicObject authInfo = CustomerUtil.getAuthBizInfo((Object)ownerF7PKValue, (Object)customerF7PKValue);
        if (authInfo.getBoolean("onlycash")) {
            this.setValue("paytype", PayType.ONLY_CASH.getFlagStr());
        } else {
            this.setValue("paytype", PayType.CHARGE_SALES.getFlagStr());
        }
    }

    protected BigDecimal getDefaultTaxRate() {
        HashMap map = this.getAlgorithm().getDefaultTaxRateInfo();
        if (map.containsKey("taxrate")) {
            return new BigDecimal((String)map.get("taxrate"));
        }
        return BigDecimal.ZERO;
    }

    protected Long getDefaultTaxRateID() {
        HashMap map = this.getAlgorithm().getDefaultTaxRateInfo();
        if (map.containsKey("taxrateid")) {
            return Long.valueOf((String)map.get("taxrateid"));
        }
        return 0L;
    }

    private void initDefaultDriver() {
        Object defaultDriverId = DriverUtil.getDefaultDriverId((Object)this.getCustomerF7PKValue());
        this.setValue("driver", defaultDriverId);
        this.driverChanged();
    }

    private void initCustomerPhone() {
        DynamicObject customer = this.getCustomerF7Value();
        if (customer == null) {
            this.setValue("customerphone", "");
            return;
        }
        String phone = customer.getString("phone");
        if (StringUtils.isNotEmpty((String)phone)) {
            phone = phone.trim();
        }
        this.setValue("customerphone", phone);
    }

    private void initRegion() {
        DynamicObject bizInfo = CustomerUtil.getAuthBizInfo((Object)this.getOwnerF7PKValue(), (Object)this.getCustomerF7PKValue());
        if (bizInfo != null && bizInfo.get("customer") != null) {
            this.setCustomer(bizInfo.get("customer"));
        }
    }

    protected void initDefaultArrivalDate() {
        int date = this.queryLeadTime();
        Date arrivalDate = DateUtil.getNextDate((Date)new Date(), (int)date);
        this.setValue("arrivaldate", arrivalDate);
        this.setValue("confirmarrivaldate", arrivalDate);
    }

    private int queryLeadTime() {
        DynamicObject info = CustomerUtil.getAuthBizInfo((Object)this.getOwnerF7PKValue(), (Object)this.getCustomerF7PKValue());
        return info.getInt("leadtime");
    }

    private BigDecimal queryLowestPrice(int index) {
        BigDecimal lowestPrice = null;
        Object attrId = this.getEntryF7PKValue("itementry", "assistattr", index);
        if (attrId == null) {
            attrId = 0L;
        }
        lowestPrice = this.loadLowestPrice(this.getOwnerF7PKValue(), this.getCustomerF7PKValue(), this.getEntryF7PKValue("itementry", "item", index), this.getEntryF7PKValue("itementry", "unit", index), attrId, this.getRowInfo("itementry", index).getBigDecimal("qty"), SysParamsUtil.isPriceByConfirmarrivedate() ? this.getRowInfo("itementry", index).getDate("entryconfirmarrivaldate") : new Date());
        return lowestPrice;
    }

    private void initDefaultConsignee() {
        List ids = ConsigneeAddressUtil.queryConsigneeAddressPK((Object)this.getCustomerF7PKValue());
        if (!ids.isEmpty()) {
            this.setConsigneeAddressF7Value(ids.get(0));
            this.setConsigneeInfo();
        }
    }

    protected void setBillParameters() {
        DynamicObject billTypeParam;
        String formid = this.getView().getFormShowParameter().getFormId();
        DynamicObject billType = (DynamicObject)this.getModel().getValue("billtypeid");
        if (null != billType && (billTypeParam = BillTypeParameterHelper.getBillTypeParameterByConstants((String)formid, (long)billType.getLong("id"))) != null) {
            DynamicObject businesstype = null;
            DynamicObject easbusinesstype = null;
            switch (formid) {
                case "dpa_purorder": {
                    businesstype = billTypeParam.getDynamicObject("businesstype");
                    if (businesstype != null) {
                        this.getModel().setValue("businesstype", businesstype.getPkValue());
                    }
                    if ((easbusinesstype = billTypeParam.getDynamicObject("easbusinesstype")) != null) {
                        this.getModel().setValue(F_easbusinesstype, easbusinesstype.getPkValue());
                    } else {
                        this.getModel().setValue(F_easbusinesstype, (Object)easBusinessType);
                    }
                    DynamicObject bbcorderbilltype = billTypeParam.getDynamicObject("bbcorderbilltype");
                    if (bbcorderbilltype == null) break;
                    this.getModel().setValue(F_saleorderbilltypeid, bbcorderbilltype.getPkValue());
                    break;
                }
                case "bbc_saleorder": {
                    businesstype = billTypeParam.getDynamicObject("businesstype");
                    if (businesstype != null) {
                        this.getModel().setValue("businesstype", businesstype.getPkValue());
                    }
                    if ((easbusinesstype = billTypeParam.getDynamicObject("easbusinesstype")) != null) {
                        this.getModel().setValue(F_easbusinesstype, easbusinesstype.getPkValue());
                    } else {
                        this.getModel().setValue(F_easbusinesstype, (Object)easBusinessType);
                    }
                    DynamicObject dObject = (DynamicObject)this.getModel().getValue("billtypeid");
                    String bbcname = dObject.getString("name");
                    QFilter filter = new QFilter("billformid.number", "=", (Object)"dpa_purorder").and("name", "=", (Object)bbcname);
                    DynamicObjectCollection doc = QueryServiceHelper.query((String)"bos_billtype", (String)"masterid", (QFilter[])new QFilter[]{filter});
                    this.getModel().setValue("purorderbilltypeid", ((DynamicObject)doc.get(0)).get("masterid"));
                }
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        if (this.isSpliting) {
            return;
        }
        if (!this.isChangeEvent) {
            return;
        }
        Boolean triggerChangeEventLocal = (Boolean)MdrFormPlugin.triggerChangeEventLocal.get();
        if (triggerChangeEventLocal != null && !triggerChangeEventLocal.booleanValue()) {
            MdrFormPlugin.triggerChangeEventLocal.remove();
            return;
        }
        int index = this.getRowIndex(e);
        Object oldValue = e.getChangeSet()[0].getOldValue();
        Object newValue = e.getChangeSet()[0].getNewValue();
        switch (key) {
            case "billtypeid": {
                this.setBillParameters();
                break;
            }
            case "transportprice": {
                this.setValue("transportamount", 0);
                break;
            }
            case "transportamount": {
                this.setValue("transportprice", 0);
                break;
            }
            case "customer": {
                this.customerChanged();
                this.setCurrencyByCustomer(newValue);
                break;
            }
            case "owner": {
                this.ownerChanged(e);
                this.setCurrencyByCustomer();
                break;
            }
            case "driver": {
                this.driverChanged();
                break;
            }
            case "entrywarehouse": {
                this.itemStoreReSet(index);
                break;
            }
            case "warehouse": {
                this.sycnEntryWareHouse();
                break;
            }
            case "consigneeaddress": {
                this.setConsigneeInfo();
                this.sycnEntryConsigneeInfo();
                break;
            }
            case "entryconsigneeaddress": {
                this.setEntryConsigneeInfoByRow(index);
                break;
            }
            case "arrivaldate": {
                this.arrivalDateChange();
                break;
            }
            case "orderdate": {
                this.orderDateChange();
                break;
            }
            case "customerphone": {
                this.checkTel();
                break;
            }
            case "entryarrivaldate": {
                this.entryArrivalDateChange(index);
                break;
            }
            case "entryconfirmarrivaldate": {
                this.entryConfirmArrivalDateChange(index);
                break;
            }
            case "confirmarrivaldate": {
                this.confirmArrivalDateChange();
                break;
            }
            case "orderneednum": {
                break;
            }
            case "currency": {
                if (newValue instanceof DynamicObject) {
                    this.getPageCache().put("currency", String.valueOf(((DynamicObject)newValue).getLong("id")));
                }
                this.currencyChanged();
                break;
            }
            case "exchangerate": {
                this.exchangeRateChanged();
                break;
            }
            case "hastax": {
                this.hasTaxChanged();
                break;
            }
            case "combitem": {
                this.combItemChanged(index);
                break;
            }
            case "item": {
                this.itemChanged(index);
                break;
            }
            case "unit": {
                this.unitChanged(index, key, oldValue);
                break;
            }
            case "assistattr": {
                this.itemAssistAttrChanged(index, oldValue);
                break;
            }
            case "alterassistqty": 
            case "assistqty": 
            case "alterqty": 
            case "qty": {
                this.qtysChanged(index, (BigDecimal)oldValue, (BigDecimal)newValue, key);
                break;
            }
            case "price": 
            case "taxprice": {
                this.priceChanged(index, (BigDecimal)oldValue, key);
                break;
            }
            case "taxrateid": {
                DynamicObject taxrateinfo = (DynamicObject)this.getModel().getValue("taxrateid", index);
                if (taxrateinfo != null) {
                    this.setValue("taxrate", taxrateinfo.getBigDecimal("taxrate"), index, true);
                } else {
                    this.setValue("taxrate", BigDecimal.ZERO, index, true);
                }
                this.taxRateidChanged(index, oldValue);
                break;
            }
            case "taxrate": {
                this.taxRateChanged(index, (BigDecimal)oldValue);
                break;
            }
            case "discounttype": {
                this.discountTypeChanged(index);
                this.setDiscountLockProperties(index);
                break;
            }
            case "discount": {
                this.discountChanged(index, (BigDecimal)oldValue);
                break;
            }
            case "discountamount": {
                this.discountAmountChanged(index, (BigDecimal)oldValue);
                break;
            }
            case "itemamount": {
                this.itemAmountChanged(index, (BigDecimal)oldValue);
                break;
            }
            case "isusebalance": {
                this.useBalanceChanged();
                break;
            }
            case "issyncconsignee": {
                this.isSyncConsigneeChange();
                break;
            }
            case "saler": {
                this.salerChanged();
                break;
            }
            case "department": {
                this.departmentChanged();
                break;
            }
            case "rebateaccounttype": {
                this.rebateAccountTypeChanged(e);
                break;
            }
            case "usedrebate": {
                this.usedRebateChanged(e);
                break;
            }
            case "canuserebate": {
                this.canuserebateChanged(e);
                break;
            }
            case "ispresent": {
                Object item = ((DynamicObject)this.getModel().getEntryEntity("itementry").get(index)).get("item");
                if (null == item) {
                    this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5546\u54c1", (String)"PurOrderEditPlugin_80", (String)"drp-dpa-formplugin", (Object[])new Object[0]));
                    break;
                }
                this.isPresentChange(index, newValue);
                break;
            }
            case "settleorgid": {
                this.setExRateTable();
                break;
            }
            default: {
                this.triggerChangeEvent = true;
            }
        }
        this.reSetTriggerChangeEvent4UnitTest();
    }

    protected void canuserebateChanged(PropertyChangedArgs e) {
        if (!this.getBooleanValue("canuserebate")) {
            this.setValue("rebateaccounttype", null);
        }
        this.setValue("isusersetrebate", Boolean.FALSE);
        this.reSetRebateInfo();
        this.getAlgorithm().calByUsedRebateChanged();
        this.initTotalEntry();
        this.recalBalance();
    }

    private void reSetRebateInfo() {
        if (this.getBooleanValue("canuserebate")) {
            FormTemplate.initAccountType((MdrFormPlugin)this, (String)"rebateaccounttype");
        }
        this.initUseableAccountInfo();
    }

    protected void initUseableAccountInfo() {
        DynamicObject order = this.getModel().getDataEntity();
        if (SaleOrderUtil.isThisStatus((DynamicObject)order, (SaleOrderStatus)SaleOrderStatus.CHANGING)) {
            return;
        }
        BigDecimal balance = null;
        Object ownerId = this.getOwnerF7PKValue();
        Object customerId = this.getCustomerF7PKValue();
        Object accountTypeId = this.getF7PKValue("rebateaccounttype");
        Object currencyId = this.getF7PKValue("currency");
        if (!this.getBooleanValue("canuserebate") || ownerId == null || customerId == null || accountTypeId == null || currencyId == null) {
            balance = BigDecimal.ZERO;
        } else {
            String key = new StringBuffer("AccountBalance4Order").append(ownerId).append(customerId).append(accountTypeId).append(currencyId).toString();
            String balanceStr = this.getPageCache().get(key);
            if (balanceStr == null) {
                balance = (BigDecimal)DispatchServiceHelper.invokeBizService((String)"drp", (String)"drm", (String)"RebateService", (String)"getAccountBalance4Order", (Object[])new Object[]{ownerId, customerId, accountTypeId, currencyId});
                this.getPageCache().put(key, balance.toPlainString());
            } else {
                balance = new BigDecimal(balanceStr);
            }
        }
        this.setValue("rebatebalance", balance);
    }

    protected void usedRebateChanged(PropertyChangedArgs e) {
        DynamicObject order = this.getModel().getDataEntity();
        BigDecimal rebateBalance = order.getBigDecimal("rebatebalance");
        BigDecimal usedRebate = order.getBigDecimal("usedrebate");
        if (usedRebate.compareTo(rebateBalance) > 0) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8fd4\u5229\uff1a\u672c\u6b21\u62b5\u7528\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u53ef\u7528\u4f59\u989d[%f]", (String)"PurOrderEditPlugin_22", (String)"drp-dpa-formplugin", (Object[])new Object[0]), rebateBalance));
            this.setValue("usedrebate", rebateBalance);
        } else if (usedRebate.compareTo(BigDecimal.ZERO) < 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8fd4\u5229\uff1a\u672c\u6b21\u62b5\u7528\u91d1\u989d\u4e0d\u80fd\u5c0f\u4e8e0", (String)"PurOrderEditPlugin_23", (String)"drp-dpa-formplugin", (Object[])new Object[0]));
            this.setValue("usedrebate", BigDecimal.ZERO);
        }
        this.setValue("isusersetrebate", Boolean.TRUE);
        this.getAlgorithm().calByUsedRebateChanged();
        this.initTotalEntry();
        this.recalBalance();
    }

    protected void rebateAccountTypeChanged(PropertyChangedArgs e) {
        DynamicObject order = this.getModel().getDataEntity();
        order.set("isusersetrebate", (Object)Boolean.FALSE);
        this.initUseableAccountInfo();
        this.getAlgorithm().calByUsedRebateChanged();
        this.initTotalEntry();
        this.recalBalance();
    }

    protected int getAmountPrecision() {
        DynamicObject currency = this.getF7Value("currency");
        int amtprecision = currency.getInt("amtprecision");
        return amtprecision;
    }

    protected int getPricePrecision() {
        DynamicObject currency = this.getF7Value("currency");
        int priceprecision = currency.getInt("priceprecision");
        return priceprecision;
    }

    protected void departmentChanged() {
        this.initDefaultDispatcher();
    }

    protected void salerChanged() {
        this.initDefaultDepartment();
        this.initDefaultDispatcher();
    }

    protected void taxRateChanged(int index, BigDecimal oldRate) {
        BigDecimal taxRate = (BigDecimal)this.getValue("taxrate", index);
        if (taxRate != null && taxRate.compareTo(oldRate) == 0 || taxRate == null && oldRate == null) {
            return;
        }
        this.taxRateChangeProcess(index);
    }

    protected void taxRateidChanged(int index, Object oldRateObj) {
        Long newrateid;
        Long oldrateid;
        Object newRateObj = this.getValue("taxrateid", index);
        boolean isdiff = true;
        if (oldRateObj == null && newRateObj == null) {
            isdiff = false;
        } else if (oldRateObj != null && newRateObj != null && (oldrateid = Long.valueOf(((DynamicObject)oldRateObj).getLong("id"))).equals(newrateid = Long.valueOf(((DynamicObject)newRateObj).getLong("id")))) {
            isdiff = false;
        }
        if (!isdiff) {
            return;
        }
        this.taxRateChangeProcess(index);
    }

    private void taxRateChangeProcess(int index) {
        SaleOrderEntryType entryType = this.getEntryType(index);
        switch (entryType) {
            case COMBINATION: {
                this.getAlgorithm().calByCombTaxRate(index, true);
                break;
            }
            case COMMON: {
                this.getAlgorithm().calByTaxRate(index, true);
                break;
            }
        }
        this.afterInitNewPresentRowData();
    }

    protected void currencyChanged() {
        DynamicObject[] accountingsys;
        Object settleOrg;
        String newValue = this.getPageCache().get("currency");
        this.getPageCache().remove("currency");
        if (StringUtils.isNotEmpty((String)newValue) && null != (settleOrg = this.getValue("settleorgid")) && (accountingsys = BusinessDataServiceHelper.load((String)"bd_accountingsys_base", (String)"id,exratetable,basecurrrency", (QFilter[])new QFilter[]{new QFilter("baseacctorg", "=", ((DynamicObject)settleOrg).getPkValue())})).length > 0) {
            Object basecurrrency = accountingsys[0].get("basecurrrency");
            Object exratetable = this.getValue("exratetableid");
            Object orderDate = this.getValue("orderdate");
            if (null != exratetable && null != orderDate) {
                this.setExchangeRate(Long.parseLong(newValue), (Long)((DynamicObject)basecurrrency).getPkValue(), (Long)((DynamicObject)exratetable).getPkValue(), (Date)orderDate);
            }
        }
        this.initUseableAccountInfo();
        this.getAlgorithm().calByUsedRebateChanged();
    }

    protected void exchangeRateChanged() {
        this.getAlgorithm().calByExchangeRate();
        this.afterInitNewPresentRowData();
        this.initTotalEntry();
    }

    protected void hasTaxChanged() {
        this.initEntryByHasTax();
    }

    protected void initEntryByHasTax() {
        for (int i = 0; i < this.getModel().getEntryRowCount("itementry"); ++i) {
            this.initEntryByHasTax(i);
        }
    }

    protected void initEntryByHasTax(int i) {
        SaleOrderStatus orderStatus = this.getOrderStatus();
        if ((this.isEdit() || this.isAddNew()) && (orderStatus == SaleOrderStatus.TEMP_SAVE || orderStatus == SaleOrderStatus.CHANGING)) {
            if (this.isPresent(i)) {
                this.setUnEnable(i, new String[]{"price", "taxprice", "taxrate"});
            } else {
                SaleOrderEntryType entryType = this.getEntryType(i);
                switch (entryType) {
                    case COMMON: {
                        this.setComonEntryByHasTax(i);
                        break;
                    }
                    case COMBINATION: {
                        DynamicObject combitem = this.getEntryF7Value("itementry", "combitem", i);
                        String pricemode = combitem.getString("pricemode");
                        if ("2".equals(pricemode)) {
                            this.setComonEntryByHasTax(i);
                            break;
                        }
                        this.setUnEnable(i, new String[]{"price", "taxprice", "taxrate"});
                        break;
                    }
                    case COMBINATION_SON: {
                        this.setUnEnable(i, new String[]{"price", "taxprice", "taxrate"});
                        break;
                    }
                }
            }
        }
    }

    protected void setComonEntryByHasTax(int i) {
        if (this.hasTax()) {
            this.setUnEnable(i, new String[]{"price"});
            this.setEnable(i, new String[]{"taxprice"});
        } else {
            this.setUnEnable(i, new String[]{"taxprice"});
            this.setEnable(i, new String[]{"price"});
        }
    }

    protected boolean hasTax() {
        Object hastax = this.getValue("hastax");
        if (hastax == null) {
            hastax = Boolean.FALSE;
            this.setValue("hastax", hastax);
        }
        return (Boolean)hastax;
    }

    protected void discountTypeChanged(int i) {
        String discountType = (String)this.getValue("discounttype", i);
        if (StringUtils.isEmpty((String)discountType)) {
            this.setUnEnable(i, new String[]{"discount"});
            this.setUnEnable(i, new String[]{"discountamount"});
        } else {
            this.setEnable(i, new String[]{"discount"});
            this.setEnable(i, new String[]{"discountamount"});
        }
        SaleOrderEntryType entryType = this.getEntryType(i);
        if (entryType == SaleOrderEntryType.COMBINATION) {
            Set<Integer> sonindexs = this.getCombItemSonEntrys(i);
            for (int sonindex : sonindexs) {
                this.setValue("discounttype", discountType, sonindex);
            }
        }
        this.getAlgorithm().calByDiscountType(i, true);
        this.afterInitNewPresentRowData();
        this.initTotalEntry();
        this.recalBalance();
    }

    private void setDiscountLockProperties(int i) {
        String discountType = (String)this.getValue("discounttype", i);
        if (StringUtils.isEmpty((String)discountType)) {
            this.setUnEnable(i, new String[]{"discount"});
            this.setUnEnable(i, new String[]{"discountamount"});
        } else {
            this.setEnable(i, new String[]{"discount"});
            this.setEnable(i, new String[]{"discountamount"});
        }
    }

    protected void discountChanged(int i, BigDecimal oldDiscount) {
        String discountType = (String)this.getValue("discounttype", i);
        if (StringUtils.isEmpty((String)discountType)) {
            this.setValue("discount", BigDecimalConstants.ZERO, i);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6298\u6263\u65b9\u5f0f\u4e3a\u7a7a\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u5355\u4f4d\u6298\u6263\uff08\u7387\uff09\uff0c\u8bf7\u5148\u786e\u8ba4\u6298\u6263\u65b9\u5f0f", (String)"PurOrderEditPlugin_24", (String)"drp-dpa-formplugin", (Object[])new Object[0]));
            return;
        }
        DiscountModeEnum discountMode = EnumUtil.toDiscountMode((String)discountType);
        BigDecimal discount = (BigDecimal)this.getValue("discount", i);
        switch (discountMode) {
            case PERCENT: {
                if (BigDecimalConstants.ONEHUNDRED.compareTo(discount) >= 0) break;
                this.setValue("discount", oldDiscount, i);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6298\u6263\u65b9\u5f0f\u4e3a\u5355\u4f4d\u6298\u6263\u7387\uff05\u65f6\uff0c\u5355\u4f4d\u6298\u6263\uff08\u7387\uff09\u4e0d\u80fd\u5927\u4e8e100", (String)"PurOrderEditPlugin_25", (String)"drp-dpa-formplugin", (Object[])new Object[0]));
                return;
            }
            case PERUNIT: {
                BigDecimal taxprice = (BigDecimal)this.getValue("taxprice", i);
                if (discount != null && discount.compareTo(taxprice) <= 0) break;
                this.setValue("discount", oldDiscount, i);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6298\u6263\u65b9\u5f0f\u4e3a\u5355\u4f4d\u6298\u6263\u989d\u65f6\uff0c\u5355\u4f4d\u6298\u6263\uff08\u7387\uff09\u4e0d\u80fd\u5927\u4e8e\u542b\u7a0e\u5355\u4ef7", (String)"PurOrderEditPlugin_26", (String)"drp-dpa-formplugin", (Object[])new Object[0]));
                return;
            }
        }
        this.getAlgorithm().calByDiscount(i, true);
        this.afterInitNewPresentRowData();
        this.initTotalEntry();
        this.recalBalance();
    }

    protected void discountAmountChanged(int i, BigDecimal oldDiscountAmount) {
        BigDecimal qty;
        BigDecimal taxprice;
        BigDecimal amount;
        boolean hasChange = this.checkBigDecimalChange(i, oldDiscountAmount, "discountamount");
        if (!hasChange) {
            return;
        }
        String discountType = (String)this.getValue("discounttype", i);
        if (StringUtils.isEmpty((String)discountType)) {
            this.setValue("discountamount", BigDecimalConstants.ZERO, i);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6298\u6263\u65b9\u5f0f\u4e3a\u7a7a\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u6298\u6263\u989d\uff0c\u8bf7\u5148\u786e\u8ba4\u6298\u6263\u65b9\u5f0f", (String)"PurOrderEditPlugin_27", (String)"drp-dpa-formplugin", (Object[])new Object[0]));
            return;
        }
        BigDecimal discountAmount = BigDecimalUtil.toBigDecimal((Object)this.getValue("discountamount", i));
        if (discountAmount.compareTo(amount = (taxprice = BigDecimalUtil.toBigDecimal((Object)this.getValue("taxprice", i))).multiply(qty = BigDecimalUtil.toBigDecimal((Object)this.getValue("qty", i)))) > 0) {
            this.setValue("discountamount", oldDiscountAmount, i);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6298\u6263\u65b9\u5f0f\u4e3a\u5355\u4f4d\u6298\u6263\u989d\u65f6\uff0c\u6298\u6263\u989d\u4e0d\u80fd\u5927\u4e8e\u542b\u7a0e\u5355\u4ef7*\u786e\u8ba4\u6570\u91cf[", (String)"PurOrderEditPlugin_28", (String)"drp-dpa-formplugin", (Object[])new Object[0]) + amount.stripTrailingZeros().toPlainString() + "]");
            return;
        }
        this.getAlgorithm().calByDiscountAmount(i, true);
        this.afterInitNewPresentRowData();
        this.initTotalEntry();
        this.recalBalance();
    }

    protected void itemAmountChanged(int i, BigDecimal oldValue) {
        boolean hasChange = this.checkBigDecimalChange(i, oldValue, "itemamount");
        if (!hasChange) {
            return;
        }
        SaleOrderEntryType entryType = this.getEntryType(i);
        switch (entryType) {
            case COMBINATION: {
                this.getAlgorithm().calByCombItemAmount(i, true);
                break;
            }
            case COMMON: {
                this.getAlgorithm().calByItemAmount(i, true);
                break;
            }
        }
        this.afterInitNewPresentRowData();
        this.initTotalEntry();
        this.recalBalance();
    }

    protected void entryArrivalDateChange(int index) {
        Date date = (Date)this.getValue("entryarrivaldate", index);
        if (date == null) {
            return;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        Date nowDate = calendar.getTime();
        int leadTime = this.queryLeadTime();
        Date limitDate = DateUtil.getNextDate((Date)nowDate, (int)leadTime);
        if (date.before(limitDate)) {
            date = limitDate;
            this.setValue("entryarrivaldate", limitDate, index);
            this.getView().showMessage(ResManager.loadKDString((String)"\u8981\u6c42\u4ea4\u8d27\u65e5\u671f\u4e0d\u80fd\u65e9\u4e8e\uff1a", (String)"PurOrderEditPlugin_29", (String)"drp-dpa-formplugin", (Object[])new Object[0]) + DateUtil.getDateFormat((Date)limitDate));
            return;
        }
        this.setValue("entryconfirmarrivaldate", date, index);
    }

    protected void orderDateChange() {
        if (!"orderdate".equals(SysParamsUtil.getPromotionTime())) {
            return;
        }
        if (this.isAllEntryAavailable()) {
            if (this.isReacquirePromotion()) {
                this.initAvailablePromotion();
            }
            this.getAlgorithm().calByMatchAndExecutePromotion();
            this.afterInitNewPresentRowData();
            this.initTotalEntry();
            this.recalBalance();
        } else {
            this.matchPromotion();
        }
    }

    private boolean isAllEntryAavailable() {
        int count = this.getModel().getEntryRowCount("itementry");
        for (int i = 0; i < count; ++i) {
            if (this.isEntryAavailable(i)) continue;
            return false;
        }
        return true;
    }

    private boolean isEntryAavailable(int index) {
        DynamicObject entry = (DynamicObject)this.getModel().getEntryEntity("itementry").get(index);
        if (SaleOrderEntryType.COMBINATION.getFlagStr().equals(entry.getString("entrytype"))) {
            return entry.get("combitem") != null;
        }
        if (entry.get("item") == null || entry.get("unit") == null) {
            return false;
        }
        DynamicObject item = this.getEntryF7Value("itementry", "item", index);
        boolean hasAssistAttr = this.hasAssistAttr(item);
        return !hasAssistAttr || entry.get("assistattr") != null;
    }

    protected void combAlterQtyChange(int index) {
        BigDecimal combalterqty = (BigDecimal)this.getValue("alterqty", index);
        if (combalterqty == null) {
            return;
        }
        DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("itementry", index);
        Object pkValue = entryRowEntity.getPkValue();
        for (int i = 0; i < this.getModel().getEntryRowCount("itementry"); ++i) {
            BigDecimal combbaseqty;
            if (index == i) continue;
            String entrytype = (String)this.getValue("entrytype", i);
            if (!SaleOrderEntryType.COMBINATION_SON.getFlagStr().equals(entrytype)) continue;
            String parententryid = (String)this.getValue("parententryid", i);
            if (!pkValue.toString().equals(parententryid) || (combbaseqty = (BigDecimal)this.getValue("combbaseqty", i)) == null || combalterqty == null) continue;
            this.setValue("alterqty", combbaseqty.multiply(combalterqty), i);
        }
    }

    protected void isSyncConsigneeChange() {
        boolean issyncconsignee = (Boolean)this.getValue("issyncconsignee");
        if (issyncconsignee) {
            this.setDisVisible(new String[]{"entryconsigneeaddress", "entryconsignee", "entryconsigneephone", "entryaddress"});
            this.setDisVisible(new String[]{AP_ENTRYCONSIGNEEHEAD});
            this.setVisible(new String[]{AP_HEADCONSIGNEE});
        } else {
            this.setVisible(new String[]{"entryconsigneeaddress", "entryconsignee", "entryconsigneephone", "entryaddress"});
            this.setVisible(new String[]{AP_ENTRYCONSIGNEEHEAD});
            this.setDisVisible(new String[]{AP_HEADCONSIGNEE});
        }
    }

    protected void driverChanged() {
        Object driverId = this.getF7PKValue("driver");
        if (driverId == null) {
            this.setValue("drivertel", null);
            this.setValue("carno", null);
        } else {
            QFilter f = WebUtil.getIdQFilter((Object)driverId);
            f.and("customerentry.customer", "=", this.getCustomerF7PKValue());
            DynamicObject driver = QueryServiceHelper.queryOne((String)"mdr_driver", (String)"driverphone,customerentry.carid", (QFilter[])f.toArray());
            if (driver != null) {
                this.setValue("drivertel", driver.get("driverphone"));
                this.setValue("carno", driver.get("customerentry.carid"));
            }
        }
    }

    protected void useBalanceChanged() {
        boolean isUseBalance = (Boolean)this.getModel().getValue("isusebalance");
        if (isUseBalance) {
            this.setVisible(new String[]{"usablebalance", "usedbalance", "usablebalancelabel", "usedbalancelabel"});
        } else {
            this.setValue("usedbalance", BigDecimal.ZERO);
            this.setDisVisible(new String[]{"usablebalance", "usedbalance", "usablebalancelabel", "usedbalancelabel"});
        }
        this.recalBalance();
    }

    protected void checkOrderQuantity(BeforeDoOperationEventArgs e) {
        DynamicObject bizType = (DynamicObject)this.getModel().getValue(F_easbusinesstype);
        if (bizType == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u4e1a\u52a1\u7c7b\u578b\uff01", (String)"PurOrderEditPlugin_30", (String)"drp-dpa-formplugin", (Object[])new Object[0]));
        }
        boolean isUseOrderQuantity = bizType.getBoolean("isuseorderquantity");
        if (!isUseOrderQuantity) {
            return;
        }
        if (!this.isOrderQuantityStrongControl()) {
            return;
        }
        int count = this.getModel().getEntryRowCount("itementry");
        StringBuffer errorMsg = new StringBuffer();
        for (int i = 0; i < count; ++i) {
            String errormsg;
            SaleOrderEntryType entryType;
            if (this.isPresent(i) || (entryType = this.getEntryType(i)) == SaleOrderEntryType.COMBINATION_SON || StringUtils.isEmpty((String)(errormsg = this.getOrderQuantityMsg(i)))) continue;
            errormsg = errormsg.split(SPLITKEY)[0];
            errorMsg.append(errormsg);
            errorMsg.append('\n');
        }
        if (!StringUtils.isEmpty((Object)errorMsg)) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25:", (String)"PurOrderEditPlugin_11", (String)"drp-dpa-formplugin", (Object[])new Object[0]), errorMsg.toString(), MessageTypes.Commit);
            e.setCancel(true);
        }
    }

    protected boolean isUseOrderQuantity(int index) {
        DynamicObject bizType = (DynamicObject)this.getModel().getValue(F_easbusinesstype);
        if (bizType == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u4e1a\u52a1\u7c7b\u578b\uff01", (String)"PurOrderEditPlugin_30", (String)"drp-dpa-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (!bizType.getBoolean("isuseorderquantity")) {
            return false;
        }
        return !this.isPresent(index);
    }

    protected boolean isOrderQuantityStrongControl() {
        return SysParamsUtil.isOrderQuantityStrongControl();
    }

    protected void checkOrderQuantity(int index, String key) {
        if (!this.isUseOrderQuantity(index)) {
            return;
        }
        String errorMsg = this.getOrderQuantityMsg(index);
        if (!StringUtils.isEmpty((String)errorMsg)) {
            BigDecimal entryqty = new BigDecimal(errorMsg.split(SPLITKEY)[1]);
            errorMsg = errorMsg.split(SPLITKEY)[0];
            if (this.isOrderQuantityStrongControl()) {
                SaleOrderEntryType entryType = this.getEntryType(index);
                if (entryType == SaleOrderEntryType.COMBINATION) {
                    this.setValue("alterqty", entryqty, index);
                    this.setValue("qty", entryqty, index);
                    this.setValue("alterbaseqty", entryqty, index);
                    this.setValue("baseqty", entryqty, index);
                } else if (key == null || key.equals("alterqty")) {
                    this.setValue("alterqty", entryqty, index, false);
                    this.getAlgorithm().calQtysByAlterQty(index);
                } else {
                    this.setValue("qty", entryqty, index, false);
                    this.getAlgorithm().calQtysByQty(index);
                }
            }
            this.getView().showTipNotification(errorMsg);
        }
    }

    protected String getOrderQuantityMsg(int index) {
        IPageCache pageCache;
        int rowindex = index + 1;
        String errorHead = MessageFormat.format(ResManager.loadKDString((String)"\u7b2c{0}\u884c\u5546\u54c1\u5df2\u542f\u7528\u8ba2\u8d27\u6279\u91cf\uff0c\u8ba2\u8d27\u6570\u91cf\u9700", (String)"PurOrderEditPlugin_66", (String)"drp-dpa-formplugin", (Object[])new Object[0]), rowindex);
        Object owner = this.getOwnerF7PKValue();
        Object customer = this.getCustomerF7PKValue();
        Object warehouse = this.getEntryF7PKValue("itementry", "entrywarehouse", index);
        DynamicObject item = null;
        Object unitid = 0L;
        Object attrid = 0L;
        String unitTips = "";
        SaleOrderEntryType entryType = this.getEntryType(index);
        if (entryType == SaleOrderEntryType.COMBINATION) {
            item = this.getEntryF7Value("itementry", "combitem", index);
        } else {
            item = this.getEntryF7Value("itementry", "item", index);
            DynamicObject unitDy = this.getEntryF7Value("itementry", "unit", index);
            if (unitDy == null) {
                return "";
            }
            unitTips = "(" + unitDy.getString("name") + ")";
            unitid = unitDy.getPkValue();
            DynamicObject assistattr = this.getEntryF7Value("itementry", "assistattr", index);
            if (!this.itemAttrNullValidate(item, assistattr)) {
                return "";
            }
            if (assistattr != null) {
                attrid = assistattr.getPkValue();
            }
        }
        if (item == null) {
            return "";
        }
        Object itemId = item.getPkValue();
        Map orderQuantity = OrderQuantityUtil.getOrderQuantityRlue((Object)owner, (Object)customer, (Object)warehouse, (Object)itemId, (Object)unitid, (Object)attrid, (IPageCache)(pageCache = this.getPageCache()));
        if (orderQuantity == null) {
            return "";
        }
        boolean isLessThanMinQty = false;
        boolean isAccordOrderQuantity = true;
        DynamicObject rowInfo = this.getRowInfo("itementry", index);
        BigDecimal entryqty = rowInfo.getBigDecimal("qty");
        BigDecimal qty = ((BigDecimal)orderQuantity.get("qty")).stripTrailingZeros();
        BigDecimal minqty = ((BigDecimal)orderQuantity.get("minqty")).stripTrailingZeros();
        StringBuffer errorMessage = new StringBuffer();
        if (entryqty.compareTo(minqty) < 0) {
            isLessThanMinQty = true;
            entryqty = minqty;
            errorMessage.append(ResManager.loadKDString((String)"\u5927\u4e8e", (String)"PurOrderEditPlugin_32", (String)"drp-dpa-formplugin", (Object[])new Object[0])).append(minqty.toPlainString()).append(unitTips).append('!');
        }
        BigDecimal[] result = entryqty.divideAndRemainder(qty);
        BigDecimal intpart = result[0];
        BigDecimal remainder = result[1];
        if (remainder.compareTo(BigDecimal.ZERO) > 0) {
            isAccordOrderQuantity = false;
            if (isLessThanMinQty) {
                errorMessage.append(ResManager.loadKDString((String)"\u4e14", (String)"PurOrderEditPlugin_33", (String)"drp-dpa-formplugin", (Object[])new Object[0]));
            }
            errorMessage.append(MessageFormat.format(ResManager.loadKDString((String)"\u4e3a{0}{1}\u7684\u500d\u6570\uff01", (String)"PurOrderEditPlugin_61", (String)"drp-dpa-formplugin", (Object[])new Object[0]), qty.toPlainString(), unitTips));
        }
        if (!StringUtils.isEmpty((Object)errorMessage)) {
            if (!isAccordOrderQuantity) {
                entryqty = intpart.add(BigDecimal.ONE).multiply(qty).stripTrailingZeros();
                errorMessage.append(ResManager.loadKDString((String)"\u5f53\u524d\u8d2d\u4e70\u6570\u91cf\u5efa\u8bae\u4e3a", (String)"PurOrderEditPlugin_36", (String)"drp-dpa-formplugin", (Object[])new Object[0])).append(entryqty.toPlainString());
            }
            StringBuilder str = new StringBuilder();
            str.append(errorHead).append(errorMessage).append('&').append(entryqty);
            return str.toString();
        }
        return "";
    }

    protected void setCustomerLogo() {
        Image customerlogo = (Image)this.getControl("customerlogo");
        if (customerlogo != null) {
            String logo = logoUrl;
            if (this.getCustomerF7Value() != null && StringUtils.isNotEmpty((String)this.getCustomerF7Value().getString("logo"))) {
                logo = this.getCustomerF7Value().getString("logo");
            }
            customerlogo.setUrl(logo);
        }
    }

    protected void setOwnerLogo() {
        Image ownerlogo = (Image)this.getControl("ownerlogo");
        if (ownerlogo != null) {
            String logo = logoUrl;
            if (this.getOwnerF7Value() != null && StringUtils.isNotEmpty((String)this.getOwnerF7Value().getString("logo"))) {
                logo = this.getOwnerF7Value().getString("logo");
            }
            ownerlogo.setUrl(logo);
        }
    }

    protected void unitChanged(int index, String key, Object oldUnit) {
        DynamicObject rowInfo = this.getRowInfo("itementry", index);
        DynamicObject unit = rowInfo.getDynamicObject("unit");
        if (unit == null) {
            this.setValue(key, oldUnit, index);
            return;
        }
        this.unitChangeHandler(index);
    }

    protected void unitChangeHandler(int index) {
        this.getAlgorithm().calQtysByBaseQty(index);
        this.checkOrderQuantity(index, null);
        this.itemStoreReSet(index);
        this.getAlgorithm().calOtherAfterCalQty(index, true);
        this.afterInitNewPresentRowData();
        this.recalBalance();
        this.initTotalEntry();
    }

    protected void itemAssistAttrChanged(int index, Object oldValue) {
        DynamicObject assistattr;
        DynamicObject item = this.getEntryF7Value("itementry", "item", index);
        if (!this.itemAttrNullValidate(item, assistattr = this.getEntryF7Value("itementry", "assistattr", index))) {
            if (oldValue != null) {
                this.setValue("assistattr", oldValue, index);
            }
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5546\u54c1\u5f00\u542f\u8f85\u52a9\u5c5e\u6027\uff0c\u8f85\u52a9\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a\uff01", (String)"PurOrderEditPlugin_37", (String)"drp-dpa-formplugin", (Object[])new Object[0]));
            return;
        }
        this.itemAssistAttrChangeHandller(index, oldValue);
    }

    public boolean itemAttrNullValidate(DynamicObject item, DynamicObject assistAttr) {
        boolean hasAssistAttr = this.hasAssistAttr(item);
        return !hasAssistAttr || assistAttr != null;
    }

    protected void itemAssistAttrChangeHandller(int index, Object oldValue) {
        this.checkOrderQuantity(index, null);
        this.itemStoreReSet(index);
        this.getAlgorithm().calByAssistAttr(index, true);
        this.afterInitNewPresentRowData();
        this.recalBalance();
        this.initTotalEntry();
    }

    protected void qtysChanged(int i, BigDecimal oldvalue, BigDecimal newvalue, String key) {
        this.qtysChanged(i, oldvalue, key);
    }

    protected void qtysChanged(int i, BigDecimal oldvalue, String key) {
        boolean hasChange;
        BigDecimal qty;
        BigDecimal noScaleQty;
        SaleOrderEntryType entryType = this.getEntryType(i);
        if (entryType == SaleOrderEntryType.COMBINATION && (noScaleQty = (qty = BigDecimalUtil.toBigDecimal((Object)this.getValue(key, i))).setScale(0, RoundingMode.HALF_UP)).compareTo(qty) != 0) {
            this.setValue(key, noScaleQty, i);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ec4\u5408\u5546\u54c1\u6570\u91cf\u53ea\u80fd\u4e3a\u6574\u6570", (String)"PurOrderEditPlugin_38", (String)"drp-dpa-formplugin", (Object[])new Object[0]));
        }
        if (!(hasChange = this.checkBigDecimalChange(i, oldvalue, key))) {
            return;
        }
        if (!this.entryAavailableCheck(i)) {
            this.setRowValue(key, oldvalue, i);
            return;
        }
        this.qtysChangeHandler(i, key);
    }

    private void qtysChangeHandler(int index, String key) {
        SaleOrderEntryType entryType = this.getEntryType(index);
        switch (entryType) {
            case COMBINATION: {
                if (key.equals("alterqty")) {
                    this.setValue("qty", this.getValue(key, index), index, false);
                }
                this.checkOrderQuantity(index, key);
                this.getAlgorithm().calByCombEntryQty(index, key, true);
                break;
            }
            case COMMON: {
                this.getAlgorithm().calQtysByQtys(index, key);
                this.checkOrderQuantity(index, key);
                this.getAlgorithm().calOtherAfterCalQty(index, true);
                break;
            }
        }
        this.afterInitNewPresentRowData();
        this.initTotalEntry();
        this.recalBalance();
    }

    protected SaleOrderAlgorithm getAlgorithm() {
        if (this.algo == null) {
            this.algo = new SaleOrderAlgorithm(this.getModel().getDataEntity(true), this.getView(), this.getPageCache());
        }
        return this.algo;
    }

    protected void priceChanged(int i, BigDecimal oldPrice, String key) {
        BigDecimal price;
        CheckResult result;
        boolean hasChange = this.checkBigDecimalChange(i, oldPrice, key);
        if (!hasChange) {
            return;
        }
        SaleOrderEntryType entryType = this.getEntryType(i);
        if (entryType == SaleOrderEntryType.COMMON && !(result = this.checkLowestPrice(i, price = (BigDecimal)this.getValue(key, i))).isSuccess()) {
            this.setRowValue(key, oldPrice, i);
            this.getView().showMessage(result.getMsg());
            return;
        }
        this.priceChangeHandler(i, key);
    }

    protected boolean entryAavailableCheck(int i) {
        if (!this.isEntryAavailable(i)) {
            SaleOrderEntryType entryType = this.getEntryType(i);
            StringBuilder msg = new StringBuilder(ResManager.loadKDString((String)"\u8bf7\u5148\u5b8c\u5584\u5206\u5f55\u57fa\u672c\u4fe1\u606f\u518d\u4fee\u6539\uff0c", (String)"PurOrderEditPlugin_39", (String)"drp-dpa-formplugin", (Object[])new Object[0]));
            switch (entryType) {
                case COMBINATION: {
                    msg.append(ResManager.loadKDString((String)"\u7ec4\u5408\u5546\u54c1\u884c\uff1a\u7ec4\u5408\u5546\u54c1", (String)"PurOrderEditPlugin_40", (String)"drp-dpa-formplugin", (Object[])new Object[0]));
                    break;
                }
                default: {
                    msg.append(ResManager.loadKDString((String)"\u666e\u901a\u5546\u54c1\u884c\uff1a\u5546\u54c1\uff0c\u5355\u4f4d\uff0c\u8f85\u52a9\u5c5e\u6027\uff1b", (String)"PurOrderEditPlugin_41", (String)"drp-dpa-formplugin", (Object[])new Object[0]));
                }
            }
            this.getView().showTipNotification(msg.toString());
            return false;
        }
        return true;
    }

    protected void priceChangeHandler(int i, String key) {
        if (!this.isEntryAavailable(i)) {
            return;
        }
        SaleOrderEntryType entryType = this.getEntryType(i);
        switch (entryType) {
            case COMBINATION: {
                this.combPriceChangeHandler(i, key);
                break;
            }
            case COMMON: {
                this.commonPriceChangeHandler(i, key);
                break;
            }
        }
        this.afterInitNewPresentRowData();
        this.initTotalEntry();
        this.recalBalance();
    }

    protected void combPriceChangeHandler(int i, String key) {
        this.setValue("custchangeprice", Boolean.TRUE, i);
        switch (key) {
            case "price": {
                this.getAlgorithm().calByCombPrice(i, true);
                break;
            }
            case "taxprice": {
                this.getAlgorithm().calByCombTaxPrice(i, true);
                break;
            }
        }
    }

    protected void commonPriceChangeHandler(int i, String key) {
        this.setValue("custchangeprice", Boolean.TRUE, i);
        if (SaleOrderUtil.isThisStatus((DynamicObject)this.getModel().getDataEntity(), (SaleOrderStatus)SaleOrderStatus.CHANGING) && SysParamsUtil.isAlterPriceResetPrice() || SaleOrderUtil.isThisStatus((DynamicObject)this.getModel().getDataEntity(), (SaleOrderStatus)SaleOrderStatus.TEMP_SAVE)) {
            this.getAlgorithm().resetPrimPrice(i);
            this.getAlgorithm().calPrimAmount(i);
        }
        switch (key) {
            case "price": {
                this.getAlgorithm().calByPrice(i, true);
                break;
            }
            case "taxprice": {
                this.getAlgorithm().calByTaxPrice(i, true);
                break;
            }
        }
    }

    protected boolean checkBigDecimalChange(int i, BigDecimal oldValue, String key) {
        BigDecimal value = (BigDecimal)this.getValue(key, i);
        return (value == null || oldValue == null || value.compareTo(oldValue) != 0) && (value != null || oldValue != null);
    }

    protected CheckResult checkLowestPrice(int index, BigDecimal price) {
        BigDecimal lowestPrice = this.queryLowestPrice(index);
        if (lowestPrice != null && lowestPrice.compareTo(price) > 0) {
            return CheckResult.returnFalse((String)(ResManager.loadKDString((String)"\u4ef7\u683c\u4e0d\u80fd\u4f4e\u4e8e\u6700\u4f4e\u4ef7\uff1a", (String)"PurOrderEditPlugin_42", (String)"drp-dpa-formplugin", (Object[])new Object[0]) + lowestPrice.stripTrailingZeros().toPlainString()));
        }
        return CheckResult.returnTrue();
    }

    protected void setId4RowIfNoId(int index) {
        Object entryId = this.getEntryId(index);
        if (entryId == null || (Long)entryId == 0L) {
            DynamicObject newEntry = BusinessDataServiceHelper.newDynamicObject((String)this.getModelName()).getDynamicObjectCollection("itementry").addNew();
            long genLongId = DB.genLongId((String)((EntryType)newEntry.getDataEntityType()).getAlias());
            DynamicObject parentrow = this.getModel().getEntryRowEntity("itementry", index);
            parentrow.set("id", (Object)genLongId);
        }
    }

    private void checkOrderNeedNum(int index) {
        DynamicObject rowInfo = this.getRowInfo("itementry", index);
        BigDecimal alterQty = rowInfo.getBigDecimal("alterqty");
        BigDecimal needNum = rowInfo.getBigDecimal(ORDER_NEED_NUM);
        if (needNum.compareTo(alterQty) > 0) {
            this.setValue(ORDER_NEED_NUM, alterQty, index);
            this.getView().showMessage(ResManager.loadKDString((String)"\u9700\u751f\u4ea7\u6570\u91cf\u4e0d\u80fd\u5927\u4e8e\u8ba2\u5355\u6570\u91cf\uff01", (String)"PurOrderEditPlugin_43", (String)"drp-dpa-formplugin", (Object[])new Object[0]));
        }
    }

    private void setEntryConsigneeInfoByRow(int index) {
        DynamicObject address = this.getEntryF7Value("itementry", "entryconsigneeaddress", index);
        if (address != null) {
            this.setRowValue("entryconsignee", address.getString("contactname"), index);
            this.setRowValue("entryconsigneephone", address.getString("telephone"), index);
            this.setRowValue("entryaddress", address.getString("detailaddress"), index);
        } else {
            this.setRowValue("entryconsignee", "", index);
            this.setRowValue("entryconsigneephone", "", index);
            this.setRowValue("entryaddress", "", index);
        }
    }

    private void sycnEntryWareHouse() {
        Object id = this.getWareHouseF7PKValue();
        int count = this.getModel().getEntryRowCount("itementry");
        int len = count;
        for (int i = 0; i < len; ++i) {
            this.setRowValue("entrywarehouse", id, i);
        }
    }

    private void initReceiveWarehouse(int index) {
        List list = WarehouseRuleUtil.queryWarehouse((Object)this.getCustomerF7PKValue());
        if (!list.isEmpty()) {
            this.setRowValue("entryreceivewarehouse", list.get(0), index);
            this.setEnable(index, new String[]{"entryreceivewarehouse"});
        } else {
            this.setUnEnable(index, new String[]{"entryreceivewarehouse"});
        }
    }

    protected void setAmountLable(boolean isInitModel) {
        this.getAlgorithm().calTotalDiscountAmount();
        this.getAlgorithm().calTotalPromotionAmount();
        this.getAlgorithm().calTotalRebateAmount();
        if (!isInitModel) {
            this.getView().updateView("totaldiscountamount");
            this.getView().updateView("totalpromotionamount");
            this.getView().updateView("totalrebateamount");
        }
    }

    private void initRowUnits(int index) {
        DynamicObject item = this.getEntryF7Value("itementry", "item", index);
        Object unit = item.get("saleUnit");
        if (unit == null) {
            this.setValue("item", null, index);
            throw new KDBizException(MessageFormat.format(ResManager.loadKDString((String)"\u7b2c{0}\u884c\u5206\u5f55\u5546\u54c1\u6ca1\u6709\u8ba1\u91cf\u5355\u4f4d", (String)"PurOrderEditPlugin_62", (String)"drp-dpa-formplugin", (Object[])new Object[0]), index + 1));
        }
        this.setValue("unit", unit, index, false);
        this.initRowBaseUnit(index);
    }

    private void initRowBaseUnit(int index) {
        DynamicObject item = this.getEntryF7Value("itementry", "item", index);
        Object baseunit = item.get("baseunit");
        this.setValue("baseunit", baseunit, index);
    }

    private void initRowAssistUnits(int index) {
        DynamicObject item = this.getEntryF7Value("itementry", "item", index);
        Object assistUnit = item.get("assistunit");
        if (assistUnit == null) {
            this.setValue("assistunit", null, index, true);
            this.setValue("assistqty", null, index, true);
            this.setValue("alterassistqty", null, index, true);
        } else {
            this.setRowValue("assistunit", assistUnit, index);
        }
    }

    private void initRowAssistAttrs(int index) {
        DynamicObject item = this.getEntryF7Value("itementry", "item", index);
        boolean hasAssistAttr = this.hasAssistAttr(item);
        if (hasAssistAttr) {
            this.setValue("assistattr", ItemAttrUtil.getDefaultAttrId((Object)item.getPkValue()), index);
        } else {
            this.setValue("assistattr", null, index);
        }
    }

    protected void entryConfirmArrivalDateChange(int index) {
        Object item = this.getModel().getValue("item", index);
        if (null == item) {
            this.setValue("entryconfirmarrivaldate", null, index);
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5546\u54c1!", (String)"PurOrderEditPlugin_69", (String)"drp-dpa-formplugin", (Object[])new Object[0]));
            return;
        }
        Date confirmDate = this.getRowInfo("itementry", index).getDate("entryconfirmarrivaldate");
        if (confirmDate == null) {
            return;
        }
        Date now = DateUtil.getNowDate();
        if (confirmDate.before(now)) {
            confirmDate = now;
            this.setValue("entryconfirmarrivaldate", confirmDate, index);
            this.getView().showMessage(ResManager.loadKDString((String)"\u786e\u8ba4\u4ea4\u8d27\u65e5\u671f\u4e0d\u65e9\u4e8e\uff1a", (String)"PurOrderEditPlugin_45", (String)"drp-dpa-formplugin", (Object[])new Object[0]) + DateUtil.getDateFormat((Date)now));
        }
        this.resetPrimPrice(index);
    }

    protected void resetPrimPrice(int index) {
        this.getAlgorithm().calByResetPrimPrice(index, true);
        this.afterInitNewPresentRowData();
    }

    protected void confirmArrivalDateChange() {
        Date confirmDate = this.getDateFieldValue("confirmarrivaldate");
        if (confirmDate == null) {
            return;
        }
        Date now = DateUtil.getNowDate();
        if (confirmDate.before(now)) {
            confirmDate = now;
            this.getView().showMessage(ResManager.loadKDString((String)"\u786e\u8ba4\u4ea4\u8d27\u65e5\u671f\u4e0d\u65e9\u4e8e\uff1a", (String)"PurOrderEditPlugin_45", (String)"drp-dpa-formplugin", (Object[])new Object[0]) + DateUtil.getDateFormat((Date)now));
        }
        this.setValue("confirmarrivaldate", confirmDate);
        this.syncEntryConfirmArrivalDate(confirmDate);
    }

    private void syncEntryConfirmArrivalDate(Date confirmDate) {
        IDataModel model = this.getModel();
        int count = model.getEntryRowCount("itementry");
        if (count == 0) {
            return;
        }
        for (int i = 0; i < count; ++i) {
            this.setRowValue("entryconfirmarrivaldate", confirmDate, i);
            if (!this.isEntryAavailable(i)) continue;
            this.resetPrimPrice(i);
        }
    }

    protected void arrivalDateChange() {
        Date date = this.getDateFieldValue("arrivaldate");
        if (date == null) {
            return;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        Date nowDate = calendar.getTime();
        int leadTime = this.queryLeadTime();
        Date limitDate = DateUtil.getNextDate((Date)nowDate, (int)leadTime);
        if (date.before(limitDate)) {
            date = limitDate;
            this.setValue("arrivaldate", date);
            this.getView().showMessage(ResManager.loadKDString((String)"\u8981\u6c42\u4ea4\u8d27\u65e5\u671f\u4e0d\u80fd\u65e9\u4e8e\uff1a", (String)"PurOrderEditPlugin_29", (String)"drp-dpa-formplugin", (Object[])new Object[0]) + DateUtil.getDateFormat((Date)limitDate));
        }
        this.syncEntryArrivalDate(date);
        this.setValue("confirmarrivaldate", date);
        this.syncEntryConfirmArrivalDate(date);
    }

    private void syncEntryArrivalDate(Date date) {
        IDataModel model = this.getModel();
        int count = model.getEntryRowCount("itementry");
        if (count == 0) {
            return;
        }
        for (int i = 0; i < count; ++i) {
            this.setRowValue("entryarrivaldate", date, i);
            this.setRowValue("entryconfirmarrivaldate", date, i);
        }
    }

    private void setEntryConsigneeInfo(int index) {
        this.setRowValue("entryconsignee", this.getTextFieldValue("consignee"), index);
        this.setRowValue("entryconsigneephone", this.getTextFieldValue("consigneephone"), index);
        this.setRowValue("entryaddress", this.getTextFieldValue("address"), index);
    }

    private void sycnEntryConsigneeInfo() {
        IDataModel model = this.getModel();
        int count = model.getEntryRowCount("itementry");
        if (count == 0) {
            return;
        }
        DynamicObject pk = this.getConsigneeAddressF7Value();
        for (int i = 0; i < count; ++i) {
            this.setRowValue("entryconsigneeaddress", pk, i);
            this.setEntryConsigneeInfo(i);
        }
    }

    private void setConsigneeInfo() {
        DynamicObject address = this.getConsigneeAddressF7Value();
        if (address != null) {
            this.setValue("consignee", address.getString("contactname"));
            this.setValue("consigneephone", address.getString("telephone"));
            this.setValue("address", address.getString("detailaddress"));
        } else {
            this.setValue("consignee", "");
            this.setValue("consigneephone", "");
            this.setValue("address", "");
        }
    }

    protected QFilter getOwnerFitler() {
        List<Object> ownerIds = this.getOwnerIDs();
        return new QFilter("id", "in", ownerIds);
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        int rowIndex = e.getRow();
        CheckResult re = null;
        switch (key) {
            case "owner": {
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)this.getOwnerFitler());
                break;
            }
            case "customer": {
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)this.getCustomerFitler());
                break;
            }
            case "directcustomer": {
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)this.getDirectcustomerFitler());
                break;
            }
            case "department": {
                DynamicObject saler = this.getF7Value("saler");
                if (saler == null) {
                    this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4e1a\u52a1\u5458", (String)"PurOrderEditPlugin_46", (String)"drp-dpa-formplugin", (Object[])new Object[0]));
                    e.setCancel(true);
                    break;
                }
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)new QFilter("id", "in", (Object)UserUtil.getAdminOrgIDs((Object)saler.getPkValue())));
                break;
            }
            case "dispatcher": {
                DynamicObject department = this.getF7Value("department");
                if (department == null) {
                    this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9500\u552e\u90e8\u95e8", (String)"PurOrderEditPlugin_47", (String)"drp-dpa-formplugin", (Object[])new Object[0]));
                    e.setCancel(true);
                    break;
                }
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)new QFilter("id", "in", (Object)UserUtil.getDispatcherIds((Object)department.getPkValue())));
                break;
            }
            case "saler": {
                this.beforeSalerSelected(e);
                break;
            }
            case "driver": {
                re = this.checkCustomerBeforeSelect();
                if (re.isSuccess()) {
                    F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)this.getDriverFilter());
                    break;
                }
                this.getView().showMessage(re.getMsg());
                e.setCancel(true);
                return;
            }
            case "warehouse": {
                re = this.checkCustomerBeforeSelect();
                if (re.isSuccess()) {
                    F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)this.getWareHouseFilter());
                    break;
                }
                this.getView().showMessage(re.getMsg());
                e.setCancel(true);
                return;
            }
            case "receivablecompany": {
                re = this.checkCustomerBeforeSelect();
                if (re.isSuccess()) {
                    F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)this.getReceivableCompanyFitler());
                    break;
                }
                this.getView().showMessage(re.getMsg());
                e.setCancel(true);
                return;
            }
            case "entrywarehouse": {
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)this.getEntryWareHouseFilter(rowIndex));
                FormShowParameter param = e.getFormShowParameter();
                param.setCustomParam("itemid", this.getEntryF7PKValue("itementry", "item", rowIndex));
                param.setCustomParam("unitid", this.getEntryF7PKValue("itementry", "unit", rowIndex));
                param.setCustomParam("customerid", this.getOwnerF7PKValue());
                e.setFormShowParameter(param);
                break;
            }
            case "receipt": {
                re = this.checkCustomerBeforeSelect();
                if (re.isSuccess()) {
                    QFilter receiptFilter = ReceiptUtil.getReceiptQFilter((Object)this.getCustomerF7PKValue());
                    F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)receiptFilter);
                    break;
                }
                this.getView().showMessage(re.getMsg());
                e.setCancel(true);
                return;
            }
            case "entryreceivewarehouse": {
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)this.getWareFilterByCustomer(this.getCustomerF7PKValue()));
                break;
            }
            case "entryconsigneeaddress": 
            case "consigneeaddress": {
                QFilter addressFilter = ConsigneeAddressUtil.getConsigneeAddressQFilter((Object)this.getCustomerF7PKValue());
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)addressFilter);
                break;
            }
            case "item": {
                this.getPageCache().put("currentChooseRowIndex", String.valueOf(rowIndex));
                if (this.getOwnerF7PKValue() == null) {
                    e.setCancel(true);
                    this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9500\u552e\u6e20\u9053\uff01", (String)"PurOrderEditPlugin_1", (String)"drp-dpa-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (this.getCustomerF7PKValue() == null) {
                    e.setCancel(true);
                    this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8ba2\u8d27\u6e20\u9053\uff01", (String)"PurOrderEditPlugin_2", (String)"drp-dpa-formplugin", (Object[])new Object[0]));
                    return;
                }
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, this.getItemFilter());
                FormShowParameter parameter = e.getFormShowParameter();
                e.setFormShowParameter(parameter);
                break;
            }
            case "combitem": {
                if (this.getOwnerF7PKValue() == null) {
                    e.setCancel(true);
                    this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9500\u552e\u6e20\u9053\uff01", (String)"PurOrderEditPlugin_1", (String)"drp-dpa-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (this.getCustomerF7PKValue() == null) {
                    e.setCancel(true);
                    this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8ba2\u8d27\u6e20\u9053\uff01", (String)"PurOrderEditPlugin_2", (String)"drp-dpa-formplugin", (Object[])new Object[0]));
                    return;
                }
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)this.getCombItemFilter());
                break;
            }
            case "unit": {
                Object efItem = this.getEntryF7PKValue("itementry", "item", rowIndex);
                if (efItem == null) {
                    e.setCancel(true);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5546\u54c1\uff01", (String)"PurOrderEditPlugin_48", (String)"drp-dpa-formplugin", (Object[])new Object[0]));
                    return;
                }
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)this.getUnitFilter(rowIndex));
                break;
            }
            case "assistunit": {
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)this.getAssistUnitFilter(rowIndex));
                break;
            }
            case "assistattr": {
                this.addAssistAttrFilter(e, rowIndex);
                break;
            }
            case "sendcustomer": {
                Set customers = CustomerUtil.getStoreCustomer((Object)this.getOwnerF7PKValue());
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)WebUtil.getIdQFilter((Collection)customers));
                break;
            }
            case "receivercustomer": {
                Set customers = CustomerUtil.getPayCustomer((Object)this.getOwnerF7PKValue());
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)WebUtil.getIdQFilter((Collection)customers));
                break;
            }
            case "consigneecutomer": {
                Set customers = CustomerUtil.getStoreCustomer((Object)this.getCustomerF7PKValue());
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)WebUtil.getIdQFilter((Collection)customers));
                break;
            }
            case "paycustomer": {
                Set customers = CustomerUtil.getPayCustomer((Object)this.getCustomerF7PKValue());
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)WebUtil.getIdQFilter((Collection)customers));
                break;
            }
            case "rebateaccounttype": {
                BeForeF7Template.beforeAccountTypeF7((MdrFormPlugin)this, (BeforeF7SelectEvent)e);
                break;
            }
            case "settleorgid": {
                List<QFilter> fitlers = this.getSettleOrgFilters();
                if (fitlers.size() <= 0) break;
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, fitlers);
                break;
            }
            case "stockorgid": {
                Long saleOrgId;
                List invOrgs;
                Object saleOrg = this.getModel().getValue("saleorgid");
                ArrayList<QFilter> filters = new ArrayList<QFilter>();
                if (null != saleOrg && (invOrgs = OrgServiceHelper.getAllToOrg((String)"03", (String)"05", (Long)(saleOrgId = Long.valueOf(((DynamicObject)saleOrg).getLong("id"))), (Long)0L)).size() != 0) {
                    QFilter deliverOrgFilter = new QFilter("id", "in", (Object)invOrgs);
                    filters.add(deliverOrgFilter);
                }
                QFilter isinventory = new QFilter("fisinventory", "=", (Object)Boolean.TRUE);
                filters.add(isinventory);
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, filters);
                break;
            }
            case "stockid": {
                Object stockOrg = this.getModel().getValue(F_stockorgid, e.getRow());
                if (null == stockOrg) {
                    e.setCancel(true);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u8bbe\u7f6e\u5e93\u5b58\u7ec4\u7ec7\u3002", (String)"PurOrderEditPlugin_70", (String)"drp-dpa-formplugin", (Object[])new Object[0]));
                    break;
                }
                String number = ((DynamicObject)stockOrg).getString("number");
                Set<Long> stockIds = this.getAllStockIdByStockOrg(number);
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)new QFilter("id", "in", stockIds));
            }
        }
    }

    private Set<Long> getAllStockIdByStockOrg(String number) {
        QFilter orgf = new QFilter("org.number", "=", (Object)number);
        orgf.and(new QFilter("startstatus", "=", (Object)"B"));
        String selects = "warehouse.id";
        DynamicObject[] warehouseDycs = BusinessDataServiceHelper.load((String)"im_warehousesetup", (String)selects, (QFilter[])new QFilter[]{orgf});
        HashSet<Long> stockIds = new HashSet<Long>(warehouseDycs.length);
        for (DynamicObject warehouseDyc : warehouseDycs) {
            stockIds.add((Long)warehouseDyc.get("warehouse.id"));
        }
        return stockIds;
    }

    protected List<QFilter> getSettleOrgFilters() {
        Long orgid;
        Map orgMap;
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        HashSet<Long> orgIds = new HashSet<Long>();
        Object saleOrg = this.getModel().getValue("saleorgid");
        if (saleOrg instanceof DynamicObject && !CollectionUtils.isEmpty((Map)(orgMap = OrgUnitServiceHelper.getCompanyByOrg((Long)(orgid = Long.valueOf(((DynamicObject)saleOrg).getLong("id"))), (Boolean)Boolean.FALSE, (Boolean)Boolean.TRUE)))) {
            orgIds.add((Long)orgMap.get("id"));
        }
        if (orgIds.size() > 0) {
            QFilter orgIdsFilter = new QFilter("id", "in", orgIds);
            filters.add(orgIdsFilter);
        }
        return filters;
    }

    protected void beforeSalerSelected(BeforeF7SelectEvent e) {
        this.setNoTreeF7(e);
        CheckResult re = this.checkCustomerBeforeSelect();
        if (!re.isSuccess()) {
            this.getView().showMessage(re.getMsg());
            e.setCancel(true);
            return;
        }
        F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)this.getSalerFilter());
    }

    protected QFilter getCombItemFilter() {
        Object customerId = this.getCustomerF7PKValue();
        Object ownerId = this.getOwnerF7PKValue();
        QFilter f = ItemSaleControlUtil.getItemFilterUsePageCache((Object)ownerId, (Object)customerId, (IPageCache)this.getPageCache());
        f.and("isonsell", "=", (Object)"1");
        f.and("status", "=", (Object)"C");
        return f;
    }

    protected void addAssistAttrFilter(BeforeF7SelectEvent e, int rowIndex) {
        Object itemId = this.getEntryF7PKValue("itementry", "item", rowIndex);
        if (itemId == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5546\u54c1\uff01", (String)"PurOrderEditPlugin_48", (String)"drp-dpa-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)ItemAttrUtil.getAttrFilter((Object)itemId));
    }

    protected QFilter getDriverFilter() {
        return DriverUtil.getDriverQFilter((Object)this.getCustomerF7PKValue());
    }

    protected List<QFilter> getItemFilter() {
        Object customerId = this.getCustomerF7PKValue();
        Object ownerId = this.getOwnerF7PKValue();
        ArrayList<QFilter> fs = new ArrayList<QFilter>();
        fs.add(ItemSaleControlUtil.getItemFilterUsePageCache((Object)ownerId, (Object)customerId, (IPageCache)this.getPageCache()));
        fs.add(new QFilter("nonsingle", "=", (Object)"0"));
        return fs;
    }

    private QFilter getReceivableCompanyFitler() {
        Object ownerId = this.getOwnerF7PKValue();
        QFilter fs = new QFilter("customer", "=", ownerId);
        Set ids = QueryUtil.querySingleCol((String)"mdr_warehouse_relation", (String)"warehouse.id", (QFilter[])fs.toArray());
        return new QFilter("id", "in", (Object)ids);
    }

    protected CheckResult checkCustomerBeforeSelect() {
        if (this.getCustomerF7Value() == null) {
            return CheckResult.returnFalse((String)ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8ba2\u8d27\u6e20\u9053\uff01", (String)"PurOrderEditPlugin_2", (String)"drp-dpa-formplugin", (Object[])new Object[0]));
        }
        if (this.getOwnerF7Value() == null) {
            return CheckResult.returnFalse((String)ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9500\u552e\u6e20\u9053\uff01", (String)"PurOrderEditPlugin_1", (String)"drp-dpa-formplugin", (Object[])new Object[0]));
        }
        return CheckResult.returnTrue();
    }

    private QFilter getDirectcustomerFitler() {
        return CustomerUtil.getAuthSubsIdsAndSelfQFilter((Object)this.getCustomerF7PKValue());
    }

    protected QFilter getCustomerFitler() {
        return this.getCommonOwnerFitler();
    }

    private QFilter getUnitFilter(int rowIndex) {
        List ids = this.getUnitFormHandler().getUnitIdList(this.getEntryF7PKValue("itementry", "item", rowIndex));
        return new QFilter("id", "in", (Object)ids);
    }

    private QFilter getAssistUnitFilter(int rowIndex) {
        Object itemId = this.getEntryF7PKValue("itementry", "item", rowIndex);
        Object unitId = this.getUnitFormHandler().getAssistUnitId(itemId);
        return new QFilter("id", "=", unitId);
    }

    private QFilter getEntryWareHouseFilter(int rowIndex) {
        if (!this.isUseWareHouseRule()) {
            return this.getWareFilterByCustomer(this.getOwnerF7PKValue());
        }
        Object itemId = this.getEntryF7PKValue("itementry", "item", rowIndex);
        List ids = WarehouseRuleUtil.getWarehouseList((Object)this.getOwnerF7PKValue(), (Object)this.getCustomerF7PKValue(), (Object)itemId);
        return new QFilter("id", "in", (Object)ids);
    }

    private QFilter getWareHouseFilter() {
        if (!this.isUseWareHouseRule()) {
            return this.getWareFilterByCustomer(this.getOwnerF7PKValue());
        }
        List ids = WarehouseRuleUtil.getWarehouseList((Object)this.getOwnerF7PKValue(), (Object)this.getCustomerF7PKValue());
        if (ids.isEmpty()) {
            return new QFilter("id", "=", (Object)0L);
        }
        return new QFilter("id", "in", (Object)ids);
    }

    private QFilter getWareFilterByCustomer(Object customerId) {
        List list = WarehouseRuleUtil.queryWarehouse((Object)customerId);
        if (list.isEmpty()) {
            return new QFilter("id", "=", (Object)0L);
        }
        return new QFilter("id", "in", (Object)list);
    }

    private void clearItemEntry() {
        this.getModel().deleteEntryData("itementry");
    }

    public void tabSelected(TabSelectEvent e) {
        String key;
        switch (key = e.getTabKey()) {
            case "paytb": 
            case "deliveryrecordtb": 
            case "versiontb": 
            case "evaluatetb": 
            case "oplogtb": 
            case "promotiontb": {
                if (this.isLoaded(key) && this.tbNotChanged(key)) {
                    return;
                }
                this.loadTb(key);
                break;
            }
        }
    }

    private boolean tbNotChanged(String key) {
        return null == this.getPageCache().get("change-" + key);
    }

    private void loadTb(String key) {
        switch (key) {
            case "paytb": {
                this.loadPayTb();
                break;
            }
            case "deliveryrecordtb": {
                this.loadDeliveryRecordTb();
                break;
            }
            case "versiontb": {
                this.loadVersionTb();
                break;
            }
            case "evaluatetb": {
                this.loadEvaluateTb();
                break;
            }
            case "oplogtb": {
                this.loadOpLogTb();
                break;
            }
            case "promotiontb": {
                this.getView().setVisible(Boolean.TRUE, new String[]{EXECUTIONS_LIST});
                this.refreshExecutionList();
                this.getView().sendFormAction(this.getView());
            }
        }
        this.getPageCache().remove("change-" + key);
    }

    private void loadOpLogTb() {
        if (this.isNewCreate()) {
            return;
        }
        QFilter f = new QFilter("orderid", "=", this.getId());
        f.and("ordertype", "=", (Object)"saleorder");
        this.showInnerTbPage("mdr_order_oplogtb", PAGE_OPLOGTB, f);
    }

    private boolean isLoaded(String key) {
        return null != this.getPageCache().get("loadtb-" + key);
    }

    private void loadEvaluateTb() {
        this.showInnerTbPage("mdr_orderevaluate", "evaluatetb", this.createOrderFilter());
    }

    protected void loadVersionTb() {
    }

    private void loadPayTb() {
        Set billIds = ReceivingbillUtil.queryReceivingbillByOrder((Object)this.getId());
        this.showInnerTbPage("mdr_orderreceiingbill", PAGE_PAYTB, new QFilter("id", "in", (Object)billIds));
    }

    private void loadDeliveryRecordTb() {
        Object idObject = this.getId();
        QFilter filter1 = new QFilter("deliverydetail.mainbillid", "=", idObject);
        filter1.and("sourcebilltype", "in", (Object)sourceBillTypes);
        DynamicObjectCollection dispatchorderEntrys = QueryServiceHelper.query((String)"mdr_dispatchorder_entry", (String)"order", (QFilter[])new QFilter("sourcebillid", "=", (Object)idObject.toString()).toArray());
        HashSet<Object> dispatchOrderIds = new HashSet<Object>();
        for (DynamicObject dispatchorderEntry : dispatchorderEntrys) {
            dispatchOrderIds.add(dispatchorderEntry.get("order"));
        }
        QFilter filter2 = new QFilter("deliverydetail.srcbillid", "in", dispatchOrderIds);
        filter2.and("sourcebilltype", "=", (Object)"dispatchorder");
        this.showInnerTbPage("mdr_orderdeliveryrecord", PAGE_DELIVERYRECORDTB, filter1.or(filter2));
    }

    protected void showInnerTbPage(String pageName, String tbName, QFilter filter) {
        String flag = "loadtb-" + tbName;
        String id = this.getPageCache().get(flag);
        String isReflesh = this.getPageCache().get("refresh");
        if (id == null || "1".equals(isReflesh)) {
            FormShowParameter parameter = new FormShowParameter();
            String pageId = parameter.getPageId();
            parameter.setFormId(pageName);
            parameter.getOpenStyle().setShowType(ShowType.InContainer);
            parameter.getOpenStyle().setTargetKey(tbName);
            parameter.setCustomParam("filterStr", (Object)filter.toSerializedString());
            this.getView().showForm(parameter);
            this.getPageCache().put(flag, pageId);
            this.getPageCache().put("refresh", "0");
        } else {
            this.getView().getView(id).invokeOperation("refresh");
            this.getView().sendFormAction(this.getView().getView(id));
        }
    }

    protected void refreshPage() {
        this.reLoadPage();
        this.initPromotionCacheKey();
        this.initShowAp();
    }

    protected QFilter createOrderFilter() {
        return new QFilter("order", "=", this.getId());
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String actionId;
        super.closedCallBack(e);
        switch (actionId = e.getActionId()) {
            case "refresh": {
                this.refreshPage();
                break;
            }
            case "invalid": {
                Map param = (Map)e.getReturnData();
                if (param == null || param.get("isconfirm") == null || !"true".equals(param.get("isconfirm"))) break;
                Object detail = param.get("detail");
                this.setValue("invalidreason", detail);
                OperationUtil.invokeOperation((DynamicObject)this.getModel().getDataEntity(true), (String)actionId);
                this.refreshPage();
                break;
            }
            case "unsubmit": 
            case "unaudit": 
            case "delete": 
            case "withdraw": 
            case "valid": {
                Map param = (Map)e.getReturnData();
                if (param == null || param.get("isconfirm") == null || !"true".equals(param.get("isconfirm"))) break;
                String remark = (String)param.get("remark");
                this.setValue("operateremark", remark);
                OperateOption operateOption = OperateOption.create();
                operateOption.setVariableValue("afterconfirm", "true");
                this.getView().invokeOperation(actionId, operateOption);
                this.refreshPage();
                break;
            }
            case "deliveryrecordtb": 
            case "paytb": {
                this.refreshPage();
                break;
            }
            case "item_select": {
                ListSelectedRowCollection listSelectRows = (ListSelectedRowCollection)e.getReturnData();
                if (CollectionUtils.isEmpty((Collection)listSelectRows)) break;
                int entryRowCount = this.getView().getModel().getEntryRowCount("itementry");
                int newRowIndex = 0;
                DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("itementry");
                int currentRowIndex = Integer.parseInt(this.getPageCache().get("currentChooseRowIndex"));
                DynamicObject item = ((DynamicObject)entryEntity.get(currentRowIndex)).getDynamicObject("item");
                IDataModel model = this.getView().getModel();
                model.beginInit();
                for (int i = 0; i < listSelectRows.size(); ++i) {
                    if (i == 0 && currentRowIndex == entryRowCount - 1 && null == item) {
                        this.setValue("item", listSelectRows.get(i).getPrimaryKeyValue(), currentRowIndex);
                        this.itemChanged(currentRowIndex);
                        continue;
                    }
                    newRowIndex = model.createNewEntryRow("itementry");
                    this.setValue("item", listSelectRows.get(i).getPrimaryKeyValue(), newRowIndex);
                    this.itemChanged(newRowIndex);
                }
                this.getView().updateView("itementry");
                model.endInit();
                break;
            }
            case "presentbag": {
                this.getAlgorithm().addItemByPresentExecution(e.getReturnData());
                this.afterInitNewPresentRowData();
                break;
            }
            case "selectsubitem": {
                this.setSubItemInfo(e);
                break;
            }
        }
    }

    private boolean checkTel() {
        String tel = this.getModel().getDataEntity().getString("customerphone");
        if (StringUtils.isEmpty((String)tel)) {
            return true;
        }
        tel = tel.trim();
        this.setValue("customerphone", tel);
        CheckResult check = ValidateUtils.validPhoneNum((PhoneType)PhoneType.ALL, (String)tel);
        if (!check.isSuccess()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8ba2\u8d27\u6e20\u9053\u8054\u7cfb\u7535\u8bdd", (String)"PurOrderEditPlugin_49", (String)"drp-dpa-formplugin", (Object[])new Object[0]) + check.getMsg());
            return false;
        }
        return true;
    }

    private void actionCallBack(String actionId) {
        Tab tab = (Tab)this.getControl("tabap");
        String tabName = tab.getCurrentTab();
        if (!actionId.equals(tabName)) {
            this.getPageCache().put("change-" + actionId, "true");
            return;
        }
        this.loadTb(actionId);
    }

    public void handleData(BasedataFuzzySearchEvent e) {
        EntryGrid grid = (EntryGrid)this.getControl("itementry");
        int row = grid.getEntryState().getFocusRow();
        Object itemid = this.getEntryF7PKValue("itementry", "item", row);
        Object unitid = this.getEntryF7PKValue("itementry", "unit", row);
        Object ownerid = this.getOwnerF7PKValue();
        List list = e.getQueryData();
        ORM orm = ORM.create();
        ArrayList<Object> arr = new ArrayList<Object>(6);
        for (Object o : list) {
            arr.add(o);
            if (arr.size() < 4) {
                return;
            }
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd 00:00:00");
            Calendar c = Calendar.getInstance();
            c.setTime(new Date());
            String endtime = sdf.format(c.getTime());
            int date = c.get(5);
            c.set(5, date - 1);
            String starttime = sdf.format(c.getTime());
            this.insertStoreData(ownerid, itemid, unitid, arr, orm, starttime, endtime);
        }
    }

    private void insertStoreData(Object customerid, Object itemid, Object unitid, List<Object> arr, ORM orm, String starttime, String endtime) {
        Object warehouseid = arr.get(0);
        DynamicObject itemstore = QueryServiceHelper.queryOne((String)"mdr_item_store", (String)"qty,orderqty", (QFilter[])new QFilter[]{new QFilter("customer.id", "=", customerid), new QFilter("item.id", "=", itemid), new QFilter("measureunit.id", "=", unitid), new QFilter("warehouse.id", "=", warehouseid)});
        if (itemstore == null) {
            arr.set(3, 0);
        } else {
            arr.set(3, itemstore.getBigDecimal("qty").subtract(itemstore.getBigDecimal("orderqty")));
        }
        StringBuilder sql = new StringBuilder();
        sql.append("select customer.id,entryentity.item.id,entryentity.unit.id,entryentity.warehouse.id,entryentity.qty from mdr_store_updatebill ");
        sql.append("where customer.id = ? and entryentity.item.id = ? and entryentity.unit.id = ? and entryentity.warehouse.id = ? and bizdate >= ? and bizdate < ?");
        try (DataSet set = orm.queryDataSet(((Object)((Object)this)).getClass().getName(), sql.toString(), new Object[]{customerid, itemid, unitid, warehouseid, starttime, endtime}).groupBy(new String[]{"customer.id", "entryentity.item.id", "entryentity.unit.id", "entryentity.warehouse.id"}).sum("entryentity.qty", "otherqty").finish();){
            Iterator i = set.iterator();
            if (i.hasNext()) {
                Row datarow = (Row)i.next();
                BigDecimal otherqty = datarow.get("otherqty") == null ? BigDecimal.ZERO : (BigDecimal)datarow.get("otherqty");
                arr.set(3, new BigDecimal(arr.get(4).toString()).add(otherqty));
            }
        }
    }

    protected int getMaxattr() {
        int maxAttr = 10;
        String maxAttrStr = this.getPageCache().get(CACHE_KEY_MAXATTR);
        if (maxAttrStr == null) {
            maxAttr = SysParamsUtil.getMaxattr();
            this.getPageCache().put(CACHE_KEY_MAXATTR, String.valueOf(maxAttr));
        } else {
            maxAttr = Integer.parseInt(maxAttrStr);
        }
        return maxAttr;
    }

    protected SaleOrderStatus getOrderStatus() {
        DynamicObject order = this.getModel().getDataEntity(true);
        SaleOrderStatus status = SaleOrderUtil.getOrderStatus((DynamicObject)order);
        return status;
    }

    protected Boolean isSave() {
        DynamicObject order = this.getModel().getDataEntity(true);
        Object oId = order.get("Id");
        long id = Long.parseLong(oId == null ? "0" : oId.toString());
        logger.info("PurOrderEditPlugin_isSave_oId:" + oId);
        return id > 0L;
    }

    protected SaleOrderPayStatus getPayStatus() {
        DynamicObject order = this.getModel().getDataEntity(true);
        SaleOrderPayStatus status = SaleOrderUtil.getOrderPayStatus((DynamicObject)order);
        return status;
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "oplogmenu": {
                this.showOpLogForm();
                break;
            }
            case "messagemenu": {
                this.showMessageForm();
                break;
            }
        }
    }

    private void showMessageForm() {
        QFilter f = new QFilter("order", "=", this.getId());
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("bbc_order_message");
        parameter.getOpenStyle().setShowType(ShowType.Floating);
        parameter.getOpenStyle().setTargetKey(MENU_FLOAT);
        parameter.getOpenStyle().setFloatingDirection(FloatingDirection.LeftTop);
        StyleCss css = new StyleCss();
        css.setWidth("400px");
        css.setHeight("70%");
        parameter.getOpenStyle().setInlineStyleCss(css);
        parameter.setCustomParam("filterStr", (Object)f.toSerializedString());
        parameter.setCustomParam("orderId", this.getId());
        this.getView().showForm(parameter);
    }

    private void showOpLogForm() {
        QFilter f = new QFilter("orderid", "=", this.getId());
        f.and("ordertype", "=", (Object)"saleorder");
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("bbc_order_oplog");
        parameter.getOpenStyle().setShowType(ShowType.Floating);
        parameter.getOpenStyle().setTargetKey(MENU_FLOAT);
        parameter.getOpenStyle().setFloatingDirection(FloatingDirection.LeftTop);
        StyleCss css = new StyleCss();
        css.setWidth("400px");
        css.setHeight("70%");
        parameter.getOpenStyle().setInlineStyleCss(css);
        parameter.setCustomParam("filterStr", (Object)f.toSerializedString());
        this.getView().showForm(parameter);
    }

    protected void initShowAp() {
        if (this.getOrderStatus() != SaleOrderStatus.CHANGING && this.getOrderStatus() != SaleOrderStatus.TEMP_SAVE) {
            this.getView().getFormShowParameter().setStatus(OperationStatus.VIEW);
        }
        this.loadOrderInfoAP();
        this.setAmountLable(false);
        this.initButton();
        this.initEntryAdvconChildPanel();
        this.initTotalEntry();
        this.initEntryItemStore();
        this.isSyncConsigneeChange();
        PromotionApiResult result = PromotionServiceHelper.getPromotionResult((String)this.getPromotionCacheKey());
        this.initPresentBagButton(result.getExecutions());
    }

    protected void initTotalEntry() {
        EntryGrid itementry = (EntryGrid)this.getControl("itementry");
        HashMap<String, String> map = new HashMap<String, String>(16);
        for (String qtyCol : qtyCols) {
            map.put(qtyCol, this.getFloatNumberValue(qtyCol));
        }
        String sign = "";
        DynamicObject currency = this.getF7Value("currency");
        if (currency != null) {
            sign = currency.getString("sign");
        }
        for (String amonutCol : amonutCols) {
            map.put(amonutCol, sign + this.getFloatNumberValue(amonutCol));
        }
        sign = "";
        DynamicObject locaCurrency = this.getF7Value("currency");
        if (currency != null) {
            sign = locaCurrency.getString("sign");
        }
        for (String amonutCol : localAmonutCols) {
            map.put(amonutCol, sign + this.getFloatNumberValue(amonutCol));
        }
        itementry.setFloatButtomData(map);
    }

    protected String getFloatNumberValue(String key) {
        BigDecimal amount = this.getAlgorithm().sumEntryFiled(key);
        return amount.stripTrailingZeros().toPlainString();
    }

    private void initEntryItemStore() {
        DynamicObjectCollection itemEntry = this.getModel().getEntryEntity("itementry");
        if (itemEntry == null || itemEntry.size() == 0) {
            return;
        }
        for (int i = 0; i < itemEntry.size(); ++i) {
            this.itemStoreReSet(i);
        }
    }

    private void initEntryView() {
        DynamicObjectCollection itemEntry = this.getModel().getEntryEntity("itementry");
        this.initSelectSubItemButton(itemEntry);
        if (itemEntry == null || itemEntry.size() == 0) {
            return;
        }
        for (int i = 0; i < itemEntry.size(); ++i) {
            if (this.getValue("ispresent", i) == null) continue;
            this.initEntryView(i);
        }
    }

    private void initEntryByDiscountType() {
        int size = this.getModel().getEntryRowCount("itementry");
        for (int i = 0; i < size; ++i) {
            this.initEntryByDiscountType(i);
        }
    }

    private void initEntryByDiscountType(int i) {
        String discountType = (String)this.getValue("discounttype", i);
        if (StringUtils.isEmpty((String)discountType)) {
            this.setUnEnable(i, new String[]{"discount"});
            this.setUnEnable(i, new String[]{"discountamount"});
        }
    }

    private void initEntryView(int i) {
        boolean present = this.isPresent(i);
        boolean isChangeEdit = this.isChangeEdit();
        if (present) {
            this.initEntryPresentView(i);
        } else {
            this.setEnable(i, new String[]{"item", "combitem", "unit", "assistattr", "qty", "alterqty", "assistunit", "assistqty", "alterassistqty", "actualtaxprice", "price", "taxrate", "taxprice", "discount", "discounttype", "discountamount", "itemamount"});
            switch (this.getEntryType(i)) {
                case COMBINATION: {
                    this.initCombEntryView(i);
                    break;
                }
                case COMBINATION_SON: {
                    this.initCombSonEntryView(i);
                    break;
                }
                case COMMON: {
                    this.initCommonEntryView(i);
                    break;
                }
            }
            if (isChangeEdit) {
                this.setDisVisible(new String[]{"operationcolumnap"});
                this.setUnEnable(i, new String[]{"item", "combitem", "unit", "assistattr", "assistunit"});
            }
        }
        this.setEnableByIsAllowAddPresent(i);
    }

    private void setEnableByIsAllowAddPresent(int i) {
        if (SysParamsUtil.isAllowAddPresent()) {
            String entrytype = (String)this.getValue("entrytype", i);
            if (SaleOrderEntryType.COMMON.getFlagStr().equals(entrytype) && !this.isIspromotional(i)) {
                this.setEnable(i, new String[]{"ispresent"});
                return;
            }
        }
        this.setUnEnable(i, new String[]{"ispresent"});
    }

    protected void initCommonEntryView(int i) {
        DynamicObject item = this.getEntryF7Value("itementry", "item", i);
        boolean hasAssistAttr = this.hasAssistAttr(item);
        if (hasAssistAttr) {
            this.setEnable(i, new String[]{"assistattr"});
        } else {
            this.setUnEnable(i, new String[]{"assistattr"});
        }
        Object assistUnit = this.getValue("assistunit", i);
        if (assistUnit == null) {
            this.setUnEnable(i, new String[]{"assistqty", "alterassistqty"});
        } else {
            this.setEnable(i, new String[]{"assistqty", "alterassistqty"});
        }
        this.initEntryByHasTax(i);
        this.setUnEnable(i, new String[]{"taxrate"});
        this.initEntryByDiscountType(i);
    }

    private boolean hasAssistAttr(DynamicObject item) {
        boolean hasattr = false;
        if (item != null) {
            hasattr = item.getBoolean("hasattr");
        }
        return hasattr;
    }

    protected void initCombSonEntryView(int i) {
        this.setUnEnable(i, new String[]{"item", "combitem", "unit", "assistattr", "assistunit", "qty", "alterqty", "assistqty", "alterassistqty", "price", "taxprice", "taxrateid", "taxrate", "discount", "discounttype", "discountamount", "itemamount"});
    }

    protected void initCombEntryView(int i) {
        DynamicObject combItem = this.getEntryF7Value("itementry", "combitem", i);
        if (combItem != null) {
            this.initCombEntryView(i, combItem);
            this.initEntryByHasTax(i);
            this.setUnEnable(i, new String[]{"taxrate"});
        }
    }

    protected void initCombEntryView(int i, DynamicObject combItem) {
        this.setUnEnable(i, new String[]{"unit", "assistattr", "assistunit", "assistqty", "alterassistqty"});
        String pricemode = combItem.getString("pricemode");
        if ("2".equals(pricemode)) {
            this.setEnable(i, new String[]{"price", "taxprice", "taxrate", "itemamount"});
        } else {
            this.setUnEnable(i, new String[]{"price", "taxprice", "taxrate", "itemamount"});
        }
        this.initEntryByDiscountType(i);
    }

    protected SaleOrderEntryType getEntryType(int i) {
        String entrytype = (String)this.getValue("entrytype", i);
        if (StringUtils.isEmpty((String)entrytype)) {
            throw new KDBizException(MessageFormat.format(ResManager.loadKDString((String)"\u7b2c{0}\u884c\u5206\u5f55\uff0c\u5206\u5f55\u7c7b\u578b\u4e3a\u7a7a,\u8bf7\u91cd\u65b0\u521d\u59cb\u5316\u884c", (String)"PurOrderEditPlugin_63", (String)"drp-dpa-formplugin", (Object[])new Object[0]), i + 1));
        }
        return EnumUtil.toSaleOrderEntryType((String)entrytype);
    }

    private void initEntryAdvconChildPanel() {
        if (this.isView() || SaleOrderStatus.CHANGING.equals((Object)this.getOrderStatus())) {
            this.setVisible(new String[]{PAGE_DELIVERYRECORDTB, PAGE_PAYTB});
        } else {
            this.setDisVisible(new String[]{PAGE_DELIVERYRECORDTB, PAGE_PAYTB});
        }
        if (this.isView() || SaleOrderStatus.CHANGING.equals((Object)this.getOrderStatus())) {
            this.setDisVisible(new String[]{"entrytbmain"});
        } else {
            this.setVisible(new String[]{"entrytbmain"});
        }
        if (SysParamsUtil.isUsePromotion() && SaleOrderStatus.TEMP_SAVE.equals((Object)this.getOrderStatus()) && !this.isView()) {
            IDataModel model = this.getModel();
            DynamicObjectCollection promotionInfo = model.getEntryEntity("promotionpreview");
            if (promotionInfo != null && promotionInfo.size() > 0) {
                this.setVisible(new String[]{PAGE_AVAILABLEPROMOTION});
            } else {
                this.setDisVisible(new String[]{PAGE_AVAILABLEPROMOTION});
            }
        } else {
            this.setDisVisible(new String[]{PAGE_AVAILABLEPROMOTION});
        }
    }

    private void initCloseButton() {
        SaleOrderStatus status = this.getOrderStatus();
        if (SaleOrderStatus.TEMP_SAVE.equals((Object)status) || SaleOrderStatus.SUBMITTED.equals((Object)status) || SaleOrderStatus.CHANGING.equals((Object)status) || SaleOrderStatus.COMPLETED.equals((Object)status) || SaleOrderStatus.INVALID.equals((Object)status)) {
            this.setDisVisible(new String[]{BAR_CLOSEORDER, BAR_UNCLOSEORDER, BAR_LINE});
        } else if (this.isView()) {
            DynamicObject order = this.getModel().getDataEntity(true);
            if (order.getBigDecimal("usedbalance").compareTo(BigDecimal.ZERO) == 0 && order.getBigDecimal("usedrebate").compareTo(BigDecimal.ZERO) == 0) {
                this.setVisible(new String[]{BAR_LINE});
                if (order.getString("closestatus").compareTo("1") == 0) {
                    this.setVisible(new String[]{BAR_CLOSEORDER});
                    this.setDisVisible(new String[]{BAR_UNCLOSEORDER});
                } else {
                    this.setDisVisible(new String[]{BAR_CLOSEORDER});
                    this.setVisible(new String[]{BAR_UNCLOSEORDER});
                }
            } else {
                this.setDisVisible(new String[]{BAR_CLOSEORDER, BAR_UNCLOSEORDER, BAR_LINE});
            }
        }
    }

    private void initPresentBagButton(List<DynamicObject> executions) {
        if (executions == null || executions.size() == 0) {
            this.setDisVisible(new String[]{"tbispresent"});
            return;
        }
        boolean isVisible = false;
        for (DynamicObject execution : executions) {
            for (DynamicObject entry : execution.getDynamicObjectCollection("entryentity")) {
                if (entry.getString("type").compareTo("addpresentbag") != 0) continue;
                isVisible = true;
                break;
            }
            if (!isVisible) continue;
            break;
        }
        SaleOrderStatus status = this.getOrderStatus();
        if (isVisible && SaleOrderStatus.TEMP_SAVE.equals((Object)status) && (this.isEdit() || this.isAddNew())) {
            this.setVisible(new String[]{"tbispresent"});
        } else {
            this.setDisVisible(new String[]{"tbispresent"});
        }
    }

    private void initSelectSubItemButton(DynamicObjectCollection itemEntry) {
        if (itemEntry == null || itemEntry.size() == 0) {
            this.setDisVisible(new String[]{SELECTSUBITEM});
            return;
        }
        boolean isVisible = false;
        for (DynamicObject entry : itemEntry) {
            DynamicObject combitem;
            if (!SaleOrderEntryType.COMBINATION.getFlagStr().equals(entry.getString("entrytype")) || (combitem = entry.getDynamicObject("combitem")) == null || !combitem.getBoolean("issubgroup")) continue;
            isVisible = true;
            break;
        }
        SaleOrderStatus status = this.getOrderStatus();
        if (isVisible && SaleOrderStatus.TEMP_SAVE.equals((Object)status) && (this.isEdit() || this.isAddNew())) {
            this.setVisible(new String[]{SELECTSUBITEM});
        } else {
            this.setDisVisible(new String[]{SELECTSUBITEM});
        }
    }

    private void initButton() {
        boolean isDispatch = SysParamsUtil.isDispatch();
        SaleOrderStatus status = this.getOrderStatus();
        if (!SaleOrderStatus.TEMP_SAVE.equals((Object)status) || this.isEdit() || this.isAddNew()) {
            this.setDisVisible(new String[]{BAR_MODIFY});
        } else {
            this.setVisible(new String[]{BAR_MODIFY});
        }
        this.initCloseButton();
        if (SaleOrderStatus.TEMP_SAVE.equals((Object)status) && (this.isView() || this.isSave().booleanValue())) {
            this.setVisible(new String[]{BAR_DEL});
        } else {
            this.setDisVisible(new String[]{BAR_DEL});
        }
        if (!SaleOrderStatus.TEMP_SAVE.equals((Object)status) || !this.isSave().booleanValue()) {
            logger.info("PurOrderEditPlugin_initButton_status:" + status);
            this.setDisVisible(new String[]{BAR_SUBMIT, BAR_SUBMITANDNEW});
        } else {
            this.setVisible(new String[]{BAR_SUBMIT, BAR_SUBMITANDNEW});
        }
        if (!SaleOrderStatus.SUBMITTED.equals((Object)status)) {
            this.setDisVisible(new String[]{BAR_UNSUBMIT});
        } else {
            this.setVisible(new String[]{BAR_UNSUBMIT});
        }
        if (!SaleOrderStatus.SUBMITTED.equals((Object)status)) {
            this.setDisVisible(new String[]{BAR_AUDIT});
        } else {
            this.setVisible(new String[]{BAR_AUDIT});
        }
        if (!SaleOrderStatus.SUBMITTED.equals((Object)status)) {
            this.setDisVisible(new String[]{BAR_AUDIT});
        } else {
            this.setVisible(new String[]{BAR_AUDIT});
        }
        if (isDispatch) {
            if (!SaleOrderStatus.PENDING_DISPATCH.equals((Object)status)) {
                this.setDisVisible(new String[]{BAR_UNAUDIT});
            } else {
                this.setVisible(new String[]{BAR_UNAUDIT});
            }
        } else if (!SaleOrderStatus.PENDING_DELIVERY.equals((Object)status)) {
            this.setDisVisible(new String[]{BAR_UNAUDIT});
        } else {
            this.setVisible(new String[]{BAR_UNAUDIT});
        }
        if (!"C".equals(this.getValue("billstatus"))) {
            this.setDisVisible(new String[]{TO_SYNC, TO_ALLOT, TO_DELIVERY, TO_PAY, TO_SIGN, TO_EVALUATE});
        } else {
            boolean dispatch = SysParamsUtil.isDispatch();
            boolean openEasSync = SysParamsUtil.isOpenEasSync();
            if (dispatch) {
                this.setVisible(new String[]{TO_ALLOT});
            } else {
                this.setDisVisible(new String[]{TO_ALLOT});
            }
            if (dispatch || !openEasSync) {
                this.setDisVisible(new String[]{TO_SYNC});
            } else {
                this.setVisible(new String[]{TO_SYNC});
            }
            if (SaleOrderStatus.PENDING_DELIVERY.equals((Object)status) || SaleOrderStatus.PART_DELIVERY.equals((Object)status)) {
                this.setVisible(new String[]{TO_DELIVERY});
            } else {
                this.setDisVisible(new String[]{TO_DELIVERY});
            }
            if (SaleOrderStatus.WAITING_RECEIVER.equals((Object)status) || SaleOrderStatus.PART_DELIVERY.equals((Object)status)) {
                this.setVisible(new String[]{TO_SIGN});
            } else {
                this.setDisVisible(new String[]{TO_SIGN});
            }
            SaleOrderPayStatus payStatus = this.getPayStatus();
            if (SaleOrderPayStatus.NOT_PAID.equals((Object)payStatus)) {
                this.setVisible(new String[]{TO_PAY});
            } else {
                this.setDisVisible(new String[]{TO_PAY});
            }
            if (SaleOrderStatus.RECEIVED.equals((Object)status) || SaleOrderStatus.COMPLETED.equals((Object)status)) {
                this.setVisible(new String[]{TO_EVALUATE});
            } else {
                this.setDisVisible(new String[]{TO_EVALUATE});
            }
        }
        if (SaleOrderStatus.CHANGING.equals((Object)status)) {
            this.setDisVisible(new String[]{BAR_SUBMIT, BAR_SUBMITANDNEW, BAR_DEL, BAR_NEW, BAR_PRINT});
        }
    }

    protected boolean isChangeEdit() {
        return this.getOrderStatus() == SaleOrderStatus.CHANGING;
    }

    protected boolean isMyOrder() {
        Object userID = UserUtil.getUserID();
        Object creator = this.getF7PKValue("creator");
        return userID.equals(creator);
    }

    protected void loadOrderInfoAP() {
        this.setValue(LABEL_BILLNO, this.getValue("billno"));
        this.setValue(LABEL_ORDERDATE, this.getValue("orderdate"));
        this.setValue(LABEL_ARRIVALDATE, this.getValue("arrivaldate"));
        this.setValue(LABEL_CONFIRMARRIVALDATE, this.getValue("confirmarrivaldate"));
        this.setValue(LABEL_ORDERREMARK, this.getValue("orderremark"));
        String paystatus = this.getStringValue("paystatus");
        String color = "#26B175";
        if (SaleOrderPayStatus.NOT_PAID.getFlagStr().equals(paystatus) || SaleOrderPayStatus.TO_RETURN.getFlagStr().equals(paystatus)) {
            color = "#FF903D";
        }
        this.setColor("paystatus", color);
        this.setborder("paystatus", "1px_solid_" + color);
        color = this.getOrderStatusColor();
        this.setColor("orderstatus", color);
        this.setborder("orderstatus", "1px_solid_" + color);
        this.setCustomerLogo();
        this.setOwnerLogo();
        String sync = this.getStringValue("sync");
        color = "#26B175";
        if (SaleOrderSyncStatus.NO_SYNC.getFlagStr().equals(sync)) {
            this.setDisVisible(new String[]{"sync"});
        } else {
            this.setVisible(new String[]{"sync"});
            if (SaleOrderSyncStatus.SYNC_ING.getFlagStr().equals(sync) || SaleOrderSyncStatus.NOT_SYNC.getFlagStr().equals(paystatus)) {
                color = "#FF903D";
            }
            this.setColor("sync", color);
            this.setborder("sync", "1px_solid_" + color);
        }
        if (this.isChangeEdit()) {
            this.setDisVisible(new String[]{BTN_CUSTOMER_ALTER});
            this.setDisVisible(new String[]{BTN_OWNER_ALTER});
            this.setDisVisible(new String[]{BTN_SALER_ALTER});
            this.setDisVisible(new String[]{BTN_REGION_ALTER});
            this.setDisVisible(new String[]{BTN_CONSIGNEEADDRESS_ALTER});
            this.setDisVisible(new String[]{BTN_RECEIPT_ALTER});
            this.setUnEnable(new String[]{"issyncconsignee"});
        }
    }

    private String getOrderStatusColor() {
        String color;
        String orderstatusStr = this.getStringValue("orderstatus");
        SaleOrderStatus orderstatus = EnumUtil.toSaleOrderStatus((String)orderstatusStr);
        switch (orderstatus) {
            case TEMP_SAVE: 
            case SUBMITTED: 
            case PENDING_DELIVERY: {
                color = "#666666";
                break;
            }
            case PART_DELIVERY: {
                color = "#55A0F5";
                break;
            }
            case CHANGING: 
            case WAITING_RECEIVER: 
            case PENDING_DISPATCH: 
            case PART_DISPATCH: {
                color = "#FF903D";
                break;
            }
            case RECEIVED: 
            case COMPLETED: 
            case DISPATCHED: {
                color = "#26B175";
                break;
            }
            case INVALID: {
                color = "#bbbbbb";
                break;
            }
            default: {
                color = "#26B175";
            }
        }
        return color;
    }

    protected void deleteEntry(BeforeDoOperationEventArgs e) {
        EntryGrid itemEntry = (EntryGrid)this.getControl("itementry");
        int[] selectRows = itemEntry.getSelectRows();
        HashSet<Integer> rows = new HashSet<Integer>();
        for (int i : selectRows) {
            if (0 > i) continue;
            this.deleteEntry4SingleRow(rows, i);
        }
        if (rows != null && rows.size() > 0) {
            Boolean isrecalculate = Boolean.FALSE;
            for (Integer integer : rows) {
                if (((Boolean)this.getValue("ispresent", integer)).booleanValue() && !this.isIspromotional(integer)) continue;
                isrecalculate = Boolean.TRUE;
                break;
            }
            this.deleteEntry(rows);
            this.afterDeleteEntry(isrecalculate);
        }
        e.setCancel(true);
    }

    protected void afterDeleteEntry(boolean isrecalculate) {
        if (isrecalculate) {
            this.executePromotion(false);
        }
        this.getAlgorithm().calTotalFields();
        this.initTotalEntry();
        this.recalBalance();
    }

    private void deleteEntry(Set<Integer> rows) {
        int j = 0;
        int[] rowindex = new int[rows.size()];
        for (Integer rowIndex : rows) {
            rowindex[j++] = rowIndex;
        }
        this.getModel().deleteEntryRows("itementry", rowindex);
    }

    protected void deleteEntry4SingleRow(Set<Integer> rows, int i) {
        if (this.isPresent(i) && !SysParamsUtil.isAllowAddPresent()) {
            return;
        }
        if (this.getEntryType(i) == SaleOrderEntryType.COMBINATION_SON) {
            return;
        }
        rows.add(i);
        rows.addAll(this.getCombItemSonEntrys(i));
    }

    protected Set<Integer> getCombItemSonEntrys(int i) {
        HashSet<Integer> rows = new HashSet<Integer>();
        DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("itementry", i);
        Object pkValue = entryRowEntity.getPkValue();
        String entrytype = (String)this.getValue("entrytype", i);
        if (!SaleOrderEntryType.COMBINATION.getFlagStr().equals(entrytype)) {
            return rows;
        }
        for (int j = 0; j < this.getModel().getEntryRowCount("itementry"); ++j) {
            if (i == j) continue;
            entrytype = (String)this.getValue("entrytype", j);
            if (!SaleOrderEntryType.COMBINATION_SON.getFlagStr().equals(entrytype)) continue;
            String parententryid = (String)this.getValue("parententryid", j);
            if (!pkValue.toString().equals(parententryid)) continue;
            rows.add(j);
        }
        return rows;
    }

    protected void itemChanged(int index) {
        this.setId4RowIfNoId(index);
        this.setValueNoChangeEvent("combitem", null, index);
        this.clearCombSonRow(index);
        this.afterInitNewRowData(index);
        this.initTotalEntry();
        this.recalBalance();
    }

    protected void afterInitNewRowData(int index) {
        DynamicObject item = this.getEntryF7Value("itementry", "item", index);
        String itemTitle = null;
        String thumbnail = logoUrl;
        if (item != null) {
            itemTitle = item.getString("name");
            if (StringUtils.isNotEmpty((String)item.getString("thumbnail"))) {
                thumbnail = item.getString("thumbnail");
            }
        }
        this.setValue("itemimg", thumbnail, index);
        this.setValue("itemtitle", itemTitle, index);
        if (item == null) {
            return;
        }
        this.setValue("entrytype", SaleOrderEntryType.COMMON.getFlagStr(), index);
        this.initNewRowCommonData(index);
        this.newTaxrateSet(index);
        this.initRowUnits(index);
        this.initRowAssistUnits(index);
        this.initRowAssistAttrs(index);
        this.setItemMaterial(index);
        this.checkOrderQuantity(index, null);
        this.itemStoreReSet(index);
        if (SysParamsUtil.isAllowAddPresent()) {
            this.synUpdatePresentRowData(index);
        } else {
            this.afterInitNewPresentRowData();
        }
    }

    public void afterF7Select(AfterF7SelectEvent e) {
        boolean flag = this.getBooleanValue("ismatchpromotion");
        for (int i = 0; i < this.getModel().getEntryRowCount("itementry"); ++i) {
            DynamicObjectCollection itemEntry;
            if (flag || ((DynamicObject)(itemEntry = this.getModel().getEntryEntity("itementry")).get(i)).getDynamicObject("item") == null) continue;
            this.getAlgorithm().reCalFields(i, true);
        }
        this.setValue("ismatchpromotion", Boolean.FALSE);
    }

    protected void initNewRowCommonData(int index) {
        this.copyHeadInfo(index);
        this.setEntryWareHouse(index);
        this.initReceiveWarehouse(index);
        this.initConsignCustomers(index);
        this.setValue("isevaluate", Character.valueOf('0'), index);
        this.setValue("isevaluate", Character.valueOf('0'), index);
        this.setEnableByIsAllowAddPresent(index);
    }

    private void initConsignCustomers(int index) {
        this.setValue("sendcustomer", this.getOwnerF7PKValue(), index);
        this.setValue("receivercustomer", this.getOwnerF7PKValue(), index);
        this.setValue("consigneecutomer", this.getCustomerF7PKValue(), index);
        this.setValue("paycustomer", this.getCustomerF7PKValue(), index);
    }

    private void combItemChanged(int index) {
        this.setId4RowIfNoId(index);
        this.combItemChangeHandler(index);
    }

    protected void combItemChangeHandler(int index) {
        this.setValueNoChangeEvent("ispresent", Boolean.FALSE, index);
        this.setValueNoChangeEvent("item", null, index);
        this.clearCombSonRow(index);
        Object combId = this.getEntryF7PKValue("itementry", "combitem", index);
        if (combId != null) {
            DynamicObject itemCombination = BusinessDataServiceHelper.loadSingle((Object)combId, (String)"dpm_item_combination", (String)"issubgroup,totalamount,pricemode,itemdetail,itemdetail.item,itemdetail.unit,itemdetail.attr,itemdetail.qty,itemdetail.price,itemdetail.amount,itemdetail.proportion,itemdetail.isdefault");
            this.afterInitNewCombRowData(index, itemCombination);
            this.checkOrderQuantity(index, null);
            this.initCombEntryView(index, itemCombination);
            this.createNewCombItemRows(index, itemCombination);
            this.setCombPrice(index, itemCombination);
            this.getAlgorithm().calByCombEntryInit(index);
            this.afterInitNewPresentRowData();
        }
        this.initTotalEntry();
        this.recalBalance();
    }

    protected void setCombPrice(int index, DynamicObject itemCombination) {
        String pricemode;
        switch (pricemode = itemCombination.getString("pricemode")) {
            case "0": {
                DynamicObject currency = this.getF7Value("currency");
                if (currency == null) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5e01\u522b", (String)"PurOrderEditPlugin_51", (String)"drp-dpa-formplugin", (Object[])new Object[0]));
                }
                BigDecimal combPrimPrice = BigDecimal.ZERO;
                Set<Integer> entrys = this.getCombItemSonEntrys(index);
                for (Integer entry : entrys) {
                    BigDecimal primprice = (BigDecimal)this.getValue("primprice", entry);
                    BigDecimal combbaseqty = (BigDecimal)this.getValue("combbaseqty", entry);
                    combPrimPrice = combPrimPrice.add(combbaseqty.multiply(primprice));
                }
                this.setValue("primprice", combPrimPrice.setScale(currency.getInt("priceprecision"), RoundingMode.HALF_UP), index);
                if (this.hasTax()) {
                    this.setValue("taxprice", combPrimPrice, index, false);
                    break;
                }
                this.setValue("price", combPrimPrice, index, false);
                break;
            }
            case "1": 
            case "2": {
                BigDecimal totalprice = itemCombination.getBigDecimal("totalamount");
                this.setValue("primprice", totalprice, index);
                if (this.hasTax()) {
                    this.setValue("taxprice", totalprice, index, false);
                    break;
                }
                this.setValue("price", totalprice, index, false);
                break;
            }
        }
    }

    private void clearCombSonRow(int index) {
        this.deleteEntry(this.getCombItemSonEntrys(index));
    }

    private void afterInitNewCombRowData(int index, DynamicObject itemCombination) {
        String pricemode = itemCombination.getString("pricemode");
        if ("0".equals(pricemode)) {
            this.setValue("custchangeprice", Boolean.FALSE, index);
        } else {
            this.setValue("custchangeprice", Boolean.TRUE, index);
        }
        this.setValue("entrytype", SaleOrderEntryType.COMBINATION.getFlagStr(), index);
        this.setValue("parententryid", this.getEntryId(index), index);
        this.setValue("combbaseqty", 1, index);
        this.setValue("custchangeprice", Boolean.FALSE, index);
        this.setValue("assistattr", null, index);
        this.setValue("unit", null, index);
        this.setValue("assistunit", null, index);
        this.setValue("baseunit", null, index);
        this.setValue("alterqty", 1, index);
        this.setValue("qty", 1, index);
        this.setValue("alterbaseqty", 1, index);
        this.setValue("baseqty", 1, index);
        this.setValue("assistqty", 0, index);
        this.setValue("alterassistqty", 0, index);
        this.setValue("discounttype", null, index);
        this.setValue("discount", 0, index);
        this.setValue("discountamount", 0, index);
        this.newTaxrateSet(index);
        this.initNewRowCommonData(index);
    }

    private void newTaxrateSet(int index) {
        HashMap map = this.getAlgorithm().getDefaultTaxRateInfo();
        BigDecimal taxratevalue = BigDecimal.ZERO;
        if (map.containsKey("taxrate")) {
            taxratevalue = new BigDecimal((String)map.get("taxrate"));
        }
        Long tempTaxRateID = 0L;
        if (map.containsKey("taxrateid")) {
            tempTaxRateID = Long.valueOf((String)map.get("taxrateid"));
        }
        if (taxratevalue != null && taxratevalue.compareTo(ZERO) > 0 || tempTaxRateID > 0L) {
            this.setValue("taxrate", taxratevalue, index, false);
            this.setValue("taxrateid", tempTaxRateID == 0L ? null : tempTaxRateID, index, false);
        } else {
            DynamicObject taxrate;
            DynamicObject material = this.getEntryF7Value("itementry", "material", index);
            if (material != null && (taxrate = material.getDynamicObject("taxrate")) != null) {
                this.setValue("taxrateid", taxrate.getPkValue(), index, false);
                DynamicObject taxrateinfo = this.getEntryF7Value("itementry", "taxrateid", index);
                this.setValue("taxrate", taxrateinfo.getBigDecimal("taxrate"), index, false);
            }
        }
    }

    private void createNewCombItemRows(int parentIndex, DynamicObject itemCombination) {
        String parentId = this.getEntryId(parentIndex).toString();
        DynamicObjectCollection itemdetails = itemCombination.getDynamicObjectCollection("itemdetail");
        String pricemode = itemCombination.getString("pricemode");
        boolean issubgroup = itemCombination.getBoolean("issubgroup");
        int i = parentIndex;
        for (int j = 0; j < itemdetails.size(); ++j) {
            DynamicObject itemdetail = (DynamicObject)itemdetails.get(j);
            if (issubgroup && !itemdetail.getBoolean("isdefault")) continue;
            this.getAlgorithm().insertEntry(++i);
            this.setValueNoChangeEvent("combitem", itemCombination.get("id"), i);
            DynamicObject item = itemdetail.getDynamicObject("item");
            Object itemId = null;
            Object baseunitId = null;
            if (!(item instanceof DynamicObject)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ec4\u5408\u5546\u54c1\u6570\u636e\u6709\u8bef\uff0c\u8bf7\u68c0\u67e5\u7ec4\u5408\u5546\u54c1\u4fe1\u606f\u6216\u91cd\u65b0\u9009\u62e9\u7ec4\u5408\u5546\u54c1\u3002", (String)"PurOrderEditPlugin_71", (String)"drp-dpa-formplugin", (Object[])new Object[0]));
                continue;
            }
            DynamicObject itemObject = item;
            itemId = itemObject.get("id");
            baseunitId = itemObject.get("baseunit.id");
            DynamicObject unit = itemdetail.getDynamicObject("unit");
            Object unitId = null;
            if (!(unit instanceof DynamicObject)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ec4\u5408\u5546\u54c1\u6570\u636e\u6709\u8bef\uff0c\u8bf7\u68c0\u67e5\u7ec4\u5408\u5546\u54c1\u4fe1\u606f\u6216\u91cd\u65b0\u9009\u62e9\u7ec4\u5408\u5546\u54c1\u3002", (String)"PurOrderEditPlugin_71", (String)"drp-dpa-formplugin", (Object[])new Object[0]));
                continue;
            }
            unitId = unit.get("id");
            DynamicObject attr = itemdetail.getDynamicObject("attr");
            BigDecimal qty = itemdetail.getBigDecimal("qty");
            this.setItemNoChangeEvent(itemId, i);
            this.setValue("entrytype", SaleOrderEntryType.COMBINATION_SON.getFlagStr(), i);
            this.setValue("parententryid", parentId, i);
            this.setValue("combitementeryid", itemdetail.get("id"), i);
            this.setValue("baseunit", baseunitId, i, false);
            this.setValue("unit", unitId, i, false);
            this.setValue("assistattr", attr, i, false);
            this.setValue("combbaseqty", qty, i, false);
            this.afterInitNewCombItemRowData(i);
            BigDecimal primprice = this.getAlgorithm().getSysPrice(i);
            this.setValue("primprice", primprice, i, false);
            BigDecimal entryprice = BigDecimal.ZERO;
            if ("0".equals(pricemode)) {
                entryprice = primprice;
                this.setValue("custchangeprice", Boolean.FALSE, i);
            } else {
                entryprice = itemdetail.getBigDecimal("price");
                this.setValue("custchangeprice", Boolean.TRUE, i);
            }
            if (this.hasTax()) {
                this.setValue("taxprice", entryprice, i, false);
            } else {
                this.setValue("price", entryprice, i, false);
            }
            this.newTaxrateSet(i);
            this.setValue("discount", 0, i);
            this.setValue("discounttype", null, i);
            this.setValue("discountamount", 0, i);
            this.initCombSonEntryView(i);
        }
    }

    private void afterInitNewCombItemRowData(int index) {
        this.initNewRowCommonData(index);
        DynamicObject item = this.getEntryF7Value("itementry", "item", index);
        String itemTitle = null;
        String thumbnail = logoUrl;
        itemTitle = item.getString("name");
        if (StringUtils.isNotEmpty((String)item.getString("thumbnail"))) {
            thumbnail = item.getString("thumbnail");
        }
        this.setValue("itemimg", thumbnail, index);
        this.setValue("itemtitle", itemTitle, index);
        this.initRowAssistUnits(index);
        this.itemStoreReSet(index);
    }

    protected boolean isPresent(int i) {
        boolean isPresent = (Boolean)this.getValue("ispresent", i);
        return isPresent;
    }

    protected boolean isIspromotional(int i) {
        Object presentType = this.getValue("ispromotional", i);
        return presentType != null && !presentType.toString().isEmpty() && presentType.toString().compareTo("0") != 0;
    }

    private Object getEntryId(int parentIndex) {
        DynamicObject parentrow = this.getModel().getEntryRowEntity("itementry", parentIndex);
        return parentrow.getPkValue();
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control source = (Control)evt.getSource();
        switch (key = source.getKey()) {
            case "saler_alter": {
                BasedataEdit saler = (BasedataEdit)this.getControl("saler");
                saler.click();
                break;
            }
            case "region_alter": {
                BasedataEdit region = (BasedataEdit)this.getControl("region");
                region.click();
                break;
            }
            case "owner_alter": {
                BasedataEdit owner = (BasedataEdit)this.getControl("owner");
                owner.click();
                break;
            }
            case "customer_alter": {
                BasedataEdit customer = (BasedataEdit)this.getControl("customer");
                customer.click();
                break;
            }
            case "consigneeaddress_alter": {
                if (this.getCustomerF7PKValue() == null) {
                    this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8ba2\u8d27\u6e20\u9053", (String)"PurOrderEditPlugin_52", (String)"drp-dpa-formplugin", (Object[])new Object[0]));
                    return;
                }
                BasedataEdit consigneeaddress = (BasedataEdit)this.getControl("consigneeaddress");
                consigneeaddress.click();
                break;
            }
            case "receipt_alter": {
                BasedataEdit receipt = (BasedataEdit)this.getControl("receipt");
                receipt.click();
                break;
            }
            case "rebateaccounttype_alter": {
                BasedataEdit rebateaccounttype = (BasedataEdit)this.getControl("rebateaccounttype");
                rebateaccounttype.click();
                break;
            }
            case "switch_execution_btn": {
                this.switchExecutionClick();
                break;
            }
        }
    }

    private void switchExecutionClick() {
        BillList list = (BillList)this.getView().getControl(EXECUTIONS_LIST);
        Object executionid = list.getFocusRowPkId();
        if (executionid == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u4e00\u6761\u6267\u884c\u7ed3\u679c", (String)"PurOrderEditPlugin_53", (String)"drp-dpa-formplugin", (Object[])new Object[0]));
            return;
        }
        PromotionApiResult result = PromotionServiceHelper.getPromotionResult((String)this.getPromotionCacheKey());
        List executions = result.getExecutions();
        for (DynamicObject execution : executions) {
            if (!executionid.equals(execution.getPkValue())) continue;
            if (execution.getBoolean("isused")) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u672a\u4f7f\u7528\u7684\u6267\u884c\u7ed3\u679c\u8fdb\u884c\u5207\u6362\uff01", (String)"PurOrderEditPlugin_54", (String)"drp-dpa-formplugin", (Object[])new Object[0]));
                return;
            }
            this.switchPromotionExecution(execution.getDynamicObject("policy").getPkValue(), execution.getString("groupnumber").charAt(0));
            return;
        }
        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u5bf9\u5e94\u4fc3\u9500\u6267\u884c\u7ed3\u679c", (String)"PurOrderEditPlugin_55", (String)"drp-dpa-formplugin", (Object[])new Object[0]));
    }

    protected void itemStoreReSet(int index) {
        Object ownerId = this.getOwnerF7PKValue();
        DynamicObject item = this.getEntryF7Value("itementry", "item", index);
        Object unitId = this.getEntryF7PKValue("itementry", "unit", index);
        DynamicObject assistattr = this.getEntryF7Value("itementry", "assistattr", index);
        Object assistattrId = this.getEntryF7PKValue("itementry", "assistattr", index);
        Object entrywarehouseId = this.getEntryF7PKValue("itementry", "entrywarehouse", index);
        if (ownerId == null || item == null || unitId == null || !this.checkItemAttrValidate(item, assistattr)) {
            this.setValue("storeqty", BigDecimal.ZERO, index);
            return;
        }
        BigDecimal qty = ItemStoreUtil.queryItemStoreQty((Object)ownerId, (Object)item.getPkValue(), (Object)unitId, (Object)assistattrId, (Object)entrywarehouseId);
        this.setValue("storeqty", qty, index);
    }

    private boolean checkItemAttrValidate(DynamicObject item, DynamicObject assistAttr) {
        boolean hasAssistAttr = this.hasAssistAttr(item);
        if (hasAssistAttr) {
            if (assistAttr == null) {
                return false;
            }
            if (!ItemAttrUtil.hasAssistAttr((Object)item.getPkValue(), (Object)assistAttr.getPkValue())) {
                return false;
            }
        }
        return true;
    }

    protected void showStoreAP() {
        DynamicObjectCollection itementrys = this.getModel().getEntryEntity("itementry");
        if (itementrys != null) {
            for (int i = 0; i < itementrys.size(); ++i) {
                this.itemStoreReSet(i);
            }
        }
    }

    protected void setItemNoChangeEvent(Object itemId, int index) {
        this.setValueNoChangeEvent("item", itemId, index);
    }

    protected void setValueNoChangeEvent(String key, Object itemId, int index) {
        this.isChangeEvent = false;
        this.setValue(key, itemId, index, false);
        this.setItemMaterial(index);
        this.isChangeEvent = true;
    }

    protected void afterInitNewPresentRowData() {
        for (int i = 0; i < this.getModel().getEntryRowCount("itementry"); ++i) {
            if (!this.isPresent(i)) continue;
            this.afterInitNewPresentRowData(i);
        }
    }

    protected synchronized void synUpdatePresentRowData(int rowIndex) {
        try {
            for (int i = 0; i < this.getModel().getEntryRowCount("itementry"); ++i) {
                if (!this.isPresent(i)) continue;
                this.afterInitNewPresentRowData(i);
            }
        }
        catch (Exception e) {
            this.getView().showMessage(MessageFormat.format(ResManager.loadKDString((String)"\u7b2c{0}\u884c\u5546\u54c1\u53d6\u503c\u66f4\u65b0\u6709\u8bef\uff0c\u8bf7\u68c0\u67e5", (String)"PurOrderEditPlugin_65", (String)"drp-dpa-formplugin", (Object[])new Object[0]), rowIndex + 1));
        }
    }

    protected void afterInitNewPresentRowData(int index) {
        SaleOrderEntryType entryType = this.getEntryType(index);
        if (SaleOrderEntryType.COMBINATION != entryType) {
            DynamicObject item = this.getEntryF7Value("itementry", "item", index);
            if (item == null || item.get("id") == null || item.get("id").equals(0L)) {
                return;
            }
            String itemTitle = null;
            String thumbnail = null;
            if (item != null) {
                itemTitle = item.getString("name");
                if (StringUtils.isNotEmpty((String)item.getString("thumbnail"))) {
                    thumbnail = item.getString("thumbnail");
                }
            }
            this.setValue("itemimg", thumbnail, index);
            this.setValue("itemtitle", itemTitle, index);
            this.initRowUnits(index);
            this.initRowAssistUnits(index);
            this.setItemMaterial(index);
            this.getAlgorithm().calQtysByInitQty(index);
            this.itemStoreReSet(index);
        }
        this.initNewRowCommonData(index);
        this.initEntryPresentView(index);
    }

    private void initEntryPresentView() {
        for (int i = 0; i < this.getModel().getEntryRowCount("itementry"); ++i) {
            this.initEntryPresentView(i);
        }
    }

    private void initEntryPresentView(int index) {
        if (this.isPresent(index)) {
            if (this.isIspromotional(index)) {
                this.setUnEnable(index, new String[]{"item", "combitem", "unit", "assistattr", "qty", "alterqty", "assistunit", "assistqty", "alterassistqty", "actualtaxprice", "price", "taxrate", "taxprice", "discount", "discounttype", "discountamount", "itemamount"});
            } else {
                this.setUnEnable(index, new String[]{"actualtaxprice", "price", "taxrate", "taxprice", "discount", "discounttype", "discountamount", "itemamount"});
            }
        }
    }

    private void addExecutionListDataProvider() {
        BillList list = (BillList)this.getView().getControl(EXECUTIONS_LIST);
        list.addCreateListDataProviderListener(new CreateListDataProviderListener(){

            public void createListDataProvider(BeforeCreateListDataProviderArgs e) {
                e.setListDataProvider((IListDataProvider)new ListDataProvider(){

                    public DynamicObjectCollection getData(int arg0, int arg1) {
                        DynamicObjectCollection col = super.getData(arg0, arg1);
                        col.clear();
                        if (!SysParamsUtil.isUsePromotion()) {
                            return col;
                        }
                        PromotionApiResult result = PromotionServiceHelper.getPromotionResult((String)PurOrderEditPlugin.this.getPromotionCacheKey());
                        List executionlist = result.getExecutions();
                        PurOrderEditPlugin.this.initPresentBagButton(executionlist);
                        if (executionlist.isEmpty()) {
                            return col;
                        }
                        for (DynamicObject execution : executionlist) {
                            for (DynamicObject entry : execution.getDynamicObjectCollection("entryentity")) {
                                DynamicObject queryobj = col.addNew();
                                queryobj.set("id", execution.getPkValue());
                                queryobj.set("policy_id", this.getF7PKValue(execution, "policy"));
                                queryobj.set("isused", (Object)execution.getBoolean("isused"));
                                queryobj.set("groupnumber", (Object)execution.getString("groupnumber"));
                                queryobj.set("id", execution.getPkValue());
                                queryobj.set("item_id", this.getF7PKValue(entry, "item"));
                                queryobj.set("combination_id", this.getF7PKValue(entry, "combination"));
                                DynamicObject unit = entry.getDynamicObject("unit");
                                queryobj.set("unit_id", unit == null ? Long.valueOf(0L) : unit.getPkValue());
                                queryobj.set("attr_id", this.getF7PKValue(entry, "attr"));
                                queryobj.set("entryentity.resultname", entry.get("resultname"));
                                queryobj.set("entryentity.amountdiff", (Object)entry.getBigDecimal("amountdiff").setScale(2, RoundingMode.HALF_UP).stripTrailingZeros());
                                queryobj.set("entryentity.pricediff", (Object)entry.getBigDecimal("pricediff").setScale(2, RoundingMode.HALF_UP).stripTrailingZeros());
                                queryobj.set("entryentity.type", (Object)entry.getString("type"));
                                queryobj.set("entryentity.id", entry.getPkValue());
                                queryobj.set("entryentity.qty", (Object)entry.getBigDecimal("qty").setScale(unit == null ? 0 : unit.getInt("precision"), RoundingMode.HALF_UP));
                            }
                        }
                        BusinessDataServiceHelper.loadRefence((Object[])col.toArray(), (IDataEntityType)((DynamicObject)col.get(0)).getDataEntityType());
                        return col;
                    }

                    public Object getF7PKValue(DynamicObject obj, String f7Name) {
                        DynamicObject val = obj.getDynamicObject(f7Name);
                        if (val == null) {
                            return 0L;
                        }
                        return val.getPkValue();
                    }
                });
            }
        });
    }

    public void beforeClosed(BeforeClosedEvent e) {
        if (!SysParamsUtil.isUsePromotion()) {
            PromotionServiceHelper.removePromotionCache((String)this.getPromotionCacheKey());
        }
        super.beforeClosed(e);
    }

    public List<String> getUnCheckField() {
        ArrayList<String> uncheckFieldList = new ArrayList<String>();
        uncheckFieldList.add("promotioncachekey");
        uncheckFieldList.add(LABEL_BILLNO);
        uncheckFieldList.add(LABEL_ORDERDATE);
        uncheckFieldList.add(LABEL_ARRIVALDATE);
        uncheckFieldList.add(LABEL_CONFIRMARRIVALDATE);
        uncheckFieldList.add(LABEL_ORDERREMARK);
        uncheckFieldList.add(LABEL_ORDERREMARK);
        uncheckFieldList.add("usablebalance");
        uncheckFieldList.add("usedbalance");
        uncheckFieldList.add("totalrebateamount");
        uncheckFieldList.add("totalpromotionamount");
        uncheckFieldList.add("totaldiscountamount");
        uncheckFieldList.add("rebatebalance");
        uncheckFieldList.add("amounttobepaid");
        uncheckFieldList.add("billno");
        uncheckFieldList.add("receivedamount");
        return uncheckFieldList;
    }

    protected void switchPromotionExecution(Object promotionid, char groupnumber) {
        this.getAlgorithm().calBySwitchPromotionExecutions(promotionid, groupnumber);
        this.afterInitNewPresentRowData();
        this.refreshViewByPromotion();
        this.initTotalEntry();
    }

    protected void refreshExecutionList() {
        BillList list = (BillList)this.getView().getControl(EXECUTIONS_LIST);
        if (list != null) {
            list.refresh();
        }
    }

    protected void initPromotionCacheKey() {
        if (SysParamsUtil.isUsePromotion()) {
            this.getPromotionCacheKey();
        }
    }

    protected String getPromotionCacheKey() {
        String key = this.getStringValue("promotioncachekey");
        if (StringUtils.isEmpty((String)key)) {
            key = this.getPageCache().get("promotioncachekey");
            if (StringUtils.isEmpty((String)key)) {
                key = this.getView().getPageId();
                this.getPageCache().put("promotioncachekey", key);
            }
            this.setValue("promotioncachekey", key);
        } else {
            this.getPageCache().put("promotioncachekey", key);
        }
        return key;
    }

    protected void matchPromotion() {
        if (!SysParamsUtil.isUsePromotion()) {
            return;
        }
        if (this.getOwnerF7PKValue() == null || this.getCustomerF7PKValue() == null) {
            return;
        }
        PromotionApiResult result = PromotionServiceHelper.match((String)this.getPromotionCacheKey(), (PromotionOrder)this.getAlgorithm().buildPromotionOrder());
        this.initPresentBagButton(result.getExecutions());
        this.refreshExecutionList();
        if (this.isReacquirePromotion()) {
            this.initAvailablePromotion();
        }
    }

    protected void executePromotion() {
        this.executePromotion(true);
    }

    protected void executePromotion(boolean isInitModel) {
        this.getAlgorithm().calByExecutePromotion();
        this.afterInitNewPresentRowData();
        this.refreshViewByPromotion();
        if (isInitModel) {
            // empty if block
        }
    }

    protected void refreshViewByPromotion() {
        this.initEntryPresentView();
        this.refreshExecutionList();
    }

    protected BigDecimal loadLowestPrice(Object ownerPK, Object customerPK, Object itemPK, Object unitPK, Object assistattrPk, BigDecimal qty, Date date) {
        return PriceUtil.getLowestPrice((Object)ownerPK, (Object)customerPK, (Object)itemPK, (Object)unitPK, (Object)assistattrPk, (BigDecimal)qty, (Date)date);
    }

    public void setValue(String key, Object value) {
        this.setValue(key, value, false);
    }

    public void setValue(String key, Object value, int i) {
        this.setValue(key, value, i, false);
    }

    public void setRowValue(String colName, Object value, int rowIndex) {
        this.setValue(colName, value, rowIndex, false);
    }

    protected void setIsPresentEnable(int rowIndex, boolean enabled) {
        this.getView().setEnable(Boolean.valueOf(enabled), rowIndex, new String[]{"ispresent"});
    }

    protected void isPresentChange(int rowIndex, Object newValue) {
        if (((Boolean)newValue).booleanValue()) {
            this.setValue("price", 0, rowIndex);
            this.setValue("itemamount", 0, rowIndex);
            this.setValue("taxprice", 0, rowIndex);
            this.setValue("discountamount", 0, rowIndex);
            this.setValue("taxrate", 0, rowIndex);
            this.setValue("taxrateid", null, rowIndex);
            this.setValue("promotionamount", 0, rowIndex);
            this.setValue("entryusedrebate", 0, rowIndex);
            this.setValue("rebateamount", 0, rowIndex);
            this.setValue("actualtaxprice", 0, rowIndex);
            this.setValue("taxamount", 0, rowIndex);
            this.setValue("ispromotional", "0", rowIndex);
            this.setValue("custchangeprice", Boolean.TRUE);
        } else {
            this.setEnable(rowIndex, new String[]{"item", "combitem", "unit", "assistattr", "qty", "alterqty", "assistunit", "assistqty", "alterassistqty", "actualtaxprice", "price", "taxrate", "taxprice", "discount", "discounttype", "discountamount", "itemamount"});
            this.setValue("custchangeprice", Boolean.FALSE);
            this.setValue("ispromotional", "", rowIndex);
            this.newTaxrateSet(rowIndex);
            this.initEntryByHasTax();
            this.initEntryByDiscountType();
        }
        this.getAlgorithm().reCalFields(rowIndex, true);
        this.synUpdatePresentRowData(rowIndex);
        this.initTotalEntry();
        this.recalBalance();
    }

    protected void setItemMaterial(int index) {
        DynamicObject item = this.getEntryF7Value("itementry", "item", index);
        if (item == null) {
            return;
        }
        DynamicObject material = item.getDynamicObject("material");
        this.setValue("material", material, index);
    }

    private void showSeletPresent() {
        HashMap<String, String> para = new HashMap<String, String>(1);
        para.put("formId", "dpm_selectpresent");
        FormShowParameter showParameter = FormShowParameter.createFormShowParameter(para);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("key", (Object)this.getPromotionCacheKey());
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, PRESENTBAG));
        this.getView().showForm(showParameter);
    }

    private void showSelectSubitem(BeforeDoOperationEventArgs e) {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("itementry");
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows == null || selectRows.length == 0) {
            e.cancel = true;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u52fe\u9009\u4f7f\u7528\u5b50\u4ef6\u7ec4\u7684\u5546\u54c1\u3002", (String)"PurOrderEditPlugin_81", (String)"drp-dpa-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObjectCollection itemEntry = this.getModel().getEntryEntity("itementry");
        boolean isSelectSubItem = false;
        StringBuilder indexs = new StringBuilder();
        StringBuilder itemname = new StringBuilder();
        HashSet<Object> combitemids = new HashSet<Object>();
        for (int i : selectRows) {
            DynamicObject combitem;
            DynamicObject entry = (DynamicObject)itemEntry.get(i);
            if (!SaleOrderEntryType.COMBINATION.getFlagStr().equals(entry.getString("entrytype")) || (combitem = entry.getDynamicObject("combitem")) == null || !combitem.getBoolean("issubgroup")) continue;
            if (combitemids.contains(combitem.getPkValue())) {
                itemname.append(combitem.getString("name"));
                itemname.append('\u3001');
            } else {
                combitemids.add(combitem.getPkValue());
            }
            isSelectSubItem = true;
            indexs.append(i);
            indexs.append(',');
        }
        if (!isSelectSubItem) {
            e.cancel = true;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u9009\u5546\u54c1\u672a\u80fd\u4f7f\u7528\u5b50\u4ef6\u7ec4\uff0c\u8bf7\u91cd\u65b0\u52fe\u9009\u3002", (String)"PurOrderEditPlugin_82", (String)"drp-dpa-formplugin", (Object[])new Object[0]));
            return;
        }
        if (itemname.length() > 0) {
            e.cancel = true;
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5df2\u9009\u5546\u54c1\u5b58\u5728\u76f8\u540c\u7ec4\u5408\u54c1%s\uff0c\u8bf7\u5206\u5f00\u7ef4\u62a4\u3002", (String)"PurOrderEditPlugin_83", (String)"drp-dpa-formplugin", (Object[])new Object[0]), itemname.substring(0, itemname.length() - 1)));
            return;
        }
        HashMap<String, String> para = new HashMap<String, String>(1);
        para.put("formId", "dbd_subitem_select");
        FormShowParameter showParameter = FormShowParameter.createFormShowParameter(para);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("indexs", (Object)indexs.toString());
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, SELECTSUBITEM));
        this.getView().showForm(showParameter);
    }

    private void setSubItemInfo(ClosedCallBackEvent e) {
        Object data = e.getReturnData();
        if (data == null) {
            return;
        }
        if (data instanceof HashMap) {
            HashMap subItemInfos = (HashMap)data;
            if (subItemInfos.size() == 0) {
                return;
            }
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl("itementry");
            int[] selectRows = entryGrid.getSelectRows();
            ArrayList<Object> entryIds = new ArrayList<Object>();
            DynamicObjectCollection itemEntry = this.getModel().getEntryEntity("itementry");
            for (int i : selectRows) {
                DynamicObject combitem;
                DynamicObject entry = (DynamicObject)itemEntry.get(i);
                if (!SaleOrderEntryType.COMBINATION.getFlagStr().equals(entry.getString("entrytype")) || (combitem = entry.getDynamicObject("combitem")) == null || !combitem.getBoolean("issubgroup")) continue;
                entryIds.add(entry.getPkValue());
            }
            Object object = entryIds.iterator();
            block1: while (object.hasNext()) {
                Object entryId = object.next();
                for (int j = 0; j < itemEntry.size(); ++j) {
                    DynamicObject entry = (DynamicObject)itemEntry.get(j);
                    if (!entry.getPkValue().equals(entryId)) continue;
                    this.combItemSelectSubItem(j, subItemInfos);
                    itemEntry = this.getModel().getEntryEntity("itementry");
                    continue block1;
                }
            }
            this.initTotalEntry();
            this.recalBalance();
        }
    }

    protected void combItemSelectSubItem(int index, Map<Long, BigDecimal> subItemInfos) {
        this.clearCombSonRow(index);
        Object combId = this.getEntryF7PKValue("itementry", "combitem", index);
        if (combId != null) {
            DynamicObject itemCombination = BusinessDataServiceHelper.loadSingle((Object)combId, (String)"dpm_item_combination", (String)"issubgroup,totalamount,pricemode,itemdetail,itemdetail.item,itemdetail.unit,itemdetail.attr,itemdetail.qty,itemdetail.price,itemdetail.amount,itemdetail.proportion,itemdetail.isdefault,itemdetail.subgroup");
            this.createNewSubItemRows(index, itemCombination, subItemInfos);
            if (this.isIspromotional(index)) {
                this.getAlgorithm().calAfterExecutePromotion();
            } else {
                this.setCombPrice(index, itemCombination);
                this.getAlgorithm().calByCombEntryInit(index);
            }
        }
    }

    private void createNewSubItemRows(int parentIndex, DynamicObject itemCombination, Map<Long, BigDecimal> subItemInfos) {
        String parentId = this.getEntryId(parentIndex).toString();
        boolean isIspromotional = this.isIspromotional(parentIndex);
        DynamicObjectCollection itemdetails = itemCombination.getDynamicObjectCollection("itemdetail");
        HashMap<Integer, DynamicObject> iteminfos = new HashMap<Integer, DynamicObject>();
        for (DynamicObject itemdetail : itemdetails) {
            if (!itemdetail.getBoolean("isdefault")) continue;
            iteminfos.put(itemdetail.getInt("subgroup"), itemdetail);
        }
        String pricemode = itemCombination.getString("pricemode");
        boolean issubgroup = itemCombination.getBoolean("issubgroup");
        int i = parentIndex;
        Object detailid = null;
        BigDecimal parentQty = BigDecimalUtil.getNullToZero((DynamicObject)this.getAlgorithm().getEntry(parentIndex), (String)"qty");
        for (int j = 0; j < itemdetails.size(); ++j) {
            DynamicObject itemdetail = (DynamicObject)itemdetails.get(j);
            detailid = itemdetail.getPkValue();
            if (issubgroup && !subItemInfos.containsKey(itemdetail.getPkValue())) continue;
            this.getAlgorithm().insertEntry(++i);
            this.setValueNoChangeEvent("combitem", itemCombination.get("id"), i);
            DynamicObject item = itemdetail.getDynamicObject("item");
            Object itemId = null;
            Object baseunitId = null;
            if (!(item instanceof DynamicObject)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ec4\u5408\u5546\u54c1\u6570\u636e\u6709\u8bef\uff0c\u8bf7\u68c0\u67e5\u7ec4\u5408\u5546\u54c1\u4fe1\u606f\u6216\u91cd\u65b0\u9009\u62e9\u7ec4\u5408\u5546\u54c1\u3002", (String)"PurOrderEditPlugin_71", (String)"drp-dpa-formplugin", (Object[])new Object[0]));
                continue;
            }
            DynamicObject itemObject = item;
            itemId = itemObject.get("id");
            baseunitId = itemObject.get("baseunit.id");
            DynamicObject unit = itemdetail.getDynamicObject("unit");
            Object unitId = null;
            if (unit == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ec4\u5408\u5546\u54c1\u6570\u636e\u6709\u8bef\uff0c\u8bf7\u68c0\u67e5\u7ec4\u5408\u5546\u54c1\u4fe1\u606f\u6216\u91cd\u65b0\u9009\u62e9\u7ec4\u5408\u5546\u54c1\u3002", (String)"PurOrderEditPlugin_71", (String)"drp-dpa-formplugin", (Object[])new Object[0]));
                continue;
            }
            unitId = unit.get("id");
            DynamicObject attr = itemdetail.getDynamicObject("attr");
            BigDecimal qty = subItemInfos.get(detailid);
            this.setItemNoChangeEvent(itemId, i);
            this.setValue("entrytype", SaleOrderEntryType.COMBINATION_SON.getFlagStr(), i);
            this.setValue("parententryid", parentId, i);
            this.setValue("combitementeryid", itemdetail.get("id"), i);
            this.setValue("baseunit", baseunitId, i, false);
            this.setValue("unit", unitId, i, false);
            this.setValue("assistattr", attr, i, false);
            this.setValue("combbaseqty", qty, i, false);
            this.afterInitNewCombItemRowData(i);
            if (isIspromotional) {
                qty = qty.multiply(parentQty).setScale(unit.getInt("precision"), 4);
                this.setValue("alterqty", qty, i, false);
                this.setValue("qty", qty, i, false);
                this.setValue("ispresent", Boolean.TRUE, i, false);
                this.setValue("ispromotional", "1", i, false);
                this.setValue("taxprice", BigDecimal.ZERO, i, false);
                this.setValue("custchangeprice", Boolean.TRUE, i, false);
                this.setValue("primamount", BigDecimal.ZERO, i, false);
                this.setValue("promotionamount", BigDecimal.ZERO, i, false);
                continue;
            }
            this.setValue("ispromotional", "", i, false);
            BigDecimal primprice = BigDecimal.ZERO;
            int subgroup = itemdetail.getInt("subgroup");
            DynamicObject dynamicObject = (DynamicObject)iteminfos.get(subgroup);
            if (dynamicObject != null) {
                primprice = this.getAlgorithm().getSysPrice(this.getAlgorithm().getEntry(i), new DetailItemInfo(DynamicObjectUtils.getDynamicObjectID((DynamicObject)dynamicObject, (String)"item"), DynamicObjectUtils.getDynamicObjectID((DynamicObject)dynamicObject, (String)"unit"), DynamicObjectUtils.getDynamicObjectID((DynamicObject)dynamicObject, (String)"attr")), qty);
            }
            this.setValue("primprice", primprice, i, false);
            BigDecimal entryprice = BigDecimal.ZERO;
            if ("0".equals(pricemode)) {
                entryprice = primprice;
                this.setValue("custchangeprice", Boolean.FALSE, i);
            } else {
                entryprice = itemdetail.getBigDecimal("price");
                this.setValue("custchangeprice", Boolean.TRUE, i);
            }
            if (this.hasTax()) {
                this.setValue("taxprice", entryprice, i, false);
            } else {
                this.setValue("price", entryprice, i, false);
            }
            this.newTaxrateSet(i);
            this.setValue("discount", 0, i);
            this.setValue("discounttype", null, i);
            this.setValue("discountamount", 0, i);
            this.initCombSonEntryView(i);
        }
    }
}

