/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dpa.formplugin.bill.saleorder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.MobileBillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.MobileListShowParameter;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.drp.mdr.common.constants.SaleOrderEntryType;
import kd.drp.mdr.common.status.SaleOrderStatus;
import kd.drp.mdr.common.util.CustomerParamsUtil;
import kd.drp.mdr.common.util.ItemStoreUtil;
import kd.drp.mdr.common.util.OperationUtil;
import kd.drp.mdr.common.util.UserUtil;
import kd.drp.mdr.formplugin.MdrListMobPlugin;
import kd.drp.mdr.mobile.model.FormModel;
import org.apache.commons.lang.StringUtils;

public class PurOrderListMobPlugin
extends MdrListMobPlugin {
    protected static final String F_billno = "billno";
    public static final String TO_EVALUATE = "toevaluate";
    public static final String TO_SIGN = "tosign";
    public static final String TO_CHANGE = "change";
    public static final String ORDERSTATUS = "orderstatus";
    public static final String BAR_MODIFY = "bar_modify";
    public static final String BAR_DELETE = "bar_delete";
    public static final String BAR_EVALUATE = "bar_evaluate";
    public static final String BAR_SIGN = "bar_sign";
    public static final String BAR_CONFIRMCHANGE = "bar_confirmchange";
    public static final String BAR_UNSIGN = "bar_unsign";
    public static final String BAR_RETURN = "bar_return";
    public static final String MOBILESEARCHAP = "mobilesearchap";
    public static final String BUT_DEBT = "butdebt";
    public static final String ORDER_EVALUATE = "orderevaluate";
    protected static final String TO_INVALID = "invalid";
    protected static final String TO_VALID = "valid";
    protected static final String RE_FRESH = "refresh";
    protected static final String UNSUBMIT = "unsubmit";
    protected static final String UNAUDIT = "unaudit";
    protected static final String DELETE = "delete";
    protected static final String WITHDRAW = "withdraw";
    protected static final String CONFIRMCHANGE = "confirmchange";
    protected static final String SUBMIT = "submit";
    private static final String OP_CHECKSUBMIT = "checksubmit";

    public void setFilter(SetFilterEvent e) {
        this.createFilter(e);
    }

    private void createFilter(SetFilterEvent e) {
        List fs = e.getQFilters();
        fs.add(new QFilter("customer", "in", (Object)UserUtil.getOwnerIDs()));
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BUT_DEBT});
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        e.getParameter().setStatus(OperationStatus.VIEW);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (BUT_DEBT.equals(key)) {
            this.showDebt();
        }
    }

    private void showDebt() {
        Object id = this.getCurrentSelectedOrderId();
        QFilter filter = new QFilter("id", "=", id);
        QFilter[] filters = new QFilter[]{filter};
        DynamicObject saleorderInfo = BusinessDataServiceHelper.loadSingle((String)"bbc_saleorder", (String)"id,orderstatus,paystatus", (QFilter[])filters);
        if (saleorderInfo != null) {
            if (!("C".equals(saleorderInfo.get(ORDERSTATUS)) || "D".equals(saleorderInfo.get(ORDERSTATUS)) || "E".equals(saleorderInfo.get(ORDERSTATUS)) || "G".equals(saleorderInfo.get(ORDERSTATUS)) || "H".equals(saleorderInfo.get(ORDERSTATUS)) || "J".equals(saleorderInfo.get(ORDERSTATUS)))) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5f85\u5206\u8d27\u3001\u5f85\u53d1\u8d27\u3001\u90e8\u5206\u53d1\u8d27\u3001\u5f85\u6536\u8d27\u3001\u5df2\u6536\u8d27\u3001\u5df2\u5b8c\u6210\u7684\u5355\u636e\u624d\u80fd\u5173\u8054\u751f\u6210\uff01", (String)"PurOrderListMobPlugin_0", (String)"drp-dpa-formplugin", (Object[])new Object[0]));
            }
        } else {
            return;
        }
        MobileBillShowParameter parameter = new MobileBillShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Floating);
        parameter.setFormId("mdr_money_debt_mob");
        parameter.setStatus(OperationStatus.ADDNEW);
        parameter.setCustomParam("orderid", id);
        this.getView().showForm((FormShowParameter)parameter);
    }

    private boolean getOperationResult(AfterDoOperationEventArgs e) {
        OperationResult result = e.getOperationResult();
        return result == null || result.isSuccess();
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        String key = e.getOperateKey();
        if (this.getOperationResult(e)) {
            switch (key) {
                case "change": {
                    this.getView().invokeOperation("modify");
                    break;
                }
                case "tosign": {
                    this.toSignPage();
                    break;
                }
                case "toevaluate": {
                    this.toEvaluate();
                    break;
                }
                case "confirmchange": {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u786e\u8ba4\u53d8\u66f4\u6210\u529f", (String)"PurOrderListMobPlugin_1", (String)"drp-dpa-formplugin", (Object[])new Object[0]));
                    break;
                }
                case "orderevaluate": {
                    this.toOrderEvaluate();
                    break;
                }
            }
        }
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        String key;
        super.beforeDoOperation(e);
        switch (key = ((AbstractOperate)e.getSource()).getOperateKey()) {
            case "invalid": {
                Object selectedOrderId = this.getCurrentSelectedOrderId();
                HashMap<String, Object> param = new HashMap<String, Object>();
                DynamicObject order = BusinessDataServiceHelper.loadSingle((Object)selectedOrderId, (String)"mdr_purorder");
                if (!SaleOrderStatus.TEMP_SAVE.getFlagStr().equals(order.getString(ORDERSTATUS))) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u6682\u5b58\u72b6\u6001\u7684\u5355\u636e\u624d\u80fd\u4f5c\u5e9f\uff01", (String)"PurOrderListMobPlugin_2", (String)"drp-dpa-formplugin", (Object[])new Object[0]));
                }
                param.put("orderid", selectedOrderId);
                this.showForm("mdr_saleorder_invalidmob", param, new CloseCallBack((IFormPlugin)this, TO_INVALID), ShowType.Floating);
                e.setCancel(true);
                break;
            }
            case "unsubmit": 
            case "unaudit": 
            case "delete": 
            case "withdraw": 
            case "valid": {
                FormOperate op = (FormOperate)e.getSource();
                op.getOption().setVariableValue("ismob", "true");
                break;
            }
            case "checksubmit": {
                this.orderInventoryCheck();
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String key;
        switch (key = e.getActionId()) {
            case "invalid": {
                Map param = (Map)e.getReturnData();
                if (param == null || param.get("isconfirm") == null) {
                    return;
                }
                DynamicObject order = BusinessDataServiceHelper.loadSingle(param.get("orderid"), (String)"bbc_saleorder");
                Object detail = param.get("detail");
                order.set("invalidreason", detail);
                OperationUtil.invokeOperation((DynamicObject)order, (String)TO_INVALID);
                this.getView().showMessage(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f", (String)"PurOrderListMobPlugin_3", (String)"drp-dpa-formplugin", (Object[])new Object[0]));
                this.getListView().refresh();
                break;
            }
            case "unsubmit": 
            case "unaudit": 
            case "delete": 
            case "withdraw": 
            case "valid": {
                Map param = (Map)e.getReturnData();
                if (param == null || param.get("isconfirm") == null || !"true".equals(param.get("isconfirm"))) break;
                String remark = (String)param.get("remark");
                String orderid = (String)param.get("orderid");
                DynamicObject order = BusinessDataServiceHelper.loadSingle((Object)orderid, (String)"bbc_saleorder");
                order.set("operateremark", (Object)remark);
                OperationUtil.invokeOperation((DynamicObject)order, (String)key);
                this.getView().showMessage(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f", (String)"PurOrderListMobPlugin_3", (String)"drp-dpa-formplugin", (Object[])new Object[0]));
                this.getListView().refresh();
            }
        }
        this.getListView().refresh();
    }

    private void toEvaluate() {
        MobileFormShowParameter parameter = new MobileFormShowParameter();
        parameter.setFormId("mdr_evaluate_mobview");
        parameter.getOpenStyle().setShowType(ShowType.Floating);
        parameter.setCustomParam("orderid", this.getCurrentSelectedOrderId());
        this.getView().showForm((FormShowParameter)parameter);
    }

    protected void toOrderEvaluate() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Object oderid = this.getCurrentSelectedOrderId();
        DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)oderid, (String)"dpa_purorder");
        map.put("customerid", obj.getDynamicObject("customer").getPkValue());
        map.put("ownerid", obj.getDynamicObject("owner").getPkValue());
        map.put("orderid", oderid);
        QFilter qFilter = new QFilter("billnumber", "=", oderid);
        DynamicObject orderEvaluate = BusinessDataServiceHelper.loadSingle((String)"mdr_bill_evaluate_manage", (String)"id", (QFilter[])qFilter.toArray());
        if (orderEvaluate != null && orderEvaluate.get("id") != null && !orderEvaluate.get("id").equals(0L)) {
            map.put("orderevalid", orderEvaluate.get("id"));
        }
        FormModel formModel = new FormModel("mdr_order_evaluate_op_mob", ResManager.loadKDString((String)"\u8ba2\u5355\u8bc4\u4ef7", (String)"PurOrderListMobPlugin_4", (String)"drp-dpa-formplugin", (Object[])new Object[0]), "5");
        formModel.setCustomParam(map);
        formModel.showPage((AbstractFormPlugin)this);
    }

    protected void toDeliveryPage() {
        throw new KDBizException(ResManager.loadKDString((String)"\u8981\u8d27\u65b9\u6682\u4e0d\u5141\u8bb8\u53d1\u8d27", (String)"PurOrderListMobPlugin_5", (String)"drp-dpa-formplugin", (Object[])new Object[0]));
    }

    private void toSignPage() {
        MobileListShowParameter parameter = new MobileListShowParameter();
        parameter.setFormId("bos_moblist");
        parameter.setBillFormId("bbc_delivery_record");
        parameter.getOpenStyle().setShowType(ShowType.Floating);
        parameter.setCustomParam("orderid", this.getCurrentSelectedOrderId());
        this.getView().showForm((FormShowParameter)parameter);
    }

    protected Object[] getSelectedOrderIds(boolean isSingle) {
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        Object[] ids = selectedRows.getPrimaryKeyValues();
        int size = ids.length;
        if (size == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u8bb0\u5f55\uff01", (String)"PurOrderListMobPlugin_6", (String)"drp-dpa-formplugin", (Object[])new Object[0]));
        }
        if (isSingle && size > 1) {
            throw new KDBizException(ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u62e9\u4e00\u6761\u8bb0\u5f55\uff01", (String)"PurOrderListMobPlugin_7", (String)"drp-dpa-formplugin", (Object[])new Object[0]));
        }
        return ids;
    }

    protected Object getCurrentSelectedOrderId() {
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRow selectedRows = billList.getCurrentSelectedRowInfo();
        Object id = selectedRows.getPrimaryKeyValue();
        return id;
    }

    private void orderInventoryCheck() {
        Object selectedOrderId = this.getCurrentSelectedOrderId();
        DynamicObject order = BusinessDataServiceHelper.loadSingle((Object)selectedOrderId, (String)"mdr_purorder");
        HashMap keyMap = new HashMap();
        HashMap errorInfo = new HashMap();
        List billnos = new ArrayList();
        DynamicObject currentOwner = order.getDynamicObject("owner");
        Object ownerId = currentOwner.get("id");
        String isallow = CustomerParamsUtil.isAllowOver((Object)ownerId);
        if (!isallow.equals("0")) {
            String billno = order.getString(F_billno);
            DynamicObjectCollection itemEntryCollection = order.getDynamicObjectCollection("itementry");
            StringBuilder sb = new StringBuilder();
            for (DynamicObject itemEntry : itemEntryCollection) {
                DynamicObject wareHouseVal;
                DynamicObject assistattrVal;
                DynamicObject unitVal;
                String entrytype = itemEntry.getString("entrytype");
                if (SaleOrderEntryType.COMBINATION.getFlagStr().equals(entrytype)) continue;
                sb = new StringBuilder();
                Object itemId = null;
                Object unitId = null;
                Object assistattrId = null;
                Object wareHouseId = null;
                String seq = itemEntry.getString("seq");
                DynamicObject itemVal = itemEntry.getDynamicObject("item");
                if (itemVal != null) {
                    itemId = itemVal.get("id");
                    sb.append(itemId);
                }
                if ((unitVal = itemEntry.getDynamicObject("unit")) != null) {
                    unitId = unitVal.get("id");
                    sb.append(unitId);
                }
                if ((assistattrVal = itemEntry.getDynamicObject("assistattr")) != null) {
                    assistattrId = assistattrVal.get("id");
                    sb.append(assistattrId);
                }
                if ((wareHouseVal = itemEntry.getDynamicObject("entrywarehouse")) != null) {
                    wareHouseId = wareHouseVal.get("id");
                    sb.append(wareHouseId);
                }
                int alterqty = itemEntry.getInt("alterqty");
                DynamicObject storeObject = ItemStoreUtil.queryItemStore((Object)ownerId, (Object)itemId, (Object)unitId, (Object)assistattrId, (Object)wareHouseId);
                if (!keyMap.containsKey(sb.toString())) {
                    int qty = storeObject.getInt("qty") - storeObject.getInt("orderqty");
                    LinkedHashMap<String, Integer> map = new LinkedHashMap<String, Integer>();
                    map.put(seq, qty - alterqty);
                    keyMap.put(sb.toString(), map);
                    if (qty >= alterqty) continue;
                    billnos = !errorInfo.containsKey(isallow) ? new ArrayList() : (List)errorInfo.get(isallow);
                    billnos.add(billno);
                    errorInfo.put(isallow, billnos);
                    continue;
                }
                LinkedHashMap map = (LinkedHashMap)keyMap.get(sb.toString());
                Map.Entry entry = this.getTail(map);
                int qty = (Integer)entry.getValue();
                map.put(seq, qty - alterqty);
                if (qty >= alterqty) continue;
                billnos = !errorInfo.containsKey(isallow) ? new ArrayList() : (List)errorInfo.get(isallow);
                billnos.add(billno);
                errorInfo.put(isallow, billnos);
            }
        }
        if (errorInfo.size() > 0) {
            List err = (List)errorInfo.get("1");
            if (err != null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8ba2\u5355\u7f16\u53f7\u4e3a\uff1a", (String)"PurOrderListMobPlugin_8", (String)"drp-dpa-formplugin", (Object[])new Object[0]) + StringUtils.join((Collection)err, (String)"\u3001") + ResManager.loadKDString((String)"\u7684\u8ba2\u5355\u4e0b\u5355\u6570\u91cf\u8d85\u51fa\u5e93\u5b58\u53ef\u7528\u6570\u91cf\uff01", (String)"PurOrderListMobPlugin_9", (String)"drp-dpa-formplugin", (Object[])new Object[0]));
            } else {
                String error = ResManager.loadKDString((String)"\u8ba2\u5355\u7f16\u53f7\u4e3a\uff1a", (String)"PurOrderListMobPlugin_8", (String)"drp-dpa-formplugin", (Object[])new Object[0]) + StringUtils.join((Collection)((Collection)errorInfo.get("2")), (String)"\u3001") + ResManager.loadKDString((String)"\u7684\u8ba2\u5355\u4e0b\u5355\u6570\u91cf\u8d85\u51fa\u5e93\u5b58\u53ef\u7528\u6570\u91cf\uff01", (String)"PurOrderListMobPlugin_9", (String)"drp-dpa-formplugin", (Object[])new Object[0]);
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("submitCallBack", (IFormPlugin)this);
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5b58\u5728\u4e0b\u5355\u6570\u91cf\u8d85\u51fa\u5e93\u5b58\u53ef\u7528\u6570\u91cf\u7684\u5355\u636e\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"PurOrderListMobPlugin_10", (String)"drp-dpa-formplugin", (Object[])new Object[0]), error, MessageBoxOptions.YesNo, ConfirmTypes.Save, confirmCallBacks);
            }
        } else {
            this.getView().invokeOperation(SUBMIT);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        if ("submitCallBack".equals(messageBoxClosedEvent.getCallBackId())) {
            if (messageBoxClosedEvent.getResult().equals((Object)MessageBoxResult.Yes)) {
                this.getView().invokeOperation(SUBMIT);
            } else {
                return;
            }
        }
    }

    public <K, V> Map.Entry<K, V> getTail(LinkedHashMap<K, V> map) {
        Iterator<Map.Entry<K, V>> iterator = map.entrySet().iterator();
        Map.Entry<K, V> tail = null;
        while (iterator.hasNext()) {
            tail = iterator.next();
        }
        return tail;
    }
}

