/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dpa.formplugin.bill.saleorder;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.coderule.api.CodeRuleInfo;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.entity.EntryType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.MobileListShowParameter;
import kd.bos.list.events.CreateListDataProviderListener;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.events.ListRowClickListener;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.drp.dpa.common.algorithm.SaleOrderAlgorithm;
import kd.drp.dpa.common.algorithm.SaleOrderMobAlgorithm;
import kd.drp.mdr.common.StringUtils;
import kd.drp.mdr.common.constants.SaleOrderEntryType;
import kd.drp.mdr.common.f7.F7Utils;
import kd.drp.mdr.common.model.CheckResult;
import kd.drp.mdr.common.model.dpm.LimitResult;
import kd.drp.mdr.common.model.dpm.LimitResultEntry;
import kd.drp.mdr.common.model.dpm.PromotionApiResult;
import kd.drp.mdr.common.model.dpm.PromotionOrder;
import kd.drp.mdr.common.status.EnumUtil;
import kd.drp.mdr.common.status.PhoneType;
import kd.drp.mdr.common.status.SaleOrderStatus;
import kd.drp.mdr.common.util.BalanceUtil;
import kd.drp.mdr.common.util.BillTypeParameterHelper;
import kd.drp.mdr.common.util.BizValidateUtils;
import kd.drp.mdr.common.util.ConsigneeAddressUtil;
import kd.drp.mdr.common.util.CustomerParamsUtil;
import kd.drp.mdr.common.util.CustomerSalerUtil;
import kd.drp.mdr.common.util.CustomerUtil;
import kd.drp.mdr.common.util.DateUtil;
import kd.drp.mdr.common.util.ItemStoreUtil;
import kd.drp.mdr.common.util.OrderQuantityUtil;
import kd.drp.mdr.common.util.PricePolicyUtil;
import kd.drp.mdr.common.util.PriceUtil;
import kd.drp.mdr.common.util.ReceiptUtil;
import kd.drp.mdr.common.util.ReceivingbillUtil;
import kd.drp.mdr.common.util.SaleOrderUtil;
import kd.drp.mdr.common.util.SysParamsUtil;
import kd.drp.mdr.common.util.UserUtil;
import kd.drp.mdr.common.util.ValidateUtils;
import kd.drp.mdr.common.util.WarehouseRuleUtil;
import kd.drp.mdr.formplugin.MdrFormMobPlugin;
import kd.drp.mdr.mobile.MobileControlUtils;
import kd.drp.mdr.mobile.model.FormModel;
import kd.drp.mdr.servicehelper.PromotionServiceHelper;

public class PurOrderMobPlugin
extends MdrFormMobPlugin
implements BeforeF7SelectListener,
TabSelectListener,
ListRowClickListener,
CreateListDataProviderListener {
    public static final String EVALUATERECORD = "evaluaterecord";
    public static final String CREATE_MONEY_DEBT = "createmoneydebt";
    public static final String PAYRECORD = "payrecord";
    public static final String ADD_ITEMENTRY = "additementry";
    public static final String ITEMNAME = "itemname";
    public static final String TO_EVALUATE = "toevaluate";
    public static final String TO_SIGN = "tosign";
    public static final String TO_CHANGE = "change";
    protected static final String BTN_DEBT = "btndebt";
    private static final String F_stockorgid = "stockorgid";
    private static final String F_easbusinesstype = "biztype";
    private static final String F_saleorderbilltypeid = "saleorderbilltypeid";
    public static final String TB_MAIN = "tbmain";
    protected static final String ADD = "add";
    protected static final String REDUCE = "reduce";
    protected static final String TO_INVALID = "invalid";
    protected static final String TO_VALID = "valid";
    protected static final String RE_FRESH = "refresh";
    protected static final String UNSUBMIT = "unsubmit";
    protected static final String UNAUDIT = "unaudit";
    protected static final String DELETE = "delete";
    protected static final String EDIT = "edit";
    protected static final String WITHDRAW = "withdraw";
    protected static final String UPDATE_ITEM_ENTRY = "updateitementry";
    protected static final String CONFIRMCHANGE = "confirmchange";
    protected static final String SAVE = "save";
    protected static final String SUBMIT = "submit";
    private static final String OP_CHECKSAVE = "checksave";
    private static final String OP_CHECKSUBMIT = "checksubmit";
    protected static final String AUDIT = "audit";
    public static final String ORDER_EVALUATE = "orderevaluate";
    protected static final String SPLITKEY = "&";
    protected static final String PAGE_ORDERINFO = "orderinfo";
    protected static final String PAGE_ENTRYINFO = "entryinfo";
    protected static final String PAGE_WORKFLOWINFO = "workflowinfo";
    protected static final String ADDITEM = "additem";
    public static final int leadTime = 0;
    protected volatile boolean triggerChangeEvent = true;
    protected static final String CACHE_KEY_USEWAREHOUSERULE = "cache_key_usewarehouserule";
    protected static final String EXECUTION_INFO = "executioninfo";
    private static String[] qtys = new String[]{"invalidreason", "changer", "changetime", "synctime", "syncuser", "allotdate"};
    private static final Long DEFAULTEASBUSINESSTYPEID = 322951122669016064L;
    protected static final String SELECTED_REBATE = "selectrebetae";
    protected static final String EXECUTIONS_LIST = "executionslist";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{TB_MAIN, BTN_DEBT});
        this.addTabSelectListener(this, new String[]{"tabap"});
        this.addClickListeners(new String[]{"deliveryrecord", EVALUATERECORD, PAYRECORD, CREATE_MONEY_DEBT, UPDATE_ITEM_ENTRY, "itementry", ADD_ITEMENTRY, DELETE, BTN_DEBT, EDIT, ADD, REDUCE, ORDER_EVALUATE, SELECTED_REBATE, EXECUTION_INFO, ADDITEM, "gotohome"});
        this.addF7Listener(this, new String[]{"receipt", "consigneeaddress", "saler", "warehouse", "customer", "entrywarehouse", "dispatcher"});
        BillList billList = (BillList)this.getControl(EXECUTIONS_LIST);
        billList.addListRowClickListener((ListRowClickListener)this);
    }

    protected void initCreatorAndTime() {
        this.setValue("creator", UserUtil.getUserID());
        this.setDateFieldValue("createtime", new Date());
    }

    public void tabSelected(TabSelectEvent e) {
        String key;
        this.hiddenFlex();
        switch (key = e.getTabKey()) {
            case "orderinfo": 
            case "workflowinfo": {
                this.setDisVisible(new String[]{ADDITEM});
                break;
            }
            case "entryinfo": {
                this.setVisible(new String[]{ADDITEM});
            }
        }
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control control = (Control)evt.getSource();
        int index = this.getModel().getEntryCurrentRowIndex("itementry");
        switch (key = control.getKey()) {
            case "deliveryrecord": {
                Object deliverycordcount = this.getModel().getValue("deliverycordcount");
                if (deliverycordcount == null || Integer.parseInt(deliverycordcount.toString()) <= 0) break;
                this.toDeliveryRecordPage();
                break;
            }
            case "payrecord": {
                Object payrecordcount = this.getModel().getValue("payrecordcount");
                if (payrecordcount == null || Integer.parseInt(payrecordcount.toString()) <= 0) break;
                this.toPayRecordPage();
                break;
            }
            case "evaluaterecord": {
                this.toEvaluatePage();
                break;
            }
            case "createmoneydebt": 
            case "btndebt": {
                this.createMoneyDebt();
                break;
            }
            case "additementry": {
                this.toItemAddPage();
                break;
            }
            case "updateitementry": {
                this.toItemEntryPage(index);
                break;
            }
            case "delete": {
                this.deleteItem();
                break;
            }
            case "edit": {
                this.showItemAttr(index);
                break;
            }
            case "add": {
                this.add(index, "qty");
                break;
            }
            case "reduce": {
                this.reduce(index, "qty");
                break;
            }
            case "selectrebetae": {
                this.toSelectedRebate();
            }
            case "executioninfo": {
                this.openExecutionSelectMobPage();
                break;
            }
            case "gotohome": {
                this.goToIndex();
                break;
            }
            case "additem": {
                Object billstatus = this.getModel().getValue("billstatus");
                if (billstatus == null || !"A".equals(billstatus.toString())) break;
                this.toItemAddPage();
            }
        }
    }

    protected void add(int index, String qtyname) {
        BigDecimal qty = (BigDecimal)this.getModel().getValue(qtyname, index);
        System.err.println(ResManager.loadKDString((String)"add \u6539\u53d8\u5e8f\u53f7\u4e3a\uff1a index", (String)"PurOrderMobPlugin_0", (String)"drp-dpa-formplugin", (Object[])new Object[0]) + index + "  qty" + qty);
        this.setValue(qtyname, qty.add(ONE), index);
    }

    protected void reduce(int index, String qtyname) {
        BigDecimal qty = (BigDecimal)this.getModel().getValue(qtyname, index);
        if (qty.compareTo(ZERO) > 0) {
            BigDecimal subQty = this.getOrderQuantityNum(index);
            this.setValue(qtyname, qty.subtract(subQty), index);
        }
    }

    private BigDecimal getOrderQuantityNum(int index) {
        IPageCache pageCache;
        Object assistattr;
        Object unit;
        Object item;
        Object warehouse;
        Object customer;
        if (!this.isOrderQuantityStrongControl()) {
            return ONE;
        }
        if (!this.isUseOrderQuantity(index)) {
            return ONE;
        }
        Object owner = this.getOwnerF7PKValue();
        Map orderQuantity = OrderQuantityUtil.getOrderQuantityRlue((Object)owner, (Object)(customer = this.getCustomerF7PKValue()), (Object)(warehouse = this.getEntryF7PKValue("itementry", "entrywarehouse", index)), (Object)(item = this.getEntryF7PKValue("itementry", "item", index)), (Object)(unit = this.getEntryF7PKValue("itementry", "unit", index)), (Object)(assistattr = this.getEntryF7PKValue("itementry", "assistattr", index)), (IPageCache)(pageCache = this.getPageCache()));
        if (orderQuantity == null || orderQuantity.get("qty") == null) {
            return ONE;
        }
        BigDecimal qty = ((BigDecimal)orderQuantity.get("qty")).stripTrailingZeros();
        return qty.add(ONE);
    }

    protected void showItemAttr(int index) {
        Object item = this.getModel().getValue("item", index);
        Object assistattr = this.getModel().getValue("assistattr", index);
        BigDecimal qty = (BigDecimal)this.getModel().getValue("qty", index);
        Object price = this.getModel().getValue("primprice", index);
        Object unit = this.getModel().getValue("unit", index);
        Object ownerId = this.getOwnerF7PKValue();
        Object customerId = this.getCustomerF7PKValue();
        if (ownerId == null || customerId == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8981\u8d27\u6e20\u9053\u53ca\u4f9b\u8d27\u6e20\u9053", (String)"PurOrderMobPlugin_1", (String)"drp-dpa-formplugin", (Object[])new Object[0]));
            return;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("entryindex", index);
        params.put("ownerid", ownerId);
        params.put("customerid", customerId);
        params.put("itemid", ((DynamicObject)item).getPkValue());
        if (assistattr != null) {
            params.put("assistattrid", ((DynamicObject)assistattr).getPkValue());
        }
        params.put("unitid", ((DynamicObject)unit).getPkValue());
        params.put("qty", qty);
        params.put("price", price);
        params.put("operate", EDIT);
        MobileFormShowParameter parameter = new MobileFormShowParameter();
        parameter.setCustomParams(params);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("mdr_mobchooseitemattr");
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "editEntryInfo"));
        this.getView().showForm((FormShowParameter)parameter);
    }

    protected void createMoneyDebt() {
        QFilter filter = new QFilter("id", "=", (Object)this.getId());
        QFilter[] filters = new QFilter[]{filter};
        DynamicObject saleorderInfo = BusinessDataServiceHelper.loadSingle((String)"mdr_saleorder", (String)"id,orderstatus,paystatus", (QFilter[])filters);
        if (saleorderInfo != null) {
            if (!("C".equals(saleorderInfo.get("orderstatus")) || "D".equals(saleorderInfo.get("orderstatus")) || "E".equals(saleorderInfo.get("orderstatus")) || "G".equals(saleorderInfo.get("orderstatus")) || "H".equals(saleorderInfo.get("orderstatus")) || "J".equals(saleorderInfo.get("orderstatus")))) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5f85\u5206\u8d27\u3001\u5f85\u53d1\u8d27\u3001\u90e8\u5206\u53d1\u8d27\u3001\u5f85\u6536\u8d27\u3001\u5df2\u6536\u8d27\u3001\u5df2\u5b8c\u6210\u7684\u5355\u636e\u624d\u80fd\u5173\u8054\u751f\u6210\uff01", (String)"PurOrderMobPlugin_2", (String)"drp-dpa-formplugin", (Object[])new Object[0]));
            }
        } else {
            return;
        }
        MobileFormShowParameter parameter = new MobileFormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Floating);
        parameter.setFormId("mdr_money_debt_mob");
        parameter.setCustomParam("orderid", (Object)this.getId());
        this.getView().showForm((FormShowParameter)parameter);
    }

    protected void deleteItem() {
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("deleteEntryCallBack", (IFormPlugin)this);
        this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u8ba4\u5220\u9664\u8be5\u5546\u54c1\u5417\uff1f", (String)"PurOrderMobPlugin_3", (String)"drp-dpa-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, ConfirmTypes.Wait, confirmCallBacks);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        switch (messageBoxClosedEvent.getCallBackId()) {
            case "deleteEntryCallBack": {
                if (messageBoxClosedEvent.getResult().equals((Object)MessageBoxResult.Yes)) {
                    this.deleteEntry();
                    break;
                }
                return;
            }
            case "saveCallBack": {
                if (messageBoxClosedEvent.getResult().equals((Object)MessageBoxResult.Yes)) {
                    this.getView().invokeOperation(SAVE);
                    break;
                }
                return;
            }
            case "submitCallBack": {
                if (messageBoxClosedEvent.getResult().equals((Object)MessageBoxResult.Yes)) {
                    this.orderLimitCheck();
                    break;
                }
                return;
            }
            case "limitCallBack": {
                if (messageBoxClosedEvent.getResult().equals((Object)MessageBoxResult.Yes)) {
                    this.refreshModelByPromotionOrder();
                    this.orderLimitAgainCheck();
                    break;
                }
                return;
            }
        }
    }

    protected void refreshModelByPromotionOrder() {
        DynamicObject data = this.getModel().getDataEntity(true);
        String strruleids = data.getString("operateremark");
        HashSet<Object> promotionpolicyids = new HashSet<Object>();
        Object policyid = null;
        HashSet<Object> policyids = new HashSet<Object>();
        DynamicObjectCollection results = QueryServiceHelper.query((String)"dpm_limit", (String)"id,policy.promotionpolicy", (QFilter[])new QFilter("id", "in", (Object)strruleids.split(",")).toArray());
        for (DynamicObject limit : results) {
            promotionpolicyids.add(limit.get("policy.promotionpolicy"));
        }
        PromotionApiResult ctx = null;
        String cachekey = data.getString("promotioncachekey");
        if (cachekey.isEmpty()) {
            long orderid = (Long)data.getPkValue();
            ctx = PromotionServiceHelper.getPromotionResult((Long)orderid);
        } else {
            ctx = PromotionServiceHelper.getPromotionResult((String)cachekey);
        }
        List executions = ctx.getExecutions();
        HashSet<Integer> rows = new HashSet<Integer>();
        HashSet<Object> strEntryids = new HashSet<Object>();
        StringBuilder stringBuilder = new StringBuilder();
        if (executions != null && !executions.isEmpty()) {
            DynamicObjectCollection entryentity = null;
            String type = "";
            Object entryid = null;
            DynamicObjectCollection entrycol = this.getAlgorithm().getEntry();
            BigDecimal sumamountdiff = BigDecimal.ZERO;
            BigDecimal amountdiff = BigDecimal.ZERO;
            BigDecimal pricediff = BigDecimal.ZERO;
            for (DynamicObject execution : executions) {
                policyid = execution.getDynamicObject("policy").getPkValue();
                if (policyid == null || !promotionpolicyids.contains(policyid)) continue;
                policyids.add(policyid);
                entryentity = execution.getDynamicObjectCollection("entryentity");
                if (entryentity == null || entryentity.isEmpty()) continue;
                block2: for (DynamicObject entry : entryentity) {
                    type = entry.getString("type");
                    if (type.compareTo("orderdiff") == 0) {
                        sumamountdiff = sumamountdiff.add(entry.getBigDecimal("amountdiff"));
                        continue;
                    }
                    entryid = entry.get("entryid");
                    if (entryid == null) continue;
                    for (int i = 0; i < entrycol.size(); ++i) {
                        DynamicObject entryc = (DynamicObject)entrycol.get(i);
                        if (!entryc.getPkValue().equals(entryid)) continue;
                        if (type.compareTo("addpresent") == 0) {
                            rows.add(i);
                            stringBuilder.append(entry.get("sourceentryids"));
                            stringBuilder.append(',');
                            continue block2;
                        }
                        amountdiff = entry.getBigDecimal("amountdiff");
                        pricediff = entry.getBigDecimal("pricediff");
                        if (pricediff.compareTo(BigDecimal.ZERO) < 0) {
                            amountdiff = amountdiff.add(pricediff.multiply(entryc.getBigDecimal("qty")));
                        }
                        if (amountdiff.compareTo(BigDecimal.ZERO) < 0) {
                            BigDecimal promotionamount = entryc.getBigDecimal("promotionamount");
                            this.setValue("promotionamount", promotionamount.subtract(amountdiff), i);
                        }
                        strEntryids.add(entryid);
                        continue block2;
                    }
                }
            }
            if (rows != null && rows.size() > 0) {
                this.deleteEntry(rows);
            }
            if (sumamountdiff.compareTo(BigDecimal.ZERO) < 0) {
                BigDecimal totalitemamount = data.getBigDecimal("totalitemamount");
                BigDecimal itemamount = BigDecimal.ZERO;
                BigDecimal promotionamount = BigDecimal.ZERO;
                for (int i = 0; i < entrycol.size(); ++i) {
                    DynamicObject entryc = (DynamicObject)entrycol.get(i);
                    itemamount = entryc.getBigDecimal("itemamount");
                    if (itemamount.compareTo(BigDecimal.ZERO) <= 0) continue;
                    amountdiff = sumamountdiff.multiply(itemamount).divide(totalitemamount, 2, RoundingMode.HALF_UP);
                    promotionamount = entryc.getBigDecimal("promotionamount");
                    this.setValue("promotionamount", promotionamount.subtract(amountdiff), i);
                    if (strEntryids.contains(entryid)) continue;
                    strEntryids.add(entryc.getPkValue());
                }
            }
            if (strEntryids.size() > 0 || stringBuilder.length() > 0) {
                String entryids = stringBuilder.toString();
                for (int i = 0; i < entrycol.size(); ++i) {
                    Object pkid = ((DynamicObject)entrycol.get(i)).getPkValue();
                    if (!strEntryids.contains(pkid) && !entryids.contains(pkid.toString())) continue;
                    this.setValue("limitentryid", 1L, i);
                }
            }
            this.getAlgorithm().calAfterExecutePromotion();
        }
        if (!cachekey.isEmpty() && policyids.size() > 0) {
            PromotionServiceHelper.removeContextFromPolicy((String)cachekey, policyids);
        }
    }

    private void deleteEntry(Set<Integer> rows) {
        int j = 0;
        int[] rowindex = new int[rows.size()];
        for (Integer rowIndex : rows) {
            rowindex[j++] = rowIndex;
        }
        this.getModel().deleteEntryRows("itementry", rowindex);
    }

    protected void toDeliveryRecordPage() {
        MobileListShowParameter parameter = new MobileListShowParameter();
        parameter.setFormId("bos_moblist");
        parameter.setBillFormId("bbc_delivery_record");
        parameter.getOpenStyle().setShowType(ShowType.Floating);
        parameter.setCustomParam("orderid", (Object)this.getId());
        this.getView().showForm((FormShowParameter)parameter);
    }

    protected void toPayRecordPage() {
        MobileListShowParameter parameter = new MobileListShowParameter();
        parameter.setFormId("bos_moblist");
        parameter.setBillFormId("mdr_money_receiveinh");
        parameter.getOpenStyle().setShowType(ShowType.Floating);
        parameter.setCustomParam("orderid", (Object)this.getId());
        this.getView().showForm((FormShowParameter)parameter);
    }

    protected void toItemAddPage() {
        MobileFormShowParameter parameter = new MobileFormShowParameter();
        parameter.setFormId("mdr_item_addtoentry");
        parameter.getOpenStyle().setShowType(ShowType.Floating);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("customerid", this.getCustomerF7PKValue());
        map.put("ownerid", this.getOwnerF7PKValue());
        map.put("warehouseid", this.getF7PKValue("warehouse"));
        parameter.setCustomParams(map);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "addItemEntry"));
        this.getView().showForm((FormShowParameter)parameter);
    }

    protected void toItemEntryPage(int index) {
        MobileFormShowParameter parameter = new MobileFormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Floating);
        parameter.setFormId("bbc_salerorder_itementry");
        this.setItemEntryColumnToCustomParam((FormShowParameter)parameter, "unit", index);
        this.setItemEntryColumnToCustomParam((FormShowParameter)parameter, "alterqty", index);
        this.setItemEntryColumnToCustomParam((FormShowParameter)parameter, "qty", index);
        this.setItemEntryColumnToCustomParam((FormShowParameter)parameter, "baseunit", index);
        this.setItemEntryColumnToCustomParam((FormShowParameter)parameter, "alterbaseqty", index);
        this.setItemEntryColumnToCustomParam((FormShowParameter)parameter, "baseqty", index);
        this.setItemEntryColumnToCustomParam((FormShowParameter)parameter, "assistunit", index);
        this.setItemEntryColumnToCustomParam((FormShowParameter)parameter, "alterassistqty", index);
        this.setItemEntryColumnToCustomParam((FormShowParameter)parameter, "assistqty", index);
        this.setItemEntryColumnToCustomParam((FormShowParameter)parameter, "storeqty", index);
        this.setItemEntryColumnToCustomParam((FormShowParameter)parameter, "primprice", index);
        this.setItemEntryColumnToCustomParam((FormShowParameter)parameter, "primamount", index);
        this.setItemEntryColumnToCustomParam((FormShowParameter)parameter, "custchangeprice", index);
        this.setItemEntryColumnToCustomParam((FormShowParameter)parameter, "taxrate", index);
        this.setItemEntryColumnToCustomParam((FormShowParameter)parameter, "taxprice", index);
        this.setItemEntryColumnToCustomParam((FormShowParameter)parameter, "discounttype", index);
        this.setItemEntryColumnToCustomParam((FormShowParameter)parameter, "discount", index);
        this.setItemEntryColumnToCustomParam((FormShowParameter)parameter, "discountamount", index);
        this.setItemEntryColumnToCustomParam((FormShowParameter)parameter, "itemamount", index);
        this.setItemEntryColumnToCustomParam((FormShowParameter)parameter, "promotionamount", index);
        this.setItemEntryColumnToCustomParam((FormShowParameter)parameter, "rebateamount", index);
        this.setItemEntryColumnToCustomParam((FormShowParameter)parameter, "actualtaxprice", index);
        this.setItemEntryColumnToCustomParam((FormShowParameter)parameter, "taxamount", index);
        this.setItemEntryColumnToCustomParam((FormShowParameter)parameter, "tax", index);
        this.setItemEntryColumnToCustomParam((FormShowParameter)parameter, "amount", index);
        this.setItemEntryColumnToCustomParam((FormShowParameter)parameter, "hightpriceratio", index);
        this.setItemEntryColumnToCustomParam((FormShowParameter)parameter, "price", index);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, UPDATE_ITEM_ENTRY));
        this.getView().showForm((FormShowParameter)parameter);
    }

    protected void setItemEntryColumnToCustomParam(FormShowParameter parameter, String key, int index) {
        Object value = this.getModel().getValue(key, index);
        if (value instanceof DynamicObject) {
            value = ((DynamicObject)value).getPkValue();
        }
        parameter.setCustomParam(key, value);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String actionId = e.getActionId();
        Object returnData = e.getReturnData();
        switch (actionId) {
            case "addItemEntry": {
                this.addItemEntry((List)returnData);
                break;
            }
            case "editEntryInfo": {
                this.updateEntryInfo((Map)returnData);
                break;
            }
            case "refreshEvaluateCount": {
                this.setEvaluateCount();
                break;
            }
            case "chooseAddress": {
                this.setAddress(returnData);
                break;
            }
            case "chooseReceipt": {
                this.setReceipt(returnData);
                break;
            }
            case "updateitementry": {
                break;
            }
            case "drm_account_type_select": {
                this.accountTypeSelectCloseCallBack((Map)returnData);
                break;
            }
            case "dpm_executionselect_mob": {
                this.executionSelectMobCloseCallBack(returnData);
            }
        }
    }

    private void setReceipt(Object returnData) {
        if (returnData != null) {
            this.triggerChangeEvent = false;
            this.setValue("receipt", returnData);
        }
    }

    private void setAddress(Object returnData) {
        if (returnData != null) {
            this.triggerChangeEvent = false;
            this.setConsigneeAddressF7Value(returnData);
            this.setConsigneeInfo();
            this.sycnEntryConsigneeInfo();
            this.setConsigneeAddressF7Value(null);
        }
    }

    private void setConsigneeInfo() {
        DynamicObject address = this.getConsigneeAddressF7Value();
        if (address != null) {
            this.setTextFieldValue("consignee", address.getString("contactname"));
            this.setTextFieldValue("consigneephone", address.getString("telephone"));
            this.setTextFieldValue("address", address.getString("detailaddress"));
        }
    }

    private void sycnEntryConsigneeInfo() {
        IDataModel model = this.getModel();
        int count = model.getEntryRowCount("itementry");
        if (count == 0) {
            return;
        }
        DynamicObject pk = this.getConsigneeAddressF7Value();
        for (int i = 0; i < count; ++i) {
            this.setRowValue("entryconsigneeaddress", pk, i);
            this.setEntryConsigneeInfo(i);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        int rowIndex = e.getRow();
        switch (key) {
            case "customer": {
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)UserUtil.getCommonUserOwnersFilter());
                break;
            }
            case "receipt": {
                HashMap<String, Object> customParams = new HashMap<String, Object>();
                customParams.put("ownerid", this.getOwnerF7PKValue());
                customParams.put("customerid", this.getCustomerF7PKValue());
                customParams.put("isf7", "true");
                this.showMobileForm("mdr_myreceipt_mobile", customParams, "chooseReceipt");
                e.setCancel(true);
                break;
            }
            case "consigneeaddress": {
                HashMap<String, Object> customParams = new HashMap<String, Object>();
                customParams.put("ownerid", this.getOwnerF7PKValue());
                customParams.put("customerid", this.getCustomerF7PKValue());
                customParams.put("isf7", "true");
                this.showMobileForm("mdr_myaddress_mob", customParams, "chooseAddress");
                e.setCancel(true);
                break;
            }
            case "saler": {
                List salers = CustomerSalerUtil.queryCustomerSalerPK((Object)this.getCustomerF7PKValue(), (Object)this.getOwnerF7PKValue());
                salers.add(0L);
                e.getFormShowParameter().setCustomParam("rang", (Object)salers);
                break;
            }
            case "dispatcher": {
                Set dispathcerIds = UserUtil.getDispathcerIds((Object)this.getOwnerF7PKValue());
                dispathcerIds.add(0L);
                e.getFormShowParameter().setCustomParam("rang", (Object)dispathcerIds);
                break;
            }
            case "warehouse": {
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)this.getWareHouseFilter());
                break;
            }
            case "entrywarehouse": {
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)this.getEntryWareHouseFilter(rowIndex));
                FormShowParameter param = e.getFormShowParameter();
                param.setCustomParam("itemid", this.getEntryF7PKValue("itementry", "item", rowIndex));
                param.setCustomParam("unitid", this.getEntryF7PKValue("itementry", "unit", rowIndex));
                param.setCustomParam("customerid", this.getOwnerF7PKValue());
                e.setFormShowParameter(param);
            }
        }
    }

    private void showMobileForm(String formId, Map<String, Object> customParams, String closeMethod) {
        MobileFormShowParameter parameter = new MobileFormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Floating);
        parameter.setFormId(formId);
        if (customParams != null) {
            parameter.setCustomParams(customParams);
        }
        if (StringUtils.isNotEmpty((String)closeMethod)) {
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, closeMethod));
        }
        this.getView().showForm((FormShowParameter)parameter);
    }

    private QFilter getWareHouseFilter() {
        List ids = WarehouseRuleUtil.getWarehouseList((Object)this.getOwnerF7PKValue(), (Object)this.getCustomerF7PKValue());
        if (ids.isEmpty()) {
            return new QFilter("id", "=", (Object)0L);
        }
        return new QFilter("id", "in", (Object)ids);
    }

    private QFilter getEntryWareHouseFilter(int rowIndex) {
        if (!this.isUseWareHouseRule()) {
            return this.getWareFilterByCustomer(this.getOwnerF7PKValue());
        }
        Object itemId = this.getEntryF7PKValue("itementry", "item", rowIndex);
        List ids = WarehouseRuleUtil.getWarehouseList((Object)this.getOwnerF7PKValue(), (Object)this.getCustomerF7PKValue(), (Object)itemId);
        return new QFilter("id", "in", (Object)ids);
    }

    protected boolean isUseWareHouseRule() {
        IPageCache pc = this.getPageCache();
        String value = pc.get(CACHE_KEY_USEWAREHOUSERULE);
        if (StringUtils.isEmpty((String)value)) {
            Boolean useWareHouseRule = SysParamsUtil.isUseWareHouseRule();
            value = useWareHouseRule.toString();
            pc.put(CACHE_KEY_USEWAREHOUSERULE, value);
        }
        return Boolean.parseBoolean(value);
    }

    private QFilter getWareFilterByCustomer(Object customerId) {
        List list = WarehouseRuleUtil.queryWarehouse((Object)customerId);
        if (list.isEmpty()) {
            return new QFilter("id", "=", (Object)0L);
        }
        return new QFilter("id", "in", (Object)list);
    }

    public void listRowClick(ListRowClickEvent evt) {
        String key;
        Control billList = (Control)evt.getSource();
        switch (key = billList.getKey()) {
            case "executionslist": {
                this.openExecutionSelectMobPage();
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        String key = e.getOperateKey();
        if (this.getOperationResult(e)) {
            switch (key) {
                case "save": {
                    this.deleteShoppingCart();
                    break;
                }
                case "submit": {
                    this.deleteShoppingCart();
                    break;
                }
                case "evaluate": {
                    this.showEvaluateAdd();
                    break;
                }
                case "change": {
                    this.getView().invokeOperation("modify");
                    break;
                }
                case "tosign": {
                    this.toSignPage();
                    break;
                }
                case "toevaluate": {
                    this.toEvaluate();
                    break;
                }
                case "confirmchange": {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u786e\u8ba4\u53d8\u66f4\u6210\u529f", (String)"PurOrderMobPlugin_4", (String)"drp-dpa-formplugin", (Object[])new Object[0]));
                    break;
                }
                case "orderevaluate": {
                    this.toOrderEvaluate();
                    break;
                }
            }
        }
    }

    protected boolean getOperationResult(AfterDoOperationEventArgs e) {
        OperationResult result = e.getOperationResult();
        return result == null || result.isSuccess();
    }

    protected void toEvaluate() {
        Long id = this.getId();
        MobileFormShowParameter parameter = new MobileFormShowParameter();
        parameter.setFormId("mdr_evaluate_mobview");
        parameter.getOpenStyle().setShowType(ShowType.Floating);
        parameter.setCustomParam("orderid", (Object)id);
        this.getView().showForm((FormShowParameter)parameter);
    }

    protected void toSignPage() {
        Long id = this.getId();
        MobileListShowParameter parameter = new MobileListShowParameter();
        parameter.setFormId("bos_moblist");
        parameter.setBillFormId("bbc_delivery_record");
        parameter.getOpenStyle().setShowType(ShowType.Floating);
        parameter.setCustomParam("orderid", (Object)id);
        this.getView().showForm((FormShowParameter)parameter);
    }

    protected void showEvaluateAdd() {
        MobileFormShowParameter parameter = new MobileFormShowParameter();
        parameter.setFormId("mdr_evaluate_mobadd");
        parameter.getOpenStyle().setShowType(ShowType.Floating);
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put("orderid", this.getId());
        parameter.setCustomParams(map);
        this.getView().showForm((FormShowParameter)parameter);
    }

    protected void deleteShoppingCart() {
        QFilter filter = new QFilter("owner.id", "=", this.getCustomerF7PKValue());
        filter.and("customer.id", "=", this.getOwnerF7PKValue());
        filter.and("user.id", "=", UserUtil.getUserID());
        filter.and("ispurchasing", "=", (Object)"0");
        DeleteServiceHelper.delete((String)"mdr_shopping_cart", (QFilter[])filter.toArray());
    }

    protected void goToIndex() {
        this.getView().close();
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        this.getModel().setDataChanged(false);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        if (this.triggerChangeEvent) {
            this.triggerChangeEvent = false;
            int index = this.getRowIndex(e);
            switch (key) {
                case "transportprice": {
                    this.setValue("transportamount", 0);
                    break;
                }
                case "transportamount": {
                    this.setValue("transportprice", 0);
                    break;
                }
                case "consigneeaddress": {
                    this.setConsigneeInfo();
                    this.sycnEntryConsigneeInfo();
                    this.setConsigneeAddressF7Value(null);
                    break;
                }
                case "warehouse": {
                    this.sycnEntryWareHouse();
                    break;
                }
                case "arrivaldate": {
                    this.arrivalDateChange();
                    break;
                }
                case "confirmarrivaldate": {
                    this.confirmArrivalDateChange();
                    this.batchReCalPrice();
                    break;
                }
                case "customer": {
                    this.setF7Value("directcustomer", this.getCustomerF7PKValue());
                    break;
                }
                case "saler": {
                    this.salerChanged();
                    break;
                }
                case "isusebalance": {
                    this.useBalanceChanged();
                    break;
                }
                case "rebateaccounttype": {
                    this.rebateAccountTypeChanged(e);
                    break;
                }
                case "usedrebate": {
                    this.usedRebateChanged(e);
                    break;
                }
                case "owner": {
                    this.setSaleOrg();
                    break;
                }
                case "billtypeid": {
                    this.setBillParameters();
                    break;
                }
                default: {
                    this.propertyChangedOnItem(e, index);
                }
            }
            this.propertyChangeRefreshExecutionList(key);
        }
    }

    private void salerChanged() {
        Object salerid = this.getF7PKValue("saler");
        this.setValue("department", UserUtil.getDefaultAdminOrgID((Object)salerid));
    }

    private void arrivalDateChange() {
        Date limitDate;
        Date date = this.getDateFieldValue("arrivaldate");
        if (date.before(limitDate = DateUtil.getBeforeDay((Date)new Date(), (int)0))) {
            date = limitDate;
            this.setDateFieldValue("arrivaldate", limitDate);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u8981\u6c42\u4ea4\u8d27\u65e5\u671f\u4e0d\u80fd\u65e9\u4e8e\uff1a", (String)"PurOrderMobPlugin_5", (String)"drp-dpa-formplugin", (Object[])new Object[0]) + DateUtil.getDateFormat((Date)limitDate));
        }
        this.syncEntryArrivalDate(date);
        this.setDateFieldValue("confirmarrivaldate", date);
        this.syncEntryConfirmArrivalDate(date);
    }

    private void syncEntryArrivalDate(Date date) {
        IDataModel model = this.getModel();
        int count = model.getEntryRowCount("itementry");
        if (count == 0) {
            return;
        }
        for (int i = 0; i < count; ++i) {
            this.setRowValue("entryarrivaldate", date, i);
            this.setRowValue("entryconfirmarrivaldate", date, i);
        }
    }

    private void syncEntryConfirmArrivalDate(Date confirmDate) {
        IDataModel model = this.getModel();
        int count = model.getEntryRowCount("itementry");
        if (count == 0) {
            return;
        }
        for (int i = 0; i < count; ++i) {
            this.setRowValue("entryconfirmarrivaldate", confirmDate, i);
        }
    }

    private void confirmArrivalDateChange() {
        Date confirmDate = this.getDateFieldValue("confirmarrivaldate");
        Date now = new Date();
        Date date = DateUtil.getNowDate();
        if (confirmDate.before(date)) {
            confirmDate = now;
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u786e\u8ba4\u4ea4\u8d27\u65e5\u671f\u4e0d\u65e9\u4e8e\uff1a", (String)"PurOrderMobPlugin_6", (String)"drp-dpa-formplugin", (Object[])new Object[0]) + DateUtil.getDateFormat((Date)now));
        }
        this.setDateFieldValue("confirmarrivaldate", confirmDate);
        this.syncEntryConfirmArrivalDate(confirmDate);
    }

    private void batchReCalPrice() {
        if (!SysParamsUtil.isPriceByConfirmarrivedate()) {
            return;
        }
        int count = this.getModel().getEntryRowCount("itementry");
        for (int i = 0; i < count; ++i) {
            this.setPrice(i);
        }
    }

    private void setPrice(int index) {
        Object itemPK = this.getEntryF7PKValue("itementry", "item", index);
        Object unitPK = this.getEntryF7PKValue("itementry", "unit", index);
        this.setPrice(index, itemPK, unitPK);
    }

    private void setPrice(int index, Object itemPK, Object unitPK) {
        DynamicObject rowInfo = this.getRowInfo("itementry", index);
        BigDecimal qty = rowInfo.getBigDecimal("qty");
        Date date = new Date();
        if (SysParamsUtil.isPriceByConfirmarrivedate()) {
            date = this.getRowInfo("itementry", index).getDate("entryconfirmarrivaldate");
        }
        DynamicObject assistattr = (DynamicObject)rowInfo.get("assistattr");
        Object attrid = 0L;
        if (assistattr != null) {
            attrid = assistattr.getPkValue();
        }
        BigDecimal itemPrice = PriceUtil.getItemPrice((Object)this.getOwnerF7PKValue(), (Object)this.getCustomerF7PKValue(), (Object)itemPK, (Object)unitPK, (Object)attrid, (BigDecimal)qty, (Date)date);
        itemPrice = itemPrice.setScale(2, 4);
        this.setRowValue("primprice", itemPrice, index);
        this.getAlgorithm().calPrimAmount(index);
        boolean custchangeprice = rowInfo.getBoolean("custchangeprice");
        if (!custchangeprice) {
            this.setRowValue("price", itemPrice, index);
            this.setRowValue("hightpriceratio", 0, index);
        }
    }

    private BigDecimal getPrice(int index, Object itemPK, Object unitPK, BigDecimal qty, Object attrid) {
        Date date = new Date();
        if (SysParamsUtil.isPriceByConfirmarrivedate()) {
            date = this.getRowInfo("itementry", index).getDate("entryconfirmarrivaldate");
        }
        if (attrid == null) {
            attrid = 0L;
        }
        BigDecimal itemPrice = PriceUtil.getItemPrice((Object)this.getOwnerF7PKValue(), (Object)this.getCustomerF7PKValue(), (Object)itemPK, (Object)unitPK, (Object)attrid, (BigDecimal)qty, (Date)date);
        return itemPrice;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        String key;
        super.beforeDoOperation(e);
        switch (key = ((AbstractOperate)e.getSource()).getOperateKey()) {
            case "close": {
                break;
            }
            case "save": 
            case "submit": 
            case "audit": {
                if (!this.checkTel() || !this.checkStatus(key)) {
                    e.setCancel(true);
                    break;
                }
                String errorMsg = this.checkOrderQuantity();
                if (StringUtils.isEmpty((String)errorMsg)) break;
                this.doWhenOrderQuantityFailed(e, errorMsg);
                break;
            }
            case "unsubmit": 
            case "unaudit": 
            case "delete": 
            case "withdraw": 
            case "valid": {
                FormOperate op = (FormOperate)e.getSource();
                op.getOption().setVariableValue("ismob", "true");
                break;
            }
            case "checksave": 
            case "checksubmit": {
                this.orderInventoryCheck(key);
                break;
            }
        }
    }

    private void orderLimitCheck() {
        DynamicObject data = this.getModel().getDataEntity(true);
        PromotionOrder promotionorder = new SaleOrderAlgorithm(data, null, null).buildPromotionOrderWithPresent();
        LimitResult limitResult = PromotionServiceHelper.validateLimitRule((PromotionOrder)promotionorder, (boolean)false);
        StringBuilder stringBuilder = new StringBuilder();
        boolean iserror = false;
        HashSet<Object> ruleids = new HashSet<Object>();
        Object ruleid = null;
        if (!limitResult.isSuccessExecuteLimit()) {
            Map limitResultEntries = limitResult.getLimitResultEntries();
            for (LimitResultEntry limitResultEntry : limitResultEntries.values()) {
                if (limitResultEntry.getExecuteResult()) continue;
                if (!iserror && !limitResultEntry.isactonpolicy()) {
                    iserror = true;
                }
                ruleid = limitResultEntry.getRuleId();
                ruleids.add(ruleid);
                stringBuilder.append(String.format(ResManager.loadKDString((String)"%s\uff0c\u53ef\u7528\u4f59\u91cf\u4e3a%s\u3002", (String)"PurOrderMobPlugin_36", (String)"drp-dpa-formplugin", (Object[])new Object[0]), limitResultEntry.getItemName(), limitResultEntry.getLeftLimitQty().stripTrailingZeros().toPlainString()));
            }
        }
        if (ruleids.size() > 0) {
            StringBuilder strruleids = new StringBuilder();
            for (Object object : ruleids) {
                strruleids.append(object);
                strruleids.append(',');
            }
            this.setValue("operateremark", strruleids.substring(0, strruleids.length() - 1));
        }
        if (stringBuilder.length() > 0) {
            if (iserror) {
                this.getView().showErrorNotification(stringBuilder.toString());
            } else {
                ConfirmCallBackListener callBack = new ConfirmCallBackListener("limitCallBack", (IFormPlugin)this);
                this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u4ee5\u4e0b\u5546\u54c1\u6570\u91cf\u5df2\u8d85\u8fc7\u9650\u5b9a\u6570\u91cf\uff0c\u65e0\u6cd5\u4eab\u53d7\u4fc3\u9500\u653f\u7b56\uff0c\u8bf7\u95ee\u786e\u8ba4\u63d0\u4ea4\uff1f%s", (String)"PurOrderMobPlugin_37", (String)"drp-dpa-formplugin", (Object[])new Object[0]), stringBuilder), MessageBoxOptions.OKCancel, callBack);
            }
        } else {
            this.getView().invokeOperation(SUBMIT);
        }
    }

    private void orderLimitAgainCheck() {
        DynamicObject data = this.getModel().getDataEntity(true);
        PromotionOrder promotionorder = new SaleOrderAlgorithm(data, null, null).buildPromotionOrderWithPresent();
        LimitResult limitResult = PromotionServiceHelper.validateLimitRule((PromotionOrder)promotionorder, (boolean)false);
        StringBuilder stringBuilder = new StringBuilder();
        if (!limitResult.isSuccessExecuteLimit()) {
            Map limitResultEntries = limitResult.getLimitResultEntries();
            for (LimitResultEntry limitResultEntry : limitResultEntries.values()) {
                if (limitResultEntry.getExecuteResult()) continue;
                stringBuilder.append(String.format(ResManager.loadKDString((String)"%s\uff0c\u53ef\u7528\u4f59\u91cf\u4e3a%s\u3002", (String)"PurOrderEditPlugin_67", (String)"drp-dpa-formplugin", (Object[])new Object[0]), limitResultEntry.getItemName(), limitResultEntry.getLeftLimitQty().stripTrailingZeros().toPlainString()));
            }
            if (stringBuilder.length() > 0) {
                this.getView().showErrorNotification(stringBuilder.toString());
            }
        } else {
            this.getView().invokeOperation(SUBMIT);
        }
    }

    private boolean checkStatus(String operatekey) {
        Long saleorderid = this.getId();
        if (((Object)saleorderid).equals(0L) || !QueryServiceHelper.exists((String)"bbc_saleorder", (Object)saleorderid)) {
            return true;
        }
        DynamicObject saleorder = BusinessDataServiceHelper.loadSingle((Object)saleorderid, (String)"bbc_saleorder", (String)"id,orderstatus");
        String orderstatus = saleorder.getString("orderstatus");
        switch (operatekey) {
            case "save": {
                if ("A".equals(orderstatus) || "F".equals(orderstatus)) break;
                this.getView().showErrorNotification("\u53ea\u6709\u6682\u5b58\u3001\u53d8\u66f4\u4e2d\u72b6\u6001\u5355\u636e\u53ef\u4ee5\u4fdd\u5b58\u3002");
                return false;
            }
            case "submit": {
                if ("A".equals(orderstatus)) break;
                this.getView().showErrorNotification("\u53ea\u6709\u6682\u5b58\u7684\u5355\u636e\u624d\u5141\u8bb8\u63d0\u4ea4\u3002");
                return false;
            }
            case "audit": {
                if ("B".equals(orderstatus)) break;
                this.getView().showErrorNotification("\u5355\u636e\u72b6\u6001\u5fc5\u987b\u4e3a\u5df2\u63d0\u4ea4\u624d\u80fd\u5ba1\u6838\u3002");
                return false;
            }
        }
        return true;
    }

    private void orderInventoryCheck(String operatekey) {
        HashMap keyMap = new HashMap();
        DynamicObject data = this.getModel().getDataEntity(true);
        StringBuilder errorInfos = new StringBuilder();
        DynamicObject currentOwner = data.getDynamicObject("owner");
        Object ownerId = currentOwner.get("id");
        String isallow = CustomerParamsUtil.isAllowOver((Object)ownerId);
        if (!isallow.equals("0")) {
            DynamicObjectCollection itemEntryCollection = data.getDynamicObjectCollection("itementry");
            List myStoreDyns = ItemStoreUtil.queryItemStoreBatch((Object)ownerId, (DynamicObjectCollection)itemEntryCollection);
            StringBuilder sb = new StringBuilder();
            for (DynamicObject itemEntry : itemEntryCollection) {
                String entrytype = itemEntry.getString("entrytype");
                if (SaleOrderEntryType.COMBINATION.getFlagStr().equals(entrytype)) continue;
                sb = new StringBuilder();
                String seq = itemEntry.getString("seq");
                DynamicObject storeObject = null;
                List<DynamicObject> tempMyStoreDyns = new ArrayList<DynamicObject>(myStoreDyns);
                tempMyStoreDyns = this.findMyStoreDynsAndAppendSb(sb, itemEntry, "item", "item", tempMyStoreDyns);
                storeObject = this.getMyStoreDyn(tempMyStoreDyns, storeObject);
                tempMyStoreDyns = this.findMyStoreDynsAndAppendSb(sb, itemEntry, "unit", "measureunit", tempMyStoreDyns);
                storeObject = this.getMyStoreDyn(tempMyStoreDyns, storeObject);
                tempMyStoreDyns = this.findMyStoreDynsAndAppendSb(sb, itemEntry, "assistattr", "assistattr", tempMyStoreDyns);
                storeObject = this.getMyStoreDyn(tempMyStoreDyns, storeObject);
                tempMyStoreDyns = this.findMyStoreDynsAndAppendSb(sb, itemEntry, "entrywarehouse", "warehouse", tempMyStoreDyns);
                storeObject = this.getMyStoreDyn(tempMyStoreDyns, storeObject);
                int alterqty = itemEntry.getInt("alterqty");
                if (!keyMap.containsKey(sb.toString())) {
                    int qty = storeObject.getInt("qty") - storeObject.getInt("orderqty");
                    LinkedHashMap<String, Integer> map = new LinkedHashMap<String, Integer>();
                    map.put(seq, qty - alterqty);
                    keyMap.put(sb.toString(), map);
                    if (qty >= alterqty) continue;
                    errorInfos.append(seq);
                    errorInfos.append('\u3001');
                    continue;
                }
                LinkedHashMap map = (LinkedHashMap)keyMap.get(sb.toString());
                Map.Entry entry = this.getTail(map);
                int qty = (Integer)entry.getValue();
                map.put(seq, qty - alterqty);
                if (qty >= alterqty) continue;
                if (qty >= 0) {
                    for (String seqKey : map.keySet()) {
                        errorInfos.append(seqKey);
                        errorInfos.append('\u3001');
                    }
                    continue;
                }
                errorInfos.append(seq);
                errorInfos.append('\u3001');
            }
        }
        if (errorInfos.length() > 0) {
            if (isallow.equals("2")) {
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("submitCallBack", (IFormPlugin)this);
                if (operatekey.equals(OP_CHECKSAVE)) {
                    confirmCallBacks = new ConfirmCallBackListener("saveCallBack", (IFormPlugin)this);
                }
                this.getView().showConfirm(ResManager.loadKDString((String)"\u884c", (String)"PurOrderMobPlugin_38", (String)"drp-dpa-formplugin", (Object[])new Object[0]) + errorInfos.toString().substring(0, errorInfos.toString().length() - 1) + ResManager.loadKDString((String)"\uff1a\u4e0b\u5355\u6570\u91cf\u8d85\u51fa\u5e93\u5b58\u53ef\u7528\u6570\u91cf\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"PurOrderMobPlugin_39", (String)"drp-dpa-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, ConfirmTypes.Save, confirmCallBacks);
            } else {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u884c", (String)"PurOrderMobPlugin_38", (String)"drp-dpa-formplugin", (Object[])new Object[0]) + errorInfos.toString().substring(0, errorInfos.toString().length() - 1) + ResManager.loadKDString((String)"\uff1a\u4e0b\u5355\u6570\u91cf\u8d85\u51fa\u5e93\u5b58\u53ef\u7528\u6570\u91cf\uff01", (String)"PurOrderMobPlugin_40", (String)"drp-dpa-formplugin", (Object[])new Object[0]));
            }
        } else if (operatekey.equals(OP_CHECKSAVE)) {
            this.getView().invokeOperation(SAVE);
        } else {
            this.orderLimitCheck();
        }
    }

    private DynamicObject getMyStoreDyn(List<DynamicObject> tempMyStoreDyns, DynamicObject myStoreDyn) {
        if (tempMyStoreDyns.size() == 1 && myStoreDyn == null) {
            return tempMyStoreDyns.get(0);
        }
        return myStoreDyn;
    }

    private List<DynamicObject> findMyStoreDynsAndAppendSb(StringBuilder sb, DynamicObject itemEntry, String propertyInItemEntry, String propertyInMyStore, List<DynamicObject> tempMyStoreDyns) {
        DynamicObject dynInItemEntry = itemEntry.getDynamicObject(propertyInItemEntry);
        if (dynInItemEntry != null) {
            sb.append(dynInItemEntry.get("id"));
            if (tempMyStoreDyns.size() > 1) {
                tempMyStoreDyns = tempMyStoreDyns.stream().filter(i -> dynInItemEntry.getLong("id") == i.getLong(propertyInMyStore + "_id")).collect(Collectors.toList());
            }
        }
        return tempMyStoreDyns;
    }

    public <K, V> Map.Entry<K, V> getTail(LinkedHashMap<K, V> map) {
        Iterator<Map.Entry<K, V>> iterator = map.entrySet().iterator();
        Map.Entry<K, V> tail = null;
        while (iterator.hasNext()) {
            tail = iterator.next();
        }
        return tail;
    }

    private boolean checkTel() {
        String tel = this.getModel().getDataEntity().getString("customerphone");
        if (StringUtils.isEmpty((String)(tel = tel.trim()))) {
            return true;
        }
        tel = tel.trim();
        this.setValue("customerphone", tel);
        CheckResult check = ValidateUtils.validPhoneNum((PhoneType)PhoneType.ALL, (String)tel);
        if (!check.isSuccess()) {
            this.getView().showMessage(check.getMsg());
            return false;
        }
        return true;
    }

    protected void doWhenOrderQuantityFailed(BeforeDoOperationEventArgs e, String errorMsg) {
        if (this.isOrderQuantityStrongControl()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25:", (String)"PurOrderMobPlugin_7", (String)"drp-dpa-formplugin", (Object[])new Object[0]) + errorMsg);
            e.setCancel(true);
        }
    }

    protected String checkOrderQuantity() {
        if (!this.isUseOrderQuantity()) {
            return "";
        }
        int count = this.getModel().getEntryRowCount("itementry");
        StringBuilder errorMsg = new StringBuilder();
        for (int i = 0; i < count; ++i) {
            String errormsg = this.getOrderQuantityMsg(i);
            if (StringUtils.isEmpty((String)errormsg)) continue;
            BigDecimal entryqty = new BigDecimal(errormsg.split(SPLITKEY)[1]);
            errormsg = errormsg.split(SPLITKEY)[0];
            if (this.isOrderQuantityStrongControl()) {
                this.setValue("alterqty", entryqty, i);
                this.setValue("qty", entryqty, i);
            }
            errorMsg.append(errormsg);
            errorMsg.append('\n');
        }
        return errorMsg.toString();
    }

    protected boolean isUseOrderQuantity() {
        DynamicObject bizType = (DynamicObject)this.getModel().getValue(F_easbusinesstype);
        if (bizType == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e1a\u52a1\u7c7b\u578b \u4e0d\u80fd\u4e3a\u7a7a", (String)"PurOrderMobPlugin_8", (String)"drp-dpa-formplugin", (Object[])new Object[0]));
        }
        return bizType.getBoolean("isuseorderquantity");
    }

    private void sycnEntryWareHouse() {
        Object id = this.getWareHouseF7PKValue();
        int count = this.getModel().getEntryRowCount("itementry");
        int len = count;
        for (int i = 0; i < len; ++i) {
            this.setRowValue("entrywarehouse", id, i);
        }
    }

    public void afterCreateNewData(EventObject e) {
        this.addExecutrionListListener();
        Object customerid = this.getParameter("customerid");
        this.setCustomerF7Value(customerid);
        this.setF7Value("warehouse", this.getParameter("warehouseid"));
        this.getPageCache().put("hasInitCustomer", "yes");
        this.setF7Value("directcustomer", customerid);
        if (this.isNewCreate()) {
            List cartList = (List)this.getParameter("cartList");
            this.setOwnerF7Value(this.getParameter("ownerid"));
            this.fromShoppingCart(cartList);
        }
        SaleOrderStatus status = SaleOrderUtil.getOrderStatus((DynamicObject)this.getModel().getDataEntity());
        this.initFieldView(status);
        this.initNumber();
        this.setBillParameters();
        this.initCustomerPhone();
    }

    protected void initCustomerPhone() {
        DynamicObject customer = this.getCustomerF7Value();
        if (customer == null) {
            this.setValue("customerphone", "");
            return;
        }
        String phone = customer.getString("phone");
        if (StringUtils.isNotEmpty((String)phone)) {
            phone = phone.trim();
        }
        this.setValue("customerphone", phone);
    }

    protected void initBizType() {
        QFilter q = new QFilter("enable", "=", (Object)"1");
        q.and("status", "=", (Object)"C");
        DynamicObjectCollection bizTypes = QueryServiceHelper.query((String)"mdr_biztype", (String)"id", (QFilter[])q.toArray(), (String)"isdefault desc");
        if (bizTypes != null && bizTypes.size() > 0) {
            this.setValue(F_easbusinesstype, ((DynamicObject)bizTypes.get(0)).get("id"));
        }
    }

    protected void setBillParameters() {
        DynamicObject billTypeParam;
        String formid = this.getView().getFormShowParameter().getFormId();
        String billTypeParamName = "";
        String newFormId = "";
        switch (formid) {
            case "dpa_purorder_mob": {
                billTypeParamName = "dpa_purorder_btparam";
                newFormId = "dpa_purorder";
                break;
            }
            case "bbc_saleorder_mob": {
                billTypeParamName = "bbc_saleorder_btparam";
                newFormId = "bbc_saleorder";
            }
        }
        DynamicObject billType = (DynamicObject)this.getModel().getValue("billtypeid");
        if (null != billType && StringUtils.isNotEmpty((String)newFormId) && (billTypeParam = BillTypeParameterHelper.getBillTypeParameter((String)newFormId, (String)billTypeParamName, (long)((Long)billType.getPkValue()))) != null) {
            DynamicObject businesstype = billTypeParam.getDynamicObject("businesstype");
            if (businesstype != null) {
                this.getModel().setValue("businesstype", businesstype.getPkValue());
            }
            long defaultEASBusinessId = 0L;
            DynamicObject mdrBiztype = BusinessDataServiceHelper.loadSingle((String)"mdr_biztype", (String)"id,number,name", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)DEFAULTEASBUSINESSTYPEID)});
            if (null != mdrBiztype) {
                defaultEASBusinessId = mdrBiztype.getLong("id");
            }
            DynamicObject easbusinesstype = null;
            switch (formid) {
                case "dpa_purorder_mob": {
                    easbusinesstype = billTypeParam.getDynamicObject("easbusinesstype");
                    if (easbusinesstype != null) {
                        this.getModel().setValue(F_easbusinesstype, easbusinesstype.getPkValue());
                    } else {
                        this.getModel().setValue(F_easbusinesstype, (Object)defaultEASBusinessId);
                    }
                    DynamicObject bbcorderbilltype = billTypeParam.getDynamicObject("bbcorderbilltype");
                    if (bbcorderbilltype == null) break;
                    this.getModel().setValue(F_saleorderbilltypeid, bbcorderbilltype.getPkValue());
                    break;
                }
                case "bbc_saleorder_mob": {
                    easbusinesstype = billTypeParam.getDynamicObject("easbusinesstype");
                    if (easbusinesstype != null) {
                        this.getModel().setValue(F_easbusinesstype, easbusinesstype.getPkValue());
                        break;
                    }
                    this.getModel().setValue(F_easbusinesstype, (Object)defaultEASBusinessId);
                }
            }
        }
    }

    protected void fromShoppingCart(List<Object> cartList) {
        this.initOrderData();
        this.createItemRow(cartList);
        this.initBalanceInfo();
    }

    private void initOrderData() {
        this.initDefaultArrivalDate();
        this.initDefaultReceipt();
        this.initDefaultConsignee();
        this.initRegion();
        this.initDefaultSaler();
        this.initDefaultDepartment();
        this.initDefaultDispatcher();
        this.initDefaultWareHouse();
        this.initRebate();
    }

    private void initDefaultArrivalDate() {
        int date = this.queryLeadTime();
        Date arrivalDate = DateUtil.getNextDate((Date)new Date(), (int)date);
        this.setDateFieldValue("arrivaldate", arrivalDate);
        this.setDateFieldValue("confirmarrivaldate", arrivalDate);
    }

    private int queryLeadTime() {
        DynamicObject info = CustomerUtil.getAuthBizInfo((Object)this.getOwnerF7PKValue(), (Object)this.getCustomerF7PKValue());
        return info.getInt("leadtime");
    }

    private void initDefaultReceipt() {
        List ids = ReceiptUtil.queryReceiptPK((Object)this.getCustomerF7PKValue());
        if (!ids.isEmpty()) {
            this.setReceiptF7Value(ids.get(0));
        }
    }

    private void initDefaultConsignee() {
        List ids = ConsigneeAddressUtil.queryConsigneeAddressPK((Object)this.getCustomerF7PKValue());
        if (!ids.isEmpty()) {
            this.setConsigneeAddressF7Value(ids.get(0));
            this.setConsigneeInfo();
        }
    }

    protected void initDefaultSaler() {
        this.setSalerF7Value(null);
        List salers = CustomerSalerUtil.queryCustomerSalerPK((Object)this.getCustomerF7PKValue(), (Object)this.getOwnerF7PKValue());
        if (!salers.isEmpty()) {
            this.setSalerF7Value(salers.get(0));
        }
    }

    protected void initDefaultDepartment() {
        Object salerid = this.getF7PKValue("saler");
        if (salerid != null) {
            this.setValue("department", UserUtil.getDefaultAdminOrgID((Object)salerid));
        }
    }

    protected void initDefaultDispatcher() {
        Object departmentid = this.getF7PKValue("department");
        if (departmentid != null) {
            this.setValue("dispatcher", UserUtil.getDefaultDispatcherId((Object)departmentid));
        }
    }

    protected void initRegion() {
        Object regionId = CustomerUtil.queryCustomerRegion((Object)this.getOwnerF7PKValue(), (Object)this.getCustomerF7PKValue());
        if (regionId != null) {
            this.setRegionF7Value(regionId);
        }
    }

    protected void initDefaultOwner() {
        List ids = CustomerUtil.getAuthOwnerIDs((Object)this.getCustomerF7PKValue());
        this.setOwnerF7Value(ids.get(0));
    }

    private void initDefaultWareHouse() {
        List ids = WarehouseRuleUtil.getWarehouseList((Object)this.getOwnerF7PKValue(), (Object)this.getCustomerF7PKValue());
        if (ids != null && !ids.isEmpty()) {
            this.setWareHouseF7Value(ids.get(0));
        }
    }

    protected void initFieldView(SaleOrderStatus status) {
        IFormView view = this.getView();
        switch (status) {
            case CHANGING: {
                view.setEnable(Boolean.FALSE, new String[]{"transportprice", "transportamount"});
                break;
            }
        }
    }

    protected void initRebate() {
        this.triggerChangeEvent = false;
        this.setValue("canuserebate", Boolean.FALSE);
        this.setUnEnable(new String[]{"usedrebate"});
        this.triggerChangeEvent = true;
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.initExecutionList();
    }

    public void afterBindData(EventObject e) {
        this.setBalanceInfo();
        this.setConsigneeInfo();
        this.setCountInfo();
        this.setAmountLable(true);
        this.setItemListColumn();
        this.hiddenAddItemButton();
        this.hiddenFlex();
        this.setSaleOrg();
    }

    protected final void setSaleOrg() {
        DynamicObject bizgroup;
        DynamicObject ownerF7Value = this.getOwnerF7Value();
        if (null != ownerF7Value && null != (bizgroup = ownerF7Value.getDynamicObject("bizgroup"))) {
            this.setValue("saleorgid", bizgroup);
            this.setSettleOrg((DynamicObject)this.getModel().getValue("saleorgid"));
            this.setEntryStockInfo();
        }
    }

    protected final void setSettleOrg(DynamicObject saleOrg) {
        if (null == saleOrg) {
            this.setValue("settleorgid", null);
        } else {
            Map map = OrgUnitServiceHelper.getCompanyByOrg((Long)saleOrg.getLong("id"), (Boolean)false, (Boolean)true);
            if (!CollectionUtils.isEmpty((Map)map)) {
                this.setValue("settleorgid", map.get("id"));
            } else {
                this.setValue("settleorgid", null);
            }
        }
        this.setExRateTable();
    }

    private void setExRateTable() {
        DynamicObject[] accountingsys;
        Object settleOrg = this.getValue("settleorgid");
        if (null == settleOrg) {
            this.setValue("exratetableid", null);
            this.setValue("exchangerate", 1, false);
            this.setValue("localcurrency", null, false);
        } else if (settleOrg instanceof DynamicObject && (accountingsys = BusinessDataServiceHelper.load((String)"bd_accountingsys_base", (String)"id,exratetable,basecurrrency", (QFilter[])new QFilter[]{new QFilter("baseacctorg", "=", ((DynamicObject)settleOrg).getPkValue())})).length > 0) {
            Object exratetable = accountingsys[0].get("exratetable");
            if (null == exratetable) {
                return;
            }
            this.setValue("exratetableid", exratetable);
            Object currency = this.getValue("currency");
            if (null == currency) {
                return;
            }
            Long srcCurId = (Long)((DynamicObject)currency).getPkValue();
            Object orderDate = this.getValue("orderdate");
            if (null == orderDate) {
                return;
            }
            Object basecurrrency = accountingsys[0].get("basecurrrency");
            if (null == basecurrrency) {
                return;
            }
            this.setValue("localcurrency", basecurrrency, false);
            this.setExchangeRate(srcCurId, (Long)((DynamicObject)basecurrrency).getPkValue(), (Long)((DynamicObject)exratetable).getPkValue(), (Date)orderDate);
        }
    }

    private void setExchangeRate(Long srcCurId, Long targetCurId, Long exRateTableId, Date date) {
        BigDecimal exchangeRate = this.calcExChangeRate(srcCurId, targetCurId, exRateTableId, date);
        this.setValue("exchangerate", exchangeRate);
    }

    private BigDecimal calcExChangeRate(Long srcCurId, Long targetCurId, Long exRateTableId, Date date) {
        BigDecimal exchangeRate = BigDecimal.ZERO;
        if (srcCurId.equals(targetCurId)) {
            exchangeRate = BigDecimal.valueOf(1L);
        } else {
            exchangeRate = BaseDataServiceHelper.getExchangeRate((Long)exRateTableId, (Long)srcCurId, (Long)targetCurId, (Date)date);
            if (null == exchangeRate || BigDecimal.ZERO.compareTo(exchangeRate) >= 0) {
                exchangeRate = BigDecimal.ONE;
            }
        }
        return exchangeRate;
    }

    private void setEntryStockInfo() {
        Object saleorg = this.getModel().getValue("saleorgid");
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("itementry");
        for (DynamicObject dynamicObject : entryEntity) {
            Object delegation = dynamicObject.get(F_stockorgid);
            if (null == delegation) {
                dynamicObject.set(F_stockorgid, saleorg);
            }
            dynamicObject.set("sendcustomer", this.getModel().getValue("owner"));
            dynamicObject.set("receivercustomer", this.getModel().getValue("owner"));
            dynamicObject.set("consigneecutomer", this.getModel().getValue("customer"));
            dynamicObject.set("paycustomer", this.getModel().getValue("customer"));
        }
    }

    private void initExecutionList() {
        if (!SysParamsUtil.isUsePromotion()) {
            this.setDisVisible(new String[]{"promotionflex"});
            return;
        }
        if (this.isAddNew()) {
            return;
        }
        this.loadPromotionCache();
        this.addExecutrionListListener();
    }

    private void hiddenAddItemButton() {
        Tab tab = (Tab)this.getControl("tabap");
        String currentTab = tab.getCurrentTab();
        if (PAGE_ENTRYINFO.equals(currentTab)) {
            this.setVisible(new String[]{ADDITEM});
        } else {
            this.setDisVisible(new String[]{ADDITEM});
        }
    }

    protected void setItemListColumn() {
        if (this.isNewCreate()) {
            return;
        }
        IDataModel model = this.getModel();
        DynamicObjectCollection itementry = (DynamicObjectCollection)model.getValue("itementry");
        int i = 0;
        for (DynamicObject entry : itementry) {
            model.setValue("assistunitname", entry.get("assistunit.name"), i);
            model.setValue("currencyname", (Object)this.getTransferCurrencyName(), i);
            model.setValue("unitnamemob", entry.get("unit.name"), i);
            model.setValue("itemimg", entry.get("item.thumbnail"), i);
            ++i;
        }
    }

    protected void setCountInfo() {
        String code;
        this.setPayrecordCount();
        Object orderStatus = this.getModel().getValue("orderstatus");
        if (null != orderStatus && "C".compareToIgnoreCase(code = String.valueOf(orderStatus)) < 0) {
            this.setDeliverycordCount();
        }
        this.setEvaluateCount();
    }

    protected void setDeliverycordCount() {
        ArrayList<QFilter> tbFilters = new ArrayList<QFilter>();
        tbFilters.add(new QFilter("deliverydetail.mainbillid", "=", (Object)this.getId()));
        int count = ORM.create().count("MDR", "bbc_delivery_record", tbFilters.toArray(new QFilter[tbFilters.size()]));
        this.setValue("deliverycordcount", count);
    }

    protected void setPayrecordCount() {
        ArrayList<QFilter> tbFilters = new ArrayList<QFilter>();
        tbFilters.add(new QFilter("orderid", "=", (Object)this.getId().toString()));
        int count = ORM.create().count("MDR", "mdr_money_receiveinh", tbFilters.toArray(new QFilter[tbFilters.size()]));
        this.setValue("payrecordcount", count);
    }

    protected void setAmountLable(boolean isInitModel) {
        SaleOrderAlgorithm saleOrderAlgorithm = this.getAlgorithm();
        BigDecimal totalDiscountAmount = saleOrderAlgorithm.sumEntryFiled("discountamount");
        this.setValue("totaldiscountamount", totalDiscountAmount);
        BigDecimal totalItemAmount = this.getModel().getDataEntity(true).getBigDecimal("totalitemamount");
        BigDecimal totalpromotionAmount = saleOrderAlgorithm.sumEntryFiled("promotionamount");
        this.setValue("totalpromotionamount", totalItemAmount.subtract(totalpromotionAmount));
        BigDecimal totalRebateAmount = saleOrderAlgorithm.sumEntryFiled("rebateamount");
        this.setValue("totalrebateamount", totalpromotionAmount.subtract(totalRebateAmount));
    }

    private void setEntryConsigneeInfo(int index) {
        this.setRowValue("entryconsignee", this.getTextFieldValue("consignee"), index);
        this.setRowValue("entryconsigneephone", this.getTextFieldValue("consigneephone"), index);
        this.setRowValue("entryaddress", this.getTextFieldValue("address"), index);
    }

    public void afterCopyData(EventObject e) {
        this.addExecutrionListListener();
        this.initHeadFromCopy();
        this.initEntryFromCopy();
        this.initPromotionCacheKey();
        this.matchPromotion();
        this.getAlgorithm().reCalFields();
        this.initBalanceInfo();
        this.initItemListLabel();
        this.initNumber();
    }

    protected void initNumber() {
        String number;
        DynamicObject obj = this.getModel().getDataEntity();
        obj.set("createtime", (Object)new Date());
        obj.set("orderdate", (Object)new Date());
        CodeRuleInfo codeRuleInfo = CodeRuleServiceHelper.getCodeRule((String)obj.getDataEntityType().getName(), (DynamicObject)obj, null);
        if (codeRuleInfo != null && !StringUtils.isEmpty((String)(number = CodeRuleServiceHelper.getNumber((CodeRuleInfo)codeRuleInfo, (DynamicObject)obj)))) {
            this.getModel().setValue("billno", (Object)number);
            this.setEnable(new String[]{"billno"});
        }
    }

    protected void initEntryFromCopy() {
        DynamicObjectCollection itemEntry = this.getModel().getEntryEntity("itementry");
        if (itemEntry == null || itemEntry.size() == 0) {
            return;
        }
        List<Long> userabelItemIds = this.getEntryUserableItems(itemEntry);
        BigDecimal taxRate = this.getDefaultTaxRate();
        boolean isExistDisableItem = false;
        for (int i = 0; i < itemEntry.size(); ++i) {
            if (this.isPresent(i) || this.isItemDisable(i, userabelItemIds)) {
                if (this.isItemDisable(i, userabelItemIds)) {
                    isExistDisableItem = true;
                }
                this.getModel().deleteEntryRow("itementry", i);
                --i;
                continue;
            }
            this.setId4RowIfNoId(i);
            this.setValue("taxrate", taxRate, i, false);
            this.setValue("isevaluate", "0", i);
            this.getAlgorithm().calPrimAmount(i);
        }
        if (isExistDisableItem) {
            this.getView().showTipNotification("\u5b58\u5728\u90e8\u5206\u5546\u54c1\u88ab\u7981\u7528\u6216\u53cd\u5ba1\u6838\uff0c\u672a\u590d\u5236\u6210\u529f\u3002");
        }
    }

    private List<Long> getEntryUserableItems(DynamicObjectCollection itemEntry) {
        List<Long> itemids = itemEntry.stream().map(p -> p.getDynamicObject("item").getLong("id")).collect(Collectors.toList());
        QFilter qf = new QFilter("id", "in", (Object)itemids.toArray(new Long[itemids.size()]));
        DynamicObjectCollection disbleItems = QueryServiceHelper.query((String)"mdr_item_info", (String)"id,enable,status", (QFilter[])qf.toArray());
        return disbleItems.stream().filter(p -> "1".equals(p.getString("enable")) && "C".equals(p.getString("status"))).map(p -> p.getLong("id")).collect(Collectors.toList());
    }

    protected BigDecimal getDefaultTaxRate() {
        return this.getAlgorithm().getDefaultTaxRate();
    }

    protected void setId4RowIfNoId(int index) {
        Object entryId = this.getEntryId(index);
        if (entryId == null || (Long)entryId == 0L) {
            DynamicObject newEntry = BusinessDataServiceHelper.newDynamicObject((String)this.getModel().getDataEntityType().getName()).getDynamicObjectCollection("itementry").addNew();
            long genLongId = DB.genLongId((String)((EntryType)newEntry.getDataEntityType()).getAlias());
            DynamicObject parentrow = this.getModel().getEntryRowEntity("itementry", index);
            parentrow.set("id", (Object)genLongId);
        }
    }

    private Object getEntryId(int parentIndex) {
        DynamicObject parentrow = this.getModel().getEntryRowEntity("itementry", parentIndex);
        return parentrow.getPkValue();
    }

    protected void matchPromotion() {
        if (!SysParamsUtil.isUsePromotion()) {
            return;
        }
        if (this.getOwnerF7PKValue() == null || this.getCustomerF7PKValue() == null) {
            return;
        }
        PromotionServiceHelper.match((String)this.getPromotionCacheKey(), (PromotionOrder)this.getAlgorithm().buildPromotionOrder());
        this.refreshViewByPromotion();
    }

    protected void initPromotionCacheKey() {
        if (SysParamsUtil.isUsePromotion()) {
            this.getPromotionCacheKey();
        }
    }

    protected void initHeadFromCopy() {
        this.initCreatorAndTime();
        this.setValue("orderdate", new Date());
        this.initDefaultArrivalDate();
        this.setValue("confirmstatus", "A");
        this.setValue("isdelete", Boolean.FALSE);
        this.setValue("amountstatus", "A");
        this.setValue("paystatus", "A");
        this.setValue("evaluatestatus", "A");
        this.setValue("sync", "D");
        this.resetHeadValueFromCopy();
    }

    private void resetHeadValueFromCopy() {
        for (int j = 0; j < qtys.length; ++j) {
            this.setValue(qtys[j], null);
        }
    }

    protected void initItemListLabel() {
        CardEntry card = (CardEntry)this.getView().getControl("itementry");
        if (card == null) {
            return;
        }
        DynamicObjectCollection objs = this.getModel().getEntryEntity("itementry");
        if (objs != null) {
            for (int i = 0; i < objs.size(); ++i) {
                this.setValue("currencyname", this.getTransferCurrencyName(), i);
                Object unit = this.getValue("unit", i);
                if (unit == null) continue;
                this.setValue("unitnamemob", ((DynamicObject)unit).get("name"), i);
            }
        }
    }

    protected void createItemRow(List<Object> cartList) {
        IDataModel model = this.getModel();
        QFilter filter = new QFilter("id", "in", cartList);
        DynamicObject[] cartItemCollection = BusinessDataServiceHelper.load((String)"mdr_shopping_cart", (String)"id,item.id,item.thumbnail,unit.id,unit.name,item.material,price,qty,assistqty,assistunit.id,assistunit.name,assistunit.precision,assistattr.id", (QFilter[])filter.toArray());
        if (cartItemCollection.length <= 0) {
            return;
        }
        model.batchCreateNewEntryRow("itementry", cartItemCollection.length);
        this.getView().sendFormAction(this.getView());
        int i = 0;
        BigDecimal defaultTaxRate = this.getDefaultTaxRate();
        for (DynamicObject cartItem : cartItemCollection) {
            this.triggerChangeEvent = false;
            Object itemId = cartItem.get("item.id");
            Object unitId = cartItem.get("unit.id");
            Object assistattrId = cartItem.get("assistattr.id");
            DynamicObject entryRow = model.getEntryRowEntity("itementry", i);
            entryRow.set("material", (Object)cartItem.getDynamicObject("item.material"));
            entryRow.set("item", (Object)cartItem.getDynamicObject("item"));
            entryRow.set("unit", (Object)cartItem.getDynamicObject("unit"));
            entryRow.set("assistattr", (Object)cartItem.getDynamicObject("assistattr"));
            entryRow.set("itemimg", (Object)cartItem.getString("item.thumbnail"));
            entryRow.set("assistunit", (Object)cartItem.getDynamicObject("assistunit"));
            entryRow.set("assistunitname", (Object)cartItem.getString("assistunit.name"));
            entryRow.set("unitnamemob", (Object)cartItem.getString("unit.name"));
            BigDecimal qty = (BigDecimal)cartItem.get("qty");
            entryRow.set("qty", (Object)qty);
            entryRow.set("alterqty", (Object)qty);
            entryRow.set("taxrate", (Object)defaultTaxRate);
            BigDecimal price = (BigDecimal)cartItem.get("price");
            price = this.getPrice(i, itemId, unitId, qty, assistattrId);
            entryRow.set("primprice", (Object)price);
            entryRow.set("taxprice", (Object)price);
            entryRow.set("ispromotional", (Object)"");
            this.triggerChangeEvent = true;
            this.initItemInfo(i);
            ++i;
        }
        this.getAlgorithm().reCalFields();
        this.afterInitNewPresentRowData();
    }

    protected void addItemEntry(List<Map<String, Object>> itemlist) {
        if (itemlist == null) {
            return;
        }
        int i = this.getModel().getEntryRowCount("itementry");
        for (Map<String, Object> data : itemlist) {
            this.addItem(data, i);
            ++i;
        }
        this.getAlgorithm().reCalFields();
        this.hiddenFlex();
    }

    protected void addItem(Map<String, Object> data, int i) {
        IDataModel model = this.getModel();
        model.createNewEntryRow("itementry");
        this.triggerChangeEvent = false;
        model.setValue("item", data.get("itemid"), i);
        model.setValue("unit", data.get("unitid"), i);
        model.setValue("taxrate", (Object)this.getDefaultTaxRate(), i);
        model.setValue("assistattr", data.get("assistattrid"), i);
        DynamicObject iteminfo = (DynamicObject)this.getValue("item", i);
        if (iteminfo != null) {
            model.setValue("itemimg", iteminfo.get("thumbnail"), i);
            model.setValue("material", iteminfo.get("material"), i);
        }
        BigDecimal price = (BigDecimal)data.get("price");
        model.setValue("primprice", (Object)price, i);
        model.setValue("taxprice", (Object)price, i);
        if (data.get("assistunitid") != null) {
            model.setValue("assistunit", data.get("assistunitid"), i);
            BigDecimal assistqty = new BigDecimal(data.get("assistqty").toString());
            model.setValue("assistqty", (Object)assistqty, i);
            model.setValue("assistunitname", data.get("assistunitname"), i);
        }
        model.setValue("unitnamemob", data.get("unitname"), i);
        BigDecimal qty = BigDecimal.ZERO;
        Object dataQty = data.get("qty");
        if (dataQty instanceof Integer) {
            qty = new BigDecimal((Integer)dataQty);
        } else if (dataQty instanceof BigDecimal) {
            qty = (BigDecimal)dataQty;
        }
        model.setValue("qty", (Object)qty, i);
        model.setValue("alterqty", (Object)qty, i);
        this.triggerChangeEvent = true;
        this.initItemInfo(i);
    }

    protected void initItemInfo(int i) {
        this.initItemEntryInfo(i);
        this.copyHeadInfo(i);
        this.initReceiveWarehouse(i);
        this.initRowUnits(i);
        this.reCalcuAllQty(i);
    }

    private void initRowAssistUnits(int index) {
        Object itemPK = this.getEntryF7PKValue("itementry", "item", index);
        Object assistUnit = this.getUnitFormHandler().getAssistUnitId(itemPK);
        if (assistUnit == null) {
            this.setRowValue("assistunit", null, index);
            this.setRowValue("assistqty", null, index);
            this.setRowValue("alterassistqty", null, index);
            this.setUnEnable(index, new String[]{"assistunit", "assistqty", "alterassistqty"});
        } else {
            this.setRowValue("assistunit", assistUnit, index);
            this.setUnEnable(index, new String[]{"assistunit"});
            this.setEnable(index, new String[]{"assistqty", "alterassistqty"});
        }
    }

    private void initItemEntryInfo(int index) {
        IDataModel model = this.getModel();
        DynamicObject itemEntry = model.getEntryRowEntity("itementry", index);
        DynamicObject newEntry = BusinessDataServiceHelper.newDynamicObject((String)this.getModel().getDataEntityType().getName()).getDynamicObjectCollection("itementry").addNew();
        Long entryId = DB.genLongId((String)((EntryType)newEntry.getDataEntityType()).getAlias());
        itemEntry.set("id", (Object)entryId);
        itemEntry.set("currencyname", (Object)this.getTransferCurrencyName());
        itemEntry.set("custchangeprice", (Object)Boolean.FALSE);
        Object onwer = this.getOwnerF7PKValue();
        itemEntry.set("sendcustomer", onwer);
        itemEntry.set("receivercustomer", onwer);
        Object customer = this.getCustomerF7PKValue();
        itemEntry.set("consigneecutomer", customer);
        itemEntry.set("paycustomer", customer);
        this.setValue("isevaluate", Character.valueOf('0'), index);
    }

    private String getTransferCurrencyName() {
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
        String currencyName = currency.getString("name");
        if (ResManager.loadKDString((String)"\u4eba\u6c11\u5e01", (String)"PurOrderMobPlugin_9", (String)"drp-dpa-formplugin", (Object[])new Object[0]).equals(currencyName) || "CNY".equals(currencyName)) {
            currencyName = ResManager.loadKDString((String)"\u5143", (String)"PurOrderMobPlugin_10", (String)"drp-dpa-formplugin", (Object[])new Object[0]);
        }
        return currencyName;
    }

    private void initReceiveWarehouse(int index) {
        List list = WarehouseRuleUtil.queryWarehouse((Object)this.getCustomerF7PKValue());
        if (!list.isEmpty()) {
            this.setRowValue("entryreceivewarehouse", list.get(0), index);
            this.setEnable(index, new String[]{"entryreceivewarehouse"});
        } else {
            this.setUnEnable(index, new String[]{"entryreceivewarehouse"});
        }
    }

    private void initRowUnits(int index) {
        Object itemPK = this.getEntryF7PKValue("itementry", "item", index);
        Object unit = this.getUnitFormHandler().getSaleUnitId(itemPK);
        this.setF7Value("baseunit", unit, index);
        Object assistUnit = this.getUnitFormHandler().getAssistUnitId(itemPK);
        if (assistUnit == null) {
            this.setUnEnable(index, new String[]{"assistunit", "assistqty"});
        } else {
            this.setRowValue("assistunit", assistUnit, index);
            this.setEnable(index, new String[]{"assistunit", "assistqty"});
        }
    }

    private void reCalcuAllQty(int index) {
        Object itemId = this.getEntryF7PKValue("itementry", "item", index);
        DynamicObject rowInfo = this.getRowInfo("itementry", index);
        BigDecimal unitQty = rowInfo.getBigDecimal("qty");
        DynamicObject unit = rowInfo.getDynamicObject("unit");
        BigDecimal baseQty = this.getUnitFormHandler().getBaseQty(itemId, unitQty, unit.get("id"));
        this.setValue("baseqty", baseQty, index);
        this.setValue("alterbaseqty", baseQty, index);
        DynamicObject assisUnit = rowInfo.getDynamicObject("assistunit");
        if (assisUnit == null) {
            return;
        }
        BigDecimal assistQty = this.getUnitFormHandler().getUnitQty(itemId, assisUnit.get("id"), baseQty);
        this.setValue("assistqty", assistQty, index);
        this.setValue("alterassistqty", assistQty, index);
    }

    private void copyHeadInfo(int index) {
        Date arrivalDate = this.getDateFieldValue("arrivaldate");
        this.setRowValue("entryarrivaldate", arrivalDate, index);
        this.setRowValue("entryconfirmarrivaldate", arrivalDate, index);
        Object address = this.getF7PKValue("consigneeaddress");
        this.setRowValue("entryconsigneeaddress", address, index);
        this.setEntryConsigneeInfo(index);
        Object wareHouse = this.getF7PKValue("warehouse");
        if (wareHouse != null) {
            this.setUnEnable(index, new String[]{"entrywarehouse"});
        } else {
            wareHouse = WarehouseRuleUtil.getWarehouse((Object)this.getOwnerF7PKValue(), (Object)this.getCustomerF7PKValue(), (Object)this.getEntryF7PKValue("itementry", "item", index));
        }
        this.setRowValue("entrywarehouse", wareHouse, index);
    }

    protected void updateEntryInfo(Map<String, Object> data) {
        BigDecimal qty = (BigDecimal)data.get("qty");
        BigDecimal price = (BigDecimal)data.get("price");
        Object unitid = data.get("unitid");
        Object unitname = data.get("unitname");
        Object assistattrid = data.get("assistattrid");
        Integer entryindex = Integer.valueOf(data.get("entryindex").toString());
        this.triggerChangeEvent = false;
        if (data.get("assistqty") != null) {
            this.setValue("assistqty", data.get("assistqty"), entryindex);
        }
        this.setValue("unit", unitid, entryindex);
        this.setValue("unitnamemob", unitname, entryindex);
        this.setValue("qty", qty, entryindex);
        this.setValue("taxprice", price, entryindex);
        this.setValue("assistattr", assistattrid, entryindex);
        this.triggerChangeEvent = true;
        this.getAlgorithm().reCalFields(entryindex.intValue(), true);
    }

    protected void deleteEntry() {
        CardEntry itemEntry = (CardEntry)this.getControl("itementry");
        int index = itemEntry.getSelectRows()[0];
        this.getModel().deleteEntryRow("itementry", index);
        this.executePromotion();
        this.getAlgorithm().calTotalFields();
    }

    private void propertyChangedOnItem(PropertyChangedArgs e, int index) {
        if (this.isPresent(index)) {
            return;
        }
        String key = e.getProperty().getName();
        ChangeData data = e.getChangeSet()[0];
        Object oldValue = data.getOldValue();
        switch (key) {
            case "unit": {
                this.unitChanged(index, key, oldValue);
                break;
            }
            case "assistattr": {
                this.itemAssistAttrChanged(index, oldValue);
                break;
            }
            case "alterassistqty": 
            case "assistqty": 
            case "alterqty": 
            case "qty": {
                this.qtysChanged(index, (BigDecimal)oldValue, key);
                break;
            }
            case "taxprice": 
            case "price": {
                this.priceChanged(index, (BigDecimal)oldValue, key);
                break;
            }
            default: {
                this.triggerChangeEvent = true;
            }
        }
    }

    protected void unitChanged(int index, String key, Object oldUnit) {
        DynamicObject rowInfo = this.getRowInfo("itementry", index);
        DynamicObject unit = rowInfo.getDynamicObject("unit");
        if (unit == null) {
            this.setValue(key, oldUnit, index);
            return;
        }
        this.getAlgorithm().calByUnit(index, true);
        this.checkOrderQuantity(index);
        this.initBalanceInfo();
    }

    protected void itemAssistAttrChanged(int index, Object oldValue) {
        DynamicObject assistattr;
        Object itemId = this.getEntryF7PKValue("itementry", "item", index);
        if (!BizValidateUtils.itemAttrNullValidate((Object)itemId, (DynamicObject)(assistattr = this.getEntryF7Value("itementry", "assistattr", index)))) {
            if (oldValue != null) {
                this.setValue("assistattr", oldValue, index);
            }
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5546\u54c1\u5f00\u542f\u8f85\u52a9\u5c5e\u6027\uff0c\u8f85\u52a9\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a\uff01", (String)"PurOrderMobPlugin_11", (String)"drp-dpa-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getAlgorithm().calByAssistAttr(index, true);
        this.checkOrderQuantity(index);
        this.initBalanceInfo();
    }

    protected void priceChanged(int index, BigDecimal oldPrice, String key) {
        boolean hasChange = this.checkBigDecimalChange(index, oldPrice, key);
        if (!hasChange) {
            return;
        }
        BigDecimal price = (BigDecimal)this.getModel().getValue(key, index);
        CheckResult result = this.checkLowestPrice(index, price);
        if (!result.isSuccess()) {
            this.setRowValue(key, oldPrice, index);
            this.getView().showMessage(result.getMsg());
            return;
        }
        this.setValue("custchangeprice", Boolean.TRUE, index);
        if (SaleOrderUtil.isThisStatus((DynamicObject)this.getModel().getDataEntity(), (SaleOrderStatus)SaleOrderStatus.CHANGING) && SysParamsUtil.isAlterPriceResetPrice() || SaleOrderUtil.isThisStatus((DynamicObject)this.getModel().getDataEntity(), (SaleOrderStatus)SaleOrderStatus.TEMP_SAVE)) {
            SaleOrderAlgorithm saleOrderAlgorithm = this.getAlgorithm();
            saleOrderAlgorithm.resetPrimPrice(index);
            saleOrderAlgorithm.calPrimAmount(index);
        }
        switch (key) {
            case "price": {
                this.getAlgorithm().calByPrice(index, true);
                this.afterInitNewPresentRowData();
                break;
            }
            case "taxprice": {
                this.getAlgorithm().calByTaxPrice(index, true);
                this.afterInitNewPresentRowData();
                break;
            }
            case "entryconfirmarrivaldate": {
                this.entryConfirmArrivalDateChange(index);
                break;
            }
            case "entryarrivaldate": {
                this.entryArrivalDateChange(index);
                break;
            }
        }
        this.initBalanceInfo();
    }

    private CheckResult checkLowestPrice(int index, BigDecimal price) {
        BigDecimal lowestPrice = this.queryLowestPrice(index);
        if (lowestPrice != null && lowestPrice.compareTo(price) > 0) {
            return CheckResult.returnFalse((String)(ResManager.loadKDString((String)"\u4ef7\u683c\u4e0d\u80fd\u4f4e\u4e8e\u6700\u4f4e\u4ef7\uff1a", (String)"PurOrderMobPlugin_12", (String)"drp-dpa-formplugin", (Object[])new Object[0]) + lowestPrice));
        }
        return CheckResult.returnTrue();
    }

    private BigDecimal queryLowestPrice(int index) {
        IPageCache pc = this.getPageCache();
        BigDecimal lowestPrice = null;
        String lowestPriceStr = pc.get("itementry_" + index);
        if (lowestPriceStr == null) {
            Object attrId = this.getEntryF7PKValue("itementry", "assistattr", index);
            if (attrId == null) {
                attrId = 0L;
            }
            lowestPrice = this.loadLowestPrice(this.getOwnerF7PKValue(), this.getCustomerF7PKValue(), this.getEntryF7PKValue("itementry", "item", index), this.getEntryF7PKValue("itementry", "unit", index), attrId, this.getRowInfo("itementry", index).getBigDecimal("qty"), SysParamsUtil.isPriceByConfirmarrivedate() ? this.getRowInfo("itementry", index).getDate("entryconfirmarrivaldate") : new Date());
            pc.put("leadtime", lowestPrice == null ? "null" : lowestPrice.toString());
        } else if (!lowestPriceStr.equals("null")) {
            lowestPrice = new BigDecimal(lowestPriceStr);
        }
        return lowestPrice;
    }

    protected BigDecimal loadLowestPrice(Object ownerPK, Object customerPK, Object itemPK, Object unitPK, Object assistattrPk, BigDecimal qty, Date date) {
        return PricePolicyUtil.getLowestPrice((Object)ownerPK, (Object)customerPK, (Object)itemPK, (Object)unitPK, (Object)assistattrPk, (BigDecimal)qty, (Date)date);
    }

    protected void qtysChanged(int index, BigDecimal oldvalue, String key) {
        this.getAlgorithm().calByQtys(index, key, true);
        this.afterInitNewPresentRowData();
        this.checkOrderQuantity(index);
        this.initBalanceInfo();
    }

    protected void checkOrderQuantity(int index) {
        if (!this.isUseOrderQuantity(index)) {
            return;
        }
        String errorMsg = this.getOrderQuantityMsg(index);
        if (!StringUtils.isEmpty((String)errorMsg)) {
            BigDecimal entryqty = new BigDecimal(errorMsg.split(SPLITKEY)[1]);
            errorMsg = errorMsg.split(SPLITKEY)[0];
            if (this.isOrderQuantityStrongControl()) {
                this.setValue("alterqty", entryqty, index);
                this.setValue("qty", entryqty, index);
                this.getAlgorithm().calByAlterQty(index, true);
            }
            this.getView().showTipNotification(errorMsg);
        }
    }

    protected boolean isUseOrderQuantity(int index) {
        DynamicObject bizType = (DynamicObject)this.getModel().getValue(F_easbusinesstype);
        if (bizType == null) {
            this.setValue("alterqty", BigDecimal.ZERO, index);
            this.getAlgorithm().calByAlterQty(index, true);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u4e1a\u52a1\u7c7b\u578b\uff01", (String)"PurOrderMobPlugin_13", (String)"drp-dpa-formplugin", (Object[])new Object[0]));
            return false;
        }
        return bizType.getBoolean("isuseorderquantity");
    }

    protected boolean checkOrderStatusIsDelivery() {
        Object orderStatus = this.getValue("orderstatus");
        return orderStatus != null && (orderStatus.equals("G") || orderStatus.equals("H"));
    }

    protected String getOrderQuantityMsg(int index) {
        int rowindex = index + 1;
        String errorHead = MessageFormat.format(ResManager.loadKDString((String)"\u7b2c{0}\u884c\u5546\u54c1\u5df2\u542f\u7528\u8ba2\u8d27\u6279\u91cf\uff0c\u8ba2\u8d27\u6570\u91cf\u9700", (String)"PurOrderMobPlugin_34", (String)"drp-dpa-formplugin", (Object[])new Object[0]), rowindex);
        Object owner = this.getOwnerF7PKValue();
        Object customer = this.getCustomerF7PKValue();
        Object warehouse = this.getEntryF7PKValue("itementry", "entrywarehouse", index);
        Object item = this.getEntryF7PKValue("itementry", "item", index);
        Object unit = this.getEntryF7PKValue("itementry", "unit", index);
        Object assistattr = this.getEntryF7PKValue("itementry", "assistattr", index);
        DynamicObject unitDy = this.getEntryF7Value("itementry", "unit", index);
        String unitTips = "(" + unitDy.getString("name") + ")";
        IPageCache pageCache = this.getPageCache();
        Map orderQuantity = OrderQuantityUtil.getOrderQuantityRlue((Object)owner, (Object)customer, (Object)warehouse, (Object)item, (Object)unit, (Object)assistattr, (IPageCache)pageCache);
        if (orderQuantity == null) {
            return "";
        }
        boolean isLessThanMinQty = false;
        boolean isAccordOrderQuantity = true;
        DynamicObject rowInfo = this.getRowInfo("itementry", index);
        BigDecimal entryqty = rowInfo.getBigDecimal("qty");
        BigDecimal qty = ((BigDecimal)orderQuantity.get("qty")).stripTrailingZeros();
        BigDecimal minqty = ((BigDecimal)orderQuantity.get("minqty")).stripTrailingZeros();
        StringBuffer errorMessage = new StringBuffer();
        if (entryqty.compareTo(minqty) < 0) {
            isLessThanMinQty = true;
            entryqty = minqty;
            errorMessage.append(ResManager.loadKDString((String)"\u5927\u4e8e", (String)"PurOrderMobPlugin_16", (String)"drp-dpa-formplugin", (Object[])new Object[0])).append(minqty.toPlainString()).append(unitTips).append('!');
        }
        BigDecimal[] result = entryqty.divideAndRemainder(qty);
        BigDecimal intpart = result[0];
        BigDecimal remainder = result[1];
        if (remainder.compareTo(BigDecimal.ZERO) > 0) {
            isAccordOrderQuantity = false;
            if (isLessThanMinQty) {
                errorMessage.append(ResManager.loadKDString((String)"\u4e14", (String)"PurOrderMobPlugin_17", (String)"drp-dpa-formplugin", (Object[])new Object[0]));
            }
            errorMessage.append(MessageFormat.format(ResManager.loadKDString((String)"\u4e3a{0}{1}\u7684\u500d\u6570\uff01", (String)"PurOrderMobPlugin_32", (String)"drp-dpa-formplugin", (Object[])new Object[0]), qty.toPlainString(), unitTips));
        }
        if (!StringUtils.isEmpty((Object)errorMessage)) {
            if (!isAccordOrderQuantity) {
                entryqty = intpart.add(BigDecimal.ONE).multiply(qty).stripTrailingZeros();
                errorMessage.append(ResManager.loadKDString((String)"\u5f53\u524d\u8d2d\u4e70\u6570\u91cf\u5efa\u8bae\u4e3a", (String)"PurOrderMobPlugin_20", (String)"drp-dpa-formplugin", (Object[])new Object[0])).append(entryqty);
            }
            StringBuilder str = new StringBuilder();
            str.append(errorHead).append(errorMessage).append('&').append(entryqty);
            return str.toString();
        }
        return "";
    }

    protected boolean isOrderQuantityStrongControl() {
        return true;
    }

    protected void entryConfirmArrivalDateChange(int index) {
        Date confirmDate = this.getRowInfo("itementry", index).getDate("entryconfirmarrivaldate");
        if (confirmDate == null) {
            return;
        }
        Date now = DateUtil.getNowDate();
        if (confirmDate.before(now)) {
            confirmDate = now;
            this.setValue("entryconfirmarrivaldate", confirmDate, index);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u786e\u8ba4\u4ea4\u8d27\u65e5\u671f\u4e0d\u65e9\u4e8e\uff1a", (String)"PurOrderMobPlugin_6", (String)"drp-dpa-formplugin", (Object[])new Object[0]) + DateUtil.getDateFormat((Date)now));
        }
    }

    protected void entryArrivalDateChange(int index) {
        Date arrivalDate = this.getRowInfo("itementry", index).getDate("entryarrivaldate");
        if (arrivalDate == null) {
            return;
        }
        Date now = DateUtil.getNowDate();
        if (arrivalDate.before(now)) {
            arrivalDate = now;
            this.setValue("entryconfirmarrivaldate", arrivalDate, index);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u8981\u6c42\u4ea4\u8d27\u65e5\u671f\u4e0d\u65e9\u4e8e\uff1a", (String)"PurOrderMobPlugin_21", (String)"drp-dpa-formplugin", (Object[])new Object[0]) + DateUtil.getDateFormat((Date)now));
        }
    }

    protected void setBalanceInfo() {
        if (this.isAddNew() || this.isEdit()) {
            return;
        }
        BigDecimal useableBalance = this.getUseableBalance(this.getOwnerF7PKValue(), this.getCustomerF7PKValue());
        if (useableBalance.compareTo(BigDecimal.ZERO) == 0) {
            this.setDisVisible(new String[]{"balanceinfo"});
        } else {
            this.setValue("usablebalance", useableBalance);
            this.setVisible(new String[]{"balanceinfo"});
            boolean isUseBalance = (Boolean)this.getModel().getValue("isusebalance");
            if (!isUseBalance) {
                this.setDisVisible(new String[]{"usablebalance", "usedbalance"});
            }
        }
    }

    protected BigDecimal getUseableBalance(Object ownerPK, Object customerPK) {
        BigDecimal usable = ZERO;
        if (ownerPK == null || customerPK == null) {
            return usable;
        }
        DynamicObject balanceInfo = BalanceUtil.getBalanceInfo((Object)ownerPK, (Object)customerPK, (boolean)false);
        if (balanceInfo != null) {
            BigDecimal used = BigDecimal.ZERO;
            if (this.getPageCache().get("usedbalance") != null) {
                used = new BigDecimal(this.getPageCache().get("usedbalance"));
            }
            usable = balanceInfo.getBigDecimal("usable").add(used);
        }
        if (balanceInfo == null) {
            return ZERO;
        }
        return usable;
    }

    protected void useBalanceChanged() {
        boolean isUseBalance = (Boolean)this.getModel().getValue("isusebalance");
        this.initBalanceInfo();
        if (!isUseBalance) {
            this.setValue("usablebalance", BigDecimal.ZERO);
            this.setValue("usedbalance", BigDecimal.ZERO);
            this.recalUsedBalance();
            this.getAlgorithm().calTotalFields();
        }
    }

    protected void initBalanceInfo() {
        boolean isUseBalance = (Boolean)this.getModel().getValue("isusebalance");
        if (!isUseBalance) {
            this.setDisVisible(new String[]{"usablebalance", "usedbalance"});
            return;
        }
        this.setVisible(new String[]{"usablebalance", "usedbalance"});
        Object ownerPK = this.getOwnerF7PKValue();
        Object customerPK = this.getCustomerF7PKValue();
        BigDecimal usableBalance = this.getUseableBalance(ownerPK, customerPK);
        BigDecimal usedBalance = BigDecimal.ZERO;
        if (this.getPageCache().get("usedbalance") != null && !this.getModel().getValue("orderstatus").toString().equals(SaleOrderStatus.TEMP_SAVE.getFlagStr())) {
            usedBalance = new BigDecimal(this.getPageCache().get("usedbalance"));
        }
        usableBalance = usableBalance.add(usedBalance);
        this.setValue("usablebalance", usableBalance);
        if (this.isEdit() || this.isAddNew()) {
            this.recalUsedBalance();
        }
    }

    protected void recalUsedBalance() {
        BigDecimal totalorderamount = (BigDecimal)this.getModel().getValue("totalorderamount");
        BigDecimal amounttobepaid = (BigDecimal)this.getModel().getValue("amounttobepaid");
        BigDecimal receivedamount = (BigDecimal)this.getModel().getValue("receivedamount");
        BigDecimal usablebalance = (BigDecimal)this.getModel().getValue("usablebalance");
        BigDecimal usedbalance = (BigDecimal)this.getModel().getValue("usedbalance");
        BigDecimal paidAmount = ReceivingbillUtil.getBillSalePayAmount((Object)this.getId(), (String)"saleorder");
        amounttobepaid = totalorderamount.subtract(paidAmount);
        if (amounttobepaid.compareTo(usablebalance) >= 0) {
            amounttobepaid = amounttobepaid.subtract(usablebalance);
            usedbalance = usablebalance;
        } else {
            usedbalance = amounttobepaid;
            amounttobepaid = BigDecimal.ZERO;
        }
        String orderStatus = (String)this.getModel().getValue("orderstatus");
        if (!orderStatus.equals(SaleOrderStatus.CHANGING.getFlagStr()) || receivedamount.compareTo(totalorderamount) < 0) {
            this.setValue("receivedamount", paidAmount.add(usedbalance));
        }
        this.setValue("amounttobepaid", amounttobepaid);
        this.setValue("usedbalance", usedbalance);
    }

    private void toSelectedRebate() {
        FormModel formModel = new FormModel("drm_account_type_select", ResManager.loadKDString((String)"\u9009\u62e9\u8d26\u6237\u7c7b\u578b", (String)"PurOrderMobPlugin_22", (String)"drp-dpa-formplugin", (Object[])new Object[0]), "5", true);
        formModel.addCustomParam("isProvideData", (Object)Boolean.FALSE);
        formModel.addCustomParam("ownerid", this.getOwnerF7PKValue());
        formModel.addCustomParam("customerid", this.getCustomerF7PKValue());
        DynamicObject currency = (DynamicObject)this.getValue("currency");
        formModel.addCustomParam("currencyId", currency.getPkValue());
        formModel.showPage((AbstractFormPlugin)this);
    }

    private void accountTypeSelectCloseCallBack(Map<String, Object> returnData) {
        if (returnData == null) {
            return;
        }
        Object accountType = returnData.get("accounttype");
        BigDecimal amount = (BigDecimal)returnData.get("amount");
        if (amount == null || amount.compareTo(BigDecimal.ZERO) == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u8fd4\u5229\u8d26\u6237\u7684\u8d26\u6237\u4f59\u989d\u4e3a0\u5143\uff0c\u65e0\u6cd5\u4f7f\u7528\u8be5\u8d26\u6237\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9", (String)"PurOrderMobPlugin_23", (String)"drp-dpa-formplugin", (Object[])new Object[0]));
            return;
        }
        this.setUseRebate(Boolean.TRUE);
        this.setValue("rebatebalance", amount);
        this.setValue("rebateaccounttype", accountType);
    }

    protected void rebateAccountTypeChanged(PropertyChangedArgs e) {
        DynamicObject order = this.getModel().getDataEntity();
        order.set("isusersetrebate", (Object)Boolean.FALSE);
        this.getAlgorithm().calByUsedRebateChanged();
        this.initBalanceInfo();
    }

    protected void usedRebateChanged(PropertyChangedArgs e) {
        DynamicObject order = this.getModel().getDataEntity();
        BigDecimal rebateBalance = order.getBigDecimal("rebatebalance");
        BigDecimal usedRebate = order.getBigDecimal("usedrebate");
        this.setValue("isusersetrebate", Boolean.TRUE);
        if (usedRebate.compareTo(rebateBalance) > 0) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8fd4\u5229\uff1a\u672c\u6b21\u62b5\u7528\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u53ef\u7528\u4f59\u989d[%s]", (String)"PurOrderMobPlugin_24", (String)"drp-dpa-formplugin", (Object[])new Object[0]), rebateBalance));
            this.setValue("usedrebate", rebateBalance);
        } else if (usedRebate.compareTo(BigDecimal.ZERO) < 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8fd4\u5229\uff1a\u672c\u6b21\u62b5\u7528\u91d1\u989d\u4e0d\u80fd\u5c0f\u4e8e0", (String)"PurOrderMobPlugin_25", (String)"drp-dpa-formplugin", (Object[])new Object[0]));
            this.setValue("usedrebate", BigDecimal.ZERO);
        } else if (usedRebate.compareTo(BigDecimal.ZERO) == 0) {
            this.setUseRebate(Boolean.FALSE);
            this.setValue("isusersetrebate", Boolean.FALSE);
        }
        this.getAlgorithm().calByUsedRebateChanged();
        this.initBalanceInfo();
    }

    protected void setUseRebate(Boolean useRebate) {
        this.setValue("canuserebate", useRebate);
        if (!useRebate.booleanValue()) {
            this.setValue("rebateaccounttype", null);
            this.setValue("rebatebalance", BigDecimal.ZERO);
            this.setUnEnable(new String[]{"usedrebate"});
        } else {
            this.setEnable(new String[]{"usedrebate"});
        }
        this.setValue("isusersetrebate", Boolean.FALSE);
    }

    protected void toOrderEvaluate() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("customerid", this.getCustomerF7PKValue());
        map.put("ownerid", this.getOwnerF7PKValue());
        Object oderid = this.getModel().getDataEntity().get("id");
        map.put("orderid", this.getModel().getDataEntity().get("id"));
        QFilter qFilter = new QFilter("billnumber", "=", oderid);
        DynamicObject orderEvaluate = BusinessDataServiceHelper.loadSingle((String)"mdr_bill_evaluate_manage", (String)"id", (QFilter[])qFilter.toArray());
        if (orderEvaluate != null && orderEvaluate.get("id") != null && !orderEvaluate.get("id").equals(0L)) {
            map.put("orderevalid", orderEvaluate.get("id"));
        }
        FormModel formModel = new FormModel("mdr_order_evaluate_op_mob", ResManager.loadKDString((String)"\u8ba2\u5355\u8bc4\u4ef7", (String)"PurOrderMobPlugin_26", (String)"drp-dpa-formplugin", (Object[])new Object[0]), "5");
        formModel.setCustomParam(map);
        formModel.showPage((AbstractFormPlugin)this);
    }

    protected void toEvaluatePage() {
        if (this.isAddNew()) {
            return;
        }
        Long id = this.getId();
        MobileFormShowParameter parameter = new MobileFormShowParameter();
        parameter.setFormId("mdr_evaluate_mobview");
        parameter.getOpenStyle().setShowType(ShowType.Floating);
        parameter.setCustomParam("orderid", (Object)id);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "refreshEvaluateCount"));
        this.getView().showForm((FormShowParameter)parameter);
    }

    protected void setEvaluateCount() {
        if (this.isAddNew()) {
            return;
        }
        ArrayList<QFilter> tbFilters = new ArrayList<QFilter>();
        tbFilters.add(new QFilter("order", "=", (Object)this.getId()));
        int count = ORM.create().count("MDR", "mdr_order_evaluates", tbFilters.toArray(new QFilter[tbFilters.size()]));
        this.setValue("evaluatecount", count);
    }

    protected void executePromotion() {
        this.getAlgorithm().calByExecutePromotion();
        this.afterInitNewPresentRowData();
        this.refreshViewByPromotion();
    }

    protected void afterInitNewPresentRowData() {
        for (int i = 0; i < this.getModel().getEntryRowCount("itementry"); ++i) {
            if (!this.isPresent(i)) continue;
            this.afterInitNewPresentRowData(i);
        }
    }

    protected boolean isPresent(int i) {
        if (i < 0) {
            return false;
        }
        boolean isPresent = (Boolean)this.getValue("ispresent", i);
        return isPresent;
    }

    protected boolean isItemDisable(int i, List<Long> userabelItemIds) {
        if (i < 0) {
            return false;
        }
        DynamicObject iteminfo = (DynamicObject)this.getValue("item", i);
        return !userabelItemIds.contains(iteminfo.getLong("id"));
    }

    protected void afterInitNewPresentRowData(int index) {
        SaleOrderEntryType entryType = this.getEntryType(index);
        if (SaleOrderEntryType.COMBINATION == entryType) {
            DynamicObject item = this.getEntryF7Value("itementry", "combitem", index);
            if (item == null || item.get("id") == null || item.get("id").equals(0L)) {
                return;
            }
            this.setValue("combitem", item.get("id"), index);
        } else {
            DynamicObject item = this.getEntryF7Value("itementry", "item", index);
            if (item == null || item.get("id") == null || item.get("id").equals(0L)) {
                return;
            }
            this.setItemNoChangeEvent(item.get("id"), index);
            String itemTitle = null;
            String thumbnail = null;
            String material = null;
            if (item != null) {
                itemTitle = item.getString("name");
                if (StringUtils.isNotEmpty((String)item.getString("thumbnail"))) {
                    thumbnail = item.getString("thumbnail");
                }
                if (StringUtils.isNotEmpty((String)item.getString("material.id"))) {
                    material = item.getString("material.id");
                }
            }
            this.setValue("material", material, index);
            this.setValue("itemimg", thumbnail, index);
            this.setValue("itemtitle", itemTitle, index);
            this.initRowUnits(index);
            this.initRowAssistUnits(index);
            this.getAlgorithm().calQtysByInitQty(index);
        }
        this.initItemEntryInfo(index);
        this.copyHeadInfo(index);
        this.initReceiveWarehouse(index);
    }

    protected void propertyChangeRefreshExecutionList(String key) {
        switch (key) {
            case "owner": 
            case "customer": 
            case "orderdate": 
            case "totalqty": 
            case "qty": 
            case "taxprice": 
            case "price": {
                this.refreshViewByPromotion();
                break;
            }
        }
    }

    protected BillList addExecutrionListListener() {
        BillList billList = (BillList)this.getControl(EXECUTIONS_LIST);
        billList.addCreateListDataProviderListener((CreateListDataProviderListener)this);
        return billList;
    }

    protected void refreshViewByPromotion() {
        BillList billList = (BillList)this.getControl(EXECUTIONS_LIST);
        billList.addCreateListDataProviderListener((CreateListDataProviderListener)this);
        MobileControlUtils.BillListRefresh((BillList)billList, (QFilter[])new QFilter[]{new QFilter("1", "!=", (Object)1)});
    }

    public void createListDataProvider(BeforeCreateListDataProviderArgs e) {
        String key;
        switch (key = this.getKeyFromEvent((EventObject)e)) {
            case "executionslist": {
                this.addExecutionListDataProvider(e);
                break;
            }
        }
    }

    protected void addExecutionListDataProvider(BeforeCreateListDataProviderArgs e) {
        e.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int arg0, int arg1) {
                DynamicObjectCollection col = super.getData(arg0, arg1);
                col.clear();
                if (!SysParamsUtil.isUsePromotion()) {
                    PurOrderMobPlugin.this.setDisVisible(new String[]{"promotionflex"});
                    return col;
                }
                PromotionApiResult result = PromotionServiceHelper.getPromotionResult((String)PurOrderMobPlugin.this.getPromotionCacheKey());
                List executionlist = result.getExecutions();
                if (executionlist.isEmpty()) {
                    PurOrderMobPlugin.this.setDisVisible(new String[]{"promotionflex"});
                    return col;
                }
                PurOrderMobPlugin.this.setVisible(new String[]{"promotionflex"});
                HashMap<DynamicObject, Object> entryResultId = new HashMap<DynamicObject, Object>();
                HashSet<String> showResult = new HashSet<String>();
                for (DynamicObject execution : executionlist) {
                    DynamicObjectCollection executions = execution.getDynamicObjectCollection("entryentity");
                    for (DynamicObject entry : executions) {
                        Boolean isUsed = execution.getBoolean("isused");
                        if (!isUsed.booleanValue()) continue;
                        Object resultid = entry.get("resultid");
                        DynamicObject policy = execution.getDynamicObject("policy");
                        Object policyid = policy.getPkValue();
                        StringBuilder keyStr = new StringBuilder();
                        keyStr.append(resultid).append('-').append(policyid);
                        String key = keyStr.toString();
                        if (showResult.contains(key)) continue;
                        showResult.add(key);
                        DynamicObject queryobj = col.addNew();
                        queryobj.set("id", execution.getPkValue());
                        queryobj.set("policy_id", policyid);
                        queryobj.set("isused", (Object)isUsed);
                        queryobj.set("groupnumber", (Object)execution.getString("groupnumber"));
                        entryResultId.put(queryobj, resultid);
                    }
                }
                Collection resultIds = entryResultId.values();
                Map relations = BusinessDataServiceHelper.loadFromCache((Object[])resultIds.toArray(new Object[]{resultIds.size()}), (String)"dpm_result_relation");
                for (DynamicObject entry : col) {
                    Object resultid = entryResultId.get(entry);
                    DynamicObject resultType = ((DynamicObject)relations.get(resultid)).getDynamicObject("resulttype");
                    entry.set("entryentity.sourceentryids", (Object)resultType.getString("name"));
                }
                BusinessDataServiceHelper.loadRefence((Object[])col.toArray(), (IDataEntityType)((DynamicObject)col.get(0)).getDataEntityType());
                return col;
            }
        });
    }

    protected String getPromotionCacheKey() {
        String key = this.getStringValue("promotioncachekey");
        if (StringUtils.isEmpty((String)key)) {
            key = this.getPageCache().get("promotioncachekey");
            if (StringUtils.isEmpty((String)key)) {
                key = this.getView().getPageId();
                this.getPageCache().put("promotioncachekey", key);
            }
            this.setValue("promotioncachekey", key);
        } else {
            this.getPageCache().put("promotioncachekey", key);
        }
        return key;
    }

    private String loadPromotionCache() {
        Long orderPk;
        if (SysParamsUtil.isUsePromotion() && (orderPk = this.getId()) != null && !((Object)orderPk).equals(0L)) {
            PromotionApiResult result = PromotionServiceHelper.getPromotionResult((Long)orderPk);
            this.setValue("promotioncachekey", result.getCachekey());
            return result.getCachekey();
        }
        return null;
    }

    public String getStringValue(String key) {
        Object value = this.getValue(key);
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof ILocaleString) {
            return ((ILocaleString)value).getLocaleValue();
        }
        throw new KDBizException(key + ResManager.loadKDString((String)":\u4e0d\u662fString\u7c7b\u578b\u5b57\u6bb5\uff01", (String)"PurOrderMobPlugin_27", (String)"drp-dpa-formplugin", (Object[])new Object[0]));
    }

    private void openExecutionSelectMobPage() {
        FormModel model = new FormModel("dpm_executionselect_mob", ResManager.loadKDString((String)"\u9009\u62e9\u4fc3\u9500\u6267\u884c\u7ed3\u679c", (String)"PurOrderMobPlugin_28", (String)"drp-dpa-formplugin", (Object[])new Object[0]), "15", true);
        model.addCustomParam("promotioncachekey", (Object)this.getPromotionCacheKey());
        model.showPage((AbstractFormPlugin)this);
    }

    private void executionSelectMobCloseCallBack(Object returnData) {
        if (returnData == null) {
            return;
        }
        PromotionApiResult result = PromotionServiceHelper.getPromotionResult((String)this.getPromotionCacheKey());
        List executions = result.getExecutions();
        for (DynamicObject execution : executions) {
            if (!returnData.equals(execution.getPkValue())) continue;
            if (execution.getBoolean("isused")) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u672a\u4f7f\u7528\u7684\u6267\u884c\u7ed3\u679c\u8fdb\u884c\u5207\u6362\uff01", (String)"PurOrderMobPlugin_29", (String)"drp-dpa-formplugin", (Object[])new Object[0]));
                return;
            }
            this.switchPromotionExecution(execution.getDynamicObject("policy").getPkValue(), execution.getString("groupnumber").charAt(0));
            return;
        }
        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u5bf9\u5e94\u4fc3\u9500\u6267\u884c\u7ed3\u679c", (String)"PurOrderMobPlugin_30", (String)"drp-dpa-formplugin", (Object[])new Object[0]));
    }

    protected void switchPromotionExecution(Object promotionid, char groupnumber) {
        this.getAlgorithm().calBySwitchPromotionExecutions(promotionid, groupnumber);
        this.afterInitNewPresentRowData();
        this.refreshViewByPromotion();
    }

    private boolean checkBigDecimalChange(int i, BigDecimal oldValue, String key) {
        BigDecimal value = (BigDecimal)this.getModel().getValue(key, i);
        return (value == null || oldValue == null || value.compareTo(oldValue) != 0) && (value != null || oldValue != null);
    }

    protected SaleOrderAlgorithm getAlgorithm() {
        return new SaleOrderMobAlgorithm(this.getModel().getDataEntity(true), this.getView(), this.getPageCache());
    }

    protected void hiddenFlex() {
        CardEntry card = (CardEntry)this.getView().getControl("itementry");
        if (card == null) {
            return;
        }
        Boolean hasTax = this.getModel().getDataEntity(true).getBoolean("hastax");
        DynamicObjectCollection objs = this.getModel().getEntryEntity("itementry");
        if (objs == null) {
            return;
        }
        DynamicObject obj = null;
        for (int i = 0; i < objs.size(); ++i) {
            obj = (DynamicObject)objs.get(i);
            this.hasTaxHidden(hasTax, card, i);
            this.isPresentHidden(obj.getBoolean("ispresent"), card, i);
        }
    }

    private void hasTaxHidden(boolean hasTax, CardEntry card, int i) {
        card.setChildVisible(!hasTax, i, new String[]{"price"});
        card.setChildVisible(hasTax, i, new String[]{"taxprice"});
    }

    private void isPresentHidden(boolean isPresent, CardEntry card, int i) {
        card.setChildVisible(!isPresent, i, new String[]{"itemstlye"});
        card.setChildVisible(isPresent, i, new String[]{"presentstyle"});
    }

    protected SaleOrderEntryType getEntryType(int i) {
        String entrytype = (String)this.getValue("entrytype", i);
        if (StringUtils.isEmpty((String)entrytype)) {
            throw new KDBizException(MessageFormat.format(ResManager.loadKDString((String)"\u7b2c{0}\u884c\u5206\u5f55\uff0c\u5206\u5f55\u7c7b\u578b\u4e3a\u7a7a,\u8bf7\u91cd\u65b0\u521d\u59cb\u5316\u884c", (String)"PurOrderMobPlugin_35", (String)"drp-dpa-formplugin", (Object[])new Object[0]), i + 1));
        }
        return EnumUtil.toSaleOrderEntryType((String)entrytype);
    }

    protected void setItemNoChangeEvent(Object itemId, int index) {
        this.setValue("item", itemId, index);
    }

    public void setValue(String key, Object value) {
        this.setValue(key, value, false);
    }

    public void setValue(String key, Object value, int i) {
        this.setValue(key, value, i, false);
    }

    public void setRowValue(String colName, Object value, int rowIndex) {
        this.setValue(colName, value, rowIndex, false);
    }
}

