/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dpa.formplugin.bill.saleorder;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operatecol.OperationColItem;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.list.column.ListOperationColumnDesc;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.drp.mdr.common.ShortMessageUtil;
import kd.drp.mdr.common.WFXOrderType;
import kd.drp.mdr.common.constants.SaleOrderEntryType;
import kd.drp.mdr.common.handler.OrderOperateLogHandler;
import kd.drp.mdr.common.handler.SaleOrderHandler;
import kd.drp.mdr.common.status.DispatchOrderConfirmStatus;
import kd.drp.mdr.common.status.SaleOrderConfirmStatus;
import kd.drp.mdr.common.status.SaleOrderReceStatus;
import kd.drp.mdr.common.status.SaleOrderStatus;
import kd.drp.mdr.common.util.CustomerParamsUtil;
import kd.drp.mdr.common.util.ItemStoreUtil;
import kd.drp.mdr.common.util.OperationUtil;
import kd.drp.mdr.common.util.OrderExportUtil;
import kd.drp.mdr.common.util.SaleOrderUtil;
import kd.drp.mdr.common.util.SysParamsUtil;
import kd.drp.mdr.formplugin.MdrListPlugin;
import org.apache.commons.lang.StringUtils;

public class PurOrderNewListPlugin
extends MdrListPlugin
implements TabSelectListener {
    protected static final String F_billno = "billno";
    protected static final String TO_DELIVERY = "todelivery";
    protected static final String TO_SIGN = "tosign";
    protected static final String TO_EVALUATE = "toevaluate";
    protected static final String TO_PAY = "topay";
    protected static final String TO_SYNC = "tosync";
    protected static final String TO_CHANGE = "change";
    protected static final String TO_MODIFY = "privatemodify";
    protected static final String TO_GENERATION = "generation";
    protected static final String TO_ALLOT = "toallot";
    protected static final String TO_OPLOG = "oplog";
    protected static final String TO_EXPORT = "exportexcel";
    protected static final String TO_INVALID = "invalid";
    protected static final String TO_DISPATCHCONFIRM = "dispatchconfirm";
    protected static final String TO_SHOWSALEORDERINFO = "showSaleOrderInfo";
    protected static final String PUSH_OEM = "pushoem";
    protected static final String TO_VALID = "valid";
    protected static final String UNSUBMIT = "unsubmit";
    protected static final String UNAUDIT = "unaudit";
    protected static final String DELETE = "delete";
    protected static final String WITHDRAW = "withdraw";
    protected static final String SUBMIT = "submit";
    private static final String OP_CHECKSUBMIT = "checksubmit";
    protected static final String PUSH_DISPATCH_ORDER = "pushdispatchorder";
    protected static final String PUSH_LOGISTIC_SEND = "pushlogisticssend";
    protected static final String SEND_ALLOT_MSG = "sendallotmsg";
    protected static final String SEND_AMOUNT_MSG = "sendamountmsg";
    protected static final String RE_FRESH = "refresh";
    protected static final String EXPORT_BY_LISTSELECT = "exportlistbyselectfields";

    public void setFilter(SetFilterEvent e) {
        this.setFilterName();
        super.setFilter(e);
        this.createListFilter(e);
    }

    protected void setFilterName() {
        this.setFilterOwnerName("customer.id");
    }

    protected void createListFilter(SetFilterEvent e) {
        this.createFilter(e);
        this.createTabFilter(e);
    }

    protected boolean isNeedCahceOwner() {
        return true;
    }

    public void filterContainerInit(FilterContainerInitArgs e) {
        super.filterContainerInit(e);
        this.initOwnerFilterComboItem(e, "customer.name");
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addTabSelectListener(this, new String[]{"filtertab"});
    }

    private void createFilter(SetFilterEvent e) {
        String key;
        List fs = e.getQFilters();
        Map fsMap = this.filter2Map(fs);
        if (!fsMap.containsKey(key = "owner.id")) {
            fs.add(new QFilter("customer", "in", (Object)this.getOwnerIDs()));
        }
    }

    protected void toPayPage() {
        throw new KDBizException(ResManager.loadKDString((String)"\u8981\u8d27\u65b9\u6682\u4e0d\u5141\u8bb8\u64cd\u4f5c", (String)"PurOrderNewListPlugin_0", (String)"drp-dpa-formplugin", (Object[])new Object[0]));
    }

    public void billListHyperLinkClick(HyperLinkClickArgs evt) {
        Object pk = this.getListView().getFocusRowPkId();
        this.checkAndShowViewBill(pk, true);
        evt.setCancel(true);
    }

    public void listRowDoubleClick(ListRowClickEvent evt) {
        Object pk = this.getListView().getFocusRowPkId();
        this.checkAndShowViewBill(pk, true);
        evt.setCancel(true);
    }

    private String getExsistPage(Object pk, String operation) {
        String key = "exsistPage" + operation + pk;
        return this.getPageCache().get(key);
    }

    private void cachePageId(Object pk, String pageId, String operation) {
        String key = "exsistPage" + operation + pk;
        this.getPageCache().put(key, pageId);
    }

    private void checkAndShowViewBill(Object pk, boolean isView) {
        String operation = "view";
        String pageId = this.getExsistPage(pk, operation);
        IFormView View = this.getView().getParentView();
        IFormView childView = View.getView(pageId);
        if (childView != null) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8be5\u8ba2\u5355\u5df2\u6253\u5f00\uff01", (String)"PurOrderNewListPlugin_1", (String)"drp-dpa-formplugin", (Object[])new Object[0]));
            return;
        }
        pageId = this.showViewBill(pk, isView);
        this.cachePageId(pk, pageId, operation);
    }

    private String showViewBill(Object pk, boolean isView) {
        BillShowParameter parameter = new BillShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.setFormId(this.getListModel().getDataEntityType().getName());
        if (isView) {
            parameter.setStatus(OperationStatus.VIEW);
        } else {
            parameter.setStatus(OperationStatus.EDIT);
        }
        parameter.setPkId(pk);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, TO_SHOWSALEORDERINFO));
        this.getView().showForm((FormShowParameter)parameter);
        return parameter.getPageId();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        String key;
        super.beforeDoOperation(e);
        block8 : switch (key = ((AbstractOperate)e.getSource()).getOperateKey()) {
            case "pushdispatchorder": {
                boolean isDispatch = SysParamsUtil.isDispatch();
                if (!isDispatch) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5f00\u542f\u53c2\u6570--\u662f\u5426\u542f\u7528\u5206\u8d27\u6d41\u7a0b", (String)"PurOrderNewListPlugin_2", (String)"drp-dpa-formplugin", (Object[])new Object[0]));
                }
                this.getSelectedOrderIds(true);
                break;
            }
            case "topay": {
                this.getSelectedOrderIds(true);
                break;
            }
            case "invalid": {
                Object selectedOrderId = this.getSelectedOrderId();
                HashMap<String, Object> param = new HashMap<String, Object>();
                DynamicObject order = QueryServiceHelper.queryOne((String)this.getModelName(), (String)"orderstatus", (QFilter[])new QFilter("id", "=", selectedOrderId).toArray());
                if (order == null) {
                    e.setCancel(true);
                    this.getView().showMessage(ResManager.loadKDString((String)"\u5355\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0", (String)"PurOrderNewListPlugin_3", (String)"drp-dpa-formplugin", (Object[])new Object[0]));
                    break;
                }
                if (!SaleOrderStatus.TEMP_SAVE.getFlagStr().equals(order.getString("orderstatus"))) {
                    e.setCancel(true);
                    this.getView().showMessage(ResManager.loadKDString((String)"\u6682\u5b58\u72b6\u6001\u7684\u5355\u636e\u624d\u80fd\u4f5c\u5e9f\uff01", (String)"PurOrderNewListPlugin_4", (String)"drp-dpa-formplugin", (Object[])new Object[0]));
                    break;
                }
                param.put("orderid", selectedOrderId);
                this.showForm("mdr_saleorder_invalid", param, new CloseCallBack((IFormPlugin)this, TO_INVALID), ShowType.Modal);
                e.setCancel(true);
                break;
            }
            case "withdraw": {
                Object[] selectedOrderIds = this.getSelectedOrderIds(false);
                String opMessage = OrderOperateLogHandler.getOpMessage((String)key);
                if (key.equals(WITHDRAW)) {
                    StringBuilder tips = new StringBuilder();
                    DynamicObjectCollection orders = QueryServiceHelper.query((String)this.getModelName(), (String)"confirmstatus,billno", (QFilter[])new QFilter("id", "in", (Object)selectedOrderIds).toArray());
                    for (DynamicObject orderInfo : orders) {
                        if (!"C".equals(orderInfo.getString("confirmstatus"))) continue;
                        tips.append(orderInfo.get(F_billno)).append(',');
                    }
                    if (tips.length() != 0) {
                        opMessage = ResManager.loadKDString((String)"\u8ba2\u5355", (String)"PurOrderNewListPlugin_5", (String)"drp-dpa-formplugin", (Object[])new Object[0]) + tips.substring(0, tips.length() - 1) + ResManager.loadKDString((String)"\u5206\u8d27\u6d88\u606f\u5df2\u786e\u8ba4\uff0c\u786e\u8ba4\u64a4\u9500\u8ba2\u5355\uff1f", (String)"PurOrderNewListPlugin_6", (String)"drp-dpa-formplugin", (Object[])new Object[0]);
                    }
                }
                HashMap<String, Object> param = new HashMap<String, Object>();
                param.put("message", opMessage);
                param.put("ids", selectedOrderIds);
                this.showForm("mdr_operate_confirm", param, new CloseCallBack((IFormPlugin)this, key), ShowType.Modal);
                e.setCancel(true);
                break;
            }
            case "checksubmit": {
                e.setCancel(true);
                this.orderInventoryCheck();
                break;
            }
            case "pushoem": {
                String orderstatus;
                Object id = this.getSelectedOrderId();
                DynamicObject saleorderInfo = BusinessDataServiceHelper.loadSingle((Object)id, (String)"bbc_saleorder", (String)"orderstatus");
                switch (orderstatus = saleorderInfo.getString("orderstatus")) {
                    case "J": 
                    case "K": 
                    case "C": 
                    case "D": {
                        break block8;
                    }
                }
                throw new KDBizException(ResManager.loadKDString((String)"\u53ea\u6709\u5f85\u5206\u8d27\u3001\u5f85\u53d1\u8d27\u3001\u90e8\u5206\u5206\u8d27\u3001\u90e8\u5206\u53d1\u8d27\u7684\u8ba2\u5355\u624d\u80fd\u5173\u8054\u751f\u6210OEM\u8ba2\u5355", (String)"PurOrderNewListPlugin_7", (String)"drp-dpa-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        String key;
        switch (key = e.getOperateKey()) {
            case "sendallotmsg": {
                this.sendAllotMsg();
                break;
            }
            case "sendamountmsg": {
                this.sendAmountMsg();
            }
        }
        if (this.getOperationResult(e)) {
            switch (key) {
                case "todelivery": {
                    this.toDeliveryPage();
                    break;
                }
                case "toallot": {
                    this.toAllotPage();
                    break;
                }
                case "tosign": {
                    this.toSignPage();
                    break;
                }
                case "generation": {
                    this.toGeneration();
                    break;
                }
                case "toevaluate": {
                    this.toEvaluate();
                    break;
                }
                case "topay": {
                    this.toPayPage();
                    break;
                }
                case "change": {
                    this.getView().invokeOperation("modify");
                    break;
                }
                case "privatemodify": {
                    Object[] pk = this.getSelectedOrderIds(true);
                    this.checkAndShowViewBill(pk[0], false);
                    break;
                }
                case "pushdispatchorder": {
                    Object[] saleorderids = this.getSelectedOrderIds(false);
                    ArrayList<String> soids = new ArrayList<String>(saleorderids.length);
                    for (Object id : saleorderids) {
                        soids.add(id.toString());
                    }
                    ArrayList<QFilter> tbFilters = new ArrayList<QFilter>();
                    tbFilters.add(new QFilter("itementry.sourcebillid", "in", soids));
                    ListFilterParameter filter = new ListFilterParameter();
                    filter.setQFilters(tbFilters);
                    this.toDispatchOrder(filter);
                    break;
                }
                case "pushlogisticssend": {
                    this.toLogisticsSend();
                    break;
                }
                case "tosync": 
                case "cancelsync": 
                case "confirmchange": {
                    this.getView().invokeOperation(RE_FRESH);
                    break;
                }
                case "withdraw": {
                    this.getView().invokeOperation(RE_FRESH);
                    break;
                }
                case "exportexcel": {
                    Object[] pks = this.getSelectedOrderIds(false);
                    OrderExportUtil.create((IFormView)this.getView()).export(pks, WFXOrderType.SALE_ORDER);
                    break;
                }
                case "oplog": {
                    Object id = this.getSelectedOrderId();
                    ListShowParameter parameter = new ListShowParameter();
                    parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                    parameter.setFormId("bos_list");
                    parameter.setBillFormId("mdr_order_op_log");
                    QFilter f = new QFilter("orderid", "=", id);
                    f.and("ordertype", "=", (Object)"saleorder");
                    ListFilterParameter listFilterParameter = new ListFilterParameter();
                    listFilterParameter.setFilter(f);
                    parameter.setListFilterParameter(listFilterParameter);
                    this.getView().showForm((FormShowParameter)parameter);
                    break;
                }
                case "dispatchconfirm": {
                    Object id = this.getSelectedOrderId();
                    DynamicObject saleorder = QueryServiceHelper.queryOne((String)this.getModelName(), (String)"confirmstatus", (QFilter[])new QFilter("id", "=", id).toArray());
                    String confirmstatus = saleorder.getString("confirmstatus");
                    if (!SaleOrderConfirmStatus.ALLOTSENDED.getFlagStr().equals(confirmstatus)) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u9500\u552e\u8ba2\u5355\u786e\u8ba4\u72b6\u6001\u4e0d\u4e3a\u5206\u8d27\u5f85\u786e\u8ba4\uff0c\u4e0d\u9700\u8981\u786e\u8ba4\uff01", (String)"PurOrderNewListPlugin_8", (String)"drp-dpa-formplugin", (Object[])new Object[0]));
                    }
                    DynamicObject dispatchOrder = BusinessDataServiceHelper.newDynamicObject((String)"mdr_dispatch_confirm");
                    dispatchOrder.set("billid", id);
                    dispatchOrder.set("remark", (Object)ResManager.loadKDString((String)"\u624b\u52a8\u786e\u8ba4\uff01", (String)"PurOrderNewListPlugin_9", (String)"drp-dpa-formplugin", (Object[])new Object[0]));
                    dispatchOrder.set("ordertype", (Object)"dispatchorder");
                    OperationUtil.invokeOperation((DynamicObject)dispatchOrder, (String)"save");
                }
            }
        }
        if (!key.equals(RE_FRESH) && !key.equals(EXPORT_BY_LISTSELECT)) {
            this.getListView().refresh();
        }
    }

    protected void sendAllotMsg() {
        Object[] saleorderids;
        for (Object saleorderid : saleorderids = this.getSelectedOrderIds(false)) {
            this.sendAllotMsg(saleorderid);
        }
    }

    protected void sendAllotMsg(Object saleorderid) {
        DynamicObject saleorder = BusinessDataServiceHelper.loadSingle((Object)saleorderid, (String)this.getModelName(), (String)"id,orderstatus,confirmstatus");
        if (!this.checkCanSendAllotMsg(saleorder)) {
            return;
        }
        saleorder.set("confirmstatus", (Object)SaleOrderConfirmStatus.ALLOTSENDED.getFlagStr());
        SaleOrderUtil.unWriteDispatchOrderConfirmStatus((Object)saleorderid, (String)DispatchOrderConfirmStatus.ALLOTSENDED.getFlagStr());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{saleorder});
        ShortMessageUtil.sendDispatchOrderMsg((Object)saleorderid);
    }

    protected boolean checkCanSendAllotMsg(DynamicObject saleorder) {
        String orderStatus = saleorder.getString("orderstatus");
        String confirmStatus = saleorder.getString("confirmstatus");
        return !(!orderStatus.equals(SaleOrderStatus.DISPATCHED.getFlagStr()) && !orderStatus.equals(SaleOrderStatus.PENDING_DELIVERY.getFlagStr()) || !confirmStatus.equals(SaleOrderConfirmStatus.ALLOTSENDED.getFlagStr()) && !confirmStatus.equals(SaleOrderConfirmStatus.EMPTY.getFlagStr()));
    }

    protected void sendAmountMsg() {
        Object[] saleorderids;
        if (!SysParamsUtil.isNeedConfirmOrderAmount()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8ba2\u5355\u5e94\u6536\u662f\u5426\u9700\u8981\u5ba2\u6237\u786e\u8ba4 \u53c2\u6570\u672a\u5f00\u542f", (String)"PurOrderNewListPlugin_10", (String)"drp-dpa-formplugin", (Object[])new Object[0]));
        }
        for (Object saleorderid : saleorderids = this.getSelectedOrderIds(false)) {
            this.sendAmountMsg(saleorderid);
        }
    }

    protected void sendAmountMsg(Object saleorderid) {
        DynamicObject saleorder = BusinessDataServiceHelper.loadSingle((Object)saleorderid, (String)this.getModelName(), (String)"id,amountstatus,confirmstatus");
        if (!this.checkCanSendAmountMsg(saleorder)) {
            return;
        }
        saleorder.set("confirmstatus", (Object)SaleOrderConfirmStatus.AMOUNTSENDED.getFlagStr());
        SaleOrderUtil.unWriteDispatchOrderConfirmStatus((Object)saleorderid, (String)DispatchOrderConfirmStatus.AMOUNTSENDED.getFlagStr());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{saleorder});
        ShortMessageUtil.sendAmountOrderMsg((Object)saleorderid);
    }

    protected boolean checkCanSendAmountMsg(DynamicObject saleorder) {
        String amountStatus = saleorder.getString("amountstatus");
        String confirmStatus = saleorder.getString("confirmstatus");
        return amountStatus.equals(SaleOrderReceStatus.ALREADY_RECE.getFlagStr()) && !confirmStatus.equals(SaleOrderConfirmStatus.AMOUNTCONFIRMED.getFlagStr());
    }

    private void toDispatchOrder(ListFilterParameter filter) {
        ListShowParameter parameter = new ListShowParameter();
        parameter.setFormId("bos_list");
        parameter.setBillFormId("mdr_dispatch_order");
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.setListFilterParameter(filter);
        this.getView().showForm((FormShowParameter)parameter);
    }

    private void toAllotPage() {
        Object[] ids = this.getSelectedOrderIds(true);
        if (ids.length == 0 || ids.length > 1) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u53ea\u80fd\u52fe\u9009\u4e00\u6761\u8bb0\u5f55\u8fdb\u884c\u5206\u914d\uff01", (String)"PurOrderNewListPlugin_11", (String)"drp-dpa-formplugin", (Object[])new Object[0]));
            return;
        }
        Object pk = ids[0];
        String operation = "allot";
        String pageId = this.getExsistPage(pk, operation);
        IFormView View = this.getView().getParentView();
        IFormView childView = View.getView(pageId);
        if (childView != null) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8be5\u9500\u552e\u8ba2\u5355\u5206\u914d\u9875\u9762\u5df2\u6253\u5f00\uff01", (String)"PurOrderNewListPlugin_12", (String)"drp-dpa-formplugin", (Object[])new Object[0]));
            return;
        }
        BillShowParameter parameter = new BillShowParameter();
        parameter.setFormId("mdr_allot_order");
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.getOpenStyle().setTargetKey(TO_ALLOT);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, RE_FRESH));
        parameter.setCustomParam("orderid", pk);
        this.getView().showForm((FormShowParameter)parameter);
        pageId = parameter.getPageId();
        this.cachePageId(pk, pageId, operation);
    }

    private void toLogisticsSend() {
        Object[] ids = this.getSelectedOrderIds(true);
        Object saleorderid = ids[0];
        DynamicObject saleorder = QueryServiceHelper.queryOne((String)this.getModelName(), (String)"orderstatus", (QFilter[])new QFilter("id", "=", saleorderid).toArray());
        SaleOrderStatus status = SaleOrderUtil.getOrderStatus((DynamicObject)saleorder);
        List afterDispatchStatus = SaleOrderHandler.getAfterDispatchStatus();
        if (!afterDispatchStatus.contains(status.getFlagStr())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u975e\u5df2\u5206\u8d27\u53ca\u4ee5\u540e\u7684\u72b6\u6001\u8ba2\u5355\u4e0d\u80fd\u751f\u6210\u6d3e\u8f66\u5355\u3002", (String)"PurOrderNewListPlugin_13", (String)"drp-dpa-formplugin", (Object[])new Object[0]));
        }
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("mdr_logistics_send");
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.setCustomParam("orderid", ids[0]);
        parameter.setStatus(OperationStatus.ADDNEW);
        this.getView().showForm(parameter);
    }

    private void toGeneration() {
        Object[] ids = this.getSelectedOrderIds(true);
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("mdr_money_debt");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCustomParam("orderid", ids[0]);
        this.getView().showForm(parameter);
    }

    private void toEvaluate() {
        Object[] ids = this.getSelectedOrderIds(true);
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("mdr_order_evaluate_op");
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.getOpenStyle().setTargetKey(TO_EVALUATE);
        parameter.setCustomParam("orderid", ids[0]);
        this.getView().showForm(parameter);
    }

    private void toSignPage() {
        Object[] ids = this.getSelectedOrderIds(false);
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("mdr_delivery_sign");
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.getOpenStyle().setTargetKey(TO_SIGN);
        parameter.setCustomParam("orderList", Arrays.asList(ids));
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, RE_FRESH));
        this.getView().showForm(parameter);
    }

    protected void toDeliveryPage() {
        throw new KDBizException(ResManager.loadKDString((String)"\u8981\u8d27\u65b9\u6682\u4e0d\u5141\u8bb8\u53d1\u8d27", (String)"PurOrderNewListPlugin_14", (String)"drp-dpa-formplugin", (Object[])new Object[0]));
    }

    protected Object[] getSelectedOrderIds(boolean isSingle) {
        Object[] ids = this.getSelectIds();
        int size = ids.length;
        if (size == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u8bb0\u5f55\uff01", (String)"PurOrderNewListPlugin_15", (String)"drp-dpa-formplugin", (Object[])new Object[0]));
        }
        if (isSingle && size > 1) {
            throw new KDBizException(ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u62e9\u4e00\u6761\u8bb0\u5f55\uff01", (String)"PurOrderNewListPlugin_16", (String)"drp-dpa-formplugin", (Object[])new Object[0]));
        }
        return ids;
    }

    protected Object getSelectedOrderId() {
        Object[] selectedOrderIds = this.getSelectedOrderIds(true);
        return selectedOrderIds[0];
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String key;
        super.closedCallBack(e);
        switch (key = e.getActionId()) {
            case "invalid": {
                Map param = (Map)e.getReturnData();
                if (param == null || param.get("isconfirm") == null || !"true".equals(param.get("isconfirm"))) break;
                DynamicObject order = BusinessDataServiceHelper.loadSingle(param.get("orderid"), (String)this.getModelName());
                Object detail = param.get("detail");
                order.set("invalidreason", detail);
                OperationUtil.invokeOperation((DynamicObject)order, (String)TO_INVALID);
                this.getListView().refresh();
                break;
            }
            case "unsubmit": 
            case "unaudit": 
            case "delete": 
            case "withdraw": 
            case "valid": {
                Map param = (Map)e.getReturnData();
                if (param == null || param.get("isconfirm") == null || !"true".equals(param.get("isconfirm"))) break;
                String remark = (String)param.get("remark");
                List list = (List)param.get("ids");
                Map orderMap = BusinessDataServiceHelper.loadFromCache((Object[])list.toArray(), (String)this.getModelName());
                DynamicObject[] orders = new DynamicObject[orderMap.size()];
                int i = 0;
                for (Map.Entry orderEntry : orderMap.entrySet()) {
                    ((DynamicObject)orderEntry.getValue()).set("operateremark", (Object)remark);
                    orders[i++] = (DynamicObject)orderEntry.getValue();
                }
                OperationUtil.invokeOperation((DynamicObject[])orders, (String)key);
                this.getListView().refresh();
                break;
            }
            case "refresh": 
            case "showSaleOrderInfo": {
                this.getListView().refresh();
                break;
            }
        }
    }

    protected void createTabFilter(SetFilterEvent e) {
        List qFilters = e.getQFilters();
        Tab filtertab = (Tab)this.getControl("filtertab");
        if (filtertab != null) {
            String currentTab = filtertab.getCurrentTab();
            QFilter f = null;
            switch (currentTab) {
                case "alltab": {
                    break;
                }
                case "tosubmittab": {
                    f = new QFilter("orderstatus", "=", (Object)"A");
                    break;
                }
                case "toaudittab": {
                    f = new QFilter("orderstatus", "=", (Object)"B");
                    break;
                }
                case "todelvtab": {
                    f = new QFilter("orderstatus", "in", (Object)new String[]{"C", "D"});
                    break;
                }
                case "tosigntab": {
                    f = new QFilter("orderstatus", "in", (Object)new String[]{"E", "D"});
                    break;
                }
                case "completetab": {
                    f = new QFilter("orderstatus", "=", (Object)"H");
                    break;
                }
            }
            if (f != null) {
                qFilters.add(f);
            }
        }
    }

    public void packageData(PackageDataEvent e) {
        super.packageData(e);
        Object formatValue = e.getFormatValue();
        Object source = e.getSource();
        DynamicObject rowData = e.getRowData();
        if (source instanceof ListOperationColumnDesc) {
            List items = (List)formatValue;
            for (OperationColItem item : items) {
                if (!item.getOperationKey().equals("confirmchange")) continue;
                String orderstatus = rowData.getString("orderstatus");
                if (SaleOrderStatus.CHANGING.getFlagStr().equals(orderstatus)) continue;
                item.setVisible(false);
            }
        }
    }

    public void tabSelected(TabSelectEvent e) {
        BillList billlistap = (BillList)this.getControl("billlistap");
        billlistap.refresh();
    }

    private void orderInventoryCheck() {
        Object[] selectedOrderIds = this.getSelectedOrderIds(false);
        DynamicObject[] orders = BusinessDataServiceHelper.load((Object[])selectedOrderIds, (DynamicObjectType)this.getListModel().getDataEntityType());
        HashMap keyMap = new HashMap();
        HashMap errorInfo = new HashMap();
        List billnos = new ArrayList();
        for (DynamicObject data : orders) {
            DynamicObject currentOwner = data.getDynamicObject("owner");
            Object ownerId = currentOwner.get("id");
            String isallow = CustomerParamsUtil.isAllowOver((Object)ownerId);
            if (isallow.equals("0")) continue;
            String billno = data.getString(F_billno);
            DynamicObjectCollection itemEntryCollection = data.getDynamicObjectCollection("itementry");
            StringBuilder sb = new StringBuilder();
            for (DynamicObject itemEntry : itemEntryCollection) {
                DynamicObject wareHouseVal;
                DynamicObject assistattrVal;
                DynamicObject unitVal;
                String entrytype = itemEntry.getString("entrytype");
                if (SaleOrderEntryType.COMBINATION.getFlagStr().equals(entrytype)) continue;
                sb = new StringBuilder();
                Object itemId = null;
                Object unitId = null;
                Object assistattrId = null;
                Object wareHouseId = null;
                String seq = itemEntry.getString("seq");
                DynamicObject itemVal = itemEntry.getDynamicObject("item");
                if (itemVal != null) {
                    itemId = itemVal.get("id");
                    sb.append(itemId);
                }
                if ((unitVal = itemEntry.getDynamicObject("unit")) != null) {
                    unitId = unitVal.get("id");
                    sb.append(unitId);
                }
                if ((assistattrVal = itemEntry.getDynamicObject("assistattr")) != null) {
                    assistattrId = assistattrVal.get("id");
                    sb.append(assistattrId);
                }
                if ((wareHouseVal = itemEntry.getDynamicObject("entrywarehouse")) != null) {
                    wareHouseId = wareHouseVal.get("id");
                    sb.append(wareHouseId);
                }
                int alterqty = itemEntry.getInt("alterqty");
                DynamicObject storeObject = ItemStoreUtil.queryItemStore((Object)ownerId, (Object)itemId, (Object)unitId, (Object)assistattrId, (Object)wareHouseId);
                if (!keyMap.containsKey(sb.toString())) {
                    int qty = storeObject.getInt("qty") - storeObject.getInt("orderqty");
                    LinkedHashMap<String, Integer> map = new LinkedHashMap<String, Integer>();
                    map.put(seq, qty - alterqty);
                    keyMap.put(sb.toString(), map);
                    if (qty >= alterqty) continue;
                    billnos = !errorInfo.containsKey(isallow) ? new ArrayList() : (List)errorInfo.get(isallow);
                    billnos.add(billno);
                    errorInfo.put(isallow, billnos);
                    continue;
                }
                LinkedHashMap map = (LinkedHashMap)keyMap.get(sb.toString());
                Map.Entry entry = this.getTail(map);
                int qty = (Integer)entry.getValue();
                map.put(seq, qty - alterqty);
                if (qty >= alterqty) continue;
                billnos = !errorInfo.containsKey(isallow) ? new ArrayList() : (List)errorInfo.get(isallow);
                billnos.add(billno);
                errorInfo.put(isallow, billnos);
            }
        }
        if (errorInfo.size() > 0) {
            List value = (List)errorInfo.get("1");
            if (value != null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8ba2\u5355\u7f16\u53f7\u4e3a\uff1a", (String)"PurOrderNewListPlugin_17", (String)"drp-dpa-formplugin", (Object[])new Object[0]) + StringUtils.join((Collection)((Collection)errorInfo.get("1")), (String)"\u3001") + ResManager.loadKDString((String)"\u7684\u8ba2\u5355\u4e0b\u5355\u6570\u91cf\u8d85\u51fa\u5e93\u5b58\u53ef\u7528\u6570\u91cf\uff01", (String)"PurOrderNewListPlugin_18", (String)"drp-dpa-formplugin", (Object[])new Object[0]));
            } else {
                String error = ResManager.loadKDString((String)"\u8ba2\u5355\u7f16\u53f7\u4e3a\uff1a", (String)"PurOrderNewListPlugin_17", (String)"drp-dpa-formplugin", (Object[])new Object[0]) + StringUtils.join((Collection)((Collection)errorInfo.get("2")), (String)"\u3001") + ResManager.loadKDString((String)"\u7684\u8ba2\u5355\u4e0b\u5355\u6570\u91cf\u8d85\u51fa\u5e93\u5b58\u53ef\u7528\u6570\u91cf\uff01", (String)"PurOrderNewListPlugin_18", (String)"drp-dpa-formplugin", (Object[])new Object[0]);
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("submitCallBack", (IFormPlugin)this);
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5b58\u5728\u4e0b\u5355\u6570\u91cf\u8d85\u51fa\u5e93\u5b58\u53ef\u7528\u6570\u91cf\u7684\u5355\u636e\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"PurOrderNewListPlugin_19", (String)"drp-dpa-formplugin", (Object[])new Object[0]), error, MessageBoxOptions.YesNo, ConfirmTypes.Save, confirmCallBacks);
            }
        } else {
            this.getView().invokeOperation(SUBMIT);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        if ("submitCallBack".equals(messageBoxClosedEvent.getCallBackId())) {
            if (messageBoxClosedEvent.getResult().equals((Object)MessageBoxResult.Yes)) {
                this.getView().invokeOperation(SUBMIT);
            } else {
                return;
            }
        }
    }

    public <K, V> Map.Entry<K, V> getTail(LinkedHashMap<K, V> map) {
        Iterator<Map.Entry<K, V>> iterator = map.entrySet().iterator();
        Map.Entry<K, V> tail = null;
        while (iterator.hasNext()) {
            tail = iterator.next();
        }
        return tail;
    }
}

