/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dpa.formplugin.bill.saleorder;

import java.math.BigDecimal;
import java.util.Date;
import java.util.Iterator;
import kd.bos.coderule.api.CodeRuleInfo;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.botp.plugin.args.AfterCreateLinkEventArgs;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.CodeRuleServiceHelper;
import kd.drp.mdr.formplugin.MdrBillConvertPlugin;

public class SaleOrderPushOEMPlugin
extends MdrBillConvertPlugin {
    private static final String BILLNO = "billno";
    private static final String CREATEDATE = "createdate";
    private static final String NEEDCOMPLETDATE = "needcompletedate";
    private static final String COMPLETEDATE = "completedate";
    private static final String NEEDSHIPMENTDATE = "needshipmentdate";
    private static final String SHIPMENTDATE = "shipmentdate";
    private static final String PRODUCTSTATUS = "productstatus";
    private static final String SENDSTATUS = "sendstatus";
    private static final String PLANPRODUCTQTY = "planproductqty";

    public void afterCreateLink(AfterCreateLinkEventArgs e) {
        ExtendedDataEntity[] billDataEntitys;
        for (ExtendedDataEntity billDataEntity : billDataEntitys = e.getTargetExtDataEntitySet().FindByEntityKey(this.targetEntityNumber)) {
            DynamicObject oemOrder = billDataEntity.getDataEntity();
            oemOrder.set(BILLNO, (Object)this.initNumber());
            oemOrder.set(CREATEDATE, (Object)new Date());
            oemOrder.set(NEEDCOMPLETDATE, (Object)new Date());
            oemOrder.set(COMPLETEDATE, (Object)new Date());
            oemOrder.set(NEEDSHIPMENTDATE, (Object)new Date());
            oemOrder.set(SHIPMENTDATE, (Object)new Date());
            oemOrder.set(PRODUCTSTATUS, (Object)"A");
            oemOrder.set(SENDSTATUS, (Object)"A");
            DynamicObjectCollection itementrys = oemOrder.getDynamicObjectCollection("itementry");
            Iterator it = itementrys.iterator();
            while (it.hasNext()) {
                DynamicObject entity = (DynamicObject)it.next();
                if (entity.getBigDecimal("alterqty").compareTo(BigDecimal.ZERO) == 0 || entity.getDynamicObject("item") == null) {
                    it.remove();
                    continue;
                }
                entity.set(PLANPRODUCTQTY, entity.get("alterqty"));
                entity.set("entryneedcompletedate", oemOrder.get(NEEDCOMPLETDATE));
                entity.set("entrycompletedate", oemOrder.get(COMPLETEDATE));
                entity.set("entryneedshipmentdate", oemOrder.get(NEEDSHIPMENTDATE));
                entity.set("entryshipmentdate", oemOrder.get(SHIPMENTDATE));
            }
            if (itementrys.size() != 0) continue;
            throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u9500\u552e\u8ba2\u5355\u6240\u6709\u5206\u5f55\u6570\u636e\u7684\u786e\u8ba4\u6570\u91cf\u7b49\u4e8e\u5df2\u5206\u8d27\u6570\u91cf,\u4e0d\u5141\u8bb8\u4e0b\u8fbe", (String)"SaleOrderPushOEMPlugin_0", (String)"drp-dpa-formplugin", (Object[])new Object[0]));
        }
    }

    private String initNumber() {
        DynamicObject obj = BusinessDataServiceHelper.newDynamicObject((String)"bbc_oemsaleorder");
        obj.set("createtime", (Object)new Date());
        String orgID = null;
        CodeRuleInfo codeRuleInfo = CodeRuleServiceHelper.getCodeRule((String)obj.getDataEntityType().getName(), (DynamicObject)obj, orgID);
        if (codeRuleInfo == null) {
            return "oem-" + System.currentTimeMillis();
        }
        String number = CodeRuleServiceHelper.getNumber((CodeRuleInfo)codeRuleInfo, (DynamicObject)obj);
        return number;
    }
}

