/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dpa.formplugin.bill.saleorder;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.botp.plugin.args.AfterCreateLinkEventArgs;
import kd.drp.dbd.business.helper.AmountHelper;
import kd.drp.dbd.business.helper.CurrencyHelper;
import kd.drp.mdr.common.StringUtils;
import kd.drp.mdr.formplugin.MdrBillConvertPlugin;

public class SaleOrderReturnConvertPlugin
extends MdrBillConvertPlugin {
    public void afterCreateLink(AfterCreateLinkEventArgs e) {
        ExtendedDataEntity[] billDataEntitys;
        HashMap<Long, BigDecimal> map = new HashMap<Long, BigDecimal>();
        for (ExtendedDataEntity billDataEntity : billDataEntitys = e.getTargetExtDataEntitySet().FindByEntityKey(this.targetEntityNumber)) {
            DynamicObject order = billDataEntity.getDataEntity();
            List srcRows = (List)billDataEntity.getValue("ConvertSource");
            for (int k = 0; k < srcRows.size(); ++k) {
                long entryid = (Long)((DynamicProperty)e.getFldProperties().get("itementry.id")).getValue(srcRows.get(k));
                BigDecimal bigqty = (BigDecimal)((DynamicProperty)e.getFldProperties().get("qty")).getValue(srcRows.get(k));
                map.put(entryid, bigqty);
            }
            DynamicObjectCollection itementrys = order.getDynamicObjectCollection("itementry");
            BigDecimal taxAndPriceSum = BigDecimal.ZERO;
            BigDecimal amountSum = BigDecimal.ZERO;
            BigDecimal taxamountSum = BigDecimal.ZERO;
            BigDecimal rebAmountSum = BigDecimal.ZERO;
            boolean isTax = order.getBoolean("hastax");
            BigDecimal exChangeRate = null;
            int settlePrecision = 10;
            int currencyPrecision = 10;
            exChangeRate = order.getBigDecimal("exchangerate");
            DynamicObject currency = order.getDynamicObject("currency");
            DynamicObject localcurrency = order.getDynamicObject("localcurrency");
            DynamicObject exRateTable = order.getDynamicObject("exratetable");
            DynamicObject org = order.getDynamicObject("saleorg");
            if (org != null) {
                Long orgId = (Long)org.getPkValue();
                if (localcurrency == null) {
                    localcurrency = CurrencyHelper.getCurrency((Long)orgId);
                    order.set("localcurrency", (Object)localcurrency);
                }
                if (localcurrency != null) {
                    currencyPrecision = currency.getInt("amtprecision");
                }
                if (currency != null) {
                    settlePrecision = currency.getInt("amtprecision");
                }
                if (exRateTable == null) {
                    exRateTable = CurrencyHelper.getExRateTable((Long)orgId);
                    order.set("exratetable", (Object)exRateTable);
                }
            }
            if (exChangeRate == null || exChangeRate.compareTo(BigDecimal.ZERO) == 0) {
                Date bizTime = order.getDate("billdate");
                if (localcurrency != null && currency != null && exRateTable != null && bizTime != null) {
                    Long curId = (Long)localcurrency.getPkValue();
                    Long settleCurId = (Long)currency.getPkValue();
                    Long exRateTableId = (Long)exRateTable.getPkValue();
                    exChangeRate = CurrencyHelper.getExChangeRate((Long)settleCurId, (Long)curId, (Long)exRateTableId, (Date)bizTime);
                    order.set("exchangerate", (Object)exChangeRate);
                }
            }
            for (DynamicObject itementry : itementrys) {
                long srcid = (Long)itementry.get("srcbillentryid");
                String discountType = itementry.getString("discounttype");
                if (StringUtils.isEmpty((String)discountType)) {
                    itementry.set("discounttype", (Object)"A");
                }
                BigDecimal qty = itementry.getBigDecimal("qty");
                BigDecimal baseqty = itementry.getBigDecimal("qty");
                BigDecimal taxprice = itementry.getBigDecimal("taxprice");
                BigDecimal price = itementry.getBigDecimal("itemprice");
                discountType = itementry.getString("discounttype");
                BigDecimal discount = itementry.getBigDecimal("discount");
                BigDecimal taxRate = itementry.getBigDecimal("taxrate");
                BigDecimal rebprice = itementry.getBigDecimal("rebbackdeductamount");
                rebAmountSum = rebAmountSum.add(baseqty.multiply(rebprice).setScale(settlePrecision, RoundingMode.HALF_UP));
                if (qty != null && ((BigDecimal)map.get(srcid)).compareTo(qty) != 0) {
                    Map amountMap = AmountHelper.getAmount((BigDecimal)qty, (boolean)isTax, (BigDecimal)price, (BigDecimal)taxprice, (BigDecimal)taxRate, (String)discountType, (BigDecimal)discount, (BigDecimal)exChangeRate, (Integer)settlePrecision, (Integer)currencyPrecision);
                    BigDecimal amount = (BigDecimal)amountMap.get("amount");
                    BigDecimal taxAmount = (BigDecimal)amountMap.get("taxamount");
                    BigDecimal amountAndTax = (BigDecimal)amountMap.get("amountandtax");
                    itementry.set("amount", (Object)amount);
                    itementry.set("taxamount", (Object)taxAmount);
                    itementry.set("amountandtax", (Object)amountAndTax);
                    itementry.set("discountamount", amountMap.get("discountamount"));
                    amountSum = amountSum.add(amount);
                    taxamountSum = taxamountSum.add(taxAmount);
                    taxAndPriceSum = taxAndPriceSum.add(amountAndTax);
                    continue;
                }
                BigDecimal amount = itementry.getBigDecimal("amount");
                BigDecimal taxamount = itementry.getBigDecimal("taxamount");
                BigDecimal amountandtax = itementry.getBigDecimal("amountandtax");
                amountSum = amountSum.add(amount);
                taxamountSum = taxamountSum.add(taxamount);
                taxAndPriceSum = taxAndPriceSum.add(amountandtax);
            }
            order.set("currentbackrebamount", (Object)rebAmountSum);
            order.set("totalamountandtax", (Object)taxAndPriceSum);
            order.set("totaltaxamount", (Object)taxamountSum);
            order.set("totalamount", (Object)amountSum);
            order.set("returnstatus", null);
        }
    }
}

