/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dpa.formplugin.item;

import java.math.BigDecimal;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Search;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.drp.mdr.common.CommonUtils;
import kd.drp.mdr.common.f7.F7Utils;
import kd.drp.mdr.common.item.ConversionDirection;
import kd.drp.mdr.common.model.dpm.DetailItemInfo;
import kd.drp.mdr.common.model.dpm.UsablePromotionResult;
import kd.drp.mdr.common.util.BizValidateUtils;
import kd.drp.mdr.common.util.CustomerUtil;
import kd.drp.mdr.common.util.ItemAttrUtil;
import kd.drp.mdr.common.util.OrderQuantityUtil;
import kd.drp.mdr.common.util.PriceUtil;
import kd.drp.mdr.common.util.UserUtil;
import kd.drp.mdr.common.util.WebUtil;
import kd.drp.mdr.formplugin.MdrFormPlugin;
import kd.drp.mdr.servicehelper.PromotionServiceHelper;

public class ShoppingCartEditPlugin
extends MdrFormPlugin
implements SearchEnterListener,
HyperLinkClickListener,
BeforeF7SelectListener {
    public static final String TOOL_BARAP = "toolbarap";
    public static final String ITEM_LIST = "itemlist";
    public static final String CUSTOMER = "customer";
    public static final String OWNER = "owner";
    public static final String ITEM_CLASS = "itemclass";
    public static final String ITEM_BRAND = "itembrand";
    public static final String SEARCHAP = "searchap";
    public static final String GOTO_ITEM_PICK = "gotoitempick";
    public static final String GOTOORDER = "gotoorder";
    public static final String DELETE = "delete";
    public static final String REFRESH = "refresh";
    public static final String UNIT = "unit";
    public static final String ASSISTUNIT = "assistunit";
    public static final String ITEM = "item";
    public static final String ITEM_NAME = "itemname";
    public static final String QTY = "qty";
    public static final String ASSISTQTY = "assistqty";
    public static final String PRICE = "price";
    public static final String COUNT = "count";
    public static final String PICTURE = "picture";
    public static final String ITEMBRANDS = "itembrands";
    public static final String CARTID = "cartid";
    public static final String CUSTOMERKEY = "customerkey";
    public static final String PROMOTIONKEY = "promotionkey";
    public static final String SPLITKEY = "&";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{TOOL_BARAP});
        EntryGrid fieldMapGrid = (EntryGrid)this.getView().getControl(ITEM_LIST);
        fieldMapGrid.addHyperClickListener((HyperLinkClickListener)this);
        Search search = (Search)this.getView().getControl(SEARCHAP);
        search.addEnterListener((SearchEnterListener)this);
        this.addF7Listener(this, new String[]{"assistattr", OWNER, CUSTOMER, ITEM_CLASS, ITEM_BRAND});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Object customer = this.getView().getFormShowParameter().getCustomParam("customerId");
        Object ownerId = this.getView().getFormShowParameter().getCustomParam("ownerId");
        if (customer != null && ownerId != null) {
            this.setValue(CUSTOMER, customer);
            this.setValue(OWNER, ownerId);
        } else {
            Object defaultOwnerid = UserUtil.getDefaultOwnerID();
            this.setValue(OWNER, defaultOwnerid);
            this.setDefaultCustomer();
        }
        this.initItemList(null);
    }

    private void setDefaultCustomer() {
        Object owner = this.getF7PKValue(OWNER);
        if (owner == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u8bbe\u7f6e\u8981\u8d27\u6e20\u9053\uff0c\u8bf7\u5148\u9009\u62e9\u8981\u8d27\u6e20\u9053", (String)"ShoppingCartEditPlugin_0", (String)"drp-dpa-formplugin", (Object[])new Object[0]));
            return;
        }
        List authOwnerIDs = CustomerUtil.getAuthOwnerIDs((Object)owner);
        if (authOwnerIDs.toArray().length > 0) {
            this.setValue(CUSTOMER, authOwnerIDs.toArray()[0]);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        if (GOTO_ITEM_PICK.equals(evt.getItemKey())) {
            this.showItemPick();
        } else if (GOTOORDER.equals(evt.getItemKey())) {
            this.goToOrder();
        } else if (DELETE.equals(evt.getItemKey())) {
            this.deleteItemCart();
        } else if (REFRESH.equals(evt.getItemKey())) {
            this.refreshList();
        }
    }

    private void refreshList() {
        this.initItemList(null);
    }

    private void deleteItemCart() {
        int[] rows;
        IDataModel model = this.getModel();
        EntryGrid itemList = (EntryGrid)this.getControl(ITEM_LIST);
        for (int row : rows = itemList.getSelectRows()) {
            Object cartId = model.getValue(CARTID, row);
            DynamicObject cartItem = BusinessDataServiceHelper.loadSingle((Object)cartId, (String)"mdr_shopping_cart");
            DeleteServiceHelper.delete((IDataEntityType)cartItem.getDataEntityType(), (Object[])new Object[]{cartId});
        }
        this.refreshList();
    }

    private void showItemPick() {
        FormShowParameter parameter = new FormShowParameter();
        Object customerId = this.getCustomerF7PKValue();
        Object ownerId = this.getOwnerF7PKValue();
        if (ownerId == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u8bbe\u7f6e\u8981\u8d27\u6e20\u9053\uff0c\u8bf7\u5148\u9009\u62e9\u8981\u8d27\u6e20\u9053\u518d\u4e0b\u5355\uff01", (String)"ShoppingCartEditPlugin_1", (String)"drp-dpa-formplugin", (Object[])new Object[0]));
            return;
        }
        if (customerId == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u8bbe\u7f6e\u4f9b\u8d27\u6e20\u9053\uff0c\u8bf7\u5148\u9009\u62e9\u4f9b\u8d27\u6e20\u9053\u518d\u4e0b\u5355\uff01", (String)"ShoppingCartEditPlugin_2", (String)"drp-dpa-formplugin", (Object[])new Object[0]));
            return;
        }
        parameter.setCustomParam("customerId", customerId);
        parameter.setCustomParam("ownerId", ownerId);
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.setFormId("mdr_item_pick");
        this.getView().showForm(parameter);
    }

    private void goToOrder() {
        Object customerId = this.getCustomerF7PKValue();
        Object ownerId = this.getOwnerF7PKValue();
        if (ownerId == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u8bbe\u7f6e\u8981\u8d27\u6e20\u9053\uff0c\u8bf7\u5148\u9009\u62e9\u8981\u8d27\u6e20\u9053\u518d\u4e0b\u5355\uff01", (String)"ShoppingCartEditPlugin_1", (String)"drp-dpa-formplugin", (Object[])new Object[0]));
            return;
        }
        if (customerId == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u8bbe\u7f6e\u4f9b\u8d27\u6e20\u9053\uff0c\u8bf7\u5148\u9009\u62e9\u4f9b\u8d27\u6e20\u9053\u518d\u4e0b\u5355\uff01", (String)"ShoppingCartEditPlugin_2", (String)"drp-dpa-formplugin", (Object[])new Object[0]));
            return;
        }
        BillShowParameter parameter = new BillShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.setFormId("dpa_purorder");
        parameter.setStatus(OperationStatus.ADDNEW);
        parameter.setCustomParam("customerId", ownerId);
        parameter.setCustomParam("ownerId", customerId);
        ArrayList<Object> cartList = new ArrayList<Object>();
        IDataModel model = this.getModel();
        EntryGrid itemList = (EntryGrid)this.getControl(ITEM_LIST);
        int[] rows = itemList.getSelectRows();
        if (rows.length > 0) {
            for (int row : rows) {
                Object item = this.getModel().getValue(ITEM, row);
                if (item == null || !((DynamicObject)item).getBoolean("enable")) continue;
                Object cartId = model.getValue(CARTID, row);
                cartList.add(cartId);
            }
            if (cartList.size() == 0) {
                this.getView().showTipNotification("\u8bf7\u52fe\u9009\u6ca1\u6709\u5931\u6548\u7684\u5546\u54c1\u751f\u6210\u5355\u636e\u3002");
                return;
            }
        } else {
            Map<Object, DynamicObject> cartCollection = ShoppingCartEditPlugin.getShoppingCartList(ownerId, customerId, Character.valueOf('0'));
            if (cartCollection != null && cartCollection.size() > 0) {
                for (DynamicObject cart : cartCollection.values()) {
                    DynamicObject item = cart.getDynamicObject(ITEM);
                    if (item == null || !item.getBoolean("enable")) continue;
                    cartList.add(cart.get("id"));
                }
            }
            if (cartList.size() == 0) {
                this.getView().showTipNotification("\u8d2d\u7269\u8f66\u4e0d\u5b58\u5728\u6709\u6548\u7684\u5546\u54c1\u4fe1\u606f\u53ef\u4ee5\u751f\u6210\u5355\u636e\u3002");
                return;
            }
        }
        if (cartList.size() > 0) {
            parameter.setCustomParam("cartList", cartList);
        }
        this.getView().showForm((FormShowParameter)parameter);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        int index = this.getRowIndex(e);
        String key = e.getProperty().getName();
        if (!this.triggerChangeEvent) {
            return;
        }
        this.triggerChangeEvent = false;
        DynamicObject assistUnit = null;
        BigDecimal baseQty = null;
        BigDecimal assistQty = null;
        Object itemId = null;
        DynamicObject item = null;
        String conversionfor = null;
        switch (key) {
            case "qty": {
                item = this.getEntryF7Value(ITEM_LIST, ITEM, index);
                if (item == null) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u5546\u54c1\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\uff01", (String)"ShoppingCartEditPlugin_3", (String)"drp-dpa-formplugin", (Object[])new Object[0]));
                }
                itemId = item.get("id");
                conversionfor = item.getString("conversionfor");
                assistUnit = this.getEntryF7Value(ITEM_LIST, ASSISTUNIT, index);
                assistQty = (BigDecimal)this.getValue(ASSISTQTY, index);
                baseQty = (BigDecimal)this.getValue(QTY, index);
                if ((ConversionDirection.FOR_EACH.getConversionFor().equals(conversionfor) || ConversionDirection.FOR_ASSISTUNIT.getConversionFor().equals(conversionfor)) && assistUnit != null) {
                    assistQty = this.getUnitFormHandler().getUnitQty(itemId, assistUnit.get("id"), baseQty);
                    this.setValue(ASSISTQTY, assistQty, index);
                }
                this.checkOrderQuantity(index);
                this.updateSelectItemList(index);
                break;
            }
            case "assistqty": {
                item = this.getEntryF7Value(ITEM_LIST, ITEM, index);
                if (item == null) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u5546\u54c1\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\uff01", (String)"ShoppingCartEditPlugin_3", (String)"drp-dpa-formplugin", (Object[])new Object[0]));
                }
                itemId = item.get("id");
                conversionfor = item.getString("conversionfor");
                assistUnit = this.getEntryF7Value(ITEM_LIST, ASSISTUNIT, index);
                assistQty = (BigDecimal)this.getValue(ASSISTQTY, index);
                if (!ConversionDirection.FOR_EACH.getConversionFor().equals(conversionfor) && !ConversionDirection.FOR_MWASUREUNIT.getConversionFor().equals(conversionfor)) break;
                if (assistUnit != null) {
                    assistQty = (BigDecimal)this.getValue(ASSISTQTY, index);
                    baseQty = this.getUnitFormHandler().getBaseQty(itemId, assistQty, assistUnit.get("id"));
                    this.setValue(QTY, baseQty, index);
                    this.updateSelectItemList(index);
                    this.checkOrderQuantity(index);
                    break;
                }
                this.setValue(ASSISTQTY, BigDecimal.ZERO, index);
                break;
            }
            case "assistattr": {
                itemId = this.getEntryF7PKValue(ITEM_LIST, ITEM, index);
                DynamicObject assistattr = (DynamicObject)e.getChangeSet()[0].getNewValue();
                if (BizValidateUtils.itemAttrNullValidate((Object)itemId, (DynamicObject)assistattr)) {
                    this.updateSelectItemList(index);
                    this.checkOrderQuantity(index);
                    break;
                }
                Object oldValue = e.getChangeSet()[0].getOldValue();
                if (oldValue != null) {
                    this.setValue("assistattr", oldValue, index);
                }
                throw new KDBizException(ResManager.loadKDString((String)"\u5546\u54c1\u5f00\u542f\u8f85\u52a9\u5c5e\u6027\uff0c\u8f85\u52a9\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a\uff01", (String)"ShoppingCartEditPlugin_4", (String)"drp-dpa-formplugin", (Object[])new Object[0]));
            }
            case "owner": {
                this.setCustomerF7Value(null);
                this.setDefaultCustomer();
                this.initItemList(null);
                break;
            }
            case "customer": 
            case "itemclass": 
            case "itembrand": {
                this.initItemList(null);
            }
        }
    }

    protected void checkOrderQuantity(int index) {
        BigDecimal qty = (BigDecimal)this.getValue(QTY, index);
        if (BigDecimal.ZERO.compareTo(qty) == 0) {
            return;
        }
        String errorMsg = this.getOrderQuantityMsg(index);
        if (!StringUtils.isEmpty((CharSequence)errorMsg)) {
            BigDecimal entryqty = new BigDecimal(errorMsg.split(SPLITKEY)[1]);
            errorMsg = errorMsg.split(SPLITKEY)[0];
            if (this.isOrderQuantityStrongControl()) {
                this.getModel().setValue(QTY, (Object)entryqty, index);
                DynamicObject assistUnit = this.getEntryF7Value(ITEM_LIST, ASSISTUNIT, index);
                if (assistUnit != null) {
                    BigDecimal baseQty = (BigDecimal)this.getValue(QTY, index);
                    Object itemId = this.getEntryF7PKValue(ITEM_LIST, ITEM, index);
                    BigDecimal assistQty = this.getUnitFormHandler().getUnitQty(itemId, assistUnit.get("id"), baseQty);
                    this.setValue(ASSISTQTY, assistQty, index);
                }
                this.updateSelectItemList(index);
            }
            this.getView().showTipNotification(errorMsg);
        }
    }

    protected boolean isOrderQuantityStrongControl() {
        return false;
    }

    protected String getOrderQuantityMsg(int index) {
        int rowindex = index + 1;
        String errorHead = MessageFormat.format(ResManager.loadKDString((String)"\u7b2c{0}\u884c\u5546\u54c1\u5df2\u542f\u7528\u8ba2\u8d27\u6279\u91cf\uff0c\u8ba2\u8d27\u6570\u91cf\u9700", (String)"ShoppingCartEditPlugin_19", (String)"drp-dpa-formplugin", (Object[])new Object[0]), rowindex);
        Object owner = this.getCustomerF7PKValue();
        Object customer = this.getOwnerF7PKValue();
        Object warehouse = null;
        Object item = this.getEntryF7PKValue(ITEM_LIST, ITEM, index);
        Object unit = this.getEntryF7PKValue(ITEM_LIST, UNIT, index);
        DynamicObject unitDy = this.getEntryF7Value(ITEM_LIST, UNIT, index);
        String unitTips = "(" + unitDy.getString("name") + ")";
        IPageCache pageCache = this.getPageCache();
        Object assistAttrId = this.getEntryF7PKValue(ITEM_LIST, "assistattr", index);
        Map orderQuantity = OrderQuantityUtil.getOrderQuantityRlue((Object)owner, (Object)customer, warehouse, (Object)item, (Object)unit, (Object)assistAttrId, (IPageCache)pageCache);
        if (orderQuantity == null) {
            return "";
        }
        boolean isLessThanMinQty = false;
        boolean isAccordOrderQuantity = true;
        DynamicObject rowInfo = this.getRowInfo(ITEM_LIST, index);
        BigDecimal entryqty = rowInfo.getBigDecimal(QTY);
        BigDecimal qty = ((BigDecimal)orderQuantity.get(QTY)).stripTrailingZeros();
        BigDecimal minqty = ((BigDecimal)orderQuantity.get("minqty")).stripTrailingZeros();
        StringBuffer errorMessage = new StringBuffer();
        if (entryqty.compareTo(minqty) < 0) {
            isLessThanMinQty = true;
            entryqty = minqty;
            errorMessage.append(ResManager.loadKDString((String)"\u5927\u4e8e", (String)"ShoppingCartEditPlugin_7", (String)"drp-dpa-formplugin", (Object[])new Object[0])).append(minqty.toPlainString()).append(unitTips).append('!');
        }
        BigDecimal[] result = entryqty.divideAndRemainder(qty);
        BigDecimal intpart = result[0];
        BigDecimal remainder = result[1];
        if (remainder.compareTo(BigDecimal.ZERO) > 0) {
            isAccordOrderQuantity = false;
            if (isLessThanMinQty) {
                errorMessage.append(ResManager.loadKDString((String)"\u4e14", (String)"ShoppingCartEditPlugin_8", (String)"drp-dpa-formplugin", (Object[])new Object[0]));
            }
            errorMessage.append(MessageFormat.format(ResManager.loadKDString((String)"\u4e3a{0}{1}\u7684\u500d\u6570\uff01", (String)"ShoppingCartEditPlugin_18", (String)"drp-dpa-formplugin", (Object[])new Object[0]), qty.toPlainString(), unitTips));
        }
        if (!StringUtils.isEmpty((CharSequence)errorMessage)) {
            if (!isAccordOrderQuantity) {
                entryqty = intpart.add(BigDecimal.ONE).multiply(qty).stripTrailingZeros();
                errorMessage.append(ResManager.loadKDString((String)"\u5f53\u524d\u8d2d\u4e70\u6570\u91cf\u5efa\u8bae\u4e3a", (String)"ShoppingCartEditPlugin_11", (String)"drp-dpa-formplugin", (Object[])new Object[0])).append(entryqty);
            }
            StringBuilder str = new StringBuilder();
            str.append(errorHead).append(errorMessage).append('&').append(entryqty);
            return str.toString();
        }
        return "";
    }

    private void updateSelectItemList(int row) {
        IDataModel model = this.getModel();
        DynamicObject item = (DynamicObject)model.getValue(ITEM, row);
        BigDecimal qty = (BigDecimal)model.getValue(QTY, row);
        DynamicObject unit = (DynamicObject)model.getValue(UNIT, row);
        DynamicObject assistattr = (DynamicObject)model.getValue("assistattr", row);
        DynamicObject assistunit = (DynamicObject)model.getValue(ASSISTUNIT, row);
        Object assistUnit = 0L;
        if (assistunit != null) {
            assistUnit = assistunit.get("id");
        }
        BigDecimal assistQty = (BigDecimal)model.getValue(ASSISTQTY, row);
        BigDecimal price = PriceUtil.getItemPrice((Object)this.getCustomerF7PKValue(), (Object)this.getOwnerF7PKValue(), (Object)item.getPkValue(), (Object)unit.get("id"), (Object)assistUnit, (BigDecimal)qty);
        BigDecimal count = BigDecimal.ZERO;
        if (qty != null && price != null) {
            count = qty.multiply(price);
        }
        model.setValue(COUNT, (Object)count, row);
        Object cartId = model.getValue(CARTID, row);
        Object customerId = this.getF7PKValue(CUSTOMER);
        Object ownerId = this.getF7PKValue(OWNER);
        if (ownerId == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u8bbe\u7f6e\u8981\u8d27\u6e20\u9053\uff0c\u8bf7\u5148\u9009\u62e9\u8981\u8d27\u6e20\u9053", (String)"ShoppingCartEditPlugin_0", (String)"drp-dpa-formplugin", (Object[])new Object[0]));
        }
        if (customerId == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u8bbe\u7f6e\u4f9b\u8d27\u6e20\u9053\uff0c\u8bf7\u5148\u9009\u62e9\u4f9b\u8d27\u6e20\u9053", (String)"ShoppingCartEditPlugin_12", (String)"drp-dpa-formplugin", (Object[])new Object[0]));
        }
        BizValidateUtils.itemAttrValidate((Object)item.get("id"), (DynamicObject)assistattr);
        String strFields = String.format("id,%s,%s,%s,%s,%s,%s", UNIT, QTY, "assistattr", ASSISTUNIT, "assistQty", PRICE);
        DynamicObject cartItem = BusinessDataServiceHelper.loadSingle((String)"mdr_shopping_cart", (String)strFields, (QFilter[])new QFilter("id", "=", cartId).toArray());
        if (cartItem != null) {
            if (qty != null && qty.compareTo(BigDecimal.ZERO) > 0) {
                cartItem.set(UNIT, (Object)unit);
                cartItem.set(QTY, (Object)qty);
                cartItem.set("assistattr", (Object)assistattr);
                cartItem.set(ASSISTUNIT, (Object)assistunit);
                cartItem.set("assistQty", (Object)assistQty);
                cartItem.set(PRICE, (Object)price);
                SaveServiceHelper.save((IDataEntityType)cartItem.getDynamicObjectType(), (Object[])new Object[]{cartItem});
            } else {
                DeleteServiceHelper.delete((IDataEntityType)cartItem.getDataEntityType(), (Object[])new Object[]{cartItem.getPkValue()});
            }
        } else {
            cartItem = BusinessDataServiceHelper.newDynamicObject((String)"mdr_shopping_cart");
            cartItem.set(OWNER, ownerId);
            cartItem.set(ITEM, (Object)item);
            cartItem.set(QTY, (Object)qty);
            cartItem.set(UNIT, (Object)unit);
            cartItem.set(PRICE, (Object)price);
            cartItem.set(ASSISTUNIT, (Object)assistunit);
            cartItem.set("assistattr", (Object)assistattr);
            cartItem.set("assistQty", (Object)assistQty);
            cartItem.set("createdate", (Object)new Date());
            cartItem.set(CUSTOMER, customerId);
            cartItem.set("user", UserUtil.getUserID());
            cartItem.set("ispurchasing", (Object)Boolean.FALSE);
            SaveServiceHelper.save((IDataEntityType)cartItem.getDataEntityType(), (Object[])new Object[]{cartItem});
            model.setValue(CARTID, cartItem.get("id"), row);
        }
        model.setValue(PRICE, (Object)price, row);
    }

    private void initItemList(QFilter filter) {
        this.getModel().deleteEntryData(ITEM_LIST);
        Object customerId = this.getCustomerF7PKValue();
        Object ownerId = this.getOwnerF7PKValue();
        if (ownerId == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u8bbe\u7f6e\u8981\u8d27\u6e20\u9053\uff0c\u8bf7\u5148\u9009\u62e9\u8981\u8d27\u6e20\u9053!", (String)"ShoppingCartEditPlugin_13", (String)"drp-dpa-formplugin", (Object[])new Object[0]));
            return;
        }
        if (customerId == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u8bbe\u7f6e\u4f9b\u8d27\u6e20\u9053\uff0c\u8bf7\u5148\u9009\u62e9\u4f9b\u8d27\u6e20\u9053!", (String)"ShoppingCartEditPlugin_14", (String)"drp-dpa-formplugin", (Object[])new Object[0]));
            return;
        }
        IDataModel model = this.getModel();
        Object itemBrand = this.getF7PKValue(ITEM_BRAND);
        Object itemClass = this.getF7PKValue(ITEM_CLASS);
        if (filter == null) {
            filter = new QFilter("owner.id", "=", ownerId);
        } else {
            filter.and("owner.id", "=", ownerId);
        }
        filter.and("customer.id", "=", customerId);
        filter.and("user.id", "=", UserUtil.getUserID());
        filter.and("ispurchasing", "=", (Object)Character.valueOf('0'));
        if (itemBrand != null) {
            filter.and("item.itembrands.fbasedataid", "=", itemBrand);
        }
        Set promotioninfos = null;
        String key = String.format("%s_%s", ownerId, customerId);
        String customerkey = this.getPageCache().get(CUSTOMERKEY);
        if (customerkey == null || key.compareTo(customerkey) != 0) {
            PromotionServiceHelper.removePromotionContextFromCache((String)this.getPageCache().get(PROMOTIONKEY));
            String cachekey = UUID.randomUUID().toString().replace("-", "");
            this.getPageCache().put(PROMOTIONKEY, cachekey);
            promotioninfos = PromotionServiceHelper.matchAndExecutePromotion((String)cachekey, (Object)customerId, (Object)ownerId, (boolean)false, (String[])new String[]{"A"});
            this.getPageCache().put(CUSTOMERKEY, key);
        } else {
            promotioninfos = PromotionServiceHelper.getUsablePromotionResult((String)this.getPageCache().get(PROMOTIONKEY));
        }
        String fileds = "id,item.id,unit,assistunit,assistattr,price,qty,assistqty,customer.id";
        Map cartItemMap = BusinessDataServiceHelper.loadFromCache((String)"mdr_shopping_cart", (String)fileds, (QFilter[])filter.toArray());
        if (cartItemMap == null) {
            return;
        }
        Set itemIdSet = cartItemMap.values().stream().map(obj -> obj.get("item.id")).collect(Collectors.toSet());
        QFilter qFilter = new QFilter("id", "in", itemIdSet);
        long standardId = 0L;
        if (itemClass != null) {
            qFilter.and(new QFilter("itemclassentity.goodsclasssid", "=", itemClass));
        } else {
            DynamicObject itemClassStandard = BusinessDataServiceHelper.loadSingle((Object)1L, (String)"mdr_classstandardapply");
            standardId = itemClassStandard.getLong("classstandardid_id");
        }
        Map itemMap = BusinessDataServiceHelper.loadFromCache((String)"mdr_item_info", (String)"id,itemclassentity.goodsclasssid,itemclassentity.classstandardid", (QFilter[])qFilter.toArray(), (String)"");
        int i = 0;
        DynamicObjectCollection itemClassColl = null;
        DynamicObject itemClassObj = null;
        DynamicObject itemObj = null;
        Object itemId = null;
        for (DynamicObject cartItem : cartItemMap.values()) {
            DynamicObject dyItem;
            itemId = cartItem.get("item.id");
            if (!itemMap.containsKey(itemId)) continue;
            model.createNewEntryRow(ITEM_LIST);
            model.setValue(CARTID, cartItem.get("id"), i);
            model.setValue(ITEM, itemId, i);
            itemObj = (DynamicObject)model.getValue(ITEM, i);
            if (itemObj != null && (dyItem = (DynamicObject)itemMap.get(itemId)) != null) {
                if (itemClass != null) {
                    itemObj.set(ITEM_CLASS, (Object)this.getF7Value(ITEM_CLASS));
                } else {
                    itemClassColl = dyItem.getDynamicObjectCollection("itemclassentity");
                    if (!CommonUtils.isNull((Object)itemClassColl)) {
                        for (DynamicObject dynamicObject : itemClassColl) {
                            if (standardId != dynamicObject.getLong("classstandardid_id")) continue;
                            itemClassObj = dynamicObject.getDynamicObject("goodsclasssid");
                            break;
                        }
                    }
                    itemObj.set(ITEM_CLASS, itemClassObj);
                }
            }
            model.setValue(UNIT, cartItem.get(UNIT), i);
            Object assistattr = cartItem.get("assistattr");
            model.setValue("assistattr", assistattr, i);
            BigDecimal qty = (BigDecimal)cartItem.get(QTY);
            model.setValue(QTY, (Object)qty, i);
            BigDecimal price = (BigDecimal)cartItem.get(PRICE);
            model.setValue(PRICE, (Object)price, i);
            model.setValue(COUNT, (Object)qty.multiply(price), i);
            DynamicObject assistunit = cartItem.getDynamicObject(ASSISTUNIT);
            if (assistunit != null) {
                model.setValue(ASSISTUNIT, (Object)assistunit, i);
                BigDecimal assistqty = (BigDecimal)cartItem.get(ASSISTQTY);
                model.setValue(ASSISTQTY, (Object)assistqty, i);
            } else {
                this.setUnEnable(i, new String[]{ASSISTQTY});
            }
            filter = new QFilter("id", "=", cartItem.getDynamicObject(ITEM).get("id"));
            DynamicObject itemInfo = BusinessDataServiceHelper.loadSingleFromCache((String)"mdr_item_info", (QFilter[])filter.toArray());
            model.setValue(PICTURE, itemInfo.get("thumbnail"), i);
            DynamicObjectCollection itembrandRs = itemInfo.getDynamicObjectCollection("itemBrands");
            StringBuilder itembrandsStr = new StringBuilder();
            Iterator it = itembrandRs.iterator();
            while (it.hasNext()) {
                DynamicObject itembrandR = (DynamicObject)it.next();
                if (itembrandR.getDynamicObject("fbasedataid") == null) continue;
                itembrandsStr.append(itembrandR.getDynamicObject("fbasedataid").get("name"));
                if (!it.hasNext()) continue;
                itembrandsStr.append('\uff0c');
            }
            model.setValue(ITEMBRANDS, (Object)itembrandsStr, i);
            model.setValue("promotiondetatils", (Object)this.getPromotionDetatils(new DetailItemInfo(itemId, (Object)0L, (Object)0L), promotioninfos), i);
            ++i;
        }
    }

    private String getPromotionDetatils(DetailItemInfo iteminfo, Set<UsablePromotionResult> promotioninfos) {
        if (promotioninfos == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        Set itemranges = null;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy/MM/dd");
        int i = 0;
        block0: for (UsablePromotionResult usablePromotionResult : promotioninfos) {
            itemranges = usablePromotionResult.getItemRanges();
            if (itemranges == null) continue;
            for (DetailItemInfo detailItemInfo : itemranges) {
                if (detailItemInfo.getItemid().toString().compareTo(iteminfo.getItemid().toString()) != 0) continue;
                if (i > 2) {
                    stringBuilder.append("...");
                    continue block0;
                }
                stringBuilder.append(String.format("%s\uff1a", usablePromotionResult.getName()));
                stringBuilder.append(String.format("%s-%s\n", simpleDateFormat.format(usablePromotionResult.getstarttime()), simpleDateFormat.format(usablePromotionResult.getendtime())));
                ++i;
                continue block0;
            }
        }
        return stringBuilder.toString();
    }

    public void search(SearchEnterEvent arg0) {
        Search search = (Search)arg0.getSource();
        if (SEARCHAP.equals(search.getKey())) {
            String searchText = arg0.getText();
            this.doSearch(searchText);
        }
    }

    private void doSearch(String searchText) {
        QFilter filter = new QFilter("item.name", "like", (Object)("%" + searchText + "%")).or("item.number", "like", (Object)("%" + searchText + "%")).or("item.searchkey", "like", (Object)("%" + searchText + "%"));
        this.initItemList(filter);
    }

    public void hyperLinkClick(HyperLinkClickEvent args) {
        if (ITEM_NAME.equals(args.getFieldName())) {
            int row = args.getRowIndex();
            DynamicObject item = (DynamicObject)this.getModel().getValue(ITEM, row);
            if (item != null) {
                FormShowParameter parameter = new FormShowParameter();
                parameter.setFormId("mdr_item_detail");
                parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                parameter.setCustomParam("itemId", item.getPkValue());
                this.getView().showForm(parameter);
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent arg0) {
        super.beforeClosed(arg0);
        PromotionServiceHelper.removePromotionContextFromCache((String)this.getPageCache().get(PROMOTIONKEY));
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String key = evt.getProperty().getName();
        int row = evt.getRow();
        switch (key) {
            case "unit": {
                break;
            }
            case "assistattr": {
                Object itemId = this.getEntryF7PKValue(ITEM_LIST, ITEM, row);
                if (itemId == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u5546\u54c1\uff0c\u8bf7\u5237\u65b0\u5217\u8868\u540e\u91cd\u8bd5\uff01", (String)"ShoppingCartEditPlugin_15", (String)"drp-dpa-formplugin", (Object[])new Object[0]));
                    evt.setCancel(true);
                    return;
                }
                F7Utils.addF7Filter((BeforeF7SelectEvent)evt, (QFilter)ItemAttrUtil.getAttrFilter((Object)itemId));
                break;
            }
            case "owner": {
                F7Utils.addF7Filter((BeforeF7SelectEvent)evt, (QFilter)UserUtil.getOwnerIdsQFilter((String)"id"));
                break;
            }
            case "customer": {
                Object owner = this.getF7PKValue(OWNER);
                if (owner == null) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u672a\u8bbe\u7f6e\u8981\u8d27\u6e20\u9053\uff0c\u8bf7\u5148\u9009\u62e9\u8981\u8d27\u6e20\u9053", (String)"ShoppingCartEditPlugin_0", (String)"drp-dpa-formplugin", (Object[])new Object[0]));
                }
                List authOwnerIDs = CustomerUtil.getAuthOwnerIDs((Object)owner);
                F7Utils.addF7Filter((BeforeF7SelectEvent)evt, (QFilter)WebUtil.getIdQFilter((Collection)authOwnerIDs));
                break;
            }
            case "itemclass": {
                DynamicObject itemClassStandard = BusinessDataServiceHelper.loadSingle((Object)1L, (String)"mdr_classstandardapply");
                long standardId = itemClassStandard.getLong("classstandardid_id");
                ListShowParameter formShowParameter = (ListShowParameter)evt.getFormShowParameter();
                formShowParameter.setCustomParam("groupStandard", (Object)standardId);
                QFilter itemStandardFilter = new QFilter("standard", "=", (Object)standardId);
                formShowParameter.getListFilterParameter().getQFilters().add(itemStandardFilter);
                break;
            }
            case "itembrand": {
                DynamicObjectCollection entryColl = this.getView().getModel().getEntryEntity(ITEM_LIST);
                if (entryColl == null || entryColl.size() <= 0) break;
                Set itemIdSet = entryColl.stream().map(entryDynObj -> entryDynObj.getLong("item_id")).collect(Collectors.toSet());
                QFilter itemIdFilter = new QFilter("id", "in", itemIdSet);
                DynamicObject[] itemInfoDynObjs = BusinessDataServiceHelper.load((String)"mdr_item_info", (String)ITEMBRANDS, (QFilter[])new QFilter[]{itemIdFilter});
                Set<Object> itemBrandIdSet = new HashSet();
                HashSet itemBrandSet = new HashSet();
                if (itemInfoDynObjs != null && itemInfoDynObjs.length > 0) {
                    for (DynamicObject itemInfoDynObj : itemInfoDynObjs) {
                        itemBrandSet.addAll(itemInfoDynObj.getDynamicObjectCollection(ITEMBRANDS));
                    }
                    itemBrandIdSet = itemBrandSet.stream().map(itemBrandDynObj -> itemBrandDynObj.getLong("fbasedataid_id")).collect(Collectors.toSet());
                }
                QFilter filter = new QFilter("id", "in", (Object)itemBrandIdSet.toArray());
                F7Utils.addF7Filter((BeforeF7SelectEvent)evt, (QFilter)filter);
            }
        }
    }

    public static Map<Object, DynamicObject> getShoppingCartList(Object ownerId, Object customerId, Object ispurchasing) {
        QFilter filter = new QFilter("owner.id", "=", ownerId);
        filter.and("customer.id", "=", customerId);
        filter.and("user.id", "=", UserUtil.getUserID());
        filter.and("ispurchasing", "=", ispurchasing);
        Map cartItemCollection = BusinessDataServiceHelper.loadFromCache((String)"mdr_shopping_cart", (String)"id,item.id,unit,unit.id,assistattr,assistattr.id,qty,assistqty,customer.id", (QFilter[])filter.toArray());
        return cartItemCollection;
    }
}

