/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dpa.formplugin.mobile.evaluate;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.property.ComboProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.ImageList;
import kd.bos.form.control.Vector;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.metadata.entity.commonfield.ComboField;
import kd.bos.metadata.entity.commonfield.ComboItem;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.ButtonAp;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.metadata.form.control.LabelAp;
import kd.bos.metadata.form.control.VectorAp;
import kd.bos.url.UrlService;
import kd.drp.mdr.common.StringUtils;
import kd.drp.mdr.formplugin.MdrFormMobPlugin;
import kd.drp.mdr.mobile.MobileControlUtils;
import net.sf.json.JSONArray;

public abstract class EvaluateMobTemplate
extends MdrFormMobPlugin
implements UploadListener {
    protected static final String TAG = "tag";
    protected static final String STAR = "star";
    protected static final String BUTTON = "button";
    protected static final String EVALTAGFLEX = "evaltagflex";
    protected static final String EVALBUTTONFLEX = "evalbuttonflex";
    protected static final String shixin = "kdfont kdfont-xingxing_shixin";
    protected static final String kongxin = "kdfont kdfont-xingxing_xianxing";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ImageList imageList = (ImageList)this.getControl("imagelistap");
        imageList.addUploadListener((UploadListener)this);
    }

    public void upload(UploadEvent evt) {
        Object[] urls = evt.getUrls();
        int[] indexes = this.getModel().batchCreateNewEntryRow("picturelist", urls.length);
        this.getView().sendFormAction(this.getView());
        for (int i = 0; i < urls.length; ++i) {
            Object url = urls[i];
            int index = indexes[i];
            this.setValue("picture", UrlService.getImageFullUrl((String)url.toString()), index);
        }
    }

    public void remove(UploadEvent evt) {
        Object[] index;
        for (Object object : index = evt.getIndexes()) {
            this.getModel().deleteEntryRow("picturelist", ((Integer)object).intValue());
        }
    }

    public void onGetControl(OnGetControlArgs e) {
        super.onGetControl(e);
        String key = e.getKey();
        if (key.startsWith(TAG)) {
            ComboEdit co = new ComboEdit();
            co.setKey(key);
            co.setView(this.getView());
            e.setControl((Control)co);
        }
        if (key.startsWith(STAR)) {
            Vector fe = new Vector();
            fe.setKey(key);
            fe.setView(this.getView());
            e.setControl((Control)fe);
            if (!this.isView()) {
                fe.addClickListener((ClickListener)this);
            }
        }
        if (key.startsWith(BUTTON)) {
            Button button = new Button();
            button.setKey(key);
            button.setView(this.getView());
            if (!this.isView()) {
                button.addClickListener((ClickListener)this);
            }
            e.setControl((Control)button);
        }
    }

    protected FlexPanelAp createEvalTagsAp(List<Map<String, Object>> tags) {
        FlexPanelAp evaltagflex = new FlexPanelAp();
        evaltagflex.setKey("headevaltagflex");
        if (tags == null || tags.isEmpty()) {
            evaltagflex.getItems().add(this.createNoContentLabel("notag", ResManager.loadKDString((String)"\u65e0\u8bc4\u4ef7\u9879", (String)"EvaluateMobTemplate_0", (String)"drp-dpa-formplugin", (Object[])new Object[0])));
            return evaltagflex;
        }
        JSONArray tagids = new JSONArray();
        for (int i = 0; i < tags.size(); ++i) {
            Map<String, Object> tag = tags.get(i);
            FlexPanelAp singleTagevaltagflex = new FlexPanelAp();
            singleTagevaltagflex.setWidth(new LocaleString("40%"));
            singleTagevaltagflex.setKey("singletag" + tag.get("id"));
            singleTagevaltagflex.setShrink(0);
            FieldAp field = this.createTagField(tag.get("id").toString(), (String)tag.get("name"));
            singleTagevaltagflex.getItems().add(field);
            tagids.add((Object)(TAG + tag.get("id")));
            LabelAp label = this.createTagLabel(tag.get("id").toString(), (String)tag.get("name"));
            singleTagevaltagflex.getItems().add(label);
            FlexPanelAp singleStarevaltagflex = new FlexPanelAp();
            singleStarevaltagflex.setKey("singlestar" + tag.get("id"));
            singleStarevaltagflex.setShrink(0);
            singleStarevaltagflex.setWidth(new LocaleString("60%"));
            for (int j = 1; j <= 5; ++j) {
                VectorAp v = this.createTagStar(tag.get("id").toString(), (String)tag.get("name"), j);
                singleStarevaltagflex.getItems().add(v);
            }
            FlexPanelAp singleevaltagflex = new FlexPanelAp();
            singleevaltagflex.setWidth(new LocaleString("50%"));
            singleevaltagflex.setKey("singlehead" + tag.get("id"));
            singleevaltagflex.setShrink(0);
            singleevaltagflex.setGrow(0);
            singleevaltagflex.setAlignItems("center");
            Style style = new Style();
            Margin margin = new Margin();
            margin.setTop("8px");
            style.setMargin(margin);
            singleevaltagflex.setStyle(style);
            singleevaltagflex.getItems().add(singleTagevaltagflex);
            singleevaltagflex.getItems().add(singleStarevaltagflex);
            evaltagflex.getItems().add(singleevaltagflex);
        }
        return evaltagflex;
    }

    protected FlexPanelAp createEvalButtonsAp(List<Map<String, Object>> labels) {
        FlexPanelAp evalbuttonApFlex = new FlexPanelAp();
        evalbuttonApFlex.setKey("headevalbuttonflex");
        if (labels == null || labels.isEmpty()) {
            evalbuttonApFlex.getItems().add(this.createNoContentLabel("nolabel", ResManager.loadKDString((String)"\u65e0\u8bc4\u4ef7\u6807\u7b7e", (String)"EvaluateMobTemplate_1", (String)"drp-dpa-formplugin", (Object[])new Object[0])));
            return evalbuttonApFlex;
        }
        JSONArray labelids = new JSONArray();
        for (int i = 0; i < labels.size(); ++i) {
            Map<String, Object> label = labels.get(i);
            ButtonAp buttonfield = this.createButtonField(label.get("id").toString(), (String)label.get("name"));
            evalbuttonApFlex.getItems().add(buttonfield);
            labelids.add((Object)("BUTTON" + label.get("id")));
        }
        return evalbuttonApFlex;
    }

    protected VectorAp createTagStar(String id, String name, int j) {
        VectorAp v = new VectorAp();
        v.setfontClass(shixin);
        v.setId(STAR + id + "_" + j);
        v.setKey(STAR + id + "_" + j);
        v.setClickable(true);
        v.setForeColor("#ffaa56");
        v.setFontSize(13);
        Style style = new Style();
        Margin margin = new Margin();
        margin.setBottom("0px");
        margin.setLeft("5px");
        style.setMargin(margin);
        v.setStyle(style);
        return v;
    }

    protected LabelAp createTagLabel(String id, String name) {
        LabelAp Label2 = new LabelAp();
        Label2.setName(new LocaleString(name));
        Label2.setId("label" + id);
        Label2.setKey("label" + id);
        Label2.setFontSize(13);
        Style style = new Style();
        Label2.setStyle(style);
        return Label2;
    }

    protected FieldAp createTagField(String id, String name) {
        FieldAp field = new FieldAp();
        ComboField co = new ComboField();
        co.setItems(this.buildComboItems());
        co.setKey(TAG + id);
        co.setDefValue("5");
        co.setMustInput(true);
        field.setId(TAG + id);
        field.setKey(TAG + id);
        field.setField((Field)co);
        field.setName(new LocaleString(name));
        field.setLabelDirection("h");
        field.setWidth(new LocaleString("150px"));
        field.setLabelWidth(new LocaleString("160px"));
        field.setComboShowStyle(0);
        field.setComboShowType(0);
        field.setFireUpdEvt(true);
        Style style = new Style();
        Margin margin = new Margin();
        margin.setBottom("0px");
        margin.setLeft("20px");
        style.setMargin(margin);
        field.setStyle(style);
        field.setVisible("");
        return field;
    }

    protected List<ComboItem> buildComboItems() {
        ArrayList<ComboItem> list = new ArrayList<ComboItem>(16);
        for (int i = 1; i <= 5; ++i) {
            ComboItem item = new ComboItem();
            String value = String.valueOf(i);
            item.setCaption(new LocaleString(value));
            item.setValue(value);
            list.add(item);
        }
        return list;
    }

    protected ButtonAp createButtonField(String id, String name) {
        ButtonAp button = new ButtonAp();
        button.setKey(BUTTON + id);
        button.setName(new LocaleString(name));
        button.setHeight(new LocaleString("28px"));
        button.setFontSize(11);
        button.setTextAlign("center");
        button.setForeColor("#666666");
        button.setRadius("100px");
        Style buttonstyle = new Style();
        Margin buttonmargin = new Margin();
        buttonmargin.setRight("12px");
        buttonmargin.setTop("15px");
        buttonstyle.setMargin(buttonmargin);
        button.setStyle(buttonstyle);
        return button;
    }

    protected LabelAp createNoContentLabel(String id, String text) {
        LabelAp label = new LabelAp();
        label.setId(id);
        label.setKey(id);
        label.setName(new LocaleString(text));
        label.setFontSize(15);
        label.setForeColor("#E5E5E5");
        return label;
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        super.getEntityType(e);
        MainEntityType oldMainType = e.getOriginalEntityType();
        MainEntityType newMainType = null;
        try {
            newMainType = (MainEntityType)oldMainType.clone();
        }
        catch (CloneNotSupportedException exp) {
            throw new KDException((Throwable)exp, new ErrorCode("LoadCustomControlMetasSample", exp.getMessage()), new Object[0]);
        }
        Map fieldmap = newMainType.getAllFields();
        JSONArray tagids = this.getEvalTags();
        for (int i = 0; i < tagids.size(); ++i) {
            String id = tagids.get(i).toString();
            if (fieldmap.get(id) != null) continue;
            ComboProp prop = new ComboProp();
            prop.setName(id);
            prop.setDbIgnore(true);
            prop.setDefaultValue((Object)"5");
            fieldmap.put(id, prop);
            newMainType.registerSimpleProperty((DynamicSimpleProperty)prop);
        }
        e.setNewEntityType(newMainType);
    }

    protected JSONArray getEvalTags() {
        String pageid = this.getView().getPageId();
        String labels = this.getPageCache().get(pageid + TAG);
        JSONArray array = new JSONArray();
        if (labels != null && !StringUtils.isEmpty((String)labels)) {
            array = JSONArray.fromObject((Object)labels);
        }
        return array;
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (key.startsWith(STAR)) {
            String[] split = key.split("_");
            String id = split[0].substring(4, split[0].length());
            Integer index = Integer.valueOf(split[1]);
            this.setValue(TAG + id, index);
            for (int i = 1; i <= 5; ++i) {
                String starKey = STAR + id + "_" + i;
                Vector v = (Vector)this.getControl(starKey);
                if (i <= index) {
                    v.setFontClass(shixin);
                    continue;
                }
                v.setFontClass(kongxin);
            }
        } else if (key.startsWith(BUTTON)) {
            String[] split = key.split(BUTTON);
            this.setLabelSelected(Long.valueOf(split[1]));
        }
    }

    protected void setLabelSelected(Object ... labelids) {
        HashSet<Object> labelIdList = new HashSet<Object>(Arrays.asList(labelids));
        DynamicObjectCollection evaluateLabelList = this.getModel().getEntryEntity("evaluatelabellist");
        DynamicObject evaluate = null;
        for (int i = 0; i < evaluateLabelList.size(); ++i) {
            evaluate = (DynamicObject)evaluateLabelList.get(i);
            Object labelId = evaluate.getDynamicObject("evaluatelabel").getPkValue();
            if (!labelIdList.contains(labelId)) continue;
            Boolean isSelected = evaluate.getBoolean("isselected");
            if (isSelected.booleanValue()) {
                MobileControlUtils.ControlSetFrontAndBackColor((Control)this.getControl(BUTTON + labelId), (String)"#666666", (String)"#ffffff");
            } else {
                MobileControlUtils.ControlSetFrontAndBackColor((Control)this.getControl(BUTTON + labelId), (String)"#ffffff", (String)"#F4984E");
            }
            this.setValue("isselected", isSelected == false, evaluate.getInt("seq") - 1);
        }
    }

    protected void fillEvaluateLabelList(List<Map<String, Object>> labels) {
        this.getModel().deleteEntryData("evaluatelabellist");
        if (labels.size() == 0) {
            return;
        }
        this.getModel().batchCreateNewEntryRow("evaluatelabellist", labels.size());
        Map<String, Object> label = null;
        for (int i = 0; i < labels.size(); ++i) {
            label = labels.get(i);
            this.setValue("evaluatelabel", label.get("id"), i);
            this.setValue("isselected", Boolean.FALSE, i);
        }
    }
}

