/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dpa.formplugin.mobile.evaluate;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.control.Image;
import kd.bos.form.control.ImageList;
import kd.bos.form.control.Label;
import kd.bos.form.control.Vector;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.CodeRuleServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.url.UrlService;
import kd.drp.dpa.formplugin.mobile.evaluate.EvaluateMobTemplate;
import kd.drp.mdr.common.StringUtils;
import kd.drp.mdr.common.util.EvaluateUtil;
import kd.drp.mdr.common.util.OperationUtil;
import kd.drp.mdr.common.util.UserUtil;
import kd.drp.mdr.mobile.MobileControlUtils;
import net.sf.json.JSONArray;

public class ItemEvaluate
extends EvaluateMobTemplate {
    private static final String SCORE = "score";
    private static final String EVALUATEGRADE = "evaluategrade";
    private static final String defaultUrl = "images/pc/emotion/No_picture.png";

    public void createNewData(BizDataEventArgs e) {
        super.createNewData(e);
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        List<Map<String, Object>> tags = this.getTagList(showParameter);
        JSONArray tagids = new JSONArray();
        for (int i = 0; i < tags.size(); ++i) {
            Map<String, Object> tag = tags.get(i);
            tagids.add((Object)("tag" + tag.get("id")));
        }
        String pageid = this.getView().getPageId();
        this.getPageCache().put(pageid + "tag", tagids.toString());
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        ItemEntryInfo entryinfo = new ItemEntryInfo(showParameter.getCustomParams());
        this.initItemInfo(entryinfo);
        this.fillEvaluateLabelList(this.getLabelList(showParameter));
        this.loadSavedItemEvaluate(entryinfo);
        if (this.isView()) {
            this.setUnEnable(new String[]{"evaltext"});
            this.setUnEnable(new String[]{"imagelistap"});
            this.setDisVisible(new String[]{"btnsubmit"});
        }
    }

    private void initItemInfo(ItemEntryInfo entryinfo) {
        Object url = entryinfo.getItempic();
        if (url == null || StringUtils.isEmpty((Object)url)) {
            url = defaultUrl;
        }
        this.setValue("image", url);
        Image pic = (Image)this.getControl("imageap");
        pic.setUrl(UrlService.getImageFullUrl((String)url.toString()));
        Object itemid = this.getParameter("itemid");
        if (itemid != null) {
            this.setValue("item", itemid);
            MobileControlUtils.LabelSetValue((Label)((Label)this.getControl("itemlabel")), (Object)((DynamicObject)this.getValue("item")).get("name"));
            Object attrid = this.getParameter("attrid");
            if (attrid != null) {
                this.setValue("attr", attrid);
            }
            Label attrlabel = (Label)this.getControl("attrlabel");
            if (attrid != null && !attrid.equals(0L)) {
                MobileControlUtils.LabelSetValue((Label)((Label)this.getControl("attrlabel")), (Object)((DynamicObject)this.getValue("attr")).get("name"));
            } else {
                MobileControlUtils.LabelSetValue((Label)attrlabel, (Object)"");
            }
            this.setVisible(new String[]{"iteminfoflex"});
            this.setDisVisible(new String[]{"combiteminfoflex"});
        } else {
            this.setValue("combitem", this.getParameter("combitem"));
            MobileControlUtils.LabelSetValue((Label)((Label)this.getControl("combitemlabel")), (Object)((DynamicObject)this.getValue("combitem")).get("name"));
            this.setDisVisible(new String[]{"iteminfoflex"});
            this.setVisible(new String[]{"combiteminfoflex"});
        }
    }

    private void loadSavedItemEvaluate(ItemEntryInfo entryinfo) {
        int i;
        Object evalid = this.getParameter("evalid");
        if (evalid == null || evalid.equals(0L)) {
            return;
        }
        DynamicObject itemEvaluate = BusinessDataServiceHelper.loadSingle((Object)evalid, (String)"mdr_item_evaluate");
        BigDecimal evaluategrade = itemEvaluate.getBigDecimal(EVALUATEGRADE);
        this.setValue(EVALUATEGRADE, evaluategrade);
        for (int i2 = 1; i2 <= 5; ++i2) {
            Vector v = (Vector)this.getControl("score_" + i2);
            if (i2 <= evaluategrade.intValue()) {
                v.setFontClass("kdfont kdfont-xingxing_shixin");
                continue;
            }
            v.setFontClass("kdfont kdfont-xingxing_xianxing");
        }
        this.setValue("evaltext", itemEvaluate.get("evaluatecontent"));
        ArrayList<Object> pics = new ArrayList<Object>(5);
        for (i = 1; i <= 5; ++i) {
            String pic = itemEvaluate.getString("picture" + i);
            if (pic == null || pic.trim().equals("")) continue;
            pics.add(pic);
        }
        if (pics.size() != 0) {
            this.getModel().batchCreateNewEntryRow("picturelist", pics.size());
            for (i = 0; i < pics.size(); ++i) {
                this.setValue("picture", pics.get(i), i);
            }
            ImageList imagelistap = (ImageList)this.getControl("imagelistap");
            imagelistap.setImageUrls(pics.toArray(new String[pics.size()]));
        }
        DynamicObjectCollection tagsentrys = itemEvaluate.getDynamicObjectCollection("entryentity");
        for (DynamicObject tagsentry : tagsentrys) {
            DynamicObject evaluateTag = tagsentry.getDynamicObject("evaluatetag");
            String tagId = evaluateTag.get("id").toString();
            BigDecimal score = tagsentry.getBigDecimal(SCORE);
            Control Tag = this.getControl("tag" + tagId);
            if (Tag == null) continue;
            this.setValue(Tag.getKey(), score.toString());
            for (int i3 = 1; i3 <= 5; ++i3) {
                String starKey = "star" + tagId + "_" + i3;
                Vector v = (Vector)this.getControl(starKey);
                if (i3 <= score.intValue()) {
                    v.setFontClass("kdfont kdfont-xingxing_shixin");
                    continue;
                }
                v.setFontClass("kdfont kdfont-xingxing_xianxing");
            }
        }
        DynamicObjectCollection evaluatelabels = itemEvaluate.getDynamicObjectCollection("evaluatelabels");
        for (DynamicObject evaluatelabel : evaluatelabels) {
            Object labelId = evaluatelabel.get("fbasedataid_id");
            this.setLabelSelected(labelId);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        if (key.startsWith("tag")) {
            this.refreshTotalScore();
        }
    }

    protected void refreshTotalScore() {
        JSONArray array = this.getEvalTags();
        int score = 5;
        if (array == null || array.isEmpty()) {
            this.setValue(EVALUATEGRADE, score);
        } else {
            BigDecimal totalscore = BigDecimal.ZERO;
            for (int i = 0; i < array.size(); ++i) {
                totalscore = totalscore.add(new BigDecimal(this.getValue(array.get(i).toString()).toString()));
            }
            score = totalscore.divide(new BigDecimal(array.size()), 0, RoundingMode.HALF_UP).intValue();
            this.setValue(EVALUATEGRADE, score);
        }
        for (int i = 1; i <= 5; ++i) {
            String starKey = "score_" + i;
            Vector v = (Vector)this.getControl(starKey);
            if (i <= score) {
                v.setFontClass("kdfont kdfont-xingxing_shixin");
                continue;
            }
            v.setFontClass("kdfont kdfont-xingxing_xianxing");
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String opKey;
        super.beforeDoOperation(args);
        switch (opKey = ((AbstractOperate)args.getSource()).getOperateKey()) {
            case "evaluate": {
                this.itemEvaluateSubmit();
                break;
            }
        }
    }

    private void itemEvaluateSubmit() {
        DynamicObject eval = null;
        Object evalid = this.getParameter("evalid");
        eval = evalid == null ? BusinessDataServiceHelper.newDynamicObject((String)"mdr_item_evaluate") : BusinessDataServiceHelper.loadSingle((Object)evalid, (String)"mdr_item_evaluate");
        ItemEntryInfo entryinfo = new ItemEntryInfo(this.getView().getFormShowParameter().getCustomParams());
        this.saveEvalTag(eval);
        this.saveEvalLabel(eval);
        eval.set("evaluatecontent", this.getValue("evaltext"));
        this.saveEvalPic(eval);
        eval.set("isanonymity", this.getValue("isanonymity"));
        eval.set("billstatus", (Object)Character.valueOf('B'));
        eval.set("creator", UserUtil.getUserID());
        eval.set("createtime", (Object)new Date());
        eval.set("evaluateshoworhide", (Object)Character.valueOf('1'));
        eval.set(EVALUATEGRADE, this.getValue(EVALUATEGRADE));
        eval.set("ordernumber", (Object)BusinessDataServiceHelper.loadSingle((Object)entryinfo.getOrderid(), (String)"mdr_order_f7", (String)"id"));
        eval.set("orderentryid", entryinfo.getEntryid());
        eval.set("item", entryinfo.getItemid());
        eval.set("unit", entryinfo.getUnitid());
        eval.set("assistattr", entryinfo.getAttrid());
        eval.set("qty", (Object)entryinfo.getQty());
        eval.set("price", (Object)entryinfo.getPrice());
        eval.set("amount", (Object)entryinfo.getAmount());
        String number = CodeRuleServiceHelper.getNumber((String)"mdr_item_evaluate", (DynamicObject)eval, null);
        if (number == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u5546\u54c1\u8bc4\u4ef7\u7684\u7f16\u7801\u89c4\u5219", (String)"ItemEvaluate_0", (String)"drp-dpa-formplugin", (Object[])new Object[0]));
        }
        eval.set("billno", (Object)number);
        OperationResult invokeOperation = OperationUtil.invokeOperation((DynamicObject)eval, (String)"submit");
        if (invokeOperation.isSuccess()) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u63d0\u4ea4\u6210\u529f", (String)"ItemEvaluate_1", (String)"drp-dpa-formplugin", (Object[])new Object[0]));
            this.getView().close();
        }
    }

    private void saveEvalTag(DynamicObject eval) {
        String pageid = this.getView().getPageId();
        JSONArray tagids = JSONArray.fromObject((Object)this.getPageCache().get(pageid + "tag"));
        if (tagids.isEmpty()) {
            return;
        }
        DynamicObjectCollection entryEntity = eval.getDynamicObjectCollection("entryentity");
        entryEntity.clear();
        for (int i = 0; i < tagids.size(); ++i) {
            DynamicObject entry = entryEntity.addNew();
            String number = tagids.get(i).toString();
            entry.set("evaluatetag", (Object)number.substring(3, number.length()));
            entry.set(SCORE, this.getValue(number));
        }
    }

    private void saveEvalLabel(DynamicObject eval) {
        DynamicObjectCollection evaluateLabelList = this.getModel().getEntryEntity("evaluatelabellist");
        DynamicObjectCollection evaluateLabels = eval.getDynamicObjectCollection("evaluatelabels");
        evaluateLabels.clear();
        DynamicObject evaluate = null;
        for (int i = 0; i < evaluateLabelList.size(); ++i) {
            evaluate = (DynamicObject)evaluateLabelList.get(i);
            Boolean isSelected = evaluate.getBoolean("isselected");
            if (!isSelected.booleanValue()) continue;
            DynamicObject label = evaluate.getDynamicObject("evaluatelabel");
            DynamicObject entry = evaluateLabels.addNew();
            entry.set("fbasedataid", (Object)label);
            entry.set("fbasedataid_id", label.get("id"));
        }
    }

    private void saveEvalPic(DynamicObject itemEvaluate) {
        DynamicObjectCollection picturelist = this.getModel().getEntryEntity("picturelist");
        int size = picturelist.size() < 5 ? picturelist.size() : 5;
        for (int i = 0; i < size; ++i) {
            itemEvaluate.set("picture" + (i + 1), ((DynamicObject)picturelist.get(i)).get("picture"));
        }
    }

    public void loadCustomControlMetas(LoadCustomControlMetasArgs e) {
        List<Map<String, Object>> labels;
        FlexPanelAp buttonap;
        super.loadCustomControlMetas(e);
        FormShowParameter showParameter = (FormShowParameter)e.getSource();
        List<Map<String, Object>> tags = this.getTagList(showParameter);
        FlexPanelAp tagap = this.createEvalTagsAp(tags);
        if (tags == null || tags.isEmpty()) {
            // empty if block
        }
        if (tagap != null) {
            HashMap<String, String> mapHead = new HashMap<String, String>();
            mapHead.put("id", "evaltagflex");
            mapHead.put("items", (String)tagap.createControl().get("items"));
            e.getItems().add(mapHead);
        }
        if ((buttonap = this.createEvalButtonsAp(labels = this.getLabelList(showParameter))) != null) {
            HashMap<String, String> mapHead = new HashMap<String, String>();
            mapHead.put("id", "evalbuttonflex");
            mapHead.put("items", (String)buttonap.createControl().get("items"));
            e.getItems().add(mapHead);
        }
    }

    private List<Map<String, Object>> getTagList(FormShowParameter param) {
        ArrayList<Map<String, Object>> list = null;
        if (this.isView(param)) {
            list = new ArrayList();
            Object evalid = param.getCustomParam("evalid");
            DynamicObjectCollection evalcol = QueryServiceHelper.query((String)"mdr_item_evaluate", (String)"entryentity.evaluatetag.id,entryentity.evaluatetag.number,entryentity.evaluatetag.name,entryentity.score", (QFilter[])new QFilter("id", "=", evalid).toArray());
            for (DynamicObject eval : evalcol) {
                HashMap<String, Object> tag = new HashMap<String, Object>();
                tag.put("id", eval.get("entryentity.evaluatetag.id"));
                tag.put("name", eval.get("entryentity.evaluatetag.name"));
                tag.put("number", eval.get("entryentity.evaluatetag.number"));
                tag.put(SCORE, eval.get("entryentity.score"));
                list.add(tag);
            }
        } else {
            list = EvaluateUtil.getEvaluateTagsByItemId((Object)param.getCustomParam("itemid"));
        }
        return list;
    }

    private List<Map<String, Object>> getLabelList(FormShowParameter param) {
        ArrayList<Map<String, Object>> list = null;
        if (this.isView(param)) {
            list = new ArrayList();
            Object evalid = param.getCustomParam("evalid");
            DynamicObject eval = BusinessDataServiceHelper.loadSingle((String)"mdr_item_evaluate", (String)"evaluatelabels", (QFilter[])new QFilter("id", "=", evalid).toArray());
            for (DynamicObject evallabel : eval.getDynamicObjectCollection("evaluatelabels")) {
                HashMap<String, Object> tag = new HashMap<String, Object>();
                tag.put("id", evallabel.getDynamicObject("fbasedataid").getPkValue());
                tag.put("name", evallabel.getDynamicObject("fbasedataid").getString("name"));
                tag.put("number", evallabel.getDynamicObject("fbasedataid").getString("number"));
                list.add(tag);
            }
        } else {
            list = EvaluateUtil.getEvaluateLabelsByItemId((Object)param.getCustomParam("itemid"));
        }
        return list;
    }

    public boolean isView() {
        FormShowParameter param = this.getView().getFormShowParameter();
        return this.isView(param);
    }

    private boolean isView(FormShowParameter param) {
        return param.getCustomParam("evalid") != null;
    }

    private static class ItemEntryInfo {
        private Object orderid;
        private Object entryid;
        private Object itemid;
        private Object unitid;
        private Object attrid;
        private BigDecimal qty;
        private BigDecimal price;
        private BigDecimal amount;
        private Object itempic;
        private Object combitem;

        private ItemEntryInfo(Map<String, Object> params) {
            this.orderid = params.get("orderid");
            this.entryid = params.get("entryid");
            this.itemid = params.get("itemid");
            this.unitid = params.get("unitid");
            this.attrid = params.get("attrid");
            this.qty = (BigDecimal)params.get("qty");
            this.price = (BigDecimal)params.get("price");
            this.amount = (BigDecimal)params.get("amount");
            this.itempic = params.get("itempic");
            this.combitem = params.get("combitem");
        }

        public Object getCombitem() {
            return this.combitem;
        }

        public Object getOrderid() {
            return this.orderid;
        }

        public Object getEntryid() {
            return this.entryid;
        }

        public Object getItemid() {
            return this.itemid;
        }

        public Object getUnitid() {
            return this.unitid;
        }

        public Object getAttrid() {
            return this.attrid;
        }

        public BigDecimal getQty() {
            return this.qty;
        }

        public BigDecimal getPrice() {
            return this.price;
        }

        public BigDecimal getAmount() {
            return this.amount;
        }

        public Object getItempic() {
            return this.itempic;
        }
    }
}

