/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dpa.formplugin.mobile.evaluate;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Control;
import kd.bos.form.control.ImageList;
import kd.bos.form.control.Label;
import kd.bos.form.control.Vector;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.CodeRuleServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.drp.dpa.formplugin.mobile.evaluate.EvaluateMobTemplate;
import kd.drp.mdr.common.util.EvaluateUtil;
import kd.drp.mdr.common.util.ObjectUtil;
import kd.drp.mdr.common.util.OperationUtil;
import kd.drp.mdr.common.util.UserUtil;
import kd.drp.mdr.mobile.model.FormModel;
import net.sf.json.JSONArray;

public class OrderEvaluate
extends EvaluateMobTemplate
implements UploadListener {
    private static final String EVALUATE = "evaluate";
    private static final String CHECK_EVALUATE = "checkevaluate";
    protected DynamicObject order = null;

    protected DynamicObject getOrder(FormShowParameter param) {
        if (this.order == null) {
            Object orderId = param.getCustomParam("orderid");
            if (orderId == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5f85\u8bc4\u8bba\u8ba2\u5355ID\u4e3a\u7a7a\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\uff01", (String)"OrderEvaluate_0", (String)"drp-dpa-formplugin", (Object[])new Object[0]));
            }
            this.order = BusinessDataServiceHelper.loadSingle((Object)orderId, (String)"bbc_saleorder", (String)"owner,billno,totalqty,totalorderamount,itementry.id,itementry.isevaluate,itementry.combitem,itementry.item,itementry.ispresent,itementry.assistattr,itementry.qty,itementry.unit,itementry.assistqty,itementry.assistunit,itementry.actualtaxprice,itementry.taxamount,itementry.entrywarehouse,itementry.entryremark");
            if (this.order == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8ba2\u5355\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\uff01", (String)"OrderEvaluate_1", (String)"drp-dpa-formplugin", (Object[])new Object[0]));
            }
        }
        return this.order;
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{CHECK_EVALUATE, EVALUATE});
    }

    public void createNewData(BizDataEventArgs e) {
        super.createNewData(e);
        DynamicObject order = this.getOrder(this.getView().getFormShowParameter());
        DynamicObject owner = order.getDynamicObject("owner");
        Label ownertag = (Label)this.getControl("owner");
        ownertag.setText(owner.getString("name"));
        Label billnotag = (Label)this.getControl("billno");
        billnotag.setText(order.getString("billno"));
        List<Map<String, Object>> tags = this.getTagList(this.getView().getFormShowParameter());
        if (tags == null || tags.isEmpty()) {
            return;
        }
        JSONArray tagids = new JSONArray();
        for (int i = 0; i < tags.size(); ++i) {
            Map<String, Object> tag = tags.get(i);
            tagids.add((Object)("tag" + tag.get("id")));
        }
        String pageid = this.getView().getPageId();
        this.getPageCache().put(pageid + "tag", tagids.toString());
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        DynamicObject order = this.getOrder(this.getView().getFormShowParameter());
        Object orderId = order.get("id");
        this.fillEvaluateLabelList(this.getLabelList(this.getView().getFormShowParameter()));
        this.loadSavedOrderEvaluate(orderId);
        this.initEntryList(order);
        if (this.isView()) {
            this.setUnEnable(new String[]{"evaluatecontent"});
            this.setUnEnable(new String[]{"imagelistap"});
            this.setDisVisible(new String[]{"bar_submit"});
        }
    }

    private void initEntryList(DynamicObject order) {
        DynamicObject[] eval;
        HashMap<String, Integer> evaluatedItems = new HashMap<String, Integer>();
        this.getModel().deleteEntryData("entryentity");
        DynamicObjectCollection itementry = order.getDynamicObjectCollection("itementry");
        this.getModel().batchCreateNewEntryRow("entryentity", itementry.size());
        for (int i = 0; i < itementry.size(); ++i) {
            DynamicObject entry = (DynamicObject)itementry.get(i);
            Boolean isEvaluated = entry.getBoolean("isevaluate");
            if (isEvaluated.booleanValue()) {
                evaluatedItems.put(entry.get("id").toString(), i);
            }
            this.handleItemEntry(entry, i);
        }
        if (evaluatedItems.size() == 0) {
            return;
        }
        QFilter filter = new QFilter("orderentryid", "in", evaluatedItems.keySet());
        for (DynamicObject itemEvaluate : eval = BusinessDataServiceHelper.load((String)"mdr_item_evaluate", (String)"orderentryid,id,evaluatecontent,createtime,picture1,picture2,picture3,picture4,picture5", (QFilter[])filter.toArray())) {
            Object id = itemEvaluate.get("orderentryid");
            this.handleEvaluatedEntry(itemEvaluate, (Integer)evaluatedItems.get(id));
        }
    }

    protected void handleItemEntry(DynamicObject entry, int i) {
        CardEntry cardEntry = (CardEntry)this.getControl("entryentity");
        Object entryId = entry.get("id");
        this.setValue("entryid", entryId, i);
        Boolean isEvaluated = entry.getBoolean("isevaluate");
        if (isEvaluated.booleanValue()) {
            cardEntry.setChildVisible(false, i, new String[]{"evaluatebutton"});
            cardEntry.setChildVisible(true, i, new String[]{"itemevaluatecontent"});
        } else {
            cardEntry.setChildVisible(true, i, new String[]{"evaluatebutton"});
            cardEntry.setChildVisible(false, i, new String[]{"itemevaluatecontent"});
        }
        this.setValue("isevaluate", isEvaluated, i);
        DynamicObject item = entry.getDynamicObject("item");
        DynamicObject combitem = entry.getDynamicObject("combitem");
        if (item != null) {
            this.setValue("item", item.getPkValue(), i);
            this.setValue("itempic", item.get("thumbnail"), i);
            cardEntry.setChildVisible(true, i, new String[]{"itemflex"});
            cardEntry.setChildVisible(false, i, new String[]{"combitemflex"});
        } else if (combitem != null) {
            this.setValue("combitem", combitem, i);
            cardEntry.setChildVisible(false, i, new String[]{"itemflex"});
            cardEntry.setChildVisible(true, i, new String[]{"combitemflex"});
        }
        this.setValue("ispresent", entry.get("ispresent"), i);
        Object assistattr = entry.get("assistattr");
        if (assistattr == null || assistattr.equals(0L)) {
            this.setDisVisible(new String[]{"assistattr"});
        } else {
            this.setValue("assistattr", entry.get("assistattr"), i);
        }
        this.setValue("qty", entry.get("qty"), i);
        this.setValue("unit", entry.get("unit"), i);
        this.setValue("assistqty", entry.get("assistqty"), i);
        this.setValue("assistunit", entry.get("assistunit"), i);
        this.setValue("actualtaxprice", entry.get("actualtaxprice"), i);
        this.setValue("taxamount", entry.get("taxamount"), i);
        this.setValue("entrywarehouse", entry.get("entrywarehouse"), i);
        this.setValue("entryremark", entry.get("entryremark"), i);
    }

    protected void handleEvaluatedEntry(DynamicObject evaluate, Integer index) {
        CardEntry cardEntry = (CardEntry)this.getControl("entryentity");
        this.setValue("itemevaluatecontenttext", evaluate.get("evaluatecontent"), index);
        this.setValue("itemevaluatecreatetime", evaluate.get("createtime"), index);
        for (int i = 1; i <= 5; ++i) {
            Object pic = evaluate.get("picture" + i);
            if (ObjectUtil.isEmpty((Object)pic)) {
                cardEntry.setChildVisible(false, index.intValue(), new String[]{"itemevaluatepic" + i});
                continue;
            }
            this.setValue("itemevaluatepic" + i, pic, index);
        }
    }

    private void loadSavedOrderEvaluate(Object orderId) {
        int i;
        Object orderEvalid = this.getParameter("orderevalid");
        if (orderEvalid == null || orderEvalid.equals(0L)) {
            JSONArray evalTags = this.getEvalTags();
            for (Object tags : evalTags) {
                String id = tags.toString();
                this.setValue(id, "5");
            }
            return;
        }
        DynamicObject orderEvaluate = BusinessDataServiceHelper.loadSingle((Object)orderEvalid, (String)"mdr_bill_evaluate_manage");
        this.setValue("evaluatecontent", orderEvaluate.get("evaluatecontent"));
        ArrayList<Object> pics = new ArrayList<Object>(5);
        for (i = 1; i <= 5; ++i) {
            String pic = orderEvaluate.getString("picture" + i);
            if (pic == null || pic.trim().equals("")) continue;
            pics.add(pic);
        }
        if (pics.size() != 0) {
            this.getModel().batchCreateNewEntryRow("picturelist", pics.size());
            for (i = 0; i < pics.size(); ++i) {
                this.setValue("picture", pics.get(i), i);
            }
            ImageList imagelistap = (ImageList)this.getControl("imagelistap");
            imagelistap.setImageUrls(pics.toArray(new String[pics.size()]));
        }
        DynamicObjectCollection evaluatelabels = orderEvaluate.getDynamicObjectCollection("evaluatelabels");
        for (DynamicObject evaluatelabel : evaluatelabels) {
            Object labelId = evaluatelabel.get("fbasedataid_id");
            this.setLabelSelected(labelId);
        }
        DynamicObjectCollection tagsentrys = orderEvaluate.getDynamicObjectCollection("entryentity");
        for (DynamicObject tagsentry : tagsentrys) {
            DynamicObject evaluateTag = tagsentry.getDynamicObject("evaluatenumber");
            String tagId = evaluateTag.get("id").toString();
            BigDecimal evaluategrade = tagsentry.getBigDecimal("evaluategrade");
            Control Tag = this.getControl("tag" + tagId);
            if (Tag == null) continue;
            this.setValue(Tag.getKey(), evaluategrade.toString());
            for (int i2 = 1; i2 <= 5; ++i2) {
                String starKey = "star" + tagId + "_" + i2;
                Vector v = (Vector)this.getControl(starKey);
                if (i2 <= evaluategrade.intValue()) {
                    v.setFontClass("kdfont kdfont-xingxing_shixin");
                    continue;
                }
                v.setFontClass("kdfont kdfont-xingxing_xianxing");
            }
        }
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        int index = 0;
        switch (key) {
            case "evaluate": {
                index = this.getModel().getEntryCurrentRowIndex("entryentity");
                this.toItemEvaluate(index, Boolean.FALSE);
            }
            case "checkevaluate": {
                index = this.getModel().getEntryCurrentRowIndex("entryentity");
                this.toItemEvaluate(index, Boolean.TRUE);
                break;
            }
        }
    }

    protected void toItemEvaluate(int i, Boolean isCheck) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("orderid", this.getParameter("orderid"));
        map.put("entryid", this.getValue("entryid", i));
        Object combItem = this.getValue("combitem", i);
        Object item = this.getValue("item", i);
        if (item != null) {
            map.put("itemid", ((DynamicObject)item).getPkValue());
            map.put("unitid", ((DynamicObject)this.getValue("unit", i)).getPkValue());
            Object attr = this.getValue("assistattr", i);
            if (attr != null) {
                map.put("attrid", ((DynamicObject)attr).getPkValue());
            }
        } else if (combItem != null) {
            map.put("combitem", combItem);
        }
        map.put("qty", this.getValue("qty", i));
        map.put("price", this.getValue("actualtaxprice", i));
        map.put("amount", this.getValue("taxamount", i));
        if (isCheck.booleanValue()) {
            map.put("evalid", EvaluateUtil.getItemEvaluateIDByEntryId((Object)this.getValue("entryid", i)));
        }
        map.put("itempic", this.getValue("itempic"));
        FormModel formModel = new FormModel("bbc_item_evaluate_edit_mo", ResManager.loadKDString((String)"\u5546\u54c1\u8bc4\u4ef7", (String)"OrderEvaluate_2", (String)"drp-dpa-formplugin", (Object[])new Object[0]), "5", true);
        formModel.setCustomParam(map);
        formModel.showPage((AbstractFormPlugin)this);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        switch (e.getActionId()) {
            case "bbc_item_evaluate_edit_mo": {
                this.evalutateCloseCallBack(e);
                break;
            }
        }
    }

    protected void evalutateCloseCallBack(ClosedCallBackEvent e) {
        DynamicObject order = this.getOrder(this.getView().getFormShowParameter());
        this.initEntryList(order);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        String opKey;
        super.beforeDoOperation(e);
        switch (opKey = ((AbstractOperate)e.getSource()).getOperateKey()) {
            case "evaluate": {
                this.orderEvaluateSubmit();
                break;
            }
        }
    }

    protected void orderEvaluateSubmit() {
        DynamicObject saleorder;
        Object orderId = this.getParameter("orderid");
        QFilter qFilter = new QFilter("billnumber", "=", orderId);
        DynamicObject orderEvaluate = BusinessDataServiceHelper.loadSingle((String)"mdr_bill_evaluate_manage", (String)"id,billnumber,amount,billstatus,goodqty,amount,billstatus,creator,createtime,evaluateshoworhide,evaluatecontent,evaluatetype,evaluatetype,replystatus,billno,evalutategrade,entryentity.evaluatenumber,entryentity.evaluategrade,picture1,picture2,picture3,picture4,picture5,evaluatelabels.fbasedataid,evaluatelabels.fbasedataid_id", (QFilter[])qFilter.toArray());
        if (orderEvaluate == null) {
            orderEvaluate = BusinessDataServiceHelper.newDynamicObject((String)"mdr_bill_evaluate_manage");
        }
        if ((saleorder = this.order) == null) {
            saleorder = BusinessDataServiceHelper.loadSingle((Object)orderId, (String)"mdr_order_f7", (String)"id,number,totalqty,totalorderamount");
        }
        orderEvaluate.set("billnumber", (Object)saleorder);
        orderEvaluate.set("goodqty", saleorder.get("totalqty"));
        orderEvaluate.set("amount", saleorder.get("totalorderamount"));
        orderEvaluate.set("billstatus", (Object)"A");
        orderEvaluate.set("creator", UserUtil.getUserID());
        orderEvaluate.set("createtime", (Object)new Date());
        orderEvaluate.set("evaluateshoworhide", (Object)"1");
        Object evaluatecontent = this.getValue("evaluatecontent");
        orderEvaluate.set("evaluatecontent", evaluatecontent);
        orderEvaluate.set("evaluatetype", (Object)"0");
        orderEvaluate.set("replystatus", (Object)"0");
        this.saveEvalLabel(orderEvaluate);
        this.saveEvalTag(orderEvaluate);
        this.saveEvalPic(orderEvaluate);
        String number = CodeRuleServiceHelper.getNumber((String)"mdr_bill_evaluate_manage", (DynamicObject)orderEvaluate, null);
        orderEvaluate.set("billno", (Object)number);
        OperationResult invokeOperation = OperationUtil.invokeOperation((DynamicObject)orderEvaluate, (String)"submit");
        if (invokeOperation.isSuccess()) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u63d0\u4ea4\u6210\u529f", (String)"OrderEvaluate_3", (String)"drp-dpa-formplugin", (Object[])new Object[0]));
            this.getView().close();
        }
    }

    private void saveEvalTag(DynamicObject eval) {
        BigDecimal evalutategrade = BigDecimal.ZERO;
        JSONArray tagids = this.getEvalTags();
        if (tagids.isEmpty()) {
            eval.set("evalutategrade", (Object)5);
            return;
        }
        DynamicObjectCollection entryEntity = eval.getDynamicObjectCollection("entryentity");
        entryEntity.clear();
        for (int i = 0; i < tagids.size(); ++i) {
            DynamicObject entry = entryEntity.addNew();
            String number = tagids.get(i).toString();
            entry.set("evaluatenumber", (Object)this.getEvaluateContentById(number.substring(3, number.length())));
            BigDecimal grade = new BigDecimal((String)this.getValue(number));
            evalutategrade = evalutategrade.add(grade);
            entry.set("evaluategrade", (Object)grade);
        }
        if (evalutategrade.compareTo(BigDecimal.ZERO) != 0) {
            evalutategrade = evalutategrade.divide(new BigDecimal(tagids.size()), 0, RoundingMode.HALF_UP);
        }
        eval.set("evalutategrade", (Object)evalutategrade);
    }

    private void saveEvalLabel(DynamicObject eval) {
        DynamicObjectCollection evaluateLabelList = this.getModel().getEntryEntity("evaluatelabellist");
        DynamicObjectCollection evaluateLabels = eval.getDynamicObjectCollection("evaluatelabels");
        evaluateLabels.clear();
        DynamicObject evaluate = null;
        for (int i = 0; i < evaluateLabelList.size(); ++i) {
            evaluate = (DynamicObject)evaluateLabelList.get(i);
            Boolean isSelected = evaluate.getBoolean("isselected");
            if (!isSelected.booleanValue()) continue;
            DynamicObject label = evaluate.getDynamicObject("evaluatelabel");
            DynamicObject entry = evaluateLabels.addNew();
            entry.set("fbasedataid", (Object)label);
            entry.set("fbasedataid_id", label.get("id"));
        }
    }

    private void saveEvalPic(DynamicObject orderEvaluate) {
        DynamicObjectCollection picturelist = this.getModel().getEntryEntity("picturelist");
        int size = picturelist.size() < 5 ? picturelist.size() : 5;
        for (int i = 0; i < size; ++i) {
            orderEvaluate.set("picture" + (i + 1), ((DynamicObject)picturelist.get(i)).get("picture"));
        }
    }

    public void loadCustomControlMetas(LoadCustomControlMetasArgs e) {
        List<Map<String, Object>> labels;
        FlexPanelAp buttonap;
        super.loadCustomControlMetas(e);
        FormShowParameter showParameter = (FormShowParameter)e.getSource();
        List<Map<String, Object>> tags = this.getTagList(showParameter);
        FlexPanelAp tagap = this.createEvalTagsAp(tags);
        if (tagap != null) {
            HashMap<String, String> mapHead = new HashMap<String, String>();
            mapHead.put("id", "evaltagflex");
            mapHead.put("items", (String)tagap.createControl().get("items"));
            e.getItems().add(mapHead);
        }
        if ((buttonap = this.createEvalButtonsAp(labels = this.getLabelList(showParameter))) != null) {
            HashMap<String, String> mapHead = new HashMap<String, String>();
            mapHead.put("id", "evalbuttonflex");
            mapHead.put("items", (String)buttonap.createControl().get("items"));
            e.getItems().add(mapHead);
        }
    }

    protected DynamicObject getEvaluateContentById(Object id) {
        return BusinessDataServiceHelper.loadSingle((Object)id, (String)"mdr_evaluate_content");
    }

    private List<Map<String, Object>> getTagList(FormShowParameter param) {
        ArrayList<Map<String, Object>> list = null;
        if (this.isView(param)) {
            list = new ArrayList();
            Object evalid = param.getCustomParam("orderevalid");
            DynamicObjectCollection evalcol = QueryServiceHelper.query((String)"mdr_bill_evaluate_manage", (String)"entryentity.evaluatenumber.id,entryentity.evaluatenumber.number,entryentity.evaluatenumber.name,entryentity.evaluategrade", (QFilter[])new QFilter("id", "=", evalid).toArray());
            for (DynamicObject eval : evalcol) {
                HashMap<String, Object> tag = new HashMap<String, Object>();
                tag.put("id", eval.get("entryentity.evaluatenumber.id"));
                tag.put("name", eval.get("entryentity.evaluatenumber.name"));
                tag.put("number", eval.get("entryentity.evaluatenumber.number"));
                tag.put("score", eval.get("entryentity.evaluategrade"));
                list.add(tag);
            }
        } else {
            Object ownerId = param.getCustomParam("ownerid");
            list = EvaluateUtil.getEvaluateTagsByOwnerId((Object)ownerId);
        }
        return list;
    }

    private List<Map<String, Object>> getLabelList(FormShowParameter param) {
        ArrayList<Map<String, Object>> list = null;
        if (this.isView(param)) {
            list = new ArrayList();
            Object evalid = param.getCustomParam("orderevalid");
            DynamicObject eval = BusinessDataServiceHelper.loadSingle((String)"mdr_bill_evaluate_manage", (String)"evaluatelabels", (QFilter[])new QFilter("id", "=", evalid).toArray());
            for (DynamicObject evallabel : eval.getDynamicObjectCollection("evaluatelabels")) {
                HashMap<String, Object> tag = new HashMap<String, Object>();
                tag.put("id", evallabel.getDynamicObject("fbasedataid").getPkValue());
                tag.put("name", evallabel.getDynamicObject("fbasedataid").getString("name"));
                tag.put("number", evallabel.getDynamicObject("fbasedataid").getString("number"));
                list.add(tag);
            }
        } else {
            Object ownerId = param.getCustomParam("ownerid");
            list = EvaluateUtil.getEvaluateLabelsByOwnerId((Object)ownerId);
        }
        return list;
    }

    public boolean isView() {
        FormShowParameter param = this.getView().getFormShowParameter();
        return this.isView(param);
    }

    private boolean isView(FormShowParameter param) {
        return param.getCustomParam("orderevalid") != null;
    }
}

