/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dpa.formplugin.money;

import java.util.Date;
import java.util.EventObject;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.MobileListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.drp.mdr.common.f7.F7Utils;
import kd.drp.mdr.common.util.CustomerSalerUtil;
import kd.drp.mdr.common.util.SaleOrderUtil;
import kd.drp.mdr.common.util.UserUtil;
import kd.drp.mdr.formplugin.MdrFormPlugin;

public class MoneyDebtEditPlugin
extends MdrFormPlugin
implements BeforeF7SelectListener {
    private static final String F7_SALER = "saler";
    private static final String F7_ORDER_NUMBER = "ordernumber";
    private static final String DEBT_MONEY = "debtmoney";
    private static final String APPLYTIME = "applytime";
    private static final String UNPAID_AMOUNT = "unpaidamount";
    private static final String SUPPLY = "supply";
    private static final String F7_OWNER = "owner";
    private static String[] status = new String[]{"C", "D", "E", "G", "H", "J"};

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addF7Listener(this, new String[]{F7_SALER, F7_ORDER_NUMBER});
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key;
        switch (key = e.getProperty().getName()) {
            case "saler": {
                FormShowParameter f = e.getFormShowParameter();
                if (f instanceof MobileListShowParameter) {
                    f.setFormId("bos_moblistmodalf7");
                    F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)this.f7salerfilter());
                    break;
                }
                f.setFormId("bos_listf7");
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)this.f7salerfilter());
                break;
            }
            case "ordernumber": {
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)this.f7ordernumberfilter());
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        IDataModel dataModel = this.getModel();
        switch (propertyName) {
            case "ordernumber": {
                DynamicObject ordernumber = (DynamicObject)dataModel.getValue(F7_ORDER_NUMBER);
                this.orderNumber(ordernumber);
                break;
            }
            case "saler": {
                DynamicObject saler = (DynamicObject)dataModel.getValue(F7_SALER);
                this.salerChanged(saler);
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter fsp = this.getView().getFormShowParameter();
        Date now = new Date();
        this.getModel().setValue("user", UserUtil.getUserID());
        this.getModel().setValue(F7_OWNER, UserUtil.getDefaultOwnerID());
        this.getModel().setValue(APPLYTIME, (Object)now);
        Long orderid = (Long)fsp.getCustomParam("orderid");
        if (orderid == null) {
            return;
        }
        DynamicObject entry = BusinessDataServiceHelper.loadSingle((Object)orderid, (String)"mdr_saleorder");
        if (entry != null) {
            this.getModel().setValue(DEBT_MONEY, entry.get("amounttobepaid"));
            this.getModel().setValue(F7_ORDER_NUMBER, entry.getPkValue());
            this.getModel().setValue(F7_SALER, entry.get(F7_SALER));
            this.getModel().setValue(UNPAID_AMOUNT, entry.get("amounttobepaid"));
            if (entry.get(F7_OWNER) != null) {
                this.getModel().setValue(SUPPLY, entry.get(F7_OWNER));
            }
            if (entry.get("customer") != null) {
                this.getModel().setValue(F7_OWNER, entry.get("customer"));
            }
        }
    }

    public QFilter f7salerfilter() {
        Set userid = CustomerSalerUtil.queryCustomerSalerPK((Object)this.getF7PKValue(F7_OWNER));
        QFilter qFilter1 = new QFilter("id", "in", (Object)userid);
        return qFilter1;
    }

    public QFilter f7ordernumberfilter() {
        Object owenrid = UserUtil.getDefaultOwnerID();
        boolean isSaler = UserUtil.isSaler((Object)owenrid);
        boolean isBuyer = UserUtil.isBuyer((Object)owenrid);
        QFilter qFilter1 = null;
        long[] dabtorderid = this.orderid();
        QFilter qFilter = new QFilter("id", "not in", (Object)dabtorderid);
        if (isBuyer) {
            qFilter.and("customer", "=", owenrid);
        }
        if (isSaler) {
            qFilter.and(F7_OWNER, "=", owenrid);
        }
        qFilter.and("orderstatus", "in", (Object)status);
        QFilter[] Filter = new QFilter[]{qFilter};
        DynamicObject[] saleorderInfos = BusinessDataServiceHelper.load((String)"mdr_saleorder", (String)"id,creator,orderstatus", (QFilter[])Filter);
        if (saleorderInfos != null) {
            long[] orderid = new long[saleorderInfos.length];
            int i = 0;
            for (DynamicObject salerInfo : saleorderInfos) {
                orderid[i] = (Long)salerInfo.get("id");
                ++i;
            }
            qFilter1 = new QFilter("id", "in", (Object)orderid);
        }
        return qFilter1;
    }

    public long[] orderid() {
        QFilter filter = new QFilter(F7_ORDER_NUMBER, ">", (Object)0);
        QFilter[] qfilter = new QFilter[]{filter};
        DynamicObject[] debtInfos = BusinessDataServiceHelper.load((String)"mdr_money_debt", (String)"id,ordernumber", (QFilter[])qfilter);
        long[] orderid = null;
        if (debtInfos != null) {
            orderid = new long[debtInfos.length];
            int i = 0;
            for (DynamicObject debtInfo : debtInfos) {
                orderid[i] = (Long)debtInfo.getDynamicObject(F7_ORDER_NUMBER).getPkValue();
                ++i;
            }
        }
        return orderid;
    }

    public void orderNumber(DynamicObject ordernumber) {
        if (ordernumber != null) {
            if (SaleOrderUtil.isMoneyDebt((DynamicObject)ordernumber)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u8ba2\u5355\u5df2\u7533\u8bf7\u6b20\u6b3e,\u4e0d\u80fd\u518d\u7533\u8bf7\uff01", (String)"MoneyDebtEditPlugin_0", (String)"drp-dpa-formplugin", (Object[])new Object[0]));
            }
            DynamicObject saleorderInfo = BusinessDataServiceHelper.loadSingle((Object)ordernumber.get(0), (String)"mdr_saleorder");
            if (saleorderInfo != null) {
                this.getModel().setValue(DEBT_MONEY, saleorderInfo.get("amounttobepaid"));
                this.getModel().setValue(F7_SALER, saleorderInfo.get(F7_SALER));
                this.getModel().setValue(F7_OWNER, saleorderInfo.getDynamicObject("customer").getPkValue());
                this.getView().setEnable(Boolean.FALSE, new String[]{F7_SALER});
            }
        }
    }

    public void salerChanged(DynamicObject saler) {
        if (saler != null) {
            QFilter qFilter = new QFilter("user", "in", saler.get(0));
            qFilter.and("enable", "=", (Object)1);
            QFilter[] Filter = new QFilter[]{qFilter};
            DynamicObject[] salerInfos = BusinessDataServiceHelper.load((String)"mdr_cust_saler_relation", (String)"customer,user,enable,isdefault", (QFilter[])Filter);
            if (salerInfos != null) {
                Boolean isdefault = Boolean.FALSE;
                for (DynamicObject salerInfo : salerInfos) {
                    if (!salerInfo.get("isdefault").equals(1)) continue;
                    this.getModel().setValue(SUPPLY, salerInfo.get("customer"));
                    isdefault = Boolean.TRUE;
                }
                if (!isdefault.booleanValue()) {
                    this.getModel().setValue(SUPPLY, salerInfos[0].get("customer"));
                }
            }
        }
    }
}

