/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dpa.formplugin.money;

import java.util.EventObject;
import java.util.List;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.drp.mdr.common.util.CustomerAdminUtil;
import kd.drp.mdr.common.util.CustomerUtil;
import kd.drp.mdr.common.util.UserUtil;
import kd.drp.mdr.formplugin.MdrListPlugin;

public class MoneyDebtListPlugin
extends MdrListPlugin {
    public static final String BTN_MODIFY = "btnmodify";
    public static final String BTN_DOWN = "btndown";
    public static final String DOUBLE_CLICK = "doubleclick";
    public static final String PUSH_MOBLIE = "pushmobile";
    public static final String BTN_MOBLIE_MODIFY = "btnmbmodify";

    public void initialize() {
        super.initialize();
        this.addItemClickListeners(new String[]{BTN_DOWN});
        this.addClickListeners(new String[]{PUSH_MOBLIE, BTN_MOBLIE_MODIFY});
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        super.beforeShowBill(e);
        String source = e.getSource().toString();
        String[] sourceArray = source.split("-");
        if (sourceArray.length > 0 && sourceArray[0].equals("MobileListView")) {
            return;
        }
        BillShowParameter parameter = e.getParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        Object owenrid = UserUtil.getDefaultOwnerID();
        Object userid = UserUtil.getUserID();
        boolean isAdmin = CustomerAdminUtil.isAdmin((Object)owenrid);
        List qFilters = e.getQFilters();
        QFilter buyFilter = new QFilter("user.id", "=", userid);
        QFilter saleFilter = new QFilter("saler.id", "=", userid);
        buyFilter.or(saleFilter);
        if (isAdmin) {
            QFilter adminFilter = new QFilter("supply", "in", (Object)CustomerUtil.getAuthSubsIds((Object)owenrid));
            buyFilter.or(adminFilter);
        }
        qFilters.add(buyFilter);
        e.setQFilters(qFilters);
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String opString = evt.getItemKey();
        if (BTN_MODIFY.equalsIgnoreCase(opString)) {
            this.modifyCheck(opString);
        } else if (BTN_DOWN.equalsIgnoreCase(evt.getItemKey())) {
            this.down(this.getSelectedRows(), opString);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (PUSH_MOBLIE.equals(key)) {
            this.downMobile(this.getSelectedRows());
        } else if (BTN_MOBLIE_MODIFY.equals(key)) {
            this.modifyCheck(BTN_MODIFY);
        }
    }

    public void listRowDoubleClick(ListRowClickEvent evt) {
        String opString = DOUBLE_CLICK;
        ListSelectedRowCollection selectRows = ((IListView)this.getView()).getSelectedRows();
        if (!this.debtstatus(selectRows, opString)) {
            evt.setCancel(true);
            this.getView().invokeOperation("view");
        }
    }

    private boolean debtstatus(ListSelectedRowCollection selectRows, String opString) {
        boolean status = true;
        QFilter qFilter = new QFilter("id", "=", (Object)selectRows.getPrimaryKeyValues());
        QFilter[] filters = new QFilter[]{qFilter};
        DynamicObject[] entrys = BusinessDataServiceHelper.load((String)"mdr_money_debt", (String)"status", (QFilter[])filters);
        if (entrys != null) {
            for (DynamicObject entry : entrys) {
                if (BTN_MODIFY.equalsIgnoreCase(opString) && !entry.get("status").equals("0") || DOUBLE_CLICK.equalsIgnoreCase(opString) && !entry.get("status").equals("0")) {
                    status = false;
                    continue;
                }
                if (!BTN_DOWN.equalsIgnoreCase(opString) || entry.get("status").equals("2")) continue;
                status = false;
            }
        }
        return status;
    }

    private boolean isdown(Object[] debtid) {
        boolean isdown = true;
        QFilter qFilter = new QFilter("debtid", "=", (Object)debtid);
        QFilter[] filters = new QFilter[]{qFilter};
        DynamicObject[] entrys = BusinessDataServiceHelper.load((String)"mdr_money_ensure", (String)"id,debtid", (QFilter[])filters);
        if (entrys.length > 0) {
            isdown = false;
        }
        return isdown;
    }

    private void down(ListSelectedRowCollection selectRows, String opString) {
        Object[] objs = selectRows.getPrimaryKeyValues();
        this.downCheck(selectRows, opString);
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("mdr_money_ensure");
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.getOpenStyle().setTargetKey(BTN_DOWN);
        parameter.setCustomParam("id", (Object)objs);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "downrefresh");
        parameter.setCloseCallBack(closeCallBack);
        parameter.setParentFormId("mdr_money_debt");
        this.getView().showForm(parameter);
    }

    public void downMobile(ListSelectedRowCollection selectRows) {
        Object[] objs = selectRows.getPrimaryKeyValues();
        this.downCheck(selectRows, BTN_DOWN);
        MobileFormShowParameter parameter = new MobileFormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Floating);
        parameter.setFormId("mdr_money_ensure_mob");
        parameter.setStatus(OperationStatus.ADDNEW);
        parameter.setCustomParam("id", (Object)objs);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "downrefresh");
        parameter.setCloseCallBack(closeCallBack);
        this.getView().showForm((FormShowParameter)parameter);
    }

    protected final ListSelectedRowCollection getSelectedRows() {
        BillList billList = (BillList)this.getControl("billlistap");
        return billList.getSelectedRows();
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if ("downrefresh".equalsIgnoreCase(closedCallBackEvent.getActionId())) {
            this.getView().invokeOperation("refresh");
        }
    }

    private void modifyCheck(String opString) {
        if (this.getSelectedRows().size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u7f16\u8f91\u7684\u6570\u636e", (String)"MoneyDebtListPlugin_0", (String)"drp-dpa-formplugin", (Object[])new Object[0]));
        }
        if (!this.debtstatus(this.getSelectedRows(), opString)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u53ea\u6709\u4fdd\u5b58\u72b6\u6001\u4e0b\u7684\u624d\u80fd\u7f16\u8f91\uff01", (String)"MoneyDebtListPlugin_1", (String)"drp-dpa-formplugin", (Object[])new Object[0]));
        }
    }

    private void downCheck(ListSelectedRowCollection selectRows, String opString) {
        Object[] objs = selectRows.getPrimaryKeyValues();
        if (selectRows.size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u4e0b\u63a8\u7684\u6570\u636e\uff01", (String)"MoneyDebtListPlugin_2", (String)"drp-dpa-formplugin", (Object[])new Object[0]));
        }
        if (!this.debtstatus(selectRows, opString)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u53ea\u6709\u5df2\u5ba1\u6838\u72b6\u6001\u7684\u624d\u80fd\u4e0b\u63a8\uff01", (String)"MoneyDebtListPlugin_3", (String)"drp-dpa-formplugin", (Object[])new Object[0]));
        }
        if (!this.isdown(objs)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u6570\u636e\u5df2\u7ecf\u4e0b\u63a8\uff01", (String)"MoneyDebtListPlugin_4", (String)"drp-dpa-formplugin", (Object[])new Object[0]));
        }
    }
}

