/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dpa.formplugin.money;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.drp.mdr.common.util.CustomerUtil;
import kd.drp.mdr.common.util.UserUtil;
import kd.drp.mdr.formplugin.MdrListPlugin;

public class MyBalanceListPlugin
extends MdrListPlugin {
    protected static final String CHECKDETAIL = "checkdetail";
    protected static final List<String> RECEVTYPE_TO_VIEW = Arrays.asList("0", "1", "4", "5");

    public void setFilter(SetFilterEvent e) {
        List qFilters = e.getQFilters();
        QFilter f = new QFilter("customer", "in", (Object)UserUtil.getOwnerIDs());
        qFilters.add(f);
        e.setQFilters(qFilters);
    }

    public void filterContainerInit(FilterContainerInitArgs e) {
        String ownerFilterkey = "owner.name";
        List columns = e.getFilterContainerInitEvent().getCommonFilterColumns();
        for (FilterColumn column : columns) {
            if (!ownerFilterkey.equals(column.getFieldName())) continue;
            CommonFilterColumn col = (CommonFilterColumn)column;
            List<ComboItem> comboItems = this.getCustomerComboItem();
            col.setComboItems(comboItems);
            break;
        }
        this.initOwnerFilterComboItem(e, "customer.name");
    }

    protected List<ComboItem> getCustomerComboItem() {
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>();
        HashSet ownerIDs = new HashSet();
        for (Object customerid : this.getOwnerIDs()) {
            ownerIDs.addAll(CustomerUtil.getAuthOwnerIDs(customerid));
        }
        QFilter f = new QFilter("id", "in", ownerIDs);
        DynamicObjectCollection owners = QueryServiceHelper.query((String)"mdr_customer", (String)"id,name", (QFilter[])f.toArray());
        ComboItem item = null;
        for (DynamicObject owner : owners) {
            item = new ComboItem();
            item.setId(String.valueOf(owner.get("id")));
            item.setValue(String.valueOf(owner.get("id")));
            item.setCaption(new LocaleString(owner.getString("name")));
            comboItems.add(item);
        }
        return comboItems;
    }

    public void billListHyperLinkClick(HyperLinkClickArgs evt) {
        evt.setCancel(true);
    }

    public void listRowDoubleClick(ListRowClickEvent evt) {
        evt.setCancel(true);
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        String key;
        switch (key = e.getOperateKey()) {
            case "checkdetail": {
                Object id = this.getSelectedOrderIds(true)[0];
                this.showReceivingBillView(id);
            }
        }
    }

    protected void showReceivingBillView(Object balancePK) {
        DynamicObject balanceInfo = BusinessDataServiceHelper.loadSingle((Object)balancePK, (String)"mdr_balance");
        Object ownerPK = balanceInfo.getDynamicObject("owner").get("id");
        Object customerPK = balanceInfo.getDynamicObject("customer").get("id");
        this.showReceivingBillView(ownerPK, customerPK);
    }

    protected void showReceivingBillView(Object ownerPK, Object customerPK) {
        ListShowParameter parameter = new ListShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.setFormId("bos_list");
        parameter.setBillFormId("mdr_money_receiveinh");
        QFilter f = new QFilter("owner", "=", ownerPK);
        f.and("contactscustomer", "=", customerPK);
        f.and("receivingtype", "in", RECEVTYPE_TO_VIEW);
        ListFilterParameter listFilterParameter = new ListFilterParameter();
        listFilterParameter.setFilter(f);
        parameter.setListFilterParameter(listFilterParameter);
        this.getView().showForm((FormShowParameter)parameter);
    }

    protected Object[] getSelectedOrderIds(boolean isSingle) {
        Object[] ids = this.getSelectIds();
        int size = ids.length;
        if (size == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u8bb0\u5f55\uff01", (String)"MyBalanceListPlugin_0", (String)"drp-dpa-formplugin", (Object[])new Object[0]));
        }
        if (isSingle && size > 1) {
            throw new KDBizException(ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u62e9\u4e00\u6761\u8bb0\u5f55\uff01", (String)"MyBalanceListPlugin_1", (String)"drp-dpa-formplugin", (Object[])new Object[0]));
        }
        return ids;
    }
}

