/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dpa.formplugin.money;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.drp.mdr.common.util.CustomerUtil;
import kd.drp.mdr.common.util.UserUtil;
import kd.drp.mdr.formplugin.MdrListPlugin;

public class PayListPlugin
extends MdrListPlugin {
    public void setFilter(SetFilterEvent e) {
        List qFilters = e.getQFilters();
        QFilter f = new QFilter("contactscustomer.id", "in", (Object)UserUtil.getOwnerIDs());
        qFilters.add(f);
        e.setQFilters(qFilters);
    }

    public void filterContainerInit(FilterContainerInitArgs e) {
        String ownerFilterkey = "owner.name";
        List columns = e.getFilterContainerInitEvent().getCommonFilterColumns();
        for (FilterColumn column : columns) {
            if (!ownerFilterkey.equals(column.getFieldName())) continue;
            CommonFilterColumn col = (CommonFilterColumn)column;
            List<ComboItem> comboItems = this.getCustomerComboItem();
            col.setComboItems(comboItems);
            break;
        }
        this.initOwnerFilterComboItem(e, "contactscustomer.name");
    }

    protected List<ComboItem> getCustomerComboItem() {
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>();
        HashSet ownerIDs = new HashSet();
        for (Object customerid : this.getOwnerIDs()) {
            ownerIDs.addAll(CustomerUtil.getAuthOwnerIDs(customerid));
        }
        QFilter f = new QFilter("id", "in", ownerIDs);
        DynamicObjectCollection owners = QueryServiceHelper.query((String)"mdr_customer", (String)"id,name", (QFilter[])f.toArray());
        ComboItem item = null;
        for (DynamicObject owner : owners) {
            item = new ComboItem();
            item.setId(String.valueOf(owner.get("id")));
            item.setValue(String.valueOf(owner.get("id")));
            item.setCaption(new LocaleString(owner.getString("name")));
            comboItems.add(item);
        }
        return comboItems;
    }

    public void billListHyperLinkClick(HyperLinkClickArgs evt) {
        evt.setCancel(true);
    }

    public void listRowDoubleClick(ListRowClickEvent evt) {
        evt.setCancel(true);
    }
}

